/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.Stage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StageMarshaller {
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentId").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTCERTIFICATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientCertificateId").isBinary(false).build();
    private static final MarshallingInfo<String> STAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageName").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CACHECLUSTERENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheClusterEnabled").isBinary(false).build();
    private static final MarshallingInfo<String> CACHECLUSTERSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheClusterSize").isBinary(false).build();
    private static final MarshallingInfo<String> CACHECLUSTERSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheClusterStatus").isBinary(false).build();
    private static final MarshallingInfo<Map> METHODSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("methodSettings").isBinary(false).build();
    private static final MarshallingInfo<Map> VARIABLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("variables").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTATIONVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("documentationVersion").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACCESSLOGSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessLogSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CANARYSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("canarySettings").isBinary(false).build();
    private static final MarshallingInfo<Boolean> TRACINGENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tracingEnabled").isBinary(false).build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedDate").isBinary(false).build();
    private static final StageMarshaller INSTANCE = new StageMarshaller();

    private StageMarshaller() {
    }

    public static StageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Stage stage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)stage, (String)"stage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stage.deploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)stage.clientCertificateId(), CLIENTCERTIFICATEID_BINDING);
            protocolMarshaller.marshall((Object)stage.stageName(), STAGENAME_BINDING);
            protocolMarshaller.marshall((Object)stage.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)stage.cacheClusterEnabled(), CACHECLUSTERENABLED_BINDING);
            protocolMarshaller.marshall((Object)stage.cacheClusterSize(), CACHECLUSTERSIZE_BINDING);
            protocolMarshaller.marshall((Object)stage.cacheClusterStatusAsString(), CACHECLUSTERSTATUS_BINDING);
            protocolMarshaller.marshall(stage.methodSettings(), METHODSETTINGS_BINDING);
            protocolMarshaller.marshall(stage.variables(), VARIABLES_BINDING);
            protocolMarshaller.marshall((Object)stage.documentationVersion(), DOCUMENTATIONVERSION_BINDING);
            protocolMarshaller.marshall((Object)stage.accessLogSettings(), ACCESSLOGSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)stage.canarySettings(), CANARYSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)stage.tracingEnabled(), TRACINGENABLED_BINDING);
            protocolMarshaller.marshall(stage.tags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)stage.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)stage.lastUpdatedDate(), LASTUPDATEDDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

