/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TestInvokeMethodRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("resource_id").isBinary(false).build();
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("http_method").isBinary(false).build();
    private static final MarshallingInfo<String> PATHWITHQUERYSTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pathWithQueryString").isBinary(false).build();
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("body").isBinary(false).build();
    private static final MarshallingInfo<Map> HEADERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("headers").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTCERTIFICATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientCertificateId").isBinary(false).build();
    private static final MarshallingInfo<Map> STAGEVARIABLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageVariables").isBinary(false).build();
    private static final TestInvokeMethodRequestModelMarshaller INSTANCE = new TestInvokeMethodRequestModelMarshaller();

    private TestInvokeMethodRequestModelMarshaller() {
    }

    public static TestInvokeMethodRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TestInvokeMethodRequest testInvokeMethodRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)testInvokeMethodRequest), (String)"testInvokeMethodRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)testInvokeMethodRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)testInvokeMethodRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)testInvokeMethodRequest.httpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall((Object)testInvokeMethodRequest.pathWithQueryString(), PATHWITHQUERYSTRING_BINDING);
            protocolMarshaller.marshall((Object)testInvokeMethodRequest.body(), BODY_BINDING);
            protocolMarshaller.marshall(testInvokeMethodRequest.headers(), HEADERS_BINDING);
            protocolMarshaller.marshall((Object)testInvokeMethodRequest.clientCertificateId(), CLIENTCERTIFICATEID_BINDING);
            protocolMarshaller.marshall(testInvokeMethodRequest.stageVariables(), STAGEVARIABLES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

