/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.ThrottleSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ThrottleSettingsMarshaller {
    private static final MarshallingInfo<Integer> BURSTLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("burstLimit").isBinary(false).build();
    private static final MarshallingInfo<Double> RATELIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rateLimit").isBinary(false).build();
    private static final ThrottleSettingsMarshaller INSTANCE = new ThrottleSettingsMarshaller();

    private ThrottleSettingsMarshaller() {
    }

    public static ThrottleSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ThrottleSettings throttleSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)throttleSettings, (String)"throttleSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)throttleSettings.burstLimit(), BURSTLIMIT_BINDING);
            protocolMarshaller.marshall((Object)throttleSettings.rateLimit(), RATELIMIT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

