/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to create an <a>ApiKey</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApiKeyRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<CreateApiKeyRequest.Builder, CreateApiKeyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApiKeyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApiKeyRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateApiKeyRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<Boolean> GENERATE_DISTINCT_ID_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateApiKeyRequest::generateDistinctId)).setter(setter(Builder::generateDistinctId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generateDistinctId").build())
            .build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApiKeyRequest::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<List<StageKey>> STAGE_KEYS_FIELD = SdkField
            .<List<StageKey>> builder(MarshallingType.LIST)
            .getter(getter(CreateApiKeyRequest::stageKeys))
            .setter(setter(Builder::stageKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StageKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(StageKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CUSTOMER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApiKeyRequest::customerId)).setter(setter(Builder::customerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            ENABLED_FIELD, GENERATE_DISTINCT_ID_FIELD, VALUE_FIELD, STAGE_KEYS_FIELD, CUSTOMER_ID_FIELD));

    private final String name;

    private final String description;

    private final Boolean enabled;

    private final Boolean generateDistinctId;

    private final String value;

    private final List<StageKey> stageKeys;

    private final String customerId;

    private CreateApiKeyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.enabled = builder.enabled;
        this.generateDistinctId = builder.generateDistinctId;
        this.value = builder.value;
        this.stageKeys = builder.stageKeys;
        this.customerId = builder.customerId;
    }

    /**
     * <p>
     * The name of the <a>ApiKey</a>.
     * </p>
     * 
     * @return The name of the <a>ApiKey</a>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the <a>ApiKey</a>.
     * </p>
     * 
     * @return The description of the <a>ApiKey</a>.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether the <a>ApiKey</a> can be used by callers.
     * </p>
     * 
     * @return Specifies whether the <a>ApiKey</a> can be used by callers.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Specifies whether (<code>true</code>) or not (<code>false</code>) the key identifier is distinct from the created
     * API key value.
     * </p>
     * 
     * @return Specifies whether (<code>true</code>) or not (<code>false</code>) the key identifier is distinct from the
     *         created API key value.
     */
    public Boolean generateDistinctId() {
        return generateDistinctId;
    }

    /**
     * <p>
     * Specifies a value of the API key.
     * </p>
     * 
     * @return Specifies a value of the API key.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
     */
    public List<StageKey> stageKeys() {
        return stageKeys;
    }

    /**
     * <p>
     * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
     * </p>
     * 
     * @return An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
     */
    public String customerId() {
        return customerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(generateDistinctId());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(stageKeys());
        hashCode = 31 * hashCode + Objects.hashCode(customerId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiKeyRequest)) {
            return false;
        }
        CreateApiKeyRequest other = (CreateApiKeyRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(generateDistinctId(), other.generateDistinctId())
                && Objects.equals(value(), other.value()) && Objects.equals(stageKeys(), other.stageKeys())
                && Objects.equals(customerId(), other.customerId());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateApiKeyRequest").add("Name", name()).add("Description", description())
                .add("Enabled", enabled()).add("GenerateDistinctId", generateDistinctId()).add("Value", value())
                .add("StageKeys", stageKeys()).add("CustomerId", customerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "generateDistinctId":
            return Optional.ofNullable(clazz.cast(generateDistinctId()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "stageKeys":
            return Optional.ofNullable(clazz.cast(stageKeys()));
        case "customerId":
            return Optional.ofNullable(clazz.cast(customerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApiKeyRequest, T> g) {
        return obj -> g.apply((CreateApiKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateApiKeyRequest> {
        /**
         * <p>
         * The name of the <a>ApiKey</a>.
         * </p>
         * 
         * @param name
         *        The name of the <a>ApiKey</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the <a>ApiKey</a>.
         * </p>
         * 
         * @param description
         *        The description of the <a>ApiKey</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether the <a>ApiKey</a> can be used by callers.
         * </p>
         * 
         * @param enabled
         *        Specifies whether the <a>ApiKey</a> can be used by callers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Specifies whether (<code>true</code>) or not (<code>false</code>) the key identifier is distinct from the
         * created API key value.
         * </p>
         * 
         * @param generateDistinctId
         *        Specifies whether (<code>true</code>) or not (<code>false</code>) the key identifier is distinct from
         *        the created API key value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generateDistinctId(Boolean generateDistinctId);

        /**
         * <p>
         * Specifies a value of the API key.
         * </p>
         * 
         * @param value
         *        Specifies a value of the API key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
         * </p>
         * 
         * @param stageKeys
         *        DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageKeys(Collection<StageKey> stageKeys);

        /**
         * <p>
         * DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
         * </p>
         * 
         * @param stageKeys
         *        DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageKeys(StageKey... stageKeys);

        /**
         * <p>
         * DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StageKey>.Builder} avoiding the need to
         * create one manually via {@link List<StageKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StageKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #stageKeys(List<StageKey>)}.
         * 
         * @param stageKeys
         *        a consumer that will call methods on {@link List<StageKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stageKeys(List<StageKey>)
         */
        Builder stageKeys(Consumer<StageKey.Builder>... stageKeys);

        /**
         * <p>
         * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
         * </p>
         * 
         * @param customerId
         *        An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerId(String customerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private Boolean enabled;

        private Boolean generateDistinctId;

        private String value;

        private List<StageKey> stageKeys = DefaultSdkAutoConstructList.getInstance();

        private String customerId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiKeyRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            enabled(model.enabled);
            generateDistinctId(model.generateDistinctId);
            value(model.value);
            stageKeys(model.stageKeys);
            customerId(model.customerId);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getGenerateDistinctId() {
            return generateDistinctId;
        }

        @Override
        public final Builder generateDistinctId(Boolean generateDistinctId) {
            this.generateDistinctId = generateDistinctId;
            return this;
        }

        public final void setGenerateDistinctId(Boolean generateDistinctId) {
            this.generateDistinctId = generateDistinctId;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Collection<StageKey.Builder> getStageKeys() {
            return stageKeys != null ? stageKeys.stream().map(StageKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stageKeys(Collection<StageKey> stageKeys) {
            this.stageKeys = ListOfStageKeysCopier.copy(stageKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageKeys(StageKey... stageKeys) {
            stageKeys(Arrays.asList(stageKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageKeys(Consumer<StageKey.Builder>... stageKeys) {
            stageKeys(Stream.of(stageKeys).map(c -> StageKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStageKeys(Collection<StageKey.BuilderImpl> stageKeys) {
            this.stageKeys = ListOfStageKeysCopier.copyFromBuilder(stageKeys);
        }

        public final String getCustomerId() {
            return customerId;
        }

        @Override
        public final Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public final void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApiKeyRequest build() {
            return new CreateApiKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
