/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a collection of <a>DomainName</a> resources.
 * </p>
 * <div class="seeAlso"> <a
 * href="http://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Use Client-Side
 * Certificate</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDomainNamesResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetDomainNamesResponse.Builder, GetDomainNamesResponse> {
    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDomainNamesResponse::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<List<DomainName>> ITEMS_FIELD = SdkField
            .<List<DomainName>> builder(MarshallingType.LIST)
            .getter(getter(GetDomainNamesResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("item").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainName> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainName::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITION_FIELD, ITEMS_FIELD));

    private final String position;

    private final List<DomainName> items;

    private GetDomainNamesResponse(BuilderImpl builder) {
        super(builder);
        this.position = builder.position;
        this.items = builder.items;
    }

    /**
     * Returns the value of the Position property for this object.
     * 
     * @return The value of the Position property for this object.
     */
    public String position() {
        return position;
    }

    /**
     * <p>
     * The current page of elements from this collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The current page of elements from this collection.
     */
    public List<DomainName> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainNamesResponse)) {
            return false;
        }
        GetDomainNamesResponse other = (GetDomainNamesResponse) obj;
        return Objects.equals(position(), other.position()) && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDomainNamesResponse").add("Position", position()).add("Items", items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainNamesResponse, T> g) {
        return obj -> g.apply((GetDomainNamesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDomainNamesResponse> {
        /**
         * Sets the value of the Position property for this object.
         *
         * @param position
         *        The new value for the Position property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * 
         * @param items
         *        The current page of elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<DomainName> items);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * 
         * @param items
         *        The current page of elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(DomainName... items);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DomainName>.Builder} avoiding the need to
         * create one manually via {@link List<DomainName>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainName>.Builder#build()} is called immediately and its
         * result is passed to {@link #items(List<DomainName>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<DomainName>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<DomainName>)
         */
        Builder items(Consumer<DomainName.Builder>... items);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String position;

        private List<DomainName> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainNamesResponse model) {
            super(model);
            position(model.position);
            items(model.items);
        }

        public final String getPosition() {
            return position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Collection<DomainName.Builder> getItems() {
            return items != null ? items.stream().map(DomainName::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<DomainName> items) {
            this.items = ListOfDomainNameCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(DomainName... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<DomainName.Builder>... items) {
            items(Stream.of(items).map(c -> DomainName.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<DomainName.BuilderImpl> items) {
            this.items = ListOfDomainNameCopier.copyFromBuilder(items);
        }

        @Override
        public GetDomainNamesResponse build() {
            return new GetDomainNamesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
