/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains references to your APIs and links that guide you in how to interact with your collection. A collection
 * offers a paginated view of your APIs.
 * </p>
 * <div class="seeAlso"> <a
 * href="http://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRestApisResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetRestApisResponse.Builder, GetRestApisResponse> {
    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRestApisResponse::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<List<RestApi>> ITEMS_FIELD = SdkField
            .<List<RestApi>> builder(MarshallingType.LIST)
            .getter(getter(GetRestApisResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("item").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RestApi> builder(MarshallingType.SDK_POJO)
                                            .constructor(RestApi::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITION_FIELD, ITEMS_FIELD));

    private final String position;

    private final List<RestApi> items;

    private GetRestApisResponse(BuilderImpl builder) {
        super(builder);
        this.position = builder.position;
        this.items = builder.items;
    }

    /**
     * Returns the value of the Position property for this object.
     * 
     * @return The value of the Position property for this object.
     */
    public String position() {
        return position;
    }

    /**
     * <p>
     * The current page of elements from this collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The current page of elements from this collection.
     */
    public List<RestApi> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRestApisResponse)) {
            return false;
        }
        GetRestApisResponse other = (GetRestApisResponse) obj;
        return Objects.equals(position(), other.position()) && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        return ToString.builder("GetRestApisResponse").add("Position", position()).add("Items", items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRestApisResponse, T> g) {
        return obj -> g.apply((GetRestApisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRestApisResponse> {
        /**
         * Sets the value of the Position property for this object.
         *
         * @param position
         *        The new value for the Position property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * 
         * @param items
         *        The current page of elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<RestApi> items);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * 
         * @param items
         *        The current page of elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(RestApi... items);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RestApi>.Builder} avoiding the need to
         * create one manually via {@link List<RestApi>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RestApi>.Builder#build()} is called immediately and its
         * result is passed to {@link #items(List<RestApi>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<RestApi>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<RestApi>)
         */
        Builder items(Consumer<RestApi.Builder>... items);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String position;

        private List<RestApi> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRestApisResponse model) {
            super(model);
            position(model.position);
            items(model.items);
        }

        public final String getPosition() {
            return position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Collection<RestApi.Builder> getItems() {
            return items != null ? items.stream().map(RestApi::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<RestApi> items) {
            this.items = ListOfRestApiCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(RestApi... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<RestApi.Builder>... items) {
            items(Stream.of(items).map(c -> RestApi.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<RestApi.BuilderImpl> items) {
            this.items = ListOfRestApiCopier.copyFromBuilder(items);
        }

        @Override
        public GetRestApisResponse build() {
            return new GetRestApisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
