/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a unique identifier for a version of a deployed <a>RestApi</a> that is callable by users.
 * </p>
 * <div class="seeAlso"> <a
 * href="http://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html">Deploy an API</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Stage implements SdkPojo, Serializable, ToCopyableBuilder<Stage.Builder, Stage> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stage::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stage::clientCertificateId)).setter(setter(Builder::clientCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateId").build())
            .build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stage::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stage::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> CACHE_CLUSTER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Stage::cacheClusterEnabled)).setter(setter(Builder::cacheClusterEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheClusterEnabled").build())
            .build();

    private static final SdkField<String> CACHE_CLUSTER_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stage::cacheClusterSize)).setter(setter(Builder::cacheClusterSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheClusterSize").build()).build();

    private static final SdkField<String> CACHE_CLUSTER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stage::cacheClusterStatusAsString)).setter(setter(Builder::cacheClusterStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheClusterStatus").build())
            .build();

    private static final SdkField<Map<String, MethodSetting>> METHOD_SETTINGS_FIELD = SdkField
            .<Map<String, MethodSetting>> builder(MarshallingType.MAP)
            .getter(getter(Stage::methodSettings))
            .setter(setter(Builder::methodSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("methodSettings").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MethodSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(MethodSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Stage::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DOCUMENTATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stage::documentationVersion)).setter(setter(Builder::documentationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentationVersion").build())
            .build();

    private static final SdkField<AccessLogSettings> ACCESS_LOG_SETTINGS_FIELD = SdkField
            .<AccessLogSettings> builder(MarshallingType.SDK_POJO).getter(getter(Stage::accessLogSettings))
            .setter(setter(Builder::accessLogSettings)).constructor(AccessLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLogSettings").build()).build();

    private static final SdkField<CanarySettings> CANARY_SETTINGS_FIELD = SdkField
            .<CanarySettings> builder(MarshallingType.SDK_POJO).getter(getter(Stage::canarySettings))
            .setter(setter(Builder::canarySettings)).constructor(CanarySettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canarySettings").build()).build();

    private static final SdkField<Boolean> TRACING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Stage::tracingEnabled)).setter(setter(Builder::tracingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingEnabled").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Stage::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Stage::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Stage::lastUpdatedDate)).setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD,
            CLIENT_CERTIFICATE_ID_FIELD, STAGE_NAME_FIELD, DESCRIPTION_FIELD, CACHE_CLUSTER_ENABLED_FIELD,
            CACHE_CLUSTER_SIZE_FIELD, CACHE_CLUSTER_STATUS_FIELD, METHOD_SETTINGS_FIELD, VARIABLES_FIELD,
            DOCUMENTATION_VERSION_FIELD, ACCESS_LOG_SETTINGS_FIELD, CANARY_SETTINGS_FIELD, TRACING_ENABLED_FIELD, TAGS_FIELD,
            CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deploymentId;

    private final String clientCertificateId;

    private final String stageName;

    private final String description;

    private final Boolean cacheClusterEnabled;

    private final String cacheClusterSize;

    private final String cacheClusterStatus;

    private final Map<String, MethodSetting> methodSettings;

    private final Map<String, String> variables;

    private final String documentationVersion;

    private final AccessLogSettings accessLogSettings;

    private final CanarySettings canarySettings;

    private final Boolean tracingEnabled;

    private final Map<String, String> tags;

    private final Instant createdDate;

    private final Instant lastUpdatedDate;

    private Stage(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.clientCertificateId = builder.clientCertificateId;
        this.stageName = builder.stageName;
        this.description = builder.description;
        this.cacheClusterEnabled = builder.cacheClusterEnabled;
        this.cacheClusterSize = builder.cacheClusterSize;
        this.cacheClusterStatus = builder.cacheClusterStatus;
        this.methodSettings = builder.methodSettings;
        this.variables = builder.variables;
        this.documentationVersion = builder.documentationVersion;
        this.accessLogSettings = builder.accessLogSettings;
        this.canarySettings = builder.canarySettings;
        this.tracingEnabled = builder.tracingEnabled;
        this.tags = builder.tags;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
    }

    /**
     * <p>
     * The identifier of the <a>Deployment</a> that the stage points to.
     * </p>
     * 
     * @return The identifier of the <a>Deployment</a> that the stage points to.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The identifier of a client certificate for an API stage.
     * </p>
     * 
     * @return The identifier of a client certificate for an API stage.
     */
    public String clientCertificateId() {
        return clientCertificateId;
    }

    /**
     * <p>
     * The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API
     * Gateway.
     * </p>
     * 
     * @return The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API
     *         Gateway.
     */
    public String stageName() {
        return stageName;
    }

    /**
     * <p>
     * The stage's description.
     * </p>
     * 
     * @return The stage's description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether a cache cluster is enabled for the stage.
     * </p>
     * 
     * @return Specifies whether a cache cluster is enabled for the stage.
     */
    public Boolean cacheClusterEnabled() {
        return cacheClusterEnabled;
    }

    /**
     * <p>
     * The size of the cache cluster for the stage, if enabled.
     * </p>
     * 
     * @return The size of the cache cluster for the stage, if enabled.
     */
    public String cacheClusterSize() {
        return cacheClusterSize;
    }

    /**
     * <p>
     * The status of the cache cluster for the stage, if enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cacheClusterStatus} will return {@link CacheClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #cacheClusterStatusAsString}.
     * </p>
     * 
     * @return The status of the cache cluster for the stage, if enabled.
     * @see CacheClusterStatus
     */
    public CacheClusterStatus cacheClusterStatus() {
        return CacheClusterStatus.fromValue(cacheClusterStatus);
    }

    /**
     * <p>
     * The status of the cache cluster for the stage, if enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cacheClusterStatus} will return {@link CacheClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #cacheClusterStatusAsString}.
     * </p>
     * 
     * @return The status of the cache cluster for the stage, if enabled.
     * @see CacheClusterStatus
     */
    public String cacheClusterStatusAsString() {
        return cacheClusterStatus;
    }

    /**
     * <p>
     * A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as
     * <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code>
     * for an individual method override, or <code>/\*&#47;\*</code> for overriding all methods in the stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as
     *         <code>/{method_setting_key</code> below) are method paths defined as
     *         <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*&#47;\*</code>
     *         for overriding all methods in the stage.
     */
    public Map<String, MethodSetting> methodSettings() {
        return methodSettings;
    }

    /**
     * <p>
     * A map that defines the stage variables for a <a>Stage</a> resource. Variable names can have alphanumeric and
     * underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map that defines the stage variables for a <a>Stage</a> resource. Variable names can have alphanumeric
     *         and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.
     */
    public Map<String, String> variables() {
        return variables;
    }

    /**
     * <p>
     * The version of the associated API documentation.
     * </p>
     * 
     * @return The version of the associated API documentation.
     */
    public String documentationVersion() {
        return documentationVersion;
    }

    /**
     * <p>
     * Settings for logging access in this stage.
     * </p>
     * 
     * @return Settings for logging access in this stage.
     */
    public AccessLogSettings accessLogSettings() {
        return accessLogSettings;
    }

    /**
     * <p>
     * Settings for the canary deployment in this stage.
     * </p>
     * 
     * @return Settings for the canary deployment in this stage.
     */
    public CanarySettings canarySettings() {
        return canarySettings;
    }

    /**
     * <p>
     * Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.
     * </p>
     * 
     * @return Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.
     */
    public Boolean tracingEnabled() {
        return tracingEnabled;
    }

    /**
     * <p>
     * The collection of tags. Each tag element is associated with a given resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The collection of tags. Each tag element is associated with a given resource.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The timestamp when the stage was created.
     * </p>
     * 
     * @return The timestamp when the stage was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The timestamp when the stage last updated.
     * </p>
     * 
     * @return The timestamp when the stage last updated.
     */
    public Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterSize());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(methodSettings());
        hashCode = 31 * hashCode + Objects.hashCode(variables());
        hashCode = 31 * hashCode + Objects.hashCode(documentationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(accessLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(canarySettings());
        hashCode = 31 * hashCode + Objects.hashCode(tracingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stage)) {
            return false;
        }
        Stage other = (Stage) obj;
        return Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(clientCertificateId(), other.clientCertificateId())
                && Objects.equals(stageName(), other.stageName()) && Objects.equals(description(), other.description())
                && Objects.equals(cacheClusterEnabled(), other.cacheClusterEnabled())
                && Objects.equals(cacheClusterSize(), other.cacheClusterSize())
                && Objects.equals(cacheClusterStatusAsString(), other.cacheClusterStatusAsString())
                && Objects.equals(methodSettings(), other.methodSettings()) && Objects.equals(variables(), other.variables())
                && Objects.equals(documentationVersion(), other.documentationVersion())
                && Objects.equals(accessLogSettings(), other.accessLogSettings())
                && Objects.equals(canarySettings(), other.canarySettings())
                && Objects.equals(tracingEnabled(), other.tracingEnabled()) && Objects.equals(tags(), other.tags())
                && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate());
    }

    @Override
    public String toString() {
        return ToString.builder("Stage").add("DeploymentId", deploymentId()).add("ClientCertificateId", clientCertificateId())
                .add("StageName", stageName()).add("Description", description())
                .add("CacheClusterEnabled", cacheClusterEnabled()).add("CacheClusterSize", cacheClusterSize())
                .add("CacheClusterStatus", cacheClusterStatusAsString()).add("MethodSettings", methodSettings())
                .add("Variables", variables()).add("DocumentationVersion", documentationVersion())
                .add("AccessLogSettings", accessLogSettings()).add("CanarySettings", canarySettings())
                .add("TracingEnabled", tracingEnabled()).add("Tags", tags()).add("CreatedDate", createdDate())
                .add("LastUpdatedDate", lastUpdatedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "clientCertificateId":
            return Optional.ofNullable(clazz.cast(clientCertificateId()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "cacheClusterEnabled":
            return Optional.ofNullable(clazz.cast(cacheClusterEnabled()));
        case "cacheClusterSize":
            return Optional.ofNullable(clazz.cast(cacheClusterSize()));
        case "cacheClusterStatus":
            return Optional.ofNullable(clazz.cast(cacheClusterStatusAsString()));
        case "methodSettings":
            return Optional.ofNullable(clazz.cast(methodSettings()));
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        case "documentationVersion":
            return Optional.ofNullable(clazz.cast(documentationVersion()));
        case "accessLogSettings":
            return Optional.ofNullable(clazz.cast(accessLogSettings()));
        case "canarySettings":
            return Optional.ofNullable(clazz.cast(canarySettings()));
        case "tracingEnabled":
            return Optional.ofNullable(clazz.cast(tracingEnabled()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Stage, T> g) {
        return obj -> g.apply((Stage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Stage> {
        /**
         * <p>
         * The identifier of the <a>Deployment</a> that the stage points to.
         * </p>
         * 
         * @param deploymentId
         *        The identifier of the <a>Deployment</a> that the stage points to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The identifier of a client certificate for an API stage.
         * </p>
         * 
         * @param clientCertificateId
         *        The identifier of a client certificate for an API stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateId(String clientCertificateId);

        /**
         * <p>
         * The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API
         * Gateway.
         * </p>
         * 
         * @param stageName
         *        The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to
         *        API Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * The stage's description.
         * </p>
         * 
         * @param description
         *        The stage's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether a cache cluster is enabled for the stage.
         * </p>
         * 
         * @param cacheClusterEnabled
         *        Specifies whether a cache cluster is enabled for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterEnabled(Boolean cacheClusterEnabled);

        /**
         * <p>
         * The size of the cache cluster for the stage, if enabled.
         * </p>
         * 
         * @param cacheClusterSize
         *        The size of the cache cluster for the stage, if enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterSize(String cacheClusterSize);

        /**
         * <p>
         * The status of the cache cluster for the stage, if enabled.
         * </p>
         * 
         * @param cacheClusterStatus
         *        The status of the cache cluster for the stage, if enabled.
         * @see CacheClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CacheClusterStatus
         */
        Builder cacheClusterStatus(String cacheClusterStatus);

        /**
         * <p>
         * The status of the cache cluster for the stage, if enabled.
         * </p>
         * 
         * @param cacheClusterStatus
         *        The status of the cache cluster for the stage, if enabled.
         * @see CacheClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CacheClusterStatus
         */
        Builder cacheClusterStatus(CacheClusterStatus cacheClusterStatus);

        /**
         * <p>
         * A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as
         * <code>/{method_setting_key</code> below) are method paths defined as
         * <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\*&#47;\*</code> for
         * overriding all methods in the stage.
         * </p>
         * 
         * @param methodSettings
         *        A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as
         *        <code>/{method_setting_key</code> below) are method paths defined as
         *        <code>{resource_path}/{http_method}</code> for an individual method override, or
         *        <code>/\*&#47;\*</code> for overriding all methods in the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder methodSettings(Map<String, MethodSetting> methodSettings);

        /**
         * <p>
         * A map that defines the stage variables for a <a>Stage</a> resource. Variable names can have alphanumeric and
         * underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.
         * </p>
         * 
         * @param variables
         *        A map that defines the stage variables for a <a>Stage</a> resource. Variable names can have
         *        alphanumeric and underscore characters, and the values must match
         *        <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Map<String, String> variables);

        /**
         * <p>
         * The version of the associated API documentation.
         * </p>
         * 
         * @param documentationVersion
         *        The version of the associated API documentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationVersion(String documentationVersion);

        /**
         * <p>
         * Settings for logging access in this stage.
         * </p>
         * 
         * @param accessLogSettings
         *        Settings for logging access in this stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLogSettings(AccessLogSettings accessLogSettings);

        /**
         * <p>
         * Settings for logging access in this stage.
         * </p>
         * This is a convenience that creates an instance of the {@link AccessLogSettings.Builder} avoiding the need to
         * create one manually via {@link AccessLogSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessLogSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #accessLogSettings(AccessLogSettings)}.
         * 
         * @param accessLogSettings
         *        a consumer that will call methods on {@link AccessLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLogSettings(AccessLogSettings)
         */
        default Builder accessLogSettings(Consumer<AccessLogSettings.Builder> accessLogSettings) {
            return accessLogSettings(AccessLogSettings.builder().applyMutation(accessLogSettings).build());
        }

        /**
         * <p>
         * Settings for the canary deployment in this stage.
         * </p>
         * 
         * @param canarySettings
         *        Settings for the canary deployment in this stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canarySettings(CanarySettings canarySettings);

        /**
         * <p>
         * Settings for the canary deployment in this stage.
         * </p>
         * This is a convenience that creates an instance of the {@link CanarySettings.Builder} avoiding the need to
         * create one manually via {@link CanarySettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanarySettings.Builder#build()} is called immediately and its
         * result is passed to {@link #canarySettings(CanarySettings)}.
         * 
         * @param canarySettings
         *        a consumer that will call methods on {@link CanarySettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canarySettings(CanarySettings)
         */
        default Builder canarySettings(Consumer<CanarySettings.Builder> canarySettings) {
            return canarySettings(CanarySettings.builder().applyMutation(canarySettings).build());
        }

        /**
         * <p>
         * Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.
         * </p>
         * 
         * @param tracingEnabled
         *        Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracingEnabled(Boolean tracingEnabled);

        /**
         * <p>
         * The collection of tags. Each tag element is associated with a given resource.
         * </p>
         * 
         * @param tags
         *        The collection of tags. Each tag element is associated with a given resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The timestamp when the stage was created.
         * </p>
         * 
         * @param createdDate
         *        The timestamp when the stage was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The timestamp when the stage last updated.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The timestamp when the stage last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentId;

        private String clientCertificateId;

        private String stageName;

        private String description;

        private Boolean cacheClusterEnabled;

        private String cacheClusterSize;

        private String cacheClusterStatus;

        private Map<String, MethodSetting> methodSettings = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();

        private String documentationVersion;

        private AccessLogSettings accessLogSettings;

        private CanarySettings canarySettings;

        private Boolean tracingEnabled;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant createdDate;

        private Instant lastUpdatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Stage model) {
            deploymentId(model.deploymentId);
            clientCertificateId(model.clientCertificateId);
            stageName(model.stageName);
            description(model.description);
            cacheClusterEnabled(model.cacheClusterEnabled);
            cacheClusterSize(model.cacheClusterSize);
            cacheClusterStatus(model.cacheClusterStatus);
            methodSettings(model.methodSettings);
            variables(model.variables);
            documentationVersion(model.documentationVersion);
            accessLogSettings(model.accessLogSettings);
            canarySettings(model.canarySettings);
            tracingEnabled(model.tracingEnabled);
            tags(model.tags);
            createdDate(model.createdDate);
            lastUpdatedDate(model.lastUpdatedDate);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getClientCertificateId() {
            return clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        public final String getStageName() {
            return stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getCacheClusterEnabled() {
            return cacheClusterEnabled;
        }

        @Override
        public final Builder cacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        public final void setCacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
        }

        public final String getCacheClusterSize() {
            return cacheClusterSize;
        }

        @Override
        public final Builder cacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
            return this;
        }

        public final void setCacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
        }

        public final String getCacheClusterStatus() {
            return cacheClusterStatus;
        }

        @Override
        public final Builder cacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
            return this;
        }

        @Override
        public final Builder cacheClusterStatus(CacheClusterStatus cacheClusterStatus) {
            this.cacheClusterStatus(cacheClusterStatus.toString());
            return this;
        }

        public final void setCacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
        }

        public final Map<String, MethodSetting.Builder> getMethodSettings() {
            return methodSettings != null ? CollectionUtils.mapValues(methodSettings, MethodSetting::toBuilder) : null;
        }

        @Override
        public final Builder methodSettings(Map<String, MethodSetting> methodSettings) {
            this.methodSettings = MapOfMethodSettingsCopier.copy(methodSettings);
            return this;
        }

        public final void setMethodSettings(Map<String, MethodSetting.BuilderImpl> methodSettings) {
            this.methodSettings = MapOfMethodSettingsCopier.copyFromBuilder(methodSettings);
        }

        public final Map<String, String> getVariables() {
            return variables;
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = MapOfStringToStringCopier.copy(variables);
            return this;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = MapOfStringToStringCopier.copy(variables);
        }

        public final String getDocumentationVersion() {
            return documentationVersion;
        }

        @Override
        public final Builder documentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
            return this;
        }

        public final void setDocumentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
        }

        public final AccessLogSettings.Builder getAccessLogSettings() {
            return accessLogSettings != null ? accessLogSettings.toBuilder() : null;
        }

        @Override
        public final Builder accessLogSettings(AccessLogSettings accessLogSettings) {
            this.accessLogSettings = accessLogSettings;
            return this;
        }

        public final void setAccessLogSettings(AccessLogSettings.BuilderImpl accessLogSettings) {
            this.accessLogSettings = accessLogSettings != null ? accessLogSettings.build() : null;
        }

        public final CanarySettings.Builder getCanarySettings() {
            return canarySettings != null ? canarySettings.toBuilder() : null;
        }

        @Override
        public final Builder canarySettings(CanarySettings canarySettings) {
            this.canarySettings = canarySettings;
            return this;
        }

        public final void setCanarySettings(CanarySettings.BuilderImpl canarySettings) {
            this.canarySettings = canarySettings != null ? canarySettings.build() : null;
        }

        public final Boolean getTracingEnabled() {
            return tracingEnabled;
        }

        @Override
        public final Builder tracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        public final void setTracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public Stage build() {
            return new Stage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
