/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a custom domain name as a user-friendly host name of an API (<a>RestApi</a>).
 * </p>
 * <div class="Remarks">
 * <p>
 * When you deploy an API, API Gateway creates a default host name for the API. This default API host name is of the
 * <code>{restapi-id}.execute-api.{region}.amazonaws.com</code> format. With the default host name, you can access the
 * API's root resource with the URL of <code>https://{restapi-id}.execute-api.{region}.amazonaws.com/{stage}/</code>.
 * When you set up a custom domain name of <code>apis.example.com</code> for this API, you can then access the same
 * resource using the URL of the <code>https://apis.examples.com/myApi</code>, where <code>myApi</code> is the base path
 * mapping (<a>BasePathMapping</a>) of your API under the custom domain name.
 * </p>
 * </div> <div class="seeAlso"> <a
 * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Set a Custom Host Name
 * for an API</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDomainNameResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<CreateDomainNameResponse.Builder, CreateDomainNameResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameResponse::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameResponse::certificateName)).setter(setter(Builder::certificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameResponse::certificateArn)).setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()).build();

    private static final SdkField<Instant> CERTIFICATE_UPLOAD_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateDomainNameResponse::certificateUploadDate)).setter(setter(Builder::certificateUploadDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateUploadDate").build())
            .build();

    private static final SdkField<String> REGIONAL_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameResponse::regionalDomainName)).setter(setter(Builder::regionalDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalDomainName").build())
            .build();

    private static final SdkField<String> REGIONAL_HOSTED_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameResponse::regionalHostedZoneId)).setter(setter(Builder::regionalHostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalHostedZoneId").build())
            .build();

    private static final SdkField<String> REGIONAL_CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameResponse::regionalCertificateName)).setter(setter(Builder::regionalCertificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalCertificateName").build())
            .build();

    private static final SdkField<String> REGIONAL_CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameResponse::regionalCertificateArn)).setter(setter(Builder::regionalCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalCertificateArn").build())
            .build();

    private static final SdkField<String> DISTRIBUTION_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameResponse::distributionDomainName)).setter(setter(Builder::distributionDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionDomainName").build())
            .build();

    private static final SdkField<String> DISTRIBUTION_HOSTED_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainNameResponse::distributionHostedZoneId)).setter(setter(Builder::distributionHostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionHostedZoneId").build())
            .build();

    private static final SdkField<EndpointConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField
            .<EndpointConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateDomainNameResponse::endpointConfiguration)).setter(setter(Builder::endpointConfiguration))
            .constructor(EndpointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            CERTIFICATE_NAME_FIELD, CERTIFICATE_ARN_FIELD, CERTIFICATE_UPLOAD_DATE_FIELD, REGIONAL_DOMAIN_NAME_FIELD,
            REGIONAL_HOSTED_ZONE_ID_FIELD, REGIONAL_CERTIFICATE_NAME_FIELD, REGIONAL_CERTIFICATE_ARN_FIELD,
            DISTRIBUTION_DOMAIN_NAME_FIELD, DISTRIBUTION_HOSTED_ZONE_ID_FIELD, ENDPOINT_CONFIGURATION_FIELD));

    private final String domainName;

    private final String certificateName;

    private final String certificateArn;

    private final Instant certificateUploadDate;

    private final String regionalDomainName;

    private final String regionalHostedZoneId;

    private final String regionalCertificateName;

    private final String regionalCertificateArn;

    private final String distributionDomainName;

    private final String distributionHostedZoneId;

    private final EndpointConfiguration endpointConfiguration;

    private CreateDomainNameResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.certificateName = builder.certificateName;
        this.certificateArn = builder.certificateArn;
        this.certificateUploadDate = builder.certificateUploadDate;
        this.regionalDomainName = builder.regionalDomainName;
        this.regionalHostedZoneId = builder.regionalHostedZoneId;
        this.regionalCertificateName = builder.regionalCertificateName;
        this.regionalCertificateArn = builder.regionalCertificateArn;
        this.distributionDomainName = builder.distributionDomainName;
        this.distributionHostedZoneId = builder.distributionHostedZoneId;
        this.endpointConfiguration = builder.endpointConfiguration;
    }

    /**
     * <p>
     * The custom domain name as an API host name, for example, <code>my-api.example.com</code>.
     * </p>
     * 
     * @return The custom domain name as an API host name, for example, <code>my-api.example.com</code>.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The name of the certificate that will be used by edge-optimized endpoint for this domain name.
     * </p>
     * 
     * @return The name of the certificate that will be used by edge-optimized endpoint for this domain name.
     */
    public String certificateName() {
        return certificateName;
    }

    /**
     * <p>
     * The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name.
     * AWS Certificate Manager is the only supported source.
     * </p>
     * 
     * @return The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain
     *         name. AWS Certificate Manager is the only supported source.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.
     * </p>
     * 
     * @return The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was
     *         uploaded.
     */
    public Instant certificateUploadDate() {
        return certificateUploadDate;
    }

    /**
     * <p>
     * The domain name associated with the regional endpoint for this custom domain name. You set up this association by
     * adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is
     * returned by API Gateway when you create a regional endpoint.
     * </p>
     * 
     * @return The domain name associated with the regional endpoint for this custom domain name. You set up this
     *         association by adding a DNS record that points the custom domain name to this regional domain name. The
     *         regional domain name is returned by API Gateway when you create a regional endpoint.
     */
    public String regionalDomainName() {
        return regionalDomainName;
    }

    /**
     * <p>
     * The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href=
     * "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html"
     * >Set up a Regional Custom Domain Name</a> and <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for
     * API Gateway</a>.
     * </p>
     * 
     * @return The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html"
     *         >Set up a Regional Custom Domain Name</a> and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and
     *         Endpoints for API Gateway</a>.
     */
    public String regionalHostedZoneId() {
        return regionalHostedZoneId;
    }

    /**
     * <p>
     * The name of the certificate that will be used for validating the regional domain name.
     * </p>
     * 
     * @return The name of the certificate that will be used for validating the regional domain name.
     */
    public String regionalCertificateName() {
        return regionalCertificateName;
    }

    /**
     * <p>
     * The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS
     * Certificate Manager is the only supported source.
     * </p>
     * 
     * @return The reference to an AWS-managed certificate that will be used for validating the regional domain name.
     *         AWS Certificate Manager is the only supported source.
     */
    public String regionalCertificateArn() {
        return regionalCertificateArn;
    }

    /**
     * <p>
     * The domain name of the Amazon CloudFront distribution associated with this custom domain name for an
     * edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to
     * this distribution name. For more information about CloudFront distributions, see the <a
     * href="https://aws.amazon.com/documentation/cloudfront/" target="_blank">Amazon CloudFront documentation</a>.
     * </p>
     * 
     * @return The domain name of the Amazon CloudFront distribution associated with this custom domain name for an
     *         edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain
     *         name to this distribution name. For more information about CloudFront distributions, see the <a
     *         href="https://aws.amazon.com/documentation/cloudfront/" target="_blank">Amazon CloudFront
     *         documentation</a>.
     */
    public String distributionDomainName() {
        return distributionDomainName;
    }

    /**
     * <p>
     * The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is
     * <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href=
     * "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html"
     * >Set up a Regional Custom Domain Name</a> and <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for
     * API Gateway</a>.
     * </p>
     * 
     * @return The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is
     *         <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href=
     *         "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html"
     *         >Set up a Regional Custom Domain Name</a> and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and
     *         Endpoints for API Gateway</a>.
     */
    public String distributionHostedZoneId() {
        return distributionHostedZoneId;
    }

    /**
     * <p>
     * The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.
     * </p>
     * 
     * @return The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.
     */
    public EndpointConfiguration endpointConfiguration() {
        return endpointConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateUploadDate());
        hashCode = 31 * hashCode + Objects.hashCode(regionalDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(regionalHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(regionalCertificateName());
        hashCode = 31 * hashCode + Objects.hashCode(regionalCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(distributionDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(distributionHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainNameResponse)) {
            return false;
        }
        CreateDomainNameResponse other = (CreateDomainNameResponse) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(certificateName(), other.certificateName())
                && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(certificateUploadDate(), other.certificateUploadDate())
                && Objects.equals(regionalDomainName(), other.regionalDomainName())
                && Objects.equals(regionalHostedZoneId(), other.regionalHostedZoneId())
                && Objects.equals(regionalCertificateName(), other.regionalCertificateName())
                && Objects.equals(regionalCertificateArn(), other.regionalCertificateArn())
                && Objects.equals(distributionDomainName(), other.distributionDomainName())
                && Objects.equals(distributionHostedZoneId(), other.distributionHostedZoneId())
                && Objects.equals(endpointConfiguration(), other.endpointConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateDomainNameResponse").add("DomainName", domainName())
                .add("CertificateName", certificateName()).add("CertificateArn", certificateArn())
                .add("CertificateUploadDate", certificateUploadDate()).add("RegionalDomainName", regionalDomainName())
                .add("RegionalHostedZoneId", regionalHostedZoneId()).add("RegionalCertificateName", regionalCertificateName())
                .add("RegionalCertificateArn", regionalCertificateArn()).add("DistributionDomainName", distributionDomainName())
                .add("DistributionHostedZoneId", distributionHostedZoneId())
                .add("EndpointConfiguration", endpointConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "certificateName":
            return Optional.ofNullable(clazz.cast(certificateName()));
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "certificateUploadDate":
            return Optional.ofNullable(clazz.cast(certificateUploadDate()));
        case "regionalDomainName":
            return Optional.ofNullable(clazz.cast(regionalDomainName()));
        case "regionalHostedZoneId":
            return Optional.ofNullable(clazz.cast(regionalHostedZoneId()));
        case "regionalCertificateName":
            return Optional.ofNullable(clazz.cast(regionalCertificateName()));
        case "regionalCertificateArn":
            return Optional.ofNullable(clazz.cast(regionalCertificateArn()));
        case "distributionDomainName":
            return Optional.ofNullable(clazz.cast(distributionDomainName()));
        case "distributionHostedZoneId":
            return Optional.ofNullable(clazz.cast(distributionHostedZoneId()));
        case "endpointConfiguration":
            return Optional.ofNullable(clazz.cast(endpointConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainNameResponse, T> g) {
        return obj -> g.apply((CreateDomainNameResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDomainNameResponse> {
        /**
         * <p>
         * The custom domain name as an API host name, for example, <code>my-api.example.com</code>.
         * </p>
         * 
         * @param domainName
         *        The custom domain name as an API host name, for example, <code>my-api.example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The name of the certificate that will be used by edge-optimized endpoint for this domain name.
         * </p>
         * 
         * @param certificateName
         *        The name of the certificate that will be used by edge-optimized endpoint for this domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateName(String certificateName);

        /**
         * <p>
         * The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain
         * name. AWS Certificate Manager is the only supported source.
         * </p>
         * 
         * @param certificateArn
         *        The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this
         *        domain name. AWS Certificate Manager is the only supported source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was
         * uploaded.
         * </p>
         * 
         * @param certificateUploadDate
         *        The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was
         *        uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateUploadDate(Instant certificateUploadDate);

        /**
         * <p>
         * The domain name associated with the regional endpoint for this custom domain name. You set up this
         * association by adding a DNS record that points the custom domain name to this regional domain name. The
         * regional domain name is returned by API Gateway when you create a regional endpoint.
         * </p>
         * 
         * @param regionalDomainName
         *        The domain name associated with the regional endpoint for this custom domain name. You set up this
         *        association by adding a DNS record that points the custom domain name to this regional domain name.
         *        The regional domain name is returned by API Gateway when you create a regional endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionalDomainName(String regionalDomainName);

        /**
         * <p>
         * The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html"
         * >Set up a Regional Custom Domain Name</a> and <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints
         * for API Gateway</a>.
         * </p>
         * 
         * @param regionalHostedZoneId
         *        The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html"
         *        >Set up a Regional Custom Domain Name</a> and <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and
         *        Endpoints for API Gateway</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionalHostedZoneId(String regionalHostedZoneId);

        /**
         * <p>
         * The name of the certificate that will be used for validating the regional domain name.
         * </p>
         * 
         * @param regionalCertificateName
         *        The name of the certificate that will be used for validating the regional domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionalCertificateName(String regionalCertificateName);

        /**
         * <p>
         * The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS
         * Certificate Manager is the only supported source.
         * </p>
         * 
         * @param regionalCertificateArn
         *        The reference to an AWS-managed certificate that will be used for validating the regional domain name.
         *        AWS Certificate Manager is the only supported source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionalCertificateArn(String regionalCertificateArn);

        /**
         * <p>
         * The domain name of the Amazon CloudFront distribution associated with this custom domain name for an
         * edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name
         * to this distribution name. For more information about CloudFront distributions, see the <a
         * href="https://aws.amazon.com/documentation/cloudfront/" target="_blank">Amazon CloudFront documentation</a>.
         * </p>
         * 
         * @param distributionDomainName
         *        The domain name of the Amazon CloudFront distribution associated with this custom domain name for an
         *        edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom
         *        domain name to this distribution name. For more information about CloudFront distributions, see the <a
         *        href="https://aws.amazon.com/documentation/cloudfront/" target="_blank">Amazon CloudFront
         *        documentation</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionDomainName(String distributionDomainName);

        /**
         * <p>
         * The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is
         * <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href=
         * "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html"
         * >Set up a Regional Custom Domain Name</a> and <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints
         * for API Gateway</a>.
         * </p>
         * 
         * @param distributionHostedZoneId
         *        The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is
         *        <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href=
         *        "https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html"
         *        >Set up a Regional Custom Domain Name</a> and <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and
         *        Endpoints for API Gateway</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionHostedZoneId(String distributionHostedZoneId);

        /**
         * <p>
         * The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.
         * </p>
         * 
         * @param endpointConfiguration
         *        The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfiguration(EndpointConfiguration endpointConfiguration);

        /**
         * <p>
         * The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name.
         * </p>
         * This is a convenience that creates an instance of the {@link EndpointConfiguration.Builder} avoiding the need
         * to create one manually via {@link EndpointConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #endpointConfiguration(EndpointConfiguration)}.
         * 
         * @param endpointConfiguration
         *        a consumer that will call methods on {@link EndpointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfiguration(EndpointConfiguration)
         */
        default Builder endpointConfiguration(Consumer<EndpointConfiguration.Builder> endpointConfiguration) {
            return endpointConfiguration(EndpointConfiguration.builder().applyMutation(endpointConfiguration).build());
        }
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String domainName;

        private String certificateName;

        private String certificateArn;

        private Instant certificateUploadDate;

        private String regionalDomainName;

        private String regionalHostedZoneId;

        private String regionalCertificateName;

        private String regionalCertificateArn;

        private String distributionDomainName;

        private String distributionHostedZoneId;

        private EndpointConfiguration endpointConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainNameResponse model) {
            super(model);
            domainName(model.domainName);
            certificateName(model.certificateName);
            certificateArn(model.certificateArn);
            certificateUploadDate(model.certificateUploadDate);
            regionalDomainName(model.regionalDomainName);
            regionalHostedZoneId(model.regionalHostedZoneId);
            regionalCertificateName(model.regionalCertificateName);
            regionalCertificateArn(model.regionalCertificateArn);
            distributionDomainName(model.distributionDomainName);
            distributionHostedZoneId(model.distributionHostedZoneId);
            endpointConfiguration(model.endpointConfiguration);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getCertificateName() {
            return certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final Instant getCertificateUploadDate() {
            return certificateUploadDate;
        }

        @Override
        public final Builder certificateUploadDate(Instant certificateUploadDate) {
            this.certificateUploadDate = certificateUploadDate;
            return this;
        }

        public final void setCertificateUploadDate(Instant certificateUploadDate) {
            this.certificateUploadDate = certificateUploadDate;
        }

        public final String getRegionalDomainName() {
            return regionalDomainName;
        }

        @Override
        public final Builder regionalDomainName(String regionalDomainName) {
            this.regionalDomainName = regionalDomainName;
            return this;
        }

        public final void setRegionalDomainName(String regionalDomainName) {
            this.regionalDomainName = regionalDomainName;
        }

        public final String getRegionalHostedZoneId() {
            return regionalHostedZoneId;
        }

        @Override
        public final Builder regionalHostedZoneId(String regionalHostedZoneId) {
            this.regionalHostedZoneId = regionalHostedZoneId;
            return this;
        }

        public final void setRegionalHostedZoneId(String regionalHostedZoneId) {
            this.regionalHostedZoneId = regionalHostedZoneId;
        }

        public final String getRegionalCertificateName() {
            return regionalCertificateName;
        }

        @Override
        public final Builder regionalCertificateName(String regionalCertificateName) {
            this.regionalCertificateName = regionalCertificateName;
            return this;
        }

        public final void setRegionalCertificateName(String regionalCertificateName) {
            this.regionalCertificateName = regionalCertificateName;
        }

        public final String getRegionalCertificateArn() {
            return regionalCertificateArn;
        }

        @Override
        public final Builder regionalCertificateArn(String regionalCertificateArn) {
            this.regionalCertificateArn = regionalCertificateArn;
            return this;
        }

        public final void setRegionalCertificateArn(String regionalCertificateArn) {
            this.regionalCertificateArn = regionalCertificateArn;
        }

        public final String getDistributionDomainName() {
            return distributionDomainName;
        }

        @Override
        public final Builder distributionDomainName(String distributionDomainName) {
            this.distributionDomainName = distributionDomainName;
            return this;
        }

        public final void setDistributionDomainName(String distributionDomainName) {
            this.distributionDomainName = distributionDomainName;
        }

        public final String getDistributionHostedZoneId() {
            return distributionHostedZoneId;
        }

        @Override
        public final Builder distributionHostedZoneId(String distributionHostedZoneId) {
            this.distributionHostedZoneId = distributionHostedZoneId;
            return this;
        }

        public final void setDistributionHostedZoneId(String distributionHostedZoneId) {
            this.distributionHostedZoneId = distributionHostedZoneId;
        }

        public final EndpointConfiguration.Builder getEndpointConfiguration() {
            return endpointConfiguration != null ? endpointConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final void setEndpointConfiguration(EndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public CreateDomainNameResponse build() {
            return new CreateDomainNameResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
