/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayException;
import software.amazon.awssdk.services.apigateway.model.BadRequestException;
import software.amazon.awssdk.services.apigateway.model.ConflictException;
import software.amazon.awssdk.services.apigateway.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.CreateModelRequest;
import software.amazon.awssdk.services.apigateway.model.CreateModelResponse;
import software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.CreateResourceRequest;
import software.amazon.awssdk.services.apigateway.model.CreateResourceResponse;
import software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.CreateRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.CreateStageRequest;
import software.amazon.awssdk.services.apigateway.model.CreateStageResponse;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.CreateVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.CreateVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteModelRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteModelResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteResourceRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteResourceResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteStageRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteStageResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheRequest;
import software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheResponse;
import software.amazon.awssdk.services.apigateway.model.FlushStageCacheRequest;
import software.amazon.awssdk.services.apigateway.model.FlushStageCacheResponse;
import software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.GetAccountRequest;
import software.amazon.awssdk.services.apigateway.model.GetAccountResponse;
import software.amazon.awssdk.services.apigateway.model.GetApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.GetApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizersResponse;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse;
import software.amazon.awssdk.services.apigateway.model.GetExportRequest;
import software.amazon.awssdk.services.apigateway.model.GetExportResponse;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesRequest;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesResponse;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetMethodRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponse;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelTemplateRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelTemplateResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelsRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelsResponse;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorsRequest;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorsResponse;
import software.amazon.awssdk.services.apigateway.model.GetResourceRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourceResponse;
import software.amazon.awssdk.services.apigateway.model.GetResourcesRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourcesResponse;
import software.amazon.awssdk.services.apigateway.model.GetRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.GetRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.GetRestApisRequest;
import software.amazon.awssdk.services.apigateway.model.GetRestApisResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypeRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypeResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypesRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypesResponse;
import software.amazon.awssdk.services.apigateway.model.GetStageRequest;
import software.amazon.awssdk.services.apigateway.model.GetStageResponse;
import software.amazon.awssdk.services.apigateway.model.GetStagesRequest;
import software.amazon.awssdk.services.apigateway.model.GetStagesResponse;
import software.amazon.awssdk.services.apigateway.model.GetTagsRequest;
import software.amazon.awssdk.services.apigateway.model.GetTagsResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsageRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsageResponse;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse;
import software.amazon.awssdk.services.apigateway.model.ImportApiKeysRequest;
import software.amazon.awssdk.services.apigateway.model.ImportApiKeysResponse;
import software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsRequest;
import software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsResponse;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.LimitExceededException;
import software.amazon.awssdk.services.apigateway.model.NotFoundException;
import software.amazon.awssdk.services.apigateway.model.PutGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutMethodRequest;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponse;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.PutRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.ServiceUnavailableException;
import software.amazon.awssdk.services.apigateway.model.TagResourceRequest;
import software.amazon.awssdk.services.apigateway.model.TagResourceResponse;
import software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest;
import software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse;
import software.amazon.awssdk.services.apigateway.model.TooManyRequestsException;
import software.amazon.awssdk.services.apigateway.model.UnauthorizedException;
import software.amazon.awssdk.services.apigateway.model.UntagResourceRequest;
import software.amazon.awssdk.services.apigateway.model.UntagResourceResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateAccountRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateAccountResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateModelRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateModelResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateResourceRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateResourceResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateStageRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateStageResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateUsageRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.paginators.GetApiKeysIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetModelsIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetResourcesIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetRestApisIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetUsageIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksIterable;

/**
 * Service client for accessing Amazon API Gateway. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon API Gateway</fullname>
 * <p>
 * Amazon API Gateway helps developers deliver robust, secure, and scalable mobile and web application back ends. API
 * Gateway allows developers to securely connect mobile and web applications to APIs that run on AWS Lambda, Amazon EC2,
 * or other publicly addressable web services that are hosted outside of AWS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ApiGatewayClient extends SdkClient {
    String SERVICE_NAME = "apigateway";

    /**
     * Create a {@link ApiGatewayClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ApiGatewayClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ApiGatewayClient}.
     */
    static ApiGatewayClientBuilder builder() {
        return new DefaultApiGatewayClientBuilder();
    }

    /**
     * <p>
     * Create an <a>ApiKey</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-api-key.html">AWS CLI</a></div>
     *
     * @param createApiKeyRequest
     *        Request to create an <a>ApiKey</a> resource.
     * @return Result of the CreateApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateApiKey
     */
    default CreateApiKeyResponse createApiKey(CreateApiKeyRequest createApiKeyRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an <a>ApiKey</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-api-key.html">AWS CLI</a></div><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link CreateApiKeyRequest#builder()}
     * </p>
     *
     * @param createApiKeyRequest
     *        A {@link Consumer} that will call methods on {@link CreateApiKeyRequest.Builder} to create a request.
     *        Request to create an <a>ApiKey</a> resource.
     * @return Result of the CreateApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateApiKey
     */
    default CreateApiKeyResponse createApiKey(Consumer<CreateApiKeyRequest.Builder> createApiKeyRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, LimitExceededException,
            BadRequestException, ConflictException, AwsServiceException, SdkClientException, ApiGatewayException {
        return createApiKey(CreateApiKeyRequest.builder().applyMutation(createApiKeyRequest).build());
    }

    /**
     * <p>
     * Adds a new <a>Authorizer</a> resource to an existing <a>RestApi</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-authorizer.html">AWS CLI</a></div>
     *
     * @param createAuthorizerRequest
     *        Request to add a new <a>Authorizer</a> to an existing <a>RestApi</a> resource.
     * @return Result of the CreateAuthorizer operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateAuthorizer
     */
    default CreateAuthorizerResponse createAuthorizer(CreateAuthorizerRequest createAuthorizerRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new <a>Authorizer</a> resource to an existing <a>RestApi</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-authorizer.html">AWS CLI</a></div><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAuthorizerRequest#builder()}
     * </p>
     *
     * @param createAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link CreateAuthorizerRequest.Builder} to create a request.
     *        Request to add a new <a>Authorizer</a> to an existing <a>RestApi</a> resource.
     * @return Result of the CreateAuthorizer operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateAuthorizer
     */
    default CreateAuthorizerResponse createAuthorizer(Consumer<CreateAuthorizerRequest.Builder> createAuthorizerRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return createAuthorizer(CreateAuthorizerRequest.builder().applyMutation(createAuthorizerRequest).build());
    }

    /**
     * <p>
     * Creates a new <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param createBasePathMappingRequest
     *        Requests API Gateway to create a new <a>BasePathMapping</a> resource.
     * @return Result of the CreateBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateBasePathMapping
     */
    default CreateBasePathMappingResponse createBasePathMapping(CreateBasePathMappingRequest createBasePathMappingRequest)
            throws UnauthorizedException, ConflictException, BadRequestException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new <a>BasePathMapping</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBasePathMappingRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBasePathMappingRequest#builder()}
     * </p>
     *
     * @param createBasePathMappingRequest
     *        A {@link Consumer} that will call methods on {@link CreateBasePathMappingRequest.Builder} to create a
     *        request. Requests API Gateway to create a new <a>BasePathMapping</a> resource.
     * @return Result of the CreateBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateBasePathMapping
     */
    default CreateBasePathMappingResponse createBasePathMapping(
            Consumer<CreateBasePathMappingRequest.Builder> createBasePathMappingRequest) throws UnauthorizedException,
            ConflictException, BadRequestException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return createBasePathMapping(CreateBasePathMappingRequest.builder().applyMutation(createBasePathMappingRequest).build());
    }

    /**
     * <p>
     * Creates a <a>Deployment</a> resource, which makes a specified <a>RestApi</a> callable over the internet.
     * </p>
     *
     * @param createDeploymentRequest
     *        Requests API Gateway to create a <a>Deployment</a> resource.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDeployment
     */
    default CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest)
            throws UnauthorizedException, BadRequestException, NotFoundException, ConflictException, LimitExceededException,
            TooManyRequestsException, ServiceUnavailableException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a>Deployment</a> resource, which makes a specified <a>RestApi</a> callable over the internet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDeploymentRequest#builder()}
     * </p>
     *
     * @param createDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentRequest.Builder} to create a request.
     *        Requests API Gateway to create a <a>Deployment</a> resource.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDeployment
     */
    default CreateDeploymentResponse createDeployment(Consumer<CreateDeploymentRequest.Builder> createDeploymentRequest)
            throws UnauthorizedException, BadRequestException, NotFoundException, ConflictException, LimitExceededException,
            TooManyRequestsException, ServiceUnavailableException, AwsServiceException, SdkClientException, ApiGatewayException {
        return createDeployment(CreateDeploymentRequest.builder().applyMutation(createDeploymentRequest).build());
    }

    /**
     * Invokes the CreateDocumentationPart operation.
     *
     * @param createDocumentationPartRequest
     *        Creates a new documentation part of a given API.
     * @return Result of the CreateDocumentationPart operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDocumentationPart
     */
    default CreateDocumentationPartResponse createDocumentationPart(CreateDocumentationPartRequest createDocumentationPartRequest)
            throws BadRequestException, ConflictException, UnauthorizedException, NotFoundException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the CreateDocumentationPart operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDocumentationPartRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDocumentationPartRequest#builder()}
     * </p>
     *
     * @param createDocumentationPartRequest
     *        A {@link Consumer} that will call methods on {@link CreateDocumentationPartRequest.Builder} to create a
     *        request. Creates a new documentation part of a given API.
     * @return Result of the CreateDocumentationPart operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDocumentationPart
     */
    default CreateDocumentationPartResponse createDocumentationPart(
            Consumer<CreateDocumentationPartRequest.Builder> createDocumentationPartRequest) throws BadRequestException,
            ConflictException, UnauthorizedException, NotFoundException, LimitExceededException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return createDocumentationPart(CreateDocumentationPartRequest.builder().applyMutation(createDocumentationPartRequest)
                .build());
    }

    /**
     * Invokes the CreateDocumentationVersion operation.
     *
     * @param createDocumentationVersionRequest
     *        Creates a new documentation version of a given API.
     * @return Result of the CreateDocumentationVersion operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDocumentationVersion
     */
    default CreateDocumentationVersionResponse createDocumentationVersion(
            CreateDocumentationVersionRequest createDocumentationVersionRequest) throws BadRequestException, ConflictException,
            UnauthorizedException, NotFoundException, LimitExceededException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the CreateDocumentationVersion operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDocumentationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDocumentationVersionRequest#builder()}
     * </p>
     *
     * @param createDocumentationVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDocumentationVersionRequest.Builder} to create a
     *        request. Creates a new documentation version of a given API.
     * @return Result of the CreateDocumentationVersion operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDocumentationVersion
     */
    default CreateDocumentationVersionResponse createDocumentationVersion(
            Consumer<CreateDocumentationVersionRequest.Builder> createDocumentationVersionRequest) throws BadRequestException,
            ConflictException, UnauthorizedException, NotFoundException, LimitExceededException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return createDocumentationVersion(CreateDocumentationVersionRequest.builder()
                .applyMutation(createDocumentationVersionRequest).build());
    }

    /**
     * <p>
     * Creates a new domain name.
     * </p>
     *
     * @param createDomainNameRequest
     *        A request to create a new domain name.
     * @return Result of the CreateDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDomainName
     */
    default CreateDomainNameResponse createDomainName(CreateDomainNameRequest createDomainNameRequest)
            throws UnauthorizedException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDomainNameRequest#builder()}
     * </p>
     *
     * @param createDomainNameRequest
     *        A {@link Consumer} that will call methods on {@link CreateDomainNameRequest.Builder} to create a request.
     *        A request to create a new domain name.
     * @return Result of the CreateDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDomainName
     */
    default CreateDomainNameResponse createDomainName(Consumer<CreateDomainNameRequest.Builder> createDomainNameRequest)
            throws UnauthorizedException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return createDomainName(CreateDomainNameRequest.builder().applyMutation(createDomainNameRequest).build());
    }

    /**
     * <p>
     * Adds a new <a>Model</a> resource to an existing <a>RestApi</a> resource.
     * </p>
     *
     * @param createModelRequest
     *        Request to add a new <a>Model</a> to an existing <a>RestApi</a> resource.
     * @return Result of the CreateModel operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateModel
     */
    default CreateModelResponse createModel(CreateModelRequest createModelRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, ConflictException, LimitExceededException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new <a>Model</a> resource to an existing <a>RestApi</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateModelRequest#builder()}
     * </p>
     *
     * @param createModelRequest
     *        A {@link Consumer} that will call methods on {@link CreateModelRequest.Builder} to create a request.
     *        Request to add a new <a>Model</a> to an existing <a>RestApi</a> resource.
     * @return Result of the CreateModel operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateModel
     */
    default CreateModelResponse createModel(Consumer<CreateModelRequest.Builder> createModelRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, ConflictException, LimitExceededException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return createModel(CreateModelRequest.builder().applyMutation(createModelRequest).build());
    }

    /**
     * <p>
     * Creates a <a>ReqeustValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param createRequestValidatorRequest
     *        Creates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the CreateRequestValidator operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateRequestValidator
     */
    default CreateRequestValidatorResponse createRequestValidator(CreateRequestValidatorRequest createRequestValidatorRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a>ReqeustValidator</a> of a given <a>RestApi</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRequestValidatorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRequestValidatorRequest#builder()}
     * </p>
     *
     * @param createRequestValidatorRequest
     *        A {@link Consumer} that will call methods on {@link CreateRequestValidatorRequest.Builder} to create a
     *        request. Creates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the CreateRequestValidator operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateRequestValidator
     */
    default CreateRequestValidatorResponse createRequestValidator(
            Consumer<CreateRequestValidatorRequest.Builder> createRequestValidatorRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, LimitExceededException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return createRequestValidator(CreateRequestValidatorRequest.builder().applyMutation(createRequestValidatorRequest)
                .build());
    }

    /**
     * <p>
     * Creates a <a>Resource</a> resource.
     * </p>
     *
     * @param createResourceRequest
     *        Requests API Gateway to create a <a>Resource</a> resource.
     * @return Result of the CreateResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateResource
     */
    default CreateResourceResponse createResource(CreateResourceRequest createResourceRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, LimitExceededException, BadRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a>Resource</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateResourceRequest#builder()}
     * </p>
     *
     * @param createResourceRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceRequest.Builder} to create a request.
     *        Requests API Gateway to create a <a>Resource</a> resource.
     * @return Result of the CreateResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateResource
     */
    default CreateResourceResponse createResource(Consumer<CreateResourceRequest.Builder> createResourceRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, LimitExceededException, BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return createResource(CreateResourceRequest.builder().applyMutation(createResourceRequest).build());
    }

    /**
     * <p>
     * Creates a new <a>RestApi</a> resource.
     * </p>
     *
     * @param createRestApiRequest
     *        The POST Request to add a new <a>RestApi</a> resource to your collection.
     * @return Result of the CreateRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateRestApi
     */
    default CreateRestApiResponse createRestApi(CreateRestApiRequest createRestApiRequest) throws UnauthorizedException,
            LimitExceededException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new <a>RestApi</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRestApiRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRestApiRequest#builder()}
     * </p>
     *
     * @param createRestApiRequest
     *        A {@link Consumer} that will call methods on {@link CreateRestApiRequest.Builder} to create a request. The
     *        POST Request to add a new <a>RestApi</a> resource to your collection.
     * @return Result of the CreateRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateRestApi
     */
    default CreateRestApiResponse createRestApi(Consumer<CreateRestApiRequest.Builder> createRestApiRequest)
            throws UnauthorizedException, LimitExceededException, BadRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return createRestApi(CreateRestApiRequest.builder().applyMutation(createRestApiRequest).build());
    }

    /**
     * <p>
     * Creates a new <a>Stage</a> resource that references a pre-existing <a>Deployment</a> for the API.
     * </p>
     *
     * @param createStageRequest
     *        Requests API Gateway to create a <a>Stage</a> resource.
     * @return Result of the CreateStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateStage
     */
    default CreateStageResponse createStage(CreateStageRequest createStageRequest) throws UnauthorizedException,
            BadRequestException, NotFoundException, ConflictException, LimitExceededException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new <a>Stage</a> resource that references a pre-existing <a>Deployment</a> for the API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStageRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStageRequest#builder()}
     * </p>
     *
     * @param createStageRequest
     *        A {@link Consumer} that will call methods on {@link CreateStageRequest.Builder} to create a request.
     *        Requests API Gateway to create a <a>Stage</a> resource.
     * @return Result of the CreateStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateStage
     */
    default CreateStageResponse createStage(Consumer<CreateStageRequest.Builder> createStageRequest)
            throws UnauthorizedException, BadRequestException, NotFoundException, ConflictException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return createStage(CreateStageRequest.builder().applyMutation(createStageRequest).build());
    }

    /**
     * <p>
     * Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the
     * payload.
     * </p>
     *
     * @param createUsagePlanRequest
     *        The POST request to create a usage plan with the name, description, throttle limits and quota limits, as
     *        well as the associated API stages, specified in the payload.
     * @return Result of the CreateUsagePlan operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateUsagePlan
     */
    default CreateUsagePlanResponse createUsagePlan(CreateUsagePlanRequest createUsagePlanRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, LimitExceededException, ConflictException, NotFoundException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the
     * payload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUsagePlanRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUsagePlanRequest#builder()}
     * </p>
     *
     * @param createUsagePlanRequest
     *        A {@link Consumer} that will call methods on {@link CreateUsagePlanRequest.Builder} to create a request.
     *        The POST request to create a usage plan with the name, description, throttle limits and quota limits, as
     *        well as the associated API stages, specified in the payload.
     * @return Result of the CreateUsagePlan operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateUsagePlan
     */
    default CreateUsagePlanResponse createUsagePlan(Consumer<CreateUsagePlanRequest.Builder> createUsagePlanRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, LimitExceededException,
            ConflictException, NotFoundException, AwsServiceException, SdkClientException, ApiGatewayException {
        return createUsagePlan(CreateUsagePlanRequest.builder().applyMutation(createUsagePlanRequest).build());
    }

    /**
     * <p>
     * Creates a usage plan key for adding an existing API key to a usage plan.
     * </p>
     *
     * @param createUsagePlanKeyRequest
     *        The POST request to create a usage plan key for adding an existing API key to a usage plan.
     * @return Result of the CreateUsagePlanKey operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateUsagePlanKey
     */
    default CreateUsagePlanKeyResponse createUsagePlanKey(CreateUsagePlanKeyRequest createUsagePlanKeyRequest)
            throws BadRequestException, ConflictException, UnauthorizedException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a usage plan key for adding an existing API key to a usage plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUsagePlanKeyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUsagePlanKeyRequest#builder()}
     * </p>
     *
     * @param createUsagePlanKeyRequest
     *        A {@link Consumer} that will call methods on {@link CreateUsagePlanKeyRequest.Builder} to create a
     *        request. The POST request to create a usage plan key for adding an existing API key to a usage plan.
     * @return Result of the CreateUsagePlanKey operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateUsagePlanKey
     */
    default CreateUsagePlanKeyResponse createUsagePlanKey(Consumer<CreateUsagePlanKeyRequest.Builder> createUsagePlanKeyRequest)
            throws BadRequestException, ConflictException, UnauthorizedException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return createUsagePlanKey(CreateUsagePlanKeyRequest.builder().applyMutation(createUsagePlanKeyRequest).build());
    }

    /**
     * <p>
     * Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically
     * takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC
     * Endpoint services.
     * </p>
     *
     * @param createVpcLinkRequest
     *        Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that
     *        typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create
     *        and update VPC Endpoint services.
     * @return Result of the CreateVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateVpcLink
     */
    default CreateVpcLinkResponse createVpcLink(CreateVpcLinkRequest createVpcLinkRequest) throws UnauthorizedException,
            BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically
     * takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC
     * Endpoint services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVpcLinkRequest#builder()}
     * </p>
     *
     * @param createVpcLinkRequest
     *        A {@link Consumer} that will call methods on {@link CreateVpcLinkRequest.Builder} to create a request.
     *        Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that
     *        typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create
     *        and update VPC Endpoint services.
     * @return Result of the CreateVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateVpcLink
     */
    default CreateVpcLinkResponse createVpcLink(Consumer<CreateVpcLinkRequest.Builder> createVpcLinkRequest)
            throws UnauthorizedException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return createVpcLink(CreateVpcLinkRequest.builder().applyMutation(createVpcLinkRequest).build());
    }

    /**
     * <p>
     * Deletes the <a>ApiKey</a> resource.
     * </p>
     *
     * @param deleteApiKeyRequest
     *        A request to delete the <a>ApiKey</a> resource.
     * @return Result of the DeleteApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteApiKey
     */
    default DeleteApiKeyResponse deleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the <a>ApiKey</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteApiKeyRequest#builder()}
     * </p>
     *
     * @param deleteApiKeyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApiKeyRequest.Builder} to create a request. A
     *        request to delete the <a>ApiKey</a> resource.
     * @return Result of the DeleteApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteApiKey
     */
    default DeleteApiKeyResponse deleteApiKey(Consumer<DeleteApiKeyRequest.Builder> deleteApiKeyRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return deleteApiKey(DeleteApiKeyRequest.builder().applyMutation(deleteApiKeyRequest).build());
    }

    /**
     * <p>
     * Deletes an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/delete-authorizer.html">AWS CLI</a></div>
     *
     * @param deleteAuthorizerRequest
     *        Request to delete an existing <a>Authorizer</a> resource.
     * @return Result of the DeleteAuthorizer operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteAuthorizer
     */
    default DeleteAuthorizerResponse deleteAuthorizer(DeleteAuthorizerRequest deleteAuthorizerRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/delete-authorizer.html">AWS CLI</a></div><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAuthorizerRequest#builder()}
     * </p>
     *
     * @param deleteAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAuthorizerRequest.Builder} to create a request.
     *        Request to delete an existing <a>Authorizer</a> resource.
     * @return Result of the DeleteAuthorizer operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteAuthorizer
     */
    default DeleteAuthorizerResponse deleteAuthorizer(Consumer<DeleteAuthorizerRequest.Builder> deleteAuthorizerRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return deleteAuthorizer(DeleteAuthorizerRequest.builder().applyMutation(deleteAuthorizerRequest).build());
    }

    /**
     * <p>
     * Deletes the <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param deleteBasePathMappingRequest
     *        A request to delete the <a>BasePathMapping</a> resource.
     * @return Result of the DeleteBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteBasePathMapping
     */
    default DeleteBasePathMappingResponse deleteBasePathMapping(DeleteBasePathMappingRequest deleteBasePathMappingRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, BadRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the <a>BasePathMapping</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBasePathMappingRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBasePathMappingRequest#builder()}
     * </p>
     *
     * @param deleteBasePathMappingRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBasePathMappingRequest.Builder} to create a
     *        request. A request to delete the <a>BasePathMapping</a> resource.
     * @return Result of the DeleteBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteBasePathMapping
     */
    default DeleteBasePathMappingResponse deleteBasePathMapping(
            Consumer<DeleteBasePathMappingRequest.Builder> deleteBasePathMappingRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return deleteBasePathMapping(DeleteBasePathMappingRequest.builder().applyMutation(deleteBasePathMappingRequest).build());
    }

    /**
     * <p>
     * Deletes the <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param deleteClientCertificateRequest
     *        A request to delete the <a>ClientCertificate</a> resource.
     * @return Result of the DeleteClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteClientCertificate
     */
    default DeleteClientCertificateResponse deleteClientCertificate(DeleteClientCertificateRequest deleteClientCertificateRequest)
            throws UnauthorizedException, TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the <a>ClientCertificate</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClientCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteClientCertificateRequest#builder()}
     * </p>
     *
     * @param deleteClientCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClientCertificateRequest.Builder} to create a
     *        request. A request to delete the <a>ClientCertificate</a> resource.
     * @return Result of the DeleteClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteClientCertificate
     */
    default DeleteClientCertificateResponse deleteClientCertificate(
            Consumer<DeleteClientCertificateRequest.Builder> deleteClientCertificateRequest) throws UnauthorizedException,
            TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return deleteClientCertificate(DeleteClientCertificateRequest.builder().applyMutation(deleteClientCertificateRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a <a>Deployment</a> resource. Deleting a deployment will only succeed if there are no <a>Stage</a>
     * resources associated with it.
     * </p>
     *
     * @param deleteDeploymentRequest
     *        Requests API Gateway to delete a <a>Deployment</a> resource.
     * @return Result of the DeleteDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDeployment
     */
    default DeleteDeploymentResponse deleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <a>Deployment</a> resource. Deleting a deployment will only succeed if there are no <a>Stage</a>
     * resources associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDeploymentRequest#builder()}
     * </p>
     *
     * @param deleteDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeploymentRequest.Builder} to create a request.
     *        Requests API Gateway to delete a <a>Deployment</a> resource.
     * @return Result of the DeleteDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDeployment
     */
    default DeleteDeploymentResponse deleteDeployment(Consumer<DeleteDeploymentRequest.Builder> deleteDeploymentRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return deleteDeployment(DeleteDeploymentRequest.builder().applyMutation(deleteDeploymentRequest).build());
    }

    /**
     * Invokes the DeleteDocumentationPart operation.
     *
     * @param deleteDocumentationPartRequest
     *        Deletes an existing documentation part of an API.
     * @return Result of the DeleteDocumentationPart operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDocumentationPart
     */
    default DeleteDocumentationPartResponse deleteDocumentationPart(DeleteDocumentationPartRequest deleteDocumentationPartRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DeleteDocumentationPart operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDocumentationPartRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDocumentationPartRequest#builder()}
     * </p>
     *
     * @param deleteDocumentationPartRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDocumentationPartRequest.Builder} to create a
     *        request. Deletes an existing documentation part of an API.
     * @return Result of the DeleteDocumentationPart operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDocumentationPart
     */
    default DeleteDocumentationPartResponse deleteDocumentationPart(
            Consumer<DeleteDocumentationPartRequest.Builder> deleteDocumentationPartRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, ConflictException, BadRequestException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return deleteDocumentationPart(DeleteDocumentationPartRequest.builder().applyMutation(deleteDocumentationPartRequest)
                .build());
    }

    /**
     * Invokes the DeleteDocumentationVersion operation.
     *
     * @param deleteDocumentationVersionRequest
     *        Deletes an existing documentation version of an API.
     * @return Result of the DeleteDocumentationVersion operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDocumentationVersion
     */
    default DeleteDocumentationVersionResponse deleteDocumentationVersion(
            DeleteDocumentationVersionRequest deleteDocumentationVersionRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DeleteDocumentationVersion operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDocumentationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDocumentationVersionRequest#builder()}
     * </p>
     *
     * @param deleteDocumentationVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDocumentationVersionRequest.Builder} to create a
     *        request. Deletes an existing documentation version of an API.
     * @return Result of the DeleteDocumentationVersion operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDocumentationVersion
     */
    default DeleteDocumentationVersionResponse deleteDocumentationVersion(
            Consumer<DeleteDocumentationVersionRequest.Builder> deleteDocumentationVersionRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return deleteDocumentationVersion(DeleteDocumentationVersionRequest.builder()
                .applyMutation(deleteDocumentationVersionRequest).build());
    }

    /**
     * <p>
     * Deletes the <a>DomainName</a> resource.
     * </p>
     *
     * @param deleteDomainNameRequest
     *        A request to delete the <a>DomainName</a> resource.
     * @return Result of the DeleteDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDomainName
     */
    default DeleteDomainNameResponse deleteDomainName(DeleteDomainNameRequest deleteDomainNameRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the <a>DomainName</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDomainNameRequest#builder()}
     * </p>
     *
     * @param deleteDomainNameRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDomainNameRequest.Builder} to create a request.
     *        A request to delete the <a>DomainName</a> resource.
     * @return Result of the DeleteDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDomainName
     */
    default DeleteDomainNameResponse deleteDomainName(Consumer<DeleteDomainNameRequest.Builder> deleteDomainNameRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return deleteDomainName(DeleteDomainNameRequest.builder().applyMutation(deleteDomainNameRequest).build());
    }

    /**
     * <p>
     * Clears any customization of a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a> and
     * resets it with the default settings.
     * </p>
     *
     * @param deleteGatewayResponseRequest
     *        Clears any customization of a <a>GatewayResponse</a> of a specified response type on the given
     *        <a>RestApi</a> and resets it with the default settings.
     * @return Result of the DeleteGatewayResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteGatewayResponse
     */
    default DeleteGatewayResponseResponse deleteGatewayResponse(DeleteGatewayResponseRequest deleteGatewayResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Clears any customization of a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a> and
     * resets it with the default settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayResponseRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGatewayResponseRequest#builder()}
     * </p>
     *
     * @param deleteGatewayResponseRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGatewayResponseRequest.Builder} to create a
     *        request. Clears any customization of a <a>GatewayResponse</a> of a specified response type on the given
     *        <a>RestApi</a> and resets it with the default settings.
     * @return Result of the DeleteGatewayResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteGatewayResponse
     */
    default DeleteGatewayResponseResponse deleteGatewayResponse(
            Consumer<DeleteGatewayResponseRequest.Builder> deleteGatewayResponseRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return deleteGatewayResponse(DeleteGatewayResponseRequest.builder().applyMutation(deleteGatewayResponseRequest).build());
    }

    /**
     * <p>
     * Represents a delete integration.
     * </p>
     *
     * @param deleteIntegrationRequest
     *        Represents a delete integration request.
     * @return Result of the DeleteIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteIntegration
     */
    default DeleteIntegrationResponse deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a delete integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIntegrationRequest.Builder} to create a request.
     *        Represents a delete integration request.
     * @return Result of the DeleteIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteIntegration
     */
    default DeleteIntegrationResponse deleteIntegration(Consumer<DeleteIntegrationRequest.Builder> deleteIntegrationRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return deleteIntegration(DeleteIntegrationRequest.builder().applyMutation(deleteIntegrationRequest).build());
    }

    /**
     * <p>
     * Represents a delete integration response.
     * </p>
     *
     * @param deleteIntegrationResponseRequest
     *        Represents a delete integration response request.
     * @return Result of the DeleteIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteIntegrationResponse
     */
    default DeleteIntegrationResponseResponse deleteIntegrationResponse(
            DeleteIntegrationResponseRequest deleteIntegrationResponseRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a delete integration response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationResponseRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIntegrationResponseRequest.Builder} to create a
     *        request. Represents a delete integration response request.
     * @return Result of the DeleteIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteIntegrationResponse
     */
    default DeleteIntegrationResponseResponse deleteIntegrationResponse(
            Consumer<DeleteIntegrationResponseRequest.Builder> deleteIntegrationResponseRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return deleteIntegrationResponse(DeleteIntegrationResponseRequest.builder()
                .applyMutation(deleteIntegrationResponseRequest).build());
    }

    /**
     * <p>
     * Deletes an existing <a>Method</a> resource.
     * </p>
     *
     * @param deleteMethodRequest
     *        Request to delete an existing <a>Method</a> resource.
     * @return Result of the DeleteMethod operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteMethod
     */
    default DeleteMethodResponse deleteMethod(DeleteMethodRequest deleteMethodRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing <a>Method</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMethodRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMethodRequest#builder()}
     * </p>
     *
     * @param deleteMethodRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMethodRequest.Builder} to create a request.
     *        Request to delete an existing <a>Method</a> resource.
     * @return Result of the DeleteMethod operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteMethod
     */
    default DeleteMethodResponse deleteMethod(Consumer<DeleteMethodRequest.Builder> deleteMethodRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return deleteMethod(DeleteMethodRequest.builder().applyMutation(deleteMethodRequest).build());
    }

    /**
     * <p>
     * Deletes an existing <a>MethodResponse</a> resource.
     * </p>
     *
     * @param deleteMethodResponseRequest
     *        A request to delete an existing <a>MethodResponse</a> resource.
     * @return Result of the DeleteMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteMethodResponse
     */
    default DeleteMethodResponseResponse deleteMethodResponse(DeleteMethodResponseRequest deleteMethodResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing <a>MethodResponse</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMethodResponseRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMethodResponseRequest#builder()}
     * </p>
     *
     * @param deleteMethodResponseRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMethodResponseRequest.Builder} to create a
     *        request. A request to delete an existing <a>MethodResponse</a> resource.
     * @return Result of the DeleteMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteMethodResponse
     */
    default DeleteMethodResponseResponse deleteMethodResponse(
            Consumer<DeleteMethodResponseRequest.Builder> deleteMethodResponseRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return deleteMethodResponse(DeleteMethodResponseRequest.builder().applyMutation(deleteMethodResponseRequest).build());
    }

    /**
     * <p>
     * Deletes a model.
     * </p>
     *
     * @param deleteModelRequest
     *        Request to delete an existing model in an existing <a>RestApi</a> resource.
     * @return Result of the DeleteModel operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteModel
     */
    default DeleteModelResponse deleteModel(DeleteModelRequest deleteModelRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteModelRequest#builder()}
     * </p>
     *
     * @param deleteModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteModelRequest.Builder} to create a request.
     *        Request to delete an existing model in an existing <a>RestApi</a> resource.
     * @return Result of the DeleteModel operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteModel
     */
    default DeleteModelResponse deleteModel(Consumer<DeleteModelRequest.Builder> deleteModelRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return deleteModel(DeleteModelRequest.builder().applyMutation(deleteModelRequest).build());
    }

    /**
     * <p>
     * Deletes a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param deleteRequestValidatorRequest
     *        Deletes a specified <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the DeleteRequestValidator operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteRequestValidator
     */
    default DeleteRequestValidatorResponse deleteRequestValidator(DeleteRequestValidatorRequest deleteRequestValidatorRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRequestValidatorRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRequestValidatorRequest#builder()}
     * </p>
     *
     * @param deleteRequestValidatorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRequestValidatorRequest.Builder} to create a
     *        request. Deletes a specified <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the DeleteRequestValidator operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteRequestValidator
     */
    default DeleteRequestValidatorResponse deleteRequestValidator(
            Consumer<DeleteRequestValidatorRequest.Builder> deleteRequestValidatorRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return deleteRequestValidator(DeleteRequestValidatorRequest.builder().applyMutation(deleteRequestValidatorRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a <a>Resource</a> resource.
     * </p>
     *
     * @param deleteResourceRequest
     *        Request to delete a <a>Resource</a>.
     * @return Result of the DeleteResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteResource
     */
    default DeleteResourceResponse deleteResource(DeleteResourceRequest deleteResourceRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <a>Resource</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteResourceRequest#builder()}
     * </p>
     *
     * @param deleteResourceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourceRequest.Builder} to create a request.
     *        Request to delete a <a>Resource</a>.
     * @return Result of the DeleteResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteResource
     */
    default DeleteResourceResponse deleteResource(Consumer<DeleteResourceRequest.Builder> deleteResourceRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, ConflictException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return deleteResource(DeleteResourceRequest.builder().applyMutation(deleteResourceRequest).build());
    }

    /**
     * <p>
     * Deletes the specified API.
     * </p>
     *
     * @param deleteRestApiRequest
     *        Request to delete the specified API from your collection.
     * @return Result of the DeleteRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteRestApi
     */
    default DeleteRestApiResponse deleteRestApi(DeleteRestApiRequest deleteRestApiRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRestApiRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRestApiRequest#builder()}
     * </p>
     *
     * @param deleteRestApiRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRestApiRequest.Builder} to create a request.
     *        Request to delete the specified API from your collection.
     * @return Result of the DeleteRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteRestApi
     */
    default DeleteRestApiResponse deleteRestApi(Consumer<DeleteRestApiRequest.Builder> deleteRestApiRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return deleteRestApi(DeleteRestApiRequest.builder().applyMutation(deleteRestApiRequest).build());
    }

    /**
     * <p>
     * Deletes a <a>Stage</a> resource.
     * </p>
     *
     * @param deleteStageRequest
     *        Requests API Gateway to delete a <a>Stage</a> resource.
     * @return Result of the DeleteStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteStage
     */
    default DeleteStageResponse deleteStage(DeleteStageRequest deleteStageRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <a>Stage</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStageRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStageRequest#builder()}
     * </p>
     *
     * @param deleteStageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStageRequest.Builder} to create a request.
     *        Requests API Gateway to delete a <a>Stage</a> resource.
     * @return Result of the DeleteStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteStage
     */
    default DeleteStageResponse deleteStage(Consumer<DeleteStageRequest.Builder> deleteStageRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return deleteStage(DeleteStageRequest.builder().applyMutation(deleteStageRequest).build());
    }

    /**
     * <p>
     * Deletes a usage plan of a given plan Id.
     * </p>
     *
     * @param deleteUsagePlanRequest
     *        The DELETE request to delete a usage plan of a given plan Id.
     * @return Result of the DeleteUsagePlan operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteUsagePlan
     */
    default DeleteUsagePlanResponse deleteUsagePlan(DeleteUsagePlanRequest deleteUsagePlanRequest) throws UnauthorizedException,
            TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a usage plan of a given plan Id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUsagePlanRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteUsagePlanRequest#builder()}
     * </p>
     *
     * @param deleteUsagePlanRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUsagePlanRequest.Builder} to create a request.
     *        The DELETE request to delete a usage plan of a given plan Id.
     * @return Result of the DeleteUsagePlan operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteUsagePlan
     */
    default DeleteUsagePlanResponse deleteUsagePlan(Consumer<DeleteUsagePlanRequest.Builder> deleteUsagePlanRequest)
            throws UnauthorizedException, TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return deleteUsagePlan(DeleteUsagePlanRequest.builder().applyMutation(deleteUsagePlanRequest).build());
    }

    /**
     * <p>
     * Deletes a usage plan key and remove the underlying API key from the associated usage plan.
     * </p>
     *
     * @param deleteUsagePlanKeyRequest
     *        The DELETE request to delete a usage plan key and remove the underlying API key from the associated usage
     *        plan.
     * @return Result of the DeleteUsagePlanKey operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteUsagePlanKey
     */
    default DeleteUsagePlanKeyResponse deleteUsagePlanKey(DeleteUsagePlanKeyRequest deleteUsagePlanKeyRequest)
            throws BadRequestException, ConflictException, UnauthorizedException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a usage plan key and remove the underlying API key from the associated usage plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUsagePlanKeyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUsagePlanKeyRequest#builder()}
     * </p>
     *
     * @param deleteUsagePlanKeyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUsagePlanKeyRequest.Builder} to create a
     *        request. The DELETE request to delete a usage plan key and remove the underlying API key from the
     *        associated usage plan.
     * @return Result of the DeleteUsagePlanKey operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteUsagePlanKey
     */
    default DeleteUsagePlanKeyResponse deleteUsagePlanKey(Consumer<DeleteUsagePlanKeyRequest.Builder> deleteUsagePlanKeyRequest)
            throws BadRequestException, ConflictException, UnauthorizedException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return deleteUsagePlanKey(DeleteUsagePlanKeyRequest.builder().applyMutation(deleteUsagePlanKeyRequest).build());
    }

    /**
     * <p>
     * Deletes an existing <a>VpcLink</a> of a specified identifier.
     * </p>
     *
     * @param deleteVpcLinkRequest
     *        Deletes an existing <a>VpcLink</a> of a specified identifier.
     * @return Result of the DeleteVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteVpcLink
     */
    default DeleteVpcLinkResponse deleteVpcLink(DeleteVpcLinkRequest deleteVpcLinkRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing <a>VpcLink</a> of a specified identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVpcLinkRequest#builder()}
     * </p>
     *
     * @param deleteVpcLinkRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVpcLinkRequest.Builder} to create a request.
     *        Deletes an existing <a>VpcLink</a> of a specified identifier.
     * @return Result of the DeleteVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteVpcLink
     */
    default DeleteVpcLinkResponse deleteVpcLink(Consumer<DeleteVpcLinkRequest.Builder> deleteVpcLinkRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return deleteVpcLink(DeleteVpcLinkRequest.builder().applyMutation(deleteVpcLinkRequest).build());
    }

    /**
     * <p>
     * Flushes all authorizer cache entries on a stage.
     * </p>
     *
     * @param flushStageAuthorizersCacheRequest
     *        Request to flush authorizer cache entries on a specified stage.
     * @return Result of the FlushStageAuthorizersCache operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.FlushStageAuthorizersCache
     */
    default FlushStageAuthorizersCacheResponse flushStageAuthorizersCache(
            FlushStageAuthorizersCacheRequest flushStageAuthorizersCacheRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Flushes all authorizer cache entries on a stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FlushStageAuthorizersCacheRequest.Builder} avoiding
     * the need to create one manually via {@link FlushStageAuthorizersCacheRequest#builder()}
     * </p>
     *
     * @param flushStageAuthorizersCacheRequest
     *        A {@link Consumer} that will call methods on {@link FlushStageAuthorizersCacheRequest.Builder} to create a
     *        request. Request to flush authorizer cache entries on a specified stage.
     * @return Result of the FlushStageAuthorizersCache operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.FlushStageAuthorizersCache
     */
    default FlushStageAuthorizersCacheResponse flushStageAuthorizersCache(
            Consumer<FlushStageAuthorizersCacheRequest.Builder> flushStageAuthorizersCacheRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return flushStageAuthorizersCache(FlushStageAuthorizersCacheRequest.builder()
                .applyMutation(flushStageAuthorizersCacheRequest).build());
    }

    /**
     * <p>
     * Flushes a stage's cache.
     * </p>
     *
     * @param flushStageCacheRequest
     *        Requests API Gateway to flush a stage's cache.
     * @return Result of the FlushStageCache operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.FlushStageCache
     */
    default FlushStageCacheResponse flushStageCache(FlushStageCacheRequest flushStageCacheRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Flushes a stage's cache.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FlushStageCacheRequest.Builder} avoiding the need
     * to create one manually via {@link FlushStageCacheRequest#builder()}
     * </p>
     *
     * @param flushStageCacheRequest
     *        A {@link Consumer} that will call methods on {@link FlushStageCacheRequest.Builder} to create a request.
     *        Requests API Gateway to flush a stage's cache.
     * @return Result of the FlushStageCache operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.FlushStageCache
     */
    default FlushStageCacheResponse flushStageCache(Consumer<FlushStageCacheRequest.Builder> flushStageCacheRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return flushStageCache(FlushStageCacheRequest.builder().applyMutation(flushStageCacheRequest).build());
    }

    /**
     * <p>
     * Generates a <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param generateClientCertificateRequest
     *        A request to generate a <a>ClientCertificate</a> resource.
     * @return Result of the GenerateClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GenerateClientCertificate
     */
    default GenerateClientCertificateResponse generateClientCertificate(
            GenerateClientCertificateRequest generateClientCertificateRequest) throws UnauthorizedException,
            TooManyRequestsException, LimitExceededException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a <a>ClientCertificate</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateClientCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link GenerateClientCertificateRequest#builder()}
     * </p>
     *
     * @param generateClientCertificateRequest
     *        A {@link Consumer} that will call methods on {@link GenerateClientCertificateRequest.Builder} to create a
     *        request. A request to generate a <a>ClientCertificate</a> resource.
     * @return Result of the GenerateClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GenerateClientCertificate
     */
    default GenerateClientCertificateResponse generateClientCertificate(
            Consumer<GenerateClientCertificateRequest.Builder> generateClientCertificateRequest) throws UnauthorizedException,
            TooManyRequestsException, LimitExceededException, AwsServiceException, SdkClientException, ApiGatewayException {
        return generateClientCertificate(GenerateClientCertificateRequest.builder()
                .applyMutation(generateClientCertificateRequest).build());
    }

    /**
     * <p>
     * Gets information about the current <a>Account</a> resource.
     * </p>
     *
     * @return Result of the GetAccount operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetAccount
     * @see #getAccount(GetAccountRequest)
     */
    default GetAccountResponse getAccount() throws UnauthorizedException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return getAccount(GetAccountRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the current <a>Account</a> resource.
     * </p>
     *
     * @param getAccountRequest
     *        Requests API Gateway to get information about the current <a>Account</a> resource.
     * @return Result of the GetAccount operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetAccount
     */
    default GetAccountResponse getAccount(GetAccountRequest getAccountRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the current <a>Account</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountRequest.Builder} avoiding the need to
     * create one manually via {@link GetAccountRequest#builder()}
     * </p>
     *
     * @param getAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountRequest.Builder} to create a request.
     *        Requests API Gateway to get information about the current <a>Account</a> resource.
     * @return Result of the GetAccount operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetAccount
     */
    default GetAccountResponse getAccount(Consumer<GetAccountRequest.Builder> getAccountRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getAccount(GetAccountRequest.builder().applyMutation(getAccountRequest).build());
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKey</a> resource.
     * </p>
     *
     * @param getApiKeyRequest
     *        A request to get information about the current <a>ApiKey</a> resource.
     * @return Result of the GetApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetApiKey
     */
    default GetApiKeyResponse getApiKey(GetApiKeyRequest getApiKeyRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKey</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link GetApiKeyRequest#builder()}
     * </p>
     *
     * @param getApiKeyRequest
     *        A {@link Consumer} that will call methods on {@link GetApiKeyRequest.Builder} to create a request. A
     *        request to get information about the current <a>ApiKey</a> resource.
     * @return Result of the GetApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetApiKey
     */
    default GetApiKeyResponse getApiKey(Consumer<GetApiKeyRequest.Builder> getApiKeyRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getApiKey(GetApiKeyRequest.builder().applyMutation(getApiKeyRequest).build());
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKeys</a> resource.
     * </p>
     *
     * @return Result of the GetApiKeys operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetApiKeys
     * @see #getApiKeys(GetApiKeysRequest)
     */
    default GetApiKeysResponse getApiKeys() throws BadRequestException, UnauthorizedException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return getApiKeys(GetApiKeysRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKeys</a> resource.
     * </p>
     *
     * @param getApiKeysRequest
     *        A request to get information about the current <a>ApiKeys</a> resource.
     * @return Result of the GetApiKeys operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetApiKeys
     */
    default GetApiKeysResponse getApiKeys(GetApiKeysRequest getApiKeysRequest) throws BadRequestException, UnauthorizedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKeys</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiKeysRequest.Builder} avoiding the need to
     * create one manually via {@link GetApiKeysRequest#builder()}
     * </p>
     *
     * @param getApiKeysRequest
     *        A {@link Consumer} that will call methods on {@link GetApiKeysRequest.Builder} to create a request. A
     *        request to get information about the current <a>ApiKeys</a> resource.
     * @return Result of the GetApiKeys operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetApiKeys
     */
    default GetApiKeysResponse getApiKeys(Consumer<GetApiKeysRequest.Builder> getApiKeysRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getApiKeys(GetApiKeysRequest.builder().applyMutation(getApiKeysRequest).build());
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKeys</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysIterable responses = client.getApiKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetApiKeysIterable responses = client.getApiKeysPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysIterable responses = client.getApiKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetApiKeys
     * @see #getApiKeysPaginator(GetApiKeysRequest)
     */
    default GetApiKeysIterable getApiKeysPaginator() throws BadRequestException, UnauthorizedException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return getApiKeysPaginator(GetApiKeysRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKeys</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysIterable responses = client.getApiKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetApiKeysIterable responses = client.getApiKeysPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysIterable responses = client.getApiKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)} operation.</b>
     * </p>
     *
     * @param getApiKeysRequest
     *        A request to get information about the current <a>ApiKeys</a> resource.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetApiKeys
     */
    default GetApiKeysIterable getApiKeysPaginator(GetApiKeysRequest getApiKeysRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKeys</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysIterable responses = client.getApiKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetApiKeysIterable responses = client.getApiKeysPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysIterable responses = client.getApiKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiKeysRequest.Builder} avoiding the need to
     * create one manually via {@link GetApiKeysRequest#builder()}
     * </p>
     *
     * @param getApiKeysRequest
     *        A {@link Consumer} that will call methods on {@link GetApiKeysRequest.Builder} to create a request. A
     *        request to get information about the current <a>ApiKeys</a> resource.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetApiKeys
     */
    default GetApiKeysIterable getApiKeysPaginator(Consumer<GetApiKeysRequest.Builder> getApiKeysRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getApiKeysPaginator(GetApiKeysRequest.builder().applyMutation(getApiKeysRequest).build());
    }

    /**
     * <p>
     * Describe an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizer.html">AWS CLI</a></div>
     *
     * @param getAuthorizerRequest
     *        Request to describe an existing <a>Authorizer</a> resource.
     * @return Result of the GetAuthorizer operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetAuthorizer
     */
    default GetAuthorizerResponse getAuthorizer(GetAuthorizerRequest getAuthorizerRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizer.html">AWS CLI</a></div><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthorizerRequest.Builder} avoiding the need to
     * create one manually via {@link GetAuthorizerRequest#builder()}
     * </p>
     *
     * @param getAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link GetAuthorizerRequest.Builder} to create a request.
     *        Request to describe an existing <a>Authorizer</a> resource.
     * @return Result of the GetAuthorizer operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetAuthorizer
     */
    default GetAuthorizerResponse getAuthorizer(Consumer<GetAuthorizerRequest.Builder> getAuthorizerRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getAuthorizer(GetAuthorizerRequest.builder().applyMutation(getAuthorizerRequest).build());
    }

    /**
     * <p>
     * Describe an existing <a>Authorizers</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizers.html">AWS CLI</a></div>
     *
     * @param getAuthorizersRequest
     *        Request to describe an existing <a>Authorizers</a> resource.
     * @return Result of the GetAuthorizers operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetAuthorizers
     */
    default GetAuthorizersResponse getAuthorizers(GetAuthorizersRequest getAuthorizersRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an existing <a>Authorizers</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizers.html">AWS CLI</a></div><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthorizersRequest.Builder} avoiding the need to
     * create one manually via {@link GetAuthorizersRequest#builder()}
     * </p>
     *
     * @param getAuthorizersRequest
     *        A {@link Consumer} that will call methods on {@link GetAuthorizersRequest.Builder} to create a request.
     *        Request to describe an existing <a>Authorizers</a> resource.
     * @return Result of the GetAuthorizers operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetAuthorizers
     */
    default GetAuthorizersResponse getAuthorizers(Consumer<GetAuthorizersRequest.Builder> getAuthorizersRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return getAuthorizers(GetAuthorizersRequest.builder().applyMutation(getAuthorizersRequest).build());
    }

    /**
     * <p>
     * Describe a <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param getBasePathMappingRequest
     *        Request to describe a <a>BasePathMapping</a> resource.
     * @return Result of the GetBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetBasePathMapping
     */
    default GetBasePathMappingResponse getBasePathMapping(GetBasePathMappingRequest getBasePathMappingRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe a <a>BasePathMapping</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBasePathMappingRequest.Builder} avoiding the
     * need to create one manually via {@link GetBasePathMappingRequest#builder()}
     * </p>
     *
     * @param getBasePathMappingRequest
     *        A {@link Consumer} that will call methods on {@link GetBasePathMappingRequest.Builder} to create a
     *        request. Request to describe a <a>BasePathMapping</a> resource.
     * @return Result of the GetBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetBasePathMapping
     */
    default GetBasePathMappingResponse getBasePathMapping(Consumer<GetBasePathMappingRequest.Builder> getBasePathMappingRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getBasePathMapping(GetBasePathMappingRequest.builder().applyMutation(getBasePathMappingRequest).build());
    }

    /**
     * <p>
     * Represents a collection of <a>BasePathMapping</a> resources.
     * </p>
     *
     * @param getBasePathMappingsRequest
     *        A request to get information about a collection of <a>BasePathMapping</a> resources.
     * @return Result of the GetBasePathMappings operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetBasePathMappings
     */
    default GetBasePathMappingsResponse getBasePathMappings(GetBasePathMappingsRequest getBasePathMappingsRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a collection of <a>BasePathMapping</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBasePathMappingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBasePathMappingsRequest#builder()}
     * </p>
     *
     * @param getBasePathMappingsRequest
     *        A {@link Consumer} that will call methods on {@link GetBasePathMappingsRequest.Builder} to create a
     *        request. A request to get information about a collection of <a>BasePathMapping</a> resources.
     * @return Result of the GetBasePathMappings operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetBasePathMappings
     */
    default GetBasePathMappingsResponse getBasePathMappings(
            Consumer<GetBasePathMappingsRequest.Builder> getBasePathMappingsRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getBasePathMappings(GetBasePathMappingsRequest.builder().applyMutation(getBasePathMappingsRequest).build());
    }

    /**
     * <p>
     * Represents a collection of <a>BasePathMapping</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBasePathMappings(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsIterable responses = client.getBasePathMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsIterable responses = client
     *             .getBasePathMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsIterable responses = client.getBasePathMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBasePathMappings(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getBasePathMappingsRequest
     *        A request to get information about a collection of <a>BasePathMapping</a> resources.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetBasePathMappings
     */
    default GetBasePathMappingsIterable getBasePathMappingsPaginator(GetBasePathMappingsRequest getBasePathMappingsRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a collection of <a>BasePathMapping</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBasePathMappings(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsIterable responses = client.getBasePathMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsIterable responses = client
     *             .getBasePathMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsIterable responses = client.getBasePathMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBasePathMappings(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBasePathMappingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBasePathMappingsRequest#builder()}
     * </p>
     *
     * @param getBasePathMappingsRequest
     *        A {@link Consumer} that will call methods on {@link GetBasePathMappingsRequest.Builder} to create a
     *        request. A request to get information about a collection of <a>BasePathMapping</a> resources.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetBasePathMappings
     */
    default GetBasePathMappingsIterable getBasePathMappingsPaginator(
            Consumer<GetBasePathMappingsRequest.Builder> getBasePathMappingsRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getBasePathMappingsPaginator(GetBasePathMappingsRequest.builder().applyMutation(getBasePathMappingsRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the current <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param getClientCertificateRequest
     *        A request to get information about the current <a>ClientCertificate</a> resource.
     * @return Result of the GetClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetClientCertificate
     */
    default GetClientCertificateResponse getClientCertificate(GetClientCertificateRequest getClientCertificateRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the current <a>ClientCertificate</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClientCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link GetClientCertificateRequest#builder()}
     * </p>
     *
     * @param getClientCertificateRequest
     *        A {@link Consumer} that will call methods on {@link GetClientCertificateRequest.Builder} to create a
     *        request. A request to get information about the current <a>ClientCertificate</a> resource.
     * @return Result of the GetClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetClientCertificate
     */
    default GetClientCertificateResponse getClientCertificate(
            Consumer<GetClientCertificateRequest.Builder> getClientCertificateRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getClientCertificate(GetClientCertificateRequest.builder().applyMutation(getClientCertificateRequest).build());
    }

    /**
     * <p>
     * Gets a collection of <a>ClientCertificate</a> resources.
     * </p>
     *
     * @return Result of the GetClientCertificates operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetClientCertificates
     * @see #getClientCertificates(GetClientCertificatesRequest)
     */
    default GetClientCertificatesResponse getClientCertificates() throws BadRequestException, UnauthorizedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getClientCertificates(GetClientCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Gets a collection of <a>ClientCertificate</a> resources.
     * </p>
     *
     * @param getClientCertificatesRequest
     *        A request to get information about a collection of <a>ClientCertificate</a> resources.
     * @return Result of the GetClientCertificates operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetClientCertificates
     */
    default GetClientCertificatesResponse getClientCertificates(GetClientCertificatesRequest getClientCertificatesRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a collection of <a>ClientCertificate</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClientCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link GetClientCertificatesRequest#builder()}
     * </p>
     *
     * @param getClientCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link GetClientCertificatesRequest.Builder} to create a
     *        request. A request to get information about a collection of <a>ClientCertificate</a> resources.
     * @return Result of the GetClientCertificates operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetClientCertificates
     */
    default GetClientCertificatesResponse getClientCertificates(
            Consumer<GetClientCertificatesRequest.Builder> getClientCertificatesRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getClientCertificates(GetClientCertificatesRequest.builder().applyMutation(getClientCertificatesRequest).build());
    }

    /**
     * <p>
     * Gets a collection of <a>ClientCertificate</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesIterable responses = client.getClientCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesIterable responses = client
     *             .getClientCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesIterable responses = client.getClientCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetClientCertificates
     * @see #getClientCertificatesPaginator(GetClientCertificatesRequest)
     */
    default GetClientCertificatesIterable getClientCertificatesPaginator() throws BadRequestException, UnauthorizedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getClientCertificatesPaginator(GetClientCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Gets a collection of <a>ClientCertificate</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesIterable responses = client.getClientCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesIterable responses = client
     *             .getClientCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesIterable responses = client.getClientCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getClientCertificatesRequest
     *        A request to get information about a collection of <a>ClientCertificate</a> resources.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetClientCertificates
     */
    default GetClientCertificatesIterable getClientCertificatesPaginator(GetClientCertificatesRequest getClientCertificatesRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a collection of <a>ClientCertificate</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesIterable responses = client.getClientCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesIterable responses = client
     *             .getClientCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesIterable responses = client.getClientCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClientCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link GetClientCertificatesRequest#builder()}
     * </p>
     *
     * @param getClientCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link GetClientCertificatesRequest.Builder} to create a
     *        request. A request to get information about a collection of <a>ClientCertificate</a> resources.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetClientCertificates
     */
    default GetClientCertificatesIterable getClientCertificatesPaginator(
            Consumer<GetClientCertificatesRequest.Builder> getClientCertificatesRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getClientCertificatesPaginator(GetClientCertificatesRequest.builder().applyMutation(getClientCertificatesRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a <a>Deployment</a> resource.
     * </p>
     *
     * @param getDeploymentRequest
     *        Requests API Gateway to get information about a <a>Deployment</a> resource.
     * @return Result of the GetDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDeployment
     */
    default GetDeploymentResponse getDeployment(GetDeploymentRequest getDeploymentRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a <a>Deployment</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentRequest#builder()}
     * </p>
     *
     * @param getDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentRequest.Builder} to create a request.
     *        Requests API Gateway to get information about a <a>Deployment</a> resource.
     * @return Result of the GetDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDeployment
     */
    default GetDeploymentResponse getDeployment(Consumer<GetDeploymentRequest.Builder> getDeploymentRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return getDeployment(GetDeploymentRequest.builder().applyMutation(getDeploymentRequest).build());
    }

    /**
     * <p>
     * Gets information about a <a>Deployments</a> collection.
     * </p>
     *
     * @param getDeploymentsRequest
     *        Requests API Gateway to get information about a <a>Deployments</a> collection.
     * @return Result of the GetDeployments operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDeployments
     */
    default GetDeploymentsResponse getDeployments(GetDeploymentsRequest getDeploymentsRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a <a>Deployments</a> collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentsRequest#builder()}
     * </p>
     *
     * @param getDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentsRequest.Builder} to create a request.
     *        Requests API Gateway to get information about a <a>Deployments</a> collection.
     * @return Result of the GetDeployments operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDeployments
     */
    default GetDeploymentsResponse getDeployments(Consumer<GetDeploymentsRequest.Builder> getDeploymentsRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return getDeployments(GetDeploymentsRequest.builder().applyMutation(getDeploymentsRequest).build());
    }

    /**
     * <p>
     * Gets information about a <a>Deployments</a> collection.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDeployments(software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsIterable responses = client.getDeploymentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsIterable responses = client
     *             .getDeploymentsPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsIterable responses = client.getDeploymentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDeployments(software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest)} operation.</b>
     * </p>
     *
     * @param getDeploymentsRequest
     *        Requests API Gateway to get information about a <a>Deployments</a> collection.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDeployments
     */
    default GetDeploymentsIterable getDeploymentsPaginator(GetDeploymentsRequest getDeploymentsRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a <a>Deployments</a> collection.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDeployments(software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsIterable responses = client.getDeploymentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsIterable responses = client
     *             .getDeploymentsPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsIterable responses = client.getDeploymentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDeployments(software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentsRequest#builder()}
     * </p>
     *
     * @param getDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link GetDeploymentsRequest.Builder} to create a request.
     *        Requests API Gateway to get information about a <a>Deployments</a> collection.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDeployments
     */
    default GetDeploymentsIterable getDeploymentsPaginator(Consumer<GetDeploymentsRequest.Builder> getDeploymentsRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return getDeploymentsPaginator(GetDeploymentsRequest.builder().applyMutation(getDeploymentsRequest).build());
    }

    /**
     * Invokes the GetDocumentationPart operation.
     *
     * @param getDocumentationPartRequest
     *        Gets a specified documentation part of a given API.
     * @return Result of the GetDocumentationPart operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationPart
     */
    default GetDocumentationPartResponse getDocumentationPart(GetDocumentationPartRequest getDocumentationPartRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the GetDocumentationPart operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentationPartRequest.Builder} avoiding the
     * need to create one manually via {@link GetDocumentationPartRequest#builder()}
     * </p>
     *
     * @param getDocumentationPartRequest
     *        A {@link Consumer} that will call methods on {@link GetDocumentationPartRequest.Builder} to create a
     *        request. Gets a specified documentation part of a given API.
     * @return Result of the GetDocumentationPart operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationPart
     */
    default GetDocumentationPartResponse getDocumentationPart(
            Consumer<GetDocumentationPartRequest.Builder> getDocumentationPartRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getDocumentationPart(GetDocumentationPartRequest.builder().applyMutation(getDocumentationPartRequest).build());
    }

    /**
     * Invokes the GetDocumentationParts operation.
     *
     * @param getDocumentationPartsRequest
     *        Gets the documentation parts of an API. The result may be filtered by the type, name, or path of API
     *        entities (targets).
     * @return Result of the GetDocumentationParts operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationParts
     */
    default GetDocumentationPartsResponse getDocumentationParts(GetDocumentationPartsRequest getDocumentationPartsRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the GetDocumentationParts operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentationPartsRequest.Builder} avoiding the
     * need to create one manually via {@link GetDocumentationPartsRequest#builder()}
     * </p>
     *
     * @param getDocumentationPartsRequest
     *        A {@link Consumer} that will call methods on {@link GetDocumentationPartsRequest.Builder} to create a
     *        request. Gets the documentation parts of an API. The result may be filtered by the type, name, or path of
     *        API entities (targets).
     * @return Result of the GetDocumentationParts operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationParts
     */
    default GetDocumentationPartsResponse getDocumentationParts(
            Consumer<GetDocumentationPartsRequest.Builder> getDocumentationPartsRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getDocumentationParts(GetDocumentationPartsRequest.builder().applyMutation(getDocumentationPartsRequest).build());
    }

    /**
     * Invokes the GetDocumentationVersion operation.
     *
     * @param getDocumentationVersionRequest
     *        Gets a documentation snapshot of an API.
     * @return Result of the GetDocumentationVersion operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationVersion
     */
    default GetDocumentationVersionResponse getDocumentationVersion(GetDocumentationVersionRequest getDocumentationVersionRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the GetDocumentationVersion operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link GetDocumentationVersionRequest#builder()}
     * </p>
     *
     * @param getDocumentationVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetDocumentationVersionRequest.Builder} to create a
     *        request. Gets a documentation snapshot of an API.
     * @return Result of the GetDocumentationVersion operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationVersion
     */
    default GetDocumentationVersionResponse getDocumentationVersion(
            Consumer<GetDocumentationVersionRequest.Builder> getDocumentationVersionRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getDocumentationVersion(GetDocumentationVersionRequest.builder().applyMutation(getDocumentationVersionRequest)
                .build());
    }

    /**
     * Invokes the GetDocumentationVersions operation.
     *
     * @param getDocumentationVersionsRequest
     *        Gets the documentation versions of an API.
     * @return Result of the GetDocumentationVersions operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationVersions
     */
    default GetDocumentationVersionsResponse getDocumentationVersions(
            GetDocumentationVersionsRequest getDocumentationVersionsRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the GetDocumentationVersions operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetDocumentationVersionsRequest#builder()}
     * </p>
     *
     * @param getDocumentationVersionsRequest
     *        A {@link Consumer} that will call methods on {@link GetDocumentationVersionsRequest.Builder} to create a
     *        request. Gets the documentation versions of an API.
     * @return Result of the GetDocumentationVersions operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationVersions
     */
    default GetDocumentationVersionsResponse getDocumentationVersions(
            Consumer<GetDocumentationVersionsRequest.Builder> getDocumentationVersionsRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getDocumentationVersions(GetDocumentationVersionsRequest.builder().applyMutation(getDocumentationVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Represents a domain name that is contained in a simpler, more intuitive URL that can be called.
     * </p>
     *
     * @param getDomainNameRequest
     *        Request to get the name of a <a>DomainName</a> resource.
     * @return Result of the GetDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDomainName
     */
    default GetDomainNameResponse getDomainName(GetDomainNameRequest getDomainNameRequest) throws UnauthorizedException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a domain name that is contained in a simpler, more intuitive URL that can be called.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainNameRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainNameRequest#builder()}
     * </p>
     *
     * @param getDomainNameRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainNameRequest.Builder} to create a request.
     *        Request to get the name of a <a>DomainName</a> resource.
     * @return Result of the GetDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDomainName
     */
    default GetDomainNameResponse getDomainName(Consumer<GetDomainNameRequest.Builder> getDomainNameRequest)
            throws UnauthorizedException, NotFoundException, ServiceUnavailableException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return getDomainName(GetDomainNameRequest.builder().applyMutation(getDomainNameRequest).build());
    }

    /**
     * <p>
     * Represents a collection of <a>DomainName</a> resources.
     * </p>
     *
     * @return Result of the GetDomainNames operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDomainNames
     * @see #getDomainNames(GetDomainNamesRequest)
     */
    default GetDomainNamesResponse getDomainNames() throws BadRequestException, UnauthorizedException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return getDomainNames(GetDomainNamesRequest.builder().build());
    }

    /**
     * <p>
     * Represents a collection of <a>DomainName</a> resources.
     * </p>
     *
     * @param getDomainNamesRequest
     *        Request to describe a collection of <a>DomainName</a> resources.
     * @return Result of the GetDomainNames operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDomainNames
     */
    default GetDomainNamesResponse getDomainNames(GetDomainNamesRequest getDomainNamesRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a collection of <a>DomainName</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainNamesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainNamesRequest#builder()}
     * </p>
     *
     * @param getDomainNamesRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainNamesRequest.Builder} to create a request.
     *        Request to describe a collection of <a>DomainName</a> resources.
     * @return Result of the GetDomainNames operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDomainNames
     */
    default GetDomainNamesResponse getDomainNames(Consumer<GetDomainNamesRequest.Builder> getDomainNamesRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getDomainNames(GetDomainNamesRequest.builder().applyMutation(getDomainNamesRequest).build());
    }

    /**
     * <p>
     * Represents a collection of <a>DomainName</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesIterable responses = client.getDomainNamesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesIterable responses = client
     *             .getDomainNamesPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesIterable responses = client.getDomainNamesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDomainNames
     * @see #getDomainNamesPaginator(GetDomainNamesRequest)
     */
    default GetDomainNamesIterable getDomainNamesPaginator() throws BadRequestException, UnauthorizedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getDomainNamesPaginator(GetDomainNamesRequest.builder().build());
    }

    /**
     * <p>
     * Represents a collection of <a>DomainName</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesIterable responses = client.getDomainNamesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesIterable responses = client
     *             .getDomainNamesPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesIterable responses = client.getDomainNamesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation.</b>
     * </p>
     *
     * @param getDomainNamesRequest
     *        Request to describe a collection of <a>DomainName</a> resources.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDomainNames
     */
    default GetDomainNamesIterable getDomainNamesPaginator(GetDomainNamesRequest getDomainNamesRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a collection of <a>DomainName</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesIterable responses = client.getDomainNamesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesIterable responses = client
     *             .getDomainNamesPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesIterable responses = client.getDomainNamesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainNamesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainNamesRequest#builder()}
     * </p>
     *
     * @param getDomainNamesRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainNamesRequest.Builder} to create a request.
     *        Request to describe a collection of <a>DomainName</a> resources.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDomainNames
     */
    default GetDomainNamesIterable getDomainNamesPaginator(Consumer<GetDomainNamesRequest.Builder> getDomainNamesRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getDomainNamesPaginator(GetDomainNamesRequest.builder().applyMutation(getDomainNamesRequest).build());
    }

    /**
     * <p>
     * Exports a deployed version of a <a>RestApi</a> in a specified format.
     * </p>
     *
     * @param getExportRequest
     *        Request a new export of a <a>RestApi</a> for a particular <a>Stage</a>.
     * @return Result of the GetExport operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetExport
     */
    default GetExportResponse getExport(GetExportRequest getExportRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports a deployed version of a <a>RestApi</a> in a specified format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExportRequest.Builder} avoiding the need to
     * create one manually via {@link GetExportRequest#builder()}
     * </p>
     *
     * @param getExportRequest
     *        A {@link Consumer} that will call methods on {@link GetExportRequest.Builder} to create a request. Request
     *        a new export of a <a>RestApi</a> for a particular <a>Stage</a>.
     * @return Result of the GetExport operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetExport
     */
    default GetExportResponse getExport(Consumer<GetExportRequest.Builder> getExportRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return getExport(GetExportRequest.builder().applyMutation(getExportRequest).build());
    }

    /**
     * <p>
     * Gets a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * </p>
     *
     * @param getGatewayResponseRequest
     *        Gets a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * @return Result of the GetGatewayResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetGatewayResponse
     */
    default GetGatewayResponseResponse getGatewayResponse(GetGatewayResponseRequest getGatewayResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGatewayResponseRequest.Builder} avoiding the
     * need to create one manually via {@link GetGatewayResponseRequest#builder()}
     * </p>
     *
     * @param getGatewayResponseRequest
     *        A {@link Consumer} that will call methods on {@link GetGatewayResponseRequest.Builder} to create a
     *        request. Gets a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * @return Result of the GetGatewayResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetGatewayResponse
     */
    default GetGatewayResponseResponse getGatewayResponse(Consumer<GetGatewayResponseRequest.Builder> getGatewayResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getGatewayResponse(GetGatewayResponseRequest.builder().applyMutation(getGatewayResponseRequest).build());
    }

    /**
     * <p>
     * Gets the <a>GatewayResponses</a> collection on the given <a>RestApi</a>. If an API developer has not added any
     * definitions for gateway responses, the result will be the API Gateway-generated default <a>GatewayResponses</a>
     * collection for the supported response types.
     * </p>
     *
     * @param getGatewayResponsesRequest
     *        Gets the <a>GatewayResponses</a> collection on the given <a>RestApi</a>. If an API developer has not added
     *        any definitions for gateway responses, the result will be the API Gateway-generated default
     *        <a>GatewayResponses</a> collection for the supported response types.
     * @return Result of the GetGatewayResponses operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetGatewayResponses
     */
    default GetGatewayResponsesResponse getGatewayResponses(GetGatewayResponsesRequest getGatewayResponsesRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the <a>GatewayResponses</a> collection on the given <a>RestApi</a>. If an API developer has not added any
     * definitions for gateway responses, the result will be the API Gateway-generated default <a>GatewayResponses</a>
     * collection for the supported response types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGatewayResponsesRequest.Builder} avoiding the
     * need to create one manually via {@link GetGatewayResponsesRequest#builder()}
     * </p>
     *
     * @param getGatewayResponsesRequest
     *        A {@link Consumer} that will call methods on {@link GetGatewayResponsesRequest.Builder} to create a
     *        request. Gets the <a>GatewayResponses</a> collection on the given <a>RestApi</a>. If an API developer has
     *        not added any definitions for gateway responses, the result will be the API Gateway-generated default
     *        <a>GatewayResponses</a> collection for the supported response types.
     * @return Result of the GetGatewayResponses operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetGatewayResponses
     */
    default GetGatewayResponsesResponse getGatewayResponses(
            Consumer<GetGatewayResponsesRequest.Builder> getGatewayResponsesRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getGatewayResponses(GetGatewayResponsesRequest.builder().applyMutation(getGatewayResponsesRequest).build());
    }

    /**
     * <p>
     * Get the integration settings.
     * </p>
     *
     * @param getIntegrationRequest
     *        Represents a request to get the integration configuration.
     * @return Result of the GetIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetIntegration
     */
    default GetIntegrationResponse getIntegration(GetIntegrationRequest getIntegrationRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the integration settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationRequest.Builder} avoiding the need to
     * create one manually via {@link GetIntegrationRequest#builder()}
     * </p>
     *
     * @param getIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link GetIntegrationRequest.Builder} to create a request.
     *        Represents a request to get the integration configuration.
     * @return Result of the GetIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetIntegration
     */
    default GetIntegrationResponse getIntegration(Consumer<GetIntegrationRequest.Builder> getIntegrationRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getIntegration(GetIntegrationRequest.builder().applyMutation(getIntegrationRequest).build());
    }

    /**
     * <p>
     * Represents a get integration response.
     * </p>
     *
     * @param getIntegrationResponseRequest
     *        Represents a get integration response request.
     * @return Result of the GetIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetIntegrationResponse
     */
    default GetIntegrationResponseResponse getIntegrationResponse(GetIntegrationResponseRequest getIntegrationResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a get integration response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationResponseRequest.Builder} avoiding the
     * need to create one manually via {@link GetIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param getIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on {@link GetIntegrationResponseRequest.Builder} to create a
     *        request. Represents a get integration response request.
     * @return Result of the GetIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetIntegrationResponse
     */
    default GetIntegrationResponseResponse getIntegrationResponse(
            Consumer<GetIntegrationResponseRequest.Builder> getIntegrationResponseRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getIntegrationResponse(GetIntegrationResponseRequest.builder().applyMutation(getIntegrationResponseRequest)
                .build());
    }

    /**
     * <p>
     * Describe an existing <a>Method</a> resource.
     * </p>
     *
     * @param getMethodRequest
     *        Request to describe an existing <a>Method</a> resource.
     * @return Result of the GetMethod operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetMethod
     */
    default GetMethodResponse getMethod(GetMethodRequest getMethodRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an existing <a>Method</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMethodRequest.Builder} avoiding the need to
     * create one manually via {@link GetMethodRequest#builder()}
     * </p>
     *
     * @param getMethodRequest
     *        A {@link Consumer} that will call methods on {@link GetMethodRequest.Builder} to create a request. Request
     *        to describe an existing <a>Method</a> resource.
     * @return Result of the GetMethod operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetMethod
     */
    default GetMethodResponse getMethod(Consumer<GetMethodRequest.Builder> getMethodRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getMethod(GetMethodRequest.builder().applyMutation(getMethodRequest).build());
    }

    /**
     * <p>
     * Describes a <a>MethodResponse</a> resource.
     * </p>
     *
     * @param getMethodResponseRequest
     *        Request to describe a <a>MethodResponse</a> resource.
     * @return Result of the GetMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetMethodResponse
     */
    default GetMethodResponseResponse getMethodResponse(GetMethodResponseRequest getMethodResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a <a>MethodResponse</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMethodResponseRequest.Builder} avoiding the need
     * to create one manually via {@link GetMethodResponseRequest#builder()}
     * </p>
     *
     * @param getMethodResponseRequest
     *        A {@link Consumer} that will call methods on {@link GetMethodResponseRequest.Builder} to create a request.
     *        Request to describe a <a>MethodResponse</a> resource.
     * @return Result of the GetMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetMethodResponse
     */
    default GetMethodResponseResponse getMethodResponse(Consumer<GetMethodResponseRequest.Builder> getMethodResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getMethodResponse(GetMethodResponseRequest.builder().applyMutation(getMethodResponseRequest).build());
    }

    /**
     * <p>
     * Describes an existing model defined for a <a>RestApi</a> resource.
     * </p>
     *
     * @param getModelRequest
     *        Request to list information about a model in an existing <a>RestApi</a> resource.
     * @return Result of the GetModel operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModel
     */
    default GetModelResponse getModel(GetModelRequest getModelRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing model defined for a <a>RestApi</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelRequest#builder()}
     * </p>
     *
     * @param getModelRequest
     *        A {@link Consumer} that will call methods on {@link GetModelRequest.Builder} to create a request. Request
     *        to list information about a model in an existing <a>RestApi</a> resource.
     * @return Result of the GetModel operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModel
     */
    default GetModelResponse getModel(Consumer<GetModelRequest.Builder> getModelRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getModel(GetModelRequest.builder().applyMutation(getModelRequest).build());
    }

    /**
     * <p>
     * Generates a sample mapping template that can be used to transform a payload into the structure of a model.
     * </p>
     *
     * @param getModelTemplateRequest
     *        Request to generate a sample mapping template used to transform the payload.
     * @return Result of the GetModelTemplate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModelTemplate
     */
    default GetModelTemplateResponse getModelTemplate(GetModelTemplateRequest getModelTemplateRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a sample mapping template that can be used to transform a payload into the structure of a model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetModelTemplateRequest#builder()}
     * </p>
     *
     * @param getModelTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetModelTemplateRequest.Builder} to create a request.
     *        Request to generate a sample mapping template used to transform the payload.
     * @return Result of the GetModelTemplate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModelTemplate
     */
    default GetModelTemplateResponse getModelTemplate(Consumer<GetModelTemplateRequest.Builder> getModelTemplateRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return getModelTemplate(GetModelTemplateRequest.builder().applyMutation(getModelTemplateRequest).build());
    }

    /**
     * <p>
     * Describes existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * </p>
     *
     * @param getModelsRequest
     *        Request to list existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * @return Result of the GetModels operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModels
     */
    default GetModelsResponse getModels(GetModelsRequest getModelsRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelsRequest#builder()}
     * </p>
     *
     * @param getModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetModelsRequest.Builder} to create a request. Request
     *        to list existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * @return Result of the GetModels operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModels
     */
    default GetModelsResponse getModels(Consumer<GetModelsRequest.Builder> getModelsRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getModels(GetModelsRequest.builder().applyMutation(getModelsRequest).build());
    }

    /**
     * <p>
     * Describes existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getModels(software.amazon.awssdk.services.apigateway.model.GetModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getModels(software.amazon.awssdk.services.apigateway.model.GetModelsRequest)} operation.</b>
     * </p>
     *
     * @param getModelsRequest
     *        Request to list existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModels
     */
    default GetModelsIterable getModelsPaginator(GetModelsRequest getModelsRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getModels(software.amazon.awssdk.services.apigateway.model.GetModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getModels(software.amazon.awssdk.services.apigateway.model.GetModelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelsRequest#builder()}
     * </p>
     *
     * @param getModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetModelsRequest.Builder} to create a request. Request
     *        to list existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModels
     */
    default GetModelsIterable getModelsPaginator(Consumer<GetModelsRequest.Builder> getModelsRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getModelsPaginator(GetModelsRequest.builder().applyMutation(getModelsRequest).build());
    }

    /**
     * <p>
     * Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param getRequestValidatorRequest
     *        Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the GetRequestValidator operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRequestValidator
     */
    default GetRequestValidatorResponse getRequestValidator(GetRequestValidatorRequest getRequestValidatorRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRequestValidatorRequest.Builder} avoiding the
     * need to create one manually via {@link GetRequestValidatorRequest#builder()}
     * </p>
     *
     * @param getRequestValidatorRequest
     *        A {@link Consumer} that will call methods on {@link GetRequestValidatorRequest.Builder} to create a
     *        request. Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the GetRequestValidator operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRequestValidator
     */
    default GetRequestValidatorResponse getRequestValidator(
            Consumer<GetRequestValidatorRequest.Builder> getRequestValidatorRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getRequestValidator(GetRequestValidatorRequest.builder().applyMutation(getRequestValidatorRequest).build());
    }

    /**
     * <p>
     * Gets the <a>RequestValidators</a> collection of a given <a>RestApi</a>.
     * </p>
     *
     * @param getRequestValidatorsRequest
     *        Gets the <a>RequestValidators</a> collection of a given <a>RestApi</a>.
     * @return Result of the GetRequestValidators operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRequestValidators
     */
    default GetRequestValidatorsResponse getRequestValidators(GetRequestValidatorsRequest getRequestValidatorsRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the <a>RequestValidators</a> collection of a given <a>RestApi</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRequestValidatorsRequest.Builder} avoiding the
     * need to create one manually via {@link GetRequestValidatorsRequest#builder()}
     * </p>
     *
     * @param getRequestValidatorsRequest
     *        A {@link Consumer} that will call methods on {@link GetRequestValidatorsRequest.Builder} to create a
     *        request. Gets the <a>RequestValidators</a> collection of a given <a>RestApi</a>.
     * @return Result of the GetRequestValidators operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRequestValidators
     */
    default GetRequestValidatorsResponse getRequestValidators(
            Consumer<GetRequestValidatorsRequest.Builder> getRequestValidatorsRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getRequestValidators(GetRequestValidatorsRequest.builder().applyMutation(getRequestValidatorsRequest).build());
    }

    /**
     * <p>
     * Lists information about a resource.
     * </p>
     *
     * @param getResourceRequest
     *        Request to list information about a resource.
     * @return Result of the GetResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetResource
     */
    default GetResourceResponse getResource(GetResourceRequest getResourceRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceRequest.Builder} avoiding the need to
     * create one manually via {@link GetResourceRequest#builder()}
     * </p>
     *
     * @param getResourceRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceRequest.Builder} to create a request.
     *        Request to list information about a resource.
     * @return Result of the GetResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetResource
     */
    default GetResourceResponse getResource(Consumer<GetResourceRequest.Builder> getResourceRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getResource(GetResourceRequest.builder().applyMutation(getResourceRequest).build());
    }

    /**
     * <p>
     * Lists information about a collection of <a>Resource</a> resources.
     * </p>
     *
     * @param getResourcesRequest
     *        Request to list information about a collection of resources.
     * @return Result of the GetResources operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetResources
     */
    default GetResourcesResponse getResources(GetResourcesRequest getResourcesRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about a collection of <a>Resource</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link GetResourcesRequest#builder()}
     * </p>
     *
     * @param getResourcesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcesRequest.Builder} to create a request.
     *        Request to list information about a collection of resources.
     * @return Result of the GetResources operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetResources
     */
    default GetResourcesResponse getResources(Consumer<GetResourcesRequest.Builder> getResourcesRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return getResources(GetResourcesRequest.builder().applyMutation(getResourcesRequest).build());
    }

    /**
     * <p>
     * Lists information about a collection of <a>Resource</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getResources(software.amazon.awssdk.services.apigateway.model.GetResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetResourcesIterable responses = client.getResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetResourcesIterable responses = client.getResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetResourcesIterable responses = client.getResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResources(software.amazon.awssdk.services.apigateway.model.GetResourcesRequest)} operation.</b>
     * </p>
     *
     * @param getResourcesRequest
     *        Request to list information about a collection of resources.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetResources
     */
    default GetResourcesIterable getResourcesPaginator(GetResourcesRequest getResourcesRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about a collection of <a>Resource</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getResources(software.amazon.awssdk.services.apigateway.model.GetResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetResourcesIterable responses = client.getResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetResourcesIterable responses = client.getResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetResourcesIterable responses = client.getResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResources(software.amazon.awssdk.services.apigateway.model.GetResourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link GetResourcesRequest#builder()}
     * </p>
     *
     * @param getResourcesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcesRequest.Builder} to create a request.
     *        Request to list information about a collection of resources.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetResources
     */
    default GetResourcesIterable getResourcesPaginator(Consumer<GetResourcesRequest.Builder> getResourcesRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return getResourcesPaginator(GetResourcesRequest.builder().applyMutation(getResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the <a>RestApi</a> resource in the collection.
     * </p>
     *
     * @param getRestApiRequest
     *        The GET request to list an existing <a>RestApi</a> defined for your collection.
     * @return Result of the GetRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRestApi
     */
    default GetRestApiResponse getRestApi(GetRestApiRequest getRestApiRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the <a>RestApi</a> resource in the collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRestApiRequest.Builder} avoiding the need to
     * create one manually via {@link GetRestApiRequest#builder()}
     * </p>
     *
     * @param getRestApiRequest
     *        A {@link Consumer} that will call methods on {@link GetRestApiRequest.Builder} to create a request. The
     *        GET request to list an existing <a>RestApi</a> defined for your collection.
     * @return Result of the GetRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRestApi
     */
    default GetRestApiResponse getRestApi(Consumer<GetRestApiRequest.Builder> getRestApiRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getRestApi(GetRestApiRequest.builder().applyMutation(getRestApiRequest).build());
    }

    /**
     * <p>
     * Lists the <a>RestApis</a> resources for your collection.
     * </p>
     *
     * @return Result of the GetRestApis operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRestApis
     * @see #getRestApis(GetRestApisRequest)
     */
    default GetRestApisResponse getRestApis() throws BadRequestException, UnauthorizedException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return getRestApis(GetRestApisRequest.builder().build());
    }

    /**
     * <p>
     * Lists the <a>RestApis</a> resources for your collection.
     * </p>
     *
     * @param getRestApisRequest
     *        The GET request to list existing <a>RestApis</a> defined for your collection.
     * @return Result of the GetRestApis operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRestApis
     */
    default GetRestApisResponse getRestApis(GetRestApisRequest getRestApisRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the <a>RestApis</a> resources for your collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRestApisRequest.Builder} avoiding the need to
     * create one manually via {@link GetRestApisRequest#builder()}
     * </p>
     *
     * @param getRestApisRequest
     *        A {@link Consumer} that will call methods on {@link GetRestApisRequest.Builder} to create a request. The
     *        GET request to list existing <a>RestApis</a> defined for your collection.
     * @return Result of the GetRestApis operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRestApis
     */
    default GetRestApisResponse getRestApis(Consumer<GetRestApisRequest.Builder> getRestApisRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getRestApis(GetRestApisRequest.builder().applyMutation(getRestApisRequest).build());
    }

    /**
     * <p>
     * Lists the <a>RestApis</a> resources for your collection.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisIterable responses = client.getRestApisPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetRestApisIterable responses = client.getRestApisPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetRestApisResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisIterable responses = client.getRestApisPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRestApis
     * @see #getRestApisPaginator(GetRestApisRequest)
     */
    default GetRestApisIterable getRestApisPaginator() throws BadRequestException, UnauthorizedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getRestApisPaginator(GetRestApisRequest.builder().build());
    }

    /**
     * <p>
     * Lists the <a>RestApis</a> resources for your collection.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisIterable responses = client.getRestApisPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetRestApisIterable responses = client.getRestApisPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetRestApisResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisIterable responses = client.getRestApisPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)} operation.</b>
     * </p>
     *
     * @param getRestApisRequest
     *        The GET request to list existing <a>RestApis</a> defined for your collection.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRestApis
     */
    default GetRestApisIterable getRestApisPaginator(GetRestApisRequest getRestApisRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the <a>RestApis</a> resources for your collection.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisIterable responses = client.getRestApisPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetRestApisIterable responses = client.getRestApisPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetRestApisResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisIterable responses = client.getRestApisPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRestApisRequest.Builder} avoiding the need to
     * create one manually via {@link GetRestApisRequest#builder()}
     * </p>
     *
     * @param getRestApisRequest
     *        A {@link Consumer} that will call methods on {@link GetRestApisRequest.Builder} to create a request. The
     *        GET request to list existing <a>RestApis</a> defined for your collection.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRestApis
     */
    default GetRestApisIterable getRestApisPaginator(Consumer<GetRestApisRequest.Builder> getRestApisRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getRestApisPaginator(GetRestApisRequest.builder().applyMutation(getRestApisRequest).build());
    }

    /**
     * <p>
     * Generates a client SDK for a <a>RestApi</a> and <a>Stage</a>.
     * </p>
     *
     * @param getSdkRequest
     *        Request a new generated client SDK for a <a>RestApi</a> and <a>Stage</a>.
     * @return Result of the GetSdk operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetSdk
     */
    default GetSdkResponse getSdk(GetSdkRequest getSdkRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a client SDK for a <a>RestApi</a> and <a>Stage</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSdkRequest.Builder} avoiding the need to create
     * one manually via {@link GetSdkRequest#builder()}
     * </p>
     *
     * @param getSdkRequest
     *        A {@link Consumer} that will call methods on {@link GetSdkRequest.Builder} to create a request. Request a
     *        new generated client SDK for a <a>RestApi</a> and <a>Stage</a>.
     * @return Result of the GetSdk operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetSdk
     */
    default GetSdkResponse getSdk(Consumer<GetSdkRequest.Builder> getSdkRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getSdk(GetSdkRequest.builder().applyMutation(getSdkRequest).build());
    }

    /**
     * Invokes the GetSdkType operation.
     *
     * @param getSdkTypeRequest
     *        Get an <a>SdkType</a> instance.
     * @return Result of the GetSdkType operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetSdkType
     */
    default GetSdkTypeResponse getSdkType(GetSdkTypeRequest getSdkTypeRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the GetSdkType operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSdkTypeRequest.Builder} avoiding the need to
     * create one manually via {@link GetSdkTypeRequest#builder()}
     * </p>
     *
     * @param getSdkTypeRequest
     *        A {@link Consumer} that will call methods on {@link GetSdkTypeRequest.Builder} to create a request. Get an
     *        <a>SdkType</a> instance.
     * @return Result of the GetSdkType operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetSdkType
     */
    default GetSdkTypeResponse getSdkType(Consumer<GetSdkTypeRequest.Builder> getSdkTypeRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getSdkType(GetSdkTypeRequest.builder().applyMutation(getSdkTypeRequest).build());
    }

    /**
     * Invokes the GetSdkTypes operation.
     *
     * @return Result of the GetSdkTypes operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetSdkTypes
     * @see #getSdkTypes(GetSdkTypesRequest)
     */
    default GetSdkTypesResponse getSdkTypes() throws UnauthorizedException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return getSdkTypes(GetSdkTypesRequest.builder().build());
    }

    /**
     * Invokes the GetSdkTypes operation.
     *
     * @param getSdkTypesRequest
     *        Get the <a>SdkTypes</a> collection.
     * @return Result of the GetSdkTypes operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetSdkTypes
     */
    default GetSdkTypesResponse getSdkTypes(GetSdkTypesRequest getSdkTypesRequest) throws UnauthorizedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the GetSdkTypes operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSdkTypesRequest.Builder} avoiding the need to
     * create one manually via {@link GetSdkTypesRequest#builder()}
     * </p>
     *
     * @param getSdkTypesRequest
     *        A {@link Consumer} that will call methods on {@link GetSdkTypesRequest.Builder} to create a request. Get
     *        the <a>SdkTypes</a> collection.
     * @return Result of the GetSdkTypes operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetSdkTypes
     */
    default GetSdkTypesResponse getSdkTypes(Consumer<GetSdkTypesRequest.Builder> getSdkTypesRequest)
            throws UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getSdkTypes(GetSdkTypesRequest.builder().applyMutation(getSdkTypesRequest).build());
    }

    /**
     * <p>
     * Gets information about a <a>Stage</a> resource.
     * </p>
     *
     * @param getStageRequest
     *        Requests API Gateway to get information about a <a>Stage</a> resource.
     * @return Result of the GetStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetStage
     */
    default GetStageResponse getStage(GetStageRequest getStageRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a <a>Stage</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStageRequest.Builder} avoiding the need to
     * create one manually via {@link GetStageRequest#builder()}
     * </p>
     *
     * @param getStageRequest
     *        A {@link Consumer} that will call methods on {@link GetStageRequest.Builder} to create a request. Requests
     *        API Gateway to get information about a <a>Stage</a> resource.
     * @return Result of the GetStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetStage
     */
    default GetStageResponse getStage(Consumer<GetStageRequest.Builder> getStageRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getStage(GetStageRequest.builder().applyMutation(getStageRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more <a>Stage</a> resources.
     * </p>
     *
     * @param getStagesRequest
     *        Requests API Gateway to get information about one or more <a>Stage</a> resources.
     * @return Result of the GetStages operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetStages
     */
    default GetStagesResponse getStages(GetStagesRequest getStagesRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more <a>Stage</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStagesRequest.Builder} avoiding the need to
     * create one manually via {@link GetStagesRequest#builder()}
     * </p>
     *
     * @param getStagesRequest
     *        A {@link Consumer} that will call methods on {@link GetStagesRequest.Builder} to create a request.
     *        Requests API Gateway to get information about one or more <a>Stage</a> resources.
     * @return Result of the GetStages operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetStages
     */
    default GetStagesResponse getStages(Consumer<GetStagesRequest.Builder> getStagesRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getStages(GetStagesRequest.builder().applyMutation(getStagesRequest).build());
    }

    /**
     * <p>
     * Gets the <a>Tags</a> collection for a given resource.
     * </p>
     *
     * @param getTagsRequest
     *        Gets the <a>Tags</a> collection for a given resource.
     * @return Result of the GetTags operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetTags
     */
    default GetTagsResponse getTags(GetTagsRequest getTagsRequest) throws BadRequestException, UnauthorizedException,
            TooManyRequestsException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the <a>Tags</a> collection for a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTagsRequest.Builder} avoiding the need to create
     * one manually via {@link GetTagsRequest#builder()}
     * </p>
     *
     * @param getTagsRequest
     *        A {@link Consumer} that will call methods on {@link GetTagsRequest.Builder} to create a request. Gets the
     *        <a>Tags</a> collection for a given resource.
     * @return Result of the GetTags operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetTags
     */
    default GetTagsResponse getTags(Consumer<GetTagsRequest.Builder> getTagsRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, NotFoundException, LimitExceededException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return getTags(GetTagsRequest.builder().applyMutation(getTagsRequest).build());
    }

    /**
     * <p>
     * Gets the usage data of a usage plan in a specified time interval.
     * </p>
     *
     * @param getUsageRequest
     *        The GET request to get the usage data of a usage plan in a specified time interval.
     * @return Result of the GetUsage operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsage
     */
    default GetUsageResponse getUsage(GetUsageRequest getUsageRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the usage data of a usage plan in a specified time interval.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageRequest.Builder} avoiding the need to
     * create one manually via {@link GetUsageRequest#builder()}
     * </p>
     *
     * @param getUsageRequest
     *        A {@link Consumer} that will call methods on {@link GetUsageRequest.Builder} to create a request. The GET
     *        request to get the usage data of a usage plan in a specified time interval.
     * @return Result of the GetUsage operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsage
     */
    default GetUsageResponse getUsage(Consumer<GetUsageRequest.Builder> getUsageRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getUsage(GetUsageRequest.builder().applyMutation(getUsageRequest).build());
    }

    /**
     * <p>
     * Gets the usage data of a usage plan in a specified time interval.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getUsage(software.amazon.awssdk.services.apigateway.model.GetUsageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsageIterable responses = client.getUsagePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetUsageIterable responses = client.getUsagePaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetUsageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsageIterable responses = client.getUsagePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsage(software.amazon.awssdk.services.apigateway.model.GetUsageRequest)} operation.</b>
     * </p>
     *
     * @param getUsageRequest
     *        The GET request to get the usage data of a usage plan in a specified time interval.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsage
     */
    default GetUsageIterable getUsagePaginator(GetUsageRequest getUsageRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the usage data of a usage plan in a specified time interval.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getUsage(software.amazon.awssdk.services.apigateway.model.GetUsageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsageIterable responses = client.getUsagePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetUsageIterable responses = client.getUsagePaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetUsageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsageIterable responses = client.getUsagePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsage(software.amazon.awssdk.services.apigateway.model.GetUsageRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageRequest.Builder} avoiding the need to
     * create one manually via {@link GetUsageRequest#builder()}
     * </p>
     *
     * @param getUsageRequest
     *        A {@link Consumer} that will call methods on {@link GetUsageRequest.Builder} to create a request. The GET
     *        request to get the usage data of a usage plan in a specified time interval.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsage
     */
    default GetUsageIterable getUsagePaginator(Consumer<GetUsageRequest.Builder> getUsageRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getUsagePaginator(GetUsageRequest.builder().applyMutation(getUsageRequest).build());
    }

    /**
     * <p>
     * Gets a usage plan of a given plan identifier.
     * </p>
     *
     * @param getUsagePlanRequest
     *        The GET request to get a usage plan of a given plan identifier.
     * @return Result of the GetUsagePlan operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlan
     */
    default GetUsagePlanResponse getUsagePlan(GetUsagePlanRequest getUsagePlanRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a usage plan of a given plan identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsagePlanRequest.Builder} avoiding the need to
     * create one manually via {@link GetUsagePlanRequest#builder()}
     * </p>
     *
     * @param getUsagePlanRequest
     *        A {@link Consumer} that will call methods on {@link GetUsagePlanRequest.Builder} to create a request. The
     *        GET request to get a usage plan of a given plan identifier.
     * @return Result of the GetUsagePlan operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlan
     */
    default GetUsagePlanResponse getUsagePlan(Consumer<GetUsagePlanRequest.Builder> getUsagePlanRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return getUsagePlan(GetUsagePlanRequest.builder().applyMutation(getUsagePlanRequest).build());
    }

    /**
     * <p>
     * Gets a usage plan key of a given key identifier.
     * </p>
     *
     * @param getUsagePlanKeyRequest
     *        The GET request to get a usage plan key of a given key identifier.
     * @return Result of the GetUsagePlanKey operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlanKey
     */
    default GetUsagePlanKeyResponse getUsagePlanKey(GetUsagePlanKeyRequest getUsagePlanKeyRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a usage plan key of a given key identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsagePlanKeyRequest.Builder} avoiding the need
     * to create one manually via {@link GetUsagePlanKeyRequest#builder()}
     * </p>
     *
     * @param getUsagePlanKeyRequest
     *        A {@link Consumer} that will call methods on {@link GetUsagePlanKeyRequest.Builder} to create a request.
     *        The GET request to get a usage plan key of a given key identifier.
     * @return Result of the GetUsagePlanKey operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlanKey
     */
    default GetUsagePlanKeyResponse getUsagePlanKey(Consumer<GetUsagePlanKeyRequest.Builder> getUsagePlanKeyRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return getUsagePlanKey(GetUsagePlanKeyRequest.builder().applyMutation(getUsagePlanKeyRequest).build());
    }

    /**
     * <p>
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     * </p>
     *
     * @param getUsagePlanKeysRequest
     *        The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.
     * @return Result of the GetUsagePlanKeys operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlanKeys
     */
    default GetUsagePlanKeysResponse getUsagePlanKeys(GetUsagePlanKeysRequest getUsagePlanKeysRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsagePlanKeysRequest.Builder} avoiding the need
     * to create one manually via {@link GetUsagePlanKeysRequest#builder()}
     * </p>
     *
     * @param getUsagePlanKeysRequest
     *        A {@link Consumer} that will call methods on {@link GetUsagePlanKeysRequest.Builder} to create a request.
     *        The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.
     * @return Result of the GetUsagePlanKeys operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlanKeys
     */
    default GetUsagePlanKeysResponse getUsagePlanKeys(Consumer<GetUsagePlanKeysRequest.Builder> getUsagePlanKeysRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return getUsagePlanKeys(GetUsagePlanKeysRequest.builder().applyMutation(getUsagePlanKeysRequest).build());
    }

    /**
     * <p>
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUsagePlanKeys(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysIterable responses = client.getUsagePlanKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysIterable responses = client
     *             .getUsagePlanKeysPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysIterable responses = client.getUsagePlanKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsagePlanKeys(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUsagePlanKeysRequest
     *        The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlanKeys
     */
    default GetUsagePlanKeysIterable getUsagePlanKeysPaginator(GetUsagePlanKeysRequest getUsagePlanKeysRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUsagePlanKeys(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysIterable responses = client.getUsagePlanKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysIterable responses = client
     *             .getUsagePlanKeysPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysIterable responses = client.getUsagePlanKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsagePlanKeys(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsagePlanKeysRequest.Builder} avoiding the need
     * to create one manually via {@link GetUsagePlanKeysRequest#builder()}
     * </p>
     *
     * @param getUsagePlanKeysRequest
     *        A {@link Consumer} that will call methods on {@link GetUsagePlanKeysRequest.Builder} to create a request.
     *        The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlanKeys
     */
    default GetUsagePlanKeysIterable getUsagePlanKeysPaginator(Consumer<GetUsagePlanKeysRequest.Builder> getUsagePlanKeysRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return getUsagePlanKeysPaginator(GetUsagePlanKeysRequest.builder().applyMutation(getUsagePlanKeysRequest).build());
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     *
     * @return Result of the GetUsagePlans operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlans
     * @see #getUsagePlans(GetUsagePlansRequest)
     */
    default GetUsagePlansResponse getUsagePlans() throws BadRequestException, UnauthorizedException, TooManyRequestsException,
            ConflictException, NotFoundException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getUsagePlans(GetUsagePlansRequest.builder().build());
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     *
     * @param getUsagePlansRequest
     *        The GET request to get all the usage plans of the caller's account.
     * @return Result of the GetUsagePlans operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlans
     */
    default GetUsagePlansResponse getUsagePlans(GetUsagePlansRequest getUsagePlansRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, ConflictException, NotFoundException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsagePlansRequest.Builder} avoiding the need to
     * create one manually via {@link GetUsagePlansRequest#builder()}
     * </p>
     *
     * @param getUsagePlansRequest
     *        A {@link Consumer} that will call methods on {@link GetUsagePlansRequest.Builder} to create a request. The
     *        GET request to get all the usage plans of the caller's account.
     * @return Result of the GetUsagePlans operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlans
     */
    default GetUsagePlansResponse getUsagePlans(Consumer<GetUsagePlansRequest.Builder> getUsagePlansRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, ConflictException, NotFoundException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return getUsagePlans(GetUsagePlansRequest.builder().applyMutation(getUsagePlansRequest).build());
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansIterable responses = client.getUsagePlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansIterable responses = client
     *             .getUsagePlansPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansIterable responses = client.getUsagePlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlans
     * @see #getUsagePlansPaginator(GetUsagePlansRequest)
     */
    default GetUsagePlansIterable getUsagePlansPaginator() throws BadRequestException, UnauthorizedException,
            TooManyRequestsException, ConflictException, NotFoundException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getUsagePlansPaginator(GetUsagePlansRequest.builder().build());
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansIterable responses = client.getUsagePlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansIterable responses = client
     *             .getUsagePlansPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansIterable responses = client.getUsagePlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation.</b>
     * </p>
     *
     * @param getUsagePlansRequest
     *        The GET request to get all the usage plans of the caller's account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlans
     */
    default GetUsagePlansIterable getUsagePlansPaginator(GetUsagePlansRequest getUsagePlansRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, ConflictException, NotFoundException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansIterable responses = client.getUsagePlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansIterable responses = client
     *             .getUsagePlansPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansIterable responses = client.getUsagePlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsagePlansRequest.Builder} avoiding the need to
     * create one manually via {@link GetUsagePlansRequest#builder()}
     * </p>
     *
     * @param getUsagePlansRequest
     *        A {@link Consumer} that will call methods on {@link GetUsagePlansRequest.Builder} to create a request. The
     *        GET request to get all the usage plans of the caller's account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlans
     */
    default GetUsagePlansIterable getUsagePlansPaginator(Consumer<GetUsagePlansRequest.Builder> getUsagePlansRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, ConflictException, NotFoundException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return getUsagePlansPaginator(GetUsagePlansRequest.builder().applyMutation(getUsagePlansRequest).build());
    }

    /**
     * <p>
     * Gets a specified VPC link under the caller's account in a region.
     * </p>
     *
     * @param getVpcLinkRequest
     *        Gets a specified VPC link under the caller's account in a region.
     * @return Result of the GetVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetVpcLink
     */
    default GetVpcLinkResponse getVpcLink(GetVpcLinkRequest getVpcLinkRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a specified VPC link under the caller's account in a region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link GetVpcLinkRequest#builder()}
     * </p>
     *
     * @param getVpcLinkRequest
     *        A {@link Consumer} that will call methods on {@link GetVpcLinkRequest.Builder} to create a request. Gets a
     *        specified VPC link under the caller's account in a region.
     * @return Result of the GetVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetVpcLink
     */
    default GetVpcLinkResponse getVpcLink(Consumer<GetVpcLinkRequest.Builder> getVpcLinkRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getVpcLink(GetVpcLinkRequest.builder().applyMutation(getVpcLinkRequest).build());
    }

    /**
     * <p>
     * Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * </p>
     *
     * @return Result of the GetVpcLinks operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetVpcLinks
     * @see #getVpcLinks(GetVpcLinksRequest)
     */
    default GetVpcLinksResponse getVpcLinks() throws BadRequestException, UnauthorizedException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return getVpcLinks(GetVpcLinksRequest.builder().build());
    }

    /**
     * <p>
     * Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * </p>
     *
     * @param getVpcLinksRequest
     *        Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * @return Result of the GetVpcLinks operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetVpcLinks
     */
    default GetVpcLinksResponse getVpcLinks(GetVpcLinksRequest getVpcLinksRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVpcLinksRequest.Builder} avoiding the need to
     * create one manually via {@link GetVpcLinksRequest#builder()}
     * </p>
     *
     * @param getVpcLinksRequest
     *        A {@link Consumer} that will call methods on {@link GetVpcLinksRequest.Builder} to create a request. Gets
     *        the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * @return Result of the GetVpcLinks operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetVpcLinks
     */
    default GetVpcLinksResponse getVpcLinks(Consumer<GetVpcLinksRequest.Builder> getVpcLinksRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getVpcLinks(GetVpcLinksRequest.builder().applyMutation(getVpcLinksRequest).build());
    }

    /**
     * <p>
     * Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksIterable responses = client.getVpcLinksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksIterable responses = client.getVpcLinksPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksIterable responses = client.getVpcLinksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetVpcLinks
     * @see #getVpcLinksPaginator(GetVpcLinksRequest)
     */
    default GetVpcLinksIterable getVpcLinksPaginator() throws BadRequestException, UnauthorizedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return getVpcLinksPaginator(GetVpcLinksRequest.builder().build());
    }

    /**
     * <p>
     * Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksIterable responses = client.getVpcLinksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksIterable responses = client.getVpcLinksPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksIterable responses = client.getVpcLinksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)} operation.</b>
     * </p>
     *
     * @param getVpcLinksRequest
     *        Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetVpcLinks
     */
    default GetVpcLinksIterable getVpcLinksPaginator(GetVpcLinksRequest getVpcLinksRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksIterable responses = client.getVpcLinksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksIterable responses = client.getVpcLinksPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksIterable responses = client.getVpcLinksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVpcLinksRequest.Builder} avoiding the need to
     * create one manually via {@link GetVpcLinksRequest#builder()}
     * </p>
     *
     * @param getVpcLinksRequest
     *        A {@link Consumer} that will call methods on {@link GetVpcLinksRequest.Builder} to create a request. Gets
     *        the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetVpcLinks
     */
    default GetVpcLinksIterable getVpcLinksPaginator(Consumer<GetVpcLinksRequest.Builder> getVpcLinksRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return getVpcLinksPaginator(GetVpcLinksRequest.builder().applyMutation(getVpcLinksRequest).build());
    }

    /**
     * <p>
     * Import API keys from an external source, such as a CSV-formatted file.
     * </p>
     *
     * @param importApiKeysRequest
     *        The POST request to import API keys from an external source, such as a CSV-formatted file.
     * @return Result of the ImportApiKeys operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.ImportApiKeys
     */
    default ImportApiKeysResponse importApiKeys(ImportApiKeysRequest importApiKeysRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Import API keys from an external source, such as a CSV-formatted file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportApiKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ImportApiKeysRequest#builder()}
     * </p>
     *
     * @param importApiKeysRequest
     *        A {@link Consumer} that will call methods on {@link ImportApiKeysRequest.Builder} to create a request. The
     *        POST request to import API keys from an external source, such as a CSV-formatted file.
     * @return Result of the ImportApiKeys operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.ImportApiKeys
     */
    default ImportApiKeysResponse importApiKeys(Consumer<ImportApiKeysRequest.Builder> importApiKeysRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, LimitExceededException,
            BadRequestException, ConflictException, AwsServiceException, SdkClientException, ApiGatewayException {
        return importApiKeys(ImportApiKeysRequest.builder().applyMutation(importApiKeysRequest).build());
    }

    /**
     * Invokes the ImportDocumentationParts operation.
     *
     * @param importDocumentationPartsRequest
     *        Import documentation parts from an external (e.g., OpenAPI) definition file.
     * @return Result of the ImportDocumentationParts operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.ImportDocumentationParts
     */
    default ImportDocumentationPartsResponse importDocumentationParts(
            ImportDocumentationPartsRequest importDocumentationPartsRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, LimitExceededException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the ImportDocumentationParts operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportDocumentationPartsRequest.Builder} avoiding
     * the need to create one manually via {@link ImportDocumentationPartsRequest#builder()}
     * </p>
     *
     * @param importDocumentationPartsRequest
     *        A {@link Consumer} that will call methods on {@link ImportDocumentationPartsRequest.Builder} to create a
     *        request. Import documentation parts from an external (e.g., OpenAPI) definition file.
     * @return Result of the ImportDocumentationParts operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.ImportDocumentationParts
     */
    default ImportDocumentationPartsResponse importDocumentationParts(
            Consumer<ImportDocumentationPartsRequest.Builder> importDocumentationPartsRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, LimitExceededException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return importDocumentationParts(ImportDocumentationPartsRequest.builder().applyMutation(importDocumentationPartsRequest)
                .build());
    }

    /**
     * <p>
     * A feature of the API Gateway control service for creating a new API from an external API definition file.
     * </p>
     *
     * @param importRestApiRequest
     *        A POST request to import an API to API Gateway using an input of an API definition file.
     * @return Result of the ImportRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.ImportRestApi
     */
    default ImportRestApiResponse importRestApi(ImportRestApiRequest importRestApiRequest) throws UnauthorizedException,
            LimitExceededException, BadRequestException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A feature of the API Gateway control service for creating a new API from an external API definition file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportRestApiRequest.Builder} avoiding the need to
     * create one manually via {@link ImportRestApiRequest#builder()}
     * </p>
     *
     * @param importRestApiRequest
     *        A {@link Consumer} that will call methods on {@link ImportRestApiRequest.Builder} to create a request. A
     *        POST request to import an API to API Gateway using an input of an API definition file.
     * @return Result of the ImportRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.ImportRestApi
     */
    default ImportRestApiResponse importRestApi(Consumer<ImportRestApiRequest.Builder> importRestApiRequest)
            throws UnauthorizedException, LimitExceededException, BadRequestException, TooManyRequestsException,
            ConflictException, AwsServiceException, SdkClientException, ApiGatewayException {
        return importRestApi(ImportRestApiRequest.builder().applyMutation(importRestApiRequest).build());
    }

    /**
     * <p>
     * Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code on the given
     * <a>RestApi</a>.
     * </p>
     *
     * @param putGatewayResponseRequest
     *        Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code on the
     *        given <a>RestApi</a>.
     * @return Result of the PutGatewayResponse operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutGatewayResponse
     */
    default PutGatewayResponseResponse putGatewayResponse(PutGatewayResponseRequest putGatewayResponseRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code on the given
     * <a>RestApi</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutGatewayResponseRequest.Builder} avoiding the
     * need to create one manually via {@link PutGatewayResponseRequest#builder()}
     * </p>
     *
     * @param putGatewayResponseRequest
     *        A {@link Consumer} that will call methods on {@link PutGatewayResponseRequest.Builder} to create a
     *        request. Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code
     *        on the given <a>RestApi</a>.
     * @return Result of the PutGatewayResponse operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutGatewayResponse
     */
    default PutGatewayResponseResponse putGatewayResponse(Consumer<PutGatewayResponseRequest.Builder> putGatewayResponseRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return putGatewayResponse(PutGatewayResponseRequest.builder().applyMutation(putGatewayResponseRequest).build());
    }

    /**
     * <p>
     * Sets up a method's integration.
     * </p>
     *
     * @param putIntegrationRequest
     *        Sets up a method's integration.
     * @return Result of the PutIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutIntegration
     */
    default PutIntegrationResponse putIntegration(PutIntegrationRequest putIntegrationRequest) throws UnauthorizedException,
            BadRequestException, ConflictException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets up a method's integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutIntegrationRequest.Builder} avoiding the need to
     * create one manually via {@link PutIntegrationRequest#builder()}
     * </p>
     *
     * @param putIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link PutIntegrationRequest.Builder} to create a request.
     *        Sets up a method's integration.
     * @return Result of the PutIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutIntegration
     */
    default PutIntegrationResponse putIntegration(Consumer<PutIntegrationRequest.Builder> putIntegrationRequest)
            throws UnauthorizedException, BadRequestException, ConflictException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return putIntegration(PutIntegrationRequest.builder().applyMutation(putIntegrationRequest).build());
    }

    /**
     * <p>
     * Represents a put integration.
     * </p>
     *
     * @param putIntegrationResponseRequest
     *        Represents a put integration response request.
     * @return Result of the PutIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutIntegrationResponse
     */
    default PutIntegrationResponseResponse putIntegrationResponse(PutIntegrationResponseRequest putIntegrationResponseRequest)
            throws UnauthorizedException, NotFoundException, LimitExceededException, BadRequestException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a put integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutIntegrationResponseRequest.Builder} avoiding the
     * need to create one manually via {@link PutIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param putIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on {@link PutIntegrationResponseRequest.Builder} to create a
     *        request. Represents a put integration response request.
     * @return Result of the PutIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutIntegrationResponse
     */
    default PutIntegrationResponseResponse putIntegrationResponse(
            Consumer<PutIntegrationResponseRequest.Builder> putIntegrationResponseRequest) throws UnauthorizedException,
            NotFoundException, LimitExceededException, BadRequestException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return putIntegrationResponse(PutIntegrationResponseRequest.builder().applyMutation(putIntegrationResponseRequest)
                .build());
    }

    /**
     * <p>
     * Add a method to an existing <a>Resource</a> resource.
     * </p>
     *
     * @param putMethodRequest
     *        Request to add a method to an existing <a>Resource</a> resource.
     * @return Result of the PutMethod operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutMethod
     */
    default PutMethodResponse putMethod(PutMethodRequest putMethodRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, ConflictException, LimitExceededException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add a method to an existing <a>Resource</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMethodRequest.Builder} avoiding the need to
     * create one manually via {@link PutMethodRequest#builder()}
     * </p>
     *
     * @param putMethodRequest
     *        A {@link Consumer} that will call methods on {@link PutMethodRequest.Builder} to create a request. Request
     *        to add a method to an existing <a>Resource</a> resource.
     * @return Result of the PutMethod operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutMethod
     */
    default PutMethodResponse putMethod(Consumer<PutMethodRequest.Builder> putMethodRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, ConflictException, LimitExceededException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return putMethod(PutMethodRequest.builder().applyMutation(putMethodRequest).build());
    }

    /**
     * <p>
     * Adds a <a>MethodResponse</a> to an existing <a>Method</a> resource.
     * </p>
     *
     * @param putMethodResponseRequest
     *        Request to add a <a>MethodResponse</a> to an existing <a>Method</a> resource.
     * @return Result of the PutMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutMethodResponse
     */
    default PutMethodResponseResponse putMethodResponse(PutMethodResponseRequest putMethodResponseRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, LimitExceededException, BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a <a>MethodResponse</a> to an existing <a>Method</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMethodResponseRequest.Builder} avoiding the need
     * to create one manually via {@link PutMethodResponseRequest#builder()}
     * </p>
     *
     * @param putMethodResponseRequest
     *        A {@link Consumer} that will call methods on {@link PutMethodResponseRequest.Builder} to create a request.
     *        Request to add a <a>MethodResponse</a> to an existing <a>Method</a> resource.
     * @return Result of the PutMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutMethodResponse
     */
    default PutMethodResponseResponse putMethodResponse(Consumer<PutMethodResponseRequest.Builder> putMethodResponseRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, LimitExceededException, BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return putMethodResponse(PutMethodResponseRequest.builder().applyMutation(putMethodResponseRequest).build());
    }

    /**
     * <p>
     * A feature of the API Gateway control service for updating an existing API with an input of external API
     * definitions. The update can take the form of merging the supplied definition into the existing API or overwriting
     * the existing API.
     * </p>
     *
     * @param putRestApiRequest
     *        A PUT request to update an existing API, with external API definitions specified as the request body.
     * @return Result of the PutRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutRestApi
     */
    default PutRestApiResponse putRestApi(PutRestApiRequest putRestApiRequest) throws UnauthorizedException,
            LimitExceededException, NotFoundException, BadRequestException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A feature of the API Gateway control service for updating an existing API with an input of external API
     * definitions. The update can take the form of merging the supplied definition into the existing API or overwriting
     * the existing API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRestApiRequest.Builder} avoiding the need to
     * create one manually via {@link PutRestApiRequest#builder()}
     * </p>
     *
     * @param putRestApiRequest
     *        A {@link Consumer} that will call methods on {@link PutRestApiRequest.Builder} to create a request. A PUT
     *        request to update an existing API, with external API definitions specified as the request body.
     * @return Result of the PutRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutRestApi
     */
    default PutRestApiResponse putRestApi(Consumer<PutRestApiRequest.Builder> putRestApiRequest) throws UnauthorizedException,
            LimitExceededException, NotFoundException, BadRequestException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return putRestApi(PutRestApiRequest.builder().applyMutation(putRestApiRequest).build());
    }

    /**
     * <p>
     * Adds or updates a tag on a given resource.
     * </p>
     *
     * @param tagResourceRequest
     *        Adds or updates a tag on a given resource.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.TagResource
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, NotFoundException, LimitExceededException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates a tag on a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request. Adds
     *        or updates a tag on a given resource.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.TagResource
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, NotFoundException, LimitExceededException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Simulate the execution of an <a>Authorizer</a> in your <a>RestApi</a> with headers, parameters, and an incoming
     * request body.
     * </p>
     * <div class="seeAlso"> <a
     * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/use-custom-authorizer.html">Enable custom
     * authorizers</a> </div>
     *
     * @param testInvokeAuthorizerRequest
     *        Make a request to simulate the execution of an <a>Authorizer</a>.
     * @return Result of the TestInvokeAuthorizer operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.TestInvokeAuthorizer
     */
    default TestInvokeAuthorizerResponse testInvokeAuthorizer(TestInvokeAuthorizerRequest testInvokeAuthorizerRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Simulate the execution of an <a>Authorizer</a> in your <a>RestApi</a> with headers, parameters, and an incoming
     * request body.
     * </p>
     * <div class="seeAlso"> <a
     * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/use-custom-authorizer.html">Enable custom
     * authorizers</a> </div><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestInvokeAuthorizerRequest.Builder} avoiding the
     * need to create one manually via {@link TestInvokeAuthorizerRequest#builder()}
     * </p>
     *
     * @param testInvokeAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link TestInvokeAuthorizerRequest.Builder} to create a
     *        request. Make a request to simulate the execution of an <a>Authorizer</a>.
     * @return Result of the TestInvokeAuthorizer operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.TestInvokeAuthorizer
     */
    default TestInvokeAuthorizerResponse testInvokeAuthorizer(
            Consumer<TestInvokeAuthorizerRequest.Builder> testInvokeAuthorizerRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return testInvokeAuthorizer(TestInvokeAuthorizerRequest.builder().applyMutation(testInvokeAuthorizerRequest).build());
    }

    /**
     * <p>
     * Simulate the execution of a <a>Method</a> in your <a>RestApi</a> with headers, parameters, and an incoming
     * request body.
     * </p>
     *
     * @param testInvokeMethodRequest
     *        Make a request to simulate the execution of a <a>Method</a>.
     * @return Result of the TestInvokeMethod operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.TestInvokeMethod
     */
    default TestInvokeMethodResponse testInvokeMethod(TestInvokeMethodRequest testInvokeMethodRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Simulate the execution of a <a>Method</a> in your <a>RestApi</a> with headers, parameters, and an incoming
     * request body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestInvokeMethodRequest.Builder} avoiding the need
     * to create one manually via {@link TestInvokeMethodRequest#builder()}
     * </p>
     *
     * @param testInvokeMethodRequest
     *        A {@link Consumer} that will call methods on {@link TestInvokeMethodRequest.Builder} to create a request.
     *        Make a request to simulate the execution of a <a>Method</a>.
     * @return Result of the TestInvokeMethod operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.TestInvokeMethod
     */
    default TestInvokeMethodResponse testInvokeMethod(Consumer<TestInvokeMethodRequest.Builder> testInvokeMethodRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return testInvokeMethod(TestInvokeMethodRequest.builder().applyMutation(testInvokeMethodRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a given resource.
     * </p>
     *
     * @param untagResourceRequest
     *        Removes a tag from a given resource.
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UntagResource
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, NotFoundException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     *        Removes a tag from a given resource.
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UntagResource
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, NotFoundException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Changes information about the current <a>Account</a> resource.
     * </p>
     *
     * @param updateAccountRequest
     *        Requests API Gateway to change information about the current <a>Account</a> resource.
     * @return Result of the UpdateAccount operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateAccount
     */
    default UpdateAccountResponse updateAccount(UpdateAccountRequest updateAccountRequest) throws UnauthorizedException,
            BadRequestException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about the current <a>Account</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAccountRequest#builder()}
     * </p>
     *
     * @param updateAccountRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAccountRequest.Builder} to create a request.
     *        Requests API Gateway to change information about the current <a>Account</a> resource.
     * @return Result of the UpdateAccount operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateAccount
     */
    default UpdateAccountResponse updateAccount(Consumer<UpdateAccountRequest.Builder> updateAccountRequest)
            throws UnauthorizedException, BadRequestException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return updateAccount(UpdateAccountRequest.builder().applyMutation(updateAccountRequest).build());
    }

    /**
     * <p>
     * Changes information about an <a>ApiKey</a> resource.
     * </p>
     *
     * @param updateApiKeyRequest
     *        A request to change information about an <a>ApiKey</a> resource.
     * @return Result of the UpdateApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateApiKey
     */
    default UpdateApiKeyResponse updateApiKey(UpdateApiKeyRequest updateApiKeyRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about an <a>ApiKey</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateApiKeyRequest#builder()}
     * </p>
     *
     * @param updateApiKeyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApiKeyRequest.Builder} to create a request. A
     *        request to change information about an <a>ApiKey</a> resource.
     * @return Result of the UpdateApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateApiKey
     */
    default UpdateApiKeyResponse updateApiKey(Consumer<UpdateApiKeyRequest.Builder> updateApiKeyRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return updateApiKey(UpdateApiKeyRequest.builder().applyMutation(updateApiKeyRequest).build());
    }

    /**
     * <p>
     * Updates an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/update-authorizer.html">AWS CLI</a></div>
     *
     * @param updateAuthorizerRequest
     *        Request to update an existing <a>Authorizer</a> resource.
     * @return Result of the UpdateAuthorizer operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateAuthorizer
     */
    default UpdateAuthorizerResponse updateAuthorizer(UpdateAuthorizerRequest updateAuthorizerRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/update-authorizer.html">AWS CLI</a></div><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAuthorizerRequest#builder()}
     * </p>
     *
     * @param updateAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAuthorizerRequest.Builder} to create a request.
     *        Request to update an existing <a>Authorizer</a> resource.
     * @return Result of the UpdateAuthorizer operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateAuthorizer
     */
    default UpdateAuthorizerResponse updateAuthorizer(Consumer<UpdateAuthorizerRequest.Builder> updateAuthorizerRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return updateAuthorizer(UpdateAuthorizerRequest.builder().applyMutation(updateAuthorizerRequest).build());
    }

    /**
     * <p>
     * Changes information about the <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param updateBasePathMappingRequest
     *        A request to change information about the <a>BasePathMapping</a> resource.
     * @return Result of the UpdateBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateBasePathMapping
     */
    default UpdateBasePathMappingResponse updateBasePathMapping(UpdateBasePathMappingRequest updateBasePathMappingRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, BadRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about the <a>BasePathMapping</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBasePathMappingRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBasePathMappingRequest#builder()}
     * </p>
     *
     * @param updateBasePathMappingRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBasePathMappingRequest.Builder} to create a
     *        request. A request to change information about the <a>BasePathMapping</a> resource.
     * @return Result of the UpdateBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateBasePathMapping
     */
    default UpdateBasePathMappingResponse updateBasePathMapping(
            Consumer<UpdateBasePathMappingRequest.Builder> updateBasePathMappingRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return updateBasePathMapping(UpdateBasePathMappingRequest.builder().applyMutation(updateBasePathMappingRequest).build());
    }

    /**
     * <p>
     * Changes information about an <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param updateClientCertificateRequest
     *        A request to change information about an <a>ClientCertificate</a> resource.
     * @return Result of the UpdateClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateClientCertificate
     */
    default UpdateClientCertificateResponse updateClientCertificate(UpdateClientCertificateRequest updateClientCertificateRequest)
            throws UnauthorizedException, TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about an <a>ClientCertificate</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClientCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateClientCertificateRequest#builder()}
     * </p>
     *
     * @param updateClientCertificateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateClientCertificateRequest.Builder} to create a
     *        request. A request to change information about an <a>ClientCertificate</a> resource.
     * @return Result of the UpdateClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateClientCertificate
     */
    default UpdateClientCertificateResponse updateClientCertificate(
            Consumer<UpdateClientCertificateRequest.Builder> updateClientCertificateRequest) throws UnauthorizedException,
            TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return updateClientCertificate(UpdateClientCertificateRequest.builder().applyMutation(updateClientCertificateRequest)
                .build());
    }

    /**
     * <p>
     * Changes information about a <a>Deployment</a> resource.
     * </p>
     *
     * @param updateDeploymentRequest
     *        Requests API Gateway to change information about a <a>Deployment</a> resource.
     * @return Result of the UpdateDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDeployment
     */
    default UpdateDeploymentResponse updateDeployment(UpdateDeploymentRequest updateDeploymentRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about a <a>Deployment</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDeploymentRequest#builder()}
     * </p>
     *
     * @param updateDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeploymentRequest.Builder} to create a request.
     *        Requests API Gateway to change information about a <a>Deployment</a> resource.
     * @return Result of the UpdateDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDeployment
     */
    default UpdateDeploymentResponse updateDeployment(Consumer<UpdateDeploymentRequest.Builder> updateDeploymentRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, ApiGatewayException {
        return updateDeployment(UpdateDeploymentRequest.builder().applyMutation(updateDeploymentRequest).build());
    }

    /**
     * Invokes the UpdateDocumentationPart operation.
     *
     * @param updateDocumentationPartRequest
     *        Updates an existing documentation part of a given API.
     * @return Result of the UpdateDocumentationPart operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDocumentationPart
     */
    default UpdateDocumentationPartResponse updateDocumentationPart(UpdateDocumentationPartRequest updateDocumentationPartRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, ConflictException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the UpdateDocumentationPart operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDocumentationPartRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDocumentationPartRequest#builder()}
     * </p>
     *
     * @param updateDocumentationPartRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDocumentationPartRequest.Builder} to create a
     *        request. Updates an existing documentation part of a given API.
     * @return Result of the UpdateDocumentationPart operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDocumentationPart
     */
    default UpdateDocumentationPartResponse updateDocumentationPart(
            Consumer<UpdateDocumentationPartRequest.Builder> updateDocumentationPartRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, ConflictException, LimitExceededException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return updateDocumentationPart(UpdateDocumentationPartRequest.builder().applyMutation(updateDocumentationPartRequest)
                .build());
    }

    /**
     * Invokes the UpdateDocumentationVersion operation.
     *
     * @param updateDocumentationVersionRequest
     *        Updates an existing documentation version of an API.
     * @return Result of the UpdateDocumentationVersion operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDocumentationVersion
     */
    default UpdateDocumentationVersionResponse updateDocumentationVersion(
            UpdateDocumentationVersionRequest updateDocumentationVersionRequest) throws UnauthorizedException, NotFoundException,
            ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the UpdateDocumentationVersion operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDocumentationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDocumentationVersionRequest#builder()}
     * </p>
     *
     * @param updateDocumentationVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDocumentationVersionRequest.Builder} to create a
     *        request. Updates an existing documentation version of an API.
     * @return Result of the UpdateDocumentationVersion operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDocumentationVersion
     */
    default UpdateDocumentationVersionResponse updateDocumentationVersion(
            Consumer<UpdateDocumentationVersionRequest.Builder> updateDocumentationVersionRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return updateDocumentationVersion(UpdateDocumentationVersionRequest.builder()
                .applyMutation(updateDocumentationVersionRequest).build());
    }

    /**
     * <p>
     * Changes information about the <a>DomainName</a> resource.
     * </p>
     *
     * @param updateDomainNameRequest
     *        A request to change information about the <a>DomainName</a> resource.
     * @return Result of the UpdateDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDomainName
     */
    default UpdateDomainNameResponse updateDomainName(UpdateDomainNameRequest updateDomainNameRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, ConflictException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about the <a>DomainName</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDomainNameRequest#builder()}
     * </p>
     *
     * @param updateDomainNameRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDomainNameRequest.Builder} to create a request.
     *        A request to change information about the <a>DomainName</a> resource.
     * @return Result of the UpdateDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDomainName
     */
    default UpdateDomainNameResponse updateDomainName(Consumer<UpdateDomainNameRequest.Builder> updateDomainNameRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, ConflictException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return updateDomainName(UpdateDomainNameRequest.builder().applyMutation(updateDomainNameRequest).build());
    }

    /**
     * <p>
     * Updates a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * </p>
     *
     * @param updateGatewayResponseRequest
     *        Updates a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * @return Result of the UpdateGatewayResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateGatewayResponse
     */
    default UpdateGatewayResponseResponse updateGatewayResponse(UpdateGatewayResponseRequest updateGatewayResponseRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayResponseRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGatewayResponseRequest#builder()}
     * </p>
     *
     * @param updateGatewayResponseRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGatewayResponseRequest.Builder} to create a
     *        request. Updates a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * @return Result of the UpdateGatewayResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateGatewayResponse
     */
    default UpdateGatewayResponseResponse updateGatewayResponse(
            Consumer<UpdateGatewayResponseRequest.Builder> updateGatewayResponseRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return updateGatewayResponse(UpdateGatewayResponseRequest.builder().applyMutation(updateGatewayResponseRequest).build());
    }

    /**
     * <p>
     * Represents an update integration.
     * </p>
     *
     * @param updateIntegrationRequest
     *        Represents an update integration request.
     * @return Result of the UpdateIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateIntegration
     */
    default UpdateIntegrationResponse updateIntegration(UpdateIntegrationRequest updateIntegrationRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents an update integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateIntegrationRequest#builder()}
     * </p>
     *
     * @param updateIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIntegrationRequest.Builder} to create a request.
     *        Represents an update integration request.
     * @return Result of the UpdateIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateIntegration
     */
    default UpdateIntegrationResponse updateIntegration(Consumer<UpdateIntegrationRequest.Builder> updateIntegrationRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return updateIntegration(UpdateIntegrationRequest.builder().applyMutation(updateIntegrationRequest).build());
    }

    /**
     * <p>
     * Represents an update integration response.
     * </p>
     *
     * @param updateIntegrationResponseRequest
     *        Represents an update integration response request.
     * @return Result of the UpdateIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateIntegrationResponse
     */
    default UpdateIntegrationResponseResponse updateIntegrationResponse(
            UpdateIntegrationResponseRequest updateIntegrationResponseRequest) throws UnauthorizedException, NotFoundException,
            ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents an update integration response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIntegrationResponseRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param updateIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIntegrationResponseRequest.Builder} to create a
     *        request. Represents an update integration response request.
     * @return Result of the UpdateIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateIntegrationResponse
     */
    default UpdateIntegrationResponseResponse updateIntegrationResponse(
            Consumer<UpdateIntegrationResponseRequest.Builder> updateIntegrationResponseRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return updateIntegrationResponse(UpdateIntegrationResponseRequest.builder()
                .applyMutation(updateIntegrationResponseRequest).build());
    }

    /**
     * <p>
     * Updates an existing <a>Method</a> resource.
     * </p>
     *
     * @param updateMethodRequest
     *        Request to update an existing <a>Method</a> resource.
     * @return Result of the UpdateMethod operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateMethod
     */
    default UpdateMethodResponse updateMethod(UpdateMethodRequest updateMethodRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing <a>Method</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMethodRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMethodRequest#builder()}
     * </p>
     *
     * @param updateMethodRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMethodRequest.Builder} to create a request.
     *        Request to update an existing <a>Method</a> resource.
     * @return Result of the UpdateMethod operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateMethod
     */
    default UpdateMethodResponse updateMethod(Consumer<UpdateMethodRequest.Builder> updateMethodRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, ConflictException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return updateMethod(UpdateMethodRequest.builder().applyMutation(updateMethodRequest).build());
    }

    /**
     * <p>
     * Updates an existing <a>MethodResponse</a> resource.
     * </p>
     *
     * @param updateMethodResponseRequest
     *        A request to update an existing <a>MethodResponse</a> resource.
     * @return Result of the UpdateMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateMethodResponse
     */
    default UpdateMethodResponseResponse updateMethodResponse(UpdateMethodResponseRequest updateMethodResponseRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, LimitExceededException, BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing <a>MethodResponse</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMethodResponseRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMethodResponseRequest#builder()}
     * </p>
     *
     * @param updateMethodResponseRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMethodResponseRequest.Builder} to create a
     *        request. A request to update an existing <a>MethodResponse</a> resource.
     * @return Result of the UpdateMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateMethodResponse
     */
    default UpdateMethodResponseResponse updateMethodResponse(
            Consumer<UpdateMethodResponseRequest.Builder> updateMethodResponseRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, LimitExceededException, BadRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return updateMethodResponse(UpdateMethodResponseRequest.builder().applyMutation(updateMethodResponseRequest).build());
    }

    /**
     * <p>
     * Changes information about a model.
     * </p>
     *
     * @param updateModelRequest
     *        Request to update an existing model in an existing <a>RestApi</a> resource.
     * @return Result of the UpdateModel operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateModel
     */
    default UpdateModelResponse updateModel(UpdateModelRequest updateModelRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about a model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateModelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateModelRequest#builder()}
     * </p>
     *
     * @param updateModelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateModelRequest.Builder} to create a request.
     *        Request to update an existing model in an existing <a>RestApi</a> resource.
     * @return Result of the UpdateModel operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateModel
     */
    default UpdateModelResponse updateModel(Consumer<UpdateModelRequest.Builder> updateModelRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, ConflictException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return updateModel(UpdateModelRequest.builder().applyMutation(updateModelRequest).build());
    }

    /**
     * <p>
     * Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param updateRequestValidatorRequest
     *        Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the UpdateRequestValidator operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateRequestValidator
     */
    default UpdateRequestValidatorResponse updateRequestValidator(UpdateRequestValidatorRequest updateRequestValidatorRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRequestValidatorRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRequestValidatorRequest#builder()}
     * </p>
     *
     * @param updateRequestValidatorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRequestValidatorRequest.Builder} to create a
     *        request. Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the UpdateRequestValidator operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateRequestValidator
     */
    default UpdateRequestValidatorResponse updateRequestValidator(
            Consumer<UpdateRequestValidatorRequest.Builder> updateRequestValidatorRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return updateRequestValidator(UpdateRequestValidatorRequest.builder().applyMutation(updateRequestValidatorRequest)
                .build());
    }

    /**
     * <p>
     * Changes information about a <a>Resource</a> resource.
     * </p>
     *
     * @param updateResourceRequest
     *        Request to change information about a <a>Resource</a> resource.
     * @return Result of the UpdateResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateResource
     */
    default UpdateResourceResponse updateResource(UpdateResourceRequest updateResourceRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about a <a>Resource</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateResourceRequest#builder()}
     * </p>
     *
     * @param updateResourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourceRequest.Builder} to create a request.
     *        Request to change information about a <a>Resource</a> resource.
     * @return Result of the UpdateResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateResource
     */
    default UpdateResourceResponse updateResource(Consumer<UpdateResourceRequest.Builder> updateResourceRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, BadRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return updateResource(UpdateResourceRequest.builder().applyMutation(updateResourceRequest).build());
    }

    /**
     * <p>
     * Changes information about the specified API.
     * </p>
     *
     * @param updateRestApiRequest
     *        Request to update an existing <a>RestApi</a> resource in your collection.
     * @return Result of the UpdateRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateRestApi
     */
    default UpdateRestApiResponse updateRestApi(UpdateRestApiRequest updateRestApiRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about the specified API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRestApiRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRestApiRequest#builder()}
     * </p>
     *
     * @param updateRestApiRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRestApiRequest.Builder} to create a request.
     *        Request to update an existing <a>RestApi</a> resource in your collection.
     * @return Result of the UpdateRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateRestApi
     */
    default UpdateRestApiResponse updateRestApi(Consumer<UpdateRestApiRequest.Builder> updateRestApiRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, BadRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return updateRestApi(UpdateRestApiRequest.builder().applyMutation(updateRestApiRequest).build());
    }

    /**
     * <p>
     * Changes information about a <a>Stage</a> resource.
     * </p>
     *
     * @param updateStageRequest
     *        Requests API Gateway to change information about a <a>Stage</a> resource.
     * @return Result of the UpdateStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateStage
     */
    default UpdateStageResponse updateStage(UpdateStageRequest updateStageRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about a <a>Stage</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStageRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStageRequest#builder()}
     * </p>
     *
     * @param updateStageRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStageRequest.Builder} to create a request.
     *        Requests API Gateway to change information about a <a>Stage</a> resource.
     * @return Result of the UpdateStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateStage
     */
    default UpdateStageResponse updateStage(Consumer<UpdateStageRequest.Builder> updateStageRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, BadRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return updateStage(UpdateStageRequest.builder().applyMutation(updateStageRequest).build());
    }

    /**
     * <p>
     * Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.
     * </p>
     *
     * @param updateUsageRequest
     *        The PATCH request to grant a temporary extension to the remaining quota of a usage plan associated with a
     *        specified API key.
     * @return Result of the UpdateUsage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateUsage
     */
    default UpdateUsageResponse updateUsage(UpdateUsageRequest updateUsageRequest) throws UnauthorizedException,
            TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUsageRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUsageRequest#builder()}
     * </p>
     *
     * @param updateUsageRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUsageRequest.Builder} to create a request. The
     *        PATCH request to grant a temporary extension to the remaining quota of a usage plan associated with a
     *        specified API key.
     * @return Result of the UpdateUsage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateUsage
     */
    default UpdateUsageResponse updateUsage(Consumer<UpdateUsageRequest.Builder> updateUsageRequest)
            throws UnauthorizedException, TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return updateUsage(UpdateUsageRequest.builder().applyMutation(updateUsageRequest).build());
    }

    /**
     * <p>
     * Updates a usage plan of a given plan Id.
     * </p>
     *
     * @param updateUsagePlanRequest
     *        The PATCH request to update a usage plan of a given plan Id.
     * @return Result of the UpdateUsagePlan operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateUsagePlan
     */
    default UpdateUsagePlanResponse updateUsagePlan(UpdateUsagePlanRequest updateUsagePlanRequest) throws UnauthorizedException,
            TooManyRequestsException, BadRequestException, NotFoundException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a usage plan of a given plan Id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUsagePlanRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateUsagePlanRequest#builder()}
     * </p>
     *
     * @param updateUsagePlanRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUsagePlanRequest.Builder} to create a request.
     *        The PATCH request to update a usage plan of a given plan Id.
     * @return Result of the UpdateUsagePlan operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateUsagePlan
     */
    default UpdateUsagePlanResponse updateUsagePlan(Consumer<UpdateUsagePlanRequest.Builder> updateUsagePlanRequest)
            throws UnauthorizedException, TooManyRequestsException, BadRequestException, NotFoundException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return updateUsagePlan(UpdateUsagePlanRequest.builder().applyMutation(updateUsagePlanRequest).build());
    }

    /**
     * <p>
     * Updates an existing <a>VpcLink</a> of a specified identifier.
     * </p>
     *
     * @param updateVpcLinkRequest
     *        Updates an existing <a>VpcLink</a> of a specified identifier.
     * @return Result of the UpdateVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateVpcLink
     */
    default UpdateVpcLinkResponse updateVpcLink(UpdateVpcLinkRequest updateVpcLinkRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing <a>VpcLink</a> of a specified identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateVpcLinkRequest#builder()}
     * </p>
     *
     * @param updateVpcLinkRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVpcLinkRequest.Builder} to create a request.
     *        Updates an existing <a>VpcLink</a> of a specified identifier.
     * @return Result of the UpdateVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateVpcLink
     */
    default UpdateVpcLinkResponse updateVpcLink(Consumer<UpdateVpcLinkRequest.Builder> updateVpcLinkRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, ConflictException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return updateVpcLink(UpdateVpcLinkRequest.builder().applyMutation(updateVpcLinkRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("apigateway");
    }
}
