/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The identifier of an <a>ApiKey</a> used in a <a>UsagePlan</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportApiKeysResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<ImportApiKeysResponse.Builder, ImportApiKeysResponse> {
    private static final SdkField<List<String>> IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ImportApiKeysResponse::ids))
            .setter(setter(Builder::ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> WARNINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ImportApiKeysResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDS_FIELD, WARNINGS_FIELD));

    private final List<String> ids;

    private final List<String> warnings;

    private ImportApiKeysResponse(BuilderImpl builder) {
        super(builder);
        this.ids = builder.ids;
        this.warnings = builder.warnings;
    }

    /**
     * Returns true if the Ids property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIds() {
        return ids != null && !(ids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all the <a>ApiKey</a> identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of all the <a>ApiKey</a> identifiers.
     */
    public List<String> ids() {
        return ids;
    }

    /**
     * Returns true if the Warnings property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasWarnings() {
        return warnings != null && !(warnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of warning messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWarnings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of warning messages.
     */
    public List<String> warnings() {
        return warnings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ids());
        hashCode = 31 * hashCode + Objects.hashCode(warnings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportApiKeysResponse)) {
            return false;
        }
        ImportApiKeysResponse other = (ImportApiKeysResponse) obj;
        return Objects.equals(ids(), other.ids()) && Objects.equals(warnings(), other.warnings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImportApiKeysResponse").add("Ids", ids()).add("Warnings", warnings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ids":
            return Optional.ofNullable(clazz.cast(ids()));
        case "warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportApiKeysResponse, T> g) {
        return obj -> g.apply((ImportApiKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, ImportApiKeysResponse> {
        /**
         * <p>
         * A list of all the <a>ApiKey</a> identifiers.
         * </p>
         * 
         * @param ids
         *        A list of all the <a>ApiKey</a> identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(Collection<String> ids);

        /**
         * <p>
         * A list of all the <a>ApiKey</a> identifiers.
         * </p>
         * 
         * @param ids
         *        A list of all the <a>ApiKey</a> identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(String... ids);

        /**
         * <p>
         * A list of warning messages.
         * </p>
         * 
         * @param warnings
         *        A list of warning messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<String> warnings);

        /**
         * <p>
         * A list of warning messages.
         * </p>
         * 
         * @param warnings
         *        A list of warning messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(String... warnings);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private List<String> ids = DefaultSdkAutoConstructList.getInstance();

        private List<String> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportApiKeysResponse model) {
            super(model);
            ids(model.ids);
            warnings(model.warnings);
        }

        public final Collection<String> getIds() {
            return ids;
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = ListOfStringCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String... ids) {
            ids(Arrays.asList(ids));
            return this;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = ListOfStringCopier.copy(ids);
        }

        public final Collection<String> getWarnings() {
            return warnings;
        }

        @Override
        public final Builder warnings(Collection<String> warnings) {
            this.warnings = ListOfStringCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(String... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        public final void setWarnings(Collection<String> warnings) {
            this.warnings = ListOfStringCopier.copy(warnings);
        }

        @Override
        public ImportApiKeysResponse build() {
            return new ImportApiKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
