/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request a new export of a <a>RestApi</a> for a particular <a>Stage</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExportRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetExportRequest.Builder, GetExportRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetExportRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetExportRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("stage_name").build()).build();

    private static final SdkField<String> EXPORT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetExportRequest::exportType)).setter(setter(Builder::exportType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("export_type").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetExportRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ACCEPTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetExportRequest::accepts)).setter(setter(Builder::accepts))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            STAGE_NAME_FIELD, EXPORT_TYPE_FIELD, PARAMETERS_FIELD, ACCEPTS_FIELD));

    private final String restApiId;

    private final String stageName;

    private final String exportType;

    private final Map<String, String> parameters;

    private final String accepts;

    private GetExportRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.stageName = builder.stageName;
        this.exportType = builder.exportType;
        this.parameters = builder.parameters;
        this.accepts = builder.accepts;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] The name of the <a>Stage</a> that will be exported.
     * </p>
     * 
     * @return [Required] The name of the <a>Stage</a> that will be exported.
     */
    public String stageName() {
        return stageName;
    }

    /**
     * <p>
     * [Required] The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI
     * 2.0.
     * </p>
     * 
     * @return [Required] The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for
     *         Swagger/OpenAPI 2.0.
     */
    public String exportType() {
        return exportType;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map of query string parameters that specify properties of the export, depending on the requested
     * <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and <code>swagger</code>, any combination
     * of the following parameters are supported: <code>extensions='integrations'</code> or
     * <code>extensions='apigateway'</code> will export the API with x-amazon-apigateway-integration extensions.
     * <code>extensions='authorizers'</code> will export the API with x-amazon-apigateway-authorizer extensions.
     * <code>postman</code> will export the API with Postman extensions, allowing for import to the Postman tool
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A key-value map of query string parameters that specify properties of the export, depending on the
     *         requested <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and
     *         <code>swagger</code>, any combination of the following parameters are supported:
     *         <code>extensions='integrations'</code> or <code>extensions='apigateway'</code> will export the API with
     *         x-amazon-apigateway-integration extensions. <code>extensions='authorizers'</code> will export the API
     *         with x-amazon-apigateway-authorizer extensions. <code>postman</code> will export the API with Postman
     *         extensions, allowing for import to the Postman tool
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The content-type of the export, for example <code>application/json</code>. Currently
     * <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code> of
     * <code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header for
     * direct API requests.
     * </p>
     * 
     * @return The content-type of the export, for example <code>application/json</code>. Currently
     *         <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code>
     *         of<code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header
     *         for direct API requests.
     */
    public String accepts() {
        return accepts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(exportType());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(accepts());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportRequest)) {
            return false;
        }
        GetExportRequest other = (GetExportRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(exportType(), other.exportType()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(accepts(), other.accepts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetExportRequest").add("RestApiId", restApiId()).add("StageName", stageName())
                .add("ExportType", exportType()).add("Parameters", parameters()).add("Accepts", accepts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "exportType":
            return Optional.ofNullable(clazz.cast(exportType()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "accepts":
            return Optional.ofNullable(clazz.cast(accepts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExportRequest, T> g) {
        return obj -> g.apply((GetExportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetExportRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] The name of the <a>Stage</a> that will be exported.
         * </p>
         * 
         * @param stageName
         *        [Required] The name of the <a>Stage</a> that will be exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * [Required] The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for
         * Swagger/OpenAPI 2.0.
         * </p>
         * 
         * @param exportType
         *        [Required] The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for
         *        Swagger/OpenAPI 2.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportType(String exportType);

        /**
         * <p>
         * A key-value map of query string parameters that specify properties of the export, depending on the requested
         * <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and <code>swagger</code>, any
         * combination of the following parameters are supported: <code>extensions='integrations'</code> or
         * <code>extensions='apigateway'</code> will export the API with x-amazon-apigateway-integration extensions.
         * <code>extensions='authorizers'</code> will export the API with x-amazon-apigateway-authorizer extensions.
         * <code>postman</code> will export the API with Postman extensions, allowing for import to the Postman tool
         * </p>
         * 
         * @param parameters
         *        A key-value map of query string parameters that specify properties of the export, depending on the
         *        requested <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and
         *        <code>swagger</code>, any combination of the following parameters are supported:
         *        <code>extensions='integrations'</code> or <code>extensions='apigateway'</code> will export the API
         *        with x-amazon-apigateway-integration extensions. <code>extensions='authorizers'</code> will export the
         *        API with x-amazon-apigateway-authorizer extensions. <code>postman</code> will export the API with
         *        Postman extensions, allowing for import to the Postman tool
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The content-type of the export, for example <code>application/json</code>. Currently
         * <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code> of
         * <code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header for
         * direct API requests.
         * </p>
         * 
         * @param accepts
         *        The content-type of the export, for example <code>application/json</code>. Currently
         *        <code>application/json</code> and <code>application/yaml</code> are supported for
         *        <code>exportType</code> of<code>oas30</code> and <code>swagger</code>. This should be specified in the
         *        <code>Accept</code> header for direct API requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepts(String accepts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String stageName;

        private String exportType;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String accepts;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportRequest model) {
            super(model);
            restApiId(model.restApiId);
            stageName(model.stageName);
            exportType(model.exportType);
            parameters(model.parameters);
            accepts(model.accepts);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getStageName() {
            return stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getExportType() {
            return exportType;
        }

        @Override
        public final Builder exportType(String exportType) {
            this.exportType = exportType;
            return this;
        }

        public final void setExportType(String exportType) {
            this.exportType = exportType;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = MapOfStringToStringCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = MapOfStringToStringCopier.copy(parameters);
        }

        public final String getAccepts() {
            return accepts;
        }

        @Override
        public final Builder accepts(String accepts) {
            this.accepts = accepts;
            return this;
        }

        public final void setAccepts(String accepts) {
            this.accepts = accepts;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetExportRequest build() {
            return new GetExportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
