/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to add a <a>MethodResponse</a> to an existing <a>Method</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutMethodResponseRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<PutMethodResponseRequest.Builder, PutMethodResponseRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMethodResponseRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMethodResponseRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource_id").build()).build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMethodResponseRequest::httpMethod)).setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("http_method").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMethodResponseRequest::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("status_code").build()).build();

    private static final SdkField<Map<String, Boolean>> RESPONSE_PARAMETERS_FIELD = SdkField
            .<Map<String, Boolean>> builder(MarshallingType.MAP)
            .getter(getter(PutMethodResponseRequest::responseParameters))
            .setter(setter(Builder::responseParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> RESPONSE_MODELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(PutMethodResponseRequest::responseModels))
            .setter(setter(Builder::responseModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseModels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            RESOURCE_ID_FIELD, HTTP_METHOD_FIELD, STATUS_CODE_FIELD, RESPONSE_PARAMETERS_FIELD, RESPONSE_MODELS_FIELD));

    private final String restApiId;

    private final String resourceId;

    private final String httpMethod;

    private final String statusCodeValue;

    private final Map<String, Boolean> responseParameters;

    private final Map<String, String> responseModels;

    private PutMethodResponseRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.httpMethod = builder.httpMethod;
        this.statusCodeValue = builder.statusCodeValue;
        this.responseParameters = builder.responseParameters;
        this.responseModels = builder.responseModels;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] The <a>Resource</a> identifier for the <a>Method</a> resource.
     * </p>
     * 
     * @return [Required] The <a>Resource</a> identifier for the <a>Method</a> resource.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * [Required] The HTTP verb of the <a>Method</a> resource.
     * </p>
     * 
     * @return [Required] The HTTP verb of the <a>Method</a> resource.
     */
    public String httpMethod() {
        return httpMethod;
    }

    /**
     * <p>
     * [Required] The method response's status code.
     * </p>
     * 
     * @return [Required] The method response's status code.
     */
    public String statusCode() {
        return statusCodeValue;
    }

    /**
     * Returns true if the ResponseParameters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResponseParameters() {
        return responseParameters != null && !(responseParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map specifying required or optional response parameters that API Gateway can send back to the caller.
     * A key defines a method response header name and the associated value is a Boolean flag indicating whether the
     * method response parameter is required or not. The method response header names must match the pattern of
     * <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The
     * response parameter names defined here are available in the integration response to be mapped from an integration
     * response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a
     * pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response
     * payload in the form of <code>integration.response.body.{JSON-expression}</code>, where
     * <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResponseParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A key-value map specifying required or optional response parameters that API Gateway can send back to the
     *         caller. A key defines a method response header name and the associated value is a Boolean flag indicating
     *         whether the method response parameter is required or not. The method response header names must match the
     *         pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique
     *         header name. The response parameter names defined here are available in the integration response to be
     *         mapped from an integration response header expressed in <code>integration.response.header.{name}</code>,
     *         a static value enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON
     *         expression from the back-end response payload in the form of
     *         <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid
     *         JSON expression without the <code>$</code> prefix.)
     */
    public Map<String, Boolean> responseParameters() {
        return responseParameters;
    }

    /**
     * Returns true if the ResponseModels property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResponseModels() {
        return responseModels != null && !(responseModels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the <a>Model</a> resources used for the response's content type. Response models are represented as a
     * key/value map, with a content type as the key and a <a>Model</a> name as the value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResponseModels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the <a>Model</a> resources used for the response's content type. Response models are
     *         represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.
     */
    public Map<String, String> responseModels() {
        return responseModels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(responseParameters());
        hashCode = 31 * hashCode + Objects.hashCode(responseModels());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMethodResponseRequest)) {
            return false;
        }
        PutMethodResponseRequest other = (PutMethodResponseRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(httpMethod(), other.httpMethod()) && Objects.equals(statusCode(), other.statusCode())
                && Objects.equals(responseParameters(), other.responseParameters())
                && Objects.equals(responseModels(), other.responseModels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutMethodResponseRequest").add("RestApiId", restApiId()).add("ResourceId", resourceId())
                .add("HttpMethod", httpMethod()).add("StatusCode", statusCode()).add("ResponseParameters", responseParameters())
                .add("ResponseModels", responseModels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "httpMethod":
            return Optional.ofNullable(clazz.cast(httpMethod()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "responseParameters":
            return Optional.ofNullable(clazz.cast(responseParameters()));
        case "responseModels":
            return Optional.ofNullable(clazz.cast(responseModels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutMethodResponseRequest, T> g) {
        return obj -> g.apply((PutMethodResponseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutMethodResponseRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] The <a>Resource</a> identifier for the <a>Method</a> resource.
         * </p>
         * 
         * @param resourceId
         *        [Required] The <a>Resource</a> identifier for the <a>Method</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * [Required] The HTTP verb of the <a>Method</a> resource.
         * </p>
         * 
         * @param httpMethod
         *        [Required] The HTTP verb of the <a>Method</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * [Required] The method response's status code.
         * </p>
         * 
         * @param statusCodeValue
         *        [Required] The method response's status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * A key-value map specifying required or optional response parameters that API Gateway can send back to the
         * caller. A key defines a method response header name and the associated value is a Boolean flag indicating
         * whether the method response parameter is required or not. The method response header names must match the
         * pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header
         * name. The response parameter names defined here are available in the integration response to be mapped from
         * an integration response header expressed in <code>integration.response.header.{name}</code>, a static value
         * enclosed within a pair of single quotes (e.g., <code>'application/json'</code>), or a JSON expression from
         * the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where
         * <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)
         * </p>
         * 
         * @param responseParameters
         *        A key-value map specifying required or optional response parameters that API Gateway can send back to
         *        the caller. A key defines a method response header name and the associated value is a Boolean flag
         *        indicating whether the method response parameter is required or not. The method response header names
         *        must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a
         *        valid and unique header name. The response parameter names defined here are available in the
         *        integration response to be mapped from an integration response header expressed in
         *        <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single
         *        quotes (e.g., <code>'application/json'</code>), or a JSON expression from the back-end response
         *        payload in the form of <code>integration.response.body.{JSON-expression}</code>, where
         *        <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseParameters(Map<String, Boolean> responseParameters);

        /**
         * <p>
         * Specifies the <a>Model</a> resources used for the response's content type. Response models are represented as
         * a key/value map, with a content type as the key and a <a>Model</a> name as the value.
         * </p>
         * 
         * @param responseModels
         *        Specifies the <a>Model</a> resources used for the response's content type. Response models are
         *        represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseModels(Map<String, String> responseModels);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String resourceId;

        private String httpMethod;

        private String statusCodeValue;

        private Map<String, Boolean> responseParameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> responseModels = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMethodResponseRequest model) {
            super(model);
            restApiId(model.restApiId);
            resourceId(model.resourceId);
            httpMethod(model.httpMethod);
            statusCode(model.statusCodeValue);
            responseParameters(model.responseParameters);
            responseModels(model.responseModels);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        public final Map<String, Boolean> getResponseParameters() {
            return responseParameters;
        }

        @Override
        public final Builder responseParameters(Map<String, Boolean> responseParameters) {
            this.responseParameters = MapOfStringToBooleanCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, Boolean> responseParameters) {
            this.responseParameters = MapOfStringToBooleanCopier.copy(responseParameters);
        }

        public final Map<String, String> getResponseModels() {
            return responseModels;
        }

        @Override
        public final Builder responseModels(Map<String, String> responseModels) {
            this.responseModels = MapOfStringToStringCopier.copy(responseModels);
            return this;
        }

        public final void setResponseModels(Map<String, String> responseModels) {
            this.responseModels = MapOfStringToStringCopier.copy(responseModels);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMethodResponseRequest build() {
            return new PutMethodResponseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
