/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Requests API Gateway to create a <a>Deployment</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<CreateDeploymentRequest.Builder, CreateDeploymentRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()).build();

    private static final SdkField<String> STAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentRequest::stageDescription)).setter(setter(Builder::stageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageDescription").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> CACHE_CLUSTER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateDeploymentRequest::cacheClusterEnabled)).setter(setter(Builder::cacheClusterEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheClusterEnabled").build())
            .build();

    private static final SdkField<String> CACHE_CLUSTER_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentRequest::cacheClusterSize)).setter(setter(Builder::cacheClusterSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheClusterSize").build()).build();

    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateDeploymentRequest::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<DeploymentCanarySettings> CANARY_SETTINGS_FIELD = SdkField
            .<DeploymentCanarySettings> builder(MarshallingType.SDK_POJO).getter(getter(CreateDeploymentRequest::canarySettings))
            .setter(setter(Builder::canarySettings)).constructor(DeploymentCanarySettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canarySettings").build()).build();

    private static final SdkField<Boolean> TRACING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateDeploymentRequest::tracingEnabled)).setter(setter(Builder::tracingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            STAGE_NAME_FIELD, STAGE_DESCRIPTION_FIELD, DESCRIPTION_FIELD, CACHE_CLUSTER_ENABLED_FIELD, CACHE_CLUSTER_SIZE_FIELD,
            VARIABLES_FIELD, CANARY_SETTINGS_FIELD, TRACING_ENABLED_FIELD));

    private final String restApiId;

    private final String stageName;

    private final String stageDescription;

    private final String description;

    private final Boolean cacheClusterEnabled;

    private final String cacheClusterSize;

    private final Map<String, String> variables;

    private final DeploymentCanarySettings canarySettings;

    private final Boolean tracingEnabled;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.stageName = builder.stageName;
        this.stageDescription = builder.stageDescription;
        this.description = builder.description;
        this.cacheClusterEnabled = builder.cacheClusterEnabled;
        this.cacheClusterSize = builder.cacheClusterSize;
        this.variables = builder.variables;
        this.canarySettings = builder.canarySettings;
        this.tracingEnabled = builder.tracingEnabled;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * The name of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.
     * </p>
     * 
     * @return The name of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.
     */
    public String stageName() {
        return stageName;
    }

    /**
     * <p>
     * The description of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.
     * </p>
     * 
     * @return The description of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.
     */
    public String stageDescription() {
        return stageDescription;
    }

    /**
     * <p>
     * The description for the <a>Deployment</a> resource to create.
     * </p>
     * 
     * @return The description for the <a>Deployment</a> resource to create.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Enables a cache cluster for the <a>Stage</a> resource specified in the input.
     * </p>
     * 
     * @return Enables a cache cluster for the <a>Stage</a> resource specified in the input.
     */
    public Boolean cacheClusterEnabled() {
        return cacheClusterEnabled;
    }

    /**
     * <p>
     * Specifies the cache cluster size for the <a>Stage</a> resource specified in the input, if a cache cluster is
     * enabled.
     * </p>
     * 
     * @return Specifies the cache cluster size for the <a>Stage</a> resource specified in the input, if a cache cluster
     *         is enabled.
     */
    public String cacheClusterSize() {
        return cacheClusterSize;
    }

    /**
     * Returns true if the Variables property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that defines the stage variables for the <a>Stage</a> resource that is associated with the new deployment.
     * Variable names can have alphanumeric and underscore characters, and the values must match
     * <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVariables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map that defines the stage variables for the <a>Stage</a> resource that is associated with the new
     *         deployment. Variable names can have alphanumeric and underscore characters, and the values must match
     *         <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.
     */
    public Map<String, String> variables() {
        return variables;
    }

    /**
     * <p>
     * The input configuration for the canary deployment when the deployment is a canary release deployment.
     * </p>
     * 
     * @return The input configuration for the canary deployment when the deployment is a canary release deployment.
     */
    public DeploymentCanarySettings canarySettings() {
        return canarySettings;
    }

    /**
     * <p>
     * Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.
     * </p>
     * 
     * @return Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.
     */
    public Boolean tracingEnabled() {
        return tracingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(stageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterSize());
        hashCode = 31 * hashCode + Objects.hashCode(variables());
        hashCode = 31 * hashCode + Objects.hashCode(canarySettings());
        hashCode = 31 * hashCode + Objects.hashCode(tracingEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(stageDescription(), other.stageDescription())
                && Objects.equals(description(), other.description())
                && Objects.equals(cacheClusterEnabled(), other.cacheClusterEnabled())
                && Objects.equals(cacheClusterSize(), other.cacheClusterSize()) && Objects.equals(variables(), other.variables())
                && Objects.equals(canarySettings(), other.canarySettings())
                && Objects.equals(tracingEnabled(), other.tracingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDeploymentRequest").add("RestApiId", restApiId()).add("StageName", stageName())
                .add("StageDescription", stageDescription()).add("Description", description())
                .add("CacheClusterEnabled", cacheClusterEnabled()).add("CacheClusterSize", cacheClusterSize())
                .add("Variables", variables()).add("CanarySettings", canarySettings()).add("TracingEnabled", tracingEnabled())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "stageDescription":
            return Optional.ofNullable(clazz.cast(stageDescription()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "cacheClusterEnabled":
            return Optional.ofNullable(clazz.cast(cacheClusterEnabled()));
        case "cacheClusterSize":
            return Optional.ofNullable(clazz.cast(cacheClusterSize()));
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        case "canarySettings":
            return Optional.ofNullable(clazz.cast(canarySettings()));
        case "tracingEnabled":
            return Optional.ofNullable(clazz.cast(tracingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentRequest, T> g) {
        return obj -> g.apply((CreateDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * The name of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.
         * </p>
         * 
         * @param stageName
         *        The name of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * The description of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.
         * </p>
         * 
         * @param stageDescription
         *        The description of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageDescription(String stageDescription);

        /**
         * <p>
         * The description for the <a>Deployment</a> resource to create.
         * </p>
         * 
         * @param description
         *        The description for the <a>Deployment</a> resource to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Enables a cache cluster for the <a>Stage</a> resource specified in the input.
         * </p>
         * 
         * @param cacheClusterEnabled
         *        Enables a cache cluster for the <a>Stage</a> resource specified in the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterEnabled(Boolean cacheClusterEnabled);

        /**
         * <p>
         * Specifies the cache cluster size for the <a>Stage</a> resource specified in the input, if a cache cluster is
         * enabled.
         * </p>
         * 
         * @param cacheClusterSize
         *        Specifies the cache cluster size for the <a>Stage</a> resource specified in the input, if a cache
         *        cluster is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterSize(String cacheClusterSize);

        /**
         * <p>
         * A map that defines the stage variables for the <a>Stage</a> resource that is associated with the new
         * deployment. Variable names can have alphanumeric and underscore characters, and the values must match
         * <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.
         * </p>
         * 
         * @param variables
         *        A map that defines the stage variables for the <a>Stage</a> resource that is associated with the new
         *        deployment. Variable names can have alphanumeric and underscore characters, and the values must match
         *        <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Map<String, String> variables);

        /**
         * <p>
         * The input configuration for the canary deployment when the deployment is a canary release deployment.
         * </p>
         * 
         * @param canarySettings
         *        The input configuration for the canary deployment when the deployment is a canary release deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canarySettings(DeploymentCanarySettings canarySettings);

        /**
         * <p>
         * The input configuration for the canary deployment when the deployment is a canary release deployment.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentCanarySettings.Builder} avoiding the
         * need to create one manually via {@link DeploymentCanarySettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentCanarySettings.Builder#build()} is called immediately
         * and its result is passed to {@link #canarySettings(DeploymentCanarySettings)}.
         * 
         * @param canarySettings
         *        a consumer that will call methods on {@link DeploymentCanarySettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canarySettings(DeploymentCanarySettings)
         */
        default Builder canarySettings(Consumer<DeploymentCanarySettings.Builder> canarySettings) {
            return canarySettings(DeploymentCanarySettings.builder().applyMutation(canarySettings).build());
        }

        /**
         * <p>
         * Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.
         * </p>
         * 
         * @param tracingEnabled
         *        Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracingEnabled(Boolean tracingEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String stageName;

        private String stageDescription;

        private String description;

        private Boolean cacheClusterEnabled;

        private String cacheClusterSize;

        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();

        private DeploymentCanarySettings canarySettings;

        private Boolean tracingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            restApiId(model.restApiId);
            stageName(model.stageName);
            stageDescription(model.stageDescription);
            description(model.description);
            cacheClusterEnabled(model.cacheClusterEnabled);
            cacheClusterSize(model.cacheClusterSize);
            variables(model.variables);
            canarySettings(model.canarySettings);
            tracingEnabled(model.tracingEnabled);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getStageName() {
            return stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getStageDescription() {
            return stageDescription;
        }

        @Override
        public final Builder stageDescription(String stageDescription) {
            this.stageDescription = stageDescription;
            return this;
        }

        public final void setStageDescription(String stageDescription) {
            this.stageDescription = stageDescription;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getCacheClusterEnabled() {
            return cacheClusterEnabled;
        }

        @Override
        public final Builder cacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        public final void setCacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
        }

        public final String getCacheClusterSize() {
            return cacheClusterSize;
        }

        @Override
        public final Builder cacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
            return this;
        }

        public final void setCacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
        }

        public final Map<String, String> getVariables() {
            return variables;
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = MapOfStringToStringCopier.copy(variables);
            return this;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = MapOfStringToStringCopier.copy(variables);
        }

        public final DeploymentCanarySettings.Builder getCanarySettings() {
            return canarySettings != null ? canarySettings.toBuilder() : null;
        }

        @Override
        public final Builder canarySettings(DeploymentCanarySettings canarySettings) {
            this.canarySettings = canarySettings;
            return this;
        }

        public final void setCanarySettings(DeploymentCanarySettings.BuilderImpl canarySettings) {
            this.canarySettings = canarySettings != null ? canarySettings.build() : null;
        }

        public final Boolean getTracingEnabled() {
            return tracingEnabled;
        }

        @Override
        public final Builder tracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        public final void setTracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
