/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to change information about the <a>BasePathMapping</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBasePathMappingRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<UpdateBasePathMappingRequest.Builder, UpdateBasePathMappingRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateBasePathMappingRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domain_name").build()).build();

    private static final SdkField<String> BASE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateBasePathMappingRequest::basePath)).setter(setter(Builder::basePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("base_path").build()).build();

    private static final SdkField<List<PatchOperation>> PATCH_OPERATIONS_FIELD = SdkField
            .<List<PatchOperation>> builder(MarshallingType.LIST)
            .getter(getter(UpdateBasePathMappingRequest::patchOperations))
            .setter(setter(Builder::patchOperations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patchOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PatchOperation> builder(MarshallingType.SDK_POJO)
                                            .constructor(PatchOperation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            BASE_PATH_FIELD, PATCH_OPERATIONS_FIELD));

    private final String domainName;

    private final String basePath;

    private final List<PatchOperation> patchOperations;

    private UpdateBasePathMappingRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.basePath = builder.basePath;
        this.patchOperations = builder.patchOperations;
    }

    /**
     * <p>
     * [Required] The domain name of the <a>BasePathMapping</a> resource to change.
     * </p>
     * 
     * @return [Required] The domain name of the <a>BasePathMapping</a> resource to change.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * [Required] The base path of the <a>BasePathMapping</a> resource to change.
     * </p>
     * <p>
     * To specify an empty base path, set this parameter to <code>'(none)'</code>.
     * </p>
     * 
     * @return [Required] The base path of the <a>BasePathMapping</a> resource to change.</p>
     *         <p>
     *         To specify an empty base path, set this parameter to <code>'(none)'</code>.
     */
    public String basePath() {
        return basePath;
    }

    /**
     * Returns true if the PatchOperations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPatchOperations() {
        return patchOperations != null && !(patchOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of update operations to be applied to the specified resource and in the order specified in this list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPatchOperations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of update operations to be applied to the specified resource and in the order specified in this
     *         list.
     */
    public List<PatchOperation> patchOperations() {
        return patchOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(basePath());
        hashCode = 31 * hashCode + Objects.hashCode(patchOperations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBasePathMappingRequest)) {
            return false;
        }
        UpdateBasePathMappingRequest other = (UpdateBasePathMappingRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(basePath(), other.basePath())
                && Objects.equals(patchOperations(), other.patchOperations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateBasePathMappingRequest").add("DomainName", domainName()).add("BasePath", basePath())
                .add("PatchOperations", patchOperations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "basePath":
            return Optional.ofNullable(clazz.cast(basePath()));
        case "patchOperations":
            return Optional.ofNullable(clazz.cast(patchOperations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBasePathMappingRequest, T> g) {
        return obj -> g.apply((UpdateBasePathMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBasePathMappingRequest> {
        /**
         * <p>
         * [Required] The domain name of the <a>BasePathMapping</a> resource to change.
         * </p>
         * 
         * @param domainName
         *        [Required] The domain name of the <a>BasePathMapping</a> resource to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * [Required] The base path of the <a>BasePathMapping</a> resource to change.
         * </p>
         * <p>
         * To specify an empty base path, set this parameter to <code>'(none)'</code>.
         * </p>
         * 
         * @param basePath
         *        [Required] The base path of the <a>BasePathMapping</a> resource to change.</p>
         *        <p>
         *        To specify an empty base path, set this parameter to <code>'(none)'</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basePath(String basePath);

        /**
         * <p>
         * A list of update operations to be applied to the specified resource and in the order specified in this list.
         * </p>
         * 
         * @param patchOperations
         *        A list of update operations to be applied to the specified resource and in the order specified in this
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchOperations(Collection<PatchOperation> patchOperations);

        /**
         * <p>
         * A list of update operations to be applied to the specified resource and in the order specified in this list.
         * </p>
         * 
         * @param patchOperations
         *        A list of update operations to be applied to the specified resource and in the order specified in this
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchOperations(PatchOperation... patchOperations);

        /**
         * <p>
         * A list of update operations to be applied to the specified resource and in the order specified in this list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PatchOperation>.Builder} avoiding the need
         * to create one manually via {@link List<PatchOperation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PatchOperation>.Builder#build()} is called immediately and
         * its result is passed to {@link #patchOperations(List<PatchOperation>)}.
         * 
         * @param patchOperations
         *        a consumer that will call methods on {@link List<PatchOperation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patchOperations(List<PatchOperation>)
         */
        Builder patchOperations(Consumer<PatchOperation.Builder>... patchOperations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String domainName;

        private String basePath;

        private List<PatchOperation> patchOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBasePathMappingRequest model) {
            super(model);
            domainName(model.domainName);
            basePath(model.basePath);
            patchOperations(model.patchOperations);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getBasePath() {
            return basePath;
        }

        @Override
        public final Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public final void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public final Collection<PatchOperation.Builder> getPatchOperations() {
            return patchOperations != null ? patchOperations.stream().map(PatchOperation::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder patchOperations(Collection<PatchOperation> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copy(patchOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(PatchOperation... patchOperations) {
            patchOperations(Arrays.asList(patchOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(Consumer<PatchOperation.Builder>... patchOperations) {
            patchOperations(Stream.of(patchOperations).map(c -> PatchOperation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPatchOperations(Collection<PatchOperation.BuilderImpl> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copyFromBuilder(patchOperations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBasePathMappingRequest build() {
            return new UpdateBasePathMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
