/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum GatewayResponseType {
    DEFAULT_4_XX("DEFAULT_4XX"),

    DEFAULT_5_XX("DEFAULT_5XX"),

    RESOURCE_NOT_FOUND("RESOURCE_NOT_FOUND"),

    UNAUTHORIZED("UNAUTHORIZED"),

    INVALID_API_KEY("INVALID_API_KEY"),

    ACCESS_DENIED("ACCESS_DENIED"),

    AUTHORIZER_FAILURE("AUTHORIZER_FAILURE"),

    AUTHORIZER_CONFIGURATION_ERROR("AUTHORIZER_CONFIGURATION_ERROR"),

    INVALID_SIGNATURE("INVALID_SIGNATURE"),

    EXPIRED_TOKEN("EXPIRED_TOKEN"),

    MISSING_AUTHENTICATION_TOKEN("MISSING_AUTHENTICATION_TOKEN"),

    INTEGRATION_FAILURE("INTEGRATION_FAILURE"),

    INTEGRATION_TIMEOUT("INTEGRATION_TIMEOUT"),

    API_CONFIGURATION_ERROR("API_CONFIGURATION_ERROR"),

    UNSUPPORTED_MEDIA_TYPE("UNSUPPORTED_MEDIA_TYPE"),

    BAD_REQUEST_PARAMETERS("BAD_REQUEST_PARAMETERS"),

    BAD_REQUEST_BODY("BAD_REQUEST_BODY"),

    REQUEST_TOO_LARGE("REQUEST_TOO_LARGE"),

    THROTTLED("THROTTLED"),

    QUOTA_EXCEEDED("QUOTA_EXCEEDED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private GatewayResponseType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return GatewayResponseType corresponding to the value
     */
    public static GatewayResponseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(GatewayResponseType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link GatewayResponseType}s
     */
    public static Set<GatewayResponseType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
