/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the base path that callers of the API must provide as part of the URL after the domain name.
 * </p>
 * <div class="remarks">A custom domain name plus a <code>BasePathMapping</code> specification identifies a deployed
 * <a>RestApi</a> in a given stage of the owner <a>Account</a>.</div> <div class="seeAlso"> <a
 * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Use Custom Domain
 * Names</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBasePathMappingResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetBasePathMappingResponse.Builder, GetBasePathMappingResponse> {
    private static final SdkField<String> BASE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBasePathMappingResponse::basePath)).setter(setter(Builder::basePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basePath").build()).build();

    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBasePathMappingResponse::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restApiId").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBasePathMappingResponse::stage)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_PATH_FIELD,
            REST_API_ID_FIELD, STAGE_FIELD));

    private final String basePath;

    private final String restApiId;

    private final String stage;

    private GetBasePathMappingResponse(BuilderImpl builder) {
        super(builder);
        this.basePath = builder.basePath;
        this.restApiId = builder.restApiId;
        this.stage = builder.stage;
    }

    /**
     * <p>
     * The base path name that callers of the API must provide as part of the URL after the domain name.
     * </p>
     * 
     * @return The base path name that callers of the API must provide as part of the URL after the domain name.
     */
    public String basePath() {
        return basePath;
    }

    /**
     * <p>
     * The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * The name of the associated stage.
     * </p>
     * 
     * @return The name of the associated stage.
     */
    public String stage() {
        return stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(basePath());
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBasePathMappingResponse)) {
            return false;
        }
        GetBasePathMappingResponse other = (GetBasePathMappingResponse) obj;
        return Objects.equals(basePath(), other.basePath()) && Objects.equals(restApiId(), other.restApiId())
                && Objects.equals(stage(), other.stage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBasePathMappingResponse").add("BasePath", basePath()).add("RestApiId", restApiId())
                .add("Stage", stage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "basePath":
            return Optional.ofNullable(clazz.cast(basePath()));
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "stage":
            return Optional.ofNullable(clazz.cast(stage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBasePathMappingResponse, T> g) {
        return obj -> g.apply((GetBasePathMappingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBasePathMappingResponse> {
        /**
         * <p>
         * The base path name that callers of the API must provide as part of the URL after the domain name.
         * </p>
         * 
         * @param basePath
         *        The base path name that callers of the API must provide as part of the URL after the domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basePath(String basePath);

        /**
         * <p>
         * The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * The name of the associated stage.
         * </p>
         * 
         * @param stage
         *        The name of the associated stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(String stage);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String basePath;

        private String restApiId;

        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBasePathMappingResponse model) {
            super(model);
            basePath(model.basePath);
            restApiId(model.restApiId);
            stage(model.stage);
        }

        public final String getBasePath() {
            return basePath;
        }

        @Override
        public final Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public final void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getStage() {
            return stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public GetBasePathMappingResponse build() {
            return new GetBasePathMappingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
