/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayException;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.BadRequestException;
import software.amazon.awssdk.services.apigateway.model.ConflictException;
import software.amazon.awssdk.services.apigateway.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.CreateModelRequest;
import software.amazon.awssdk.services.apigateway.model.CreateModelResponse;
import software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.CreateResourceRequest;
import software.amazon.awssdk.services.apigateway.model.CreateResourceResponse;
import software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.CreateRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.CreateStageRequest;
import software.amazon.awssdk.services.apigateway.model.CreateStageResponse;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.CreateVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.CreateVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteModelRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteModelResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteResourceRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteResourceResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteStageRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteStageResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheRequest;
import software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheResponse;
import software.amazon.awssdk.services.apigateway.model.FlushStageCacheRequest;
import software.amazon.awssdk.services.apigateway.model.FlushStageCacheResponse;
import software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.GetAccountRequest;
import software.amazon.awssdk.services.apigateway.model.GetAccountResponse;
import software.amazon.awssdk.services.apigateway.model.GetApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.GetApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizersResponse;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse;
import software.amazon.awssdk.services.apigateway.model.GetExportRequest;
import software.amazon.awssdk.services.apigateway.model.GetExportResponse;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesRequest;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesResponse;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetMethodRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponse;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelTemplateRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelTemplateResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelsRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelsResponse;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorsRequest;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorsResponse;
import software.amazon.awssdk.services.apigateway.model.GetResourceRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourceResponse;
import software.amazon.awssdk.services.apigateway.model.GetResourcesRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourcesResponse;
import software.amazon.awssdk.services.apigateway.model.GetRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.GetRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.GetRestApisRequest;
import software.amazon.awssdk.services.apigateway.model.GetRestApisResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypeRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypeResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypesRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypesResponse;
import software.amazon.awssdk.services.apigateway.model.GetStageRequest;
import software.amazon.awssdk.services.apigateway.model.GetStageResponse;
import software.amazon.awssdk.services.apigateway.model.GetStagesRequest;
import software.amazon.awssdk.services.apigateway.model.GetStagesResponse;
import software.amazon.awssdk.services.apigateway.model.GetTagsRequest;
import software.amazon.awssdk.services.apigateway.model.GetTagsResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsageRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsageResponse;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse;
import software.amazon.awssdk.services.apigateway.model.ImportApiKeysRequest;
import software.amazon.awssdk.services.apigateway.model.ImportApiKeysResponse;
import software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsRequest;
import software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsResponse;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.LimitExceededException;
import software.amazon.awssdk.services.apigateway.model.NotFoundException;
import software.amazon.awssdk.services.apigateway.model.PutGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutMethodRequest;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponse;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.PutRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.ServiceUnavailableException;
import software.amazon.awssdk.services.apigateway.model.TagResourceRequest;
import software.amazon.awssdk.services.apigateway.model.TagResourceResponse;
import software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest;
import software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse;
import software.amazon.awssdk.services.apigateway.model.TooManyRequestsException;
import software.amazon.awssdk.services.apigateway.model.UnauthorizedException;
import software.amazon.awssdk.services.apigateway.model.UntagResourceRequest;
import software.amazon.awssdk.services.apigateway.model.UntagResourceResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateAccountRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateAccountResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateModelRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateModelResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateResourceRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateResourceResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateStageRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateStageResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateUsageRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.paginators.GetApiKeysIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetModelsIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetResourcesIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetRestApisIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetUsageIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansIterable;
import software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksIterable;
import software.amazon.awssdk.services.apigateway.transform.CreateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateUsagePlanKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteUsagePlanKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.FlushStageAuthorizersCacheRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.FlushStageCacheRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GenerateClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAccountRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetApiKeysRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAuthorizersRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetBasePathMappingsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetClientCertificatesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationPartsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationVersionsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetExportRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetGatewayResponsesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelTemplateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRequestValidatorsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetResourcesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRestApisRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkTypeRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkTypesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetStagesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetTagsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanKeysRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlansRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetVpcLinksRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportApiKeysRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportDocumentationPartsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.TestInvokeAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.TestInvokeMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateAccountRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateUsageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateVpcLinkRequestMarshaller;

/**
 * Internal implementation of {@link ApiGatewayClient}.
 *
 * @see ApiGatewayClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultApiGatewayClient implements ApiGatewayClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultApiGatewayClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Create an <a>ApiKey</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-api-key.html">AWS CLI</a></div>
     *
     * @param createApiKeyRequest
     *        Request to create an <a>ApiKey</a> resource.
     * @return Result of the CreateApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateApiKey
     */
    @Override
    public CreateApiKeyResponse createApiKey(CreateApiKeyRequest createApiKeyRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateApiKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApiKey");

            return clientHandler.execute(new ClientExecutionParams<CreateApiKeyRequest, CreateApiKeyResponse>()
                    .withOperationName("CreateApiKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createApiKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateApiKeyRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApiKeyRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a new <a>Authorizer</a> resource to an existing <a>RestApi</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-authorizer.html">AWS CLI</a></div>
     *
     * @param createAuthorizerRequest
     *        Request to add a new <a>Authorizer</a> to an existing <a>RestApi</a> resource.
     * @return Result of the CreateAuthorizer operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateAuthorizer
     */
    @Override
    public CreateAuthorizerResponse createAuthorizer(CreateAuthorizerRequest createAuthorizerRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, LimitExceededException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<CreateAuthorizerRequest, CreateAuthorizerResponse>()
                    .withOperationName("CreateAuthorizer").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAuthorizerRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param createBasePathMappingRequest
     *        Requests API Gateway to create a new <a>BasePathMapping</a> resource.
     * @return Result of the CreateBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateBasePathMapping
     */
    @Override
    public CreateBasePathMappingResponse createBasePathMapping(CreateBasePathMappingRequest createBasePathMappingRequest)
            throws UnauthorizedException, ConflictException, BadRequestException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBasePathMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBasePathMapping");

            return clientHandler.execute(new ClientExecutionParams<CreateBasePathMappingRequest, CreateBasePathMappingResponse>()
                    .withOperationName("CreateBasePathMapping").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createBasePathMappingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBasePathMappingRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBasePathMappingRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <a>Deployment</a> resource, which makes a specified <a>RestApi</a> callable over the internet.
     * </p>
     *
     * @param createDeploymentRequest
     *        Requests API Gateway to create a <a>Deployment</a> resource.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDeployment
     */
    @Override
    public CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest)
            throws UnauthorizedException, BadRequestException, NotFoundException, ConflictException, LimitExceededException,
            TooManyRequestsException, ServiceUnavailableException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeployment");

            return clientHandler.execute(new ClientExecutionParams<CreateDeploymentRequest, CreateDeploymentResponse>()
                    .withOperationName("CreateDeployment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDeploymentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Invokes the CreateDocumentationPart operation.
     *
     * @param createDocumentationPartRequest
     *        Creates a new documentation part of a given API.
     * @return Result of the CreateDocumentationPart operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDocumentationPart
     */
    @Override
    public CreateDocumentationPartResponse createDocumentationPart(CreateDocumentationPartRequest createDocumentationPartRequest)
            throws BadRequestException, ConflictException, UnauthorizedException, NotFoundException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDocumentationPartResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDocumentationPart");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDocumentationPartRequest, CreateDocumentationPartResponse>()
                            .withOperationName("CreateDocumentationPart").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createDocumentationPartRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDocumentationPartRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDocumentationPartRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Invokes the CreateDocumentationVersion operation.
     *
     * @param createDocumentationVersionRequest
     *        Creates a new documentation version of a given API.
     * @return Result of the CreateDocumentationVersion operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDocumentationVersion
     */
    @Override
    public CreateDocumentationVersionResponse createDocumentationVersion(
            CreateDocumentationVersionRequest createDocumentationVersionRequest) throws BadRequestException, ConflictException,
            UnauthorizedException, NotFoundException, LimitExceededException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDocumentationVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDocumentationVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDocumentationVersionRequest, CreateDocumentationVersionResponse>()
                            .withOperationName("CreateDocumentationVersion").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createDocumentationVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDocumentationVersionRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                    createDocumentationVersionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new domain name.
     * </p>
     *
     * @param createDomainNameRequest
     *        A request to create a new domain name.
     * @return Result of the CreateDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateDomainName
     */
    @Override
    public CreateDomainNameResponse createDomainName(CreateDomainNameRequest createDomainNameRequest)
            throws UnauthorizedException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDomainNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDomainName");

            return clientHandler.execute(new ClientExecutionParams<CreateDomainNameRequest, CreateDomainNameResponse>()
                    .withOperationName("CreateDomainName").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDomainNameRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDomainNameRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDomainNameRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a new <a>Model</a> resource to an existing <a>RestApi</a> resource.
     * </p>
     *
     * @param createModelRequest
     *        Request to add a new <a>Model</a> to an existing <a>RestApi</a> resource.
     * @return Result of the CreateModel operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateModel
     */
    @Override
    public CreateModelResponse createModel(CreateModelRequest createModelRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, ConflictException, LimitExceededException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModel");

            return clientHandler.execute(new ClientExecutionParams<CreateModelRequest, CreateModelResponse>()
                    .withOperationName("CreateModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateModelRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <a>ReqeustValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param createRequestValidatorRequest
     *        Creates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the CreateRequestValidator operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateRequestValidator
     */
    @Override
    public CreateRequestValidatorResponse createRequestValidator(CreateRequestValidatorRequest createRequestValidatorRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateRequestValidatorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRequestValidator");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateRequestValidatorRequest, CreateRequestValidatorResponse>()
                            .withOperationName("CreateRequestValidator").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createRequestValidatorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateRequestValidatorRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRequestValidatorRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <a>Resource</a> resource.
     * </p>
     *
     * @param createResourceRequest
     *        Requests API Gateway to create a <a>Resource</a> resource.
     * @return Result of the CreateResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateResource
     */
    @Override
    public CreateResourceResponse createResource(CreateResourceRequest createResourceRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, LimitExceededException, BadRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResource");

            return clientHandler.execute(new ClientExecutionParams<CreateResourceRequest, CreateResourceResponse>()
                    .withOperationName("CreateResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateResourceRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new <a>RestApi</a> resource.
     * </p>
     *
     * @param createRestApiRequest
     *        The POST Request to add a new <a>RestApi</a> resource to your collection.
     * @return Result of the CreateRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateRestApi
     */
    @Override
    public CreateRestApiResponse createRestApi(CreateRestApiRequest createRestApiRequest) throws UnauthorizedException,
            LimitExceededException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRestApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRestApi");

            return clientHandler.execute(new ClientExecutionParams<CreateRestApiRequest, CreateRestApiResponse>()
                    .withOperationName("CreateRestApi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createRestApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRestApiRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRestApiRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new <a>Stage</a> resource that references a pre-existing <a>Deployment</a> for the API.
     * </p>
     *
     * @param createStageRequest
     *        Requests API Gateway to create a <a>Stage</a> resource.
     * @return Result of the CreateStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateStage
     */
    @Override
    public CreateStageResponse createStage(CreateStageRequest createStageRequest) throws UnauthorizedException,
            BadRequestException, NotFoundException, ConflictException, LimitExceededException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateStageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStage");

            return clientHandler.execute(new ClientExecutionParams<CreateStageRequest, CreateStageResponse>()
                    .withOperationName("CreateStage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createStageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStageRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStageRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the
     * payload.
     * </p>
     *
     * @param createUsagePlanRequest
     *        The POST request to create a usage plan with the name, description, throttle limits and quota limits, as
     *        well as the associated API stages, specified in the payload.
     * @return Result of the CreateUsagePlan operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateUsagePlan
     */
    @Override
    public CreateUsagePlanResponse createUsagePlan(CreateUsagePlanRequest createUsagePlanRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, LimitExceededException, ConflictException, NotFoundException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUsagePlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUsagePlan");

            return clientHandler.execute(new ClientExecutionParams<CreateUsagePlanRequest, CreateUsagePlanResponse>()
                    .withOperationName("CreateUsagePlan").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createUsagePlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUsagePlanRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUsagePlanRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a usage plan key for adding an existing API key to a usage plan.
     * </p>
     *
     * @param createUsagePlanKeyRequest
     *        The POST request to create a usage plan key for adding an existing API key to a usage plan.
     * @return Result of the CreateUsagePlanKey operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateUsagePlanKey
     */
    @Override
    public CreateUsagePlanKeyResponse createUsagePlanKey(CreateUsagePlanKeyRequest createUsagePlanKeyRequest)
            throws BadRequestException, ConflictException, UnauthorizedException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUsagePlanKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUsagePlanKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUsagePlanKey");

            return clientHandler.execute(new ClientExecutionParams<CreateUsagePlanKeyRequest, CreateUsagePlanKeyResponse>()
                    .withOperationName("CreateUsagePlanKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createUsagePlanKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUsagePlanKeyRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUsagePlanKeyRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically
     * takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC
     * Endpoint services.
     * </p>
     *
     * @param createVpcLinkRequest
     *        Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that
     *        typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create
     *        and update VPC Endpoint services.
     * @return Result of the CreateVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.CreateVpcLink
     */
    @Override
    public CreateVpcLinkResponse createVpcLink(CreateVpcLinkRequest createVpcLinkRequest) throws UnauthorizedException,
            BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateVpcLinkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcLink");

            return clientHandler.execute(new ClientExecutionParams<CreateVpcLinkRequest, CreateVpcLinkResponse>()
                    .withOperationName("CreateVpcLink").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createVpcLinkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVpcLinkRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcLinkRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the <a>ApiKey</a> resource.
     * </p>
     *
     * @param deleteApiKeyRequest
     *        A request to delete the <a>ApiKey</a> resource.
     * @return Result of the DeleteApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteApiKey
     */
    @Override
    public DeleteApiKeyResponse deleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteApiKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApiKey");

            return clientHandler.execute(new ClientExecutionParams<DeleteApiKeyRequest, DeleteApiKeyResponse>()
                    .withOperationName("DeleteApiKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteApiKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteApiKeyRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApiKeyRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/delete-authorizer.html">AWS CLI</a></div>
     *
     * @param deleteAuthorizerRequest
     *        Request to delete an existing <a>Authorizer</a> resource.
     * @return Result of the DeleteAuthorizer operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteAuthorizer
     */
    @Override
    public DeleteAuthorizerResponse deleteAuthorizer(DeleteAuthorizerRequest deleteAuthorizerRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<DeleteAuthorizerRequest, DeleteAuthorizerResponse>()
                    .withOperationName("DeleteAuthorizer").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAuthorizerRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param deleteBasePathMappingRequest
     *        A request to delete the <a>BasePathMapping</a> resource.
     * @return Result of the DeleteBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteBasePathMapping
     */
    @Override
    public DeleteBasePathMappingResponse deleteBasePathMapping(DeleteBasePathMappingRequest deleteBasePathMappingRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, BadRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBasePathMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBasePathMapping");

            return clientHandler.execute(new ClientExecutionParams<DeleteBasePathMappingRequest, DeleteBasePathMappingResponse>()
                    .withOperationName("DeleteBasePathMapping").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteBasePathMappingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBasePathMappingRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBasePathMappingRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param deleteClientCertificateRequest
     *        A request to delete the <a>ClientCertificate</a> resource.
     * @return Result of the DeleteClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteClientCertificate
     */
    @Override
    public DeleteClientCertificateResponse deleteClientCertificate(DeleteClientCertificateRequest deleteClientCertificateRequest)
            throws UnauthorizedException, TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteClientCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClientCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteClientCertificateRequest, DeleteClientCertificateResponse>()
                            .withOperationName("DeleteClientCertificate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteClientCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteClientCertificateRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClientCertificateRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <a>Deployment</a> resource. Deleting a deployment will only succeed if there are no <a>Stage</a>
     * resources associated with it.
     * </p>
     *
     * @param deleteDeploymentRequest
     *        Requests API Gateway to delete a <a>Deployment</a> resource.
     * @return Result of the DeleteDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDeployment
     */
    @Override
    public DeleteDeploymentResponse deleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeployment");

            return clientHandler.execute(new ClientExecutionParams<DeleteDeploymentRequest, DeleteDeploymentResponse>()
                    .withOperationName("DeleteDeployment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDeploymentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeploymentRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Invokes the DeleteDocumentationPart operation.
     *
     * @param deleteDocumentationPartRequest
     *        Deletes an existing documentation part of an API.
     * @return Result of the DeleteDocumentationPart operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDocumentationPart
     */
    @Override
    public DeleteDocumentationPartResponse deleteDocumentationPart(DeleteDocumentationPartRequest deleteDocumentationPartRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, ConflictException, BadRequestException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDocumentationPartResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDocumentationPart");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDocumentationPartRequest, DeleteDocumentationPartResponse>()
                            .withOperationName("DeleteDocumentationPart").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteDocumentationPartRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDocumentationPartRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDocumentationPartRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Invokes the DeleteDocumentationVersion operation.
     *
     * @param deleteDocumentationVersionRequest
     *        Deletes an existing documentation version of an API.
     * @return Result of the DeleteDocumentationVersion operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDocumentationVersion
     */
    @Override
    public DeleteDocumentationVersionResponse deleteDocumentationVersion(
            DeleteDocumentationVersionRequest deleteDocumentationVersionRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDocumentationVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDocumentationVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDocumentationVersionRequest, DeleteDocumentationVersionResponse>()
                            .withOperationName("DeleteDocumentationVersion").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteDocumentationVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDocumentationVersionRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                    deleteDocumentationVersionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the <a>DomainName</a> resource.
     * </p>
     *
     * @param deleteDomainNameRequest
     *        A request to delete the <a>DomainName</a> resource.
     * @return Result of the DeleteDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteDomainName
     */
    @Override
    public DeleteDomainNameResponse deleteDomainName(DeleteDomainNameRequest deleteDomainNameRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDomainNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDomainName");

            return clientHandler.execute(new ClientExecutionParams<DeleteDomainNameRequest, DeleteDomainNameResponse>()
                    .withOperationName("DeleteDomainName").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDomainNameRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDomainNameRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDomainNameRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Clears any customization of a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a> and
     * resets it with the default settings.
     * </p>
     *
     * @param deleteGatewayResponseRequest
     *        Clears any customization of a <a>GatewayResponse</a> of a specified response type on the given
     *        <a>RestApi</a> and resets it with the default settings.
     * @return Result of the DeleteGatewayResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteGatewayResponse
     */
    @Override
    public DeleteGatewayResponseResponse deleteGatewayResponse(DeleteGatewayResponseRequest deleteGatewayResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteGatewayResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGatewayResponse");

            return clientHandler.execute(new ClientExecutionParams<DeleteGatewayResponseRequest, DeleteGatewayResponseResponse>()
                    .withOperationName("DeleteGatewayResponse").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteGatewayResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGatewayResponseRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGatewayResponseRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Represents a delete integration.
     * </p>
     *
     * @param deleteIntegrationRequest
     *        Represents a delete integration request.
     * @return Result of the DeleteIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteIntegration
     */
    @Override
    public DeleteIntegrationResponse deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteIntegrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntegration");

            return clientHandler.execute(new ClientExecutionParams<DeleteIntegrationRequest, DeleteIntegrationResponse>()
                    .withOperationName("DeleteIntegration").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntegrationRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Represents a delete integration response.
     * </p>
     *
     * @param deleteIntegrationResponseRequest
     *        Represents a delete integration response request.
     * @return Result of the DeleteIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteIntegrationResponse
     */
    @Override
    public DeleteIntegrationResponseResponse deleteIntegrationResponse(
            DeleteIntegrationResponseRequest deleteIntegrationResponseRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteIntegrationResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntegrationResponse");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteIntegrationResponseRequest, DeleteIntegrationResponseResponse>()
                            .withOperationName("DeleteIntegrationResponse").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteIntegrationResponseRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteIntegrationResponseRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                    deleteIntegrationResponseRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing <a>Method</a> resource.
     * </p>
     *
     * @param deleteMethodRequest
     *        Request to delete an existing <a>Method</a> resource.
     * @return Result of the DeleteMethod operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteMethod
     */
    @Override
    public DeleteMethodResponse deleteMethod(DeleteMethodRequest deleteMethodRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMethodResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteMethodResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMethod");

            return clientHandler.execute(new ClientExecutionParams<DeleteMethodRequest, DeleteMethodResponse>()
                    .withOperationName("DeleteMethod").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteMethodRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteMethodRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMethodRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing <a>MethodResponse</a> resource.
     * </p>
     *
     * @param deleteMethodResponseRequest
     *        A request to delete an existing <a>MethodResponse</a> resource.
     * @return Result of the DeleteMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteMethodResponse
     */
    @Override
    public DeleteMethodResponseResponse deleteMethodResponse(DeleteMethodResponseRequest deleteMethodResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMethodResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMethodResponse");

            return clientHandler.execute(new ClientExecutionParams<DeleteMethodResponseRequest, DeleteMethodResponseResponse>()
                    .withOperationName("DeleteMethodResponse").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteMethodResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteMethodResponseRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMethodResponseRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a model.
     * </p>
     *
     * @param deleteModelRequest
     *        Request to delete an existing model in an existing <a>RestApi</a> resource.
     * @return Result of the DeleteModel operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteModel
     */
    @Override
    public DeleteModelResponse deleteModel(DeleteModelRequest deleteModelRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModel");

            return clientHandler.execute(new ClientExecutionParams<DeleteModelRequest, DeleteModelResponse>()
                    .withOperationName("DeleteModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteModelRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param deleteRequestValidatorRequest
     *        Deletes a specified <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the DeleteRequestValidator operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteRequestValidator
     */
    @Override
    public DeleteRequestValidatorResponse deleteRequestValidator(DeleteRequestValidatorRequest deleteRequestValidatorRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRequestValidatorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRequestValidator");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRequestValidatorRequest, DeleteRequestValidatorResponse>()
                            .withOperationName("DeleteRequestValidator").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteRequestValidatorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRequestValidatorRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRequestValidatorRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <a>Resource</a> resource.
     * </p>
     *
     * @param deleteResourceRequest
     *        Request to delete a <a>Resource</a>.
     * @return Result of the DeleteResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteResource
     */
    @Override
    public DeleteResourceResponse deleteResource(DeleteResourceRequest deleteResourceRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResource");

            return clientHandler.execute(new ClientExecutionParams<DeleteResourceRequest, DeleteResourceResponse>()
                    .withOperationName("DeleteResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteResourceRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified API.
     * </p>
     *
     * @param deleteRestApiRequest
     *        Request to delete the specified API from your collection.
     * @return Result of the DeleteRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteRestApi
     */
    @Override
    public DeleteRestApiResponse deleteRestApi(DeleteRestApiRequest deleteRestApiRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRestApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRestApi");

            return clientHandler.execute(new ClientExecutionParams<DeleteRestApiRequest, DeleteRestApiResponse>()
                    .withOperationName("DeleteRestApi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteRestApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRestApiRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRestApiRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <a>Stage</a> resource.
     * </p>
     *
     * @param deleteStageRequest
     *        Requests API Gateway to delete a <a>Stage</a> resource.
     * @return Result of the DeleteStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteStage
     */
    @Override
    public DeleteStageResponse deleteStage(DeleteStageRequest deleteStageRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteStageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStage");

            return clientHandler.execute(new ClientExecutionParams<DeleteStageRequest, DeleteStageResponse>()
                    .withOperationName("DeleteStage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteStageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteStageRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStageRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a usage plan of a given plan Id.
     * </p>
     *
     * @param deleteUsagePlanRequest
     *        The DELETE request to delete a usage plan of a given plan Id.
     * @return Result of the DeleteUsagePlan operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteUsagePlan
     */
    @Override
    public DeleteUsagePlanResponse deleteUsagePlan(DeleteUsagePlanRequest deleteUsagePlanRequest) throws UnauthorizedException,
            TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteUsagePlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUsagePlan");

            return clientHandler.execute(new ClientExecutionParams<DeleteUsagePlanRequest, DeleteUsagePlanResponse>()
                    .withOperationName("DeleteUsagePlan").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteUsagePlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUsagePlanRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUsagePlanRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a usage plan key and remove the underlying API key from the associated usage plan.
     * </p>
     *
     * @param deleteUsagePlanKeyRequest
     *        The DELETE request to delete a usage plan key and remove the underlying API key from the associated usage
     *        plan.
     * @return Result of the DeleteUsagePlanKey operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteUsagePlanKey
     */
    @Override
    public DeleteUsagePlanKeyResponse deleteUsagePlanKey(DeleteUsagePlanKeyRequest deleteUsagePlanKeyRequest)
            throws BadRequestException, ConflictException, UnauthorizedException, NotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUsagePlanKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteUsagePlanKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUsagePlanKey");

            return clientHandler.execute(new ClientExecutionParams<DeleteUsagePlanKeyRequest, DeleteUsagePlanKeyResponse>()
                    .withOperationName("DeleteUsagePlanKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteUsagePlanKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUsagePlanKeyRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUsagePlanKeyRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing <a>VpcLink</a> of a specified identifier.
     * </p>
     *
     * @param deleteVpcLinkRequest
     *        Deletes an existing <a>VpcLink</a> of a specified identifier.
     * @return Result of the DeleteVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.DeleteVpcLink
     */
    @Override
    public DeleteVpcLinkResponse deleteVpcLink(DeleteVpcLinkRequest deleteVpcLinkRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteVpcLinkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcLink");

            return clientHandler.execute(new ClientExecutionParams<DeleteVpcLinkRequest, DeleteVpcLinkResponse>()
                    .withOperationName("DeleteVpcLink").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteVpcLinkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVpcLinkRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpcLinkRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Flushes all authorizer cache entries on a stage.
     * </p>
     *
     * @param flushStageAuthorizersCacheRequest
     *        Request to flush authorizer cache entries on a specified stage.
     * @return Result of the FlushStageAuthorizersCache operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.FlushStageAuthorizersCache
     */
    @Override
    public FlushStageAuthorizersCacheResponse flushStageAuthorizersCache(
            FlushStageAuthorizersCacheRequest flushStageAuthorizersCacheRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<FlushStageAuthorizersCacheResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, FlushStageAuthorizersCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FlushStageAuthorizersCache");

            return clientHandler
                    .execute(new ClientExecutionParams<FlushStageAuthorizersCacheRequest, FlushStageAuthorizersCacheResponse>()
                            .withOperationName("FlushStageAuthorizersCache").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(flushStageAuthorizersCacheRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new FlushStageAuthorizersCacheRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                    flushStageAuthorizersCacheRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Flushes a stage's cache.
     * </p>
     *
     * @param flushStageCacheRequest
     *        Requests API Gateway to flush a stage's cache.
     * @return Result of the FlushStageCache operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.FlushStageCache
     */
    @Override
    public FlushStageCacheResponse flushStageCache(FlushStageCacheRequest flushStageCacheRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<FlushStageCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                FlushStageCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FlushStageCache");

            return clientHandler.execute(new ClientExecutionParams<FlushStageCacheRequest, FlushStageCacheResponse>()
                    .withOperationName("FlushStageCache").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(flushStageCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new FlushStageCacheRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, flushStageCacheRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates a <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param generateClientCertificateRequest
     *        A request to generate a <a>ClientCertificate</a> resource.
     * @return Result of the GenerateClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GenerateClientCertificate
     */
    @Override
    public GenerateClientCertificateResponse generateClientCertificate(
            GenerateClientCertificateRequest generateClientCertificateRequest) throws UnauthorizedException,
            TooManyRequestsException, LimitExceededException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GenerateClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GenerateClientCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateClientCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<GenerateClientCertificateRequest, GenerateClientCertificateResponse>()
                            .withOperationName("GenerateClientCertificate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(generateClientCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GenerateClientCertificateRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                    generateClientCertificateRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the current <a>Account</a> resource.
     * </p>
     *
     * @param getAccountRequest
     *        Requests API Gateway to get information about the current <a>Account</a> resource.
     * @return Result of the GetAccount operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetAccount
     */
    @Override
    public GetAccountResponse getAccount(GetAccountRequest getAccountRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAccountResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccount");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAccountRequest, GetAccountResponse>().withOperationName("GetAccount")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getAccountRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAccountRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKey</a> resource.
     * </p>
     *
     * @param getApiKeyRequest
     *        A request to get information about the current <a>ApiKey</a> resource.
     * @return Result of the GetApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetApiKey
     */
    @Override
    public GetApiKeyResponse getApiKey(GetApiKeyRequest getApiKeyRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetApiKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApiKey");

            return clientHandler.execute(new ClientExecutionParams<GetApiKeyRequest, GetApiKeyResponse>()
                    .withOperationName("GetApiKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getApiKeyRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetApiKeyRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApiKeyRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKeys</a> resource.
     * </p>
     *
     * @param getApiKeysRequest
     *        A request to get information about the current <a>ApiKeys</a> resource.
     * @return Result of the GetApiKeys operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetApiKeys
     */
    @Override
    public GetApiKeysResponse getApiKeys(GetApiKeysRequest getApiKeysRequest) throws BadRequestException, UnauthorizedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApiKeysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetApiKeysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApiKeys");

            return clientHandler
                    .execute(new ClientExecutionParams<GetApiKeysRequest, GetApiKeysResponse>().withOperationName("GetApiKeys")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getApiKeysRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetApiKeysRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApiKeysRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKeys</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysIterable responses = client.getApiKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetApiKeysIterable responses = client.getApiKeysPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysIterable responses = client.getApiKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)} operation.</b>
     * </p>
     *
     * @param getApiKeysRequest
     *        A request to get information about the current <a>ApiKeys</a> resource.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetApiKeys
     */
    @Override
    public GetApiKeysIterable getApiKeysPaginator(GetApiKeysRequest getApiKeysRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return new GetApiKeysIterable(this, applyPaginatorUserAgent(getApiKeysRequest));
    }

    /**
     * <p>
     * Describe an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizer.html">AWS CLI</a></div>
     *
     * @param getAuthorizerRequest
     *        Request to describe an existing <a>Authorizer</a> resource.
     * @return Result of the GetAuthorizer operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetAuthorizer
     */
    @Override
    public GetAuthorizerResponse getAuthorizer(GetAuthorizerRequest getAuthorizerRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<GetAuthorizerRequest, GetAuthorizerResponse>()
                    .withOperationName("GetAuthorizer").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAuthorizerRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describe an existing <a>Authorizers</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizers.html">AWS CLI</a></div>
     *
     * @param getAuthorizersRequest
     *        Request to describe an existing <a>Authorizers</a> resource.
     * @return Result of the GetAuthorizers operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetAuthorizers
     */
    @Override
    public GetAuthorizersResponse getAuthorizers(GetAuthorizersRequest getAuthorizersRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAuthorizersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAuthorizersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAuthorizers");

            return clientHandler.execute(new ClientExecutionParams<GetAuthorizersRequest, GetAuthorizersResponse>()
                    .withOperationName("GetAuthorizers").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getAuthorizersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAuthorizersRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAuthorizersRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describe a <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param getBasePathMappingRequest
     *        Request to describe a <a>BasePathMapping</a> resource.
     * @return Result of the GetBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetBasePathMapping
     */
    @Override
    public GetBasePathMappingResponse getBasePathMapping(GetBasePathMappingRequest getBasePathMappingRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBasePathMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBasePathMapping");

            return clientHandler.execute(new ClientExecutionParams<GetBasePathMappingRequest, GetBasePathMappingResponse>()
                    .withOperationName("GetBasePathMapping").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBasePathMappingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBasePathMappingRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBasePathMappingRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Represents a collection of <a>BasePathMapping</a> resources.
     * </p>
     *
     * @param getBasePathMappingsRequest
     *        A request to get information about a collection of <a>BasePathMapping</a> resources.
     * @return Result of the GetBasePathMappings operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetBasePathMappings
     */
    @Override
    public GetBasePathMappingsResponse getBasePathMappings(GetBasePathMappingsRequest getBasePathMappingsRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBasePathMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBasePathMappingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBasePathMappings");

            return clientHandler.execute(new ClientExecutionParams<GetBasePathMappingsRequest, GetBasePathMappingsResponse>()
                    .withOperationName("GetBasePathMappings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBasePathMappingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBasePathMappingsRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBasePathMappingsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Represents a collection of <a>BasePathMapping</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBasePathMappings(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsIterable responses = client.getBasePathMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsIterable responses = client
     *             .getBasePathMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsIterable responses = client.getBasePathMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBasePathMappings(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getBasePathMappingsRequest
     *        A request to get information about a collection of <a>BasePathMapping</a> resources.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetBasePathMappings
     */
    @Override
    public GetBasePathMappingsIterable getBasePathMappingsPaginator(GetBasePathMappingsRequest getBasePathMappingsRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return new GetBasePathMappingsIterable(this, applyPaginatorUserAgent(getBasePathMappingsRequest));
    }

    /**
     * <p>
     * Gets information about the current <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param getClientCertificateRequest
     *        A request to get information about the current <a>ClientCertificate</a> resource.
     * @return Result of the GetClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetClientCertificate
     */
    @Override
    public GetClientCertificateResponse getClientCertificate(GetClientCertificateRequest getClientCertificateRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetClientCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetClientCertificate");

            return clientHandler.execute(new ClientExecutionParams<GetClientCertificateRequest, GetClientCertificateResponse>()
                    .withOperationName("GetClientCertificate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getClientCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetClientCertificateRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getClientCertificateRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a collection of <a>ClientCertificate</a> resources.
     * </p>
     *
     * @param getClientCertificatesRequest
     *        A request to get information about a collection of <a>ClientCertificate</a> resources.
     * @return Result of the GetClientCertificates operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetClientCertificates
     */
    @Override
    public GetClientCertificatesResponse getClientCertificates(GetClientCertificatesRequest getClientCertificatesRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetClientCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetClientCertificatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetClientCertificates");

            return clientHandler.execute(new ClientExecutionParams<GetClientCertificatesRequest, GetClientCertificatesResponse>()
                    .withOperationName("GetClientCertificates").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getClientCertificatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetClientCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getClientCertificatesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a collection of <a>ClientCertificate</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesIterable responses = client.getClientCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesIterable responses = client
     *             .getClientCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesIterable responses = client.getClientCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getClientCertificatesRequest
     *        A request to get information about a collection of <a>ClientCertificate</a> resources.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetClientCertificates
     */
    @Override
    public GetClientCertificatesIterable getClientCertificatesPaginator(GetClientCertificatesRequest getClientCertificatesRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return new GetClientCertificatesIterable(this, applyPaginatorUserAgent(getClientCertificatesRequest));
    }

    /**
     * <p>
     * Gets information about a <a>Deployment</a> resource.
     * </p>
     *
     * @param getDeploymentRequest
     *        Requests API Gateway to get information about a <a>Deployment</a> resource.
     * @return Result of the GetDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDeployment
     */
    @Override
    public GetDeploymentResponse getDeployment(GetDeploymentRequest getDeploymentRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeployment");

            return clientHandler.execute(new ClientExecutionParams<GetDeploymentRequest, GetDeploymentResponse>()
                    .withOperationName("GetDeployment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDeploymentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a <a>Deployments</a> collection.
     * </p>
     *
     * @param getDeploymentsRequest
     *        Requests API Gateway to get information about a <a>Deployments</a> collection.
     * @return Result of the GetDeployments operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDeployments
     */
    @Override
    public GetDeploymentsResponse getDeployments(GetDeploymentsRequest getDeploymentsRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDeploymentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeployments");

            return clientHandler.execute(new ClientExecutionParams<GetDeploymentsRequest, GetDeploymentsResponse>()
                    .withOperationName("GetDeployments").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDeploymentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDeploymentsRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a <a>Deployments</a> collection.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDeployments(software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsIterable responses = client.getDeploymentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsIterable responses = client
     *             .getDeploymentsPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsIterable responses = client.getDeploymentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDeployments(software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest)} operation.</b>
     * </p>
     *
     * @param getDeploymentsRequest
     *        Requests API Gateway to get information about a <a>Deployments</a> collection.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDeployments
     */
    @Override
    public GetDeploymentsIterable getDeploymentsPaginator(GetDeploymentsRequest getDeploymentsRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        return new GetDeploymentsIterable(this, applyPaginatorUserAgent(getDeploymentsRequest));
    }

    /**
     * Invokes the GetDocumentationPart operation.
     *
     * @param getDocumentationPartRequest
     *        Gets a specified documentation part of a given API.
     * @return Result of the GetDocumentationPart operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationPart
     */
    @Override
    public GetDocumentationPartResponse getDocumentationPart(GetDocumentationPartRequest getDocumentationPartRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDocumentationPartResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocumentationPart");

            return clientHandler.execute(new ClientExecutionParams<GetDocumentationPartRequest, GetDocumentationPartResponse>()
                    .withOperationName("GetDocumentationPart").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDocumentationPartRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDocumentationPartRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentationPartRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Invokes the GetDocumentationParts operation.
     *
     * @param getDocumentationPartsRequest
     *        Gets the documentation parts of an API. The result may be filtered by the type, name, or path of API
     *        entities (targets).
     * @return Result of the GetDocumentationParts operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationParts
     */
    @Override
    public GetDocumentationPartsResponse getDocumentationParts(GetDocumentationPartsRequest getDocumentationPartsRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDocumentationPartsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDocumentationPartsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocumentationParts");

            return clientHandler.execute(new ClientExecutionParams<GetDocumentationPartsRequest, GetDocumentationPartsResponse>()
                    .withOperationName("GetDocumentationParts").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDocumentationPartsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDocumentationPartsRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentationPartsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Invokes the GetDocumentationVersion operation.
     *
     * @param getDocumentationVersionRequest
     *        Gets a documentation snapshot of an API.
     * @return Result of the GetDocumentationVersion operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationVersion
     */
    @Override
    public GetDocumentationVersionResponse getDocumentationVersion(GetDocumentationVersionRequest getDocumentationVersionRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDocumentationVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocumentationVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDocumentationVersionRequest, GetDocumentationVersionResponse>()
                            .withOperationName("GetDocumentationVersion").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getDocumentationVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDocumentationVersionRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentationVersionRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Invokes the GetDocumentationVersions operation.
     *
     * @param getDocumentationVersionsRequest
     *        Gets the documentation versions of an API.
     * @return Result of the GetDocumentationVersions operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDocumentationVersions
     */
    @Override
    public GetDocumentationVersionsResponse getDocumentationVersions(
            GetDocumentationVersionsRequest getDocumentationVersionsRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDocumentationVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDocumentationVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocumentationVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDocumentationVersionsRequest, GetDocumentationVersionsResponse>()
                            .withOperationName("GetDocumentationVersions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getDocumentationVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDocumentationVersionsRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentationVersionsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Represents a domain name that is contained in a simpler, more intuitive URL that can be called.
     * </p>
     *
     * @param getDomainNameRequest
     *        Request to get the name of a <a>DomainName</a> resource.
     * @return Result of the GetDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDomainName
     */
    @Override
    public GetDomainNameResponse getDomainName(GetDomainNameRequest getDomainNameRequest) throws UnauthorizedException,
            NotFoundException, ServiceUnavailableException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDomainNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDomainName");

            return clientHandler.execute(new ClientExecutionParams<GetDomainNameRequest, GetDomainNameResponse>()
                    .withOperationName("GetDomainName").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDomainNameRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDomainNameRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDomainNameRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Represents a collection of <a>DomainName</a> resources.
     * </p>
     *
     * @param getDomainNamesRequest
     *        Request to describe a collection of <a>DomainName</a> resources.
     * @return Result of the GetDomainNames operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDomainNames
     */
    @Override
    public GetDomainNamesResponse getDomainNames(GetDomainNamesRequest getDomainNamesRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDomainNamesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDomainNamesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDomainNames");

            return clientHandler.execute(new ClientExecutionParams<GetDomainNamesRequest, GetDomainNamesResponse>()
                    .withOperationName("GetDomainNames").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDomainNamesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDomainNamesRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDomainNamesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Represents a collection of <a>DomainName</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesIterable responses = client.getDomainNamesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesIterable responses = client
     *             .getDomainNamesPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesIterable responses = client.getDomainNamesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation.</b>
     * </p>
     *
     * @param getDomainNamesRequest
     *        Request to describe a collection of <a>DomainName</a> resources.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetDomainNames
     */
    @Override
    public GetDomainNamesIterable getDomainNamesPaginator(GetDomainNamesRequest getDomainNamesRequest)
            throws BadRequestException, UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return new GetDomainNamesIterable(this, applyPaginatorUserAgent(getDomainNamesRequest));
    }

    /**
     * <p>
     * Exports a deployed version of a <a>RestApi</a> in a specified format.
     * </p>
     *
     * @param getExportRequest
     *        Request a new export of a <a>RestApi</a> for a particular <a>Stage</a>.
     * @return Result of the GetExport operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetExport
     */
    @Override
    public GetExportResponse getExport(GetExportRequest getExportRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(false).build();

        HttpResponseHandler<GetExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetExportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetExport");

            return clientHandler.execute(new ClientExecutionParams<GetExportRequest, GetExportResponse>()
                    .withOperationName("GetExport").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getExportRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetExportRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getExportRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * </p>
     *
     * @param getGatewayResponseRequest
     *        Gets a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * @return Result of the GetGatewayResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetGatewayResponse
     */
    @Override
    public GetGatewayResponseResponse getGatewayResponse(GetGatewayResponseRequest getGatewayResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetGatewayResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGatewayResponse");

            return clientHandler.execute(new ClientExecutionParams<GetGatewayResponseRequest, GetGatewayResponseResponse>()
                    .withOperationName("GetGatewayResponse").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getGatewayResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetGatewayResponseRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGatewayResponseRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the <a>GatewayResponses</a> collection on the given <a>RestApi</a>. If an API developer has not added any
     * definitions for gateway responses, the result will be the API Gateway-generated default <a>GatewayResponses</a>
     * collection for the supported response types.
     * </p>
     *
     * @param getGatewayResponsesRequest
     *        Gets the <a>GatewayResponses</a> collection on the given <a>RestApi</a>. If an API developer has not added
     *        any definitions for gateway responses, the result will be the API Gateway-generated default
     *        <a>GatewayResponses</a> collection for the supported response types.
     * @return Result of the GetGatewayResponses operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetGatewayResponses
     */
    @Override
    public GetGatewayResponsesResponse getGatewayResponses(GetGatewayResponsesRequest getGatewayResponsesRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGatewayResponsesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetGatewayResponsesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGatewayResponses");

            return clientHandler.execute(new ClientExecutionParams<GetGatewayResponsesRequest, GetGatewayResponsesResponse>()
                    .withOperationName("GetGatewayResponses").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getGatewayResponsesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetGatewayResponsesRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGatewayResponsesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the integration settings.
     * </p>
     *
     * @param getIntegrationRequest
     *        Represents a request to get the integration configuration.
     * @return Result of the GetIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetIntegration
     */
    @Override
    public GetIntegrationResponse getIntegration(GetIntegrationRequest getIntegrationRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetIntegrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntegration");

            return clientHandler.execute(new ClientExecutionParams<GetIntegrationRequest, GetIntegrationResponse>()
                    .withOperationName("GetIntegration").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntegrationRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Represents a get integration response.
     * </p>
     *
     * @param getIntegrationResponseRequest
     *        Represents a get integration response request.
     * @return Result of the GetIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetIntegrationResponse
     */
    @Override
    public GetIntegrationResponseResponse getIntegrationResponse(GetIntegrationResponseRequest getIntegrationResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetIntegrationResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntegrationResponse");

            return clientHandler
                    .execute(new ClientExecutionParams<GetIntegrationResponseRequest, GetIntegrationResponseResponse>()
                            .withOperationName("GetIntegrationResponse").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getIntegrationResponseRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetIntegrationResponseRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntegrationResponseRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describe an existing <a>Method</a> resource.
     * </p>
     *
     * @param getMethodRequest
     *        Request to describe an existing <a>Method</a> resource.
     * @return Result of the GetMethod operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetMethod
     */
    @Override
    public GetMethodResponse getMethod(GetMethodRequest getMethodRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMethodResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMethodResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMethod");

            return clientHandler.execute(new ClientExecutionParams<GetMethodRequest, GetMethodResponse>()
                    .withOperationName("GetMethod").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getMethodRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetMethodRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMethodRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a <a>MethodResponse</a> resource.
     * </p>
     *
     * @param getMethodResponseRequest
     *        Request to describe a <a>MethodResponse</a> resource.
     * @return Result of the GetMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetMethodResponse
     */
    @Override
    public GetMethodResponseResponse getMethodResponse(GetMethodResponseRequest getMethodResponseRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMethodResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMethodResponse");

            return clientHandler.execute(new ClientExecutionParams<GetMethodResponseRequest, GetMethodResponseResponse>()
                    .withOperationName("GetMethodResponse").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getMethodResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMethodResponseRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMethodResponseRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an existing model defined for a <a>RestApi</a> resource.
     * </p>
     *
     * @param getModelRequest
     *        Request to list information about a model in an existing <a>RestApi</a> resource.
     * @return Result of the GetModel operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModel
     */
    @Override
    public GetModelResponse getModel(GetModelRequest getModelRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModel");

            return clientHandler.execute(new ClientExecutionParams<GetModelRequest, GetModelResponse>()
                    .withOperationName("GetModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getModelRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetModelRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates a sample mapping template that can be used to transform a payload into the structure of a model.
     * </p>
     *
     * @param getModelTemplateRequest
     *        Request to generate a sample mapping template used to transform the payload.
     * @return Result of the GetModelTemplate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModelTemplate
     */
    @Override
    public GetModelTemplateResponse getModelTemplate(GetModelTemplateRequest getModelTemplateRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetModelTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetModelTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModelTemplate");

            return clientHandler.execute(new ClientExecutionParams<GetModelTemplateRequest, GetModelTemplateResponse>()
                    .withOperationName("GetModelTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getModelTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetModelTemplateRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelTemplateRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * </p>
     *
     * @param getModelsRequest
     *        Request to list existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * @return Result of the GetModels operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModels
     */
    @Override
    public GetModelsResponse getModels(GetModelsRequest getModelsRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetModelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetModelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModels");

            return clientHandler.execute(new ClientExecutionParams<GetModelsRequest, GetModelsResponse>()
                    .withOperationName("GetModels").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getModelsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetModelsRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getModels(software.amazon.awssdk.services.apigateway.model.GetModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getModels(software.amazon.awssdk.services.apigateway.model.GetModelsRequest)} operation.</b>
     * </p>
     *
     * @param getModelsRequest
     *        Request to list existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetModels
     */
    @Override
    public GetModelsIterable getModelsPaginator(GetModelsRequest getModelsRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return new GetModelsIterable(this, applyPaginatorUserAgent(getModelsRequest));
    }

    /**
     * <p>
     * Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param getRequestValidatorRequest
     *        Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the GetRequestValidator operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRequestValidator
     */
    @Override
    public GetRequestValidatorResponse getRequestValidator(GetRequestValidatorRequest getRequestValidatorRequest)
            throws UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRequestValidatorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRequestValidator");

            return clientHandler.execute(new ClientExecutionParams<GetRequestValidatorRequest, GetRequestValidatorResponse>()
                    .withOperationName("GetRequestValidator").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getRequestValidatorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRequestValidatorRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRequestValidatorRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the <a>RequestValidators</a> collection of a given <a>RestApi</a>.
     * </p>
     *
     * @param getRequestValidatorsRequest
     *        Gets the <a>RequestValidators</a> collection of a given <a>RestApi</a>.
     * @return Result of the GetRequestValidators operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRequestValidators
     */
    @Override
    public GetRequestValidatorsResponse getRequestValidators(GetRequestValidatorsRequest getRequestValidatorsRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRequestValidatorsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRequestValidatorsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRequestValidators");

            return clientHandler.execute(new ClientExecutionParams<GetRequestValidatorsRequest, GetRequestValidatorsResponse>()
                    .withOperationName("GetRequestValidators").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getRequestValidatorsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRequestValidatorsRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRequestValidatorsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists information about a resource.
     * </p>
     *
     * @param getResourceRequest
     *        Request to list information about a resource.
     * @return Result of the GetResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetResource
     */
    @Override
    public GetResourceResponse getResource(GetResourceRequest getResourceRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResource");

            return clientHandler.execute(new ClientExecutionParams<GetResourceRequest, GetResourceResponse>()
                    .withOperationName("GetResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetResourceRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists information about a collection of <a>Resource</a> resources.
     * </p>
     *
     * @param getResourcesRequest
     *        Request to list information about a collection of resources.
     * @return Result of the GetResources operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetResources
     */
    @Override
    public GetResourcesResponse getResources(GetResourcesRequest getResourcesRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetResourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResources");

            return clientHandler.execute(new ClientExecutionParams<GetResourcesRequest, GetResourcesResponse>()
                    .withOperationName("GetResources").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getResourcesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetResourcesRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourcesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists information about a collection of <a>Resource</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getResources(software.amazon.awssdk.services.apigateway.model.GetResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetResourcesIterable responses = client.getResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetResourcesIterable responses = client.getResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetResourcesIterable responses = client.getResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResources(software.amazon.awssdk.services.apigateway.model.GetResourcesRequest)} operation.</b>
     * </p>
     *
     * @param getResourcesRequest
     *        Request to list information about a collection of resources.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetResources
     */
    @Override
    public GetResourcesIterable getResourcesPaginator(GetResourcesRequest getResourcesRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        return new GetResourcesIterable(this, applyPaginatorUserAgent(getResourcesRequest));
    }

    /**
     * <p>
     * Lists the <a>RestApi</a> resource in the collection.
     * </p>
     *
     * @param getRestApiRequest
     *        The GET request to list an existing <a>RestApi</a> defined for your collection.
     * @return Result of the GetRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRestApi
     */
    @Override
    public GetRestApiResponse getRestApi(GetRestApiRequest getRestApiRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRestApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRestApi");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRestApiRequest, GetRestApiResponse>().withOperationName("GetRestApi")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRestApiRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRestApiRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRestApiRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the <a>RestApis</a> resources for your collection.
     * </p>
     *
     * @param getRestApisRequest
     *        The GET request to list existing <a>RestApis</a> defined for your collection.
     * @return Result of the GetRestApis operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRestApis
     */
    @Override
    public GetRestApisResponse getRestApis(GetRestApisRequest getRestApisRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRestApisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRestApisResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRestApis");

            return clientHandler.execute(new ClientExecutionParams<GetRestApisRequest, GetRestApisResponse>()
                    .withOperationName("GetRestApis").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getRestApisRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRestApisRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRestApisRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the <a>RestApis</a> resources for your collection.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisIterable responses = client.getRestApisPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetRestApisIterable responses = client.getRestApisPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetRestApisResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisIterable responses = client.getRestApisPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)} operation.</b>
     * </p>
     *
     * @param getRestApisRequest
     *        The GET request to list existing <a>RestApis</a> defined for your collection.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetRestApis
     */
    @Override
    public GetRestApisIterable getRestApisPaginator(GetRestApisRequest getRestApisRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return new GetRestApisIterable(this, applyPaginatorUserAgent(getRestApisRequest));
    }

    /**
     * <p>
     * Generates a client SDK for a <a>RestApi</a> and <a>Stage</a>.
     * </p>
     *
     * @param getSdkRequest
     *        Request a new generated client SDK for a <a>RestApi</a> and <a>Stage</a>.
     * @return Result of the GetSdk operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetSdk
     */
    @Override
    public GetSdkResponse getSdk(GetSdkRequest getSdkRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(false).build();

        HttpResponseHandler<GetSdkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSdkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSdk");

            return clientHandler.execute(new ClientExecutionParams<GetSdkRequest, GetSdkResponse>().withOperationName("GetSdk")
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getSdkRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetSdkRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSdkRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Invokes the GetSdkType operation.
     *
     * @param getSdkTypeRequest
     *        Get an <a>SdkType</a> instance.
     * @return Result of the GetSdkType operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetSdkType
     */
    @Override
    public GetSdkTypeResponse getSdkType(GetSdkTypeRequest getSdkTypeRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSdkTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSdkTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSdkType");

            return clientHandler
                    .execute(new ClientExecutionParams<GetSdkTypeRequest, GetSdkTypeResponse>().withOperationName("GetSdkType")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getSdkTypeRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetSdkTypeRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSdkTypeRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Invokes the GetSdkTypes operation.
     *
     * @param getSdkTypesRequest
     *        Get the <a>SdkTypes</a> collection.
     * @return Result of the GetSdkTypes operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetSdkTypes
     */
    @Override
    public GetSdkTypesResponse getSdkTypes(GetSdkTypesRequest getSdkTypesRequest) throws UnauthorizedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSdkTypesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSdkTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSdkTypes");

            return clientHandler.execute(new ClientExecutionParams<GetSdkTypesRequest, GetSdkTypesResponse>()
                    .withOperationName("GetSdkTypes").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getSdkTypesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSdkTypesRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSdkTypesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a <a>Stage</a> resource.
     * </p>
     *
     * @param getStageRequest
     *        Requests API Gateway to get information about a <a>Stage</a> resource.
     * @return Result of the GetStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetStage
     */
    @Override
    public GetStageResponse getStage(GetStageRequest getStageRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetStageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStage");

            return clientHandler.execute(new ClientExecutionParams<GetStageRequest, GetStageResponse>()
                    .withOperationName("GetStage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getStageRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetStageRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStageRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about one or more <a>Stage</a> resources.
     * </p>
     *
     * @param getStagesRequest
     *        Requests API Gateway to get information about one or more <a>Stage</a> resources.
     * @return Result of the GetStages operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetStages
     */
    @Override
    public GetStagesResponse getStages(GetStagesRequest getStagesRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetStagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStages");

            return clientHandler.execute(new ClientExecutionParams<GetStagesRequest, GetStagesResponse>()
                    .withOperationName("GetStages").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getStagesRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetStagesRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStagesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the <a>Tags</a> collection for a given resource.
     * </p>
     *
     * @param getTagsRequest
     *        Gets the <a>Tags</a> collection for a given resource.
     * @return Result of the GetTags operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetTags
     */
    @Override
    public GetTagsResponse getTags(GetTagsRequest getTagsRequest) throws BadRequestException, UnauthorizedException,
            TooManyRequestsException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTags");

            return clientHandler.execute(new ClientExecutionParams<GetTagsRequest, GetTagsResponse>()
                    .withOperationName("GetTags").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getTagsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetTagsRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTagsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the usage data of a usage plan in a specified time interval.
     * </p>
     *
     * @param getUsageRequest
     *        The GET request to get the usage data of a usage plan in a specified time interval.
     * @return Result of the GetUsage operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsage
     */
    @Override
    public GetUsageResponse getUsage(GetUsageRequest getUsageRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUsageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUsageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsage");

            return clientHandler.execute(new ClientExecutionParams<GetUsageRequest, GetUsageResponse>()
                    .withOperationName("GetUsage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getUsageRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetUsageRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsageRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the usage data of a usage plan in a specified time interval.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getUsage(software.amazon.awssdk.services.apigateway.model.GetUsageRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsageIterable responses = client.getUsagePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetUsageIterable responses = client.getUsagePaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetUsageResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsageIterable responses = client.getUsagePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsage(software.amazon.awssdk.services.apigateway.model.GetUsageRequest)} operation.</b>
     * </p>
     *
     * @param getUsageRequest
     *        The GET request to get the usage data of a usage plan in a specified time interval.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsage
     */
    @Override
    public GetUsageIterable getUsagePaginator(GetUsageRequest getUsageRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return new GetUsageIterable(this, applyPaginatorUserAgent(getUsageRequest));
    }

    /**
     * <p>
     * Gets a usage plan of a given plan identifier.
     * </p>
     *
     * @param getUsagePlanRequest
     *        The GET request to get a usage plan of a given plan identifier.
     * @return Result of the GetUsagePlan operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlan
     */
    @Override
    public GetUsagePlanResponse getUsagePlan(GetUsagePlanRequest getUsagePlanRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUsagePlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsagePlan");

            return clientHandler.execute(new ClientExecutionParams<GetUsagePlanRequest, GetUsagePlanResponse>()
                    .withOperationName("GetUsagePlan").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getUsagePlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetUsagePlanRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsagePlanRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a usage plan key of a given key identifier.
     * </p>
     *
     * @param getUsagePlanKeyRequest
     *        The GET request to get a usage plan key of a given key identifier.
     * @return Result of the GetUsagePlanKey operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlanKey
     */
    @Override
    public GetUsagePlanKeyResponse getUsagePlanKey(GetUsagePlanKeyRequest getUsagePlanKeyRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUsagePlanKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUsagePlanKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsagePlanKey");

            return clientHandler.execute(new ClientExecutionParams<GetUsagePlanKeyRequest, GetUsagePlanKeyResponse>()
                    .withOperationName("GetUsagePlanKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getUsagePlanKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetUsagePlanKeyRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsagePlanKeyRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     * </p>
     *
     * @param getUsagePlanKeysRequest
     *        The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.
     * @return Result of the GetUsagePlanKeys operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlanKeys
     */
    @Override
    public GetUsagePlanKeysResponse getUsagePlanKeys(GetUsagePlanKeysRequest getUsagePlanKeysRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUsagePlanKeysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUsagePlanKeysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsagePlanKeys");

            return clientHandler.execute(new ClientExecutionParams<GetUsagePlanKeysRequest, GetUsagePlanKeysResponse>()
                    .withOperationName("GetUsagePlanKeys").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getUsagePlanKeysRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetUsagePlanKeysRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsagePlanKeysRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUsagePlanKeys(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysIterable responses = client.getUsagePlanKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysIterable responses = client
     *             .getUsagePlanKeysPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysIterable responses = client.getUsagePlanKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsagePlanKeys(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUsagePlanKeysRequest
     *        The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlanKeys
     */
    @Override
    public GetUsagePlanKeysIterable getUsagePlanKeysPaginator(GetUsagePlanKeysRequest getUsagePlanKeysRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return new GetUsagePlanKeysIterable(this, applyPaginatorUserAgent(getUsagePlanKeysRequest));
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     *
     * @param getUsagePlansRequest
     *        The GET request to get all the usage plans of the caller's account.
     * @return Result of the GetUsagePlans operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlans
     */
    @Override
    public GetUsagePlansResponse getUsagePlans(GetUsagePlansRequest getUsagePlansRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, ConflictException, NotFoundException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUsagePlansResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUsagePlansResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsagePlans");

            return clientHandler.execute(new ClientExecutionParams<GetUsagePlansRequest, GetUsagePlansResponse>()
                    .withOperationName("GetUsagePlans").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getUsagePlansRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetUsagePlansRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsagePlansRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansIterable responses = client.getUsagePlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansIterable responses = client
     *             .getUsagePlansPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansIterable responses = client.getUsagePlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation.</b>
     * </p>
     *
     * @param getUsagePlansRequest
     *        The GET request to get all the usage plans of the caller's account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetUsagePlans
     */
    @Override
    public GetUsagePlansIterable getUsagePlansPaginator(GetUsagePlansRequest getUsagePlansRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, ConflictException, NotFoundException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        return new GetUsagePlansIterable(this, applyPaginatorUserAgent(getUsagePlansRequest));
    }

    /**
     * <p>
     * Gets a specified VPC link under the caller's account in a region.
     * </p>
     *
     * @param getVpcLinkRequest
     *        Gets a specified VPC link under the caller's account in a region.
     * @return Result of the GetVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetVpcLink
     */
    @Override
    public GetVpcLinkResponse getVpcLink(GetVpcLinkRequest getVpcLinkRequest) throws UnauthorizedException, NotFoundException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetVpcLinkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVpcLink");

            return clientHandler
                    .execute(new ClientExecutionParams<GetVpcLinkRequest, GetVpcLinkResponse>().withOperationName("GetVpcLink")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getVpcLinkRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetVpcLinkRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVpcLinkRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * </p>
     *
     * @param getVpcLinksRequest
     *        Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * @return Result of the GetVpcLinks operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetVpcLinks
     */
    @Override
    public GetVpcLinksResponse getVpcLinks(GetVpcLinksRequest getVpcLinksRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVpcLinksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetVpcLinksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVpcLinks");

            return clientHandler.execute(new ClientExecutionParams<GetVpcLinksRequest, GetVpcLinksResponse>()
                    .withOperationName("GetVpcLinks").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getVpcLinksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetVpcLinksRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVpcLinksRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksIterable responses = client.getVpcLinksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksIterable responses = client.getVpcLinksPaginator(request);
     *     for (software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksIterable responses = client.getVpcLinksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)} operation.</b>
     * </p>
     *
     * @param getVpcLinksRequest
     *        Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.GetVpcLinks
     */
    @Override
    public GetVpcLinksIterable getVpcLinksPaginator(GetVpcLinksRequest getVpcLinksRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        return new GetVpcLinksIterable(this, applyPaginatorUserAgent(getVpcLinksRequest));
    }

    /**
     * <p>
     * Import API keys from an external source, such as a CSV-formatted file.
     * </p>
     *
     * @param importApiKeysRequest
     *        The POST request to import API keys from an external source, such as a CSV-formatted file.
     * @return Result of the ImportApiKeys operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.ImportApiKeys
     */
    @Override
    public ImportApiKeysResponse importApiKeys(ImportApiKeysRequest importApiKeysRequest) throws UnauthorizedException,
            NotFoundException, TooManyRequestsException, LimitExceededException, BadRequestException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportApiKeysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ImportApiKeysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportApiKeys");

            return clientHandler.execute(new ClientExecutionParams<ImportApiKeysRequest, ImportApiKeysResponse>()
                    .withOperationName("ImportApiKeys").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(importApiKeysRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportApiKeysRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importApiKeysRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Invokes the ImportDocumentationParts operation.
     *
     * @param importDocumentationPartsRequest
     *        Import documentation parts from an external (e.g., OpenAPI) definition file.
     * @return Result of the ImportDocumentationParts operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.ImportDocumentationParts
     */
    @Override
    public ImportDocumentationPartsResponse importDocumentationParts(
            ImportDocumentationPartsRequest importDocumentationPartsRequest) throws UnauthorizedException, NotFoundException,
            BadRequestException, LimitExceededException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportDocumentationPartsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ImportDocumentationPartsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportDocumentationParts");

            return clientHandler
                    .execute(new ClientExecutionParams<ImportDocumentationPartsRequest, ImportDocumentationPartsResponse>()
                            .withOperationName("ImportDocumentationParts").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(importDocumentationPartsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ImportDocumentationPartsRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importDocumentationPartsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A feature of the API Gateway control service for creating a new API from an external API definition file.
     * </p>
     *
     * @param importRestApiRequest
     *        A POST request to import an API to API Gateway using an input of an API definition file.
     * @return Result of the ImportRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.ImportRestApi
     */
    @Override
    public ImportRestApiResponse importRestApi(ImportRestApiRequest importRestApiRequest) throws UnauthorizedException,
            LimitExceededException, BadRequestException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ImportRestApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportRestApi");

            return clientHandler.execute(new ClientExecutionParams<ImportRestApiRequest, ImportRestApiResponse>()
                    .withOperationName("ImportRestApi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(importRestApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportRestApiRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importRestApiRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code on the given
     * <a>RestApi</a>.
     * </p>
     *
     * @param putGatewayResponseRequest
     *        Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code on the
     *        given <a>RestApi</a>.
     * @return Result of the PutGatewayResponse operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutGatewayResponse
     */
    @Override
    public PutGatewayResponseResponse putGatewayResponse(PutGatewayResponseRequest putGatewayResponseRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutGatewayResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutGatewayResponse");

            return clientHandler.execute(new ClientExecutionParams<PutGatewayResponseRequest, PutGatewayResponseResponse>()
                    .withOperationName("PutGatewayResponse").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putGatewayResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutGatewayResponseRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putGatewayResponseRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets up a method's integration.
     * </p>
     *
     * @param putIntegrationRequest
     *        Sets up a method's integration.
     * @return Result of the PutIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutIntegration
     */
    @Override
    public PutIntegrationResponse putIntegration(PutIntegrationRequest putIntegrationRequest) throws UnauthorizedException,
            BadRequestException, ConflictException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutIntegrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutIntegration");

            return clientHandler.execute(new ClientExecutionParams<PutIntegrationRequest, PutIntegrationResponse>()
                    .withOperationName("PutIntegration").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putIntegrationRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Represents a put integration.
     * </p>
     *
     * @param putIntegrationResponseRequest
     *        Represents a put integration response request.
     * @return Result of the PutIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutIntegrationResponse
     */
    @Override
    public PutIntegrationResponseResponse putIntegrationResponse(PutIntegrationResponseRequest putIntegrationResponseRequest)
            throws UnauthorizedException, NotFoundException, LimitExceededException, BadRequestException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutIntegrationResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutIntegrationResponse");

            return clientHandler
                    .execute(new ClientExecutionParams<PutIntegrationResponseRequest, PutIntegrationResponseResponse>()
                            .withOperationName("PutIntegrationResponse").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putIntegrationResponseRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutIntegrationResponseRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putIntegrationResponseRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Add a method to an existing <a>Resource</a> resource.
     * </p>
     *
     * @param putMethodRequest
     *        Request to add a method to an existing <a>Resource</a> resource.
     * @return Result of the PutMethod operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutMethod
     */
    @Override
    public PutMethodResponse putMethod(PutMethodRequest putMethodRequest) throws BadRequestException, UnauthorizedException,
            NotFoundException, ConflictException, LimitExceededException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutMethodResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutMethodResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMethod");

            return clientHandler.execute(new ClientExecutionParams<PutMethodRequest, PutMethodResponse>()
                    .withOperationName("PutMethod").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putMethodRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new PutMethodRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putMethodRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a <a>MethodResponse</a> to an existing <a>Method</a> resource.
     * </p>
     *
     * @param putMethodResponseRequest
     *        Request to add a <a>MethodResponse</a> to an existing <a>Method</a> resource.
     * @return Result of the PutMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutMethodResponse
     */
    @Override
    public PutMethodResponseResponse putMethodResponse(PutMethodResponseRequest putMethodResponseRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, LimitExceededException, BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutMethodResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMethodResponse");

            return clientHandler.execute(new ClientExecutionParams<PutMethodResponseRequest, PutMethodResponseResponse>()
                    .withOperationName("PutMethodResponse").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putMethodResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutMethodResponseRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putMethodResponseRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A feature of the API Gateway control service for updating an existing API with an input of external API
     * definitions. The update can take the form of merging the supplied definition into the existing API or overwriting
     * the existing API.
     * </p>
     *
     * @param putRestApiRequest
     *        A PUT request to update an existing API, with external API definitions specified as the request body.
     * @return Result of the PutRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.PutRestApi
     */
    @Override
    public PutRestApiResponse putRestApi(PutRestApiRequest putRestApiRequest) throws UnauthorizedException,
            LimitExceededException, NotFoundException, BadRequestException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutRestApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRestApi");

            return clientHandler
                    .execute(new ClientExecutionParams<PutRestApiRequest, PutRestApiResponse>().withOperationName("PutRestApi")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putRestApiRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutRestApiRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRestApiRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or updates a tag on a given resource.
     * </p>
     *
     * @param tagResourceRequest
     *        Adds or updates a tag on a given resource.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.TagResource
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, NotFoundException, LimitExceededException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Simulate the execution of an <a>Authorizer</a> in your <a>RestApi</a> with headers, parameters, and an incoming
     * request body.
     * </p>
     * <div class="seeAlso"> <a
     * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">Use
     * Lambda Function as Authorizer</a> <a
     * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">Use
     * Cognito User Pool as Authorizer</a> </div>
     *
     * @param testInvokeAuthorizerRequest
     *        Make a request to simulate the execution of an <a>Authorizer</a>.
     * @return Result of the TestInvokeAuthorizer operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.TestInvokeAuthorizer
     */
    @Override
    public TestInvokeAuthorizerResponse testInvokeAuthorizer(TestInvokeAuthorizerRequest testInvokeAuthorizerRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TestInvokeAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, TestInvokeAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestInvokeAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<TestInvokeAuthorizerRequest, TestInvokeAuthorizerResponse>()
                    .withOperationName("TestInvokeAuthorizer").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(testInvokeAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TestInvokeAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testInvokeAuthorizerRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Simulate the execution of a <a>Method</a> in your <a>RestApi</a> with headers, parameters, and an incoming
     * request body.
     * </p>
     *
     * @param testInvokeMethodRequest
     *        Make a request to simulate the execution of a <a>Method</a>.
     * @return Result of the TestInvokeMethod operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.TestInvokeMethod
     */
    @Override
    public TestInvokeMethodResponse testInvokeMethod(TestInvokeMethodRequest testInvokeMethodRequest) throws BadRequestException,
            UnauthorizedException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TestInvokeMethodResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TestInvokeMethodResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestInvokeMethod");

            return clientHandler.execute(new ClientExecutionParams<TestInvokeMethodRequest, TestInvokeMethodResponse>()
                    .withOperationName("TestInvokeMethod").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(testInvokeMethodRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TestInvokeMethodRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testInvokeMethodRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a tag from a given resource.
     * </p>
     *
     * @param untagResourceRequest
     *        Removes a tag from a given resource.
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UntagResource
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            UnauthorizedException, TooManyRequestsException, NotFoundException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes information about the current <a>Account</a> resource.
     * </p>
     *
     * @param updateAccountRequest
     *        Requests API Gateway to change information about the current <a>Account</a> resource.
     * @return Result of the UpdateAccount operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateAccount
     */
    @Override
    public UpdateAccountResponse updateAccount(UpdateAccountRequest updateAccountRequest) throws UnauthorizedException,
            BadRequestException, NotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAccountResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccount");

            return clientHandler.execute(new ClientExecutionParams<UpdateAccountRequest, UpdateAccountResponse>()
                    .withOperationName("UpdateAccount").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateAccountRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAccountRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccountRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes information about an <a>ApiKey</a> resource.
     * </p>
     *
     * @param updateApiKeyRequest
     *        A request to change information about an <a>ApiKey</a> resource.
     * @return Result of the UpdateApiKey operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateApiKey
     */
    @Override
    public UpdateApiKeyResponse updateApiKey(UpdateApiKeyRequest updateApiKeyRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateApiKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApiKey");

            return clientHandler.execute(new ClientExecutionParams<UpdateApiKeyRequest, UpdateApiKeyResponse>()
                    .withOperationName("UpdateApiKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateApiKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateApiKeyRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApiKeyRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/update-authorizer.html">AWS CLI</a></div>
     *
     * @param updateAuthorizerRequest
     *        Request to update an existing <a>Authorizer</a> resource.
     * @return Result of the UpdateAuthorizer operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateAuthorizer
     */
    @Override
    public UpdateAuthorizerResponse updateAuthorizer(UpdateAuthorizerRequest updateAuthorizerRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<UpdateAuthorizerRequest, UpdateAuthorizerResponse>()
                    .withOperationName("UpdateAuthorizer").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAuthorizerRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes information about the <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param updateBasePathMappingRequest
     *        A request to change information about the <a>BasePathMapping</a> resource.
     * @return Result of the UpdateBasePathMapping operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateBasePathMapping
     */
    @Override
    public UpdateBasePathMappingResponse updateBasePathMapping(UpdateBasePathMappingRequest updateBasePathMappingRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, BadRequestException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBasePathMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBasePathMapping");

            return clientHandler.execute(new ClientExecutionParams<UpdateBasePathMappingRequest, UpdateBasePathMappingResponse>()
                    .withOperationName("UpdateBasePathMapping").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateBasePathMappingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBasePathMappingRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBasePathMappingRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes information about an <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param updateClientCertificateRequest
     *        A request to change information about an <a>ClientCertificate</a> resource.
     * @return Result of the UpdateClientCertificate operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateClientCertificate
     */
    @Override
    public UpdateClientCertificateResponse updateClientCertificate(UpdateClientCertificateRequest updateClientCertificateRequest)
            throws UnauthorizedException, TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateClientCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateClientCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateClientCertificateRequest, UpdateClientCertificateResponse>()
                            .withOperationName("UpdateClientCertificate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateClientCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateClientCertificateRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateClientCertificateRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes information about a <a>Deployment</a> resource.
     * </p>
     *
     * @param updateDeploymentRequest
     *        Requests API Gateway to change information about a <a>Deployment</a> resource.
     * @return Result of the UpdateDeployment operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ServiceUnavailableException
     *         The requested service is not available. For details see the accompanying error message. Retry after the
     *         specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDeployment
     */
    @Override
    public UpdateDeploymentResponse updateDeployment(UpdateDeploymentRequest updateDeploymentRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDeployment");

            return clientHandler.execute(new ClientExecutionParams<UpdateDeploymentRequest, UpdateDeploymentResponse>()
                    .withOperationName("UpdateDeployment").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateDeploymentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDeploymentRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Invokes the UpdateDocumentationPart operation.
     *
     * @param updateDocumentationPartRequest
     *        Updates an existing documentation part of a given API.
     * @return Result of the UpdateDocumentationPart operation returned by the service.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDocumentationPart
     */
    @Override
    public UpdateDocumentationPartResponse updateDocumentationPart(UpdateDocumentationPartRequest updateDocumentationPartRequest)
            throws BadRequestException, UnauthorizedException, NotFoundException, ConflictException, LimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDocumentationPartResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDocumentationPart");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDocumentationPartRequest, UpdateDocumentationPartResponse>()
                            .withOperationName("UpdateDocumentationPart").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateDocumentationPartRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDocumentationPartRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDocumentationPartRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Invokes the UpdateDocumentationVersion operation.
     *
     * @param updateDocumentationVersionRequest
     *        Updates an existing documentation version of an API.
     * @return Result of the UpdateDocumentationVersion operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDocumentationVersion
     */
    @Override
    public UpdateDocumentationVersionResponse updateDocumentationVersion(
            UpdateDocumentationVersionRequest updateDocumentationVersionRequest) throws UnauthorizedException, NotFoundException,
            ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDocumentationVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDocumentationVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDocumentationVersionRequest, UpdateDocumentationVersionResponse>()
                            .withOperationName("UpdateDocumentationVersion").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateDocumentationVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDocumentationVersionRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                    updateDocumentationVersionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes information about the <a>DomainName</a> resource.
     * </p>
     *
     * @param updateDomainNameRequest
     *        A request to change information about the <a>DomainName</a> resource.
     * @return Result of the UpdateDomainName operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateDomainName
     */
    @Override
    public UpdateDomainNameResponse updateDomainName(UpdateDomainNameRequest updateDomainNameRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, ConflictException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDomainNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDomainName");

            return clientHandler.execute(new ClientExecutionParams<UpdateDomainNameRequest, UpdateDomainNameResponse>()
                    .withOperationName("UpdateDomainName").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateDomainNameRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDomainNameRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDomainNameRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * </p>
     *
     * @param updateGatewayResponseRequest
     *        Updates a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * @return Result of the UpdateGatewayResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateGatewayResponse
     */
    @Override
    public UpdateGatewayResponseResponse updateGatewayResponse(UpdateGatewayResponseRequest updateGatewayResponseRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateGatewayResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGatewayResponse");

            return clientHandler.execute(new ClientExecutionParams<UpdateGatewayResponseRequest, UpdateGatewayResponseResponse>()
                    .withOperationName("UpdateGatewayResponse").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateGatewayResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateGatewayResponseRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGatewayResponseRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Represents an update integration.
     * </p>
     *
     * @param updateIntegrationRequest
     *        Represents an update integration request.
     * @return Result of the UpdateIntegration operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateIntegration
     */
    @Override
    public UpdateIntegrationResponse updateIntegration(UpdateIntegrationRequest updateIntegrationRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateIntegrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIntegration");

            return clientHandler.execute(new ClientExecutionParams<UpdateIntegrationRequest, UpdateIntegrationResponse>()
                    .withOperationName("UpdateIntegration").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIntegrationRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Represents an update integration response.
     * </p>
     *
     * @param updateIntegrationResponseRequest
     *        Represents an update integration response request.
     * @return Result of the UpdateIntegrationResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateIntegrationResponse
     */
    @Override
    public UpdateIntegrationResponseResponse updateIntegrationResponse(
            UpdateIntegrationResponseRequest updateIntegrationResponseRequest) throws UnauthorizedException, NotFoundException,
            ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateIntegrationResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIntegrationResponse");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateIntegrationResponseRequest, UpdateIntegrationResponseResponse>()
                            .withOperationName("UpdateIntegrationResponse").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateIntegrationResponseRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateIntegrationResponseRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                    updateIntegrationResponseRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing <a>Method</a> resource.
     * </p>
     *
     * @param updateMethodRequest
     *        Request to update an existing <a>Method</a> resource.
     * @return Result of the UpdateMethod operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateMethod
     */
    @Override
    public UpdateMethodResponse updateMethod(UpdateMethodRequest updateMethodRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMethodResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateMethodResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMethod");

            return clientHandler.execute(new ClientExecutionParams<UpdateMethodRequest, UpdateMethodResponse>()
                    .withOperationName("UpdateMethod").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateMethodRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateMethodRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMethodRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing <a>MethodResponse</a> resource.
     * </p>
     *
     * @param updateMethodResponseRequest
     *        A request to update an existing <a>MethodResponse</a> resource.
     * @return Result of the UpdateMethodResponse operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws LimitExceededException
     *         The request exceeded the rate limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateMethodResponse
     */
    @Override
    public UpdateMethodResponseResponse updateMethodResponse(UpdateMethodResponseRequest updateMethodResponseRequest)
            throws UnauthorizedException, NotFoundException, ConflictException, LimitExceededException, BadRequestException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateMethodResponseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMethodResponse");

            return clientHandler.execute(new ClientExecutionParams<UpdateMethodResponseRequest, UpdateMethodResponseResponse>()
                    .withOperationName("UpdateMethodResponse").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateMethodResponseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateMethodResponseRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMethodResponseRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes information about a model.
     * </p>
     *
     * @param updateModelRequest
     *        Request to update an existing model in an existing <a>RestApi</a> resource.
     * @return Result of the UpdateModel operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateModel
     */
    @Override
    public UpdateModelResponse updateModel(UpdateModelRequest updateModelRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateModelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateModel");

            return clientHandler.execute(new ClientExecutionParams<UpdateModelRequest, UpdateModelResponse>()
                    .withOperationName("UpdateModel").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateModelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateModelRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateModelRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param updateRequestValidatorRequest
     *        Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return Result of the UpdateRequestValidator operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateRequestValidator
     */
    @Override
    public UpdateRequestValidatorResponse updateRequestValidator(UpdateRequestValidatorRequest updateRequestValidatorRequest)
            throws UnauthorizedException, NotFoundException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRequestValidatorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRequestValidator");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateRequestValidatorRequest, UpdateRequestValidatorResponse>()
                            .withOperationName("UpdateRequestValidator").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateRequestValidatorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateRequestValidatorRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRequestValidatorRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes information about a <a>Resource</a> resource.
     * </p>
     *
     * @param updateResourceRequest
     *        Request to change information about a <a>Resource</a> resource.
     * @return Result of the UpdateResource operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateResource
     */
    @Override
    public UpdateResourceResponse updateResource(UpdateResourceRequest updateResourceRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResource");

            return clientHandler.execute(new ClientExecutionParams<UpdateResourceRequest, UpdateResourceResponse>()
                    .withOperationName("UpdateResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateResourceRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes information about the specified API.
     * </p>
     *
     * @param updateRestApiRequest
     *        Request to update an existing <a>RestApi</a> resource in your collection.
     * @return Result of the UpdateRestApi operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateRestApi
     */
    @Override
    public UpdateRestApiResponse updateRestApi(UpdateRestApiRequest updateRestApiRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateRestApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRestApi");

            return clientHandler.execute(new ClientExecutionParams<UpdateRestApiRequest, UpdateRestApiResponse>()
                    .withOperationName("UpdateRestApi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateRestApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRestApiRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRestApiRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes information about a <a>Stage</a> resource.
     * </p>
     *
     * @param updateStageRequest
     *        Requests API Gateway to change information about a <a>Stage</a> resource.
     * @return Result of the UpdateStage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateStage
     */
    @Override
    public UpdateStageResponse updateStage(UpdateStageRequest updateStageRequest) throws UnauthorizedException,
            NotFoundException, ConflictException, BadRequestException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateStageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStage");

            return clientHandler.execute(new ClientExecutionParams<UpdateStageRequest, UpdateStageResponse>()
                    .withOperationName("UpdateStage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateStageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateStageRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStageRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.
     * </p>
     *
     * @param updateUsageRequest
     *        The PATCH request to grant a temporary extension to the remaining quota of a usage plan associated with a
     *        specified API key.
     * @return Result of the UpdateUsage operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateUsage
     */
    @Override
    public UpdateUsageResponse updateUsage(UpdateUsageRequest updateUsageRequest) throws UnauthorizedException,
            TooManyRequestsException, BadRequestException, NotFoundException, AwsServiceException, SdkClientException,
            ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateUsageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateUsageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUsage");

            return clientHandler.execute(new ClientExecutionParams<UpdateUsageRequest, UpdateUsageResponse>()
                    .withOperationName("UpdateUsage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateUsageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateUsageRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUsageRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a usage plan of a given plan Id.
     * </p>
     *
     * @param updateUsagePlanRequest
     *        The PATCH request to update a usage plan of a given plan Id.
     * @return Result of the UpdateUsagePlan operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateUsagePlan
     */
    @Override
    public UpdateUsagePlanResponse updateUsagePlan(UpdateUsagePlanRequest updateUsagePlanRequest) throws UnauthorizedException,
            TooManyRequestsException, BadRequestException, NotFoundException, ConflictException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateUsagePlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUsagePlan");

            return clientHandler.execute(new ClientExecutionParams<UpdateUsagePlanRequest, UpdateUsagePlanResponse>()
                    .withOperationName("UpdateUsagePlan").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateUsagePlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateUsagePlanRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUsagePlanRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing <a>VpcLink</a> of a specified identifier.
     * </p>
     *
     * @param updateVpcLinkRequest
     *        Updates an existing <a>VpcLink</a> of a specified identifier.
     * @return Result of the UpdateVpcLink operation returned by the service.
     * @throws UnauthorizedException
     *         The request is denied because the caller has insufficient permissions.
     * @throws NotFoundException
     *         The requested resource is not found. Make sure that the request URI is correct.
     * @throws BadRequestException
     *         The submitted request is not valid, for example, the input is incomplete or incorrect. See the
     *         accompanying error message for details.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws TooManyRequestsException
     *         The request has reached its throttling limit. Retry after the specified time period.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApiGatewayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApiGatewayClient.UpdateVpcLink
     */
    @Override
    public UpdateVpcLinkResponse updateVpcLink(UpdateVpcLinkRequest updateVpcLinkRequest) throws UnauthorizedException,
            NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ApiGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateVpcLinkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVpcLink");

            return clientHandler.execute(new ClientExecutionParams<UpdateVpcLinkRequest, UpdateVpcLinkResponse>()
                    .withOperationName("UpdateVpcLink").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateVpcLinkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateVpcLinkRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVpcLinkRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ApiGatewayException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(503).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends ApiGatewayRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
