/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayException;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.BadRequestException;
import software.amazon.awssdk.services.apigateway.model.ConflictException;
import software.amazon.awssdk.services.apigateway.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.CreateModelRequest;
import software.amazon.awssdk.services.apigateway.model.CreateModelResponse;
import software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.CreateResourceRequest;
import software.amazon.awssdk.services.apigateway.model.CreateResourceResponse;
import software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.CreateRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.CreateStageRequest;
import software.amazon.awssdk.services.apigateway.model.CreateStageResponse;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.CreateVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.CreateVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteModelRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteModelResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteResourceRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteResourceResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteStageRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteStageResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheRequest;
import software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheResponse;
import software.amazon.awssdk.services.apigateway.model.FlushStageCacheRequest;
import software.amazon.awssdk.services.apigateway.model.FlushStageCacheResponse;
import software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.GetAccountRequest;
import software.amazon.awssdk.services.apigateway.model.GetAccountResponse;
import software.amazon.awssdk.services.apigateway.model.GetApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.GetApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizersResponse;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse;
import software.amazon.awssdk.services.apigateway.model.GetExportRequest;
import software.amazon.awssdk.services.apigateway.model.GetExportResponse;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesRequest;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesResponse;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetMethodRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponse;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelTemplateRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelTemplateResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelsRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelsResponse;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorsRequest;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorsResponse;
import software.amazon.awssdk.services.apigateway.model.GetResourceRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourceResponse;
import software.amazon.awssdk.services.apigateway.model.GetResourcesRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourcesResponse;
import software.amazon.awssdk.services.apigateway.model.GetRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.GetRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.GetRestApisRequest;
import software.amazon.awssdk.services.apigateway.model.GetRestApisResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypeRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypeResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypesRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypesResponse;
import software.amazon.awssdk.services.apigateway.model.GetStageRequest;
import software.amazon.awssdk.services.apigateway.model.GetStageResponse;
import software.amazon.awssdk.services.apigateway.model.GetStagesRequest;
import software.amazon.awssdk.services.apigateway.model.GetStagesResponse;
import software.amazon.awssdk.services.apigateway.model.GetTagsRequest;
import software.amazon.awssdk.services.apigateway.model.GetTagsResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsageRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsageResponse;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse;
import software.amazon.awssdk.services.apigateway.model.ImportApiKeysRequest;
import software.amazon.awssdk.services.apigateway.model.ImportApiKeysResponse;
import software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsRequest;
import software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsResponse;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.LimitExceededException;
import software.amazon.awssdk.services.apigateway.model.NotFoundException;
import software.amazon.awssdk.services.apigateway.model.PutGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutMethodRequest;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponse;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.PutRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.ServiceUnavailableException;
import software.amazon.awssdk.services.apigateway.model.TagResourceRequest;
import software.amazon.awssdk.services.apigateway.model.TagResourceResponse;
import software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest;
import software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse;
import software.amazon.awssdk.services.apigateway.model.TooManyRequestsException;
import software.amazon.awssdk.services.apigateway.model.UnauthorizedException;
import software.amazon.awssdk.services.apigateway.model.UntagResourceRequest;
import software.amazon.awssdk.services.apigateway.model.UntagResourceResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateAccountRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateAccountResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateModelRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateModelResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateResourceRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateResourceResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateStageRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateStageResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateUsageRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.paginators.GetApiKeysPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetModelsPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetResourcesPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetRestApisPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetUsagePublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksPublisher;
import software.amazon.awssdk.services.apigateway.transform.CreateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateUsagePlanKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteUsagePlanKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.FlushStageAuthorizersCacheRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.FlushStageCacheRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GenerateClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAccountRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetApiKeysRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAuthorizersRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetBasePathMappingsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetClientCertificatesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationPartsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationVersionsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetExportRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetGatewayResponsesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelTemplateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRequestValidatorsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetResourcesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRestApisRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkTypeRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkTypesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetStagesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetTagsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanKeysRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlansRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetVpcLinksRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportApiKeysRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportDocumentationPartsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.TestInvokeAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.TestInvokeMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateAccountRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateUsageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateVpcLinkRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ApiGatewayAsyncClient}.
 *
 * @see ApiGatewayAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultApiGatewayAsyncClient implements ApiGatewayAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultApiGatewayAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultApiGatewayAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Create an <a>ApiKey</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-api-key.html">AWS CLI</a></div>
     *
     * @param createApiKeyRequest
     *        Request to create an <a>ApiKey</a> resource.
     * @return A Java Future containing the result of the CreateApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateApiKey
     */
    @Override
    public CompletableFuture<CreateApiKeyResponse> createApiKey(CreateApiKeyRequest createApiKeyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApiKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApiKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateApiKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateApiKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateApiKeyRequest, CreateApiKeyResponse>()
                            .withOperationName("CreateApiKey").withMarshaller(new CreateApiKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createApiKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createApiKeyRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateApiKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a new <a>Authorizer</a> resource to an existing <a>RestApi</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-authorizer.html">AWS CLI</a></div>
     *
     * @param createAuthorizerRequest
     *        Request to add a new <a>Authorizer</a> to an existing <a>RestApi</a> resource.
     * @return A Java Future containing the result of the CreateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateAuthorizer
     */
    @Override
    public CompletableFuture<CreateAuthorizerResponse> createAuthorizer(CreateAuthorizerRequest createAuthorizerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAuthorizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAuthorizerRequest, CreateAuthorizerResponse>()
                            .withOperationName("CreateAuthorizer")
                            .withMarshaller(new CreateAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAuthorizerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createAuthorizerRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateAuthorizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param createBasePathMappingRequest
     *        Requests API Gateway to create a new <a>BasePathMapping</a> resource.
     * @return A Java Future containing the result of the CreateBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateBasePathMapping
     */
    @Override
    public CompletableFuture<CreateBasePathMappingResponse> createBasePathMapping(
            CreateBasePathMappingRequest createBasePathMappingRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBasePathMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBasePathMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBasePathMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBasePathMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBasePathMappingRequest, CreateBasePathMappingResponse>()
                            .withOperationName("CreateBasePathMapping")
                            .withMarshaller(new CreateBasePathMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createBasePathMappingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createBasePathMappingRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateBasePathMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a <a>Deployment</a> resource, which makes a specified <a>RestApi</a> callable over the internet.
     * </p>
     *
     * @param createDeploymentRequest
     *        Requests API Gateway to create a <a>Deployment</a> resource.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDeployment
     */
    @Override
    public CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeploymentRequest, CreateDeploymentResponse>()
                            .withOperationName("CreateDeployment")
                            .withMarshaller(new CreateDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDeploymentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDeploymentRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the CreateDocumentationPart operation asynchronously.
     *
     * @param createDocumentationPartRequest
     *        Creates a new documentation part of a given API.
     * @return A Java Future containing the result of the CreateDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDocumentationPart
     */
    @Override
    public CompletableFuture<CreateDocumentationPartResponse> createDocumentationPart(
            CreateDocumentationPartRequest createDocumentationPartRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDocumentationPartRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDocumentationPart");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDocumentationPartResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDocumentationPartResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDocumentationPartRequest, CreateDocumentationPartResponse>()
                            .withOperationName("CreateDocumentationPart")
                            .withMarshaller(new CreateDocumentationPartRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDocumentationPartRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDocumentationPartRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateDocumentationPartResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the CreateDocumentationVersion operation asynchronously.
     *
     * @param createDocumentationVersionRequest
     *        Creates a new documentation version of a given API.
     * @return A Java Future containing the result of the CreateDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDocumentationVersion
     */
    @Override
    public CompletableFuture<CreateDocumentationVersionResponse> createDocumentationVersion(
            CreateDocumentationVersionRequest createDocumentationVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDocumentationVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDocumentationVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDocumentationVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDocumentationVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDocumentationVersionRequest, CreateDocumentationVersionResponse>()
                            .withOperationName("CreateDocumentationVersion")
                            .withMarshaller(new CreateDocumentationVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDocumentationVersionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDocumentationVersionRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateDocumentationVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new domain name.
     * </p>
     *
     * @param createDomainNameRequest
     *        A request to create a new domain name.
     * @return A Java Future containing the result of the CreateDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDomainName
     */
    @Override
    public CompletableFuture<CreateDomainNameResponse> createDomainName(CreateDomainNameRequest createDomainNameRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDomainName");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDomainNameResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDomainNameResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDomainNameRequest, CreateDomainNameResponse>()
                            .withOperationName("CreateDomainName")
                            .withMarshaller(new CreateDomainNameRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDomainNameRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDomainNameRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateDomainNameResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a new <a>Model</a> resource to an existing <a>RestApi</a> resource.
     * </p>
     *
     * @param createModelRequest
     *        Request to add a new <a>Model</a> to an existing <a>RestApi</a> resource.
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateModel
     */
    @Override
    public CompletableFuture<CreateModelResponse> createModel(CreateModelRequest createModelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelRequest, CreateModelResponse>()
                            .withOperationName("CreateModel").withMarshaller(new CreateModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createModelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createModelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a <a>ReqeustValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param createRequestValidatorRequest
     *        Creates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return A Java Future containing the result of the CreateRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateRequestValidator
     */
    @Override
    public CompletableFuture<CreateRequestValidatorResponse> createRequestValidator(
            CreateRequestValidatorRequest createRequestValidatorRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRequestValidatorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRequestValidator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRequestValidatorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRequestValidatorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRequestValidatorRequest, CreateRequestValidatorResponse>()
                            .withOperationName("CreateRequestValidator")
                            .withMarshaller(new CreateRequestValidatorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createRequestValidatorRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createRequestValidatorRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateRequestValidatorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a <a>Resource</a> resource.
     * </p>
     *
     * @param createResourceRequest
     *        Requests API Gateway to create a <a>Resource</a> resource.
     * @return A Java Future containing the result of the CreateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateResource
     */
    @Override
    public CompletableFuture<CreateResourceResponse> createResource(CreateResourceRequest createResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResourceRequest, CreateResourceResponse>()
                            .withOperationName("CreateResource")
                            .withMarshaller(new CreateResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new <a>RestApi</a> resource.
     * </p>
     *
     * @param createRestApiRequest
     *        The POST Request to add a new <a>RestApi</a> resource to your collection.
     * @return A Java Future containing the result of the CreateRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateRestApi
     */
    @Override
    public CompletableFuture<CreateRestApiResponse> createRestApi(CreateRestApiRequest createRestApiRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRestApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRestApi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateRestApiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRestApiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRestApiRequest, CreateRestApiResponse>()
                            .withOperationName("CreateRestApi")
                            .withMarshaller(new CreateRestApiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createRestApiRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createRestApiRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateRestApiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new <a>Stage</a> resource that references a pre-existing <a>Deployment</a> for the API.
     * </p>
     *
     * @param createStageRequest
     *        Requests API Gateway to create a <a>Stage</a> resource.
     * @return A Java Future containing the result of the CreateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateStage
     */
    @Override
    public CompletableFuture<CreateStageResponse> createStage(CreateStageRequest createStageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateStageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateStageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStageRequest, CreateStageResponse>()
                            .withOperationName("CreateStage").withMarshaller(new CreateStageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createStageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createStageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateStageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the
     * payload.
     * </p>
     *
     * @param createUsagePlanRequest
     *        The POST request to create a usage plan with the name, description, throttle limits and quota limits, as
     *        well as the associated API stages, specified in the payload.
     * @return A Java Future containing the result of the CreateUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateUsagePlan
     */
    @Override
    public CompletableFuture<CreateUsagePlanResponse> createUsagePlan(CreateUsagePlanRequest createUsagePlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUsagePlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUsagePlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUsagePlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUsagePlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUsagePlanRequest, CreateUsagePlanResponse>()
                            .withOperationName("CreateUsagePlan")
                            .withMarshaller(new CreateUsagePlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createUsagePlanRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createUsagePlanRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateUsagePlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a usage plan key for adding an existing API key to a usage plan.
     * </p>
     *
     * @param createUsagePlanKeyRequest
     *        The POST request to create a usage plan key for adding an existing API key to a usage plan.
     * @return A Java Future containing the result of the CreateUsagePlanKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateUsagePlanKey
     */
    @Override
    public CompletableFuture<CreateUsagePlanKeyResponse> createUsagePlanKey(CreateUsagePlanKeyRequest createUsagePlanKeyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUsagePlanKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUsagePlanKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUsagePlanKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUsagePlanKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUsagePlanKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUsagePlanKeyRequest, CreateUsagePlanKeyResponse>()
                            .withOperationName("CreateUsagePlanKey")
                            .withMarshaller(new CreateUsagePlanKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createUsagePlanKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createUsagePlanKeyRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateUsagePlanKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically
     * takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC
     * Endpoint services.
     * </p>
     *
     * @param createVpcLinkRequest
     *        Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that
     *        typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create
     *        and update VPC Endpoint services.
     * @return A Java Future containing the result of the CreateVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateVpcLink
     */
    @Override
    public CompletableFuture<CreateVpcLinkResponse> createVpcLink(CreateVpcLinkRequest createVpcLinkRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateVpcLinkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateVpcLinkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcLinkRequest, CreateVpcLinkResponse>()
                            .withOperationName("CreateVpcLink")
                            .withMarshaller(new CreateVpcLinkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createVpcLinkRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createVpcLinkRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateVpcLinkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the <a>ApiKey</a> resource.
     * </p>
     *
     * @param deleteApiKeyRequest
     *        A request to delete the <a>ApiKey</a> resource.
     * @return A Java Future containing the result of the DeleteApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteApiKey
     */
    @Override
    public CompletableFuture<DeleteApiKeyResponse> deleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApiKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApiKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteApiKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteApiKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteApiKeyRequest, DeleteApiKeyResponse>()
                            .withOperationName("DeleteApiKey").withMarshaller(new DeleteApiKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteApiKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteApiKeyRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteApiKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/delete-authorizer.html">AWS CLI</a></div>
     *
     * @param deleteAuthorizerRequest
     *        Request to delete an existing <a>Authorizer</a> resource.
     * @return A Java Future containing the result of the DeleteAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteAuthorizer
     */
    @Override
    public CompletableFuture<DeleteAuthorizerResponse> deleteAuthorizer(DeleteAuthorizerRequest deleteAuthorizerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAuthorizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAuthorizerRequest, DeleteAuthorizerResponse>()
                            .withOperationName("DeleteAuthorizer")
                            .withMarshaller(new DeleteAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAuthorizerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteAuthorizerRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteAuthorizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param deleteBasePathMappingRequest
     *        A request to delete the <a>BasePathMapping</a> resource.
     * @return A Java Future containing the result of the DeleteBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteBasePathMapping
     */
    @Override
    public CompletableFuture<DeleteBasePathMappingResponse> deleteBasePathMapping(
            DeleteBasePathMappingRequest deleteBasePathMappingRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBasePathMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBasePathMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBasePathMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBasePathMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBasePathMappingRequest, DeleteBasePathMappingResponse>()
                            .withOperationName("DeleteBasePathMapping")
                            .withMarshaller(new DeleteBasePathMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteBasePathMappingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteBasePathMappingRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteBasePathMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param deleteClientCertificateRequest
     *        A request to delete the <a>ClientCertificate</a> resource.
     * @return A Java Future containing the result of the DeleteClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteClientCertificate
     */
    @Override
    public CompletableFuture<DeleteClientCertificateResponse> deleteClientCertificate(
            DeleteClientCertificateRequest deleteClientCertificateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClientCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClientCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteClientCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteClientCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteClientCertificateRequest, DeleteClientCertificateResponse>()
                            .withOperationName("DeleteClientCertificate")
                            .withMarshaller(new DeleteClientCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteClientCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteClientCertificateRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteClientCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a <a>Deployment</a> resource. Deleting a deployment will only succeed if there are no <a>Stage</a>
     * resources associated with it.
     * </p>
     *
     * @param deleteDeploymentRequest
     *        Requests API Gateway to delete a <a>Deployment</a> resource.
     * @return A Java Future containing the result of the DeleteDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDeployment
     */
    @Override
    public CompletableFuture<DeleteDeploymentResponse> deleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeploymentRequest, DeleteDeploymentResponse>()
                            .withOperationName("DeleteDeployment")
                            .withMarshaller(new DeleteDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDeploymentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDeploymentRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteDocumentationPart operation asynchronously.
     *
     * @param deleteDocumentationPartRequest
     *        Deletes an existing documentation part of an API.
     * @return A Java Future containing the result of the DeleteDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDocumentationPart
     */
    @Override
    public CompletableFuture<DeleteDocumentationPartResponse> deleteDocumentationPart(
            DeleteDocumentationPartRequest deleteDocumentationPartRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDocumentationPartRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDocumentationPart");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDocumentationPartResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDocumentationPartResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDocumentationPartRequest, DeleteDocumentationPartResponse>()
                            .withOperationName("DeleteDocumentationPart")
                            .withMarshaller(new DeleteDocumentationPartRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDocumentationPartRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDocumentationPartRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteDocumentationPartResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the DeleteDocumentationVersion operation asynchronously.
     *
     * @param deleteDocumentationVersionRequest
     *        Deletes an existing documentation version of an API.
     * @return A Java Future containing the result of the DeleteDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDocumentationVersion
     */
    @Override
    public CompletableFuture<DeleteDocumentationVersionResponse> deleteDocumentationVersion(
            DeleteDocumentationVersionRequest deleteDocumentationVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDocumentationVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDocumentationVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDocumentationVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDocumentationVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDocumentationVersionRequest, DeleteDocumentationVersionResponse>()
                            .withOperationName("DeleteDocumentationVersion")
                            .withMarshaller(new DeleteDocumentationVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDocumentationVersionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDocumentationVersionRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteDocumentationVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the <a>DomainName</a> resource.
     * </p>
     *
     * @param deleteDomainNameRequest
     *        A request to delete the <a>DomainName</a> resource.
     * @return A Java Future containing the result of the DeleteDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDomainName
     */
    @Override
    public CompletableFuture<DeleteDomainNameResponse> deleteDomainName(DeleteDomainNameRequest deleteDomainNameRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDomainName");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDomainNameResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDomainNameResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDomainNameRequest, DeleteDomainNameResponse>()
                            .withOperationName("DeleteDomainName")
                            .withMarshaller(new DeleteDomainNameRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDomainNameRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDomainNameRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteDomainNameResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Clears any customization of a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a> and
     * resets it with the default settings.
     * </p>
     *
     * @param deleteGatewayResponseRequest
     *        Clears any customization of a <a>GatewayResponse</a> of a specified response type on the given
     *        <a>RestApi</a> and resets it with the default settings.
     * @return A Java Future containing the result of the DeleteGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteGatewayResponse
     */
    @Override
    public CompletableFuture<DeleteGatewayResponseResponse> deleteGatewayResponse(
            DeleteGatewayResponseRequest deleteGatewayResponseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGatewayResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGatewayResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteGatewayResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGatewayResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGatewayResponseRequest, DeleteGatewayResponseResponse>()
                            .withOperationName("DeleteGatewayResponse")
                            .withMarshaller(new DeleteGatewayResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteGatewayResponseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteGatewayResponseRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteGatewayResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a delete integration.
     * </p>
     *
     * @param deleteIntegrationRequest
     *        Represents a delete integration request.
     * @return A Java Future containing the result of the DeleteIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteIntegration
     */
    @Override
    public CompletableFuture<DeleteIntegrationResponse> deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIntegrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIntegrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIntegrationRequest, DeleteIntegrationResponse>()
                            .withOperationName("DeleteIntegration")
                            .withMarshaller(new DeleteIntegrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteIntegrationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteIntegrationRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteIntegrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a delete integration response.
     * </p>
     *
     * @param deleteIntegrationResponseRequest
     *        Represents a delete integration response request.
     * @return A Java Future containing the result of the DeleteIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteIntegrationResponse
     */
    @Override
    public CompletableFuture<DeleteIntegrationResponseResponse> deleteIntegrationResponse(
            DeleteIntegrationResponseRequest deleteIntegrationResponseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntegrationResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntegrationResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIntegrationResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIntegrationResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIntegrationResponseRequest, DeleteIntegrationResponseResponse>()
                            .withOperationName("DeleteIntegrationResponse")
                            .withMarshaller(new DeleteIntegrationResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteIntegrationResponseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteIntegrationResponseRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteIntegrationResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing <a>Method</a> resource.
     * </p>
     *
     * @param deleteMethodRequest
     *        Request to delete an existing <a>Method</a> resource.
     * @return A Java Future containing the result of the DeleteMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteMethod
     */
    @Override
    public CompletableFuture<DeleteMethodResponse> deleteMethod(DeleteMethodRequest deleteMethodRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMethodRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMethodResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteMethodResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMethodResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMethodRequest, DeleteMethodResponse>()
                            .withOperationName("DeleteMethod").withMarshaller(new DeleteMethodRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteMethodRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteMethodRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteMethodResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing <a>MethodResponse</a> resource.
     * </p>
     *
     * @param deleteMethodResponseRequest
     *        A request to delete an existing <a>MethodResponse</a> resource.
     * @return A Java Future containing the result of the DeleteMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteMethodResponse
     */
    @Override
    public CompletableFuture<DeleteMethodResponseResponse> deleteMethodResponse(
            DeleteMethodResponseRequest deleteMethodResponseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMethodResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMethodResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMethodResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMethodResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMethodResponseRequest, DeleteMethodResponseResponse>()
                            .withOperationName("DeleteMethodResponse")
                            .withMarshaller(new DeleteMethodResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteMethodResponseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteMethodResponseRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteMethodResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a model.
     * </p>
     *
     * @param deleteModelRequest
     *        Request to delete an existing model in an existing <a>RestApi</a> resource.
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteModel
     */
    @Override
    public CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest deleteModelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelRequest, DeleteModelResponse>()
                            .withOperationName("DeleteModel").withMarshaller(new DeleteModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteModelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteModelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param deleteRequestValidatorRequest
     *        Deletes a specified <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return A Java Future containing the result of the DeleteRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteRequestValidator
     */
    @Override
    public CompletableFuture<DeleteRequestValidatorResponse> deleteRequestValidator(
            DeleteRequestValidatorRequest deleteRequestValidatorRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRequestValidatorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRequestValidator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRequestValidatorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRequestValidatorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRequestValidatorRequest, DeleteRequestValidatorResponse>()
                            .withOperationName("DeleteRequestValidator")
                            .withMarshaller(new DeleteRequestValidatorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteRequestValidatorRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteRequestValidatorRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteRequestValidatorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a <a>Resource</a> resource.
     * </p>
     *
     * @param deleteResourceRequest
     *        Request to delete a <a>Resource</a>.
     * @return A Java Future containing the result of the DeleteResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteResource
     */
    @Override
    public CompletableFuture<DeleteResourceResponse> deleteResource(DeleteResourceRequest deleteResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceRequest, DeleteResourceResponse>()
                            .withOperationName("DeleteResource")
                            .withMarshaller(new DeleteResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified API.
     * </p>
     *
     * @param deleteRestApiRequest
     *        Request to delete the specified API from your collection.
     * @return A Java Future containing the result of the DeleteRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteRestApi
     */
    @Override
    public CompletableFuture<DeleteRestApiResponse> deleteRestApi(DeleteRestApiRequest deleteRestApiRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRestApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRestApi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteRestApiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRestApiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRestApiRequest, DeleteRestApiResponse>()
                            .withOperationName("DeleteRestApi")
                            .withMarshaller(new DeleteRestApiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteRestApiRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteRestApiRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteRestApiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a <a>Stage</a> resource.
     * </p>
     *
     * @param deleteStageRequest
     *        Requests API Gateway to delete a <a>Stage</a> resource.
     * @return A Java Future containing the result of the DeleteStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteStage
     */
    @Override
    public CompletableFuture<DeleteStageResponse> deleteStage(DeleteStageRequest deleteStageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteStageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteStageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStageRequest, DeleteStageResponse>()
                            .withOperationName("DeleteStage").withMarshaller(new DeleteStageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteStageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteStageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteStageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a usage plan of a given plan Id.
     * </p>
     *
     * @param deleteUsagePlanRequest
     *        The DELETE request to delete a usage plan of a given plan Id.
     * @return A Java Future containing the result of the DeleteUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteUsagePlan
     */
    @Override
    public CompletableFuture<DeleteUsagePlanResponse> deleteUsagePlan(DeleteUsagePlanRequest deleteUsagePlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUsagePlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUsagePlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUsagePlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUsagePlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUsagePlanRequest, DeleteUsagePlanResponse>()
                            .withOperationName("DeleteUsagePlan")
                            .withMarshaller(new DeleteUsagePlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteUsagePlanRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteUsagePlanRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteUsagePlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a usage plan key and remove the underlying API key from the associated usage plan.
     * </p>
     *
     * @param deleteUsagePlanKeyRequest
     *        The DELETE request to delete a usage plan key and remove the underlying API key from the associated usage
     *        plan.
     * @return A Java Future containing the result of the DeleteUsagePlanKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteUsagePlanKey
     */
    @Override
    public CompletableFuture<DeleteUsagePlanKeyResponse> deleteUsagePlanKey(DeleteUsagePlanKeyRequest deleteUsagePlanKeyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUsagePlanKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUsagePlanKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUsagePlanKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUsagePlanKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUsagePlanKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUsagePlanKeyRequest, DeleteUsagePlanKeyResponse>()
                            .withOperationName("DeleteUsagePlanKey")
                            .withMarshaller(new DeleteUsagePlanKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteUsagePlanKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteUsagePlanKeyRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteUsagePlanKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing <a>VpcLink</a> of a specified identifier.
     * </p>
     *
     * @param deleteVpcLinkRequest
     *        Deletes an existing <a>VpcLink</a> of a specified identifier.
     * @return A Java Future containing the result of the DeleteVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteVpcLink
     */
    @Override
    public CompletableFuture<DeleteVpcLinkResponse> deleteVpcLink(DeleteVpcLinkRequest deleteVpcLinkRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpcLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteVpcLinkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVpcLinkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcLinkRequest, DeleteVpcLinkResponse>()
                            .withOperationName("DeleteVpcLink")
                            .withMarshaller(new DeleteVpcLinkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteVpcLinkRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteVpcLinkRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteVpcLinkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Flushes all authorizer cache entries on a stage.
     * </p>
     *
     * @param flushStageAuthorizersCacheRequest
     *        Request to flush authorizer cache entries on a specified stage.
     * @return A Java Future containing the result of the FlushStageAuthorizersCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.FlushStageAuthorizersCache
     */
    @Override
    public CompletableFuture<FlushStageAuthorizersCacheResponse> flushStageAuthorizersCache(
            FlushStageAuthorizersCacheRequest flushStageAuthorizersCacheRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, flushStageAuthorizersCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FlushStageAuthorizersCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<FlushStageAuthorizersCacheResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, FlushStageAuthorizersCacheResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<FlushStageAuthorizersCacheResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<FlushStageAuthorizersCacheRequest, FlushStageAuthorizersCacheResponse>()
                            .withOperationName("FlushStageAuthorizersCache")
                            .withMarshaller(new FlushStageAuthorizersCacheRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(flushStageAuthorizersCacheRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = flushStageAuthorizersCacheRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<FlushStageAuthorizersCacheResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Flushes a stage's cache.
     * </p>
     *
     * @param flushStageCacheRequest
     *        Requests API Gateway to flush a stage's cache.
     * @return A Java Future containing the result of the FlushStageCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.FlushStageCache
     */
    @Override
    public CompletableFuture<FlushStageCacheResponse> flushStageCache(FlushStageCacheRequest flushStageCacheRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, flushStageCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FlushStageCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<FlushStageCacheResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, FlushStageCacheResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<FlushStageCacheResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<FlushStageCacheRequest, FlushStageCacheResponse>()
                            .withOperationName("FlushStageCache")
                            .withMarshaller(new FlushStageCacheRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(flushStageCacheRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = flushStageCacheRequest.overrideConfiguration().orElse(null);
            CompletableFuture<FlushStageCacheResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates a <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param generateClientCertificateRequest
     *        A request to generate a <a>ClientCertificate</a> resource.
     * @return A Java Future containing the result of the GenerateClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GenerateClientCertificate
     */
    @Override
    public CompletableFuture<GenerateClientCertificateResponse> generateClientCertificate(
            GenerateClientCertificateRequest generateClientCertificateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, generateClientCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateClientCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GenerateClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GenerateClientCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GenerateClientCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GenerateClientCertificateRequest, GenerateClientCertificateResponse>()
                            .withOperationName("GenerateClientCertificate")
                            .withMarshaller(new GenerateClientCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(generateClientCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = generateClientCertificateRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GenerateClientCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the current <a>Account</a> resource.
     * </p>
     *
     * @param getAccountRequest
     *        Requests API Gateway to get information about the current <a>Account</a> resource.
     * @return A Java Future containing the result of the GetAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetAccount
     */
    @Override
    public CompletableFuture<GetAccountResponse> getAccount(GetAccountRequest getAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAccountResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccountRequest, GetAccountResponse>().withOperationName("GetAccount")
                            .withMarshaller(new GetAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getAccountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAccountRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKey</a> resource.
     * </p>
     *
     * @param getApiKeyRequest
     *        A request to get information about the current <a>ApiKey</a> resource.
     * @return A Java Future containing the result of the GetApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetApiKey
     */
    @Override
    public CompletableFuture<GetApiKeyResponse> getApiKey(GetApiKeyRequest getApiKeyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApiKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApiKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetApiKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApiKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApiKeyRequest, GetApiKeyResponse>().withOperationName("GetApiKey")
                            .withMarshaller(new GetApiKeyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getApiKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getApiKeyRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetApiKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKeys</a> resource.
     * </p>
     *
     * @param getApiKeysRequest
     *        A request to get information about the current <a>ApiKeys</a> resource.
     * @return A Java Future containing the result of the GetApiKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetApiKeys
     */
    @Override
    public CompletableFuture<GetApiKeysResponse> getApiKeys(GetApiKeysRequest getApiKeysRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApiKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApiKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApiKeysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetApiKeysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApiKeysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApiKeysRequest, GetApiKeysResponse>().withOperationName("GetApiKeys")
                            .withMarshaller(new GetApiKeysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getApiKeysRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getApiKeysRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetApiKeysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the current <a>ApiKeys</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysPublisher publisher = client.getApiKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysPublisher publisher = client.getApiKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)} operation.</b>
     * </p>
     *
     * @param getApiKeysRequest
     *        A request to get information about the current <a>ApiKeys</a> resource.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetApiKeys
     */
    public GetApiKeysPublisher getApiKeysPaginator(GetApiKeysRequest getApiKeysRequest) {
        return new GetApiKeysPublisher(this, applyPaginatorUserAgent(getApiKeysRequest));
    }

    /**
     * <p>
     * Describe an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizer.html">AWS CLI</a></div>
     *
     * @param getAuthorizerRequest
     *        Request to describe an existing <a>Authorizer</a> resource.
     * @return A Java Future containing the result of the GetAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetAuthorizer
     */
    @Override
    public CompletableFuture<GetAuthorizerResponse> getAuthorizer(GetAuthorizerRequest getAuthorizerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAuthorizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAuthorizerRequest, GetAuthorizerResponse>()
                            .withOperationName("GetAuthorizer")
                            .withMarshaller(new GetAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getAuthorizerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAuthorizerRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetAuthorizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe an existing <a>Authorizers</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizers.html">AWS CLI</a></div>
     *
     * @param getAuthorizersRequest
     *        Request to describe an existing <a>Authorizers</a> resource.
     * @return A Java Future containing the result of the GetAuthorizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetAuthorizers
     */
    @Override
    public CompletableFuture<GetAuthorizersResponse> getAuthorizers(GetAuthorizersRequest getAuthorizersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAuthorizersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAuthorizers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAuthorizersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAuthorizersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAuthorizersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAuthorizersRequest, GetAuthorizersResponse>()
                            .withOperationName("GetAuthorizers")
                            .withMarshaller(new GetAuthorizersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getAuthorizersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAuthorizersRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetAuthorizersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe a <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param getBasePathMappingRequest
     *        Request to describe a <a>BasePathMapping</a> resource.
     * @return A Java Future containing the result of the GetBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetBasePathMapping
     */
    @Override
    public CompletableFuture<GetBasePathMappingResponse> getBasePathMapping(GetBasePathMappingRequest getBasePathMappingRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBasePathMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBasePathMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBasePathMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBasePathMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBasePathMappingRequest, GetBasePathMappingResponse>()
                            .withOperationName("GetBasePathMapping")
                            .withMarshaller(new GetBasePathMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getBasePathMappingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getBasePathMappingRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetBasePathMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a collection of <a>BasePathMapping</a> resources.
     * </p>
     *
     * @param getBasePathMappingsRequest
     *        A request to get information about a collection of <a>BasePathMapping</a> resources.
     * @return A Java Future containing the result of the GetBasePathMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetBasePathMappings
     */
    @Override
    public CompletableFuture<GetBasePathMappingsResponse> getBasePathMappings(
            GetBasePathMappingsRequest getBasePathMappingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBasePathMappingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBasePathMappings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBasePathMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBasePathMappingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBasePathMappingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBasePathMappingsRequest, GetBasePathMappingsResponse>()
                            .withOperationName("GetBasePathMappings")
                            .withMarshaller(new GetBasePathMappingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getBasePathMappingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getBasePathMappingsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetBasePathMappingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a collection of <a>BasePathMapping</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBasePathMappings(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsPublisher publisher = client.getBasePathMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsPublisher publisher = client.getBasePathMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBasePathMappings(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getBasePathMappingsRequest
     *        A request to get information about a collection of <a>BasePathMapping</a> resources.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetBasePathMappings
     */
    public GetBasePathMappingsPublisher getBasePathMappingsPaginator(GetBasePathMappingsRequest getBasePathMappingsRequest) {
        return new GetBasePathMappingsPublisher(this, applyPaginatorUserAgent(getBasePathMappingsRequest));
    }

    /**
     * <p>
     * Gets information about the current <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param getClientCertificateRequest
     *        A request to get information about the current <a>ClientCertificate</a> resource.
     * @return A Java Future containing the result of the GetClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetClientCertificate
     */
    @Override
    public CompletableFuture<GetClientCertificateResponse> getClientCertificate(
            GetClientCertificateRequest getClientCertificateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getClientCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetClientCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetClientCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetClientCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetClientCertificateRequest, GetClientCertificateResponse>()
                            .withOperationName("GetClientCertificate")
                            .withMarshaller(new GetClientCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getClientCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getClientCertificateRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetClientCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a collection of <a>ClientCertificate</a> resources.
     * </p>
     *
     * @param getClientCertificatesRequest
     *        A request to get information about a collection of <a>ClientCertificate</a> resources.
     * @return A Java Future containing the result of the GetClientCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetClientCertificates
     */
    @Override
    public CompletableFuture<GetClientCertificatesResponse> getClientCertificates(
            GetClientCertificatesRequest getClientCertificatesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getClientCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetClientCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetClientCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetClientCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetClientCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetClientCertificatesRequest, GetClientCertificatesResponse>()
                            .withOperationName("GetClientCertificates")
                            .withMarshaller(new GetClientCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getClientCertificatesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getClientCertificatesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetClientCertificatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a collection of <a>ClientCertificate</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesPublisher publisher = client.getClientCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesPublisher publisher = client.getClientCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getClientCertificatesRequest
     *        A request to get information about a collection of <a>ClientCertificate</a> resources.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetClientCertificates
     */
    public GetClientCertificatesPublisher getClientCertificatesPaginator(GetClientCertificatesRequest getClientCertificatesRequest) {
        return new GetClientCertificatesPublisher(this, applyPaginatorUserAgent(getClientCertificatesRequest));
    }

    /**
     * <p>
     * Gets information about a <a>Deployment</a> resource.
     * </p>
     *
     * @param getDeploymentRequest
     *        Requests API Gateway to get information about a <a>Deployment</a> resource.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDeployment
     */
    @Override
    public CompletableFuture<GetDeploymentResponse> getDeployment(GetDeploymentRequest getDeploymentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeploymentRequest, GetDeploymentResponse>()
                            .withOperationName("GetDeployment")
                            .withMarshaller(new GetDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDeploymentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDeploymentRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a <a>Deployments</a> collection.
     * </p>
     *
     * @param getDeploymentsRequest
     *        Requests API Gateway to get information about a <a>Deployments</a> collection.
     * @return A Java Future containing the result of the GetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDeployments
     */
    @Override
    public CompletableFuture<GetDeploymentsResponse> getDeployments(GetDeploymentsRequest getDeploymentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeployments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeploymentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeploymentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeploymentsRequest, GetDeploymentsResponse>()
                            .withOperationName("GetDeployments")
                            .withMarshaller(new GetDeploymentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDeploymentsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDeploymentsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetDeploymentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a <a>Deployments</a> collection.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDeployments(software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsPublisher publisher = client.getDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsPublisher publisher = client.getDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDeployments(software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest)} operation.</b>
     * </p>
     *
     * @param getDeploymentsRequest
     *        Requests API Gateway to get information about a <a>Deployments</a> collection.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDeployments
     */
    public GetDeploymentsPublisher getDeploymentsPaginator(GetDeploymentsRequest getDeploymentsRequest) {
        return new GetDeploymentsPublisher(this, applyPaginatorUserAgent(getDeploymentsRequest));
    }

    /**
     * Invokes the GetDocumentationPart operation asynchronously.
     *
     * @param getDocumentationPartRequest
     *        Gets a specified documentation part of a given API.
     * @return A Java Future containing the result of the GetDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationPart
     */
    @Override
    public CompletableFuture<GetDocumentationPartResponse> getDocumentationPart(
            GetDocumentationPartRequest getDocumentationPartRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentationPartRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocumentationPart");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDocumentationPartResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDocumentationPartResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDocumentationPartRequest, GetDocumentationPartResponse>()
                            .withOperationName("GetDocumentationPart")
                            .withMarshaller(new GetDocumentationPartRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDocumentationPartRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDocumentationPartRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetDocumentationPartResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetDocumentationParts operation asynchronously.
     *
     * @param getDocumentationPartsRequest
     *        Gets the documentation parts of an API. The result may be filtered by the type, name, or path of API
     *        entities (targets).
     * @return A Java Future containing the result of the GetDocumentationParts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationParts
     */
    @Override
    public CompletableFuture<GetDocumentationPartsResponse> getDocumentationParts(
            GetDocumentationPartsRequest getDocumentationPartsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentationPartsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocumentationParts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDocumentationPartsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDocumentationPartsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDocumentationPartsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDocumentationPartsRequest, GetDocumentationPartsResponse>()
                            .withOperationName("GetDocumentationParts")
                            .withMarshaller(new GetDocumentationPartsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDocumentationPartsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDocumentationPartsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetDocumentationPartsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetDocumentationVersion operation asynchronously.
     *
     * @param getDocumentationVersionRequest
     *        Gets a documentation snapshot of an API.
     * @return A Java Future containing the result of the GetDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationVersion
     */
    @Override
    public CompletableFuture<GetDocumentationVersionResponse> getDocumentationVersion(
            GetDocumentationVersionRequest getDocumentationVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentationVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocumentationVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDocumentationVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDocumentationVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDocumentationVersionRequest, GetDocumentationVersionResponse>()
                            .withOperationName("GetDocumentationVersion")
                            .withMarshaller(new GetDocumentationVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDocumentationVersionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDocumentationVersionRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetDocumentationVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetDocumentationVersions operation asynchronously.
     *
     * @param getDocumentationVersionsRequest
     *        Gets the documentation versions of an API.
     * @return A Java Future containing the result of the GetDocumentationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationVersions
     */
    @Override
    public CompletableFuture<GetDocumentationVersionsResponse> getDocumentationVersions(
            GetDocumentationVersionsRequest getDocumentationVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentationVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocumentationVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDocumentationVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDocumentationVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDocumentationVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDocumentationVersionsRequest, GetDocumentationVersionsResponse>()
                            .withOperationName("GetDocumentationVersions")
                            .withMarshaller(new GetDocumentationVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDocumentationVersionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDocumentationVersionsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetDocumentationVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a domain name that is contained in a simpler, more intuitive URL that can be called.
     * </p>
     *
     * @param getDomainNameRequest
     *        Request to get the name of a <a>DomainName</a> resource.
     * @return A Java Future containing the result of the GetDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDomainName
     */
    @Override
    public CompletableFuture<GetDomainNameResponse> getDomainName(GetDomainNameRequest getDomainNameRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDomainName");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDomainNameResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDomainNameResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDomainNameRequest, GetDomainNameResponse>()
                            .withOperationName("GetDomainName")
                            .withMarshaller(new GetDomainNameRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDomainNameRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDomainNameRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetDomainNameResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a collection of <a>DomainName</a> resources.
     * </p>
     *
     * @param getDomainNamesRequest
     *        Request to describe a collection of <a>DomainName</a> resources.
     * @return A Java Future containing the result of the GetDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDomainNames
     */
    @Override
    public CompletableFuture<GetDomainNamesResponse> getDomainNames(GetDomainNamesRequest getDomainNamesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDomainNamesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDomainNames");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDomainNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDomainNamesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDomainNamesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDomainNamesRequest, GetDomainNamesResponse>()
                            .withOperationName("GetDomainNames")
                            .withMarshaller(new GetDomainNamesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDomainNamesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDomainNamesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetDomainNamesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a collection of <a>DomainName</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesPublisher publisher = client.getDomainNamesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesPublisher publisher = client.getDomainNamesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation.</b>
     * </p>
     *
     * @param getDomainNamesRequest
     *        Request to describe a collection of <a>DomainName</a> resources.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDomainNames
     */
    public GetDomainNamesPublisher getDomainNamesPaginator(GetDomainNamesRequest getDomainNamesRequest) {
        return new GetDomainNamesPublisher(this, applyPaginatorUserAgent(getDomainNamesRequest));
    }

    /**
     * <p>
     * Exports a deployed version of a <a>RestApi</a> in a specified format.
     * </p>
     *
     * @param getExportRequest
     *        Request a new export of a <a>RestApi</a> for a particular <a>Stage</a>.
     * @return A Java Future containing the result of the GetExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetExport
     */
    @Override
    public CompletableFuture<GetExportResponse> getExport(GetExportRequest getExportRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetExport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(false).build();

            HttpResponseHandler<GetExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetExportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetExportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetExportRequest, GetExportResponse>().withOperationName("GetExport")
                            .withMarshaller(new GetExportRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getExportRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getExportRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetExportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * </p>
     *
     * @param getGatewayResponseRequest
     *        Gets a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * @return A Java Future containing the result of the GetGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetGatewayResponse
     */
    @Override
    public CompletableFuture<GetGatewayResponseResponse> getGatewayResponse(GetGatewayResponseRequest getGatewayResponseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGatewayResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGatewayResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetGatewayResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGatewayResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGatewayResponseRequest, GetGatewayResponseResponse>()
                            .withOperationName("GetGatewayResponse")
                            .withMarshaller(new GetGatewayResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getGatewayResponseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getGatewayResponseRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetGatewayResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the <a>GatewayResponses</a> collection on the given <a>RestApi</a>. If an API developer has not added any
     * definitions for gateway responses, the result will be the API Gateway-generated default <a>GatewayResponses</a>
     * collection for the supported response types.
     * </p>
     *
     * @param getGatewayResponsesRequest
     *        Gets the <a>GatewayResponses</a> collection on the given <a>RestApi</a>. If an API developer has not added
     *        any definitions for gateway responses, the result will be the API Gateway-generated default
     *        <a>GatewayResponses</a> collection for the supported response types.
     * @return A Java Future containing the result of the GetGatewayResponses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetGatewayResponses
     */
    @Override
    public CompletableFuture<GetGatewayResponsesResponse> getGatewayResponses(
            GetGatewayResponsesRequest getGatewayResponsesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGatewayResponsesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGatewayResponses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGatewayResponsesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetGatewayResponsesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGatewayResponsesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGatewayResponsesRequest, GetGatewayResponsesResponse>()
                            .withOperationName("GetGatewayResponses")
                            .withMarshaller(new GetGatewayResponsesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getGatewayResponsesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getGatewayResponsesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetGatewayResponsesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the integration settings.
     * </p>
     *
     * @param getIntegrationRequest
     *        Represents a request to get the integration configuration.
     * @return A Java Future containing the result of the GetIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetIntegration
     */
    @Override
    public CompletableFuture<GetIntegrationResponse> getIntegration(GetIntegrationRequest getIntegrationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIntegrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIntegrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIntegrationRequest, GetIntegrationResponse>()
                            .withOperationName("GetIntegration")
                            .withMarshaller(new GetIntegrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getIntegrationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getIntegrationRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetIntegrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a get integration response.
     * </p>
     *
     * @param getIntegrationResponseRequest
     *        Represents a get integration response request.
     * @return A Java Future containing the result of the GetIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetIntegrationResponse
     */
    @Override
    public CompletableFuture<GetIntegrationResponseResponse> getIntegrationResponse(
            GetIntegrationResponseRequest getIntegrationResponseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntegrationResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntegrationResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIntegrationResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIntegrationResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIntegrationResponseRequest, GetIntegrationResponseResponse>()
                            .withOperationName("GetIntegrationResponse")
                            .withMarshaller(new GetIntegrationResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getIntegrationResponseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getIntegrationResponseRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetIntegrationResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe an existing <a>Method</a> resource.
     * </p>
     *
     * @param getMethodRequest
     *        Request to describe an existing <a>Method</a> resource.
     * @return A Java Future containing the result of the GetMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetMethod
     */
    @Override
    public CompletableFuture<GetMethodResponse> getMethod(GetMethodRequest getMethodRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMethodRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMethodResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMethodResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMethodResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMethodRequest, GetMethodResponse>().withOperationName("GetMethod")
                            .withMarshaller(new GetMethodRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMethodRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getMethodRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetMethodResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a <a>MethodResponse</a> resource.
     * </p>
     *
     * @param getMethodResponseRequest
     *        Request to describe a <a>MethodResponse</a> resource.
     * @return A Java Future containing the result of the GetMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetMethodResponse
     */
    @Override
    public CompletableFuture<GetMethodResponseResponse> getMethodResponse(GetMethodResponseRequest getMethodResponseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMethodResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMethodResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMethodResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMethodResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMethodResponseRequest, GetMethodResponseResponse>()
                            .withOperationName("GetMethodResponse")
                            .withMarshaller(new GetMethodResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getMethodResponseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getMethodResponseRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetMethodResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an existing model defined for a <a>RestApi</a> resource.
     * </p>
     *
     * @param getModelRequest
     *        Request to list information about a model in an existing <a>RestApi</a> resource.
     * @return A Java Future containing the result of the GetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModel
     */
    @Override
    public CompletableFuture<GetModelResponse> getModel(GetModelRequest getModelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetModelRequest, GetModelResponse>().withOperationName("GetModel")
                            .withMarshaller(new GetModelRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getModelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getModelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates a sample mapping template that can be used to transform a payload into the structure of a model.
     * </p>
     *
     * @param getModelTemplateRequest
     *        Request to generate a sample mapping template used to transform the payload.
     * @return A Java Future containing the result of the GetModelTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModelTemplate
     */
    @Override
    public CompletableFuture<GetModelTemplateResponse> getModelTemplate(GetModelTemplateRequest getModelTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModelTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetModelTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetModelTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetModelTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetModelTemplateRequest, GetModelTemplateResponse>()
                            .withOperationName("GetModelTemplate")
                            .withMarshaller(new GetModelTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getModelTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getModelTemplateRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetModelTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * </p>
     *
     * @param getModelsRequest
     *        Request to list existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * @return A Java Future containing the result of the GetModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModels
     */
    @Override
    public CompletableFuture<GetModelsResponse> getModels(GetModelsRequest getModelsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetModelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetModelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetModelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetModelsRequest, GetModelsResponse>().withOperationName("GetModels")
                            .withMarshaller(new GetModelsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getModelsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getModelsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetModelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getModels(software.amazon.awssdk.services.apigateway.model.GetModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetModelsPublisher publisher = client.getModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetModelsPublisher publisher = client.getModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getModels(software.amazon.awssdk.services.apigateway.model.GetModelsRequest)} operation.</b>
     * </p>
     *
     * @param getModelsRequest
     *        Request to list existing <a>Models</a> defined for a <a>RestApi</a> resource.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModels
     */
    public GetModelsPublisher getModelsPaginator(GetModelsRequest getModelsRequest) {
        return new GetModelsPublisher(this, applyPaginatorUserAgent(getModelsRequest));
    }

    /**
     * <p>
     * Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param getRequestValidatorRequest
     *        Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return A Java Future containing the result of the GetRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRequestValidator
     */
    @Override
    public CompletableFuture<GetRequestValidatorResponse> getRequestValidator(
            GetRequestValidatorRequest getRequestValidatorRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRequestValidatorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRequestValidator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRequestValidatorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRequestValidatorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRequestValidatorRequest, GetRequestValidatorResponse>()
                            .withOperationName("GetRequestValidator")
                            .withMarshaller(new GetRequestValidatorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRequestValidatorRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRequestValidatorRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetRequestValidatorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the <a>RequestValidators</a> collection of a given <a>RestApi</a>.
     * </p>
     *
     * @param getRequestValidatorsRequest
     *        Gets the <a>RequestValidators</a> collection of a given <a>RestApi</a>.
     * @return A Java Future containing the result of the GetRequestValidators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRequestValidators
     */
    @Override
    public CompletableFuture<GetRequestValidatorsResponse> getRequestValidators(
            GetRequestValidatorsRequest getRequestValidatorsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRequestValidatorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRequestValidators");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRequestValidatorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRequestValidatorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRequestValidatorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRequestValidatorsRequest, GetRequestValidatorsResponse>()
                            .withOperationName("GetRequestValidators")
                            .withMarshaller(new GetRequestValidatorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRequestValidatorsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRequestValidatorsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetRequestValidatorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about a resource.
     * </p>
     *
     * @param getResourceRequest
     *        Request to list information about a resource.
     * @return A Java Future containing the result of the GetResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetResource
     */
    @Override
    public CompletableFuture<GetResourceResponse> getResource(GetResourceRequest getResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourceRequest, GetResourceResponse>()
                            .withOperationName("GetResource").withMarshaller(new GetResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about a collection of <a>Resource</a> resources.
     * </p>
     *
     * @param getResourcesRequest
     *        Request to list information about a collection of resources.
     * @return A Java Future containing the result of the GetResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetResources
     */
    @Override
    public CompletableFuture<GetResourcesResponse> getResources(GetResourcesRequest getResourcesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourcesRequest, GetResourcesResponse>()
                            .withOperationName("GetResources").withMarshaller(new GetResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getResourcesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getResourcesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetResourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about a collection of <a>Resource</a> resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getResources(software.amazon.awssdk.services.apigateway.model.GetResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetResourcesPublisher publisher = client.getResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetResourcesPublisher publisher = client.getResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResources(software.amazon.awssdk.services.apigateway.model.GetResourcesRequest)} operation.</b>
     * </p>
     *
     * @param getResourcesRequest
     *        Request to list information about a collection of resources.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetResources
     */
    public GetResourcesPublisher getResourcesPaginator(GetResourcesRequest getResourcesRequest) {
        return new GetResourcesPublisher(this, applyPaginatorUserAgent(getResourcesRequest));
    }

    /**
     * <p>
     * Lists the <a>RestApi</a> resource in the collection.
     * </p>
     *
     * @param getRestApiRequest
     *        The GET request to list an existing <a>RestApi</a> defined for your collection.
     * @return A Java Future containing the result of the GetRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRestApi
     */
    @Override
    public CompletableFuture<GetRestApiResponse> getRestApi(GetRestApiRequest getRestApiRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRestApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRestApi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetRestApiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRestApiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRestApiRequest, GetRestApiResponse>().withOperationName("GetRestApi")
                            .withMarshaller(new GetRestApiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRestApiRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRestApiRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetRestApiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the <a>RestApis</a> resources for your collection.
     * </p>
     *
     * @param getRestApisRequest
     *        The GET request to list existing <a>RestApis</a> defined for your collection.
     * @return A Java Future containing the result of the GetRestApis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRestApis
     */
    @Override
    public CompletableFuture<GetRestApisResponse> getRestApis(GetRestApisRequest getRestApisRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRestApisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRestApis");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRestApisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetRestApisResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRestApisResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRestApisRequest, GetRestApisResponse>()
                            .withOperationName("GetRestApis").withMarshaller(new GetRestApisRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRestApisRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRestApisRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetRestApisResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the <a>RestApis</a> resources for your collection.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisPublisher publisher = client.getRestApisPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisPublisher publisher = client.getRestApisPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetRestApisResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetRestApisResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)} operation.</b>
     * </p>
     *
     * @param getRestApisRequest
     *        The GET request to list existing <a>RestApis</a> defined for your collection.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRestApis
     */
    public GetRestApisPublisher getRestApisPaginator(GetRestApisRequest getRestApisRequest) {
        return new GetRestApisPublisher(this, applyPaginatorUserAgent(getRestApisRequest));
    }

    /**
     * <p>
     * Generates a client SDK for a <a>RestApi</a> and <a>Stage</a>.
     * </p>
     *
     * @param getSdkRequest
     *        Request a new generated client SDK for a <a>RestApi</a> and <a>Stage</a>.
     * @return A Java Future containing the result of the GetSdk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetSdk
     */
    @Override
    public CompletableFuture<GetSdkResponse> getSdk(GetSdkRequest getSdkRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSdkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSdk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(false).build();

            HttpResponseHandler<GetSdkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSdkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSdkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSdkRequest, GetSdkResponse>().withOperationName("GetSdk")
                            .withMarshaller(new GetSdkRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSdkRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSdkRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetSdkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetSdkType operation asynchronously.
     *
     * @param getSdkTypeRequest
     *        Get an <a>SdkType</a> instance.
     * @return A Java Future containing the result of the GetSdkType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetSdkType
     */
    @Override
    public CompletableFuture<GetSdkTypeResponse> getSdkType(GetSdkTypeRequest getSdkTypeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSdkTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSdkType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSdkTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSdkTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSdkTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSdkTypeRequest, GetSdkTypeResponse>().withOperationName("GetSdkType")
                            .withMarshaller(new GetSdkTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSdkTypeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSdkTypeRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetSdkTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the GetSdkTypes operation asynchronously.
     *
     * @param getSdkTypesRequest
     *        Get the <a>SdkTypes</a> collection.
     * @return A Java Future containing the result of the GetSdkTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetSdkTypes
     */
    @Override
    public CompletableFuture<GetSdkTypesResponse> getSdkTypes(GetSdkTypesRequest getSdkTypesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSdkTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSdkTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSdkTypesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSdkTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSdkTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSdkTypesRequest, GetSdkTypesResponse>()
                            .withOperationName("GetSdkTypes").withMarshaller(new GetSdkTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSdkTypesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSdkTypesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetSdkTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a <a>Stage</a> resource.
     * </p>
     *
     * @param getStageRequest
     *        Requests API Gateway to get information about a <a>Stage</a> resource.
     * @return A Java Future containing the result of the GetStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetStage
     */
    @Override
    public CompletableFuture<GetStageResponse> getStage(GetStageRequest getStageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetStageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStageRequest, GetStageResponse>().withOperationName("GetStage")
                            .withMarshaller(new GetStageRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getStageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getStageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetStageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more <a>Stage</a> resources.
     * </p>
     *
     * @param getStagesRequest
     *        Requests API Gateway to get information about one or more <a>Stage</a> resources.
     * @return A Java Future containing the result of the GetStages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetStages
     */
    @Override
    public CompletableFuture<GetStagesResponse> getStages(GetStagesRequest getStagesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetStagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStagesRequest, GetStagesResponse>().withOperationName("GetStages")
                            .withMarshaller(new GetStagesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getStagesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getStagesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetStagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the <a>Tags</a> collection for a given resource.
     * </p>
     *
     * @param getTagsRequest
     *        Gets the <a>Tags</a> collection for a given resource.
     * @return A Java Future containing the result of the GetTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetTags
     */
    @Override
    public CompletableFuture<GetTagsResponse> getTags(GetTagsRequest getTagsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTagsRequest, GetTagsResponse>().withOperationName("GetTags")
                            .withMarshaller(new GetTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTagsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getTagsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the usage data of a usage plan in a specified time interval.
     * </p>
     *
     * @param getUsageRequest
     *        The GET request to get the usage data of a usage plan in a specified time interval.
     * @return A Java Future containing the result of the GetUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsage
     */
    @Override
    public CompletableFuture<GetUsageResponse> getUsage(GetUsageRequest getUsageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetUsageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsageRequest, GetUsageResponse>().withOperationName("GetUsage")
                            .withMarshaller(new GetUsageRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUsageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getUsageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetUsageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the usage data of a usage plan in a specified time interval.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getUsage(software.amazon.awssdk.services.apigateway.model.GetUsageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePublisher publisher = client.getUsagePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePublisher publisher = client.getUsagePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetUsageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetUsageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsage(software.amazon.awssdk.services.apigateway.model.GetUsageRequest)} operation.</b>
     * </p>
     *
     * @param getUsageRequest
     *        The GET request to get the usage data of a usage plan in a specified time interval.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsage
     */
    public GetUsagePublisher getUsagePaginator(GetUsageRequest getUsageRequest) {
        return new GetUsagePublisher(this, applyPaginatorUserAgent(getUsageRequest));
    }

    /**
     * <p>
     * Gets a usage plan of a given plan identifier.
     * </p>
     *
     * @param getUsagePlanRequest
     *        The GET request to get a usage plan of a given plan identifier.
     * @return A Java Future containing the result of the GetUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlan
     */
    @Override
    public CompletableFuture<GetUsagePlanResponse> getUsagePlan(GetUsagePlanRequest getUsagePlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsagePlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsagePlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetUsagePlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsagePlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsagePlanRequest, GetUsagePlanResponse>()
                            .withOperationName("GetUsagePlan").withMarshaller(new GetUsagePlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getUsagePlanRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getUsagePlanRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetUsagePlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a usage plan key of a given key identifier.
     * </p>
     *
     * @param getUsagePlanKeyRequest
     *        The GET request to get a usage plan key of a given key identifier.
     * @return A Java Future containing the result of the GetUsagePlanKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlanKey
     */
    @Override
    public CompletableFuture<GetUsagePlanKeyResponse> getUsagePlanKey(GetUsagePlanKeyRequest getUsagePlanKeyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsagePlanKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsagePlanKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsagePlanKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUsagePlanKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsagePlanKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsagePlanKeyRequest, GetUsagePlanKeyResponse>()
                            .withOperationName("GetUsagePlanKey")
                            .withMarshaller(new GetUsagePlanKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getUsagePlanKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getUsagePlanKeyRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetUsagePlanKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     * </p>
     *
     * @param getUsagePlanKeysRequest
     *        The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.
     * @return A Java Future containing the result of the GetUsagePlanKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlanKeys
     */
    @Override
    public CompletableFuture<GetUsagePlanKeysResponse> getUsagePlanKeys(GetUsagePlanKeysRequest getUsagePlanKeysRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsagePlanKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsagePlanKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsagePlanKeysResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUsagePlanKeysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsagePlanKeysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsagePlanKeysRequest, GetUsagePlanKeysResponse>()
                            .withOperationName("GetUsagePlanKeys")
                            .withMarshaller(new GetUsagePlanKeysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getUsagePlanKeysRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getUsagePlanKeysRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetUsagePlanKeysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUsagePlanKeys(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysPublisher publisher = client.getUsagePlanKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysPublisher publisher = client.getUsagePlanKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsagePlanKeys(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUsagePlanKeysRequest
     *        The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlanKeys
     */
    public GetUsagePlanKeysPublisher getUsagePlanKeysPaginator(GetUsagePlanKeysRequest getUsagePlanKeysRequest) {
        return new GetUsagePlanKeysPublisher(this, applyPaginatorUserAgent(getUsagePlanKeysRequest));
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     *
     * @param getUsagePlansRequest
     *        The GET request to get all the usage plans of the caller's account.
     * @return A Java Future containing the result of the GetUsagePlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlans
     */
    @Override
    public CompletableFuture<GetUsagePlansResponse> getUsagePlans(GetUsagePlansRequest getUsagePlansRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsagePlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsagePlans");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsagePlansResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetUsagePlansResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsagePlansResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsagePlansRequest, GetUsagePlansResponse>()
                            .withOperationName("GetUsagePlans")
                            .withMarshaller(new GetUsagePlansRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getUsagePlansRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getUsagePlansRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetUsagePlansResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansPublisher publisher = client.getUsagePlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansPublisher publisher = client.getUsagePlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation.</b>
     * </p>
     *
     * @param getUsagePlansRequest
     *        The GET request to get all the usage plans of the caller's account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlans
     */
    public GetUsagePlansPublisher getUsagePlansPaginator(GetUsagePlansRequest getUsagePlansRequest) {
        return new GetUsagePlansPublisher(this, applyPaginatorUserAgent(getUsagePlansRequest));
    }

    /**
     * <p>
     * Gets a specified VPC link under the caller's account in a region.
     * </p>
     *
     * @param getVpcLinkRequest
     *        Gets a specified VPC link under the caller's account in a region.
     * @return A Java Future containing the result of the GetVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetVpcLink
     */
    @Override
    public CompletableFuture<GetVpcLinkResponse> getVpcLink(GetVpcLinkRequest getVpcLinkRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVpcLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVpcLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetVpcLinkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVpcLinkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVpcLinkRequest, GetVpcLinkResponse>().withOperationName("GetVpcLink")
                            .withMarshaller(new GetVpcLinkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVpcLinkRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getVpcLinkRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetVpcLinkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * </p>
     *
     * @param getVpcLinksRequest
     *        Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * @return A Java Future containing the result of the GetVpcLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetVpcLinks
     */
    @Override
    public CompletableFuture<GetVpcLinksResponse> getVpcLinks(GetVpcLinksRequest getVpcLinksRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVpcLinksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVpcLinks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVpcLinksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetVpcLinksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVpcLinksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVpcLinksRequest, GetVpcLinksResponse>()
                            .withOperationName("GetVpcLinks").withMarshaller(new GetVpcLinksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getVpcLinksRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getVpcLinksRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetVpcLinksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksPublisher publisher = client.getVpcLinksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksPublisher publisher = client.getVpcLinksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)} operation.</b>
     * </p>
     *
     * @param getVpcLinksRequest
     *        Gets the <a>VpcLinks</a> collection under the caller's account in a selected region.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetVpcLinks
     */
    public GetVpcLinksPublisher getVpcLinksPaginator(GetVpcLinksRequest getVpcLinksRequest) {
        return new GetVpcLinksPublisher(this, applyPaginatorUserAgent(getVpcLinksRequest));
    }

    /**
     * <p>
     * Import API keys from an external source, such as a CSV-formatted file.
     * </p>
     *
     * @param importApiKeysRequest
     *        The POST request to import API keys from an external source, such as a CSV-formatted file.
     * @return A Java Future containing the result of the ImportApiKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.ImportApiKeys
     */
    @Override
    public CompletableFuture<ImportApiKeysResponse> importApiKeys(ImportApiKeysRequest importApiKeysRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importApiKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportApiKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportApiKeysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ImportApiKeysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportApiKeysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportApiKeysRequest, ImportApiKeysResponse>()
                            .withOperationName("ImportApiKeys")
                            .withMarshaller(new ImportApiKeysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(importApiKeysRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = importApiKeysRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ImportApiKeysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the ImportDocumentationParts operation asynchronously.
     *
     * @param importDocumentationPartsRequest
     *        Import documentation parts from an external (e.g., OpenAPI) definition file.
     * @return A Java Future containing the result of the ImportDocumentationParts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.ImportDocumentationParts
     */
    @Override
    public CompletableFuture<ImportDocumentationPartsResponse> importDocumentationParts(
            ImportDocumentationPartsRequest importDocumentationPartsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importDocumentationPartsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportDocumentationParts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportDocumentationPartsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ImportDocumentationPartsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportDocumentationPartsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportDocumentationPartsRequest, ImportDocumentationPartsResponse>()
                            .withOperationName("ImportDocumentationParts")
                            .withMarshaller(new ImportDocumentationPartsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(importDocumentationPartsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = importDocumentationPartsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ImportDocumentationPartsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A feature of the API Gateway control service for creating a new API from an external API definition file.
     * </p>
     *
     * @param importRestApiRequest
     *        A POST request to import an API to API Gateway using an input of an API definition file.
     * @return A Java Future containing the result of the ImportRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.ImportRestApi
     */
    @Override
    public CompletableFuture<ImportRestApiResponse> importRestApi(ImportRestApiRequest importRestApiRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importRestApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportRestApi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ImportRestApiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportRestApiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportRestApiRequest, ImportRestApiResponse>()
                            .withOperationName("ImportRestApi")
                            .withMarshaller(new ImportRestApiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(importRestApiRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = importRestApiRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ImportRestApiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code on the given
     * <a>RestApi</a>.
     * </p>
     *
     * @param putGatewayResponseRequest
     *        Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code on the
     *        given <a>RestApi</a>.
     * @return A Java Future containing the result of the PutGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutGatewayResponse
     */
    @Override
    public CompletableFuture<PutGatewayResponseResponse> putGatewayResponse(PutGatewayResponseRequest putGatewayResponseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putGatewayResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutGatewayResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutGatewayResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutGatewayResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutGatewayResponseRequest, PutGatewayResponseResponse>()
                            .withOperationName("PutGatewayResponse")
                            .withMarshaller(new PutGatewayResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putGatewayResponseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putGatewayResponseRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<PutGatewayResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets up a method's integration.
     * </p>
     *
     * @param putIntegrationRequest
     *        Sets up a method's integration.
     * @return A Java Future containing the result of the PutIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutIntegration
     */
    @Override
    public CompletableFuture<PutIntegrationResponse> putIntegration(PutIntegrationRequest putIntegrationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutIntegrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutIntegrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutIntegrationRequest, PutIntegrationResponse>()
                            .withOperationName("PutIntegration")
                            .withMarshaller(new PutIntegrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putIntegrationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putIntegrationRequest.overrideConfiguration().orElse(null);
            CompletableFuture<PutIntegrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a put integration.
     * </p>
     *
     * @param putIntegrationResponseRequest
     *        Represents a put integration response request.
     * @return A Java Future containing the result of the PutIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutIntegrationResponse
     */
    @Override
    public CompletableFuture<PutIntegrationResponseResponse> putIntegrationResponse(
            PutIntegrationResponseRequest putIntegrationResponseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putIntegrationResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutIntegrationResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutIntegrationResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutIntegrationResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutIntegrationResponseRequest, PutIntegrationResponseResponse>()
                            .withOperationName("PutIntegrationResponse")
                            .withMarshaller(new PutIntegrationResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putIntegrationResponseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putIntegrationResponseRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<PutIntegrationResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Add a method to an existing <a>Resource</a> resource.
     * </p>
     *
     * @param putMethodRequest
     *        Request to add a method to an existing <a>Resource</a> resource.
     * @return A Java Future containing the result of the PutMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutMethod
     */
    @Override
    public CompletableFuture<PutMethodResponse> putMethod(PutMethodRequest putMethodRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putMethodRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutMethodResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutMethodResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutMethodResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutMethodRequest, PutMethodResponse>().withOperationName("PutMethod")
                            .withMarshaller(new PutMethodRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(putMethodRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putMethodRequest.overrideConfiguration().orElse(null);
            CompletableFuture<PutMethodResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a <a>MethodResponse</a> to an existing <a>Method</a> resource.
     * </p>
     *
     * @param putMethodResponseRequest
     *        Request to add a <a>MethodResponse</a> to an existing <a>Method</a> resource.
     * @return A Java Future containing the result of the PutMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutMethodResponse
     */
    @Override
    public CompletableFuture<PutMethodResponseResponse> putMethodResponse(PutMethodResponseRequest putMethodResponseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putMethodResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMethodResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutMethodResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutMethodResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutMethodResponseRequest, PutMethodResponseResponse>()
                            .withOperationName("PutMethodResponse")
                            .withMarshaller(new PutMethodResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putMethodResponseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putMethodResponseRequest.overrideConfiguration().orElse(null);
            CompletableFuture<PutMethodResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A feature of the API Gateway control service for updating an existing API with an input of external API
     * definitions. The update can take the form of merging the supplied definition into the existing API or overwriting
     * the existing API.
     * </p>
     *
     * @param putRestApiRequest
     *        A PUT request to update an existing API, with external API definitions specified as the request body.
     * @return A Java Future containing the result of the PutRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutRestApi
     */
    @Override
    public CompletableFuture<PutRestApiResponse> putRestApi(PutRestApiRequest putRestApiRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRestApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRestApi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutRestApiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutRestApiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutRestApiRequest, PutRestApiResponse>().withOperationName("PutRestApi")
                            .withMarshaller(new PutRestApiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putRestApiRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putRestApiRequest.overrideConfiguration().orElse(null);
            CompletableFuture<PutRestApiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates a tag on a given resource.
     * </p>
     *
     * @param tagResourceRequest
     *        Adds or updates a tag on a given resource.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.TagResource
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Simulate the execution of an <a>Authorizer</a> in your <a>RestApi</a> with headers, parameters, and an incoming
     * request body.
     * </p>
     * <div class="seeAlso"> <a
     * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">Use
     * Lambda Function as Authorizer</a> <a
     * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">Use
     * Cognito User Pool as Authorizer</a> </div>
     *
     * @param testInvokeAuthorizerRequest
     *        Make a request to simulate the execution of an <a>Authorizer</a>.
     * @return A Java Future containing the result of the TestInvokeAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.TestInvokeAuthorizer
     */
    @Override
    public CompletableFuture<TestInvokeAuthorizerResponse> testInvokeAuthorizer(
            TestInvokeAuthorizerRequest testInvokeAuthorizerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testInvokeAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestInvokeAuthorizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestInvokeAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TestInvokeAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TestInvokeAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestInvokeAuthorizerRequest, TestInvokeAuthorizerResponse>()
                            .withOperationName("TestInvokeAuthorizer")
                            .withMarshaller(new TestInvokeAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(testInvokeAuthorizerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = testInvokeAuthorizerRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<TestInvokeAuthorizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Simulate the execution of a <a>Method</a> in your <a>RestApi</a> with headers, parameters, and an incoming
     * request body.
     * </p>
     *
     * @param testInvokeMethodRequest
     *        Make a request to simulate the execution of a <a>Method</a>.
     * @return A Java Future containing the result of the TestInvokeMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.TestInvokeMethod
     */
    @Override
    public CompletableFuture<TestInvokeMethodResponse> testInvokeMethod(TestInvokeMethodRequest testInvokeMethodRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testInvokeMethodRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestInvokeMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestInvokeMethodResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TestInvokeMethodResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TestInvokeMethodResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestInvokeMethodRequest, TestInvokeMethodResponse>()
                            .withOperationName("TestInvokeMethod")
                            .withMarshaller(new TestInvokeMethodRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(testInvokeMethodRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = testInvokeMethodRequest.overrideConfiguration().orElse(null);
            CompletableFuture<TestInvokeMethodResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a tag from a given resource.
     * </p>
     *
     * @param untagResourceRequest
     *        Removes a tag from a given resource.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UntagResource
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about the current <a>Account</a> resource.
     * </p>
     *
     * @param updateAccountRequest
     *        Requests API Gateway to change information about the current <a>Account</a> resource.
     * @return A Java Future containing the result of the UpdateAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateAccount
     */
    @Override
    public CompletableFuture<UpdateAccountResponse> updateAccount(UpdateAccountRequest updateAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAccountResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAccountRequest, UpdateAccountResponse>()
                            .withOperationName("UpdateAccount")
                            .withMarshaller(new UpdateAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateAccountRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateAccountRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about an <a>ApiKey</a> resource.
     * </p>
     *
     * @param updateApiKeyRequest
     *        A request to change information about an <a>ApiKey</a> resource.
     * @return A Java Future containing the result of the UpdateApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateApiKey
     */
    @Override
    public CompletableFuture<UpdateApiKeyResponse> updateApiKey(UpdateApiKeyRequest updateApiKeyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApiKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApiKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateApiKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateApiKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApiKeyRequest, UpdateApiKeyResponse>()
                            .withOperationName("UpdateApiKey").withMarshaller(new UpdateApiKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateApiKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateApiKeyRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateApiKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing <a>Authorizer</a> resource.
     * </p>
     * <div class="seeAlso"><a
     * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/update-authorizer.html">AWS CLI</a></div>
     *
     * @param updateAuthorizerRequest
     *        Request to update an existing <a>Authorizer</a> resource.
     * @return A Java Future containing the result of the UpdateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateAuthorizer
     */
    @Override
    public CompletableFuture<UpdateAuthorizerResponse> updateAuthorizer(UpdateAuthorizerRequest updateAuthorizerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAuthorizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAuthorizerRequest, UpdateAuthorizerResponse>()
                            .withOperationName("UpdateAuthorizer")
                            .withMarshaller(new UpdateAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateAuthorizerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateAuthorizerRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateAuthorizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about the <a>BasePathMapping</a> resource.
     * </p>
     *
     * @param updateBasePathMappingRequest
     *        A request to change information about the <a>BasePathMapping</a> resource.
     * @return A Java Future containing the result of the UpdateBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateBasePathMapping
     */
    @Override
    public CompletableFuture<UpdateBasePathMappingResponse> updateBasePathMapping(
            UpdateBasePathMappingRequest updateBasePathMappingRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBasePathMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBasePathMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBasePathMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBasePathMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBasePathMappingRequest, UpdateBasePathMappingResponse>()
                            .withOperationName("UpdateBasePathMapping")
                            .withMarshaller(new UpdateBasePathMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateBasePathMappingRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateBasePathMappingRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateBasePathMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about an <a>ClientCertificate</a> resource.
     * </p>
     *
     * @param updateClientCertificateRequest
     *        A request to change information about an <a>ClientCertificate</a> resource.
     * @return A Java Future containing the result of the UpdateClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateClientCertificate
     */
    @Override
    public CompletableFuture<UpdateClientCertificateResponse> updateClientCertificate(
            UpdateClientCertificateRequest updateClientCertificateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateClientCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateClientCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateClientCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateClientCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateClientCertificateRequest, UpdateClientCertificateResponse>()
                            .withOperationName("UpdateClientCertificate")
                            .withMarshaller(new UpdateClientCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateClientCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateClientCertificateRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateClientCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about a <a>Deployment</a> resource.
     * </p>
     *
     * @param updateDeploymentRequest
     *        Requests API Gateway to change information about a <a>Deployment</a> resource.
     * @return A Java Future containing the result of the UpdateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDeployment
     */
    @Override
    public CompletableFuture<UpdateDeploymentResponse> updateDeployment(UpdateDeploymentRequest updateDeploymentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDeploymentRequest, UpdateDeploymentResponse>()
                            .withOperationName("UpdateDeployment")
                            .withMarshaller(new UpdateDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDeploymentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateDeploymentRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the UpdateDocumentationPart operation asynchronously.
     *
     * @param updateDocumentationPartRequest
     *        Updates an existing documentation part of a given API.
     * @return A Java Future containing the result of the UpdateDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDocumentationPart
     */
    @Override
    public CompletableFuture<UpdateDocumentationPartResponse> updateDocumentationPart(
            UpdateDocumentationPartRequest updateDocumentationPartRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDocumentationPartRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDocumentationPart");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDocumentationPartResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDocumentationPartResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDocumentationPartRequest, UpdateDocumentationPartResponse>()
                            .withOperationName("UpdateDocumentationPart")
                            .withMarshaller(new UpdateDocumentationPartRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDocumentationPartRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateDocumentationPartRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateDocumentationPartResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Invokes the UpdateDocumentationVersion operation asynchronously.
     *
     * @param updateDocumentationVersionRequest
     *        Updates an existing documentation version of an API.
     * @return A Java Future containing the result of the UpdateDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDocumentationVersion
     */
    @Override
    public CompletableFuture<UpdateDocumentationVersionResponse> updateDocumentationVersion(
            UpdateDocumentationVersionRequest updateDocumentationVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDocumentationVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDocumentationVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDocumentationVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDocumentationVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDocumentationVersionRequest, UpdateDocumentationVersionResponse>()
                            .withOperationName("UpdateDocumentationVersion")
                            .withMarshaller(new UpdateDocumentationVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDocumentationVersionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateDocumentationVersionRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateDocumentationVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about the <a>DomainName</a> resource.
     * </p>
     *
     * @param updateDomainNameRequest
     *        A request to change information about the <a>DomainName</a> resource.
     * @return A Java Future containing the result of the UpdateDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDomainName
     */
    @Override
    public CompletableFuture<UpdateDomainNameResponse> updateDomainName(UpdateDomainNameRequest updateDomainNameRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDomainName");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDomainNameResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDomainNameResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDomainNameRequest, UpdateDomainNameResponse>()
                            .withOperationName("UpdateDomainName")
                            .withMarshaller(new UpdateDomainNameRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDomainNameRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateDomainNameRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateDomainNameResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * </p>
     *
     * @param updateGatewayResponseRequest
     *        Updates a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.
     * @return A Java Future containing the result of the UpdateGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateGatewayResponse
     */
    @Override
    public CompletableFuture<UpdateGatewayResponseResponse> updateGatewayResponse(
            UpdateGatewayResponseRequest updateGatewayResponseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGatewayResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGatewayResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateGatewayResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGatewayResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGatewayResponseRequest, UpdateGatewayResponseResponse>()
                            .withOperationName("UpdateGatewayResponse")
                            .withMarshaller(new UpdateGatewayResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateGatewayResponseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateGatewayResponseRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateGatewayResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents an update integration.
     * </p>
     *
     * @param updateIntegrationRequest
     *        Represents an update integration request.
     * @return A Java Future containing the result of the UpdateIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateIntegration
     */
    @Override
    public CompletableFuture<UpdateIntegrationResponse> updateIntegration(UpdateIntegrationRequest updateIntegrationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateIntegrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIntegrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIntegrationRequest, UpdateIntegrationResponse>()
                            .withOperationName("UpdateIntegration")
                            .withMarshaller(new UpdateIntegrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateIntegrationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateIntegrationRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateIntegrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents an update integration response.
     * </p>
     *
     * @param updateIntegrationResponseRequest
     *        Represents an update integration response request.
     * @return A Java Future containing the result of the UpdateIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateIntegrationResponse
     */
    @Override
    public CompletableFuture<UpdateIntegrationResponseResponse> updateIntegrationResponse(
            UpdateIntegrationResponseRequest updateIntegrationResponseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIntegrationResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIntegrationResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateIntegrationResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIntegrationResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIntegrationResponseRequest, UpdateIntegrationResponseResponse>()
                            .withOperationName("UpdateIntegrationResponse")
                            .withMarshaller(new UpdateIntegrationResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateIntegrationResponseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateIntegrationResponseRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateIntegrationResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing <a>Method</a> resource.
     * </p>
     *
     * @param updateMethodRequest
     *        Request to update an existing <a>Method</a> resource.
     * @return A Java Future containing the result of the UpdateMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateMethod
     */
    @Override
    public CompletableFuture<UpdateMethodResponse> updateMethod(UpdateMethodRequest updateMethodRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMethodRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMethodResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateMethodResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMethodResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMethodRequest, UpdateMethodResponse>()
                            .withOperationName("UpdateMethod").withMarshaller(new UpdateMethodRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateMethodRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateMethodRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateMethodResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing <a>MethodResponse</a> resource.
     * </p>
     *
     * @param updateMethodResponseRequest
     *        A request to update an existing <a>MethodResponse</a> resource.
     * @return A Java Future containing the result of the UpdateMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateMethodResponse
     */
    @Override
    public CompletableFuture<UpdateMethodResponseResponse> updateMethodResponse(
            UpdateMethodResponseRequest updateMethodResponseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMethodResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMethodResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMethodResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMethodResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMethodResponseRequest, UpdateMethodResponseResponse>()
                            .withOperationName("UpdateMethodResponse")
                            .withMarshaller(new UpdateMethodResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateMethodResponseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateMethodResponseRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateMethodResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about a model.
     * </p>
     *
     * @param updateModelRequest
     *        Request to update an existing model in an existing <a>RestApi</a> resource.
     * @return A Java Future containing the result of the UpdateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateModel
     */
    @Override
    public CompletableFuture<UpdateModelResponse> updateModel(UpdateModelRequest updateModelRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateModelRequest, UpdateModelResponse>()
                            .withOperationName("UpdateModel").withMarshaller(new UpdateModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateModelRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateModelRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * </p>
     *
     * @param updateRequestValidatorRequest
     *        Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.
     * @return A Java Future containing the result of the UpdateRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateRequestValidator
     */
    @Override
    public CompletableFuture<UpdateRequestValidatorResponse> updateRequestValidator(
            UpdateRequestValidatorRequest updateRequestValidatorRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRequestValidatorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRequestValidator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRequestValidatorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRequestValidatorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRequestValidatorRequest, UpdateRequestValidatorResponse>()
                            .withOperationName("UpdateRequestValidator")
                            .withMarshaller(new UpdateRequestValidatorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateRequestValidatorRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateRequestValidatorRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateRequestValidatorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about a <a>Resource</a> resource.
     * </p>
     *
     * @param updateResourceRequest
     *        Request to change information about a <a>Resource</a> resource.
     * @return A Java Future containing the result of the UpdateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateResource
     */
    @Override
    public CompletableFuture<UpdateResourceResponse> updateResource(UpdateResourceRequest updateResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResourceRequest, UpdateResourceResponse>()
                            .withOperationName("UpdateResource")
                            .withMarshaller(new UpdateResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about the specified API.
     * </p>
     *
     * @param updateRestApiRequest
     *        Request to update an existing <a>RestApi</a> resource in your collection.
     * @return A Java Future containing the result of the UpdateRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateRestApi
     */
    @Override
    public CompletableFuture<UpdateRestApiResponse> updateRestApi(UpdateRestApiRequest updateRestApiRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRestApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRestApi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateRestApiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRestApiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRestApiRequest, UpdateRestApiResponse>()
                            .withOperationName("UpdateRestApi")
                            .withMarshaller(new UpdateRestApiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateRestApiRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateRestApiRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateRestApiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about a <a>Stage</a> resource.
     * </p>
     *
     * @param updateStageRequest
     *        Requests API Gateway to change information about a <a>Stage</a> resource.
     * @return A Java Future containing the result of the UpdateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateStage
     */
    @Override
    public CompletableFuture<UpdateStageResponse> updateStage(UpdateStageRequest updateStageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateStageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateStageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateStageRequest, UpdateStageResponse>()
                            .withOperationName("UpdateStage").withMarshaller(new UpdateStageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateStageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateStageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateStageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.
     * </p>
     *
     * @param updateUsageRequest
     *        The PATCH request to grant a temporary extension to the remaining quota of a usage plan associated with a
     *        specified API key.
     * @return A Java Future containing the result of the UpdateUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateUsage
     */
    @Override
    public CompletableFuture<UpdateUsageResponse> updateUsage(UpdateUsageRequest updateUsageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUsageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUsageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateUsageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUsageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUsageRequest, UpdateUsageResponse>()
                            .withOperationName("UpdateUsage").withMarshaller(new UpdateUsageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateUsageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateUsageRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateUsageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a usage plan of a given plan Id.
     * </p>
     *
     * @param updateUsagePlanRequest
     *        The PATCH request to update a usage plan of a given plan Id.
     * @return A Java Future containing the result of the UpdateUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateUsagePlan
     */
    @Override
    public CompletableFuture<UpdateUsagePlanResponse> updateUsagePlan(UpdateUsagePlanRequest updateUsagePlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUsagePlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUsagePlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateUsagePlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUsagePlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUsagePlanRequest, UpdateUsagePlanResponse>()
                            .withOperationName("UpdateUsagePlan")
                            .withMarshaller(new UpdateUsagePlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateUsagePlanRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateUsagePlanRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateUsagePlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing <a>VpcLink</a> of a specified identifier.
     * </p>
     *
     * @param updateVpcLinkRequest
     *        Updates an existing <a>VpcLink</a> of a specified identifier.
     * @return A Java Future containing the result of the UpdateVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateVpcLink
     */
    @Override
    public CompletableFuture<UpdateVpcLinkResponse> updateVpcLink(UpdateVpcLinkRequest updateVpcLinkRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVpcLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVpcLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateVpcLinkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateVpcLinkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVpcLinkRequest, UpdateVpcLinkResponse>()
                            .withOperationName("UpdateVpcLink")
                            .withMarshaller(new UpdateVpcLinkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateVpcLinkRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateVpcLinkRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateVpcLinkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ApiGatewayException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(503).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends ApiGatewayRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
