/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.
 * </p>
 * <div class="seeAlso"><a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/stages.html">Deploying API
 * in Stages</a></div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStagesResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetStagesResponse.Builder, GetStagesResponse> {
    private static final SdkField<List<Stage>> ITEM_FIELD = SdkField
            .<List<Stage>> builder(MarshallingType.LIST)
            .getter(getter(GetStagesResponse::item))
            .setter(setter(Builder::item))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("item").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Stage> builder(MarshallingType.SDK_POJO)
                                            .constructor(Stage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD));

    private final List<Stage> item;

    private GetStagesResponse(BuilderImpl builder) {
        super(builder);
        this.item = builder.item;
    }

    /**
     * Returns true if the Item property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasItem() {
        return item != null && !(item instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The current page of elements from this collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItem()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The current page of elements from this collection.
     */
    public List<Stage> item() {
        return item;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(item());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStagesResponse)) {
            return false;
        }
        GetStagesResponse other = (GetStagesResponse) obj;
        return Objects.equals(item(), other.item());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetStagesResponse").add("Item", item()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "item":
            return Optional.ofNullable(clazz.cast(item()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStagesResponse, T> g) {
        return obj -> g.apply((GetStagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStagesResponse> {
        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * 
         * @param item
         *        The current page of elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Collection<Stage> item);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * 
         * @param item
         *        The current page of elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Stage... item);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Stage>.Builder} avoiding the need to create
         * one manually via {@link List<Stage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Stage>.Builder#build()} is called immediately and its result
         * is passed to {@link #item(List<Stage>)}.
         * 
         * @param item
         *        a consumer that will call methods on {@link List<Stage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #item(List<Stage>)
         */
        Builder item(Consumer<Stage.Builder>... item);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private List<Stage> item = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetStagesResponse model) {
            super(model);
            item(model.item);
        }

        public final Collection<Stage.Builder> getItem() {
            return item != null ? item.stream().map(Stage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<Stage> item) {
            this.item = ListOfStageCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Stage... item) {
            item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<Stage.Builder>... item) {
            item(Stream.of(item).map(c -> Stage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItem(Collection<Stage.BuilderImpl> item) {
            this.item = ListOfStageCopier.copyFromBuilder(item);
        }

        @Override
        public GetStagesResponse build() {
            return new GetStagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
