/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ApiKeySourceType;
import software.amazon.awssdk.services.apigateway.model.EndpointConfiguration;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRestApiResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, PutRestApiResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(PutRestApiResponse.getter(PutRestApiResponse::id)).setter(PutRestApiResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PutRestApiResponse.getter(PutRestApiResponse::name)).setter(PutRestApiResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(PutRestApiResponse.getter(PutRestApiResponse::description)).setter(PutRestApiResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(PutRestApiResponse.getter(PutRestApiResponse::createdDate)).setter(PutRestApiResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(PutRestApiResponse.getter(PutRestApiResponse::version)).setter(PutRestApiResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<List<String>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("warnings").getter(PutRestApiResponse.getter(PutRestApiResponse::warnings)).setter(PutRestApiResponse.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BINARY_MEDIA_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("binaryMediaTypes").getter(PutRestApiResponse.getter(PutRestApiResponse::binaryMediaTypes)).setter(PutRestApiResponse.setter(Builder::binaryMediaTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binaryMediaTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MINIMUM_COMPRESSION_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minimumCompressionSize").getter(PutRestApiResponse.getter(PutRestApiResponse::minimumCompressionSize)).setter(PutRestApiResponse.setter(Builder::minimumCompressionSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumCompressionSize").build()}).build();
    private static final SdkField<String> API_KEY_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiKeySource").getter(PutRestApiResponse.getter(PutRestApiResponse::apiKeySourceAsString)).setter(PutRestApiResponse.setter(Builder::apiKeySource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeySource").build()}).build();
    private static final SdkField<EndpointConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("endpointConfiguration").getter(PutRestApiResponse.getter(PutRestApiResponse::endpointConfiguration)).setter(PutRestApiResponse.setter(Builder::endpointConfiguration)).constructor(EndpointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfiguration").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policy").getter(PutRestApiResponse.getter(PutRestApiResponse::policy)).setter(PutRestApiResponse.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(PutRestApiResponse.getter(PutRestApiResponse::tags)).setter(PutRestApiResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CREATED_DATE_FIELD, VERSION_FIELD, WARNINGS_FIELD, BINARY_MEDIA_TYPES_FIELD, MINIMUM_COMPRESSION_SIZE_FIELD, API_KEY_SOURCE_FIELD, ENDPOINT_CONFIGURATION_FIELD, POLICY_FIELD, TAGS_FIELD));
    private final String id;
    private final String name;
    private final String description;
    private final Instant createdDate;
    private final String version;
    private final List<String> warnings;
    private final List<String> binaryMediaTypes;
    private final Integer minimumCompressionSize;
    private final String apiKeySource;
    private final EndpointConfiguration endpointConfiguration;
    private final String policy;
    private final Map<String, String> tags;

    private PutRestApiResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.warnings = builder.warnings;
        this.binaryMediaTypes = builder.binaryMediaTypes;
        this.minimumCompressionSize = builder.minimumCompressionSize;
        this.apiKeySource = builder.apiKeySource;
        this.endpointConfiguration = builder.endpointConfiguration;
        this.policy = builder.policy;
        this.tags = builder.tags;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public String version() {
        return this.version;
    }

    public boolean hasWarnings() {
        return this.warnings != null && !(this.warnings instanceof SdkAutoConstructList);
    }

    public List<String> warnings() {
        return this.warnings;
    }

    public boolean hasBinaryMediaTypes() {
        return this.binaryMediaTypes != null && !(this.binaryMediaTypes instanceof SdkAutoConstructList);
    }

    public List<String> binaryMediaTypes() {
        return this.binaryMediaTypes;
    }

    public Integer minimumCompressionSize() {
        return this.minimumCompressionSize;
    }

    public ApiKeySourceType apiKeySource() {
        return ApiKeySourceType.fromValue(this.apiKeySource);
    }

    public String apiKeySourceAsString() {
        return this.apiKeySource;
    }

    public EndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public String policy() {
        return this.policy;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWarnings() ? this.warnings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBinaryMediaTypes() ? this.binaryMediaTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumCompressionSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeySourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRestApiResponse)) {
            return false;
        }
        PutRestApiResponse other = (PutRestApiResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.version(), other.version()) && this.hasWarnings() == other.hasWarnings() && Objects.equals(this.warnings(), other.warnings()) && this.hasBinaryMediaTypes() == other.hasBinaryMediaTypes() && Objects.equals(this.binaryMediaTypes(), other.binaryMediaTypes()) && Objects.equals(this.minimumCompressionSize(), other.minimumCompressionSize()) && Objects.equals(this.apiKeySourceAsString(), other.apiKeySourceAsString()) && Objects.equals(this.endpointConfiguration(), other.endpointConfiguration()) && Objects.equals(this.policy(), other.policy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"PutRestApiResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CreatedDate", (Object)this.createdDate()).add("Version", (Object)this.version()).add("Warnings", this.hasWarnings() ? this.warnings() : null).add("BinaryMediaTypes", this.hasBinaryMediaTypes() ? this.binaryMediaTypes() : null).add("MinimumCompressionSize", (Object)this.minimumCompressionSize()).add("ApiKeySource", (Object)this.apiKeySourceAsString()).add("EndpointConfiguration", (Object)this.endpointConfiguration()).add("Policy", (Object)this.policy()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
            case "binaryMediaTypes": {
                return Optional.ofNullable(clazz.cast(this.binaryMediaTypes()));
            }
            case "minimumCompressionSize": {
                return Optional.ofNullable(clazz.cast(this.minimumCompressionSize()));
            }
            case "apiKeySource": {
                return Optional.ofNullable(clazz.cast(this.apiKeySourceAsString()));
            }
            case "endpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRestApiResponse, T> g) {
        return obj -> g.apply((PutRestApiResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private Instant createdDate;
        private String version;
        private List<String> warnings = DefaultSdkAutoConstructList.getInstance();
        private List<String> binaryMediaTypes = DefaultSdkAutoConstructList.getInstance();
        private Integer minimumCompressionSize;
        private String apiKeySource;
        private EndpointConfiguration endpointConfiguration;
        private String policy;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRestApiResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.createdDate(model.createdDate);
            this.version(model.version);
            this.warnings(model.warnings);
            this.binaryMediaTypes(model.binaryMediaTypes);
            this.minimumCompressionSize(model.minimumCompressionSize);
            this.apiKeySource(model.apiKeySource);
            this.endpointConfiguration(model.endpointConfiguration);
            this.policy(model.policy);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Collection<String> getWarnings() {
            if (this.warnings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.warnings;
        }

        @Override
        public final Builder warnings(Collection<String> warnings) {
            this.warnings = ListOfStringCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(String ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        public final void setWarnings(Collection<String> warnings) {
            this.warnings = ListOfStringCopier.copy(warnings);
        }

        public final Collection<String> getBinaryMediaTypes() {
            if (this.binaryMediaTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.binaryMediaTypes;
        }

        @Override
        public final Builder binaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = ListOfStringCopier.copy(binaryMediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binaryMediaTypes(String ... binaryMediaTypes) {
            this.binaryMediaTypes(Arrays.asList(binaryMediaTypes));
            return this;
        }

        public final void setBinaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = ListOfStringCopier.copy(binaryMediaTypes);
        }

        public final Integer getMinimumCompressionSize() {
            return this.minimumCompressionSize;
        }

        @Override
        public final Builder minimumCompressionSize(Integer minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        public final void setMinimumCompressionSize(Integer minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
        }

        public final String getApiKeySource() {
            return this.apiKeySource;
        }

        @Override
        public final Builder apiKeySource(String apiKeySource) {
            this.apiKeySource = apiKeySource;
            return this;
        }

        @Override
        public final Builder apiKeySource(ApiKeySourceType apiKeySource) {
            this.apiKeySource(apiKeySource == null ? null : apiKeySource.toString());
            return this;
        }

        public final void setApiKeySource(String apiKeySource) {
            this.apiKeySource = apiKeySource;
        }

        public final EndpointConfiguration.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final void setEndpointConfiguration(EndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public PutRestApiResponse build() {
            return new PutRestApiResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRestApiResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder createdDate(Instant var1);

        public Builder version(String var1);

        public Builder warnings(Collection<String> var1);

        public Builder warnings(String ... var1);

        public Builder binaryMediaTypes(Collection<String> var1);

        public Builder binaryMediaTypes(String ... var1);

        public Builder minimumCompressionSize(Integer var1);

        public Builder apiKeySource(String var1);

        public Builder apiKeySource(ApiKeySourceType var1);

        public Builder endpointConfiguration(EndpointConfiguration var1);

        default public Builder endpointConfiguration(Consumer<EndpointConfiguration.Builder> endpointConfiguration) {
            return this.endpointConfiguration((EndpointConfiguration)((EndpointConfiguration.Builder)EndpointConfiguration.builder().applyMutation(endpointConfiguration)).build());
        }

        public Builder policy(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

