/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to update an existing model in an existing <a>RestApi</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateModelRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<UpdateModelRequest.Builder, UpdateModelRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(UpdateModelRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelName").getter(getter(UpdateModelRequest::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("model_name").build()).build();

    private static final SdkField<List<PatchOperation>> PATCH_OPERATIONS_FIELD = SdkField
            .<List<PatchOperation>> builder(MarshallingType.LIST)
            .memberName("patchOperations")
            .getter(getter(UpdateModelRequest::patchOperations))
            .setter(setter(Builder::patchOperations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patchOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PatchOperation> builder(MarshallingType.SDK_POJO)
                                            .constructor(PatchOperation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            MODEL_NAME_FIELD, PATCH_OPERATIONS_FIELD));

    private final String restApiId;

    private final String modelName;

    private final List<PatchOperation> patchOperations;

    private UpdateModelRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.modelName = builder.modelName;
        this.patchOperations = builder.patchOperations;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] The name of the model to update.
     * </p>
     * 
     * @return [Required] The name of the model to update.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * Returns true if the PatchOperations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPatchOperations() {
        return patchOperations != null && !(patchOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of update operations to be applied to the specified resource and in the order specified in this list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPatchOperations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of update operations to be applied to the specified resource and in the order specified in this
     *         list.
     */
    public final List<PatchOperation> patchOperations() {
        return patchOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPatchOperations() ? patchOperations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelRequest)) {
            return false;
        }
        UpdateModelRequest other = (UpdateModelRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(modelName(), other.modelName())
                && hasPatchOperations() == other.hasPatchOperations()
                && Objects.equals(patchOperations(), other.patchOperations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateModelRequest").add("RestApiId", restApiId()).add("ModelName", modelName())
                .add("PatchOperations", hasPatchOperations() ? patchOperations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "modelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "patchOperations":
            return Optional.ofNullable(clazz.cast(patchOperations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateModelRequest, T> g) {
        return obj -> g.apply((UpdateModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateModelRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] The name of the model to update.
         * </p>
         * 
         * @param modelName
         *        [Required] The name of the model to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * A list of update operations to be applied to the specified resource and in the order specified in this list.
         * </p>
         * 
         * @param patchOperations
         *        A list of update operations to be applied to the specified resource and in the order specified in this
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchOperations(Collection<PatchOperation> patchOperations);

        /**
         * <p>
         * A list of update operations to be applied to the specified resource and in the order specified in this list.
         * </p>
         * 
         * @param patchOperations
         *        A list of update operations to be applied to the specified resource and in the order specified in this
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchOperations(PatchOperation... patchOperations);

        /**
         * <p>
         * A list of update operations to be applied to the specified resource and in the order specified in this list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PatchOperation>.Builder} avoiding the need
         * to create one manually via {@link List<PatchOperation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PatchOperation>.Builder#build()} is called immediately and
         * its result is passed to {@link #patchOperations(List<PatchOperation>)}.
         * 
         * @param patchOperations
         *        a consumer that will call methods on {@link List<PatchOperation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patchOperations(List<PatchOperation>)
         */
        Builder patchOperations(Consumer<PatchOperation.Builder>... patchOperations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String modelName;

        private List<PatchOperation> patchOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateModelRequest model) {
            super(model);
            restApiId(model.restApiId);
            modelName(model.modelName);
            patchOperations(model.patchOperations);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getModelName() {
            return modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final Collection<PatchOperation.Builder> getPatchOperations() {
            if (patchOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return patchOperations != null ? patchOperations.stream().map(PatchOperation::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder patchOperations(Collection<PatchOperation> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copy(patchOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(PatchOperation... patchOperations) {
            patchOperations(Arrays.asList(patchOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(Consumer<PatchOperation.Builder>... patchOperations) {
            patchOperations(Stream.of(patchOperations).map(c -> PatchOperation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPatchOperations(Collection<PatchOperation.BuilderImpl> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copyFromBuilder(patchOperations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateModelRequest build() {
            return new UpdateModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
