/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration property of an SDK type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SdkConfigurationProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<SdkConfigurationProperty.Builder, SdkConfigurationProperty> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SdkConfigurationProperty::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> FRIENDLY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("friendlyName").getter(getter(SdkConfigurationProperty::friendlyName))
            .setter(setter(Builder::friendlyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("friendlyName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SdkConfigurationProperty::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("required").getter(getter(SdkConfigurationProperty::required)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultValue").getter(getter(SdkConfigurationProperty::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            FRIENDLY_NAME_FIELD, DESCRIPTION_FIELD, REQUIRED_FIELD, DEFAULT_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String friendlyName;

    private final String description;

    private final Boolean required;

    private final String defaultValue;

    private SdkConfigurationProperty(BuilderImpl builder) {
        this.name = builder.name;
        this.friendlyName = builder.friendlyName;
        this.description = builder.description;
        this.required = builder.required;
        this.defaultValue = builder.defaultValue;
    }

    /**
     * <p>
     * The name of a an <a>SdkType</a> configuration property.
     * </p>
     * 
     * @return The name of a an <a>SdkType</a> configuration property.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The user-friendly name of an <a>SdkType</a> configuration property.
     * </p>
     * 
     * @return The user-friendly name of an <a>SdkType</a> configuration property.
     */
    public final String friendlyName() {
        return friendlyName;
    }

    /**
     * <p>
     * The description of an <a>SdkType</a> configuration property.
     * </p>
     * 
     * @return The description of an <a>SdkType</a> configuration property.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A boolean flag of an <a>SdkType</a> configuration property to indicate if the associated SDK configuration
     * property is required (<code>true</code>) or not (<code>false</code>).
     * </p>
     * 
     * @return A boolean flag of an <a>SdkType</a> configuration property to indicate if the associated SDK
     *         configuration property is required (<code>true</code>) or not (<code>false</code>).
     */
    public final Boolean required() {
        return required;
    }

    /**
     * <p>
     * The default value of an <a>SdkType</a> configuration property.
     * </p>
     * 
     * @return The default value of an <a>SdkType</a> configuration property.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(friendlyName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(required());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SdkConfigurationProperty)) {
            return false;
        }
        SdkConfigurationProperty other = (SdkConfigurationProperty) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(friendlyName(), other.friendlyName())
                && Objects.equals(description(), other.description()) && Objects.equals(required(), other.required())
                && Objects.equals(defaultValue(), other.defaultValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SdkConfigurationProperty").add("Name", name()).add("FriendlyName", friendlyName())
                .add("Description", description()).add("Required", required()).add("DefaultValue", defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "friendlyName":
            return Optional.ofNullable(clazz.cast(friendlyName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "required":
            return Optional.ofNullable(clazz.cast(required()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SdkConfigurationProperty, T> g) {
        return obj -> g.apply((SdkConfigurationProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SdkConfigurationProperty> {
        /**
         * <p>
         * The name of a an <a>SdkType</a> configuration property.
         * </p>
         * 
         * @param name
         *        The name of a an <a>SdkType</a> configuration property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The user-friendly name of an <a>SdkType</a> configuration property.
         * </p>
         * 
         * @param friendlyName
         *        The user-friendly name of an <a>SdkType</a> configuration property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder friendlyName(String friendlyName);

        /**
         * <p>
         * The description of an <a>SdkType</a> configuration property.
         * </p>
         * 
         * @param description
         *        The description of an <a>SdkType</a> configuration property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A boolean flag of an <a>SdkType</a> configuration property to indicate if the associated SDK configuration
         * property is required (<code>true</code>) or not (<code>false</code>).
         * </p>
         * 
         * @param required
         *        A boolean flag of an <a>SdkType</a> configuration property to indicate if the associated SDK
         *        configuration property is required (<code>true</code>) or not (<code>false</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Boolean required);

        /**
         * <p>
         * The default value of an <a>SdkType</a> configuration property.
         * </p>
         * 
         * @param defaultValue
         *        The default value of an <a>SdkType</a> configuration property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String friendlyName;

        private String description;

        private Boolean required;

        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SdkConfigurationProperty model) {
            name(model.name);
            friendlyName(model.friendlyName);
            description(model.description);
            required(model.required);
            defaultValue(model.defaultValue);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFriendlyName() {
            return friendlyName;
        }

        @Override
        public final Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        public final void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getRequired() {
            return required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public SdkConfigurationProperty build() {
            return new SdkConfigurationProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
