/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Op {
    ADD("add"),
    REMOVE("remove"),
    REPLACE("replace"),
    MOVE("move"),
    COPY("copy"),
    TEST("test"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Op(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Op fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Op.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Op> knownValues() {
        return Stream.of(Op.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

