/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ConnectionType;
import software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy;
import software.amazon.awssdk.services.apigateway.model.IntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.IntegrationType;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfIntegrationResponseCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.apigateway.model.TlsConfig;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutIntegrationResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, PutIntegrationResponse> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(PutIntegrationResponse.getter(PutIntegrationResponse::typeAsString)).setter(PutIntegrationResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpMethod").getter(PutIntegrationResponse.getter(PutIntegrationResponse::httpMethod)).setter(PutIntegrationResponse.setter(Builder::httpMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpMethod").build()}).build();
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uri").getter(PutIntegrationResponse.getter(PutIntegrationResponse::uri)).setter(PutIntegrationResponse.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionType").getter(PutIntegrationResponse.getter(PutIntegrationResponse::connectionTypeAsString)).setter(PutIntegrationResponse.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionType").build()}).build();
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(PutIntegrationResponse.getter(PutIntegrationResponse::connectionId)).setter(PutIntegrationResponse.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentials").getter(PutIntegrationResponse.getter(PutIntegrationResponse::credentials)).setter(PutIntegrationResponse.setter(Builder::credentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requestParameters").getter(PutIntegrationResponse.getter(PutIntegrationResponse::requestParameters)).setter(PutIntegrationResponse.setter(Builder::requestParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requestTemplates").getter(PutIntegrationResponse.getter(PutIntegrationResponse::requestTemplates)).setter(PutIntegrationResponse.setter(Builder::requestTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestTemplates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PASSTHROUGH_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("passthroughBehavior").getter(PutIntegrationResponse.getter(PutIntegrationResponse::passthroughBehavior)).setter(PutIntegrationResponse.setter(Builder::passthroughBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passthroughBehavior").build()}).build();
    private static final SdkField<String> CONTENT_HANDLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentHandling").getter(PutIntegrationResponse.getter(PutIntegrationResponse::contentHandlingAsString)).setter(PutIntegrationResponse.setter(Builder::contentHandling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentHandling").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutInMillis").getter(PutIntegrationResponse.getter(PutIntegrationResponse::timeoutInMillis)).setter(PutIntegrationResponse.setter(Builder::timeoutInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMillis").build()}).build();
    private static final SdkField<String> CACHE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheNamespace").getter(PutIntegrationResponse.getter(PutIntegrationResponse::cacheNamespace)).setter(PutIntegrationResponse.setter(Builder::cacheNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheNamespace").build()}).build();
    private static final SdkField<List<String>> CACHE_KEY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cacheKeyParameters").getter(PutIntegrationResponse.getter(PutIntegrationResponse::cacheKeyParameters)).setter(PutIntegrationResponse.setter(Builder::cacheKeyParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheKeyParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, IntegrationResponse>> INTEGRATION_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("integrationResponses").getter(PutIntegrationResponse.getter(PutIntegrationResponse::integrationResponses)).setter(PutIntegrationResponse.setter(Builder::integrationResponses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationResponses").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IntegrationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TlsConfig> TLS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tlsConfig").getter(PutIntegrationResponse.getter(PutIntegrationResponse::tlsConfig)).setter(PutIntegrationResponse.setter(Builder::tlsConfig)).constructor(TlsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, HTTP_METHOD_FIELD, URI_FIELD, CONNECTION_TYPE_FIELD, CONNECTION_ID_FIELD, CREDENTIALS_FIELD, REQUEST_PARAMETERS_FIELD, REQUEST_TEMPLATES_FIELD, PASSTHROUGH_BEHAVIOR_FIELD, CONTENT_HANDLING_FIELD, TIMEOUT_IN_MILLIS_FIELD, CACHE_NAMESPACE_FIELD, CACHE_KEY_PARAMETERS_FIELD, INTEGRATION_RESPONSES_FIELD, TLS_CONFIG_FIELD));
    private final String type;
    private final String httpMethod;
    private final String uri;
    private final String connectionType;
    private final String connectionId;
    private final String credentials;
    private final Map<String, String> requestParameters;
    private final Map<String, String> requestTemplates;
    private final String passthroughBehavior;
    private final String contentHandling;
    private final Integer timeoutInMillis;
    private final String cacheNamespace;
    private final List<String> cacheKeyParameters;
    private final Map<String, IntegrationResponse> integrationResponses;
    private final TlsConfig tlsConfig;

    private PutIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.httpMethod = builder.httpMethod;
        this.uri = builder.uri;
        this.connectionType = builder.connectionType;
        this.connectionId = builder.connectionId;
        this.credentials = builder.credentials;
        this.requestParameters = builder.requestParameters;
        this.requestTemplates = builder.requestTemplates;
        this.passthroughBehavior = builder.passthroughBehavior;
        this.contentHandling = builder.contentHandling;
        this.timeoutInMillis = builder.timeoutInMillis;
        this.cacheNamespace = builder.cacheNamespace;
        this.cacheKeyParameters = builder.cacheKeyParameters;
        this.integrationResponses = builder.integrationResponses;
        this.tlsConfig = builder.tlsConfig;
    }

    public final IntegrationType type() {
        return IntegrationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String httpMethod() {
        return this.httpMethod;
    }

    public final String uri() {
        return this.uri;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final String credentials() {
        return this.credentials;
    }

    public final boolean hasRequestParameters() {
        return this.requestParameters != null && !(this.requestParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestParameters() {
        return this.requestParameters;
    }

    public final boolean hasRequestTemplates() {
        return this.requestTemplates != null && !(this.requestTemplates instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestTemplates() {
        return this.requestTemplates;
    }

    public final String passthroughBehavior() {
        return this.passthroughBehavior;
    }

    public final ContentHandlingStrategy contentHandling() {
        return ContentHandlingStrategy.fromValue(this.contentHandling);
    }

    public final String contentHandlingAsString() {
        return this.contentHandling;
    }

    public final Integer timeoutInMillis() {
        return this.timeoutInMillis;
    }

    public final String cacheNamespace() {
        return this.cacheNamespace;
    }

    public final boolean hasCacheKeyParameters() {
        return this.cacheKeyParameters != null && !(this.cacheKeyParameters instanceof SdkAutoConstructList);
    }

    public final List<String> cacheKeyParameters() {
        return this.cacheKeyParameters;
    }

    public final boolean hasIntegrationResponses() {
        return this.integrationResponses != null && !(this.integrationResponses instanceof SdkAutoConstructMap);
    }

    public final Map<String, IntegrationResponse> integrationResponses() {
        return this.integrationResponses;
    }

    public final TlsConfig tlsConfig() {
        return this.tlsConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestParameters() ? this.requestParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestTemplates() ? this.requestTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.passthroughBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentHandlingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheKeyParameters() ? this.cacheKeyParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegrationResponses() ? this.integrationResponses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntegrationResponse)) {
            return false;
        }
        PutIntegrationResponse other = (PutIntegrationResponse)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.uri(), other.uri()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.credentials(), other.credentials()) && this.hasRequestParameters() == other.hasRequestParameters() && Objects.equals(this.requestParameters(), other.requestParameters()) && this.hasRequestTemplates() == other.hasRequestTemplates() && Objects.equals(this.requestTemplates(), other.requestTemplates()) && Objects.equals(this.passthroughBehavior(), other.passthroughBehavior()) && Objects.equals(this.contentHandlingAsString(), other.contentHandlingAsString()) && Objects.equals(this.timeoutInMillis(), other.timeoutInMillis()) && Objects.equals(this.cacheNamespace(), other.cacheNamespace()) && this.hasCacheKeyParameters() == other.hasCacheKeyParameters() && Objects.equals(this.cacheKeyParameters(), other.cacheKeyParameters()) && this.hasIntegrationResponses() == other.hasIntegrationResponses() && Objects.equals(this.integrationResponses(), other.integrationResponses()) && Objects.equals(this.tlsConfig(), other.tlsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"PutIntegrationResponse").add("Type", (Object)this.typeAsString()).add("HttpMethod", (Object)this.httpMethod()).add("Uri", (Object)this.uri()).add("ConnectionType", (Object)this.connectionTypeAsString()).add("ConnectionId", (Object)this.connectionId()).add("Credentials", (Object)this.credentials()).add("RequestParameters", this.hasRequestParameters() ? this.requestParameters() : null).add("RequestTemplates", this.hasRequestTemplates() ? this.requestTemplates() : null).add("PassthroughBehavior", (Object)this.passthroughBehavior()).add("ContentHandling", (Object)this.contentHandlingAsString()).add("TimeoutInMillis", (Object)this.timeoutInMillis()).add("CacheNamespace", (Object)this.cacheNamespace()).add("CacheKeyParameters", this.hasCacheKeyParameters() ? this.cacheKeyParameters() : null).add("IntegrationResponses", this.hasIntegrationResponses() ? this.integrationResponses() : null).add("TlsConfig", (Object)this.tlsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "httpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "connectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "requestParameters": {
                return Optional.ofNullable(clazz.cast(this.requestParameters()));
            }
            case "requestTemplates": {
                return Optional.ofNullable(clazz.cast(this.requestTemplates()));
            }
            case "passthroughBehavior": {
                return Optional.ofNullable(clazz.cast(this.passthroughBehavior()));
            }
            case "contentHandling": {
                return Optional.ofNullable(clazz.cast(this.contentHandlingAsString()));
            }
            case "timeoutInMillis": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMillis()));
            }
            case "cacheNamespace": {
                return Optional.ofNullable(clazz.cast(this.cacheNamespace()));
            }
            case "cacheKeyParameters": {
                return Optional.ofNullable(clazz.cast(this.cacheKeyParameters()));
            }
            case "integrationResponses": {
                return Optional.ofNullable(clazz.cast(this.integrationResponses()));
            }
            case "tlsConfig": {
                return Optional.ofNullable(clazz.cast(this.tlsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutIntegrationResponse, T> g) {
        return obj -> g.apply((PutIntegrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String type;
        private String httpMethod;
        private String uri;
        private String connectionType;
        private String connectionId;
        private String credentials;
        private Map<String, String> requestParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> requestTemplates = DefaultSdkAutoConstructMap.getInstance();
        private String passthroughBehavior;
        private String contentHandling;
        private Integer timeoutInMillis;
        private String cacheNamespace;
        private List<String> cacheKeyParameters = DefaultSdkAutoConstructList.getInstance();
        private Map<String, IntegrationResponse> integrationResponses = DefaultSdkAutoConstructMap.getInstance();
        private TlsConfig tlsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntegrationResponse model) {
            super(model);
            this.type(model.type);
            this.httpMethod(model.httpMethod);
            this.uri(model.uri);
            this.connectionType(model.connectionType);
            this.connectionId(model.connectionId);
            this.credentials(model.credentials);
            this.requestParameters(model.requestParameters);
            this.requestTemplates(model.requestTemplates);
            this.passthroughBehavior(model.passthroughBehavior);
            this.contentHandling(model.contentHandling);
            this.timeoutInMillis(model.timeoutInMillis);
            this.cacheNamespace(model.cacheNamespace);
            this.cacheKeyParameters(model.cacheKeyParameters);
            this.integrationResponses(model.integrationResponses);
            this.tlsConfig(model.tlsConfig);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IntegrationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getUri() {
            return this.uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getCredentials() {
            return this.credentials;
        }

        @Override
        public final Builder credentials(String credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(String credentials) {
            this.credentials = credentials;
        }

        public final Map<String, String> getRequestParameters() {
            if (this.requestParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestParameters;
        }

        @Override
        public final Builder requestParameters(Map<String, String> requestParameters) {
            this.requestParameters = MapOfStringToStringCopier.copy(requestParameters);
            return this;
        }

        public final void setRequestParameters(Map<String, String> requestParameters) {
            this.requestParameters = MapOfStringToStringCopier.copy(requestParameters);
        }

        public final Map<String, String> getRequestTemplates() {
            if (this.requestTemplates instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestTemplates;
        }

        @Override
        public final Builder requestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = MapOfStringToStringCopier.copy(requestTemplates);
            return this;
        }

        public final void setRequestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = MapOfStringToStringCopier.copy(requestTemplates);
        }

        public final String getPassthroughBehavior() {
            return this.passthroughBehavior;
        }

        @Override
        public final Builder passthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        public final void setPassthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
        }

        public final String getContentHandling() {
            return this.contentHandling;
        }

        @Override
        public final Builder contentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        @Override
        public final Builder contentHandling(ContentHandlingStrategy contentHandling) {
            this.contentHandling(contentHandling == null ? null : contentHandling.toString());
            return this;
        }

        public final void setContentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
        }

        public final Integer getTimeoutInMillis() {
            return this.timeoutInMillis;
        }

        @Override
        public final Builder timeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        public final void setTimeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
        }

        public final String getCacheNamespace() {
            return this.cacheNamespace;
        }

        @Override
        public final Builder cacheNamespace(String cacheNamespace) {
            this.cacheNamespace = cacheNamespace;
            return this;
        }

        public final void setCacheNamespace(String cacheNamespace) {
            this.cacheNamespace = cacheNamespace;
        }

        public final Collection<String> getCacheKeyParameters() {
            if (this.cacheKeyParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cacheKeyParameters;
        }

        @Override
        public final Builder cacheKeyParameters(Collection<String> cacheKeyParameters) {
            this.cacheKeyParameters = ListOfStringCopier.copy(cacheKeyParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheKeyParameters(String ... cacheKeyParameters) {
            this.cacheKeyParameters(Arrays.asList(cacheKeyParameters));
            return this;
        }

        public final void setCacheKeyParameters(Collection<String> cacheKeyParameters) {
            this.cacheKeyParameters = ListOfStringCopier.copy(cacheKeyParameters);
        }

        public final Map<String, IntegrationResponse.Builder> getIntegrationResponses() {
            if (this.integrationResponses instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.integrationResponses != null ? CollectionUtils.mapValues(this.integrationResponses, IntegrationResponse::toBuilder) : null;
        }

        @Override
        public final Builder integrationResponses(Map<String, IntegrationResponse> integrationResponses) {
            this.integrationResponses = MapOfIntegrationResponseCopier.copy(integrationResponses);
            return this;
        }

        public final void setIntegrationResponses(Map<String, IntegrationResponse.BuilderImpl> integrationResponses) {
            this.integrationResponses = MapOfIntegrationResponseCopier.copyFromBuilder(integrationResponses);
        }

        public final TlsConfig.Builder getTlsConfig() {
            return this.tlsConfig != null ? this.tlsConfig.toBuilder() : null;
        }

        @Override
        public final Builder tlsConfig(TlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public final void setTlsConfig(TlsConfig.BuilderImpl tlsConfig) {
            this.tlsConfig = tlsConfig != null ? tlsConfig.build() : null;
        }

        @Override
        public PutIntegrationResponse build() {
            return new PutIntegrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutIntegrationResponse> {
        public Builder type(String var1);

        public Builder type(IntegrationType var1);

        public Builder httpMethod(String var1);

        public Builder uri(String var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder connectionId(String var1);

        public Builder credentials(String var1);

        public Builder requestParameters(Map<String, String> var1);

        public Builder requestTemplates(Map<String, String> var1);

        public Builder passthroughBehavior(String var1);

        public Builder contentHandling(String var1);

        public Builder contentHandling(ContentHandlingStrategy var1);

        public Builder timeoutInMillis(Integer var1);

        public Builder cacheNamespace(String var1);

        public Builder cacheKeyParameters(Collection<String> var1);

        public Builder cacheKeyParameters(String ... var1);

        public Builder integrationResponses(Map<String, IntegrationResponse> var1);

        public Builder tlsConfig(TlsConfig var1);

        default public Builder tlsConfig(Consumer<TlsConfig.Builder> tlsConfig) {
            return this.tlsConfig((TlsConfig)((TlsConfig.Builder)TlsConfig.builder().applyMutation(tlsConfig)).build());
        }
    }
}

