/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a usage plan than can specify who can assess associated API stages with specified request limits and
 * quotas.
 * </p>
 * <div class="remarks">
 * <p>
 * In a usage plan, you associate an API by specifying the API's Id and a stage name of the specified API. You add plan
 * customers by adding API keys to the plan.
 * </p>
 * </div> <div class="seeAlso"> <a
 * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use
 * Usage Plans</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUsagePlanResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<CreateUsagePlanResponse.Builder, CreateUsagePlanResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateUsagePlanResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateUsagePlanResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateUsagePlanResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<ApiStage>> API_STAGES_FIELD = SdkField
            .<List<ApiStage>> builder(MarshallingType.LIST)
            .memberName("apiStages")
            .getter(getter(CreateUsagePlanResponse::apiStages))
            .setter(setter(Builder::apiStages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiStages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApiStage> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApiStage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ThrottleSettings> THROTTLE_FIELD = SdkField
            .<ThrottleSettings> builder(MarshallingType.SDK_POJO).memberName("throttle")
            .getter(getter(CreateUsagePlanResponse::throttle)).setter(setter(Builder::throttle))
            .constructor(ThrottleSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throttle").build()).build();

    private static final SdkField<QuotaSettings> QUOTA_FIELD = SdkField.<QuotaSettings> builder(MarshallingType.SDK_POJO)
            .memberName("quota").getter(getter(CreateUsagePlanResponse::quota)).setter(setter(Builder::quota))
            .constructor(QuotaSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quota").build()).build();

    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productCode").getter(getter(CreateUsagePlanResponse::productCode)).setter(setter(Builder::productCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productCode").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateUsagePlanResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, API_STAGES_FIELD, THROTTLE_FIELD, QUOTA_FIELD, PRODUCT_CODE_FIELD, TAGS_FIELD));

    private final String id;

    private final String name;

    private final String description;

    private final List<ApiStage> apiStages;

    private final ThrottleSettings throttle;

    private final QuotaSettings quota;

    private final String productCode;

    private final Map<String, String> tags;

    private CreateUsagePlanResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.apiStages = builder.apiStages;
        this.throttle = builder.throttle;
        this.quota = builder.quota;
        this.productCode = builder.productCode;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of a <a>UsagePlan</a> resource.
     * </p>
     * 
     * @return The identifier of a <a>UsagePlan</a> resource.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of a usage plan.
     * </p>
     * 
     * @return The name of a usage plan.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of a usage plan.
     * </p>
     * 
     * @return The description of a usage plan.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the ApiStages property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasApiStages() {
        return apiStages != null && !(apiStages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The associated API stages of a usage plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApiStages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The associated API stages of a usage plan.
     */
    public final List<ApiStage> apiStages() {
        return apiStages;
    }

    /**
     * <p>
     * The request throttle limits of a usage plan.
     * </p>
     * 
     * @return The request throttle limits of a usage plan.
     */
    public final ThrottleSettings throttle() {
        return throttle;
    }

    /**
     * <p>
     * The maximum number of permitted requests per a given unit time interval.
     * </p>
     * 
     * @return The maximum number of permitted requests per a given unit time interval.
     */
    public final QuotaSettings quota() {
        return quota;
    }

    /**
     * <p>
     * The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.
     * </p>
     * 
     * @return The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS
     *         Marketplace.
     */
    public final String productCode() {
        return productCode;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The collection of tags. Each tag element is associated with a given resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The collection of tags. Each tag element is associated with a given resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasApiStages() ? apiStages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(throttle());
        hashCode = 31 * hashCode + Objects.hashCode(quota());
        hashCode = 31 * hashCode + Objects.hashCode(productCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUsagePlanResponse)) {
            return false;
        }
        CreateUsagePlanResponse other = (CreateUsagePlanResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasApiStages() == other.hasApiStages()
                && Objects.equals(apiStages(), other.apiStages()) && Objects.equals(throttle(), other.throttle())
                && Objects.equals(quota(), other.quota()) && Objects.equals(productCode(), other.productCode())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUsagePlanResponse").add("Id", id()).add("Name", name()).add("Description", description())
                .add("ApiStages", hasApiStages() ? apiStages() : null).add("Throttle", throttle()).add("Quota", quota())
                .add("ProductCode", productCode()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "apiStages":
            return Optional.ofNullable(clazz.cast(apiStages()));
        case "throttle":
            return Optional.ofNullable(clazz.cast(throttle()));
        case "quota":
            return Optional.ofNullable(clazz.cast(quota()));
        case "productCode":
            return Optional.ofNullable(clazz.cast(productCode()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUsagePlanResponse, T> g) {
        return obj -> g.apply((CreateUsagePlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateUsagePlanResponse> {
        /**
         * <p>
         * The identifier of a <a>UsagePlan</a> resource.
         * </p>
         * 
         * @param id
         *        The identifier of a <a>UsagePlan</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of a usage plan.
         * </p>
         * 
         * @param name
         *        The name of a usage plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of a usage plan.
         * </p>
         * 
         * @param description
         *        The description of a usage plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The associated API stages of a usage plan.
         * </p>
         * 
         * @param apiStages
         *        The associated API stages of a usage plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiStages(Collection<ApiStage> apiStages);

        /**
         * <p>
         * The associated API stages of a usage plan.
         * </p>
         * 
         * @param apiStages
         *        The associated API stages of a usage plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiStages(ApiStage... apiStages);

        /**
         * <p>
         * The associated API stages of a usage plan.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ApiStage>.Builder} avoiding the need to
         * create one manually via {@link List<ApiStage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApiStage>.Builder#build()} is called immediately and its
         * result is passed to {@link #apiStages(List<ApiStage>)}.
         * 
         * @param apiStages
         *        a consumer that will call methods on {@link List<ApiStage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiStages(List<ApiStage>)
         */
        Builder apiStages(Consumer<ApiStage.Builder>... apiStages);

        /**
         * <p>
         * The request throttle limits of a usage plan.
         * </p>
         * 
         * @param throttle
         *        The request throttle limits of a usage plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throttle(ThrottleSettings throttle);

        /**
         * <p>
         * The request throttle limits of a usage plan.
         * </p>
         * This is a convenience that creates an instance of the {@link ThrottleSettings.Builder} avoiding the need to
         * create one manually via {@link ThrottleSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThrottleSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #throttle(ThrottleSettings)}.
         * 
         * @param throttle
         *        a consumer that will call methods on {@link ThrottleSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #throttle(ThrottleSettings)
         */
        default Builder throttle(Consumer<ThrottleSettings.Builder> throttle) {
            return throttle(ThrottleSettings.builder().applyMutation(throttle).build());
        }

        /**
         * <p>
         * The maximum number of permitted requests per a given unit time interval.
         * </p>
         * 
         * @param quota
         *        The maximum number of permitted requests per a given unit time interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quota(QuotaSettings quota);

        /**
         * <p>
         * The maximum number of permitted requests per a given unit time interval.
         * </p>
         * This is a convenience that creates an instance of the {@link QuotaSettings.Builder} avoiding the need to
         * create one manually via {@link QuotaSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link QuotaSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #quota(QuotaSettings)}.
         * 
         * @param quota
         *        a consumer that will call methods on {@link QuotaSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quota(QuotaSettings)
         */
        default Builder quota(Consumer<QuotaSettings.Builder> quota) {
            return quota(QuotaSettings.builder().applyMutation(quota).build());
        }

        /**
         * <p>
         * The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.
         * </p>
         * 
         * @param productCode
         *        The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS
         *        Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCode(String productCode);

        /**
         * <p>
         * The collection of tags. Each tag element is associated with a given resource.
         * </p>
         * 
         * @param tags
         *        The collection of tags. Each tag element is associated with a given resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private List<ApiStage> apiStages = DefaultSdkAutoConstructList.getInstance();

        private ThrottleSettings throttle;

        private QuotaSettings quota;

        private String productCode;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUsagePlanResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            description(model.description);
            apiStages(model.apiStages);
            throttle(model.throttle);
            quota(model.quota);
            productCode(model.productCode);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<ApiStage.Builder> getApiStages() {
            List<ApiStage.Builder> result = ListOfApiStageCopier.copyToBuilder(this.apiStages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder apiStages(Collection<ApiStage> apiStages) {
            this.apiStages = ListOfApiStageCopier.copy(apiStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiStages(ApiStage... apiStages) {
            apiStages(Arrays.asList(apiStages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiStages(Consumer<ApiStage.Builder>... apiStages) {
            apiStages(Stream.of(apiStages).map(c -> ApiStage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApiStages(Collection<ApiStage.BuilderImpl> apiStages) {
            this.apiStages = ListOfApiStageCopier.copyFromBuilder(apiStages);
        }

        public final ThrottleSettings.Builder getThrottle() {
            return throttle != null ? throttle.toBuilder() : null;
        }

        @Override
        public final Builder throttle(ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        public final void setThrottle(ThrottleSettings.BuilderImpl throttle) {
            this.throttle = throttle != null ? throttle.build() : null;
        }

        public final QuotaSettings.Builder getQuota() {
            return quota != null ? quota.toBuilder() : null;
        }

        @Override
        public final Builder quota(QuotaSettings quota) {
            this.quota = quota;
            return this;
        }

        public final void setQuota(QuotaSettings.BuilderImpl quota) {
            this.quota = quota != null ? quota.build() : null;
        }

        public final String getProductCode() {
            return productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public CreateUsagePlanResponse build() {
            return new CreateUsagePlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
