/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the target API entity to which the documentation applies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentationPartLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentationPartLocation.Builder, DocumentationPartLocation> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DocumentationPartLocation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("path")
            .getter(getter(DocumentationPartLocation::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<String> METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("method")
            .getter(getter(DocumentationPartLocation::method)).setter(setter(Builder::method))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(DocumentationPartLocation::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DocumentationPartLocation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PATH_FIELD,
            METHOD_FIELD, STATUS_CODE_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String path;

    private final String method;

    private final String statusCodeValue;

    private final String name;

    private DocumentationPartLocation(BuilderImpl builder) {
        this.type = builder.type;
        this.path = builder.path;
        this.method = builder.method;
        this.statusCodeValue = builder.statusCodeValue;
        this.name = builder.name;
    }

    /**
     * <p>
     * [Required] The type of API entity to which the documentation content applies. Valid values are <code>API</code>,
     * <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>,
     * <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Content inheritance does
     * not apply to any entity of the <code>API</code>, <code>AUTHORIZER</code>, <code>METHOD</code>, <code>MODEL</code>, <code>REQUEST_BODY</code>, or <code>RESOURCE</code> type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DocumentationPartType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return [Required] The type of API entity to which the documentation content applies. Valid values are
     *         <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>
     *         , <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,
     *         <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and
     *         <code>RESPONSE_BODY</code>. Content inheritance does not apply to any entity of the <code>API</code>,
     *         <code>AUTHORIZER</code>, <code>METHOD</code>, <code>MODEL</code>, <code>REQUEST_BODY</code>, or
     *         <code>RESOURCE</code> type.
     * @see DocumentationPartType
     */
    public final DocumentationPartType type() {
        return DocumentationPartType.fromValue(type);
    }

    /**
     * <p>
     * [Required] The type of API entity to which the documentation content applies. Valid values are <code>API</code>,
     * <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>,
     * <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Content inheritance does
     * not apply to any entity of the <code>API</code>, <code>AUTHORIZER</code>, <code>METHOD</code>, <code>MODEL</code>, <code>REQUEST_BODY</code>, or <code>RESOURCE</code> type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DocumentationPartType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return [Required] The type of API entity to which the documentation content applies. Valid values are
     *         <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>
     *         , <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,
     *         <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and
     *         <code>RESPONSE_BODY</code>. Content inheritance does not apply to any entity of the <code>API</code>,
     *         <code>AUTHORIZER</code>, <code>METHOD</code>, <code>MODEL</code>, <code>REQUEST_BODY</code>, or
     *         <code>RESOURCE</code> type.
     * @see DocumentationPartType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The URL path of the target. It is a valid field for the API entity types of <code>RESOURCE</code>,
     * <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,
     * <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>.
     * The default value is <code>/</code> for the root resource. When an applicable child entity inherits the content
     * of another entity of the same type with more general specifications of the other <code>location</code>
     * attributes, the child entity's <code>path</code> attribute must match that of the parent entity as a prefix.
     * </p>
     * 
     * @return The URL path of the target. It is a valid field for the API entity types of <code>RESOURCE</code>,
     *         <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>,
     *         <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>,
     *         <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>/</code> for the
     *         root resource. When an applicable child entity inherits the content of another entity of the same type
     *         with more general specifications of the other <code>location</code> attributes, the child entity's
     *         <code>path</code> attribute must match that of the parent entity as a prefix.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The HTTP verb of a method. It is a valid field for the API entity types of <code>METHOD</code>,
     * <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is
     * <code>*</code> for any method. When an applicable child entity inherits the content of an entity of the same type
     * with more general specifications of the other <code>location</code> attributes, the child entity's
     * <code>method</code> attribute must match that of the parent entity exactly.
     * </p>
     * 
     * @return The HTTP verb of a method. It is a valid field for the API entity types of <code>METHOD</code>,
     *         <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,
     *         <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and
     *         <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any method. When an applicable child
     *         entity inherits the content of an entity of the same type with more general specifications of the other
     *         <code>location</code> attributes, the child entity's <code>method</code> attribute must match that of the
     *         parent entity exactly.
     */
    public final String method() {
        return method;
    }

    /**
     * <p>
     * The HTTP status code of a response. It is a valid field for the API entity types of <code>RESPONSE</code>,
     * <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any status
     * code. When an applicable child entity inherits the content of an entity of the same type with more general
     * specifications of the other <code>location</code> attributes, the child entity's <code>statusCode</code>
     * attribute must match that of the parent entity exactly.
     * </p>
     * 
     * @return The HTTP status code of a response. It is a valid field for the API entity types of <code>RESPONSE</code>
     *         , <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for
     *         any status code. When an applicable child entity inherits the content of an entity of the same type with
     *         more general specifications of the other <code>location</code> attributes, the child entity's
     *         <code>statusCode</code> attribute must match that of the parent entity exactly.
     */
    public final String statusCode() {
        return statusCodeValue;
    }

    /**
     * <p>
     * The name of the targeted API entity. It is a valid and required field for the API entity types of
     * <code>AUTHORIZER</code>, <code>MODEL</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>,
     * <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code>. It is an invalid field
     * for any other entity type.
     * </p>
     * 
     * @return The name of the targeted API entity. It is a valid and required field for the API entity types of
     *         <code>AUTHORIZER</code>, <code>MODEL</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>,
     *         <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code>. It is an invalid
     *         field for any other entity type.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(method());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentationPartLocation)) {
            return false;
        }
        DocumentationPartLocation other = (DocumentationPartLocation) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(path(), other.path())
                && Objects.equals(method(), other.method()) && Objects.equals(statusCode(), other.statusCode())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentationPartLocation").add("Type", typeAsString()).add("Path", path())
                .add("Method", method()).add("StatusCode", statusCode()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "method":
            return Optional.ofNullable(clazz.cast(method()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentationPartLocation, T> g) {
        return obj -> g.apply((DocumentationPartLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentationPartLocation> {
        /**
         * <p>
         * [Required] The type of API entity to which the documentation content applies. Valid values are
         * <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>,
         * <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,
         * <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and
         * <code>RESPONSE_BODY</code>. Content inheritance does not apply to any entity of the <code>API</code>,
         * <code>AUTHORIZER</code>, <code>METHOD</code>, <code>MODEL</code>, <code>REQUEST_BODY</code>, or
         * <code>RESOURCE</code> type.
         * </p>
         * 
         * @param type
         *        [Required] The type of API entity to which the documentation content applies. Valid values are
         *        <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>,
         *        <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>,
         *        <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>,
         *        <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Content inheritance does not apply to
         *        any entity of the <code>API</code>, <code>AUTHORIZER</code>, <code>METHOD</code>, <code>MODEL</code>,
         *        <code>REQUEST_BODY</code>, or <code>RESOURCE</code> type.
         * @see DocumentationPartType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentationPartType
         */
        Builder type(String type);

        /**
         * <p>
         * [Required] The type of API entity to which the documentation content applies. Valid values are
         * <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>,
         * <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,
         * <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and
         * <code>RESPONSE_BODY</code>. Content inheritance does not apply to any entity of the <code>API</code>,
         * <code>AUTHORIZER</code>, <code>METHOD</code>, <code>MODEL</code>, <code>REQUEST_BODY</code>, or
         * <code>RESOURCE</code> type.
         * </p>
         * 
         * @param type
         *        [Required] The type of API entity to which the documentation content applies. Valid values are
         *        <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>,
         *        <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>,
         *        <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>,
         *        <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Content inheritance does not apply to
         *        any entity of the <code>API</code>, <code>AUTHORIZER</code>, <code>METHOD</code>, <code>MODEL</code>,
         *        <code>REQUEST_BODY</code>, or <code>RESOURCE</code> type.
         * @see DocumentationPartType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentationPartType
         */
        Builder type(DocumentationPartType type);

        /**
         * <p>
         * The URL path of the target. It is a valid field for the API entity types of <code>RESOURCE</code>,
         * <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,
         * <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and
         * <code>RESPONSE_BODY</code>. The default value is <code>/</code> for the root resource. When an applicable
         * child entity inherits the content of another entity of the same type with more general specifications of the
         * other <code>location</code> attributes, the child entity's <code>path</code> attribute must match that of the
         * parent entity as a prefix.
         * </p>
         * 
         * @param path
         *        The URL path of the target. It is a valid field for the API entity types of <code>RESOURCE</code>,
         *        <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>,
         *        <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>,
         *        <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>/</code> for
         *        the root resource. When an applicable child entity inherits the content of another entity of the same
         *        type with more general specifications of the other <code>location</code> attributes, the child
         *        entity's <code>path</code> attribute must match that of the parent entity as a prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The HTTP verb of a method. It is a valid field for the API entity types of <code>METHOD</code>,
         * <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,
         * <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and
         * <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any method. When an applicable child
         * entity inherits the content of an entity of the same type with more general specifications of the other
         * <code>location</code> attributes, the child entity's <code>method</code> attribute must match that of the
         * parent entity exactly.
         * </p>
         * 
         * @param method
         *        The HTTP verb of a method. It is a valid field for the API entity types of <code>METHOD</code>,
         *        <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>,
         *        <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and
         *        <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any method. When an applicable
         *        child entity inherits the content of an entity of the same type with more general specifications of
         *        the other <code>location</code> attributes, the child entity's <code>method</code> attribute must
         *        match that of the parent entity exactly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder method(String method);

        /**
         * <p>
         * The HTTP status code of a response. It is a valid field for the API entity types of <code>RESPONSE</code>,
         * <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any
         * status code. When an applicable child entity inherits the content of an entity of the same type with more
         * general specifications of the other <code>location</code> attributes, the child entity's
         * <code>statusCode</code> attribute must match that of the parent entity exactly.
         * </p>
         * 
         * @param statusCodeValue
         *        The HTTP status code of a response. It is a valid field for the API entity types of
         *        <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value
         *        is <code>*</code> for any status code. When an applicable child entity inherits the content of an
         *        entity of the same type with more general specifications of the other <code>location</code>
         *        attributes, the child entity's <code>statusCode</code> attribute must match that of the parent entity
         *        exactly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * The name of the targeted API entity. It is a valid and required field for the API entity types of
         * <code>AUTHORIZER</code>, <code>MODEL</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>,
         * <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code>. It is an invalid
         * field for any other entity type.
         * </p>
         * 
         * @param name
         *        The name of the targeted API entity. It is a valid and required field for the API entity types of
         *        <code>AUTHORIZER</code>, <code>MODEL</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>
         *        , <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code>. It is an
         *        invalid field for any other entity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String path;

        private String method;

        private String statusCodeValue;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentationPartLocation model) {
            type(model.type);
            path(model.path);
            method(model.method);
            statusCode(model.statusCodeValue);
            name(model.name);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DocumentationPartType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getMethod() {
            return method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public DocumentationPartLocation build() {
            return new DocumentationPartLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
