/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The endpoint configuration to indicate the types of endpoints an API (<a>RestApi</a>) or its custom domain name
 * (<a>DomainName</a>) has.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointConfiguration.Builder, EndpointConfiguration> {
    private static final SdkField<List<String>> TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("types")
            .getter(getter(EndpointConfiguration::typesAsStrings))
            .setter(setter(Builder::typesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_ENDPOINT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpcEndpointIds")
            .getter(getter(EndpointConfiguration::vpcEndpointIds))
            .setter(setter(Builder::vpcEndpointIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPES_FIELD,
            VPC_ENDPOINT_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> types;

    private final List<String> vpcEndpointIds;

    private EndpointConfiguration(BuilderImpl builder) {
        this.types = builder.types;
        this.vpcEndpointIds = builder.vpcEndpointIds;
    }

    /**
     * <p>
     * A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an
     * edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and
     * its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is
     * <code>PRIVATE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an
     *         edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional
     *         API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the
     *         endpoint type is <code>PRIVATE</code>.
     */
    public final List<EndpointType> types() {
        return ListOfEndpointTypeCopier.copyStringToEnum(types);
    }

    /**
     * Returns true if the Types property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an
     * edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and
     * its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is
     * <code>PRIVATE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an
     *         edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional
     *         API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the
     *         endpoint type is <code>PRIVATE</code>.
     */
    public final List<String> typesAsStrings() {
        return types;
    }

    /**
     * Returns true if the VpcEndpointIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasVpcEndpointIds() {
        return vpcEndpointIds != null && !(vpcEndpointIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported
     * for <code>PRIVATE</code> endpoint type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcEndpointIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only
     *         supported for <code>PRIVATE</code> endpoint type.
     */
    public final List<String> vpcEndpointIds() {
        return vpcEndpointIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTypes() ? typesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcEndpointIds() ? vpcEndpointIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointConfiguration)) {
            return false;
        }
        EndpointConfiguration other = (EndpointConfiguration) obj;
        return hasTypes() == other.hasTypes() && Objects.equals(typesAsStrings(), other.typesAsStrings())
                && hasVpcEndpointIds() == other.hasVpcEndpointIds() && Objects.equals(vpcEndpointIds(), other.vpcEndpointIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointConfiguration").add("Types", hasTypes() ? typesAsStrings() : null)
                .add("VpcEndpointIds", hasVpcEndpointIds() ? vpcEndpointIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "types":
            return Optional.ofNullable(clazz.cast(typesAsStrings()));
        case "vpcEndpointIds":
            return Optional.ofNullable(clazz.cast(vpcEndpointIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointConfiguration, T> g) {
        return obj -> g.apply((EndpointConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointConfiguration> {
        /**
         * <p>
         * A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an
         * edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API
         * and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type
         * is <code>PRIVATE</code>.
         * </p>
         * 
         * @param types
         *        A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For
         *        an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a
         *        regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private
         *        API, the endpoint type is <code>PRIVATE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typesWithStrings(Collection<String> types);

        /**
         * <p>
         * A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an
         * edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API
         * and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type
         * is <code>PRIVATE</code>.
         * </p>
         * 
         * @param types
         *        A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For
         *        an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a
         *        regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private
         *        API, the endpoint type is <code>PRIVATE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typesWithStrings(String... types);

        /**
         * <p>
         * A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an
         * edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API
         * and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type
         * is <code>PRIVATE</code>.
         * </p>
         * 
         * @param types
         *        A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For
         *        an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a
         *        regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private
         *        API, the endpoint type is <code>PRIVATE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<EndpointType> types);

        /**
         * <p>
         * A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an
         * edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API
         * and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type
         * is <code>PRIVATE</code>.
         * </p>
         * 
         * @param types
         *        A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For
         *        an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a
         *        regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private
         *        API, the endpoint type is <code>PRIVATE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(EndpointType... types);

        /**
         * <p>
         * A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only
         * supported for <code>PRIVATE</code> endpoint type.
         * </p>
         * 
         * @param vpcEndpointIds
         *        A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is
         *        only supported for <code>PRIVATE</code> endpoint type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointIds(Collection<String> vpcEndpointIds);

        /**
         * <p>
         * A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only
         * supported for <code>PRIVATE</code> endpoint type.
         * </p>
         * 
         * @param vpcEndpointIds
         *        A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is
         *        only supported for <code>PRIVATE</code> endpoint type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointIds(String... vpcEndpointIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcEndpointIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointConfiguration model) {
            typesWithStrings(model.types);
            vpcEndpointIds(model.vpcEndpointIds);
        }

        public final Collection<String> getTypes() {
            if (types instanceof SdkAutoConstructList) {
                return null;
            }
            return types;
        }

        @Override
        public final Builder typesWithStrings(Collection<String> types) {
            this.types = ListOfEndpointTypeCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typesWithStrings(String... types) {
            typesWithStrings(Arrays.asList(types));
            return this;
        }

        @Override
        public final Builder types(Collection<EndpointType> types) {
            this.types = ListOfEndpointTypeCopier.copyEnumToString(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(EndpointType... types) {
            types(Arrays.asList(types));
            return this;
        }

        public final void setTypes(Collection<String> types) {
            this.types = ListOfEndpointTypeCopier.copy(types);
        }

        public final Collection<String> getVpcEndpointIds() {
            if (vpcEndpointIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcEndpointIds;
        }

        @Override
        public final Builder vpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ListOfStringCopier.copy(vpcEndpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointIds(String... vpcEndpointIds) {
            vpcEndpointIds(Arrays.asList(vpcEndpointIds));
            return this;
        }

        public final void setVpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ListOfStringCopier.copy(vpcEndpointIds);
        }

        @Override
        public EndpointConfiguration build() {
            return new EndpointConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
