/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a collection of API keys as represented by an <a>ApiKeys</a> resource.
 * </p>
 * <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-api-keys.html">Use
 * API Keys</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApiKeysResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetApiKeysResponse.Builder, GetApiKeysResponse> {
    private static final SdkField<List<String>> WARNINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("warnings")
            .getter(getter(GetApiKeysResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("position").getter(getter(GetApiKeysResponse::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<List<ApiKey>> ITEMS_FIELD = SdkField
            .<List<ApiKey>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(GetApiKeysResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("item").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApiKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApiKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WARNINGS_FIELD,
            POSITION_FIELD, ITEMS_FIELD));

    private final List<String> warnings;

    private final String position;

    private final List<ApiKey> items;

    private GetApiKeysResponse(BuilderImpl builder) {
        super(builder);
        this.warnings = builder.warnings;
        this.position = builder.position;
        this.items = builder.items;
    }

    /**
     * Returns true if the Warnings property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasWarnings() {
        return warnings != null && !(warnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of warning messages logged during the import of API keys when the <code>failOnWarnings</code> option is
     * set to true.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWarnings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of warning messages logged during the import of API keys when the <code>failOnWarnings</code>
     *         option is set to true.
     */
    public final List<String> warnings() {
        return warnings;
    }

    /**
     * Returns the value of the Position property for this object.
     * 
     * @return The value of the Position property for this object.
     */
    public final String position() {
        return position;
    }

    /**
     * Returns true if the Items property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The current page of elements from this collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The current page of elements from this collection.
     */
    public final List<ApiKey> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWarnings() ? warnings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApiKeysResponse)) {
            return false;
        }
        GetApiKeysResponse other = (GetApiKeysResponse) obj;
        return hasWarnings() == other.hasWarnings() && Objects.equals(warnings(), other.warnings())
                && Objects.equals(position(), other.position()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApiKeysResponse").add("Warnings", hasWarnings() ? warnings() : null)
                .add("Position", position()).add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApiKeysResponse, T> g) {
        return obj -> g.apply((GetApiKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetApiKeysResponse> {
        /**
         * <p>
         * A list of warning messages logged during the import of API keys when the <code>failOnWarnings</code> option
         * is set to true.
         * </p>
         * 
         * @param warnings
         *        A list of warning messages logged during the import of API keys when the <code>failOnWarnings</code>
         *        option is set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<String> warnings);

        /**
         * <p>
         * A list of warning messages logged during the import of API keys when the <code>failOnWarnings</code> option
         * is set to true.
         * </p>
         * 
         * @param warnings
         *        A list of warning messages logged during the import of API keys when the <code>failOnWarnings</code>
         *        option is set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(String... warnings);

        /**
         * Sets the value of the Position property for this object.
         *
         * @param position
         *        The new value for the Position property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * 
         * @param items
         *        The current page of elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<ApiKey> items);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * 
         * @param items
         *        The current page of elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(ApiKey... items);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ApiKey>.Builder} avoiding the need to
         * create one manually via {@link List<ApiKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApiKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #items(List<ApiKey>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<ApiKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<ApiKey>)
         */
        Builder items(Consumer<ApiKey.Builder>... items);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private List<String> warnings = DefaultSdkAutoConstructList.getInstance();

        private String position;

        private List<ApiKey> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetApiKeysResponse model) {
            super(model);
            warnings(model.warnings);
            position(model.position);
            items(model.items);
        }

        public final Collection<String> getWarnings() {
            if (warnings instanceof SdkAutoConstructList) {
                return null;
            }
            return warnings;
        }

        @Override
        public final Builder warnings(Collection<String> warnings) {
            this.warnings = ListOfStringCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(String... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        public final void setWarnings(Collection<String> warnings) {
            this.warnings = ListOfStringCopier.copy(warnings);
        }

        public final String getPosition() {
            return position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final List<ApiKey.Builder> getItems() {
            List<ApiKey.Builder> result = ListOfApiKeyCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder items(Collection<ApiKey> items) {
            this.items = ListOfApiKeyCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ApiKey... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ApiKey.Builder>... items) {
            items(Stream.of(items).map(c -> ApiKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<ApiKey.BuilderImpl> items) {
            this.items = ListOfApiKeyCopier.copyFromBuilder(items);
        }

        @Override
        public GetApiKeysResponse build() {
            return new GetApiKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
