/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The binary blob response to <a>GetSdk</a>, which contains the generated SDK.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSdkResponse extends ApiGatewayResponse implements ToCopyableBuilder<GetSdkResponse.Builder, GetSdkResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(GetSdkResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> CONTENT_DISPOSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentDisposition").getter(getter(GetSdkResponse::contentDisposition))
            .setter(setter(Builder::contentDisposition))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Disposition").build())
            .build();

    private static final SdkField<SdkBytes> BODY_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("body")
            .getter(getter(GetSdkResponse::body))
            .setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            CONTENT_DISPOSITION_FIELD, BODY_FIELD));

    private final String contentType;

    private final String contentDisposition;

    private final SdkBytes body;

    private GetSdkResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.contentDisposition = builder.contentDisposition;
        this.body = builder.body;
    }

    /**
     * <p>
     * The content-type header value in the HTTP response.
     * </p>
     * 
     * @return The content-type header value in the HTTP response.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The content-disposition header value in the HTTP response.
     * </p>
     * 
     * @return The content-disposition header value in the HTTP response.
     */
    public final String contentDisposition() {
        return contentDisposition;
    }

    /**
     * <p>
     * The binary blob response to <a>GetSdk</a>, which contains the generated SDK.
     * </p>
     * 
     * @return The binary blob response to <a>GetSdk</a>, which contains the generated SDK.
     */
    public final SdkBytes body() {
        return body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(contentDisposition());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSdkResponse)) {
            return false;
        }
        GetSdkResponse other = (GetSdkResponse) obj;
        return Objects.equals(contentType(), other.contentType())
                && Objects.equals(contentDisposition(), other.contentDisposition()) && Objects.equals(body(), other.body());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSdkResponse").add("ContentType", contentType())
                .add("ContentDisposition", contentDisposition()).add("Body", body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "contentDisposition":
            return Optional.ofNullable(clazz.cast(contentDisposition()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSdkResponse, T> g) {
        return obj -> g.apply((GetSdkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSdkResponse> {
        /**
         * <p>
         * The content-type header value in the HTTP response.
         * </p>
         * 
         * @param contentType
         *        The content-type header value in the HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The content-disposition header value in the HTTP response.
         * </p>
         * 
         * @param contentDisposition
         *        The content-disposition header value in the HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentDisposition(String contentDisposition);

        /**
         * <p>
         * The binary blob response to <a>GetSdk</a>, which contains the generated SDK.
         * </p>
         * 
         * @param body
         *        The binary blob response to <a>GetSdk</a>, which contains the generated SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(SdkBytes body);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String contentType;

        private String contentDisposition;

        private SdkBytes body;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSdkResponse model) {
            super(model);
            contentType(model.contentType);
            contentDisposition(model.contentDisposition);
            body(model.body);
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getContentDisposition() {
            return contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        public final ByteBuffer getBody() {
            return body == null ? null : body.asByteBuffer();
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = body;
            return this;
        }

        public final void setBody(ByteBuffer body) {
            body(body == null ? null : SdkBytes.fromByteBuffer(body));
        }

        @Override
        public GetSdkResponse build() {
            return new GetSdkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
