/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Requests API Gateway to create a <a>Stage</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStageRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<CreateStageRequest.Builder, CreateStageRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(CreateStageRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageName").getter(getter(CreateStageRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()).build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentId").getter(getter(CreateStageRequest::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateStageRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> CACHE_CLUSTER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("cacheClusterEnabled").getter(getter(CreateStageRequest::cacheClusterEnabled))
            .setter(setter(Builder::cacheClusterEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheClusterEnabled").build())
            .build();

    private static final SdkField<String> CACHE_CLUSTER_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cacheClusterSize").getter(getter(CreateStageRequest::cacheClusterSize))
            .setter(setter(Builder::cacheClusterSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheClusterSize").build()).build();

    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("variables")
            .getter(getter(CreateStageRequest::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DOCUMENTATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentationVersion").getter(getter(CreateStageRequest::documentationVersion))
            .setter(setter(Builder::documentationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentationVersion").build())
            .build();

    private static final SdkField<CanarySettings> CANARY_SETTINGS_FIELD = SdkField
            .<CanarySettings> builder(MarshallingType.SDK_POJO).memberName("canarySettings")
            .getter(getter(CreateStageRequest::canarySettings)).setter(setter(Builder::canarySettings))
            .constructor(CanarySettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canarySettings").build()).build();

    private static final SdkField<Boolean> TRACING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("tracingEnabled").getter(getter(CreateStageRequest::tracingEnabled))
            .setter(setter(Builder::tracingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingEnabled").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateStageRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            STAGE_NAME_FIELD, DEPLOYMENT_ID_FIELD, DESCRIPTION_FIELD, CACHE_CLUSTER_ENABLED_FIELD, CACHE_CLUSTER_SIZE_FIELD,
            VARIABLES_FIELD, DOCUMENTATION_VERSION_FIELD, CANARY_SETTINGS_FIELD, TRACING_ENABLED_FIELD, TAGS_FIELD));

    private final String restApiId;

    private final String stageName;

    private final String deploymentId;

    private final String description;

    private final Boolean cacheClusterEnabled;

    private final String cacheClusterSize;

    private final Map<String, String> variables;

    private final String documentationVersion;

    private final CanarySettings canarySettings;

    private final Boolean tracingEnabled;

    private final Map<String, String> tags;

    private CreateStageRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.stageName = builder.stageName;
        this.deploymentId = builder.deploymentId;
        this.description = builder.description;
        this.cacheClusterEnabled = builder.cacheClusterEnabled;
        this.cacheClusterSize = builder.cacheClusterSize;
        this.variables = builder.variables;
        this.documentationVersion = builder.documentationVersion;
        this.canarySettings = builder.canarySettings;
        this.tracingEnabled = builder.tracingEnabled;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] The name for the <a>Stage</a> resource. Stage names can only contain alphanumeric characters, hyphens,
     * and underscores. Maximum length is 128 characters.
     * </p>
     * 
     * @return [Required] The name for the <a>Stage</a> resource. Stage names can only contain alphanumeric characters,
     *         hyphens, and underscores. Maximum length is 128 characters.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * <p>
     * [Required] The identifier of the <a>Deployment</a> resource for the <a>Stage</a> resource.
     * </p>
     * 
     * @return [Required] The identifier of the <a>Deployment</a> resource for the <a>Stage</a> resource.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The description of the <a>Stage</a> resource.
     * </p>
     * 
     * @return The description of the <a>Stage</a> resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether cache clustering is enabled for the stage.
     * </p>
     * 
     * @return Whether cache clustering is enabled for the stage.
     */
    public final Boolean cacheClusterEnabled() {
        return cacheClusterEnabled;
    }

    /**
     * <p>
     * The stage's cache cluster size.
     * </p>
     * 
     * @return The stage's cache cluster size.
     */
    public final String cacheClusterSize() {
        return cacheClusterSize;
    }

    /**
     * Returns true if the Variables property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that defines the stage variables for the new <a>Stage</a> resource. Variable names can have alphanumeric
     * and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVariables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map that defines the stage variables for the new <a>Stage</a> resource. Variable names can have
     *         alphanumeric and underscore characters, and the values must match
     *         <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.
     */
    public final Map<String, String> variables() {
        return variables;
    }

    /**
     * <p>
     * The version of the associated API documentation.
     * </p>
     * 
     * @return The version of the associated API documentation.
     */
    public final String documentationVersion() {
        return documentationVersion;
    }

    /**
     * <p>
     * The canary deployment settings of this stage.
     * </p>
     * 
     * @return The canary deployment settings of this stage.
     */
    public final CanarySettings canarySettings() {
        return canarySettings;
    }

    /**
     * <p>
     * Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.
     * </p>
     * 
     * @return Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.
     */
    public final Boolean tracingEnabled() {
        return tracingEnabled;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters
     * and must not start with <code>aws:</code>. The tag value can be up to 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128
     *         characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterSize());
        hashCode = 31 * hashCode + Objects.hashCode(hasVariables() ? variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(documentationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(canarySettings());
        hashCode = 31 * hashCode + Objects.hashCode(tracingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStageRequest)) {
            return false;
        }
        CreateStageRequest other = (CreateStageRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(description(), other.description())
                && Objects.equals(cacheClusterEnabled(), other.cacheClusterEnabled())
                && Objects.equals(cacheClusterSize(), other.cacheClusterSize()) && hasVariables() == other.hasVariables()
                && Objects.equals(variables(), other.variables())
                && Objects.equals(documentationVersion(), other.documentationVersion())
                && Objects.equals(canarySettings(), other.canarySettings())
                && Objects.equals(tracingEnabled(), other.tracingEnabled()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStageRequest").add("RestApiId", restApiId()).add("StageName", stageName())
                .add("DeploymentId", deploymentId()).add("Description", description())
                .add("CacheClusterEnabled", cacheClusterEnabled()).add("CacheClusterSize", cacheClusterSize())
                .add("Variables", hasVariables() ? variables() : null).add("DocumentationVersion", documentationVersion())
                .add("CanarySettings", canarySettings()).add("TracingEnabled", tracingEnabled())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "deploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "cacheClusterEnabled":
            return Optional.ofNullable(clazz.cast(cacheClusterEnabled()));
        case "cacheClusterSize":
            return Optional.ofNullable(clazz.cast(cacheClusterSize()));
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        case "documentationVersion":
            return Optional.ofNullable(clazz.cast(documentationVersion()));
        case "canarySettings":
            return Optional.ofNullable(clazz.cast(canarySettings()));
        case "tracingEnabled":
            return Optional.ofNullable(clazz.cast(tracingEnabled()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStageRequest, T> g) {
        return obj -> g.apply((CreateStageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStageRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] The name for the <a>Stage</a> resource. Stage names can only contain alphanumeric characters,
         * hyphens, and underscores. Maximum length is 128 characters.
         * </p>
         * 
         * @param stageName
         *        [Required] The name for the <a>Stage</a> resource. Stage names can only contain alphanumeric
         *        characters, hyphens, and underscores. Maximum length is 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * [Required] The identifier of the <a>Deployment</a> resource for the <a>Stage</a> resource.
         * </p>
         * 
         * @param deploymentId
         *        [Required] The identifier of the <a>Deployment</a> resource for the <a>Stage</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The description of the <a>Stage</a> resource.
         * </p>
         * 
         * @param description
         *        The description of the <a>Stage</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether cache clustering is enabled for the stage.
         * </p>
         * 
         * @param cacheClusterEnabled
         *        Whether cache clustering is enabled for the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterEnabled(Boolean cacheClusterEnabled);

        /**
         * <p>
         * The stage's cache cluster size.
         * </p>
         * 
         * @param cacheClusterSize
         *        The stage's cache cluster size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterSize(String cacheClusterSize);

        /**
         * <p>
         * A map that defines the stage variables for the new <a>Stage</a> resource. Variable names can have
         * alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.
         * </p>
         * 
         * @param variables
         *        A map that defines the stage variables for the new <a>Stage</a> resource. Variable names can have
         *        alphanumeric and underscore characters, and the values must match
         *        <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Map<String, String> variables);

        /**
         * <p>
         * The version of the associated API documentation.
         * </p>
         * 
         * @param documentationVersion
         *        The version of the associated API documentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationVersion(String documentationVersion);

        /**
         * <p>
         * The canary deployment settings of this stage.
         * </p>
         * 
         * @param canarySettings
         *        The canary deployment settings of this stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canarySettings(CanarySettings canarySettings);

        /**
         * <p>
         * The canary deployment settings of this stage.
         * </p>
         * This is a convenience that creates an instance of the {@link CanarySettings.Builder} avoiding the need to
         * create one manually via {@link CanarySettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link CanarySettings.Builder#build()} is called immediately and its
         * result is passed to {@link #canarySettings(CanarySettings)}.
         * 
         * @param canarySettings
         *        a consumer that will call methods on {@link CanarySettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canarySettings(CanarySettings)
         */
        default Builder canarySettings(Consumer<CanarySettings.Builder> canarySettings) {
            return canarySettings(CanarySettings.builder().applyMutation(canarySettings).build());
        }

        /**
         * <p>
         * Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.
         * </p>
         * 
         * @param tracingEnabled
         *        Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracingEnabled(Boolean tracingEnabled);

        /**
         * <p>
         * The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128
         * characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.
         * </p>
         * 
         * @param tags
         *        The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128
         *        characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String stageName;

        private String deploymentId;

        private String description;

        private Boolean cacheClusterEnabled;

        private String cacheClusterSize;

        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();

        private String documentationVersion;

        private CanarySettings canarySettings;

        private Boolean tracingEnabled;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStageRequest model) {
            super(model);
            restApiId(model.restApiId);
            stageName(model.stageName);
            deploymentId(model.deploymentId);
            description(model.description);
            cacheClusterEnabled(model.cacheClusterEnabled);
            cacheClusterSize(model.cacheClusterSize);
            variables(model.variables);
            documentationVersion(model.documentationVersion);
            canarySettings(model.canarySettings);
            tracingEnabled(model.tracingEnabled);
            tags(model.tags);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getStageName() {
            return stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getCacheClusterEnabled() {
            return cacheClusterEnabled;
        }

        @Override
        public final Builder cacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        public final void setCacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
        }

        public final String getCacheClusterSize() {
            return cacheClusterSize;
        }

        @Override
        public final Builder cacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
            return this;
        }

        public final void setCacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
        }

        public final Map<String, String> getVariables() {
            if (variables instanceof SdkAutoConstructMap) {
                return null;
            }
            return variables;
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = MapOfStringToStringCopier.copy(variables);
            return this;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = MapOfStringToStringCopier.copy(variables);
        }

        public final String getDocumentationVersion() {
            return documentationVersion;
        }

        @Override
        public final Builder documentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
            return this;
        }

        public final void setDocumentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
        }

        public final CanarySettings.Builder getCanarySettings() {
            return canarySettings != null ? canarySettings.toBuilder() : null;
        }

        @Override
        public final Builder canarySettings(CanarySettings canarySettings) {
            this.canarySettings = canarySettings;
            return this;
        }

        public final void setCanarySettings(CanarySettings.BuilderImpl canarySettings) {
            this.canarySettings = canarySettings != null ? canarySettings.build() : null;
        }

        public final Boolean getTracingEnabled() {
            return tracingEnabled;
        }

        @Override
        public final Builder tracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        public final void setTracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStageRequest build() {
            return new CreateStageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
