/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code on the given
 * <a>RestApi</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutGatewayResponseRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<PutGatewayResponseRequest.Builder, PutGatewayResponseRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(PutGatewayResponseRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> RESPONSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseType").getter(getter(PutGatewayResponseRequest::responseTypeAsString))
            .setter(setter(Builder::responseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("response_type").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(PutGatewayResponseRequest::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<Map<String, String>> RESPONSE_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("responseParameters")
            .getter(getter(PutGatewayResponseRequest::responseParameters))
            .setter(setter(Builder::responseParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> RESPONSE_TEMPLATES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("responseTemplates")
            .getter(getter(PutGatewayResponseRequest::responseTemplates))
            .setter(setter(Builder::responseTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTemplates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            RESPONSE_TYPE_FIELD, STATUS_CODE_FIELD, RESPONSE_PARAMETERS_FIELD, RESPONSE_TEMPLATES_FIELD));

    private final String restApiId;

    private final String responseType;

    private final String statusCodeValue;

    private final Map<String, String> responseParameters;

    private final Map<String, String> responseTemplates;

    private PutGatewayResponseRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.responseType = builder.responseType;
        this.statusCodeValue = builder.statusCodeValue;
        this.responseParameters = builder.responseParameters;
        this.responseTemplates = builder.responseTemplates;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required]
     * <p>
     * The response type of the associated <a>GatewayResponse</a>. Valid values are
     * <ul>
     * <li>ACCESS_DENIED</li>
     * <li>API_CONFIGURATION_ERROR</li>
     * <li>AUTHORIZER_FAILURE</li>
     * <li>AUTHORIZER_CONFIGURATION_ERROR</li>
     * <li>BAD_REQUEST_PARAMETERS</li>
     * <li>BAD_REQUEST_BODY</li>
     * <li>DEFAULT_4XX</li>
     * <li>DEFAULT_5XX</li>
     * <li>EXPIRED_TOKEN</li>
     * <li>INVALID_SIGNATURE</li>
     * <li>INTEGRATION_FAILURE</li>
     * <li>INTEGRATION_TIMEOUT</li>
     * <li>INVALID_API_KEY</li>
     * <li>MISSING_AUTHENTICATION_TOKEN</li>
     * <li>QUOTA_EXCEEDED</li>
     * <li>REQUEST_TOO_LARGE</li>
     * <li>RESOURCE_NOT_FOUND</li>
     * <li>THROTTLED</li>
     * <li>UNAUTHORIZED</li>
     * <li>UNSUPPORTED_MEDIA_TYPE</li>
     * </ul>
     * </p>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #responseType} will
     * return {@link GatewayResponseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #responseTypeAsString}.
     * </p>
     * 
     * @return [Required]
     *         <p>
     *         The response type of the associated <a>GatewayResponse</a>. Valid values are
     *         <ul>
     *         <li>ACCESS_DENIED</li>
     *         <li>API_CONFIGURATION_ERROR</li>
     *         <li>AUTHORIZER_FAILURE</li>
     *         <li>AUTHORIZER_CONFIGURATION_ERROR</li>
     *         <li>BAD_REQUEST_PARAMETERS</li>
     *         <li>BAD_REQUEST_BODY</li>
     *         <li>DEFAULT_4XX</li>
     *         <li>DEFAULT_5XX</li>
     *         <li>EXPIRED_TOKEN</li>
     *         <li>INVALID_SIGNATURE</li>
     *         <li>INTEGRATION_FAILURE</li>
     *         <li>INTEGRATION_TIMEOUT</li>
     *         <li>INVALID_API_KEY</li>
     *         <li>MISSING_AUTHENTICATION_TOKEN</li>
     *         <li>QUOTA_EXCEEDED</li>
     *         <li>REQUEST_TOO_LARGE</li>
     *         <li>RESOURCE_NOT_FOUND</li>
     *         <li>THROTTLED</li>
     *         <li>UNAUTHORIZED</li>
     *         <li>UNSUPPORTED_MEDIA_TYPE</li>
     *         </ul>
     *         </p>
     * @see GatewayResponseType
     */
    public final GatewayResponseType responseType() {
        return GatewayResponseType.fromValue(responseType);
    }

    /**
     * <p>
     * [Required]
     * <p>
     * The response type of the associated <a>GatewayResponse</a>. Valid values are
     * <ul>
     * <li>ACCESS_DENIED</li>
     * <li>API_CONFIGURATION_ERROR</li>
     * <li>AUTHORIZER_FAILURE</li>
     * <li>AUTHORIZER_CONFIGURATION_ERROR</li>
     * <li>BAD_REQUEST_PARAMETERS</li>
     * <li>BAD_REQUEST_BODY</li>
     * <li>DEFAULT_4XX</li>
     * <li>DEFAULT_5XX</li>
     * <li>EXPIRED_TOKEN</li>
     * <li>INVALID_SIGNATURE</li>
     * <li>INTEGRATION_FAILURE</li>
     * <li>INTEGRATION_TIMEOUT</li>
     * <li>INVALID_API_KEY</li>
     * <li>MISSING_AUTHENTICATION_TOKEN</li>
     * <li>QUOTA_EXCEEDED</li>
     * <li>REQUEST_TOO_LARGE</li>
     * <li>RESOURCE_NOT_FOUND</li>
     * <li>THROTTLED</li>
     * <li>UNAUTHORIZED</li>
     * <li>UNSUPPORTED_MEDIA_TYPE</li>
     * </ul>
     * </p>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #responseType} will
     * return {@link GatewayResponseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #responseTypeAsString}.
     * </p>
     * 
     * @return [Required]
     *         <p>
     *         The response type of the associated <a>GatewayResponse</a>. Valid values are
     *         <ul>
     *         <li>ACCESS_DENIED</li>
     *         <li>API_CONFIGURATION_ERROR</li>
     *         <li>AUTHORIZER_FAILURE</li>
     *         <li>AUTHORIZER_CONFIGURATION_ERROR</li>
     *         <li>BAD_REQUEST_PARAMETERS</li>
     *         <li>BAD_REQUEST_BODY</li>
     *         <li>DEFAULT_4XX</li>
     *         <li>DEFAULT_5XX</li>
     *         <li>EXPIRED_TOKEN</li>
     *         <li>INVALID_SIGNATURE</li>
     *         <li>INTEGRATION_FAILURE</li>
     *         <li>INTEGRATION_TIMEOUT</li>
     *         <li>INVALID_API_KEY</li>
     *         <li>MISSING_AUTHENTICATION_TOKEN</li>
     *         <li>QUOTA_EXCEEDED</li>
     *         <li>REQUEST_TOO_LARGE</li>
     *         <li>RESOURCE_NOT_FOUND</li>
     *         <li>THROTTLED</li>
     *         <li>UNAUTHORIZED</li>
     *         <li>UNSUPPORTED_MEDIA_TYPE</li>
     *         </ul>
     *         </p>
     * @see GatewayResponseType
     */
    public final String responseTypeAsString() {
        return responseType;
    }

    /**
     * The HTTP status code of the <a>GatewayResponse</a>.
     * 
     * @return The HTTP status code of the <a>GatewayResponse</a>.
     */
    public final String statusCode() {
        return statusCodeValue;
    }

    /**
     * Returns true if the ResponseParameters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasResponseParameters() {
        return responseParameters != null && !(responseParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * <p>
     * Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of
     * key-value pairs.
     * </p>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResponseParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a
     *         string-to-string map of key-value pairs.
     */
    public final Map<String, String> responseParameters() {
        return responseParameters;
    }

    /**
     * Returns true if the ResponseTemplates property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasResponseTemplates() {
        return responseTemplates != null && !(responseTemplates instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * <p>
     * Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.
     * </p>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResponseTemplates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.
     */
    public final Map<String, String> responseTemplates() {
        return responseTemplates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(responseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseParameters() ? responseParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseTemplates() ? responseTemplates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutGatewayResponseRequest)) {
            return false;
        }
        PutGatewayResponseRequest other = (PutGatewayResponseRequest) obj;
        return Objects.equals(restApiId(), other.restApiId())
                && Objects.equals(responseTypeAsString(), other.responseTypeAsString())
                && Objects.equals(statusCode(), other.statusCode()) && hasResponseParameters() == other.hasResponseParameters()
                && Objects.equals(responseParameters(), other.responseParameters())
                && hasResponseTemplates() == other.hasResponseTemplates()
                && Objects.equals(responseTemplates(), other.responseTemplates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutGatewayResponseRequest").add("RestApiId", restApiId())
                .add("ResponseType", responseTypeAsString()).add("StatusCode", statusCode())
                .add("ResponseParameters", hasResponseParameters() ? responseParameters() : null)
                .add("ResponseTemplates", hasResponseTemplates() ? responseTemplates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "responseType":
            return Optional.ofNullable(clazz.cast(responseTypeAsString()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "responseParameters":
            return Optional.ofNullable(clazz.cast(responseParameters()));
        case "responseTemplates":
            return Optional.ofNullable(clazz.cast(responseTemplates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutGatewayResponseRequest, T> g) {
        return obj -> g.apply((PutGatewayResponseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutGatewayResponseRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required]
         * <p>
         * The response type of the associated <a>GatewayResponse</a>. Valid values are
         * <ul>
         * <li>ACCESS_DENIED</li>
         * <li>API_CONFIGURATION_ERROR</li>
         * <li>AUTHORIZER_FAILURE</li>
         * <li>AUTHORIZER_CONFIGURATION_ERROR</li>
         * <li>BAD_REQUEST_PARAMETERS</li>
         * <li>BAD_REQUEST_BODY</li>
         * <li>DEFAULT_4XX</li>
         * <li>DEFAULT_5XX</li>
         * <li>EXPIRED_TOKEN</li>
         * <li>INVALID_SIGNATURE</li>
         * <li>INTEGRATION_FAILURE</li>
         * <li>INTEGRATION_TIMEOUT</li>
         * <li>INVALID_API_KEY</li>
         * <li>MISSING_AUTHENTICATION_TOKEN</li>
         * <li>QUOTA_EXCEEDED</li>
         * <li>REQUEST_TOO_LARGE</li>
         * <li>RESOURCE_NOT_FOUND</li>
         * <li>THROTTLED</li>
         * <li>UNAUTHORIZED</li>
         * <li>UNSUPPORTED_MEDIA_TYPE</li>
         * </ul>
         * </p>
         * </p>
         * 
         * @param responseType
         *        [Required]
         *        <p>
         *        The response type of the associated <a>GatewayResponse</a>. Valid values are
         *        <ul>
         *        <li>ACCESS_DENIED</li>
         *        <li>API_CONFIGURATION_ERROR</li>
         *        <li>AUTHORIZER_FAILURE</li>
         *        <li>AUTHORIZER_CONFIGURATION_ERROR</li>
         *        <li>BAD_REQUEST_PARAMETERS</li>
         *        <li>BAD_REQUEST_BODY</li>
         *        <li>DEFAULT_4XX</li>
         *        <li>DEFAULT_5XX</li>
         *        <li>EXPIRED_TOKEN</li>
         *        <li>INVALID_SIGNATURE</li>
         *        <li>INTEGRATION_FAILURE</li>
         *        <li>INTEGRATION_TIMEOUT</li>
         *        <li>INVALID_API_KEY</li>
         *        <li>MISSING_AUTHENTICATION_TOKEN</li>
         *        <li>QUOTA_EXCEEDED</li>
         *        <li>REQUEST_TOO_LARGE</li>
         *        <li>RESOURCE_NOT_FOUND</li>
         *        <li>THROTTLED</li>
         *        <li>UNAUTHORIZED</li>
         *        <li>UNSUPPORTED_MEDIA_TYPE</li>
         *        </ul>
         *        </p>
         * @see GatewayResponseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayResponseType
         */
        Builder responseType(String responseType);

        /**
         * <p>
         * [Required]
         * <p>
         * The response type of the associated <a>GatewayResponse</a>. Valid values are
         * <ul>
         * <li>ACCESS_DENIED</li>
         * <li>API_CONFIGURATION_ERROR</li>
         * <li>AUTHORIZER_FAILURE</li>
         * <li>AUTHORIZER_CONFIGURATION_ERROR</li>
         * <li>BAD_REQUEST_PARAMETERS</li>
         * <li>BAD_REQUEST_BODY</li>
         * <li>DEFAULT_4XX</li>
         * <li>DEFAULT_5XX</li>
         * <li>EXPIRED_TOKEN</li>
         * <li>INVALID_SIGNATURE</li>
         * <li>INTEGRATION_FAILURE</li>
         * <li>INTEGRATION_TIMEOUT</li>
         * <li>INVALID_API_KEY</li>
         * <li>MISSING_AUTHENTICATION_TOKEN</li>
         * <li>QUOTA_EXCEEDED</li>
         * <li>REQUEST_TOO_LARGE</li>
         * <li>RESOURCE_NOT_FOUND</li>
         * <li>THROTTLED</li>
         * <li>UNAUTHORIZED</li>
         * <li>UNSUPPORTED_MEDIA_TYPE</li>
         * </ul>
         * </p>
         * </p>
         * 
         * @param responseType
         *        [Required]
         *        <p>
         *        The response type of the associated <a>GatewayResponse</a>. Valid values are
         *        <ul>
         *        <li>ACCESS_DENIED</li>
         *        <li>API_CONFIGURATION_ERROR</li>
         *        <li>AUTHORIZER_FAILURE</li>
         *        <li>AUTHORIZER_CONFIGURATION_ERROR</li>
         *        <li>BAD_REQUEST_PARAMETERS</li>
         *        <li>BAD_REQUEST_BODY</li>
         *        <li>DEFAULT_4XX</li>
         *        <li>DEFAULT_5XX</li>
         *        <li>EXPIRED_TOKEN</li>
         *        <li>INVALID_SIGNATURE</li>
         *        <li>INTEGRATION_FAILURE</li>
         *        <li>INTEGRATION_TIMEOUT</li>
         *        <li>INVALID_API_KEY</li>
         *        <li>MISSING_AUTHENTICATION_TOKEN</li>
         *        <li>QUOTA_EXCEEDED</li>
         *        <li>REQUEST_TOO_LARGE</li>
         *        <li>RESOURCE_NOT_FOUND</li>
         *        <li>THROTTLED</li>
         *        <li>UNAUTHORIZED</li>
         *        <li>UNSUPPORTED_MEDIA_TYPE</li>
         *        </ul>
         *        </p>
         * @see GatewayResponseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayResponseType
         */
        Builder responseType(GatewayResponseType responseType);

        /**
         * The HTTP status code of the <a>GatewayResponse</a>.
         * 
         * @param statusCodeValue
         *        The HTTP status code of the <a>GatewayResponse</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * <p>
         * Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string
         * map of key-value pairs.
         * </p>
         * </p>
         * 
         * @param responseParameters
         *        Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a
         *        string-to-string map of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseParameters(Map<String, String> responseParameters);

        /**
         * <p>
         * <p>
         * Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.
         * </p>
         * </p>
         * 
         * @param responseTemplates
         *        Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTemplates(Map<String, String> responseTemplates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String responseType;

        private String statusCodeValue;

        private Map<String, String> responseParameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> responseTemplates = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutGatewayResponseRequest model) {
            super(model);
            restApiId(model.restApiId);
            responseType(model.responseType);
            statusCode(model.statusCodeValue);
            responseParameters(model.responseParameters);
            responseTemplates(model.responseTemplates);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getResponseType() {
            return responseType;
        }

        @Override
        public final Builder responseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        @Override
        public final Builder responseType(GatewayResponseType responseType) {
            this.responseType(responseType == null ? null : responseType.toString());
            return this;
        }

        public final void setResponseType(String responseType) {
            this.responseType = responseType;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        public final Map<String, String> getResponseParameters() {
            if (responseParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return responseParameters;
        }

        @Override
        public final Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
        }

        public final Map<String, String> getResponseTemplates() {
            if (responseTemplates instanceof SdkAutoConstructMap) {
                return null;
            }
            return responseTemplates;
        }

        @Override
        public final Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
            return this;
        }

        public final void setResponseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutGatewayResponseRequest build() {
            return new PutGatewayResponseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
