/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The collection of documentation parts of an API.
 * </p>
 * <div class="remarks"/> <div class="seeAlso"> <a
 * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an
 * API</a>, <a>DocumentationPart</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDocumentationPartsResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetDocumentationPartsResponse.Builder, GetDocumentationPartsResponse> {
    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("position").getter(getter(GetDocumentationPartsResponse::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<List<DocumentationPart>> ITEMS_FIELD = SdkField
            .<List<DocumentationPart>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(GetDocumentationPartsResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("item").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentationPart> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentationPart::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITION_FIELD, ITEMS_FIELD));

    private final String position;

    private final List<DocumentationPart> items;

    private GetDocumentationPartsResponse(BuilderImpl builder) {
        super(builder);
        this.position = builder.position;
        this.items = builder.items;
    }

    /**
     * Returns the value of the Position property for this object.
     * 
     * @return The value of the Position property for this object.
     */
    public final String position() {
        return position;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The current page of elements from this collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The current page of elements from this collection.
     */
    public final List<DocumentationPart> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentationPartsResponse)) {
            return false;
        }
        GetDocumentationPartsResponse other = (GetDocumentationPartsResponse) obj;
        return Objects.equals(position(), other.position()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDocumentationPartsResponse").add("Position", position())
                .add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentationPartsResponse, T> g) {
        return obj -> g.apply((GetDocumentationPartsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDocumentationPartsResponse> {
        /**
         * Sets the value of the Position property for this object.
         *
         * @param position
         *        The new value for the Position property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * 
         * @param items
         *        The current page of elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<DocumentationPart> items);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * 
         * @param items
         *        The current page of elements from this collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(DocumentationPart... items);

        /**
         * <p>
         * The current page of elements from this collection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentationPart>.Builder} avoiding the
         * need to create one manually via {@link List<DocumentationPart>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentationPart>.Builder#build()} is called immediately
         * and its result is passed to {@link #items(List<DocumentationPart>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<DocumentationPart>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<DocumentationPart>)
         */
        Builder items(Consumer<DocumentationPart.Builder>... items);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String position;

        private List<DocumentationPart> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentationPartsResponse model) {
            super(model);
            position(model.position);
            items(model.items);
        }

        public final String getPosition() {
            return position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        @Transient
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final List<DocumentationPart.Builder> getItems() {
            List<DocumentationPart.Builder> result = ListOfDocumentationPartCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<DocumentationPart.BuilderImpl> items) {
            this.items = ListOfDocumentationPartCopier.copyFromBuilder(items);
        }

        @Override
        @Transient
        public final Builder items(Collection<DocumentationPart> items) {
            this.items = ListOfDocumentationPartCopier.copy(items);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(DocumentationPart... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(Consumer<DocumentationPart.Builder>... items) {
            items(Stream.of(items).map(c -> DocumentationPart.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDocumentationPartsResponse build() {
            return new GetDocumentationPartsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
