/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to list information about a collection of resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourcesRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetResourcesRequest.Builder, GetResourcesRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(GetResourcesRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("position").getter(getter(GetResourcesRequest::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("position").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(GetResourcesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<List<String>> EMBED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("embed")
            .getter(getter(GetResourcesRequest::embed))
            .setter(setter(Builder::embed))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("embed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            POSITION_FIELD, LIMIT_FIELD, EMBED_FIELD));

    private final String restApiId;

    private final String position;

    private final Integer limit;

    private final List<String> embed;

    private GetResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.position = builder.position;
        this.limit = builder.limit;
        this.embed = builder.embed;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * The current pagination position in the paged result set.
     * </p>
     * 
     * @return The current pagination position in the paged result set.
     */
    public final String position() {
        return position;
    }

    /**
     * <p>
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     * </p>
     * 
     * @return The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * For responses, this returns true if the service returned a value for the Embed property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasEmbed() {
        return embed != null && !(embed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A query parameter used to retrieve the specified resources embedded in the returned <a>Resources</a> resource in
     * the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the
     * request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value must
     * be a single-valued list and contain the <code>"methods"</code> string. For example,
     * <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmbed} method.
     * </p>
     * 
     * @return A query parameter used to retrieve the specified resources embedded in the returned <a>Resources</a>
     *         resource in the response. This <code>embed</code> parameter value is a list of comma-separated strings.
     *         Currently, the request supports only retrieval of the embedded <a>Method</a> resources this way. The
     *         query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For
     *         example, <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.
     */
    public final List<String> embed() {
        return embed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(hasEmbed() ? embed() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesRequest)) {
            return false;
        }
        GetResourcesRequest other = (GetResourcesRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(position(), other.position())
                && Objects.equals(limit(), other.limit()) && hasEmbed() == other.hasEmbed()
                && Objects.equals(embed(), other.embed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourcesRequest").add("RestApiId", restApiId()).add("Position", position())
                .add("Limit", limit()).add("Embed", hasEmbed() ? embed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "embed":
            return Optional.ofNullable(clazz.cast(embed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesRequest, T> g) {
        return obj -> g.apply((GetResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetResourcesRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * The current pagination position in the paged result set.
         * </p>
         * 
         * @param position
         *        The current pagination position in the paged result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         * </p>
         * 
         * @param limit
         *        The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * A query parameter used to retrieve the specified resources embedded in the returned <a>Resources</a> resource
         * in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the
         * request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value
         * must be a single-valued list and contain the <code>"methods"</code> string. For example,
         * <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.
         * </p>
         * 
         * @param embed
         *        A query parameter used to retrieve the specified resources embedded in the returned <a>Resources</a>
         *        resource in the response. This <code>embed</code> parameter value is a list of comma-separated
         *        strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this
         *        way. The query parameter value must be a single-valued list and contain the <code>"methods"</code>
         *        string. For example, <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embed(Collection<String> embed);

        /**
         * <p>
         * A query parameter used to retrieve the specified resources embedded in the returned <a>Resources</a> resource
         * in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the
         * request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value
         * must be a single-valued list and contain the <code>"methods"</code> string. For example,
         * <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.
         * </p>
         * 
         * @param embed
         *        A query parameter used to retrieve the specified resources embedded in the returned <a>Resources</a>
         *        resource in the response. This <code>embed</code> parameter value is a list of comma-separated
         *        strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this
         *        way. The query parameter value must be a single-valued list and contain the <code>"methods"</code>
         *        string. For example, <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embed(String... embed);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String position;

        private Integer limit;

        private List<String> embed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesRequest model) {
            super(model);
            restApiId(model.restApiId);
            position(model.position);
            limit(model.limit);
            embed(model.embed);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        @Transient
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getPosition() {
            return position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        @Transient
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        @Transient
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Collection<String> getEmbed() {
            if (embed instanceof SdkAutoConstructList) {
                return null;
            }
            return embed;
        }

        public final void setEmbed(Collection<String> embed) {
            this.embed = ListOfStringCopier.copy(embed);
        }

        @Override
        @Transient
        public final Builder embed(Collection<String> embed) {
            this.embed = ListOfStringCopier.copy(embed);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder embed(String... embed) {
            embed(Arrays.asList(embed));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourcesRequest build() {
            return new GetResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
