/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to update an existing <a>MethodResponse</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMethodResponseRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<UpdateMethodResponseRequest.Builder, UpdateMethodResponseRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(UpdateMethodResponseRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(UpdateMethodResponseRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource_id").build()).build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpMethod").getter(getter(UpdateMethodResponseRequest::httpMethod)).setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("http_method").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(UpdateMethodResponseRequest::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("status_code").build()).build();

    private static final SdkField<List<PatchOperation>> PATCH_OPERATIONS_FIELD = SdkField
            .<List<PatchOperation>> builder(MarshallingType.LIST)
            .memberName("patchOperations")
            .getter(getter(UpdateMethodResponseRequest::patchOperations))
            .setter(setter(Builder::patchOperations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patchOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PatchOperation> builder(MarshallingType.SDK_POJO)
                                            .constructor(PatchOperation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            RESOURCE_ID_FIELD, HTTP_METHOD_FIELD, STATUS_CODE_FIELD, PATCH_OPERATIONS_FIELD));

    private final String restApiId;

    private final String resourceId;

    private final String httpMethod;

    private final String statusCodeValue;

    private final List<PatchOperation> patchOperations;

    private UpdateMethodResponseRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.httpMethod = builder.httpMethod;
        this.statusCodeValue = builder.statusCodeValue;
        this.patchOperations = builder.patchOperations;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.
     * </p>
     * 
     * @return [Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * [Required] The HTTP verb of the <a>Method</a> resource.
     * </p>
     * 
     * @return [Required] The HTTP verb of the <a>Method</a> resource.
     */
    public final String httpMethod() {
        return httpMethod;
    }

    /**
     * <p>
     * [Required] The status code for the <a>MethodResponse</a> resource.
     * </p>
     * 
     * @return [Required] The status code for the <a>MethodResponse</a> resource.
     */
    public final String statusCode() {
        return statusCodeValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the PatchOperations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPatchOperations() {
        return patchOperations != null && !(patchOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of update operations to be applied to the specified resource and in the order specified in this list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPatchOperations} method.
     * </p>
     * 
     * @return A list of update operations to be applied to the specified resource and in the order specified in this
     *         list.
     */
    public final List<PatchOperation> patchOperations() {
        return patchOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasPatchOperations() ? patchOperations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMethodResponseRequest)) {
            return false;
        }
        UpdateMethodResponseRequest other = (UpdateMethodResponseRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(httpMethod(), other.httpMethod()) && Objects.equals(statusCode(), other.statusCode())
                && hasPatchOperations() == other.hasPatchOperations()
                && Objects.equals(patchOperations(), other.patchOperations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMethodResponseRequest").add("RestApiId", restApiId()).add("ResourceId", resourceId())
                .add("HttpMethod", httpMethod()).add("StatusCode", statusCode())
                .add("PatchOperations", hasPatchOperations() ? patchOperations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "httpMethod":
            return Optional.ofNullable(clazz.cast(httpMethod()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "patchOperations":
            return Optional.ofNullable(clazz.cast(patchOperations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMethodResponseRequest, T> g) {
        return obj -> g.apply((UpdateMethodResponseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMethodResponseRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.
         * </p>
         * 
         * @param resourceId
         *        [Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * [Required] The HTTP verb of the <a>Method</a> resource.
         * </p>
         * 
         * @param httpMethod
         *        [Required] The HTTP verb of the <a>Method</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * [Required] The status code for the <a>MethodResponse</a> resource.
         * </p>
         * 
         * @param statusCodeValue
         *        [Required] The status code for the <a>MethodResponse</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * A list of update operations to be applied to the specified resource and in the order specified in this list.
         * </p>
         * 
         * @param patchOperations
         *        A list of update operations to be applied to the specified resource and in the order specified in this
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchOperations(Collection<PatchOperation> patchOperations);

        /**
         * <p>
         * A list of update operations to be applied to the specified resource and in the order specified in this list.
         * </p>
         * 
         * @param patchOperations
         *        A list of update operations to be applied to the specified resource and in the order specified in this
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchOperations(PatchOperation... patchOperations);

        /**
         * <p>
         * A list of update operations to be applied to the specified resource and in the order specified in this list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PatchOperation>.Builder} avoiding the need
         * to create one manually via {@link List<PatchOperation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PatchOperation>.Builder#build()} is called immediately and
         * its result is passed to {@link #patchOperations(List<PatchOperation>)}.
         * 
         * @param patchOperations
         *        a consumer that will call methods on {@link List<PatchOperation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patchOperations(List<PatchOperation>)
         */
        Builder patchOperations(Consumer<PatchOperation.Builder>... patchOperations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String resourceId;

        private String httpMethod;

        private String statusCodeValue;

        private List<PatchOperation> patchOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMethodResponseRequest model) {
            super(model);
            restApiId(model.restApiId);
            resourceId(model.resourceId);
            httpMethod(model.httpMethod);
            statusCode(model.statusCodeValue);
            patchOperations(model.patchOperations);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        @Transient
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        @Transient
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        @Transient
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final List<PatchOperation.Builder> getPatchOperations() {
            List<PatchOperation.Builder> result = ListOfPatchOperationCopier.copyToBuilder(this.patchOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPatchOperations(Collection<PatchOperation.BuilderImpl> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copyFromBuilder(patchOperations);
        }

        @Override
        @Transient
        public final Builder patchOperations(Collection<PatchOperation> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copy(patchOperations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder patchOperations(PatchOperation... patchOperations) {
            patchOperations(Arrays.asList(patchOperations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder patchOperations(Consumer<PatchOperation.Builder>... patchOperations) {
            patchOperations(Stream.of(patchOperations).map(c -> PatchOperation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMethodResponseRequest build() {
            return new UpdateMethodResponseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
