/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A documentation part for a targeted API entity.
 * </p>
 * <div class="remarks">
 * <p>
 * A documentation part consists of a content map (<code>properties</code>) and a target (<code>location</code>). The
 * target specifies an API entity to which the documentation content applies. The supported API entity types are
 * <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>,
 * <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>,
 * <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Valid <code>location</code>
 * fields depend on the API entity type. All valid fields are not required.
 * </p>
 * <p>
 * The content map is a JSON string of API-specific key-value pairs. Although an API can use any shape for the content
 * map, only the OpenAPI-compliant documentation fields will be injected into the associated API entity definition in
 * the exported OpenAPI definition file.
 * </p>
 * </div> <div class="seeAlso"> <a
 * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an
 * API</a>, <a>DocumentationParts</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDocumentationPartResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<CreateDocumentationPartResponse.Builder, CreateDocumentationPartResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateDocumentationPartResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<DocumentationPartLocation> LOCATION_FIELD = SdkField
            .<DocumentationPartLocation> builder(MarshallingType.SDK_POJO).memberName("location")
            .getter(getter(CreateDocumentationPartResponse::location)).setter(setter(Builder::location))
            .constructor(DocumentationPartLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> PROPERTIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("properties").getter(getter(CreateDocumentationPartResponse::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, LOCATION_FIELD,
            PROPERTIES_FIELD));

    private final String id;

    private final DocumentationPartLocation location;

    private final String properties;

    private CreateDocumentationPartResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.location = builder.location;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code> is
     * created.
     * </p>
     * 
     * @return The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code>
     *         is created.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity
     * type. All the valid location fields are not required. If not explicitly specified, a valid location field is
     * treated as a wildcard and associated documentation content may be inherited by matching entities, unless
     * overridden.
     * </p>
     * 
     * @return The location of the API entity to which the documentation applies. Valid fields depend on the targeted
     *         API entity type. All the valid location fields are not required. If not explicitly specified, a valid
     *         location field is treated as a wildcard and associated documentation content may be inherited by matching
     *         entities, unless overridden.
     */
    public final DocumentationPartLocation location() {
        return location;
    }

    /**
     * <p>
     * A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a
     * JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>. Only OpenAPI-compliant
     * documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as
     * part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of
     * <code>x-amazon-apigateway-documentation</code>.
     * </p>
     * 
     * @return A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded
     *         as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>. Only OpenAPI-compliant
     *         documentation-related fields from the <literal>properties</literal> map are exported and, hence,
     *         published as part of the API entity definitions, while the original documentation parts are exported in a
     *         OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.
     */
    public final String properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDocumentationPartResponse)) {
            return false;
        }
        CreateDocumentationPartResponse other = (CreateDocumentationPartResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(location(), other.location())
                && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDocumentationPartResponse").add("Id", id()).add("Location", location())
                .add("Properties", properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDocumentationPartResponse, T> g) {
        return obj -> g.apply((CreateDocumentationPartResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDocumentationPartResponse> {
        /**
         * <p>
         * The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code> is
         * created.
         * </p>
         * 
         * @param id
         *        The <a>DocumentationPart</a> identifier, generated by API Gateway when the
         *        <code>DocumentationPart</code> is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The location of the API entity to which the documentation applies. Valid fields depend on the targeted API
         * entity type. All the valid location fields are not required. If not explicitly specified, a valid location
         * field is treated as a wildcard and associated documentation content may be inherited by matching entities,
         * unless overridden.
         * </p>
         * 
         * @param location
         *        The location of the API entity to which the documentation applies. Valid fields depend on the targeted
         *        API entity type. All the valid location fields are not required. If not explicitly specified, a valid
         *        location field is treated as a wildcard and associated documentation content may be inherited by
         *        matching entities, unless overridden.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(DocumentationPartLocation location);

        /**
         * <p>
         * The location of the API entity to which the documentation applies. Valid fields depend on the targeted API
         * entity type. All the valid location fields are not required. If not explicitly specified, a valid location
         * field is treated as a wildcard and associated documentation content may be inherited by matching entities,
         * unless overridden.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentationPartLocation.Builder} avoiding the
         * need to create one manually via {@link DocumentationPartLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentationPartLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #location(DocumentationPartLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link DocumentationPartLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(DocumentationPartLocation)
         */
        default Builder location(Consumer<DocumentationPartLocation.Builder> location) {
            return location(DocumentationPartLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as
         * a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>. Only OpenAPI-compliant
         * documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as
         * part of the API entity definitions, while the original documentation parts are exported in a OpenAPI
         * extension of <code>x-amazon-apigateway-documentation</code>.
         * </p>
         * 
         * @param properties
         *        A content map of API-specific key-value pairs describing the targeted API entity. The map must be
         *        encoded as a JSON string, e.g., <code>"{ \"description\": \"The API does ...\" }"</code>. Only
         *        OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported
         *        and, hence, published as part of the API entity definitions, while the original documentation parts
         *        are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(String properties);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String id;

        private DocumentationPartLocation location;

        private String properties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDocumentationPartResponse model) {
            super(model);
            id(model.id);
            location(model.location);
            properties(model.properties);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final DocumentationPartLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(DocumentationPartLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        @Transient
        public final Builder location(DocumentationPartLocation location) {
            this.location = location;
            return this;
        }

        public final String getProperties() {
            return properties;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        @Override
        @Transient
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public CreateDocumentationPartResponse build() {
            return new CreateDocumentationPartResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
