/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a REST API.
 * </p>
 * <div class="seeAlso"> <a
 * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRestApiResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<CreateRestApiResponse.Builder, CreateRestApiResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateRestApiResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRestApiResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateRestApiResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(CreateRestApiResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(CreateRestApiResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<List<String>> WARNINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("warnings")
            .getter(getter(CreateRestApiResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BINARY_MEDIA_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("binaryMediaTypes")
            .getter(getter(CreateRestApiResponse::binaryMediaTypes))
            .setter(setter(Builder::binaryMediaTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binaryMediaTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MINIMUM_COMPRESSION_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minimumCompressionSize").getter(getter(CreateRestApiResponse::minimumCompressionSize))
            .setter(setter(Builder::minimumCompressionSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumCompressionSize").build())
            .build();

    private static final SdkField<String> API_KEY_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiKeySource").getter(getter(CreateRestApiResponse::apiKeySourceAsString))
            .setter(setter(Builder::apiKeySource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeySource").build()).build();

    private static final SdkField<EndpointConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField
            .<EndpointConfiguration> builder(MarshallingType.SDK_POJO).memberName("endpointConfiguration")
            .getter(getter(CreateRestApiResponse::endpointConfiguration)).setter(setter(Builder::endpointConfiguration))
            .constructor(EndpointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfiguration").build())
            .build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("policy")
            .getter(getter(CreateRestApiResponse::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateRestApiResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> DISABLE_EXECUTE_API_ENDPOINT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("disableExecuteApiEndpoint")
            .getter(getter(CreateRestApiResponse::disableExecuteApiEndpoint)).setter(setter(Builder::disableExecuteApiEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableExecuteApiEndpoint").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CREATED_DATE_FIELD, VERSION_FIELD, WARNINGS_FIELD, BINARY_MEDIA_TYPES_FIELD,
            MINIMUM_COMPRESSION_SIZE_FIELD, API_KEY_SOURCE_FIELD, ENDPOINT_CONFIGURATION_FIELD, POLICY_FIELD, TAGS_FIELD,
            DISABLE_EXECUTE_API_ENDPOINT_FIELD));

    private final String id;

    private final String name;

    private final String description;

    private final Instant createdDate;

    private final String version;

    private final List<String> warnings;

    private final List<String> binaryMediaTypes;

    private final Integer minimumCompressionSize;

    private final String apiKeySource;

    private final EndpointConfiguration endpointConfiguration;

    private final String policy;

    private final Map<String, String> tags;

    private final Boolean disableExecuteApiEndpoint;

    private CreateRestApiResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.warnings = builder.warnings;
        this.binaryMediaTypes = builder.binaryMediaTypes;
        this.minimumCompressionSize = builder.minimumCompressionSize;
        this.apiKeySource = builder.apiKeySource;
        this.endpointConfiguration = builder.endpointConfiguration;
        this.policy = builder.policy;
        this.tags = builder.tags;
        this.disableExecuteApiEndpoint = builder.disableExecuteApiEndpoint;
    }

    /**
     * <p>
     * The API's identifier. This identifier is unique across all of your APIs in API Gateway.
     * </p>
     * 
     * @return The API's identifier. This identifier is unique across all of your APIs in API Gateway.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The API's name.
     * </p>
     * 
     * @return The API's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The API's description.
     * </p>
     * 
     * @return The API's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp when the API was created.
     * </p>
     * 
     * @return The timestamp when the API was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * A version identifier for the API.
     * </p>
     * 
     * @return A version identifier for the API.
     */
    public final String version() {
        return version;
    }

    /**
     * For responses, this returns true if the service returned a value for the Warnings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWarnings() {
        return warnings != null && !(warnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The warning messages reported when <code>failonwarnings</code> is turned on during API import.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWarnings} method.
     * </p>
     * 
     * @return The warning messages reported when <code>failonwarnings</code> is turned on during API import.
     */
    public final List<String> warnings() {
        return warnings;
    }

    /**
     * For responses, this returns true if the service returned a value for the BinaryMediaTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBinaryMediaTypes() {
        return binaryMediaTypes != null && !(binaryMediaTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only
     * UTF-8-encoded text payloads.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBinaryMediaTypes} method.
     * </p>
     * 
     * @return The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports
     *         only UTF-8-encoded text payloads.
     */
    public final List<String> binaryMediaTypes() {
        return binaryMediaTypes;
    }

    /**
     * <p>
     * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes,
     * inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or
     * decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero
     * allows compression for any payload size.
     * </p>
     * 
     * @return A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M)
     *         bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled,
     *         compression or decompression is not applied on the payload if the payload size is smaller than this
     *         value. Setting it to zero allows compression for any payload size.
     */
    public final Integer minimumCompressionSize() {
        return minimumCompressionSize;
    }

    /**
     * <p>
     * The source of the API key for metering requests according to a usage plan. Valid values are:
     * <ul>
     * <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
     * <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
     * authorizer.</li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiKeySource} will
     * return {@link ApiKeySourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiKeySourceAsString}.
     * </p>
     * 
     * @return The source of the API key for metering requests according to a usage plan. Valid values are:
     *         <ul>
     *         <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
     *         <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
     *         authorizer.</li>
     *         </ul>
     * @see ApiKeySourceType
     */
    public final ApiKeySourceType apiKeySource() {
        return ApiKeySourceType.fromValue(apiKeySource);
    }

    /**
     * <p>
     * The source of the API key for metering requests according to a usage plan. Valid values are:
     * <ul>
     * <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
     * <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
     * authorizer.</li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiKeySource} will
     * return {@link ApiKeySourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiKeySourceAsString}.
     * </p>
     * 
     * @return The source of the API key for metering requests according to a usage plan. Valid values are:
     *         <ul>
     *         <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
     *         <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
     *         authorizer.</li>
     *         </ul>
     * @see ApiKeySourceType
     */
    public final String apiKeySourceAsString() {
        return apiKeySource;
    }

    /**
     * <p>
     * The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
     * </p>
     * 
     * @return The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
     */
    public final EndpointConfiguration endpointConfiguration() {
        return endpointConfiguration;
    }

    /**
     * <p>
     * A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a>
     * configuration.
     * </p>
     * 
     * @return A stringified JSON policy document that applies to this RestApi regardless of the caller and
     *         <a>Method</a> configuration.
     */
    public final String policy() {
        return policy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The collection of tags. Each tag element is associated with a given resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The collection of tags. Each tag element is associated with a given resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By default,
     * clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To
     * require that clients use a custom domain name to invoke your API, disable the default endpoint.
     * </p>
     * 
     * @return Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By
     *         default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com
     *         endpoint. To require that clients use a custom domain name to invoke your API, disable the default
     *         endpoint.
     */
    public final Boolean disableExecuteApiEndpoint() {
        return disableExecuteApiEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(hasWarnings() ? warnings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBinaryMediaTypes() ? binaryMediaTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minimumCompressionSize());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeySourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(disableExecuteApiEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestApiResponse)) {
            return false;
        }
        CreateRestApiResponse other = (CreateRestApiResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(version(), other.version()) && hasWarnings() == other.hasWarnings()
                && Objects.equals(warnings(), other.warnings()) && hasBinaryMediaTypes() == other.hasBinaryMediaTypes()
                && Objects.equals(binaryMediaTypes(), other.binaryMediaTypes())
                && Objects.equals(minimumCompressionSize(), other.minimumCompressionSize())
                && Objects.equals(apiKeySourceAsString(), other.apiKeySourceAsString())
                && Objects.equals(endpointConfiguration(), other.endpointConfiguration())
                && Objects.equals(policy(), other.policy()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(disableExecuteApiEndpoint(), other.disableExecuteApiEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRestApiResponse").add("Id", id()).add("Name", name()).add("Description", description())
                .add("CreatedDate", createdDate()).add("Version", version()).add("Warnings", hasWarnings() ? warnings() : null)
                .add("BinaryMediaTypes", hasBinaryMediaTypes() ? binaryMediaTypes() : null)
                .add("MinimumCompressionSize", minimumCompressionSize()).add("ApiKeySource", apiKeySourceAsString())
                .add("EndpointConfiguration", endpointConfiguration()).add("Policy", policy())
                .add("Tags", hasTags() ? tags() : null).add("DisableExecuteApiEndpoint", disableExecuteApiEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        case "binaryMediaTypes":
            return Optional.ofNullable(clazz.cast(binaryMediaTypes()));
        case "minimumCompressionSize":
            return Optional.ofNullable(clazz.cast(minimumCompressionSize()));
        case "apiKeySource":
            return Optional.ofNullable(clazz.cast(apiKeySourceAsString()));
        case "endpointConfiguration":
            return Optional.ofNullable(clazz.cast(endpointConfiguration()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "disableExecuteApiEndpoint":
            return Optional.ofNullable(clazz.cast(disableExecuteApiEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRestApiResponse, T> g) {
        return obj -> g.apply((CreateRestApiResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRestApiResponse> {
        /**
         * <p>
         * The API's identifier. This identifier is unique across all of your APIs in API Gateway.
         * </p>
         * 
         * @param id
         *        The API's identifier. This identifier is unique across all of your APIs in API Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The API's name.
         * </p>
         * 
         * @param name
         *        The API's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The API's description.
         * </p>
         * 
         * @param description
         *        The API's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp when the API was created.
         * </p>
         * 
         * @param createdDate
         *        The timestamp when the API was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * A version identifier for the API.
         * </p>
         * 
         * @param version
         *        A version identifier for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The warning messages reported when <code>failonwarnings</code> is turned on during API import.
         * </p>
         * 
         * @param warnings
         *        The warning messages reported when <code>failonwarnings</code> is turned on during API import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<String> warnings);

        /**
         * <p>
         * The warning messages reported when <code>failonwarnings</code> is turned on during API import.
         * </p>
         * 
         * @param warnings
         *        The warning messages reported when <code>failonwarnings</code> is turned on during API import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(String... warnings);

        /**
         * <p>
         * The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only
         * UTF-8-encoded text payloads.
         * </p>
         * 
         * @param binaryMediaTypes
         *        The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a>
         *        supports only UTF-8-encoded text payloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binaryMediaTypes(Collection<String> binaryMediaTypes);

        /**
         * <p>
         * The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only
         * UTF-8-encoded text payloads.
         * </p>
         * 
         * @param binaryMediaTypes
         *        The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a>
         *        supports only UTF-8-encoded text payloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binaryMediaTypes(String... binaryMediaTypes);

        /**
         * <p>
         * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes,
         * inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or
         * decompression is not applied on the payload if the payload size is smaller than this value. Setting it to
         * zero allows compression for any payload size.
         * </p>
         * 
         * @param minimumCompressionSize
         *        A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M)
         *        bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled,
         *        compression or decompression is not applied on the payload if the payload size is smaller than this
         *        value. Setting it to zero allows compression for any payload size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumCompressionSize(Integer minimumCompressionSize);

        /**
         * <p>
         * The source of the API key for metering requests according to a usage plan. Valid values are:
         * <ul>
         * <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
         * <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
         * authorizer.</li>
         * </ul>
         * </p>
         * 
         * @param apiKeySource
         *        The source of the API key for metering requests according to a usage plan. Valid values are:
         *        <ul>
         *        <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
         *        <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
         *        authorizer.</li>
         *        </ul>
         * @see ApiKeySourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiKeySourceType
         */
        Builder apiKeySource(String apiKeySource);

        /**
         * <p>
         * The source of the API key for metering requests according to a usage plan. Valid values are:
         * <ul>
         * <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
         * <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
         * authorizer.</li>
         * </ul>
         * </p>
         * 
         * @param apiKeySource
         *        The source of the API key for metering requests according to a usage plan. Valid values are:
         *        <ul>
         *        <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
         *        <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
         *        authorizer.</li>
         *        </ul>
         * @see ApiKeySourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiKeySourceType
         */
        Builder apiKeySource(ApiKeySourceType apiKeySource);

        /**
         * <p>
         * The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
         * </p>
         * 
         * @param endpointConfiguration
         *        The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfiguration(EndpointConfiguration endpointConfiguration);

        /**
         * <p>
         * The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndpointConfiguration.Builder} avoiding
         * the need to create one manually via {@link EndpointConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #endpointConfiguration(EndpointConfiguration)}.
         * 
         * @param endpointConfiguration
         *        a consumer that will call methods on {@link EndpointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfiguration(EndpointConfiguration)
         */
        default Builder endpointConfiguration(Consumer<EndpointConfiguration.Builder> endpointConfiguration) {
            return endpointConfiguration(EndpointConfiguration.builder().applyMutation(endpointConfiguration).build());
        }

        /**
         * <p>
         * A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a>
         * configuration.
         * </p>
         * 
         * @param policy
         *        A stringified JSON policy document that applies to this RestApi regardless of the caller and
         *        <a>Method</a> configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The collection of tags. Each tag element is associated with a given resource.
         * </p>
         * 
         * @param tags
         *        The collection of tags. Each tag element is associated with a given resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint. By
         * default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com
         * endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
         * </p>
         * 
         * @param disableExecuteApiEndpoint
         *        Specifies whether clients can invoke your API by using the default <code>execute-api</code> endpoint.
         *        By default, clients can invoke your API with the default
         *        https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom
         *        domain name to invoke your API, disable the default endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private Instant createdDate;

        private String version;

        private List<String> warnings = DefaultSdkAutoConstructList.getInstance();

        private List<String> binaryMediaTypes = DefaultSdkAutoConstructList.getInstance();

        private Integer minimumCompressionSize;

        private String apiKeySource;

        private EndpointConfiguration endpointConfiguration;

        private String policy;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Boolean disableExecuteApiEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestApiResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            description(model.description);
            createdDate(model.createdDate);
            version(model.version);
            warnings(model.warnings);
            binaryMediaTypes(model.binaryMediaTypes);
            minimumCompressionSize(model.minimumCompressionSize);
            apiKeySource(model.apiKeySource);
            endpointConfiguration(model.endpointConfiguration);
            policy(model.policy);
            tags(model.tags);
            disableExecuteApiEndpoint(model.disableExecuteApiEndpoint);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        @Transient
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getWarnings() {
            if (warnings instanceof SdkAutoConstructList) {
                return null;
            }
            return warnings;
        }

        public final void setWarnings(Collection<String> warnings) {
            this.warnings = ListOfStringCopier.copy(warnings);
        }

        @Override
        @Transient
        public final Builder warnings(Collection<String> warnings) {
            this.warnings = ListOfStringCopier.copy(warnings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder warnings(String... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        public final Collection<String> getBinaryMediaTypes() {
            if (binaryMediaTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return binaryMediaTypes;
        }

        public final void setBinaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = ListOfStringCopier.copy(binaryMediaTypes);
        }

        @Override
        @Transient
        public final Builder binaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = ListOfStringCopier.copy(binaryMediaTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder binaryMediaTypes(String... binaryMediaTypes) {
            binaryMediaTypes(Arrays.asList(binaryMediaTypes));
            return this;
        }

        public final Integer getMinimumCompressionSize() {
            return minimumCompressionSize;
        }

        public final void setMinimumCompressionSize(Integer minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
        }

        @Override
        @Transient
        public final Builder minimumCompressionSize(Integer minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        public final String getApiKeySource() {
            return apiKeySource;
        }

        public final void setApiKeySource(String apiKeySource) {
            this.apiKeySource = apiKeySource;
        }

        @Override
        @Transient
        public final Builder apiKeySource(String apiKeySource) {
            this.apiKeySource = apiKeySource;
            return this;
        }

        @Override
        @Transient
        public final Builder apiKeySource(ApiKeySourceType apiKeySource) {
            this.apiKeySource(apiKeySource == null ? null : apiKeySource.toString());
            return this;
        }

        public final EndpointConfiguration.Builder getEndpointConfiguration() {
            return endpointConfiguration != null ? endpointConfiguration.toBuilder() : null;
        }

        public final void setEndpointConfiguration(EndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        @Transient
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        public final Boolean getDisableExecuteApiEndpoint() {
            return disableExecuteApiEndpoint;
        }

        public final void setDisableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
        }

        @Override
        @Transient
        public final Builder disableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        @Override
        public CreateRestApiResponse build() {
            return new CreateRestApiResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
