/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Import documentation parts from an external (e.g., OpenAPI) definition file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportDocumentationPartsRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<ImportDocumentationPartsRequest.Builder, ImportDocumentationPartsRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(ImportDocumentationPartsRequest::restApiId))
            .setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(ImportDocumentationPartsRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("mode").build()).build();

    private static final SdkField<Boolean> FAIL_ON_WARNINGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("failOnWarnings").getter(getter(ImportDocumentationPartsRequest::failOnWarnings))
            .setter(setter(Builder::failOnWarnings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("failonwarnings").build())
            .build();

    private static final SdkField<SdkBytes> BODY_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("body")
            .getter(getter(ImportDocumentationPartsRequest::body))
            .setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, MODE_FIELD,
            FAIL_ON_WARNINGS_FIELD, BODY_FIELD));

    private final String restApiId;

    private final String mode;

    private final Boolean failOnWarnings;

    private final SdkBytes body;

    private ImportDocumentationPartsRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.mode = builder.mode;
        this.failOnWarnings = builder.failOnWarnings;
        this.body = builder.body;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing
     * <a>DocumentationParts</a> definition or to merge (<code>MERGE</code>) the new definition into the existing one.
     * The default value is <code>MERGE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link PutMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing
     *         <a>DocumentationParts</a> definition or to merge (<code>MERGE</code>) the new definition into the
     *         existing one. The default value is <code>MERGE</code>.
     * @see PutMode
     */
    public final PutMode mode() {
        return PutMode.fromValue(mode);
    }

    /**
     * <p>
     * A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing
     * <a>DocumentationParts</a> definition or to merge (<code>MERGE</code>) the new definition into the existing one.
     * The default value is <code>MERGE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link PutMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing
     *         <a>DocumentationParts</a> definition or to merge (<code>MERGE</code>) the new definition into the
     *         existing one. The default value is <code>MERGE</code>.
     * @see PutMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * A query parameter to specify whether to rollback the documentation importation (<code>true</code>) or not (
     * <code>false</code>) when a warning is encountered. The default value is <code>false</code>.
     * </p>
     * 
     * @return A query parameter to specify whether to rollback the documentation importation (<code>true</code>) or not
     *         (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.
     */
    public final Boolean failOnWarnings() {
        return failOnWarnings;
    }

    /**
     * <p>
     * [Required] Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file,
     * this is a JSON object.
     * </p>
     * 
     * @return [Required] Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI
     *         file, this is a JSON object.
     */
    public final SdkBytes body() {
        return body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failOnWarnings());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportDocumentationPartsRequest)) {
            return false;
        }
        ImportDocumentationPartsRequest other = (ImportDocumentationPartsRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(failOnWarnings(), other.failOnWarnings()) && Objects.equals(body(), other.body());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportDocumentationPartsRequest").add("RestApiId", restApiId()).add("Mode", modeAsString())
                .add("FailOnWarnings", failOnWarnings()).add("Body", body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "failOnWarnings":
            return Optional.ofNullable(clazz.cast(failOnWarnings()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportDocumentationPartsRequest, T> g) {
        return obj -> g.apply((ImportDocumentationPartsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportDocumentationPartsRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing
         * <a>DocumentationParts</a> definition or to merge (<code>MERGE</code>) the new definition into the existing
         * one. The default value is <code>MERGE</code>.
         * </p>
         * 
         * @param mode
         *        A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing
         *        <a>DocumentationParts</a> definition or to merge (<code>MERGE</code>) the new definition into the
         *        existing one. The default value is <code>MERGE</code>.
         * @see PutMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PutMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing
         * <a>DocumentationParts</a> definition or to merge (<code>MERGE</code>) the new definition into the existing
         * one. The default value is <code>MERGE</code>.
         * </p>
         * 
         * @param mode
         *        A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing
         *        <a>DocumentationParts</a> definition or to merge (<code>MERGE</code>) the new definition into the
         *        existing one. The default value is <code>MERGE</code>.
         * @see PutMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PutMode
         */
        Builder mode(PutMode mode);

        /**
         * <p>
         * A query parameter to specify whether to rollback the documentation importation (<code>true</code>) or not (
         * <code>false</code>) when a warning is encountered. The default value is <code>false</code>.
         * </p>
         * 
         * @param failOnWarnings
         *        A query parameter to specify whether to rollback the documentation importation (<code>true</code>) or
         *        not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failOnWarnings(Boolean failOnWarnings);

        /**
         * <p>
         * [Required] Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI
         * file, this is a JSON object.
         * </p>
         * 
         * @param body
         *        [Required] Raw byte array representing the to-be-imported documentation parts. To import from an
         *        OpenAPI file, this is a JSON object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(SdkBytes body);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String mode;

        private Boolean failOnWarnings;

        private SdkBytes body;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportDocumentationPartsRequest model) {
            super(model);
            restApiId(model.restApiId);
            mode(model.mode);
            failOnWarnings(model.failOnWarnings);
            body(model.body);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(PutMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Boolean getFailOnWarnings() {
            return failOnWarnings;
        }

        public final void setFailOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
        }

        @Override
        public final Builder failOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        public final ByteBuffer getBody() {
            return body == null ? null : body.asByteBuffer();
        }

        public final void setBody(ByteBuffer body) {
            body(body == null ? null : SdkBytes.fromByteBuffer(body));
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = body;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportDocumentationPartsRequest build() {
            return new ImportDocumentationPartsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
