/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to get information about the current <a>ApiKeys</a> resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApiKeysRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetApiKeysRequest.Builder, GetApiKeysRequest> {
    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("position").getter(getter(GetApiKeysRequest::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("position").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(GetApiKeysRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> NAME_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nameQuery").getter(getter(GetApiKeysRequest::nameQuery)).setter(setter(Builder::nameQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();

    private static final SdkField<String> CUSTOMER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerId").getter(getter(GetApiKeysRequest::customerId)).setter(setter(Builder::customerId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("customerId").build()).build();

    private static final SdkField<Boolean> INCLUDE_VALUES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeValues").getter(getter(GetApiKeysRequest::includeValues)).setter(setter(Builder::includeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeValues").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITION_FIELD, LIMIT_FIELD,
            NAME_QUERY_FIELD, CUSTOMER_ID_FIELD, INCLUDE_VALUES_FIELD));

    private final String position;

    private final Integer limit;

    private final String nameQuery;

    private final String customerId;

    private final Boolean includeValues;

    private GetApiKeysRequest(BuilderImpl builder) {
        super(builder);
        this.position = builder.position;
        this.limit = builder.limit;
        this.nameQuery = builder.nameQuery;
        this.customerId = builder.customerId;
        this.includeValues = builder.includeValues;
    }

    /**
     * <p>
     * The current pagination position in the paged result set.
     * </p>
     * 
     * @return The current pagination position in the paged result set.
     */
    public final String position() {
        return position;
    }

    /**
     * <p>
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     * </p>
     * 
     * @return The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The name of queried API keys.
     * </p>
     * 
     * @return The name of queried API keys.
     */
    public final String nameQuery() {
        return nameQuery;
    }

    /**
     * <p>
     * The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.
     * </p>
     * 
     * @return The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.
     */
    public final String customerId() {
        return customerId;
    }

    /**
     * <p>
     * A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key values.
     * </p>
     * 
     * @return A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key
     *         values.
     */
    public final Boolean includeValues() {
        return includeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nameQuery());
        hashCode = 31 * hashCode + Objects.hashCode(customerId());
        hashCode = 31 * hashCode + Objects.hashCode(includeValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApiKeysRequest)) {
            return false;
        }
        GetApiKeysRequest other = (GetApiKeysRequest) obj;
        return Objects.equals(position(), other.position()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nameQuery(), other.nameQuery()) && Objects.equals(customerId(), other.customerId())
                && Objects.equals(includeValues(), other.includeValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApiKeysRequest").add("Position", position()).add("Limit", limit())
                .add("NameQuery", nameQuery()).add("CustomerId", customerId()).add("IncludeValues", includeValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "nameQuery":
            return Optional.ofNullable(clazz.cast(nameQuery()));
        case "customerId":
            return Optional.ofNullable(clazz.cast(customerId()));
        case "includeValues":
            return Optional.ofNullable(clazz.cast(includeValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApiKeysRequest, T> g) {
        return obj -> g.apply((GetApiKeysRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetApiKeysRequest> {
        /**
         * <p>
         * The current pagination position in the paged result set.
         * </p>
         * 
         * @param position
         *        The current pagination position in the paged result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         * </p>
         * 
         * @param limit
         *        The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The name of queried API keys.
         * </p>
         * 
         * @param nameQuery
         *        The name of queried API keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameQuery(String nameQuery);

        /**
         * <p>
         * The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.
         * </p>
         * 
         * @param customerId
         *        The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerId(String customerId);

        /**
         * <p>
         * A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key
         * values.
         * </p>
         * 
         * @param includeValues
         *        A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains
         *        key values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeValues(Boolean includeValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String position;

        private Integer limit;

        private String nameQuery;

        private String customerId;

        private Boolean includeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApiKeysRequest model) {
            super(model);
            position(model.position);
            limit(model.limit);
            nameQuery(model.nameQuery);
            customerId(model.customerId);
            includeValues(model.includeValues);
        }

        public final String getPosition() {
            return position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNameQuery() {
            return nameQuery;
        }

        public final void setNameQuery(String nameQuery) {
            this.nameQuery = nameQuery;
        }

        @Override
        public final Builder nameQuery(String nameQuery) {
            this.nameQuery = nameQuery;
            return this;
        }

        public final String getCustomerId() {
            return customerId;
        }

        public final void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        @Override
        public final Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public final Boolean getIncludeValues() {
            return includeValues;
        }

        public final void setIncludeValues(Boolean includeValues) {
            this.includeValues = includeValues;
        }

        @Override
        public final Builder includeValues(Boolean includeValues) {
            this.includeValues = includeValues;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApiKeysRequest build() {
            return new GetApiKeysRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
