/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the usage data of a usage plan.
 * </p>
 * <div class="remarks"/> <div class="seeAlso"> <a
 * href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use
 * Usage Plans</a>, <a href=
 * "https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-usage-plans-with-console.html#api-gateway-usage-plan-manage-usage"
 * >Manage Usage in a Usage Plan</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsageResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetUsageResponse.Builder, GetUsageResponse> {
    private static final SdkField<String> USAGE_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usagePlanId").getter(getter(GetUsageResponse::usagePlanId)).setter(setter(Builder::usagePlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usagePlanId").build()).build();

    private static final SdkField<String> START_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startDate").getter(getter(GetUsageResponse::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()).build();

    private static final SdkField<String> END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endDate").getter(getter(GetUsageResponse::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDate").build()).build();

    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("position").getter(getter(GetUsageResponse::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<Map<String, List<List<Long>>>> ITEMS_FIELD = SdkField
            .<Map<String, List<List<Long>>>> builder(MarshallingType.MAP)
            .memberName("items")
            .getter(getter(GetUsageResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<List<Long>>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<List<Long>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<Long> builder(
                                                                                                            MarshallingType.LONG)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_PLAN_ID_FIELD,
            START_DATE_FIELD, END_DATE_FIELD, POSITION_FIELD, ITEMS_FIELD));

    private final String usagePlanId;

    private final String startDate;

    private final String endDate;

    private final String position;

    private final Map<String, List<List<Long>>> items;

    private GetUsageResponse(BuilderImpl builder) {
        super(builder);
        this.usagePlanId = builder.usagePlanId;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.position = builder.position;
        this.items = builder.items;
    }

    /**
     * <p>
     * The plan Id associated with this usage data.
     * </p>
     * 
     * @return The plan Id associated with this usage data.
     */
    public final String usagePlanId() {
        return usagePlanId;
    }

    /**
     * <p>
     * The starting date of the usage data.
     * </p>
     * 
     * @return The starting date of the usage data.
     */
    public final String startDate() {
        return startDate;
    }

    /**
     * <p>
     * The ending date of the usage data.
     * </p>
     * 
     * @return The ending date of the usage data.
     */
    public final String endDate() {
        return endDate;
    }

    /**
     * Returns the value of the Position property for this object.
     * 
     * @return The value of the Position property for this object.
     */
    public final String position() {
        return position;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API
     * keys in a usage plan. For example,
     * <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code>
     * stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over
     *         the API keys in a usage plan. For example,
     *         <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where
     *         <code>{api_key}</code> stands for an API key value and the daily log entry is of the format
     *         <code>[used quota, remaining quota]</code>.
     */
    public final Map<String, List<List<Long>>> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(usagePlanId());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageResponse)) {
            return false;
        }
        GetUsageResponse other = (GetUsageResponse) obj;
        return Objects.equals(usagePlanId(), other.usagePlanId()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(endDate(), other.endDate()) && Objects.equals(position(), other.position())
                && hasItems() == other.hasItems() && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUsageResponse").add("UsagePlanId", usagePlanId()).add("StartDate", startDate())
                .add("EndDate", endDate()).add("Position", position()).add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usagePlanId":
            return Optional.ofNullable(clazz.cast(usagePlanId()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "endDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUsageResponse, T> g) {
        return obj -> g.apply((GetUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUsageResponse> {
        /**
         * <p>
         * The plan Id associated with this usage data.
         * </p>
         * 
         * @param usagePlanId
         *        The plan Id associated with this usage data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePlanId(String usagePlanId);

        /**
         * <p>
         * The starting date of the usage data.
         * </p>
         * 
         * @param startDate
         *        The starting date of the usage data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(String startDate);

        /**
         * <p>
         * The ending date of the usage data.
         * </p>
         * 
         * @param endDate
         *        The ending date of the usage data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(String endDate);

        /**
         * Sets the value of the Position property for this object.
         *
         * @param position
         *        The new value for the Position property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the
         * API keys in a usage plan. For example,
         * <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code>
         * stands for an API key value and the daily log entry is of the format
         * <code>[used quota, remaining quota]</code>.
         * </p>
         * 
         * @param items
         *        The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed
         *        over the API keys in a usage plan. For example,
         *        <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where
         *        <code>{api_key}</code> stands for an API key value and the daily log entry is of the format
         *        <code>[used quota, remaining quota]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Map<String, ? extends Collection<? extends Collection<Long>>> items);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String usagePlanId;

        private String startDate;

        private String endDate;

        private String position;

        private Map<String, List<List<Long>>> items = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageResponse model) {
            super(model);
            usagePlanId(model.usagePlanId);
            startDate(model.startDate);
            endDate(model.endDate);
            position(model.position);
            items(model.items);
        }

        public final String getUsagePlanId() {
            return usagePlanId;
        }

        public final void setUsagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
        }

        @Override
        public final Builder usagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
            return this;
        }

        public final String getStartDate() {
            return startDate;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getEndDate() {
            return endDate;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getPosition() {
            return position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final Map<String, ? extends Collection<? extends Collection<Long>>> getItems() {
            if (items instanceof SdkAutoConstructMap) {
                return null;
            }
            return items;
        }

        public final void setItems(Map<String, ? extends Collection<? extends Collection<Long>>> items) {
            this.items = MapOfKeyUsagesCopier.copy(items);
        }

        @Override
        public final Builder items(Map<String, ? extends Collection<? extends Collection<Long>>> items) {
            this.items = MapOfKeyUsagesCopier.copy(items);
            return this;
        }

        @Override
        public GetUsageResponse build() {
            return new GetUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
