/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response of the test invoke request for a custom <a>Authorizer</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestInvokeAuthorizerResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<TestInvokeAuthorizerResponse.Builder, TestInvokeAuthorizerResponse> {
    private static final SdkField<Integer> CLIENT_STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("clientStatus").getter(getter(TestInvokeAuthorizerResponse::clientStatus))
            .setter(setter(Builder::clientStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientStatus").build()).build();

    private static final SdkField<String> LOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("log")
            .getter(getter(TestInvokeAuthorizerResponse::log)).setter(setter(Builder::log))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("log").build()).build();

    private static final SdkField<Long> LATENCY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("latency")
            .getter(getter(TestInvokeAuthorizerResponse::latency)).setter(setter(Builder::latency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latency").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalId").getter(getter(TestInvokeAuthorizerResponse::principalId))
            .setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalId").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("policy")
            .getter(getter(TestInvokeAuthorizerResponse::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final SdkField<Map<String, List<String>>> AUTHORIZATION_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("authorization")
            .getter(getter(TestInvokeAuthorizerResponse::authorization))
            .setter(setter(Builder::authorization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorization").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, String>> CLAIMS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("claims")
            .getter(getter(TestInvokeAuthorizerResponse::claims))
            .setter(setter(Builder::claims))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claims").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_STATUS_FIELD,
            LOG_FIELD, LATENCY_FIELD, PRINCIPAL_ID_FIELD, POLICY_FIELD, AUTHORIZATION_FIELD, CLAIMS_FIELD));

    private final Integer clientStatus;

    private final String log;

    private final Long latency;

    private final String principalId;

    private final String policy;

    private final Map<String, List<String>> authorization;

    private final Map<String, String> claims;

    private TestInvokeAuthorizerResponse(BuilderImpl builder) {
        super(builder);
        this.clientStatus = builder.clientStatus;
        this.log = builder.log;
        this.latency = builder.latency;
        this.principalId = builder.principalId;
        this.policy = builder.policy;
        this.authorization = builder.authorization;
        this.claims = builder.claims;
    }

    /**
     * <p>
     * The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.
     * </p>
     * 
     * @return The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.
     */
    public final Integer clientStatus() {
        return clientStatus;
    }

    /**
     * <p>
     * The API Gateway execution log for the test authorizer request.
     * </p>
     * 
     * @return The API Gateway execution log for the test authorizer request.
     */
    public final String log() {
        return log;
    }

    /**
     * <p>
     * The execution latency of the test authorizer request.
     * </p>
     * 
     * @return The execution latency of the test authorizer request.
     */
    public final Long latency() {
        return latency;
    }

    /**
     * <p>
     * The principal identity returned by the <a>Authorizer</a>
     * </p>
     * 
     * @return The principal identity returned by the <a>Authorizer</a>
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The JSON policy document returned by the <a>Authorizer</a>
     * </p>
     * 
     * @return The JSON policy document returned by the <a>Authorizer</a>
     */
    public final String policy() {
        return policy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Authorization property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorization() {
        return authorization != null && !(authorization instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Authorization property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorization} method.
     * </p>
     * 
     * @return The value of the Authorization property for this object.
     */
    public final Map<String, List<String>> authorization() {
        return authorization;
    }

    /**
     * For responses, this returns true if the service returned a value for the Claims property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClaims() {
        return claims != null && !(claims instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The <a href="https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity claims</a>, with
     * any supported custom attributes, returned from the Cognito Your User Pool configured for the API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClaims} method.
     * </p>
     * 
     * @return The <a href="https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity
     *         claims</a>, with any supported custom attributes, returned from the Cognito Your User Pool configured for
     *         the API.
     */
    public final Map<String, String> claims() {
        return claims;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientStatus());
        hashCode = 31 * hashCode + Objects.hashCode(log());
        hashCode = 31 * hashCode + Objects.hashCode(latency());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorization() ? authorization() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasClaims() ? claims() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeAuthorizerResponse)) {
            return false;
        }
        TestInvokeAuthorizerResponse other = (TestInvokeAuthorizerResponse) obj;
        return Objects.equals(clientStatus(), other.clientStatus()) && Objects.equals(log(), other.log())
                && Objects.equals(latency(), other.latency()) && Objects.equals(principalId(), other.principalId())
                && Objects.equals(policy(), other.policy()) && hasAuthorization() == other.hasAuthorization()
                && Objects.equals(authorization(), other.authorization()) && hasClaims() == other.hasClaims()
                && Objects.equals(claims(), other.claims());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestInvokeAuthorizerResponse").add("ClientStatus", clientStatus()).add("Log", log())
                .add("Latency", latency()).add("PrincipalId", principalId()).add("Policy", policy())
                .add("Authorization", hasAuthorization() ? authorization() : null).add("Claims", hasClaims() ? claims() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientStatus":
            return Optional.ofNullable(clazz.cast(clientStatus()));
        case "log":
            return Optional.ofNullable(clazz.cast(log()));
        case "latency":
            return Optional.ofNullable(clazz.cast(latency()));
        case "principalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "authorization":
            return Optional.ofNullable(clazz.cast(authorization()));
        case "claims":
            return Optional.ofNullable(clazz.cast(claims()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeAuthorizerResponse, T> g) {
        return obj -> g.apply((TestInvokeAuthorizerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestInvokeAuthorizerResponse> {
        /**
         * <p>
         * The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.
         * </p>
         * 
         * @param clientStatus
         *        The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientStatus(Integer clientStatus);

        /**
         * <p>
         * The API Gateway execution log for the test authorizer request.
         * </p>
         * 
         * @param log
         *        The API Gateway execution log for the test authorizer request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder log(String log);

        /**
         * <p>
         * The execution latency of the test authorizer request.
         * </p>
         * 
         * @param latency
         *        The execution latency of the test authorizer request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latency(Long latency);

        /**
         * <p>
         * The principal identity returned by the <a>Authorizer</a>
         * </p>
         * 
         * @param principalId
         *        The principal identity returned by the <a>Authorizer</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The JSON policy document returned by the <a>Authorizer</a>
         * </p>
         * 
         * @param policy
         *        The JSON policy document returned by the <a>Authorizer</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * Sets the value of the Authorization property for this object.
         *
         * @param authorization
         *        The new value for the Authorization property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorization(Map<String, ? extends Collection<String>> authorization);

        /**
         * <p>
         * The <a href="https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity claims</a>,
         * with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.
         * </p>
         * 
         * @param claims
         *        The <a href="https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity
         *        claims</a>, with any supported custom attributes, returned from the Cognito Your User Pool configured
         *        for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claims(Map<String, String> claims);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private Integer clientStatus;

        private String log;

        private Long latency;

        private String principalId;

        private String policy;

        private Map<String, List<String>> authorization = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> claims = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeAuthorizerResponse model) {
            super(model);
            clientStatus(model.clientStatus);
            log(model.log);
            latency(model.latency);
            principalId(model.principalId);
            policy(model.policy);
            authorization(model.authorization);
            claims(model.claims);
        }

        public final Integer getClientStatus() {
            return clientStatus;
        }

        public final void setClientStatus(Integer clientStatus) {
            this.clientStatus = clientStatus;
        }

        @Override
        public final Builder clientStatus(Integer clientStatus) {
            this.clientStatus = clientStatus;
            return this;
        }

        public final String getLog() {
            return log;
        }

        public final void setLog(String log) {
            this.log = log;
        }

        @Override
        public final Builder log(String log) {
            this.log = log;
            return this;
        }

        public final Long getLatency() {
            return latency;
        }

        public final void setLatency(Long latency) {
            this.latency = latency;
        }

        @Override
        public final Builder latency(Long latency) {
            this.latency = latency;
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getAuthorization() {
            if (authorization instanceof SdkAutoConstructMap) {
                return null;
            }
            return authorization;
        }

        public final void setAuthorization(Map<String, ? extends Collection<String>> authorization) {
            this.authorization = MapOfStringToListCopier.copy(authorization);
        }

        @Override
        public final Builder authorization(Map<String, ? extends Collection<String>> authorization) {
            this.authorization = MapOfStringToListCopier.copy(authorization);
            return this;
        }

        public final Map<String, String> getClaims() {
            if (claims instanceof SdkAutoConstructMap) {
                return null;
            }
            return claims;
        }

        public final void setClaims(Map<String, String> claims) {
            this.claims = MapOfStringToStringCopier.copy(claims);
        }

        @Override
        public final Builder claims(Map<String, String> claims) {
            this.claims = MapOfStringToStringCopier.copy(claims);
            return this;
        }

        @Override
        public TestInvokeAuthorizerResponse build() {
            return new TestInvokeAuthorizerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
