/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a client certificate used to configure client-side SSL authentication while sending requests to the
 * integration endpoint.
 * </p>
 * <div class="remarks">Client certificates are used to authenticate an API by the backend server. To authenticate an
 * API client (or user), use IAM roles and policies, a custom <a>Authorizer</a> or an Amazon Cognito user pool.</div>
 * <div class="seeAlso"> <a href=
 * "https://docs.aws.amazon.com/apigateway/latest/developerguide/getting-started-client-side-ssl-authentication.html"
 * >Use Client-Side Certificate</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClientCertificateResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<UpdateClientCertificateResponse.Builder, UpdateClientCertificateResponse> {
    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientCertificateId").getter(getter(UpdateClientCertificateResponse::clientCertificateId))
            .setter(setter(Builder::clientCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateId").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateClientCertificateResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PEM_ENCODED_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pemEncodedCertificate").getter(getter(UpdateClientCertificateResponse::pemEncodedCertificate))
            .setter(setter(Builder::pemEncodedCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pemEncodedCertificate").build())
            .build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(UpdateClientCertificateResponse::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expirationDate").getter(getter(UpdateClientCertificateResponse::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(UpdateClientCertificateResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CERTIFICATE_ID_FIELD,
            DESCRIPTION_FIELD, PEM_ENCODED_CERTIFICATE_FIELD, CREATED_DATE_FIELD, EXPIRATION_DATE_FIELD, TAGS_FIELD));

    private final String clientCertificateId;

    private final String description;

    private final String pemEncodedCertificate;

    private final Instant createdDate;

    private final Instant expirationDate;

    private final Map<String, String> tags;

    private UpdateClientCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.clientCertificateId = builder.clientCertificateId;
        this.description = builder.description;
        this.pemEncodedCertificate = builder.pemEncodedCertificate;
        this.createdDate = builder.createdDate;
        this.expirationDate = builder.expirationDate;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the client certificate.
     * </p>
     * 
     * @return The identifier of the client certificate.
     */
    public final String clientCertificateId() {
        return clientCertificateId;
    }

    /**
     * <p>
     * The description of the client certificate.
     * </p>
     * 
     * @return The description of the client certificate.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication
     * in the integration endpoint .
     * </p>
     * 
     * @return The PEM-encoded public key of the client certificate, which can be used to configure certificate
     *         authentication in the integration endpoint .
     */
    public final String pemEncodedCertificate() {
        return pemEncodedCertificate;
    }

    /**
     * <p>
     * The timestamp when the client certificate was created.
     * </p>
     * 
     * @return The timestamp when the client certificate was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The timestamp when the client certificate will expire.
     * </p>
     * 
     * @return The timestamp when the client certificate will expire.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The collection of tags. Each tag element is associated with a given resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The collection of tags. Each tag element is associated with a given resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(pemEncodedCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClientCertificateResponse)) {
            return false;
        }
        UpdateClientCertificateResponse other = (UpdateClientCertificateResponse) obj;
        return Objects.equals(clientCertificateId(), other.clientCertificateId())
                && Objects.equals(description(), other.description())
                && Objects.equals(pemEncodedCertificate(), other.pemEncodedCertificate())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(expirationDate(), other.expirationDate())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClientCertificateResponse").add("ClientCertificateId", clientCertificateId())
                .add("Description", description()).add("PemEncodedCertificate", pemEncodedCertificate())
                .add("CreatedDate", createdDate()).add("ExpirationDate", expirationDate()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientCertificateId":
            return Optional.ofNullable(clazz.cast(clientCertificateId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "pemEncodedCertificate":
            return Optional.ofNullable(clazz.cast(pemEncodedCertificate()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "expirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClientCertificateResponse, T> g) {
        return obj -> g.apply((UpdateClientCertificateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateClientCertificateResponse> {
        /**
         * <p>
         * The identifier of the client certificate.
         * </p>
         * 
         * @param clientCertificateId
         *        The identifier of the client certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateId(String clientCertificateId);

        /**
         * <p>
         * The description of the client certificate.
         * </p>
         * 
         * @param description
         *        The description of the client certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The PEM-encoded public key of the client certificate, which can be used to configure certificate
         * authentication in the integration endpoint .
         * </p>
         * 
         * @param pemEncodedCertificate
         *        The PEM-encoded public key of the client certificate, which can be used to configure certificate
         *        authentication in the integration endpoint .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pemEncodedCertificate(String pemEncodedCertificate);

        /**
         * <p>
         * The timestamp when the client certificate was created.
         * </p>
         * 
         * @param createdDate
         *        The timestamp when the client certificate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The timestamp when the client certificate will expire.
         * </p>
         * 
         * @param expirationDate
         *        The timestamp when the client certificate will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * The collection of tags. Each tag element is associated with a given resource.
         * </p>
         * 
         * @param tags
         *        The collection of tags. Each tag element is associated with a given resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String clientCertificateId;

        private String description;

        private String pemEncodedCertificate;

        private Instant createdDate;

        private Instant expirationDate;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClientCertificateResponse model) {
            super(model);
            clientCertificateId(model.clientCertificateId);
            description(model.description);
            pemEncodedCertificate(model.pemEncodedCertificate);
            createdDate(model.createdDate);
            expirationDate(model.expirationDate);
            tags(model.tags);
        }

        public final String getClientCertificateId() {
            return clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getPemEncodedCertificate() {
            return pemEncodedCertificate;
        }

        @Override
        public final Builder pemEncodedCertificate(String pemEncodedCertificate) {
            this.pemEncodedCertificate = pemEncodedCertificate;
            return this;
        }

        public final void setPemEncodedCertificate(String pemEncodedCertificate) {
            this.pemEncodedCertificate = pemEncodedCertificate;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public UpdateClientCertificateResponse build() {
            return new UpdateClientCertificateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
