/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the TLS configuration for an integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TlsConfig implements SdkPojo, Serializable, ToCopyableBuilder<TlsConfig.Builder, TlsConfig> {
    private static final SdkField<Boolean> INSECURE_SKIP_VERIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("insecureSkipVerification").getter(getter(TlsConfig::insecureSkipVerification))
            .setter(setter(Builder::insecureSkipVerification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insecureSkipVerification").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INSECURE_SKIP_VERIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean insecureSkipVerification;

    private TlsConfig(BuilderImpl builder) {
        this.insecureSkipVerification = builder.insecureSkipVerification;
    }

    /**
     * <p>
     * Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is
     * issued by a supported certificate authority. This isn’t recommended, but it enables you to use certificates that
     * are signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway
     * still performs basic certificate validation, which includes checking the certificate's expiration date, hostname,
     * and presence of a root certificate authority. Supported only for <code>HTTP</code> and <code>HTTP_PROXY</code>
     * integrations.
     * </p>
     * 
     * @return Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint
     *         is issued by a supported certificate authority. This isn’t recommended, but it enables you to use
     *         certificates that are signed by private certificate authorities, or certificates that are self-signed. If
     *         enabled, API Gateway still performs basic certificate validation, which includes checking the
     *         certificate's expiration date, hostname, and presence of a root certificate authority. Supported only for
     *         <code>HTTP</code> and <code>HTTP_PROXY</code> integrations.
     */
    public final Boolean insecureSkipVerification() {
        return insecureSkipVerification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(insecureSkipVerification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TlsConfig)) {
            return false;
        }
        TlsConfig other = (TlsConfig) obj;
        return Objects.equals(insecureSkipVerification(), other.insecureSkipVerification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TlsConfig").add("InsecureSkipVerification", insecureSkipVerification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "insecureSkipVerification":
            return Optional.ofNullable(clazz.cast(insecureSkipVerification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TlsConfig, T> g) {
        return obj -> g.apply((TlsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TlsConfig> {
        /**
         * <p>
         * Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is
         * issued by a supported certificate authority. This isn’t recommended, but it enables you to use certificates
         * that are signed by private certificate authorities, or certificates that are self-signed. If enabled, API
         * Gateway still performs basic certificate validation, which includes checking the certificate's expiration
         * date, hostname, and presence of a root certificate authority. Supported only for <code>HTTP</code> and
         * <code>HTTP_PROXY</code> integrations.
         * </p>
         * 
         * @param insecureSkipVerification
         *        Specifies whether or not API Gateway skips verification that the certificate for an integration
         *        endpoint is issued by a supported certificate authority. This isn’t recommended, but it enables you to
         *        use certificates that are signed by private certificate authorities, or certificates that are
         *        self-signed. If enabled, API Gateway still performs basic certificate validation, which includes
         *        checking the certificate's expiration date, hostname, and presence of a root certificate authority.
         *        Supported only for <code>HTTP</code> and <code>HTTP_PROXY</code> integrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insecureSkipVerification(Boolean insecureSkipVerification);
    }

    static final class BuilderImpl implements Builder {
        private Boolean insecureSkipVerification;

        private BuilderImpl() {
        }

        private BuilderImpl(TlsConfig model) {
            insecureSkipVerification(model.insecureSkipVerification);
        }

        public final Boolean getInsecureSkipVerification() {
            return insecureSkipVerification;
        }

        public final void setInsecureSkipVerification(Boolean insecureSkipVerification) {
            this.insecureSkipVerification = insecureSkipVerification;
        }

        @Override
        public final Builder insecureSkipVerification(Boolean insecureSkipVerification) {
            this.insecureSkipVerification = insecureSkipVerification;
            return this;
        }

        @Override
        public TlsConfig build() {
            return new TlsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
