/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the method setting properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MethodSetting implements SdkPojo, Serializable, ToCopyableBuilder<MethodSetting.Builder, MethodSetting> {
    private static final SdkField<Boolean> METRICS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("metricsEnabled").getter(getter(MethodSetting::metricsEnabled)).setter(setter(Builder::metricsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsEnabled").build()).build();

    private static final SdkField<String> LOGGING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("loggingLevel").getter(getter(MethodSetting::loggingLevel)).setter(setter(Builder::loggingLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingLevel").build()).build();

    private static final SdkField<Boolean> DATA_TRACE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("dataTraceEnabled").getter(getter(MethodSetting::dataTraceEnabled))
            .setter(setter(Builder::dataTraceEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTraceEnabled").build()).build();

    private static final SdkField<Integer> THROTTLING_BURST_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("throttlingBurstLimit").getter(getter(MethodSetting::throttlingBurstLimit))
            .setter(setter(Builder::throttlingBurstLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throttlingBurstLimit").build())
            .build();

    private static final SdkField<Double> THROTTLING_RATE_LIMIT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("throttlingRateLimit").getter(getter(MethodSetting::throttlingRateLimit))
            .setter(setter(Builder::throttlingRateLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throttlingRateLimit").build())
            .build();

    private static final SdkField<Boolean> CACHING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("cachingEnabled").getter(getter(MethodSetting::cachingEnabled)).setter(setter(Builder::cachingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cachingEnabled").build()).build();

    private static final SdkField<Integer> CACHE_TTL_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("cacheTtlInSeconds").getter(getter(MethodSetting::cacheTtlInSeconds))
            .setter(setter(Builder::cacheTtlInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheTtlInSeconds").build()).build();

    private static final SdkField<Boolean> CACHE_DATA_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("cacheDataEncrypted").getter(getter(MethodSetting::cacheDataEncrypted))
            .setter(setter(Builder::cacheDataEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheDataEncrypted").build())
            .build();

    private static final SdkField<Boolean> REQUIRE_AUTHORIZATION_FOR_CACHE_CONTROL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("requireAuthorizationForCacheControl")
            .getter(getter(MethodSetting::requireAuthorizationForCacheControl))
            .setter(setter(Builder::requireAuthorizationForCacheControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("requireAuthorizationForCacheControl").build()).build();

    private static final SdkField<String> UNAUTHORIZED_CACHE_CONTROL_HEADER_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("unauthorizedCacheControlHeaderStrategy")
            .getter(getter(MethodSetting::unauthorizedCacheControlHeaderStrategyAsString))
            .setter(setter(Builder::unauthorizedCacheControlHeaderStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("unauthorizedCacheControlHeaderStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_ENABLED_FIELD,
            LOGGING_LEVEL_FIELD, DATA_TRACE_ENABLED_FIELD, THROTTLING_BURST_LIMIT_FIELD, THROTTLING_RATE_LIMIT_FIELD,
            CACHING_ENABLED_FIELD, CACHE_TTL_IN_SECONDS_FIELD, CACHE_DATA_ENCRYPTED_FIELD,
            REQUIRE_AUTHORIZATION_FOR_CACHE_CONTROL_FIELD, UNAUTHORIZED_CACHE_CONTROL_HEADER_STRATEGY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean metricsEnabled;

    private final String loggingLevel;

    private final Boolean dataTraceEnabled;

    private final Integer throttlingBurstLimit;

    private final Double throttlingRateLimit;

    private final Boolean cachingEnabled;

    private final Integer cacheTtlInSeconds;

    private final Boolean cacheDataEncrypted;

    private final Boolean requireAuthorizationForCacheControl;

    private final String unauthorizedCacheControlHeaderStrategy;

    private MethodSetting(BuilderImpl builder) {
        this.metricsEnabled = builder.metricsEnabled;
        this.loggingLevel = builder.loggingLevel;
        this.dataTraceEnabled = builder.dataTraceEnabled;
        this.throttlingBurstLimit = builder.throttlingBurstLimit;
        this.throttlingRateLimit = builder.throttlingRateLimit;
        this.cachingEnabled = builder.cachingEnabled;
        this.cacheTtlInSeconds = builder.cacheTtlInSeconds;
        this.cacheDataEncrypted = builder.cacheDataEncrypted;
        this.requireAuthorizationForCacheControl = builder.requireAuthorizationForCacheControl;
        this.unauthorizedCacheControlHeaderStrategy = builder.unauthorizedCacheControlHeaderStrategy;
    }

    /**
     * <p>
     * Specifies whether Amazon CloudWatch metrics are enabled for this method. The PATCH path for this setting is
     * <code>/{method_setting_key}/metrics/enabled</code>, and the value is a Boolean.
     * </p>
     * 
     * @return Specifies whether Amazon CloudWatch metrics are enabled for this method. The PATCH path for this setting
     *         is <code>/{method_setting_key}/metrics/enabled</code>, and the value is a Boolean.
     */
    public final Boolean metricsEnabled() {
        return metricsEnabled;
    }

    /**
     * <p>
     * Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. The
     * PATCH path for this setting is <code>/{method_setting_key}/logging/loglevel</code>, and the available levels are
     * <code>OFF</code>, <code>ERROR</code>, and <code>INFO</code>. Choose <code>ERROR</code> to write only error-level
     * entries to CloudWatch Logs, or choose <code>INFO</code> to include all <code>ERROR</code> events as well as extra
     * informational events.
     * </p>
     * 
     * @return Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch
     *         Logs. The PATCH path for this setting is <code>/{method_setting_key}/logging/loglevel</code>, and the
     *         available levels are <code>OFF</code>, <code>ERROR</code>, and <code>INFO</code>. Choose
     *         <code>ERROR</code> to write only error-level entries to CloudWatch Logs, or choose <code>INFO</code> to
     *         include all <code>ERROR</code> events as well as extra informational events.
     */
    public final String loggingLevel() {
        return loggingLevel;
    }

    /**
     * <p>
     * Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon
     * CloudWatch Logs. The PATCH path for this setting is <code>/{method_setting_key}/logging/dataTrace</code>, and the
     * value is a Boolean.
     * </p>
     * 
     * @return Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to
     *         Amazon CloudWatch Logs. The PATCH path for this setting is
     *         <code>/{method_setting_key}/logging/dataTrace</code>, and the value is a Boolean.
     */
    public final Boolean dataTraceEnabled() {
        return dataTraceEnabled;
    }

    /**
     * <p>
     * Specifies the throttling burst limit. The PATCH path for this setting is
     * <code>/{method_setting_key}/throttling/burstLimit</code>, and the value is an integer.
     * </p>
     * 
     * @return Specifies the throttling burst limit. The PATCH path for this setting is
     *         <code>/{method_setting_key}/throttling/burstLimit</code>, and the value is an integer.
     */
    public final Integer throttlingBurstLimit() {
        return throttlingBurstLimit;
    }

    /**
     * <p>
     * Specifies the throttling rate limit. The PATCH path for this setting is
     * <code>/{method_setting_key}/throttling/rateLimit</code>, and the value is a double.
     * </p>
     * 
     * @return Specifies the throttling rate limit. The PATCH path for this setting is
     *         <code>/{method_setting_key}/throttling/rateLimit</code>, and the value is a double.
     */
    public final Double throttlingRateLimit() {
        return throttlingRateLimit;
    }

    /**
     * <p>
     * Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the
     * stage for responses to be cached. The PATCH path for this setting is
     * <code>/{method_setting_key}/caching/enabled</code>, and the value is a Boolean.
     * </p>
     * 
     * @return Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled
     *         on the stage for responses to be cached. The PATCH path for this setting is
     *         <code>/{method_setting_key}/caching/enabled</code>, and the value is a Boolean.
     */
    public final Boolean cachingEnabled() {
        return cachingEnabled;
    }

    /**
     * <p>
     * Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response
     * will be cached. The PATCH path for this setting is <code>/{method_setting_key}/caching/ttlInSeconds</code>, and
     * the value is an integer.
     * </p>
     * 
     * @return Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the
     *         response will be cached. The PATCH path for this setting is
     *         <code>/{method_setting_key}/caching/ttlInSeconds</code>, and the value is an integer.
     */
    public final Integer cacheTtlInSeconds() {
        return cacheTtlInSeconds;
    }

    /**
     * <p>
     * Specifies whether the cached responses are encrypted. The PATCH path for this setting is
     * <code>/{method_setting_key}/caching/dataEncrypted</code>, and the value is a Boolean.
     * </p>
     * 
     * @return Specifies whether the cached responses are encrypted. The PATCH path for this setting is
     *         <code>/{method_setting_key}/caching/dataEncrypted</code>, and the value is a Boolean.
     */
    public final Boolean cacheDataEncrypted() {
        return cacheDataEncrypted;
    }

    /**
     * <p>
     * Specifies whether authorization is required for a cache invalidation request. The PATCH path for this setting is
     * <code>/{method_setting_key}/caching/requireAuthorizationForCacheControl</code>, and the value is a Boolean.
     * </p>
     * 
     * @return Specifies whether authorization is required for a cache invalidation request. The PATCH path for this
     *         setting is <code>/{method_setting_key}/caching/requireAuthorizationForCacheControl</code>, and the value
     *         is a Boolean.
     */
    public final Boolean requireAuthorizationForCacheControl() {
        return requireAuthorizationForCacheControl;
    }

    /**
     * <p>
     * Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting is
     * <code>/{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy</code>, and the available values are
     * <code>FAIL_WITH_403</code>, <code>SUCCEED_WITH_RESPONSE_HEADER</code>,
     * <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #unauthorizedCacheControlHeaderStrategy} will return
     * {@link UnauthorizedCacheControlHeaderStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #unauthorizedCacheControlHeaderStrategyAsString}.
     * </p>
     * 
     * @return Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting is
     *         <code>/{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy</code>, and the available
     *         values are <code>FAIL_WITH_403</code>, <code>SUCCEED_WITH_RESPONSE_HEADER</code>,
     *         <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>.
     * @see UnauthorizedCacheControlHeaderStrategy
     */
    public final UnauthorizedCacheControlHeaderStrategy unauthorizedCacheControlHeaderStrategy() {
        return UnauthorizedCacheControlHeaderStrategy.fromValue(unauthorizedCacheControlHeaderStrategy);
    }

    /**
     * <p>
     * Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting is
     * <code>/{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy</code>, and the available values are
     * <code>FAIL_WITH_403</code>, <code>SUCCEED_WITH_RESPONSE_HEADER</code>,
     * <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #unauthorizedCacheControlHeaderStrategy} will return
     * {@link UnauthorizedCacheControlHeaderStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #unauthorizedCacheControlHeaderStrategyAsString}.
     * </p>
     * 
     * @return Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting is
     *         <code>/{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy</code>, and the available
     *         values are <code>FAIL_WITH_403</code>, <code>SUCCEED_WITH_RESPONSE_HEADER</code>,
     *         <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>.
     * @see UnauthorizedCacheControlHeaderStrategy
     */
    public final String unauthorizedCacheControlHeaderStrategyAsString() {
        return unauthorizedCacheControlHeaderStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(loggingLevel());
        hashCode = 31 * hashCode + Objects.hashCode(dataTraceEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(throttlingBurstLimit());
        hashCode = 31 * hashCode + Objects.hashCode(throttlingRateLimit());
        hashCode = 31 * hashCode + Objects.hashCode(cachingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cacheTtlInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(cacheDataEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(requireAuthorizationForCacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(unauthorizedCacheControlHeaderStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MethodSetting)) {
            return false;
        }
        MethodSetting other = (MethodSetting) obj;
        return Objects.equals(metricsEnabled(), other.metricsEnabled())
                && Objects.equals(loggingLevel(), other.loggingLevel())
                && Objects.equals(dataTraceEnabled(), other.dataTraceEnabled())
                && Objects.equals(throttlingBurstLimit(), other.throttlingBurstLimit())
                && Objects.equals(throttlingRateLimit(), other.throttlingRateLimit())
                && Objects.equals(cachingEnabled(), other.cachingEnabled())
                && Objects.equals(cacheTtlInSeconds(), other.cacheTtlInSeconds())
                && Objects.equals(cacheDataEncrypted(), other.cacheDataEncrypted())
                && Objects.equals(requireAuthorizationForCacheControl(), other.requireAuthorizationForCacheControl())
                && Objects.equals(unauthorizedCacheControlHeaderStrategyAsString(),
                        other.unauthorizedCacheControlHeaderStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MethodSetting").add("MetricsEnabled", metricsEnabled()).add("LoggingLevel", loggingLevel())
                .add("DataTraceEnabled", dataTraceEnabled()).add("ThrottlingBurstLimit", throttlingBurstLimit())
                .add("ThrottlingRateLimit", throttlingRateLimit()).add("CachingEnabled", cachingEnabled())
                .add("CacheTtlInSeconds", cacheTtlInSeconds()).add("CacheDataEncrypted", cacheDataEncrypted())
                .add("RequireAuthorizationForCacheControl", requireAuthorizationForCacheControl())
                .add("UnauthorizedCacheControlHeaderStrategy", unauthorizedCacheControlHeaderStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricsEnabled":
            return Optional.ofNullable(clazz.cast(metricsEnabled()));
        case "loggingLevel":
            return Optional.ofNullable(clazz.cast(loggingLevel()));
        case "dataTraceEnabled":
            return Optional.ofNullable(clazz.cast(dataTraceEnabled()));
        case "throttlingBurstLimit":
            return Optional.ofNullable(clazz.cast(throttlingBurstLimit()));
        case "throttlingRateLimit":
            return Optional.ofNullable(clazz.cast(throttlingRateLimit()));
        case "cachingEnabled":
            return Optional.ofNullable(clazz.cast(cachingEnabled()));
        case "cacheTtlInSeconds":
            return Optional.ofNullable(clazz.cast(cacheTtlInSeconds()));
        case "cacheDataEncrypted":
            return Optional.ofNullable(clazz.cast(cacheDataEncrypted()));
        case "requireAuthorizationForCacheControl":
            return Optional.ofNullable(clazz.cast(requireAuthorizationForCacheControl()));
        case "unauthorizedCacheControlHeaderStrategy":
            return Optional.ofNullable(clazz.cast(unauthorizedCacheControlHeaderStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MethodSetting, T> g) {
        return obj -> g.apply((MethodSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MethodSetting> {
        /**
         * <p>
         * Specifies whether Amazon CloudWatch metrics are enabled for this method. The PATCH path for this setting is
         * <code>/{method_setting_key}/metrics/enabled</code>, and the value is a Boolean.
         * </p>
         * 
         * @param metricsEnabled
         *        Specifies whether Amazon CloudWatch metrics are enabled for this method. The PATCH path for this
         *        setting is <code>/{method_setting_key}/metrics/enabled</code>, and the value is a Boolean.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsEnabled(Boolean metricsEnabled);

        /**
         * <p>
         * Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs.
         * The PATCH path for this setting is <code>/{method_setting_key}/logging/loglevel</code>, and the available
         * levels are <code>OFF</code>, <code>ERROR</code>, and <code>INFO</code>. Choose <code>ERROR</code> to write
         * only error-level entries to CloudWatch Logs, or choose <code>INFO</code> to include all <code>ERROR</code>
         * events as well as extra informational events.
         * </p>
         * 
         * @param loggingLevel
         *        Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch
         *        Logs. The PATCH path for this setting is <code>/{method_setting_key}/logging/loglevel</code>, and the
         *        available levels are <code>OFF</code>, <code>ERROR</code>, and <code>INFO</code>. Choose
         *        <code>ERROR</code> to write only error-level entries to CloudWatch Logs, or choose <code>INFO</code>
         *        to include all <code>ERROR</code> events as well as extra informational events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingLevel(String loggingLevel);

        /**
         * <p>
         * Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to
         * Amazon CloudWatch Logs. The PATCH path for this setting is
         * <code>/{method_setting_key}/logging/dataTrace</code>, and the value is a Boolean.
         * </p>
         * 
         * @param dataTraceEnabled
         *        Specifies whether data trace logging is enabled for this method, which affects the log entries pushed
         *        to Amazon CloudWatch Logs. The PATCH path for this setting is
         *        <code>/{method_setting_key}/logging/dataTrace</code>, and the value is a Boolean.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTraceEnabled(Boolean dataTraceEnabled);

        /**
         * <p>
         * Specifies the throttling burst limit. The PATCH path for this setting is
         * <code>/{method_setting_key}/throttling/burstLimit</code>, and the value is an integer.
         * </p>
         * 
         * @param throttlingBurstLimit
         *        Specifies the throttling burst limit. The PATCH path for this setting is
         *        <code>/{method_setting_key}/throttling/burstLimit</code>, and the value is an integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throttlingBurstLimit(Integer throttlingBurstLimit);

        /**
         * <p>
         * Specifies the throttling rate limit. The PATCH path for this setting is
         * <code>/{method_setting_key}/throttling/rateLimit</code>, and the value is a double.
         * </p>
         * 
         * @param throttlingRateLimit
         *        Specifies the throttling rate limit. The PATCH path for this setting is
         *        <code>/{method_setting_key}/throttling/rateLimit</code>, and the value is a double.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throttlingRateLimit(Double throttlingRateLimit);

        /**
         * <p>
         * Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on
         * the stage for responses to be cached. The PATCH path for this setting is
         * <code>/{method_setting_key}/caching/enabled</code>, and the value is a Boolean.
         * </p>
         * 
         * @param cachingEnabled
         *        Specifies whether responses should be cached and returned for requests. A cache cluster must be
         *        enabled on the stage for responses to be cached. The PATCH path for this setting is
         *        <code>/{method_setting_key}/caching/enabled</code>, and the value is a Boolean.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachingEnabled(Boolean cachingEnabled);

        /**
         * <p>
         * Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the
         * response will be cached. The PATCH path for this setting is
         * <code>/{method_setting_key}/caching/ttlInSeconds</code>, and the value is an integer.
         * </p>
         * 
         * @param cacheTtlInSeconds
         *        Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the
         *        response will be cached. The PATCH path for this setting is
         *        <code>/{method_setting_key}/caching/ttlInSeconds</code>, and the value is an integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheTtlInSeconds(Integer cacheTtlInSeconds);

        /**
         * <p>
         * Specifies whether the cached responses are encrypted. The PATCH path for this setting is
         * <code>/{method_setting_key}/caching/dataEncrypted</code>, and the value is a Boolean.
         * </p>
         * 
         * @param cacheDataEncrypted
         *        Specifies whether the cached responses are encrypted. The PATCH path for this setting is
         *        <code>/{method_setting_key}/caching/dataEncrypted</code>, and the value is a Boolean.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheDataEncrypted(Boolean cacheDataEncrypted);

        /**
         * <p>
         * Specifies whether authorization is required for a cache invalidation request. The PATCH path for this setting
         * is <code>/{method_setting_key}/caching/requireAuthorizationForCacheControl</code>, and the value is a
         * Boolean.
         * </p>
         * 
         * @param requireAuthorizationForCacheControl
         *        Specifies whether authorization is required for a cache invalidation request. The PATCH path for this
         *        setting is <code>/{method_setting_key}/caching/requireAuthorizationForCacheControl</code>, and the
         *        value is a Boolean.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireAuthorizationForCacheControl(Boolean requireAuthorizationForCacheControl);

        /**
         * <p>
         * Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting is
         * <code>/{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy</code>, and the available values
         * are <code>FAIL_WITH_403</code>, <code>SUCCEED_WITH_RESPONSE_HEADER</code>,
         * <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>.
         * </p>
         * 
         * @param unauthorizedCacheControlHeaderStrategy
         *        Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting
         *        is <code>/{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy</code>, and the
         *        available values are <code>FAIL_WITH_403</code>, <code>SUCCEED_WITH_RESPONSE_HEADER</code>,
         *        <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>.
         * @see UnauthorizedCacheControlHeaderStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnauthorizedCacheControlHeaderStrategy
         */
        Builder unauthorizedCacheControlHeaderStrategy(String unauthorizedCacheControlHeaderStrategy);

        /**
         * <p>
         * Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting is
         * <code>/{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy</code>, and the available values
         * are <code>FAIL_WITH_403</code>, <code>SUCCEED_WITH_RESPONSE_HEADER</code>,
         * <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>.
         * </p>
         * 
         * @param unauthorizedCacheControlHeaderStrategy
         *        Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting
         *        is <code>/{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy</code>, and the
         *        available values are <code>FAIL_WITH_403</code>, <code>SUCCEED_WITH_RESPONSE_HEADER</code>,
         *        <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>.
         * @see UnauthorizedCacheControlHeaderStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnauthorizedCacheControlHeaderStrategy
         */
        Builder unauthorizedCacheControlHeaderStrategy(
                UnauthorizedCacheControlHeaderStrategy unauthorizedCacheControlHeaderStrategy);
    }

    static final class BuilderImpl implements Builder {
        private Boolean metricsEnabled;

        private String loggingLevel;

        private Boolean dataTraceEnabled;

        private Integer throttlingBurstLimit;

        private Double throttlingRateLimit;

        private Boolean cachingEnabled;

        private Integer cacheTtlInSeconds;

        private Boolean cacheDataEncrypted;

        private Boolean requireAuthorizationForCacheControl;

        private String unauthorizedCacheControlHeaderStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(MethodSetting model) {
            metricsEnabled(model.metricsEnabled);
            loggingLevel(model.loggingLevel);
            dataTraceEnabled(model.dataTraceEnabled);
            throttlingBurstLimit(model.throttlingBurstLimit);
            throttlingRateLimit(model.throttlingRateLimit);
            cachingEnabled(model.cachingEnabled);
            cacheTtlInSeconds(model.cacheTtlInSeconds);
            cacheDataEncrypted(model.cacheDataEncrypted);
            requireAuthorizationForCacheControl(model.requireAuthorizationForCacheControl);
            unauthorizedCacheControlHeaderStrategy(model.unauthorizedCacheControlHeaderStrategy);
        }

        public final Boolean getMetricsEnabled() {
            return metricsEnabled;
        }

        public final void setMetricsEnabled(Boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
        }

        @Override
        public final Builder metricsEnabled(Boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
            return this;
        }

        public final String getLoggingLevel() {
            return loggingLevel;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        @Override
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public final Boolean getDataTraceEnabled() {
            return dataTraceEnabled;
        }

        public final void setDataTraceEnabled(Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
        }

        @Override
        public final Builder dataTraceEnabled(Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
            return this;
        }

        public final Integer getThrottlingBurstLimit() {
            return throttlingBurstLimit;
        }

        public final void setThrottlingBurstLimit(Integer throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
        }

        @Override
        public final Builder throttlingBurstLimit(Integer throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
            return this;
        }

        public final Double getThrottlingRateLimit() {
            return throttlingRateLimit;
        }

        public final void setThrottlingRateLimit(Double throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
        }

        @Override
        public final Builder throttlingRateLimit(Double throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
            return this;
        }

        public final Boolean getCachingEnabled() {
            return cachingEnabled;
        }

        public final void setCachingEnabled(Boolean cachingEnabled) {
            this.cachingEnabled = cachingEnabled;
        }

        @Override
        public final Builder cachingEnabled(Boolean cachingEnabled) {
            this.cachingEnabled = cachingEnabled;
            return this;
        }

        public final Integer getCacheTtlInSeconds() {
            return cacheTtlInSeconds;
        }

        public final void setCacheTtlInSeconds(Integer cacheTtlInSeconds) {
            this.cacheTtlInSeconds = cacheTtlInSeconds;
        }

        @Override
        public final Builder cacheTtlInSeconds(Integer cacheTtlInSeconds) {
            this.cacheTtlInSeconds = cacheTtlInSeconds;
            return this;
        }

        public final Boolean getCacheDataEncrypted() {
            return cacheDataEncrypted;
        }

        public final void setCacheDataEncrypted(Boolean cacheDataEncrypted) {
            this.cacheDataEncrypted = cacheDataEncrypted;
        }

        @Override
        public final Builder cacheDataEncrypted(Boolean cacheDataEncrypted) {
            this.cacheDataEncrypted = cacheDataEncrypted;
            return this;
        }

        public final Boolean getRequireAuthorizationForCacheControl() {
            return requireAuthorizationForCacheControl;
        }

        public final void setRequireAuthorizationForCacheControl(Boolean requireAuthorizationForCacheControl) {
            this.requireAuthorizationForCacheControl = requireAuthorizationForCacheControl;
        }

        @Override
        public final Builder requireAuthorizationForCacheControl(Boolean requireAuthorizationForCacheControl) {
            this.requireAuthorizationForCacheControl = requireAuthorizationForCacheControl;
            return this;
        }

        public final String getUnauthorizedCacheControlHeaderStrategy() {
            return unauthorizedCacheControlHeaderStrategy;
        }

        public final void setUnauthorizedCacheControlHeaderStrategy(String unauthorizedCacheControlHeaderStrategy) {
            this.unauthorizedCacheControlHeaderStrategy = unauthorizedCacheControlHeaderStrategy;
        }

        @Override
        public final Builder unauthorizedCacheControlHeaderStrategy(String unauthorizedCacheControlHeaderStrategy) {
            this.unauthorizedCacheControlHeaderStrategy = unauthorizedCacheControlHeaderStrategy;
            return this;
        }

        @Override
        public final Builder unauthorizedCacheControlHeaderStrategy(
                UnauthorizedCacheControlHeaderStrategy unauthorizedCacheControlHeaderStrategy) {
            this.unauthorizedCacheControlHeaderStrategy(unauthorizedCacheControlHeaderStrategy == null ? null
                    : unauthorizedCacheControlHeaderStrategy.toString());
            return this;
        }

        @Override
        public MethodSetting build() {
            return new MethodSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
