/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The POST request to create a usage plan with the name, description, throttle limits and quota limits, as well as the
 * associated API stages, specified in the payload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUsagePlanRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<CreateUsagePlanRequest.Builder, CreateUsagePlanRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateUsagePlanRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateUsagePlanRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<ApiStage>> API_STAGES_FIELD = SdkField
            .<List<ApiStage>> builder(MarshallingType.LIST)
            .memberName("apiStages")
            .getter(getter(CreateUsagePlanRequest::apiStages))
            .setter(setter(Builder::apiStages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiStages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApiStage> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApiStage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ThrottleSettings> THROTTLE_FIELD = SdkField
            .<ThrottleSettings> builder(MarshallingType.SDK_POJO).memberName("throttle")
            .getter(getter(CreateUsagePlanRequest::throttle)).setter(setter(Builder::throttle))
            .constructor(ThrottleSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throttle").build()).build();

    private static final SdkField<QuotaSettings> QUOTA_FIELD = SdkField.<QuotaSettings> builder(MarshallingType.SDK_POJO)
            .memberName("quota").getter(getter(CreateUsagePlanRequest::quota)).setter(setter(Builder::quota))
            .constructor(QuotaSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quota").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateUsagePlanRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            API_STAGES_FIELD, THROTTLE_FIELD, QUOTA_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final List<ApiStage> apiStages;

    private final ThrottleSettings throttle;

    private final QuotaSettings quota;

    private final Map<String, String> tags;

    private CreateUsagePlanRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.apiStages = builder.apiStages;
        this.throttle = builder.throttle;
        this.quota = builder.quota;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the usage plan.
     * </p>
     * 
     * @return The name of the usage plan.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the usage plan.
     * </p>
     * 
     * @return The description of the usage plan.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApiStages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasApiStages() {
        return apiStages != null && !(apiStages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The associated API stages of the usage plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApiStages} method.
     * </p>
     * 
     * @return The associated API stages of the usage plan.
     */
    public final List<ApiStage> apiStages() {
        return apiStages;
    }

    /**
     * <p>
     * The throttling limits of the usage plan.
     * </p>
     * 
     * @return The throttling limits of the usage plan.
     */
    public final ThrottleSettings throttle() {
        return throttle;
    }

    /**
     * <p>
     * The quota of the usage plan.
     * </p>
     * 
     * @return The quota of the usage plan.
     */
    public final QuotaSettings quota() {
        return quota;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters
     * and must not start with <code>aws:</code>. The tag value can be up to 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128
     *         characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasApiStages() ? apiStages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(throttle());
        hashCode = 31 * hashCode + Objects.hashCode(quota());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUsagePlanRequest)) {
            return false;
        }
        CreateUsagePlanRequest other = (CreateUsagePlanRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasApiStages() == other.hasApiStages() && Objects.equals(apiStages(), other.apiStages())
                && Objects.equals(throttle(), other.throttle()) && Objects.equals(quota(), other.quota())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUsagePlanRequest").add("Name", name()).add("Description", description())
                .add("ApiStages", hasApiStages() ? apiStages() : null).add("Throttle", throttle()).add("Quota", quota())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "apiStages":
            return Optional.ofNullable(clazz.cast(apiStages()));
        case "throttle":
            return Optional.ofNullable(clazz.cast(throttle()));
        case "quota":
            return Optional.ofNullable(clazz.cast(quota()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUsagePlanRequest, T> g) {
        return obj -> g.apply((CreateUsagePlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUsagePlanRequest> {
        /**
         * <p>
         * The name of the usage plan.
         * </p>
         * 
         * @param name
         *        The name of the usage plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the usage plan.
         * </p>
         * 
         * @param description
         *        The description of the usage plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The associated API stages of the usage plan.
         * </p>
         * 
         * @param apiStages
         *        The associated API stages of the usage plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiStages(Collection<ApiStage> apiStages);

        /**
         * <p>
         * The associated API stages of the usage plan.
         * </p>
         * 
         * @param apiStages
         *        The associated API stages of the usage plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiStages(ApiStage... apiStages);

        /**
         * <p>
         * The associated API stages of the usage plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ApiStage>.Builder} avoiding the need
         * to create one manually via {@link List<ApiStage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApiStage>.Builder#build()} is called immediately and its
         * result is passed to {@link #apiStages(List<ApiStage>)}.
         * 
         * @param apiStages
         *        a consumer that will call methods on {@link List<ApiStage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiStages(List<ApiStage>)
         */
        Builder apiStages(Consumer<ApiStage.Builder>... apiStages);

        /**
         * <p>
         * The throttling limits of the usage plan.
         * </p>
         * 
         * @param throttle
         *        The throttling limits of the usage plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throttle(ThrottleSettings throttle);

        /**
         * <p>
         * The throttling limits of the usage plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThrottleSettings.Builder} avoiding the
         * need to create one manually via {@link ThrottleSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThrottleSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #throttle(ThrottleSettings)}.
         * 
         * @param throttle
         *        a consumer that will call methods on {@link ThrottleSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #throttle(ThrottleSettings)
         */
        default Builder throttle(Consumer<ThrottleSettings.Builder> throttle) {
            return throttle(ThrottleSettings.builder().applyMutation(throttle).build());
        }

        /**
         * <p>
         * The quota of the usage plan.
         * </p>
         * 
         * @param quota
         *        The quota of the usage plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quota(QuotaSettings quota);

        /**
         * <p>
         * The quota of the usage plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuotaSettings.Builder} avoiding the need
         * to create one manually via {@link QuotaSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link QuotaSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #quota(QuotaSettings)}.
         * 
         * @param quota
         *        a consumer that will call methods on {@link QuotaSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quota(QuotaSettings)
         */
        default Builder quota(Consumer<QuotaSettings.Builder> quota) {
            return quota(QuotaSettings.builder().applyMutation(quota).build());
        }

        /**
         * <p>
         * The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128
         * characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.
         * </p>
         * 
         * @param tags
         *        The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128
         *        characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<ApiStage> apiStages = DefaultSdkAutoConstructList.getInstance();

        private ThrottleSettings throttle;

        private QuotaSettings quota;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUsagePlanRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            apiStages(model.apiStages);
            throttle(model.throttle);
            quota(model.quota);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ApiStage.Builder> getApiStages() {
            List<ApiStage.Builder> result = ListOfApiStageCopier.copyToBuilder(this.apiStages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApiStages(Collection<ApiStage.BuilderImpl> apiStages) {
            this.apiStages = ListOfApiStageCopier.copyFromBuilder(apiStages);
        }

        @Override
        public final Builder apiStages(Collection<ApiStage> apiStages) {
            this.apiStages = ListOfApiStageCopier.copy(apiStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiStages(ApiStage... apiStages) {
            apiStages(Arrays.asList(apiStages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiStages(Consumer<ApiStage.Builder>... apiStages) {
            apiStages(Stream.of(apiStages).map(c -> ApiStage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ThrottleSettings.Builder getThrottle() {
            return throttle != null ? throttle.toBuilder() : null;
        }

        public final void setThrottle(ThrottleSettings.BuilderImpl throttle) {
            this.throttle = throttle != null ? throttle.build() : null;
        }

        @Override
        public final Builder throttle(ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        public final QuotaSettings.Builder getQuota() {
            return quota != null ? quota.toBuilder() : null;
        }

        public final void setQuota(QuotaSettings.BuilderImpl quota) {
            this.quota = quota != null ? quota.build() : null;
        }

        @Override
        public final Builder quota(QuotaSettings quota) {
            this.quota = quota;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUsagePlanRequest build() {
            return new CreateUsagePlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
