/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse;
import software.amazon.awssdk.services.apigateway.model.VpcLink;

public class GetVpcLinksIterable
implements SdkIterable<GetVpcLinksResponse> {
    private final ApiGatewayClient client;
    private final GetVpcLinksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetVpcLinksIterable(ApiGatewayClient client, GetVpcLinksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetVpcLinksResponseFetcher();
    }

    public Iterator<GetVpcLinksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VpcLink> items() {
        Function<GetVpcLinksResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetVpcLinksResponseFetcher
    implements SyncPageFetcher<GetVpcLinksResponse> {
        private GetVpcLinksResponseFetcher() {
        }

        public boolean hasNextPage(GetVpcLinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public GetVpcLinksResponse nextPage(GetVpcLinksResponse previousPage) {
            if (previousPage == null) {
                return GetVpcLinksIterable.this.client.getVpcLinks(GetVpcLinksIterable.this.firstRequest);
            }
            return GetVpcLinksIterable.this.client.getVpcLinks((GetVpcLinksRequest)((Object)GetVpcLinksIterable.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

