/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource that can be distributed to callers for executing <a>Method</a> resources that require an API key. API keys
 * can be mapped to any <a>Stage</a> on any <a>RestApi</a>, which indicates that the callers with the API key can make
 * requests to that stage.
 * </p>
 * <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-api-keys.html">Use
 * API Keys</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApiKeyResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<GetApiKeyResponse.Builder, GetApiKeyResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetApiKeyResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(GetApiKeyResponse::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetApiKeyResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CUSTOMER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerId").getter(getter(GetApiKeyResponse::customerId)).setter(setter(Builder::customerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetApiKeyResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(GetApiKeyResponse::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(GetApiKeyResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDate").getter(getter(GetApiKeyResponse::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()).build();

    private static final SdkField<List<String>> STAGE_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stageKeys")
            .getter(getter(GetApiKeyResponse::stageKeys))
            .setter(setter(Builder::stageKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetApiKeyResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VALUE_FIELD,
            NAME_FIELD, CUSTOMER_ID_FIELD, DESCRIPTION_FIELD, ENABLED_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD,
            STAGE_KEYS_FIELD, TAGS_FIELD));

    private final String id;

    private final String value;

    private final String name;

    private final String customerId;

    private final String description;

    private final Boolean enabled;

    private final Instant createdDate;

    private final Instant lastUpdatedDate;

    private final List<String> stageKeys;

    private final Map<String, String> tags;

    private GetApiKeyResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.value = builder.value;
        this.name = builder.name;
        this.customerId = builder.customerId;
        this.description = builder.description;
        this.enabled = builder.enabled;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.stageKeys = builder.stageKeys;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the API Key.
     * </p>
     * 
     * @return The identifier of the API Key.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The value of the API Key.
     * </p>
     * 
     * @return The value of the API Key.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The name of the API Key.
     * </p>
     * 
     * @return The name of the API Key.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
     * </p>
     * 
     * @return An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
     */
    public final String customerId() {
        return customerId;
    }

    /**
     * <p>
     * The description of the API Key.
     * </p>
     * 
     * @return The description of the API Key.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether the API Key can be used by callers.
     * </p>
     * 
     * @return Specifies whether the API Key can be used by callers.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The timestamp when the API Key was created.
     * </p>
     * 
     * @return The timestamp when the API Key was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The timestamp when the API Key was last updated.
     * </p>
     * 
     * @return The timestamp when the API Key was last updated.
     */
    public final Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the StageKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStageKeys() {
        return stageKeys != null && !(stageKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStageKeys} method.
     * </p>
     * 
     * @return A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.
     */
    public final List<String> stageKeys() {
        return stageKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The collection of tags. Each tag element is associated with a given resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The collection of tags. Each tag element is associated with a given resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(customerId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasStageKeys() ? stageKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApiKeyResponse)) {
            return false;
        }
        GetApiKeyResponse other = (GetApiKeyResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(value(), other.value()) && Objects.equals(name(), other.name())
                && Objects.equals(customerId(), other.customerId()) && Objects.equals(description(), other.description())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate()) && hasStageKeys() == other.hasStageKeys()
                && Objects.equals(stageKeys(), other.stageKeys()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApiKeyResponse").add("Id", id()).add("Value", value()).add("Name", name())
                .add("CustomerId", customerId()).add("Description", description()).add("Enabled", enabled())
                .add("CreatedDate", createdDate()).add("LastUpdatedDate", lastUpdatedDate())
                .add("StageKeys", hasStageKeys() ? stageKeys() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "customerId":
            return Optional.ofNullable(clazz.cast(customerId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "stageKeys":
            return Optional.ofNullable(clazz.cast(stageKeys()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApiKeyResponse, T> g) {
        return obj -> g.apply((GetApiKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetApiKeyResponse> {
        /**
         * <p>
         * The identifier of the API Key.
         * </p>
         * 
         * @param id
         *        The identifier of the API Key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The value of the API Key.
         * </p>
         * 
         * @param value
         *        The value of the API Key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The name of the API Key.
         * </p>
         * 
         * @param name
         *        The name of the API Key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
         * </p>
         * 
         * @param customerId
         *        An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerId(String customerId);

        /**
         * <p>
         * The description of the API Key.
         * </p>
         * 
         * @param description
         *        The description of the API Key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether the API Key can be used by callers.
         * </p>
         * 
         * @param enabled
         *        Specifies whether the API Key can be used by callers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The timestamp when the API Key was created.
         * </p>
         * 
         * @param createdDate
         *        The timestamp when the API Key was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The timestamp when the API Key was last updated.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The timestamp when the API Key was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.
         * </p>
         * 
         * @param stageKeys
         *        A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageKeys(Collection<String> stageKeys);

        /**
         * <p>
         * A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.
         * </p>
         * 
         * @param stageKeys
         *        A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageKeys(String... stageKeys);

        /**
         * <p>
         * The collection of tags. Each tag element is associated with a given resource.
         * </p>
         * 
         * @param tags
         *        The collection of tags. Each tag element is associated with a given resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String id;

        private String value;

        private String name;

        private String customerId;

        private String description;

        private Boolean enabled;

        private Instant createdDate;

        private Instant lastUpdatedDate;

        private List<String> stageKeys = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetApiKeyResponse model) {
            super(model);
            id(model.id);
            value(model.value);
            name(model.name);
            customerId(model.customerId);
            description(model.description);
            enabled(model.enabled);
            createdDate(model.createdDate);
            lastUpdatedDate(model.lastUpdatedDate);
            stageKeys(model.stageKeys);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCustomerId() {
            return customerId;
        }

        public final void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        @Override
        @Transient
        public final Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        @Transient
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        @Transient
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final Collection<String> getStageKeys() {
            if (stageKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return stageKeys;
        }

        public final void setStageKeys(Collection<String> stageKeys) {
            this.stageKeys = ListOfStringCopier.copy(stageKeys);
        }

        @Override
        @Transient
        public final Builder stageKeys(Collection<String> stageKeys) {
            this.stageKeys = ListOfStringCopier.copy(stageKeys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stageKeys(String... stageKeys) {
            stageKeys(Arrays.asList(stageKeys));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        @Override
        public GetApiKeyResponse build() {
            return new GetApiKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
