/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The POST Request to add a new <a>RestApi</a> resource to your collection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRestApiRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<CreateRestApiRequest.Builder, CreateRestApiRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRestApiRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRestApiRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRestApiRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> CLONE_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRestApiRequest::cloneFrom)).setter(setter(Builder::cloneFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloneFrom").build()).build();

    private static final SdkField<List<String>> BINARY_MEDIA_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateRestApiRequest::binaryMediaTypes))
            .setter(setter(Builder::binaryMediaTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binaryMediaTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MINIMUM_COMPRESSION_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateRestApiRequest::minimumCompressionSize)).setter(setter(Builder::minimumCompressionSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumCompressionSize").build())
            .build();

    private static final SdkField<String> API_KEY_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRestApiRequest::apiKeySourceAsString)).setter(setter(Builder::apiKeySource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeySource").build()).build();

    private static final SdkField<EndpointConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField
            .<EndpointConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateRestApiRequest::endpointConfiguration)).setter(setter(Builder::endpointConfiguration))
            .constructor(EndpointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfiguration").build())
            .build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRestApiRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            VERSION_FIELD, CLONE_FROM_FIELD, BINARY_MEDIA_TYPES_FIELD, MINIMUM_COMPRESSION_SIZE_FIELD, API_KEY_SOURCE_FIELD,
            ENDPOINT_CONFIGURATION_FIELD, POLICY_FIELD));

    private final String name;

    private final String description;

    private final String version;

    private final String cloneFrom;

    private final List<String> binaryMediaTypes;

    private final Integer minimumCompressionSize;

    private final String apiKeySource;

    private final EndpointConfiguration endpointConfiguration;

    private final String policy;

    private CreateRestApiRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.version = builder.version;
        this.cloneFrom = builder.cloneFrom;
        this.binaryMediaTypes = builder.binaryMediaTypes;
        this.minimumCompressionSize = builder.minimumCompressionSize;
        this.apiKeySource = builder.apiKeySource;
        this.endpointConfiguration = builder.endpointConfiguration;
        this.policy = builder.policy;
    }

    /**
     * <p>
     * [Required] The name of the <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The name of the <a>RestApi</a>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the <a>RestApi</a>.
     * </p>
     * 
     * @return The description of the <a>RestApi</a>.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A version identifier for the API.
     * </p>
     * 
     * @return A version identifier for the API.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The ID of the <a>RestApi</a> that you want to clone from.
     * </p>
     * 
     * @return The ID of the <a>RestApi</a> that you want to clone from.
     */
    public String cloneFrom() {
        return cloneFrom;
    }

    /**
     * <p>
     * The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only
     * UTF-8-encoded text payloads.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports
     *         only UTF-8-encoded text payloads.
     */
    public List<String> binaryMediaTypes() {
        return binaryMediaTypes;
    }

    /**
     * <p>
     * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes,
     * inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or
     * decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero
     * allows compression for any payload size.
     * </p>
     * 
     * @return A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M)
     *         bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled,
     *         compression or decompression is not applied on the payload if the payload size is smaller than this
     *         value. Setting it to zero allows compression for any payload size.
     */
    public Integer minimumCompressionSize() {
        return minimumCompressionSize;
    }

    /**
     * <p>
     * The source of the API key for metering requests according to a usage plan. Valid values are:
     * <ul>
     * <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
     * <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
     * authorizer.</li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiKeySource} will
     * return {@link ApiKeySourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiKeySourceAsString}.
     * </p>
     * 
     * @return The source of the API key for metering requests according to a usage plan. Valid values are:
     *         <ul>
     *         <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
     *         <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
     *         authorizer.</li>
     *         </ul>
     * @see ApiKeySourceType
     */
    public ApiKeySourceType apiKeySource() {
        return ApiKeySourceType.fromValue(apiKeySource);
    }

    /**
     * <p>
     * The source of the API key for metering requests according to a usage plan. Valid values are:
     * <ul>
     * <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
     * <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
     * authorizer.</li>
     * </ul>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiKeySource} will
     * return {@link ApiKeySourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiKeySourceAsString}.
     * </p>
     * 
     * @return The source of the API key for metering requests according to a usage plan. Valid values are:
     *         <ul>
     *         <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
     *         <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
     *         authorizer.</li>
     *         </ul>
     * @see ApiKeySourceType
     */
    public String apiKeySourceAsString() {
        return apiKeySource;
    }

    /**
     * <p>
     * The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
     * </p>
     * 
     * @return The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
     */
    public EndpointConfiguration endpointConfiguration() {
        return endpointConfiguration;
    }

    /**
     * A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a>
     * configuration.
     * 
     * @return A stringified JSON policy document that applies to this RestApi regardless of the caller and
     *         <a>Method</a> configuration.
     */
    public String policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(cloneFrom());
        hashCode = 31 * hashCode + Objects.hashCode(binaryMediaTypes());
        hashCode = 31 * hashCode + Objects.hashCode(minimumCompressionSize());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeySourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestApiRequest)) {
            return false;
        }
        CreateRestApiRequest other = (CreateRestApiRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(version(), other.version()) && Objects.equals(cloneFrom(), other.cloneFrom())
                && Objects.equals(binaryMediaTypes(), other.binaryMediaTypes())
                && Objects.equals(minimumCompressionSize(), other.minimumCompressionSize())
                && Objects.equals(apiKeySourceAsString(), other.apiKeySourceAsString())
                && Objects.equals(endpointConfiguration(), other.endpointConfiguration())
                && Objects.equals(policy(), other.policy());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateRestApiRequest").add("Name", name()).add("Description", description())
                .add("Version", version()).add("CloneFrom", cloneFrom()).add("BinaryMediaTypes", binaryMediaTypes())
                .add("MinimumCompressionSize", minimumCompressionSize()).add("ApiKeySource", apiKeySourceAsString())
                .add("EndpointConfiguration", endpointConfiguration()).add("Policy", policy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "cloneFrom":
            return Optional.ofNullable(clazz.cast(cloneFrom()));
        case "binaryMediaTypes":
            return Optional.ofNullable(clazz.cast(binaryMediaTypes()));
        case "minimumCompressionSize":
            return Optional.ofNullable(clazz.cast(minimumCompressionSize()));
        case "apiKeySource":
            return Optional.ofNullable(clazz.cast(apiKeySourceAsString()));
        case "endpointConfiguration":
            return Optional.ofNullable(clazz.cast(endpointConfiguration()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRestApiRequest, T> g) {
        return obj -> g.apply((CreateRestApiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRestApiRequest> {
        /**
         * <p>
         * [Required] The name of the <a>RestApi</a>.
         * </p>
         * 
         * @param name
         *        [Required] The name of the <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the <a>RestApi</a>.
         * </p>
         * 
         * @param description
         *        The description of the <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A version identifier for the API.
         * </p>
         * 
         * @param version
         *        A version identifier for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The ID of the <a>RestApi</a> that you want to clone from.
         * </p>
         * 
         * @param cloneFrom
         *        The ID of the <a>RestApi</a> that you want to clone from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloneFrom(String cloneFrom);

        /**
         * <p>
         * The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only
         * UTF-8-encoded text payloads.
         * </p>
         * 
         * @param binaryMediaTypes
         *        The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a>
         *        supports only UTF-8-encoded text payloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binaryMediaTypes(Collection<String> binaryMediaTypes);

        /**
         * <p>
         * The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only
         * UTF-8-encoded text payloads.
         * </p>
         * 
         * @param binaryMediaTypes
         *        The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a>
         *        supports only UTF-8-encoded text payloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binaryMediaTypes(String... binaryMediaTypes);

        /**
         * <p>
         * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes,
         * inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or
         * decompression is not applied on the payload if the payload size is smaller than this value. Setting it to
         * zero allows compression for any payload size.
         * </p>
         * 
         * @param minimumCompressionSize
         *        A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M)
         *        bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled,
         *        compression or decompression is not applied on the payload if the payload size is smaller than this
         *        value. Setting it to zero allows compression for any payload size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumCompressionSize(Integer minimumCompressionSize);

        /**
         * <p>
         * The source of the API key for metering requests according to a usage plan. Valid values are:
         * <ul>
         * <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
         * <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
         * authorizer.</li>
         * </ul>
         * </p>
         * 
         * @param apiKeySource
         *        The source of the API key for metering requests according to a usage plan. Valid values are:
         *        <ul>
         *        <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
         *        <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
         *        authorizer.</li>
         *        </ul>
         * @see ApiKeySourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiKeySourceType
         */
        Builder apiKeySource(String apiKeySource);

        /**
         * <p>
         * The source of the API key for metering requests according to a usage plan. Valid values are:
         * <ul>
         * <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
         * <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
         * authorizer.</li>
         * </ul>
         * </p>
         * 
         * @param apiKeySource
         *        The source of the API key for metering requests according to a usage plan. Valid values are:
         *        <ul>
         *        <li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request.</li>
         *        <li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom
         *        authorizer.</li>
         *        </ul>
         * @see ApiKeySourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiKeySourceType
         */
        Builder apiKeySource(ApiKeySourceType apiKeySource);

        /**
         * <p>
         * The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
         * </p>
         * 
         * @param endpointConfiguration
         *        The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfiguration(EndpointConfiguration endpointConfiguration);

        /**
         * <p>
         * The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API.
         * </p>
         * This is a convenience that creates an instance of the {@link EndpointConfiguration.Builder} avoiding the need
         * to create one manually via {@link EndpointConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #endpointConfiguration(EndpointConfiguration)}.
         * 
         * @param endpointConfiguration
         *        a consumer that will call methods on {@link EndpointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfiguration(EndpointConfiguration)
         */
        default Builder endpointConfiguration(Consumer<EndpointConfiguration.Builder> endpointConfiguration) {
            return endpointConfiguration(EndpointConfiguration.builder().applyMutation(endpointConfiguration).build());
        }

        /**
         * A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a>
         * configuration.
         * 
         * @param policy
         *        A stringified JSON policy document that applies to this RestApi regardless of the caller and
         *        <a>Method</a> configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String version;

        private String cloneFrom;

        private List<String> binaryMediaTypes = DefaultSdkAutoConstructList.getInstance();

        private Integer minimumCompressionSize;

        private String apiKeySource;

        private EndpointConfiguration endpointConfiguration;

        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestApiRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            version(model.version);
            cloneFrom(model.cloneFrom);
            binaryMediaTypes(model.binaryMediaTypes);
            minimumCompressionSize(model.minimumCompressionSize);
            apiKeySource(model.apiKeySource);
            endpointConfiguration(model.endpointConfiguration);
            policy(model.policy);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getCloneFrom() {
            return cloneFrom;
        }

        @Override
        public final Builder cloneFrom(String cloneFrom) {
            this.cloneFrom = cloneFrom;
            return this;
        }

        public final void setCloneFrom(String cloneFrom) {
            this.cloneFrom = cloneFrom;
        }

        public final Collection<String> getBinaryMediaTypes() {
            return binaryMediaTypes;
        }

        @Override
        public final Builder binaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = ListOfStringCopier.copy(binaryMediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binaryMediaTypes(String... binaryMediaTypes) {
            binaryMediaTypes(Arrays.asList(binaryMediaTypes));
            return this;
        }

        public final void setBinaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = ListOfStringCopier.copy(binaryMediaTypes);
        }

        public final Integer getMinimumCompressionSize() {
            return minimumCompressionSize;
        }

        @Override
        public final Builder minimumCompressionSize(Integer minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        public final void setMinimumCompressionSize(Integer minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
        }

        public final String getApiKeySource() {
            return apiKeySource;
        }

        @Override
        public final Builder apiKeySource(String apiKeySource) {
            this.apiKeySource = apiKeySource;
            return this;
        }

        @Override
        public final Builder apiKeySource(ApiKeySourceType apiKeySource) {
            this.apiKeySource(apiKeySource.toString());
            return this;
        }

        public final void setApiKeySource(String apiKeySource) {
            this.apiKeySource = apiKeySource;
        }

        public final EndpointConfiguration.Builder getEndpointConfiguration() {
            return endpointConfiguration != null ? endpointConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final void setEndpointConfiguration(EndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRestApiRequest build() {
            return new CreateRestApiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
