/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.apigateway.internal.ApiGatewayServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayException;
import software.amazon.awssdk.services.apigateway.model.BadRequestException;
import software.amazon.awssdk.services.apigateway.model.ConflictException;
import software.amazon.awssdk.services.apigateway.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.CreateModelRequest;
import software.amazon.awssdk.services.apigateway.model.CreateModelResponse;
import software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.CreateResourceRequest;
import software.amazon.awssdk.services.apigateway.model.CreateResourceResponse;
import software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.CreateRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.CreateStageRequest;
import software.amazon.awssdk.services.apigateway.model.CreateStageResponse;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.CreateVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.CreateVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteModelRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteModelResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteResourceRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteResourceResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteStageRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteStageResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheRequest;
import software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheResponse;
import software.amazon.awssdk.services.apigateway.model.FlushStageCacheRequest;
import software.amazon.awssdk.services.apigateway.model.FlushStageCacheResponse;
import software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.GetAccountRequest;
import software.amazon.awssdk.services.apigateway.model.GetAccountResponse;
import software.amazon.awssdk.services.apigateway.model.GetApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.GetApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizersResponse;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse;
import software.amazon.awssdk.services.apigateway.model.GetExportRequest;
import software.amazon.awssdk.services.apigateway.model.GetExportResponse;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesRequest;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesResponse;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetMethodRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponse;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelTemplateRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelTemplateResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelsRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelsResponse;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorsRequest;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorsResponse;
import software.amazon.awssdk.services.apigateway.model.GetResourceRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourceResponse;
import software.amazon.awssdk.services.apigateway.model.GetResourcesRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourcesResponse;
import software.amazon.awssdk.services.apigateway.model.GetRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.GetRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.GetRestApisRequest;
import software.amazon.awssdk.services.apigateway.model.GetRestApisResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypeRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypeResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypesRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypesResponse;
import software.amazon.awssdk.services.apigateway.model.GetStageRequest;
import software.amazon.awssdk.services.apigateway.model.GetStageResponse;
import software.amazon.awssdk.services.apigateway.model.GetStagesRequest;
import software.amazon.awssdk.services.apigateway.model.GetStagesResponse;
import software.amazon.awssdk.services.apigateway.model.GetTagsRequest;
import software.amazon.awssdk.services.apigateway.model.GetTagsResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsageRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsageResponse;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse;
import software.amazon.awssdk.services.apigateway.model.ImportApiKeysRequest;
import software.amazon.awssdk.services.apigateway.model.ImportApiKeysResponse;
import software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsRequest;
import software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsResponse;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.LimitExceededException;
import software.amazon.awssdk.services.apigateway.model.NotFoundException;
import software.amazon.awssdk.services.apigateway.model.PutGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutMethodRequest;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponse;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.PutRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.ServiceUnavailableException;
import software.amazon.awssdk.services.apigateway.model.TagResourceRequest;
import software.amazon.awssdk.services.apigateway.model.TagResourceResponse;
import software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest;
import software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse;
import software.amazon.awssdk.services.apigateway.model.TooManyRequestsException;
import software.amazon.awssdk.services.apigateway.model.UnauthorizedException;
import software.amazon.awssdk.services.apigateway.model.UntagResourceRequest;
import software.amazon.awssdk.services.apigateway.model.UntagResourceResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateAccountRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateAccountResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateModelRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateModelResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateResourceRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateResourceResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateStageRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateStageResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateUsageRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.transform.CreateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateUsagePlanKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.CreateVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteUsagePlanKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.DeleteVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.FlushStageAuthorizersCacheRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.FlushStageCacheRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GenerateClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAccountRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetApiKeysRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetAuthorizersRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetBasePathMappingsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetClientCertificatesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationPartsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDocumentationVersionsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetExportRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetGatewayResponsesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelTemplateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetModelsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRequestValidatorsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetResourcesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetRestApisRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkTypeRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetSdkTypesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetStagesRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetTagsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanKeysRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsagePlansRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetUsageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetVpcLinkRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.GetVpcLinksRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportApiKeysRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportDocumentationPartsRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.ImportRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.PutRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.TestInvokeAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.TestInvokeMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateAccountRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateBasePathMappingRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDocumentationPartRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDocumentationVersionRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateDomainNameRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateGatewayResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateIntegrationRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateIntegrationResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateMethodRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateMethodResponseRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateModelRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateRequestValidatorRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateResourceRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateRestApiRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateStageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateUsagePlanRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateUsageRequestMarshaller;
import software.amazon.awssdk.services.apigateway.transform.UpdateVpcLinkRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ApiGatewayAsyncClient}.
 *
 * @see ApiGatewayAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultApiGatewayAsyncClient implements ApiGatewayAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultApiGatewayAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultApiGatewayAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Create an ApiKey resource.
     * </p>
     *
     * @param createApiKeyRequest
     *        Request to create an ApiKey resource.
     * @return A Java Future containing the result of the CreateApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateApiKey
     */
    @Override
    public CompletableFuture<CreateApiKeyResponse> createApiKey(CreateApiKeyRequest createApiKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApiKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApiKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateApiKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateApiKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateApiKeyRequest, CreateApiKeyResponse>()
                            .withOperationName("CreateApiKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateApiKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createApiKeyRequest));
            CompletableFuture<CreateApiKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a new Authorizer resource to an existing RestApi resource.
     * </p>
     *
     * @param createAuthorizerRequest
     *        Request to add a new Authorizer to an existing RestApi resource.
     * @return A Java Future containing the result of the CreateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateAuthorizer
     */
    @Override
    public CompletableFuture<CreateAuthorizerResponse> createAuthorizer(CreateAuthorizerRequest createAuthorizerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAuthorizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAuthorizerRequest, CreateAuthorizerResponse>()
                            .withOperationName("CreateAuthorizer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAuthorizerRequest));
            CompletableFuture<CreateAuthorizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new BasePathMapping resource.
     * </p>
     *
     * @param createBasePathMappingRequest
     *        Requests API Gateway to create a new BasePathMapping resource.
     * @return A Java Future containing the result of the CreateBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateBasePathMapping
     */
    @Override
    public CompletableFuture<CreateBasePathMappingResponse> createBasePathMapping(
            CreateBasePathMappingRequest createBasePathMappingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBasePathMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBasePathMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBasePathMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBasePathMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBasePathMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBasePathMappingRequest, CreateBasePathMappingResponse>()
                            .withOperationName("CreateBasePathMapping").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBasePathMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBasePathMappingRequest));
            CompletableFuture<CreateBasePathMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Deployment resource, which makes a specified RestApi callable over the internet.
     * </p>
     *
     * @param createDeploymentRequest
     *        Requests API Gateway to create a Deployment resource.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDeployment
     */
    @Override
    public CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeploymentRequest, CreateDeploymentResponse>()
                            .withOperationName("CreateDeployment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDeploymentRequest));
            CompletableFuture<CreateDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a documentation part.
     * </p>
     *
     * @param createDocumentationPartRequest
     *        Creates a new documentation part of a given API.
     * @return A Java Future containing the result of the CreateDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDocumentationPart
     */
    @Override
    public CompletableFuture<CreateDocumentationPartResponse> createDocumentationPart(
            CreateDocumentationPartRequest createDocumentationPartRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDocumentationPartRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDocumentationPartRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDocumentationPart");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDocumentationPartResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDocumentationPartResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDocumentationPartRequest, CreateDocumentationPartResponse>()
                            .withOperationName("CreateDocumentationPart").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDocumentationPartRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDocumentationPartRequest));
            CompletableFuture<CreateDocumentationPartResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a documentation version
     * </p>
     *
     * @param createDocumentationVersionRequest
     *        Creates a new documentation version of a given API.
     * @return A Java Future containing the result of the CreateDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDocumentationVersion
     */
    @Override
    public CompletableFuture<CreateDocumentationVersionResponse> createDocumentationVersion(
            CreateDocumentationVersionRequest createDocumentationVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDocumentationVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDocumentationVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDocumentationVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDocumentationVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDocumentationVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDocumentationVersionRequest, CreateDocumentationVersionResponse>()
                            .withOperationName("CreateDocumentationVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDocumentationVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDocumentationVersionRequest));
            CompletableFuture<CreateDocumentationVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new domain name.
     * </p>
     *
     * @param createDomainNameRequest
     *        A request to create a new domain name.
     * @return A Java Future containing the result of the CreateDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDomainName
     */
    @Override
    public CompletableFuture<CreateDomainNameResponse> createDomainName(CreateDomainNameRequest createDomainNameRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDomainNameRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDomainName");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDomainNameResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDomainNameResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDomainNameRequest, CreateDomainNameResponse>()
                            .withOperationName("CreateDomainName").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDomainNameRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDomainNameRequest));
            CompletableFuture<CreateDomainNameResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a new Model resource to an existing RestApi resource.
     * </p>
     *
     * @param createModelRequest
     *        Request to add a new Model to an existing RestApi resource.
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateModel
     */
    @Override
    public CompletableFuture<CreateModelResponse> createModel(CreateModelRequest createModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateModelRequest, CreateModelResponse>()
                            .withOperationName("CreateModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createModelRequest));
            CompletableFuture<CreateModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a RequestValidator of a given RestApi.
     * </p>
     *
     * @param createRequestValidatorRequest
     *        Creates a RequestValidator of a given RestApi.
     * @return A Java Future containing the result of the CreateRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateRequestValidator
     */
    @Override
    public CompletableFuture<CreateRequestValidatorResponse> createRequestValidator(
            CreateRequestValidatorRequest createRequestValidatorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRequestValidatorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRequestValidatorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRequestValidator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRequestValidatorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRequestValidatorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRequestValidatorRequest, CreateRequestValidatorResponse>()
                            .withOperationName("CreateRequestValidator").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRequestValidatorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRequestValidatorRequest));
            CompletableFuture<CreateRequestValidatorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Resource resource.
     * </p>
     *
     * @param createResourceRequest
     *        Requests API Gateway to create a Resource resource.
     * @return A Java Future containing the result of the CreateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateResource
     */
    @Override
    public CompletableFuture<CreateResourceResponse> createResource(CreateResourceRequest createResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResourceRequest, CreateResourceResponse>()
                            .withOperationName("CreateResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createResourceRequest));
            CompletableFuture<CreateResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new RestApi resource.
     * </p>
     *
     * @param createRestApiRequest
     *        The POST Request to add a new RestApi resource to your collection.
     * @return A Java Future containing the result of the CreateRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateRestApi
     */
    @Override
    public CompletableFuture<CreateRestApiResponse> createRestApi(CreateRestApiRequest createRestApiRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRestApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRestApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRestApi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateRestApiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRestApiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRestApiRequest, CreateRestApiResponse>()
                            .withOperationName("CreateRestApi").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRestApiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRestApiRequest));
            CompletableFuture<CreateRestApiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Stage resource that references a pre-existing Deployment for the API.
     * </p>
     *
     * @param createStageRequest
     *        Requests API Gateway to create a Stage resource.
     * @return A Java Future containing the result of the CreateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateStage
     */
    @Override
    public CompletableFuture<CreateStageResponse> createStage(CreateStageRequest createStageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateStageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateStageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStageRequest, CreateStageResponse>()
                            .withOperationName("CreateStage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateStageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createStageRequest));
            CompletableFuture<CreateStageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the
     * payload.
     * </p>
     *
     * @param createUsagePlanRequest
     *        The POST request to create a usage plan with the name, description, throttle limits and quota limits, as
     *        well as the associated API stages, specified in the payload.
     * @return A Java Future containing the result of the CreateUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateUsagePlan
     */
    @Override
    public CompletableFuture<CreateUsagePlanResponse> createUsagePlan(CreateUsagePlanRequest createUsagePlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUsagePlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUsagePlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUsagePlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUsagePlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUsagePlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUsagePlanRequest, CreateUsagePlanResponse>()
                            .withOperationName("CreateUsagePlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUsagePlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUsagePlanRequest));
            CompletableFuture<CreateUsagePlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a usage plan key for adding an existing API key to a usage plan.
     * </p>
     *
     * @param createUsagePlanKeyRequest
     *        The POST request to create a usage plan key for adding an existing API key to a usage plan.
     * @return A Java Future containing the result of the CreateUsagePlanKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateUsagePlanKey
     */
    @Override
    public CompletableFuture<CreateUsagePlanKeyResponse> createUsagePlanKey(CreateUsagePlanKeyRequest createUsagePlanKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUsagePlanKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUsagePlanKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUsagePlanKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUsagePlanKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUsagePlanKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUsagePlanKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUsagePlanKeyRequest, CreateUsagePlanKeyResponse>()
                            .withOperationName("CreateUsagePlanKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUsagePlanKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUsagePlanKeyRequest));
            CompletableFuture<CreateUsagePlanKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically
     * takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC
     * Endpoint services.
     * </p>
     *
     * @param createVpcLinkRequest
     *        Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that
     *        typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create
     *        and update VPC Endpoint services.
     * @return A Java Future containing the result of the CreateVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateVpcLink
     */
    @Override
    public CompletableFuture<CreateVpcLinkResponse> createVpcLink(CreateVpcLinkRequest createVpcLinkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcLinkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateVpcLinkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateVpcLinkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcLinkRequest, CreateVpcLinkResponse>()
                            .withOperationName("CreateVpcLink").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVpcLinkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVpcLinkRequest));
            CompletableFuture<CreateVpcLinkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the ApiKey resource.
     * </p>
     *
     * @param deleteApiKeyRequest
     *        A request to delete the ApiKey resource.
     * @return A Java Future containing the result of the DeleteApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteApiKey
     */
    @Override
    public CompletableFuture<DeleteApiKeyResponse> deleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApiKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApiKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteApiKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteApiKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteApiKeyRequest, DeleteApiKeyResponse>()
                            .withOperationName("DeleteApiKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteApiKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteApiKeyRequest));
            CompletableFuture<DeleteApiKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing Authorizer resource.
     * </p>
     *
     * @param deleteAuthorizerRequest
     *        Request to delete an existing Authorizer resource.
     * @return A Java Future containing the result of the DeleteAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteAuthorizer
     */
    @Override
    public CompletableFuture<DeleteAuthorizerResponse> deleteAuthorizer(DeleteAuthorizerRequest deleteAuthorizerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAuthorizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAuthorizerRequest, DeleteAuthorizerResponse>()
                            .withOperationName("DeleteAuthorizer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAuthorizerRequest));
            CompletableFuture<DeleteAuthorizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the BasePathMapping resource.
     * </p>
     *
     * @param deleteBasePathMappingRequest
     *        A request to delete the BasePathMapping resource.
     * @return A Java Future containing the result of the DeleteBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteBasePathMapping
     */
    @Override
    public CompletableFuture<DeleteBasePathMappingResponse> deleteBasePathMapping(
            DeleteBasePathMappingRequest deleteBasePathMappingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBasePathMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBasePathMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBasePathMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBasePathMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBasePathMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBasePathMappingRequest, DeleteBasePathMappingResponse>()
                            .withOperationName("DeleteBasePathMapping").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBasePathMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBasePathMappingRequest));
            CompletableFuture<DeleteBasePathMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the ClientCertificate resource.
     * </p>
     *
     * @param deleteClientCertificateRequest
     *        A request to delete the ClientCertificate resource.
     * @return A Java Future containing the result of the DeleteClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteClientCertificate
     */
    @Override
    public CompletableFuture<DeleteClientCertificateResponse> deleteClientCertificate(
            DeleteClientCertificateRequest deleteClientCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClientCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClientCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClientCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteClientCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteClientCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteClientCertificateRequest, DeleteClientCertificateResponse>()
                            .withOperationName("DeleteClientCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteClientCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteClientCertificateRequest));
            CompletableFuture<DeleteClientCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Deployment resource. Deleting a deployment will only succeed if there are no Stage resources associated
     * with it.
     * </p>
     *
     * @param deleteDeploymentRequest
     *        Requests API Gateway to delete a Deployment resource.
     * @return A Java Future containing the result of the DeleteDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDeployment
     */
    @Override
    public CompletableFuture<DeleteDeploymentResponse> deleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeploymentRequest, DeleteDeploymentResponse>()
                            .withOperationName("DeleteDeployment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDeploymentRequest));
            CompletableFuture<DeleteDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a documentation part
     * </p>
     *
     * @param deleteDocumentationPartRequest
     *        Deletes an existing documentation part of an API.
     * @return A Java Future containing the result of the DeleteDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDocumentationPart
     */
    @Override
    public CompletableFuture<DeleteDocumentationPartResponse> deleteDocumentationPart(
            DeleteDocumentationPartRequest deleteDocumentationPartRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDocumentationPartRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDocumentationPartRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDocumentationPart");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDocumentationPartResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDocumentationPartResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDocumentationPartRequest, DeleteDocumentationPartResponse>()
                            .withOperationName("DeleteDocumentationPart").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDocumentationPartRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDocumentationPartRequest));
            CompletableFuture<DeleteDocumentationPartResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a documentation version.
     * </p>
     *
     * @param deleteDocumentationVersionRequest
     *        Deletes an existing documentation version of an API.
     * @return A Java Future containing the result of the DeleteDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDocumentationVersion
     */
    @Override
    public CompletableFuture<DeleteDocumentationVersionResponse> deleteDocumentationVersion(
            DeleteDocumentationVersionRequest deleteDocumentationVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDocumentationVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDocumentationVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDocumentationVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDocumentationVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDocumentationVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDocumentationVersionRequest, DeleteDocumentationVersionResponse>()
                            .withOperationName("DeleteDocumentationVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDocumentationVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDocumentationVersionRequest));
            CompletableFuture<DeleteDocumentationVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the DomainName resource.
     * </p>
     *
     * @param deleteDomainNameRequest
     *        A request to delete the DomainName resource.
     * @return A Java Future containing the result of the DeleteDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDomainName
     */
    @Override
    public CompletableFuture<DeleteDomainNameResponse> deleteDomainName(DeleteDomainNameRequest deleteDomainNameRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDomainNameRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDomainName");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDomainNameResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDomainNameResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDomainNameRequest, DeleteDomainNameResponse>()
                            .withOperationName("DeleteDomainName").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDomainNameRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDomainNameRequest));
            CompletableFuture<DeleteDomainNameResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Clears any customization of a GatewayResponse of a specified response type on the given RestApi and resets it
     * with the default settings.
     * </p>
     *
     * @param deleteGatewayResponseRequest
     *        Clears any customization of a GatewayResponse of a specified response type on the given RestApi and resets
     *        it with the default settings.
     * @return A Java Future containing the result of the DeleteGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteGatewayResponse
     */
    @Override
    public CompletableFuture<DeleteGatewayResponseResponse> deleteGatewayResponse(
            DeleteGatewayResponseRequest deleteGatewayResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGatewayResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGatewayResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGatewayResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteGatewayResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGatewayResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGatewayResponseRequest, DeleteGatewayResponseResponse>()
                            .withOperationName("DeleteGatewayResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGatewayResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGatewayResponseRequest));
            CompletableFuture<DeleteGatewayResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a delete integration.
     * </p>
     *
     * @param deleteIntegrationRequest
     *        Represents a delete integration request.
     * @return A Java Future containing the result of the DeleteIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteIntegration
     */
    @Override
    public CompletableFuture<DeleteIntegrationResponse> deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIntegrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIntegrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIntegrationRequest, DeleteIntegrationResponse>()
                            .withOperationName("DeleteIntegration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIntegrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIntegrationRequest));
            CompletableFuture<DeleteIntegrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a delete integration response.
     * </p>
     *
     * @param deleteIntegrationResponseRequest
     *        Represents a delete integration response request.
     * @return A Java Future containing the result of the DeleteIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteIntegrationResponse
     */
    @Override
    public CompletableFuture<DeleteIntegrationResponseResponse> deleteIntegrationResponse(
            DeleteIntegrationResponseRequest deleteIntegrationResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIntegrationResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntegrationResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntegrationResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIntegrationResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIntegrationResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIntegrationResponseRequest, DeleteIntegrationResponseResponse>()
                            .withOperationName("DeleteIntegrationResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIntegrationResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIntegrationResponseRequest));
            CompletableFuture<DeleteIntegrationResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing Method resource.
     * </p>
     *
     * @param deleteMethodRequest
     *        Request to delete an existing Method resource.
     * @return A Java Future containing the result of the DeleteMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteMethod
     */
    @Override
    public CompletableFuture<DeleteMethodResponse> deleteMethod(DeleteMethodRequest deleteMethodRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMethodRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMethodRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMethodResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteMethodResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMethodResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMethodRequest, DeleteMethodResponse>()
                            .withOperationName("DeleteMethod").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMethodRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMethodRequest));
            CompletableFuture<DeleteMethodResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing MethodResponse resource.
     * </p>
     *
     * @param deleteMethodResponseRequest
     *        A request to delete an existing MethodResponse resource.
     * @return A Java Future containing the result of the DeleteMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteMethodResponse
     */
    @Override
    public CompletableFuture<DeleteMethodResponseResponse> deleteMethodResponse(
            DeleteMethodResponseRequest deleteMethodResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMethodResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMethodResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMethodResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMethodResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMethodResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMethodResponseRequest, DeleteMethodResponseResponse>()
                            .withOperationName("DeleteMethodResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMethodResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMethodResponseRequest));
            CompletableFuture<DeleteMethodResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a model.
     * </p>
     *
     * @param deleteModelRequest
     *        Request to delete an existing model in an existing RestApi resource.
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteModel
     */
    @Override
    public CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest deleteModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteModelRequest, DeleteModelResponse>()
                            .withOperationName("DeleteModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteModelRequest));
            CompletableFuture<DeleteModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a RequestValidator of a given RestApi.
     * </p>
     *
     * @param deleteRequestValidatorRequest
     *        Deletes a specified RequestValidator of a given RestApi.
     * @return A Java Future containing the result of the DeleteRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteRequestValidator
     */
    @Override
    public CompletableFuture<DeleteRequestValidatorResponse> deleteRequestValidator(
            DeleteRequestValidatorRequest deleteRequestValidatorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRequestValidatorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRequestValidatorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRequestValidator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRequestValidatorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRequestValidatorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRequestValidatorRequest, DeleteRequestValidatorResponse>()
                            .withOperationName("DeleteRequestValidator").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRequestValidatorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRequestValidatorRequest));
            CompletableFuture<DeleteRequestValidatorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Resource resource.
     * </p>
     *
     * @param deleteResourceRequest
     *        Request to delete a Resource.
     * @return A Java Future containing the result of the DeleteResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteResource
     */
    @Override
    public CompletableFuture<DeleteResourceResponse> deleteResource(DeleteResourceRequest deleteResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceRequest, DeleteResourceResponse>()
                            .withOperationName("DeleteResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourceRequest));
            CompletableFuture<DeleteResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified API.
     * </p>
     *
     * @param deleteRestApiRequest
     *        Request to delete the specified API from your collection.
     * @return A Java Future containing the result of the DeleteRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteRestApi
     */
    @Override
    public CompletableFuture<DeleteRestApiResponse> deleteRestApi(DeleteRestApiRequest deleteRestApiRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRestApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRestApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRestApi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteRestApiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRestApiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRestApiRequest, DeleteRestApiResponse>()
                            .withOperationName("DeleteRestApi").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRestApiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRestApiRequest));
            CompletableFuture<DeleteRestApiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Stage resource.
     * </p>
     *
     * @param deleteStageRequest
     *        Requests API Gateway to delete a Stage resource.
     * @return A Java Future containing the result of the DeleteStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteStage
     */
    @Override
    public CompletableFuture<DeleteStageResponse> deleteStage(DeleteStageRequest deleteStageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteStageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteStageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteStageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStageRequest, DeleteStageResponse>()
                            .withOperationName("DeleteStage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteStageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteStageRequest));
            CompletableFuture<DeleteStageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a usage plan of a given plan Id.
     * </p>
     *
     * @param deleteUsagePlanRequest
     *        The DELETE request to delete a usage plan of a given plan Id.
     * @return A Java Future containing the result of the DeleteUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteUsagePlan
     */
    @Override
    public CompletableFuture<DeleteUsagePlanResponse> deleteUsagePlan(DeleteUsagePlanRequest deleteUsagePlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUsagePlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUsagePlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUsagePlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUsagePlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUsagePlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUsagePlanRequest, DeleteUsagePlanResponse>()
                            .withOperationName("DeleteUsagePlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUsagePlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUsagePlanRequest));
            CompletableFuture<DeleteUsagePlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a usage plan key and remove the underlying API key from the associated usage plan.
     * </p>
     *
     * @param deleteUsagePlanKeyRequest
     *        The DELETE request to delete a usage plan key and remove the underlying API key from the associated usage
     *        plan.
     * @return A Java Future containing the result of the DeleteUsagePlanKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteUsagePlanKey
     */
    @Override
    public CompletableFuture<DeleteUsagePlanKeyResponse> deleteUsagePlanKey(DeleteUsagePlanKeyRequest deleteUsagePlanKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUsagePlanKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUsagePlanKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUsagePlanKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUsagePlanKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUsagePlanKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUsagePlanKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUsagePlanKeyRequest, DeleteUsagePlanKeyResponse>()
                            .withOperationName("DeleteUsagePlanKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUsagePlanKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUsagePlanKeyRequest));
            CompletableFuture<DeleteUsagePlanKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing VpcLink of a specified identifier.
     * </p>
     *
     * @param deleteVpcLinkRequest
     *        Deletes an existing VpcLink of a specified identifier.
     * @return A Java Future containing the result of the DeleteVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteVpcLink
     */
    @Override
    public CompletableFuture<DeleteVpcLinkResponse> deleteVpcLink(DeleteVpcLinkRequest deleteVpcLinkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcLinkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpcLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteVpcLinkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVpcLinkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcLinkRequest, DeleteVpcLinkResponse>()
                            .withOperationName("DeleteVpcLink").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteVpcLinkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVpcLinkRequest));
            CompletableFuture<DeleteVpcLinkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Flushes all authorizer cache entries on a stage.
     * </p>
     *
     * @param flushStageAuthorizersCacheRequest
     *        Request to flush authorizer cache entries on a specified stage.
     * @return A Java Future containing the result of the FlushStageAuthorizersCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.FlushStageAuthorizersCache
     */
    @Override
    public CompletableFuture<FlushStageAuthorizersCacheResponse> flushStageAuthorizersCache(
            FlushStageAuthorizersCacheRequest flushStageAuthorizersCacheRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(flushStageAuthorizersCacheRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, flushStageAuthorizersCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FlushStageAuthorizersCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<FlushStageAuthorizersCacheResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, FlushStageAuthorizersCacheResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<FlushStageAuthorizersCacheResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<FlushStageAuthorizersCacheRequest, FlushStageAuthorizersCacheResponse>()
                            .withOperationName("FlushStageAuthorizersCache").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new FlushStageAuthorizersCacheRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(flushStageAuthorizersCacheRequest));
            CompletableFuture<FlushStageAuthorizersCacheResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Flushes a stage's cache.
     * </p>
     *
     * @param flushStageCacheRequest
     *        Requests API Gateway to flush a stage's cache.
     * @return A Java Future containing the result of the FlushStageCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.FlushStageCache
     */
    @Override
    public CompletableFuture<FlushStageCacheResponse> flushStageCache(FlushStageCacheRequest flushStageCacheRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(flushStageCacheRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, flushStageCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FlushStageCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<FlushStageCacheResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, FlushStageCacheResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<FlushStageCacheResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<FlushStageCacheRequest, FlushStageCacheResponse>()
                            .withOperationName("FlushStageCache").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new FlushStageCacheRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(flushStageCacheRequest));
            CompletableFuture<FlushStageCacheResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates a ClientCertificate resource.
     * </p>
     *
     * @param generateClientCertificateRequest
     *        A request to generate a ClientCertificate resource.
     * @return A Java Future containing the result of the GenerateClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GenerateClientCertificate
     */
    @Override
    public CompletableFuture<GenerateClientCertificateResponse> generateClientCertificate(
            GenerateClientCertificateRequest generateClientCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(generateClientCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, generateClientCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateClientCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GenerateClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GenerateClientCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GenerateClientCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GenerateClientCertificateRequest, GenerateClientCertificateResponse>()
                            .withOperationName("GenerateClientCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GenerateClientCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(generateClientCertificateRequest));
            CompletableFuture<GenerateClientCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the current Account resource.
     * </p>
     *
     * @param getAccountRequest
     *        Requests API Gateway to get information about the current Account resource.
     * @return A Java Future containing the result of the GetAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetAccount
     */
    @Override
    public CompletableFuture<GetAccountResponse> getAccount(GetAccountRequest getAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAccountResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccountRequest, GetAccountResponse>().withOperationName("GetAccount")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccountRequest));
            CompletableFuture<GetAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the current ApiKey resource.
     * </p>
     *
     * @param getApiKeyRequest
     *        A request to get information about the current ApiKey resource.
     * @return A Java Future containing the result of the GetApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetApiKey
     */
    @Override
    public CompletableFuture<GetApiKeyResponse> getApiKey(GetApiKeyRequest getApiKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApiKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApiKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetApiKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApiKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApiKeyRequest, GetApiKeyResponse>().withOperationName("GetApiKey")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetApiKeyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getApiKeyRequest));
            CompletableFuture<GetApiKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the current ApiKeys resource.
     * </p>
     *
     * @param getApiKeysRequest
     *        A request to get information about the current ApiKeys resource.
     * @return A Java Future containing the result of the GetApiKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetApiKeys
     */
    @Override
    public CompletableFuture<GetApiKeysResponse> getApiKeys(GetApiKeysRequest getApiKeysRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApiKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApiKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApiKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApiKeysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetApiKeysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApiKeysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApiKeysRequest, GetApiKeysResponse>().withOperationName("GetApiKeys")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetApiKeysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getApiKeysRequest));
            CompletableFuture<GetApiKeysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe an existing Authorizer resource.
     * </p>
     *
     * @param getAuthorizerRequest
     *        Request to describe an existing Authorizer resource.
     * @return A Java Future containing the result of the GetAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetAuthorizer
     */
    @Override
    public CompletableFuture<GetAuthorizerResponse> getAuthorizer(GetAuthorizerRequest getAuthorizerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAuthorizerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAuthorizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAuthorizerRequest, GetAuthorizerResponse>()
                            .withOperationName("GetAuthorizer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAuthorizerRequest));
            CompletableFuture<GetAuthorizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe an existing Authorizers resource.
     * </p>
     *
     * @param getAuthorizersRequest
     *        Request to describe an existing Authorizers resource.
     * @return A Java Future containing the result of the GetAuthorizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetAuthorizers
     */
    @Override
    public CompletableFuture<GetAuthorizersResponse> getAuthorizers(GetAuthorizersRequest getAuthorizersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAuthorizersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAuthorizersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAuthorizers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAuthorizersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAuthorizersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAuthorizersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAuthorizersRequest, GetAuthorizersResponse>()
                            .withOperationName("GetAuthorizers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAuthorizersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAuthorizersRequest));
            CompletableFuture<GetAuthorizersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe a BasePathMapping resource.
     * </p>
     *
     * @param getBasePathMappingRequest
     *        Request to describe a BasePathMapping resource.
     * @return A Java Future containing the result of the GetBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetBasePathMapping
     */
    @Override
    public CompletableFuture<GetBasePathMappingResponse> getBasePathMapping(GetBasePathMappingRequest getBasePathMappingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBasePathMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBasePathMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBasePathMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBasePathMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBasePathMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBasePathMappingRequest, GetBasePathMappingResponse>()
                            .withOperationName("GetBasePathMapping").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBasePathMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBasePathMappingRequest));
            CompletableFuture<GetBasePathMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a collection of BasePathMapping resources.
     * </p>
     *
     * @param getBasePathMappingsRequest
     *        A request to get information about a collection of BasePathMapping resources.
     * @return A Java Future containing the result of the GetBasePathMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetBasePathMappings
     */
    @Override
    public CompletableFuture<GetBasePathMappingsResponse> getBasePathMappings(
            GetBasePathMappingsRequest getBasePathMappingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBasePathMappingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBasePathMappingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBasePathMappings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBasePathMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBasePathMappingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBasePathMappingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBasePathMappingsRequest, GetBasePathMappingsResponse>()
                            .withOperationName("GetBasePathMappings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBasePathMappingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBasePathMappingsRequest));
            CompletableFuture<GetBasePathMappingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the current ClientCertificate resource.
     * </p>
     *
     * @param getClientCertificateRequest
     *        A request to get information about the current ClientCertificate resource.
     * @return A Java Future containing the result of the GetClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetClientCertificate
     */
    @Override
    public CompletableFuture<GetClientCertificateResponse> getClientCertificate(
            GetClientCertificateRequest getClientCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getClientCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getClientCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetClientCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetClientCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetClientCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetClientCertificateRequest, GetClientCertificateResponse>()
                            .withOperationName("GetClientCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetClientCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getClientCertificateRequest));
            CompletableFuture<GetClientCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a collection of ClientCertificate resources.
     * </p>
     *
     * @param getClientCertificatesRequest
     *        A request to get information about a collection of ClientCertificate resources.
     * @return A Java Future containing the result of the GetClientCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetClientCertificates
     */
    @Override
    public CompletableFuture<GetClientCertificatesResponse> getClientCertificates(
            GetClientCertificatesRequest getClientCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getClientCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getClientCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetClientCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetClientCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetClientCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetClientCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetClientCertificatesRequest, GetClientCertificatesResponse>()
                            .withOperationName("GetClientCertificates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetClientCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getClientCertificatesRequest));
            CompletableFuture<GetClientCertificatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a Deployment resource.
     * </p>
     *
     * @param getDeploymentRequest
     *        Requests API Gateway to get information about a Deployment resource.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDeployment
     */
    @Override
    public CompletableFuture<GetDeploymentResponse> getDeployment(GetDeploymentRequest getDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeploymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeploymentRequest, GetDeploymentResponse>()
                            .withOperationName("GetDeployment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeploymentRequest));
            CompletableFuture<GetDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a Deployments collection.
     * </p>
     *
     * @param getDeploymentsRequest
     *        Requests API Gateway to get information about a Deployments collection.
     * @return A Java Future containing the result of the GetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDeployments
     */
    @Override
    public CompletableFuture<GetDeploymentsResponse> getDeployments(GetDeploymentsRequest getDeploymentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeploymentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeployments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeploymentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeploymentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeploymentsRequest, GetDeploymentsResponse>()
                            .withOperationName("GetDeployments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDeploymentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDeploymentsRequest));
            CompletableFuture<GetDeploymentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a documentation part.
     * </p>
     *
     * @param getDocumentationPartRequest
     *        Gets a specified documentation part of a given API.
     * @return A Java Future containing the result of the GetDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationPart
     */
    @Override
    public CompletableFuture<GetDocumentationPartResponse> getDocumentationPart(
            GetDocumentationPartRequest getDocumentationPartRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDocumentationPartRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentationPartRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocumentationPart");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDocumentationPartResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDocumentationPartResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDocumentationPartRequest, GetDocumentationPartResponse>()
                            .withOperationName("GetDocumentationPart").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDocumentationPartRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDocumentationPartRequest));
            CompletableFuture<GetDocumentationPartResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets documentation parts.
     * </p>
     *
     * @param getDocumentationPartsRequest
     *        Gets the documentation parts of an API. The result may be filtered by the type, name, or path of API
     *        entities (targets).
     * @return A Java Future containing the result of the GetDocumentationParts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationParts
     */
    @Override
    public CompletableFuture<GetDocumentationPartsResponse> getDocumentationParts(
            GetDocumentationPartsRequest getDocumentationPartsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDocumentationPartsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentationPartsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocumentationParts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDocumentationPartsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDocumentationPartsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDocumentationPartsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDocumentationPartsRequest, GetDocumentationPartsResponse>()
                            .withOperationName("GetDocumentationParts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDocumentationPartsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDocumentationPartsRequest));
            CompletableFuture<GetDocumentationPartsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a documentation version.
     * </p>
     *
     * @param getDocumentationVersionRequest
     *        Gets a documentation snapshot of an API.
     * @return A Java Future containing the result of the GetDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationVersion
     */
    @Override
    public CompletableFuture<GetDocumentationVersionResponse> getDocumentationVersion(
            GetDocumentationVersionRequest getDocumentationVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDocumentationVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentationVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocumentationVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDocumentationVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDocumentationVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDocumentationVersionRequest, GetDocumentationVersionResponse>()
                            .withOperationName("GetDocumentationVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDocumentationVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDocumentationVersionRequest));
            CompletableFuture<GetDocumentationVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets documentation versions.
     * </p>
     *
     * @param getDocumentationVersionsRequest
     *        Gets the documentation versions of an API.
     * @return A Java Future containing the result of the GetDocumentationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationVersions
     */
    @Override
    public CompletableFuture<GetDocumentationVersionsResponse> getDocumentationVersions(
            GetDocumentationVersionsRequest getDocumentationVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDocumentationVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentationVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocumentationVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDocumentationVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDocumentationVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDocumentationVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDocumentationVersionsRequest, GetDocumentationVersionsResponse>()
                            .withOperationName("GetDocumentationVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDocumentationVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDocumentationVersionsRequest));
            CompletableFuture<GetDocumentationVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a domain name that is contained in a simpler, more intuitive URL that can be called.
     * </p>
     *
     * @param getDomainNameRequest
     *        Request to get the name of a DomainName resource.
     * @return A Java Future containing the result of the GetDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDomainName
     */
    @Override
    public CompletableFuture<GetDomainNameResponse> getDomainName(GetDomainNameRequest getDomainNameRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDomainNameRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDomainName");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDomainNameResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDomainNameResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDomainNameRequest, GetDomainNameResponse>()
                            .withOperationName("GetDomainName").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDomainNameRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDomainNameRequest));
            CompletableFuture<GetDomainNameResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a collection of DomainName resources.
     * </p>
     *
     * @param getDomainNamesRequest
     *        Request to describe a collection of DomainName resources.
     * @return A Java Future containing the result of the GetDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDomainNames
     */
    @Override
    public CompletableFuture<GetDomainNamesResponse> getDomainNames(GetDomainNamesRequest getDomainNamesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDomainNamesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDomainNamesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDomainNames");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDomainNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDomainNamesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDomainNamesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDomainNamesRequest, GetDomainNamesResponse>()
                            .withOperationName("GetDomainNames").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDomainNamesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDomainNamesRequest));
            CompletableFuture<GetDomainNamesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Exports a deployed version of a RestApi in a specified format.
     * </p>
     *
     * @param getExportRequest
     *        Request a new export of a RestApi for a particular Stage.
     * @return A Java Future containing the result of the GetExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetExport
     */
    @Override
    public CompletableFuture<GetExportResponse> getExport(GetExportRequest getExportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getExportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetExport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(false).build();

            HttpResponseHandler<GetExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetExportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetExportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetExportRequest, GetExportResponse>().withOperationName("GetExport")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetExportRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getExportRequest));
            CompletableFuture<GetExportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a GatewayResponse of a specified response type on the given RestApi.
     * </p>
     *
     * @param getGatewayResponseRequest
     *        Gets a GatewayResponse of a specified response type on the given RestApi.
     * @return A Java Future containing the result of the GetGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetGatewayResponse
     */
    @Override
    public CompletableFuture<GetGatewayResponseResponse> getGatewayResponse(GetGatewayResponseRequest getGatewayResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGatewayResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGatewayResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGatewayResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetGatewayResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGatewayResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGatewayResponseRequest, GetGatewayResponseResponse>()
                            .withOperationName("GetGatewayResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetGatewayResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getGatewayResponseRequest));
            CompletableFuture<GetGatewayResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any definitions for
     * gateway responses, the result will be the API Gateway-generated default GatewayResponses collection for the
     * supported response types.
     * </p>
     *
     * @param getGatewayResponsesRequest
     *        Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any
     *        definitions for gateway responses, the result will be the API Gateway-generated default GatewayResponses
     *        collection for the supported response types.
     * @return A Java Future containing the result of the GetGatewayResponses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetGatewayResponses
     */
    @Override
    public CompletableFuture<GetGatewayResponsesResponse> getGatewayResponses(
            GetGatewayResponsesRequest getGatewayResponsesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGatewayResponsesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGatewayResponsesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGatewayResponses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGatewayResponsesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetGatewayResponsesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGatewayResponsesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGatewayResponsesRequest, GetGatewayResponsesResponse>()
                            .withOperationName("GetGatewayResponses").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetGatewayResponsesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getGatewayResponsesRequest));
            CompletableFuture<GetGatewayResponsesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the integration settings.
     * </p>
     *
     * @param getIntegrationRequest
     *        Represents a request to get the integration configuration.
     * @return A Java Future containing the result of the GetIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetIntegration
     */
    @Override
    public CompletableFuture<GetIntegrationResponse> getIntegration(GetIntegrationRequest getIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIntegrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIntegrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIntegrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIntegrationRequest, GetIntegrationResponse>()
                            .withOperationName("GetIntegration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIntegrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getIntegrationRequest));
            CompletableFuture<GetIntegrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a get integration response.
     * </p>
     *
     * @param getIntegrationResponseRequest
     *        Represents a get integration response request.
     * @return A Java Future containing the result of the GetIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetIntegrationResponse
     */
    @Override
    public CompletableFuture<GetIntegrationResponseResponse> getIntegrationResponse(
            GetIntegrationResponseRequest getIntegrationResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIntegrationResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntegrationResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntegrationResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIntegrationResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIntegrationResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIntegrationResponseRequest, GetIntegrationResponseResponse>()
                            .withOperationName("GetIntegrationResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetIntegrationResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getIntegrationResponseRequest));
            CompletableFuture<GetIntegrationResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe an existing Method resource.
     * </p>
     *
     * @param getMethodRequest
     *        Request to describe an existing Method resource.
     * @return A Java Future containing the result of the GetMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetMethod
     */
    @Override
    public CompletableFuture<GetMethodResponse> getMethod(GetMethodRequest getMethodRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMethodRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMethodRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMethodResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMethodResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMethodResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMethodRequest, GetMethodResponse>().withOperationName("GetMethod")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMethodRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getMethodRequest));
            CompletableFuture<GetMethodResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a MethodResponse resource.
     * </p>
     *
     * @param getMethodResponseRequest
     *        Request to describe a MethodResponse resource.
     * @return A Java Future containing the result of the GetMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetMethodResponse
     */
    @Override
    public CompletableFuture<GetMethodResponseResponse> getMethodResponse(GetMethodResponseRequest getMethodResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMethodResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMethodResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMethodResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMethodResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMethodResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMethodResponseRequest, GetMethodResponseResponse>()
                            .withOperationName("GetMethodResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMethodResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMethodResponseRequest));
            CompletableFuture<GetMethodResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an existing model defined for a RestApi resource.
     * </p>
     *
     * @param getModelRequest
     *        Request to list information about a model in an existing RestApi resource.
     * @return A Java Future containing the result of the GetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModel
     */
    @Override
    public CompletableFuture<GetModelResponse> getModel(GetModelRequest getModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetModelRequest, GetModelResponse>().withOperationName("GetModel")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetModelRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getModelRequest));
            CompletableFuture<GetModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates a sample mapping template that can be used to transform a payload into the structure of a model.
     * </p>
     *
     * @param getModelTemplateRequest
     *        Request to generate a sample mapping template used to transform the payload.
     * @return A Java Future containing the result of the GetModelTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModelTemplate
     */
    @Override
    public CompletableFuture<GetModelTemplateResponse> getModelTemplate(GetModelTemplateRequest getModelTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getModelTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModelTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetModelTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetModelTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetModelTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetModelTemplateRequest, GetModelTemplateResponse>()
                            .withOperationName("GetModelTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetModelTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getModelTemplateRequest));
            CompletableFuture<GetModelTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes existing Models defined for a RestApi resource.
     * </p>
     *
     * @param getModelsRequest
     *        Request to list existing Models defined for a RestApi resource.
     * @return A Java Future containing the result of the GetModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModels
     */
    @Override
    public CompletableFuture<GetModelsResponse> getModels(GetModelsRequest getModelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getModelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetModels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetModelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetModelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetModelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetModelsRequest, GetModelsResponse>().withOperationName("GetModels")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetModelsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getModelsRequest));
            CompletableFuture<GetModelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a RequestValidator of a given RestApi.
     * </p>
     *
     * @param getRequestValidatorRequest
     *        Gets a RequestValidator of a given RestApi.
     * @return A Java Future containing the result of the GetRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRequestValidator
     */
    @Override
    public CompletableFuture<GetRequestValidatorResponse> getRequestValidator(
            GetRequestValidatorRequest getRequestValidatorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRequestValidatorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRequestValidatorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRequestValidator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRequestValidatorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRequestValidatorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRequestValidatorRequest, GetRequestValidatorResponse>()
                            .withOperationName("GetRequestValidator").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRequestValidatorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRequestValidatorRequest));
            CompletableFuture<GetRequestValidatorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the RequestValidators collection of a given RestApi.
     * </p>
     *
     * @param getRequestValidatorsRequest
     *        Gets the RequestValidators collection of a given RestApi.
     * @return A Java Future containing the result of the GetRequestValidators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRequestValidators
     */
    @Override
    public CompletableFuture<GetRequestValidatorsResponse> getRequestValidators(
            GetRequestValidatorsRequest getRequestValidatorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRequestValidatorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRequestValidatorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRequestValidators");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRequestValidatorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRequestValidatorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRequestValidatorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRequestValidatorsRequest, GetRequestValidatorsResponse>()
                            .withOperationName("GetRequestValidators").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRequestValidatorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRequestValidatorsRequest));
            CompletableFuture<GetRequestValidatorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about a resource.
     * </p>
     *
     * @param getResourceRequest
     *        Request to list information about a resource.
     * @return A Java Future containing the result of the GetResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetResource
     */
    @Override
    public CompletableFuture<GetResourceResponse> getResource(GetResourceRequest getResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourceRequest, GetResourceResponse>()
                            .withOperationName("GetResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResourceRequest));
            CompletableFuture<GetResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about a collection of Resource resources.
     * </p>
     *
     * @param getResourcesRequest
     *        Request to list information about a collection of resources.
     * @return A Java Future containing the result of the GetResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetResources
     */
    @Override
    public CompletableFuture<GetResourcesResponse> getResources(GetResourcesRequest getResourcesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourcesRequest, GetResourcesResponse>()
                            .withOperationName("GetResources").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResourcesRequest));
            CompletableFuture<GetResourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the RestApi resource in the collection.
     * </p>
     *
     * @param getRestApiRequest
     *        The GET request to list an existing RestApi defined for your collection.
     * @return A Java Future containing the result of the GetRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRestApi
     */
    @Override
    public CompletableFuture<GetRestApiResponse> getRestApi(GetRestApiRequest getRestApiRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRestApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRestApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRestApi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetRestApiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRestApiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRestApiRequest, GetRestApiResponse>().withOperationName("GetRestApi")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRestApiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRestApiRequest));
            CompletableFuture<GetRestApiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the RestApis resources for your collection.
     * </p>
     *
     * @param getRestApisRequest
     *        The GET request to list existing RestApis defined for your collection.
     * @return A Java Future containing the result of the GetRestApis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRestApis
     */
    @Override
    public CompletableFuture<GetRestApisResponse> getRestApis(GetRestApisRequest getRestApisRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRestApisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRestApisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRestApis");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRestApisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetRestApisResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRestApisResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRestApisRequest, GetRestApisResponse>()
                            .withOperationName("GetRestApis").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRestApisRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRestApisRequest));
            CompletableFuture<GetRestApisResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates a client SDK for a RestApi and Stage.
     * </p>
     *
     * @param getSdkRequest
     *        Request a new generated client SDK for a RestApi and Stage.
     * @return A Java Future containing the result of the GetSdk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetSdk
     */
    @Override
    public CompletableFuture<GetSdkResponse> getSdk(GetSdkRequest getSdkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSdkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSdkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSdk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(false).build();

            HttpResponseHandler<GetSdkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSdkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSdkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSdkRequest, GetSdkResponse>().withOperationName("GetSdk")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetSdkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSdkRequest));
            CompletableFuture<GetSdkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an SDK type.
     * </p>
     *
     * @param getSdkTypeRequest
     *        Get an SdkType instance.
     * @return A Java Future containing the result of the GetSdkType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetSdkType
     */
    @Override
    public CompletableFuture<GetSdkTypeResponse> getSdkType(GetSdkTypeRequest getSdkTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSdkTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSdkTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSdkType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSdkTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSdkTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSdkTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSdkTypeRequest, GetSdkTypeResponse>().withOperationName("GetSdkType")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSdkTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSdkTypeRequest));
            CompletableFuture<GetSdkTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets SDK types
     * </p>
     *
     * @param getSdkTypesRequest
     *        Get the SdkTypes collection.
     * @return A Java Future containing the result of the GetSdkTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetSdkTypes
     */
    @Override
    public CompletableFuture<GetSdkTypesResponse> getSdkTypes(GetSdkTypesRequest getSdkTypesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSdkTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSdkTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSdkTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSdkTypesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSdkTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSdkTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSdkTypesRequest, GetSdkTypesResponse>()
                            .withOperationName("GetSdkTypes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSdkTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSdkTypesRequest));
            CompletableFuture<GetSdkTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a Stage resource.
     * </p>
     *
     * @param getStageRequest
     *        Requests API Gateway to get information about a Stage resource.
     * @return A Java Future containing the result of the GetStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetStage
     */
    @Override
    public CompletableFuture<GetStageResponse> getStage(GetStageRequest getStageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetStageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStageRequest, GetStageResponse>().withOperationName("GetStage")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetStageRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getStageRequest));
            CompletableFuture<GetStageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more Stage resources.
     * </p>
     *
     * @param getStagesRequest
     *        Requests API Gateway to get information about one or more Stage resources.
     * @return A Java Future containing the result of the GetStages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetStages
     */
    @Override
    public CompletableFuture<GetStagesResponse> getStages(GetStagesRequest getStagesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetStagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStagesRequest, GetStagesResponse>().withOperationName("GetStages")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetStagesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getStagesRequest));
            CompletableFuture<GetStagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the Tags collection for a given resource.
     * </p>
     *
     * @param getTagsRequest
     *        Gets the Tags collection for a given resource.
     * @return A Java Future containing the result of the GetTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetTags
     */
    @Override
    public CompletableFuture<GetTagsResponse> getTags(GetTagsRequest getTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTagsRequest, GetTagsResponse>().withOperationName("GetTags")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTagsRequest));
            CompletableFuture<GetTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the usage data of a usage plan in a specified time interval.
     * </p>
     *
     * @param getUsageRequest
     *        The GET request to get the usage data of a usage plan in a specified time interval.
     * @return A Java Future containing the result of the GetUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsage
     */
    @Override
    public CompletableFuture<GetUsageResponse> getUsage(GetUsageRequest getUsageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetUsageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsageRequest, GetUsageResponse>().withOperationName("GetUsage")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUsageRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getUsageRequest));
            CompletableFuture<GetUsageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a usage plan of a given plan identifier.
     * </p>
     *
     * @param getUsagePlanRequest
     *        The GET request to get a usage plan of a given plan identifier.
     * @return A Java Future containing the result of the GetUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlan
     */
    @Override
    public CompletableFuture<GetUsagePlanResponse> getUsagePlan(GetUsagePlanRequest getUsagePlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUsagePlanRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsagePlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsagePlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetUsagePlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsagePlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsagePlanRequest, GetUsagePlanResponse>()
                            .withOperationName("GetUsagePlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUsagePlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUsagePlanRequest));
            CompletableFuture<GetUsagePlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a usage plan key of a given key identifier.
     * </p>
     *
     * @param getUsagePlanKeyRequest
     *        The GET request to get a usage plan key of a given key identifier.
     * @return A Java Future containing the result of the GetUsagePlanKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlanKey
     */
    @Override
    public CompletableFuture<GetUsagePlanKeyResponse> getUsagePlanKey(GetUsagePlanKeyRequest getUsagePlanKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUsagePlanKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsagePlanKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsagePlanKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsagePlanKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUsagePlanKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsagePlanKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsagePlanKeyRequest, GetUsagePlanKeyResponse>()
                            .withOperationName("GetUsagePlanKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUsagePlanKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUsagePlanKeyRequest));
            CompletableFuture<GetUsagePlanKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     * </p>
     *
     * @param getUsagePlanKeysRequest
     *        The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.
     * @return A Java Future containing the result of the GetUsagePlanKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlanKeys
     */
    @Override
    public CompletableFuture<GetUsagePlanKeysResponse> getUsagePlanKeys(GetUsagePlanKeysRequest getUsagePlanKeysRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUsagePlanKeysRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsagePlanKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsagePlanKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsagePlanKeysResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUsagePlanKeysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsagePlanKeysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsagePlanKeysRequest, GetUsagePlanKeysResponse>()
                            .withOperationName("GetUsagePlanKeys").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUsagePlanKeysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUsagePlanKeysRequest));
            CompletableFuture<GetUsagePlanKeysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     *
     * @param getUsagePlansRequest
     *        The GET request to get all the usage plans of the caller's account.
     * @return A Java Future containing the result of the GetUsagePlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlans
     */
    @Override
    public CompletableFuture<GetUsagePlansResponse> getUsagePlans(GetUsagePlansRequest getUsagePlansRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUsagePlansRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsagePlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsagePlans");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsagePlansResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetUsagePlansResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsagePlansResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsagePlansRequest, GetUsagePlansResponse>()
                            .withOperationName("GetUsagePlans").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUsagePlansRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUsagePlansRequest));
            CompletableFuture<GetUsagePlansResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a specified VPC link under the caller's account in a region.
     * </p>
     *
     * @param getVpcLinkRequest
     *        Gets a specified VPC link under the caller's account in a region.
     * @return A Java Future containing the result of the GetVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetVpcLink
     */
    @Override
    public CompletableFuture<GetVpcLinkResponse> getVpcLink(GetVpcLinkRequest getVpcLinkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVpcLinkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVpcLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVpcLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetVpcLinkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVpcLinkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVpcLinkRequest, GetVpcLinkResponse>().withOperationName("GetVpcLink")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetVpcLinkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getVpcLinkRequest));
            CompletableFuture<GetVpcLinkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the VpcLinks collection under the caller's account in a selected region.
     * </p>
     *
     * @param getVpcLinksRequest
     *        Gets the VpcLinks collection under the caller's account in a selected region.
     * @return A Java Future containing the result of the GetVpcLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetVpcLinks
     */
    @Override
    public CompletableFuture<GetVpcLinksResponse> getVpcLinks(GetVpcLinksRequest getVpcLinksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVpcLinksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVpcLinksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVpcLinks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVpcLinksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetVpcLinksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVpcLinksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVpcLinksRequest, GetVpcLinksResponse>()
                            .withOperationName("GetVpcLinks").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetVpcLinksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getVpcLinksRequest));
            CompletableFuture<GetVpcLinksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Import API keys from an external source, such as a CSV-formatted file.
     * </p>
     *
     * @param importApiKeysRequest
     *        The POST request to import API keys from an external source, such as a CSV-formatted file.
     * @return A Java Future containing the result of the ImportApiKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.ImportApiKeys
     */
    @Override
    public CompletableFuture<ImportApiKeysResponse> importApiKeys(ImportApiKeysRequest importApiKeysRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importApiKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importApiKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportApiKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportApiKeysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ImportApiKeysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportApiKeysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportApiKeysRequest, ImportApiKeysResponse>()
                            .withOperationName("ImportApiKeys").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ImportApiKeysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(importApiKeysRequest));
            CompletableFuture<ImportApiKeysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Imports documentation parts
     * </p>
     *
     * @param importDocumentationPartsRequest
     *        Import documentation parts from an external (e.g., OpenAPI) definition file.
     * @return A Java Future containing the result of the ImportDocumentationParts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.ImportDocumentationParts
     */
    @Override
    public CompletableFuture<ImportDocumentationPartsResponse> importDocumentationParts(
            ImportDocumentationPartsRequest importDocumentationPartsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importDocumentationPartsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importDocumentationPartsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportDocumentationParts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportDocumentationPartsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ImportDocumentationPartsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportDocumentationPartsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportDocumentationPartsRequest, ImportDocumentationPartsResponse>()
                            .withOperationName("ImportDocumentationParts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ImportDocumentationPartsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(importDocumentationPartsRequest));
            CompletableFuture<ImportDocumentationPartsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A feature of the API Gateway control service for creating a new API from an external API definition file.
     * </p>
     *
     * @param importRestApiRequest
     *        A POST request to import an API to API Gateway using an input of an API definition file.
     * @return A Java Future containing the result of the ImportRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.ImportRestApi
     */
    @Override
    public CompletableFuture<ImportRestApiResponse> importRestApi(ImportRestApiRequest importRestApiRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importRestApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importRestApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportRestApi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ImportRestApiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportRestApiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportRestApiRequest, ImportRestApiResponse>()
                            .withOperationName("ImportRestApi").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ImportRestApiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(importRestApiRequest));
            CompletableFuture<ImportRestApiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a customization of a GatewayResponse of a specified response type and status code on the given RestApi.
     * </p>
     *
     * @param putGatewayResponseRequest
     *        Creates a customization of a GatewayResponse of a specified response type and status code on the given
     *        RestApi.
     * @return A Java Future containing the result of the PutGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutGatewayResponse
     */
    @Override
    public CompletableFuture<PutGatewayResponseResponse> putGatewayResponse(PutGatewayResponseRequest putGatewayResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putGatewayResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putGatewayResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutGatewayResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutGatewayResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutGatewayResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutGatewayResponseRequest, PutGatewayResponseResponse>()
                            .withOperationName("PutGatewayResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutGatewayResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putGatewayResponseRequest));
            CompletableFuture<PutGatewayResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets up a method's integration.
     * </p>
     *
     * @param putIntegrationRequest
     *        Sets up a method's integration.
     * @return A Java Future containing the result of the PutIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutIntegration
     */
    @Override
    public CompletableFuture<PutIntegrationResponse> putIntegration(PutIntegrationRequest putIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putIntegrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutIntegrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutIntegrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutIntegrationRequest, PutIntegrationResponse>()
                            .withOperationName("PutIntegration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutIntegrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putIntegrationRequest));
            CompletableFuture<PutIntegrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents a put integration.
     * </p>
     *
     * @param putIntegrationResponseRequest
     *        Represents a put integration response request.
     * @return A Java Future containing the result of the PutIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutIntegrationResponse
     */
    @Override
    public CompletableFuture<PutIntegrationResponseResponse> putIntegrationResponse(
            PutIntegrationResponseRequest putIntegrationResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putIntegrationResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putIntegrationResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutIntegrationResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutIntegrationResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutIntegrationResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutIntegrationResponseRequest, PutIntegrationResponseResponse>()
                            .withOperationName("PutIntegrationResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutIntegrationResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putIntegrationResponseRequest));
            CompletableFuture<PutIntegrationResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Add a method to an existing Resource resource.
     * </p>
     *
     * @param putMethodRequest
     *        Request to add a method to an existing Resource resource.
     * @return A Java Future containing the result of the PutMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutMethod
     */
    @Override
    public CompletableFuture<PutMethodResponse> putMethod(PutMethodRequest putMethodRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putMethodRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putMethodRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutMethodResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutMethodResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutMethodResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutMethodRequest, PutMethodResponse>().withOperationName("PutMethod")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutMethodRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(putMethodRequest));
            CompletableFuture<PutMethodResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a MethodResponse to an existing Method resource.
     * </p>
     *
     * @param putMethodResponseRequest
     *        Request to add a MethodResponse to an existing Method resource.
     * @return A Java Future containing the result of the PutMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutMethodResponse
     */
    @Override
    public CompletableFuture<PutMethodResponseResponse> putMethodResponse(PutMethodResponseRequest putMethodResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putMethodResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putMethodResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMethodResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutMethodResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutMethodResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutMethodResponseRequest, PutMethodResponseResponse>()
                            .withOperationName("PutMethodResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutMethodResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putMethodResponseRequest));
            CompletableFuture<PutMethodResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A feature of the API Gateway control service for updating an existing API with an input of external API
     * definitions. The update can take the form of merging the supplied definition into the existing API or overwriting
     * the existing API.
     * </p>
     *
     * @param putRestApiRequest
     *        A PUT request to update an existing API, with external API definitions specified as the request body.
     * @return A Java Future containing the result of the PutRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutRestApi
     */
    @Override
    public CompletableFuture<PutRestApiResponse> putRestApi(PutRestApiRequest putRestApiRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putRestApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRestApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRestApi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutRestApiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutRestApiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutRestApiRequest, PutRestApiResponse>().withOperationName("PutRestApi")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutRestApiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putRestApiRequest));
            CompletableFuture<PutRestApiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or updates a tag on a given resource.
     * </p>
     *
     * @param tagResourceRequest
     *        Adds or updates a tag on a given resource.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.TagResource
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Simulate the execution of an Authorizer in your RestApi with headers, parameters, and an incoming request body.
     * </p>
     *
     * @param testInvokeAuthorizerRequest
     *        Make a request to simulate the invocation of an Authorizer.
     * @return A Java Future containing the result of the TestInvokeAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.TestInvokeAuthorizer
     */
    @Override
    public CompletableFuture<TestInvokeAuthorizerResponse> testInvokeAuthorizer(
            TestInvokeAuthorizerRequest testInvokeAuthorizerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testInvokeAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testInvokeAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestInvokeAuthorizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestInvokeAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TestInvokeAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TestInvokeAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestInvokeAuthorizerRequest, TestInvokeAuthorizerResponse>()
                            .withOperationName("TestInvokeAuthorizer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TestInvokeAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(testInvokeAuthorizerRequest));
            CompletableFuture<TestInvokeAuthorizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Simulate the invocation of a Method in your RestApi with headers, parameters, and an incoming request body.
     * </p>
     *
     * @param testInvokeMethodRequest
     *        Make a request to simulate the invocation of a Method.
     * @return A Java Future containing the result of the TestInvokeMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.TestInvokeMethod
     */
    @Override
    public CompletableFuture<TestInvokeMethodResponse> testInvokeMethod(TestInvokeMethodRequest testInvokeMethodRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testInvokeMethodRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testInvokeMethodRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestInvokeMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestInvokeMethodResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TestInvokeMethodResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TestInvokeMethodResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestInvokeMethodRequest, TestInvokeMethodResponse>()
                            .withOperationName("TestInvokeMethod").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TestInvokeMethodRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(testInvokeMethodRequest));
            CompletableFuture<TestInvokeMethodResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a tag from a given resource.
     * </p>
     *
     * @param untagResourceRequest
     *        Removes a tag from a given resource.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UntagResource
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about the current Account resource.
     * </p>
     *
     * @param updateAccountRequest
     *        Requests API Gateway to change information about the current Account resource.
     * @return A Java Future containing the result of the UpdateAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateAccount
     */
    @Override
    public CompletableFuture<UpdateAccountResponse> updateAccount(UpdateAccountRequest updateAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAccountResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAccountRequest, UpdateAccountResponse>()
                            .withOperationName("UpdateAccount").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAccountRequest));
            CompletableFuture<UpdateAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about an ApiKey resource.
     * </p>
     *
     * @param updateApiKeyRequest
     *        A request to change information about an ApiKey resource.
     * @return A Java Future containing the result of the UpdateApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateApiKey
     */
    @Override
    public CompletableFuture<UpdateApiKeyResponse> updateApiKey(UpdateApiKeyRequest updateApiKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApiKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApiKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateApiKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateApiKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApiKeyRequest, UpdateApiKeyResponse>()
                            .withOperationName("UpdateApiKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateApiKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateApiKeyRequest));
            CompletableFuture<UpdateApiKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing Authorizer resource.
     * </p>
     *
     * @param updateAuthorizerRequest
     *        Request to update an existing Authorizer resource.
     * @return A Java Future containing the result of the UpdateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateAuthorizer
     */
    @Override
    public CompletableFuture<UpdateAuthorizerResponse> updateAuthorizer(UpdateAuthorizerRequest updateAuthorizerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAuthorizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAuthorizerRequest, UpdateAuthorizerResponse>()
                            .withOperationName("UpdateAuthorizer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAuthorizerRequest));
            CompletableFuture<UpdateAuthorizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about the BasePathMapping resource.
     * </p>
     *
     * @param updateBasePathMappingRequest
     *        A request to change information about the BasePathMapping resource.
     * @return A Java Future containing the result of the UpdateBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateBasePathMapping
     */
    @Override
    public CompletableFuture<UpdateBasePathMappingResponse> updateBasePathMapping(
            UpdateBasePathMappingRequest updateBasePathMappingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBasePathMappingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBasePathMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBasePathMapping");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBasePathMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBasePathMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBasePathMappingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBasePathMappingRequest, UpdateBasePathMappingResponse>()
                            .withOperationName("UpdateBasePathMapping").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateBasePathMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateBasePathMappingRequest));
            CompletableFuture<UpdateBasePathMappingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about an ClientCertificate resource.
     * </p>
     *
     * @param updateClientCertificateRequest
     *        A request to change information about an ClientCertificate resource.
     * @return A Java Future containing the result of the UpdateClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateClientCertificate
     */
    @Override
    public CompletableFuture<UpdateClientCertificateResponse> updateClientCertificate(
            UpdateClientCertificateRequest updateClientCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateClientCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateClientCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateClientCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateClientCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateClientCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateClientCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateClientCertificateRequest, UpdateClientCertificateResponse>()
                            .withOperationName("UpdateClientCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateClientCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateClientCertificateRequest));
            CompletableFuture<UpdateClientCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about a Deployment resource.
     * </p>
     *
     * @param updateDeploymentRequest
     *        Requests API Gateway to change information about a Deployment resource.
     * @return A Java Future containing the result of the UpdateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDeployment
     */
    @Override
    public CompletableFuture<UpdateDeploymentResponse> updateDeployment(UpdateDeploymentRequest updateDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDeploymentRequest, UpdateDeploymentResponse>()
                            .withOperationName("UpdateDeployment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDeploymentRequest));
            CompletableFuture<UpdateDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a documentation part.
     * </p>
     *
     * @param updateDocumentationPartRequest
     *        Updates an existing documentation part of a given API.
     * @return A Java Future containing the result of the UpdateDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDocumentationPart
     */
    @Override
    public CompletableFuture<UpdateDocumentationPartResponse> updateDocumentationPart(
            UpdateDocumentationPartRequest updateDocumentationPartRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDocumentationPartRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDocumentationPartRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDocumentationPart");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDocumentationPartResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDocumentationPartResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDocumentationPartResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDocumentationPartRequest, UpdateDocumentationPartResponse>()
                            .withOperationName("UpdateDocumentationPart").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDocumentationPartRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDocumentationPartRequest));
            CompletableFuture<UpdateDocumentationPartResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a documentation version.
     * </p>
     *
     * @param updateDocumentationVersionRequest
     *        Updates an existing documentation version of an API.
     * @return A Java Future containing the result of the UpdateDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDocumentationVersion
     */
    @Override
    public CompletableFuture<UpdateDocumentationVersionResponse> updateDocumentationVersion(
            UpdateDocumentationVersionRequest updateDocumentationVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDocumentationVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDocumentationVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDocumentationVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDocumentationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDocumentationVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDocumentationVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDocumentationVersionRequest, UpdateDocumentationVersionResponse>()
                            .withOperationName("UpdateDocumentationVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDocumentationVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDocumentationVersionRequest));
            CompletableFuture<UpdateDocumentationVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about the DomainName resource.
     * </p>
     *
     * @param updateDomainNameRequest
     *        A request to change information about the DomainName resource.
     * @return A Java Future containing the result of the UpdateDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDomainName
     */
    @Override
    public CompletableFuture<UpdateDomainNameResponse> updateDomainName(UpdateDomainNameRequest updateDomainNameRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDomainNameRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDomainName");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDomainNameResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDomainNameResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDomainNameRequest, UpdateDomainNameResponse>()
                            .withOperationName("UpdateDomainName").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDomainNameRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDomainNameRequest));
            CompletableFuture<UpdateDomainNameResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a GatewayResponse of a specified response type on the given RestApi.
     * </p>
     *
     * @param updateGatewayResponseRequest
     *        Updates a GatewayResponse of a specified response type on the given RestApi.
     * @return A Java Future containing the result of the UpdateGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateGatewayResponse
     */
    @Override
    public CompletableFuture<UpdateGatewayResponseResponse> updateGatewayResponse(
            UpdateGatewayResponseRequest updateGatewayResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGatewayResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGatewayResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGatewayResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGatewayResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateGatewayResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGatewayResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGatewayResponseRequest, UpdateGatewayResponseResponse>()
                            .withOperationName("UpdateGatewayResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateGatewayResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateGatewayResponseRequest));
            CompletableFuture<UpdateGatewayResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents an update integration.
     * </p>
     *
     * @param updateIntegrationRequest
     *        Represents an update integration request.
     * @return A Java Future containing the result of the UpdateIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateIntegration
     */
    @Override
    public CompletableFuture<UpdateIntegrationResponse> updateIntegration(UpdateIntegrationRequest updateIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIntegration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateIntegrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIntegrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIntegrationRequest, UpdateIntegrationResponse>()
                            .withOperationName("UpdateIntegration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateIntegrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateIntegrationRequest));
            CompletableFuture<UpdateIntegrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Represents an update integration response.
     * </p>
     *
     * @param updateIntegrationResponseRequest
     *        Represents an update integration response request.
     * @return A Java Future containing the result of the UpdateIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateIntegrationResponse
     */
    @Override
    public CompletableFuture<UpdateIntegrationResponseResponse> updateIntegrationResponse(
            UpdateIntegrationResponseRequest updateIntegrationResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIntegrationResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIntegrationResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIntegrationResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIntegrationResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateIntegrationResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIntegrationResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIntegrationResponseRequest, UpdateIntegrationResponseResponse>()
                            .withOperationName("UpdateIntegrationResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateIntegrationResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateIntegrationResponseRequest));
            CompletableFuture<UpdateIntegrationResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing Method resource.
     * </p>
     *
     * @param updateMethodRequest
     *        Request to update an existing Method resource.
     * @return A Java Future containing the result of the UpdateMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateMethod
     */
    @Override
    public CompletableFuture<UpdateMethodResponse> updateMethod(UpdateMethodRequest updateMethodRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMethodRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMethodRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMethodResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateMethodResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMethodResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMethodRequest, UpdateMethodResponse>()
                            .withOperationName("UpdateMethod").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateMethodRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateMethodRequest));
            CompletableFuture<UpdateMethodResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing MethodResponse resource.
     * </p>
     *
     * @param updateMethodResponseRequest
     *        A request to update an existing MethodResponse resource.
     * @return A Java Future containing the result of the UpdateMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateMethodResponse
     */
    @Override
    public CompletableFuture<UpdateMethodResponseResponse> updateMethodResponse(
            UpdateMethodResponseRequest updateMethodResponseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMethodResponseRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMethodResponseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMethodResponse");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMethodResponseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMethodResponseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMethodResponseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMethodResponseRequest, UpdateMethodResponseResponse>()
                            .withOperationName("UpdateMethodResponse").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateMethodResponseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateMethodResponseRequest));
            CompletableFuture<UpdateMethodResponseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about a model.
     * </p>
     *
     * @param updateModelRequest
     *        Request to update an existing model in an existing RestApi resource.
     * @return A Java Future containing the result of the UpdateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateModel
     */
    @Override
    public CompletableFuture<UpdateModelResponse> updateModel(UpdateModelRequest updateModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateModelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateModelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateModelRequest, UpdateModelResponse>()
                            .withOperationName("UpdateModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateModelRequest));
            CompletableFuture<UpdateModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a RequestValidator of a given RestApi.
     * </p>
     *
     * @param updateRequestValidatorRequest
     *        Updates a RequestValidator of a given RestApi.
     * @return A Java Future containing the result of the UpdateRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateRequestValidator
     */
    @Override
    public CompletableFuture<UpdateRequestValidatorResponse> updateRequestValidator(
            UpdateRequestValidatorRequest updateRequestValidatorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRequestValidatorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRequestValidatorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRequestValidator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRequestValidatorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRequestValidatorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRequestValidatorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRequestValidatorRequest, UpdateRequestValidatorResponse>()
                            .withOperationName("UpdateRequestValidator").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRequestValidatorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRequestValidatorRequest));
            CompletableFuture<UpdateRequestValidatorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about a Resource resource.
     * </p>
     *
     * @param updateResourceRequest
     *        Request to change information about a Resource resource.
     * @return A Java Future containing the result of the UpdateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateResource
     */
    @Override
    public CompletableFuture<UpdateResourceResponse> updateResource(UpdateResourceRequest updateResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResourceRequest, UpdateResourceResponse>()
                            .withOperationName("UpdateResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateResourceRequest));
            CompletableFuture<UpdateResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about the specified API.
     * </p>
     *
     * @param updateRestApiRequest
     *        Request to update an existing RestApi resource in your collection.
     * @return A Java Future containing the result of the UpdateRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateRestApi
     */
    @Override
    public CompletableFuture<UpdateRestApiResponse> updateRestApi(UpdateRestApiRequest updateRestApiRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRestApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRestApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRestApi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRestApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateRestApiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRestApiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRestApiRequest, UpdateRestApiResponse>()
                            .withOperationName("UpdateRestApi").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRestApiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRestApiRequest));
            CompletableFuture<UpdateRestApiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes information about a Stage resource.
     * </p>
     *
     * @param updateStageRequest
     *        Requests API Gateway to change information about a Stage resource.
     * @return A Java Future containing the result of the UpdateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateStage
     */
    @Override
    public CompletableFuture<UpdateStageResponse> updateStage(UpdateStageRequest updateStageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateStageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateStageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateStageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateStageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateStageRequest, UpdateStageResponse>()
                            .withOperationName("UpdateStage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateStageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateStageRequest));
            CompletableFuture<UpdateStageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.
     * </p>
     *
     * @param updateUsageRequest
     *        The PATCH request to grant a temporary extension to the remaining quota of a usage plan associated with a
     *        specified API key.
     * @return A Java Future containing the result of the UpdateUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateUsage
     */
    @Override
    public CompletableFuture<UpdateUsageResponse> updateUsage(UpdateUsageRequest updateUsageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUsageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUsageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateUsageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUsageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUsageRequest, UpdateUsageResponse>()
                            .withOperationName("UpdateUsage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateUsageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateUsageRequest));
            CompletableFuture<UpdateUsageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a usage plan of a given plan Id.
     * </p>
     *
     * @param updateUsagePlanRequest
     *        The PATCH request to update a usage plan of a given plan Id.
     * @return A Java Future containing the result of the UpdateUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateUsagePlan
     */
    @Override
    public CompletableFuture<UpdateUsagePlanResponse> updateUsagePlan(UpdateUsagePlanRequest updateUsagePlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUsagePlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUsagePlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUsagePlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUsagePlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateUsagePlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUsagePlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUsagePlanRequest, UpdateUsagePlanResponse>()
                            .withOperationName("UpdateUsagePlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateUsagePlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateUsagePlanRequest));
            CompletableFuture<UpdateUsagePlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing VpcLink of a specified identifier.
     * </p>
     *
     * @param updateVpcLinkRequest
     *        Updates an existing VpcLink of a specified identifier.
     * @return A Java Future containing the result of the UpdateVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateVpcLink
     */
    @Override
    public CompletableFuture<UpdateVpcLinkResponse> updateVpcLink(UpdateVpcLinkRequest updateVpcLinkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateVpcLinkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVpcLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "API Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVpcLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVpcLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateVpcLinkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateVpcLinkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVpcLinkRequest, UpdateVpcLinkResponse>()
                            .withOperationName("UpdateVpcLink").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateVpcLinkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateVpcLinkRequest));
            CompletableFuture<UpdateVpcLinkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final ApiGatewayServiceClientConfiguration serviceClientConfiguration() {
        return new ApiGatewayServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ApiGatewayException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(503).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ApiGatewayServiceClientConfigurationBuilder serviceConfigBuilder = new ApiGatewayServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
