/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.EndpointType;
import software.amazon.awssdk.services.apigateway.model.ListOfEndpointTypeCopier;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointConfiguration> {
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("types").getter(EndpointConfiguration.getter(EndpointConfiguration::typesAsStrings)).setter(EndpointConfiguration.setter(Builder::typesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_ENDPOINT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcEndpointIds").getter(EndpointConfiguration.getter(EndpointConfiguration::vpcEndpointIds)).setter(EndpointConfiguration.setter(Builder::vpcEndpointIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPES_FIELD, VPC_ENDPOINT_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> types;
    private final List<String> vpcEndpointIds;

    private EndpointConfiguration(BuilderImpl builder) {
        this.types = builder.types;
        this.vpcEndpointIds = builder.vpcEndpointIds;
    }

    public final List<EndpointType> types() {
        return ListOfEndpointTypeCopier.copyStringToEnum(this.types);
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<String> typesAsStrings() {
        return this.types;
    }

    public final boolean hasVpcEndpointIds() {
        return this.vpcEndpointIds != null && !(this.vpcEndpointIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcEndpointIds() {
        return this.vpcEndpointIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.typesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcEndpointIds() ? this.vpcEndpointIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointConfiguration)) {
            return false;
        }
        EndpointConfiguration other = (EndpointConfiguration)obj;
        return this.hasTypes() == other.hasTypes() && Objects.equals(this.typesAsStrings(), other.typesAsStrings()) && this.hasVpcEndpointIds() == other.hasVpcEndpointIds() && Objects.equals(this.vpcEndpointIds(), other.vpcEndpointIds());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointConfiguration").add("Types", this.hasTypes() ? this.typesAsStrings() : null).add("VpcEndpointIds", this.hasVpcEndpointIds() ? this.vpcEndpointIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "types": {
                return Optional.ofNullable(clazz.cast(this.typesAsStrings()));
            }
            case "vpcEndpointIds": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointConfiguration, T> g) {
        return obj -> g.apply((EndpointConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> types = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcEndpointIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointConfiguration model) {
            this.typesWithStrings(model.types);
            this.vpcEndpointIds(model.vpcEndpointIds);
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = ListOfEndpointTypeCopier.copy(types);
        }

        @Override
        public final Builder typesWithStrings(Collection<String> types) {
            this.types = ListOfEndpointTypeCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typesWithStrings(String ... types) {
            this.typesWithStrings(Arrays.asList(types));
            return this;
        }

        @Override
        public final Builder types(Collection<EndpointType> types) {
            this.types = ListOfEndpointTypeCopier.copyEnumToString(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(EndpointType ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public final Collection<String> getVpcEndpointIds() {
            if (this.vpcEndpointIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcEndpointIds;
        }

        public final void setVpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ListOfStringCopier.copy(vpcEndpointIds);
        }

        @Override
        public final Builder vpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ListOfStringCopier.copy(vpcEndpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointIds(String ... vpcEndpointIds) {
            this.vpcEndpointIds(Arrays.asList(vpcEndpointIds));
            return this;
        }

        public EndpointConfiguration build() {
            return new EndpointConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointConfiguration> {
        public Builder typesWithStrings(Collection<String> var1);

        public Builder typesWithStrings(String ... var1);

        public Builder types(Collection<EndpointType> var1);

        public Builder types(EndpointType ... var1);

        public Builder vpcEndpointIds(Collection<String> var1);

        public Builder vpcEndpointIds(String ... var1);
    }
}

