/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.apigateway.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.CreateModelRequest;
import software.amazon.awssdk.services.apigateway.model.CreateModelResponse;
import software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.CreateResourceRequest;
import software.amazon.awssdk.services.apigateway.model.CreateResourceResponse;
import software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.CreateRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.CreateStageRequest;
import software.amazon.awssdk.services.apigateway.model.CreateStageResponse;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.CreateUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.CreateVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.CreateVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteModelRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteModelResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteResourceRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteResourceResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteStageRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteStageResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheRequest;
import software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheResponse;
import software.amazon.awssdk.services.apigateway.model.FlushStageCacheRequest;
import software.amazon.awssdk.services.apigateway.model.FlushStageCacheResponse;
import software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.GetAccountRequest;
import software.amazon.awssdk.services.apigateway.model.GetAccountResponse;
import software.amazon.awssdk.services.apigateway.model.GetApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.GetApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizersResponse;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest;
import software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionsResponse;
import software.amazon.awssdk.services.apigateway.model.GetDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse;
import software.amazon.awssdk.services.apigateway.model.GetExportRequest;
import software.amazon.awssdk.services.apigateway.model.GetExportResponse;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesRequest;
import software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesResponse;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetMethodRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponse;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelTemplateRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelTemplateResponse;
import software.amazon.awssdk.services.apigateway.model.GetModelsRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelsResponse;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorsRequest;
import software.amazon.awssdk.services.apigateway.model.GetRequestValidatorsResponse;
import software.amazon.awssdk.services.apigateway.model.GetResourceRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourceResponse;
import software.amazon.awssdk.services.apigateway.model.GetResourcesRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourcesResponse;
import software.amazon.awssdk.services.apigateway.model.GetRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.GetRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.GetRestApisRequest;
import software.amazon.awssdk.services.apigateway.model.GetRestApisResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypeRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypeResponse;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypesRequest;
import software.amazon.awssdk.services.apigateway.model.GetSdkTypesResponse;
import software.amazon.awssdk.services.apigateway.model.GetStageRequest;
import software.amazon.awssdk.services.apigateway.model.GetStageResponse;
import software.amazon.awssdk.services.apigateway.model.GetStagesRequest;
import software.amazon.awssdk.services.apigateway.model.GetStagesResponse;
import software.amazon.awssdk.services.apigateway.model.GetTagsRequest;
import software.amazon.awssdk.services.apigateway.model.GetTagsResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse;
import software.amazon.awssdk.services.apigateway.model.GetUsageRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsageResponse;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest;
import software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse;
import software.amazon.awssdk.services.apigateway.model.ImportApiKeysRequest;
import software.amazon.awssdk.services.apigateway.model.ImportApiKeysResponse;
import software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsRequest;
import software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsResponse;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.PutGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutMethodRequest;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponse;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.PutRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.PutRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.TagResourceRequest;
import software.amazon.awssdk.services.apigateway.model.TagResourceResponse;
import software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest;
import software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse;
import software.amazon.awssdk.services.apigateway.model.UntagResourceRequest;
import software.amazon.awssdk.services.apigateway.model.UntagResourceResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateAccountRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateAccountResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateApiKeyRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateApiKeyResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateDomainNameRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateDomainNameResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponseResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateModelRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateModelResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateResourceRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateResourceResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateStageRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateStageResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateUsageRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse;
import software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkResponse;
import software.amazon.awssdk.services.apigateway.paginators.GetApiKeysPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetModelsPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetResourcesPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetRestApisPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansPublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetUsagePublisher;
import software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksPublisher;

/**
 * Service client for accessing Amazon API Gateway asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <fullname>Amazon API Gateway</fullname>
 * <p>
 * Amazon API Gateway helps developers deliver robust, secure, and scalable mobile and web application back ends. API
 * Gateway allows developers to securely connect mobile and web applications to APIs that run on Lambda, Amazon EC2, or
 * other publicly addressable web services that are hosted outside of AWS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ApiGatewayAsyncClient extends AwsClient {
    String SERVICE_NAME = "apigateway";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "apigateway";

    /**
     * <p>
     * Create an ApiKey resource.
     * </p>
     *
     * @param createApiKeyRequest
     *        Request to create an ApiKey resource.
     * @return A Java Future containing the result of the CreateApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateApiKey
     */
    default CompletableFuture<CreateApiKeyResponse> createApiKey(CreateApiKeyRequest createApiKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an ApiKey resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link CreateApiKeyRequest#builder()}
     * </p>
     *
     * @param createApiKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateApiKeyRequest.Builder} to create a request.
     *        Request to create an ApiKey resource.
     * @return A Java Future containing the result of the CreateApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateApiKey
     */
    default CompletableFuture<CreateApiKeyResponse> createApiKey(Consumer<CreateApiKeyRequest.Builder> createApiKeyRequest) {
        return createApiKey(CreateApiKeyRequest.builder().applyMutation(createApiKeyRequest).build());
    }

    /**
     * <p>
     * Create an ApiKey resource.
     * </p>
     *
     * @return A Java Future containing the result of the CreateApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateApiKey
     */
    default CompletableFuture<CreateApiKeyResponse> createApiKey() {
        return createApiKey(CreateApiKeyRequest.builder().build());
    }

    /**
     * <p>
     * Adds a new Authorizer resource to an existing RestApi resource.
     * </p>
     *
     * @param createAuthorizerRequest
     *        Request to add a new Authorizer to an existing RestApi resource.
     * @return A Java Future containing the result of the CreateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateAuthorizer
     */
    default CompletableFuture<CreateAuthorizerResponse> createAuthorizer(CreateAuthorizerRequest createAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new Authorizer resource to an existing RestApi resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAuthorizerRequest#builder()}
     * </p>
     *
     * @param createAuthorizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest.Builder} to create a
     *        request. Request to add a new Authorizer to an existing RestApi resource.
     * @return A Java Future containing the result of the CreateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateAuthorizer
     */
    default CompletableFuture<CreateAuthorizerResponse> createAuthorizer(
            Consumer<CreateAuthorizerRequest.Builder> createAuthorizerRequest) {
        return createAuthorizer(CreateAuthorizerRequest.builder().applyMutation(createAuthorizerRequest).build());
    }

    /**
     * <p>
     * Creates a new BasePathMapping resource.
     * </p>
     *
     * @param createBasePathMappingRequest
     *        Requests API Gateway to create a new BasePathMapping resource.
     * @return A Java Future containing the result of the CreateBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateBasePathMapping
     */
    default CompletableFuture<CreateBasePathMappingResponse> createBasePathMapping(
            CreateBasePathMappingRequest createBasePathMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new BasePathMapping resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBasePathMappingRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBasePathMappingRequest#builder()}
     * </p>
     *
     * @param createBasePathMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingRequest.Builder} to create a
     *        request. Requests API Gateway to create a new BasePathMapping resource.
     * @return A Java Future containing the result of the CreateBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateBasePathMapping
     */
    default CompletableFuture<CreateBasePathMappingResponse> createBasePathMapping(
            Consumer<CreateBasePathMappingRequest.Builder> createBasePathMappingRequest) {
        return createBasePathMapping(CreateBasePathMappingRequest.builder().applyMutation(createBasePathMappingRequest).build());
    }

    /**
     * <p>
     * Creates a Deployment resource, which makes a specified RestApi callable over the internet.
     * </p>
     *
     * @param createDeploymentRequest
     *        Requests API Gateway to create a Deployment resource.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDeployment
     */
    default CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Deployment resource, which makes a specified RestApi callable over the internet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDeploymentRequest#builder()}
     * </p>
     *
     * @param createDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest.Builder} to create a
     *        request. Requests API Gateway to create a Deployment resource.
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDeployment
     */
    default CompletableFuture<CreateDeploymentResponse> createDeployment(
            Consumer<CreateDeploymentRequest.Builder> createDeploymentRequest) {
        return createDeployment(CreateDeploymentRequest.builder().applyMutation(createDeploymentRequest).build());
    }

    /**
     * <p>
     * Creates a documentation part.
     * </p>
     *
     * @param createDocumentationPartRequest
     *        Creates a new documentation part of a given API.
     * @return A Java Future containing the result of the CreateDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDocumentationPart
     */
    default CompletableFuture<CreateDocumentationPartResponse> createDocumentationPart(
            CreateDocumentationPartRequest createDocumentationPartRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a documentation part.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDocumentationPartRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDocumentationPartRequest#builder()}
     * </p>
     *
     * @param createDocumentationPartRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateDocumentationPartRequest.Builder} to create
     *        a request. Creates a new documentation part of a given API.
     * @return A Java Future containing the result of the CreateDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDocumentationPart
     */
    default CompletableFuture<CreateDocumentationPartResponse> createDocumentationPart(
            Consumer<CreateDocumentationPartRequest.Builder> createDocumentationPartRequest) {
        return createDocumentationPart(CreateDocumentationPartRequest.builder().applyMutation(createDocumentationPartRequest)
                .build());
    }

    /**
     * <p>
     * Creates a documentation version
     * </p>
     *
     * @param createDocumentationVersionRequest
     *        Creates a new documentation version of a given API.
     * @return A Java Future containing the result of the CreateDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDocumentationVersion
     */
    default CompletableFuture<CreateDocumentationVersionResponse> createDocumentationVersion(
            CreateDocumentationVersionRequest createDocumentationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a documentation version
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDocumentationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDocumentationVersionRequest#builder()}
     * </p>
     *
     * @param createDocumentationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionRequest.Builder} to
     *        create a request. Creates a new documentation version of a given API.
     * @return A Java Future containing the result of the CreateDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDocumentationVersion
     */
    default CompletableFuture<CreateDocumentationVersionResponse> createDocumentationVersion(
            Consumer<CreateDocumentationVersionRequest.Builder> createDocumentationVersionRequest) {
        return createDocumentationVersion(CreateDocumentationVersionRequest.builder()
                .applyMutation(createDocumentationVersionRequest).build());
    }

    /**
     * <p>
     * Creates a new domain name.
     * </p>
     *
     * @param createDomainNameRequest
     *        A request to create a new domain name.
     * @return A Java Future containing the result of the CreateDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDomainName
     */
    default CompletableFuture<CreateDomainNameResponse> createDomainName(CreateDomainNameRequest createDomainNameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDomainNameRequest#builder()}
     * </p>
     *
     * @param createDomainNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest.Builder} to create a
     *        request. A request to create a new domain name.
     * @return A Java Future containing the result of the CreateDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateDomainName
     */
    default CompletableFuture<CreateDomainNameResponse> createDomainName(
            Consumer<CreateDomainNameRequest.Builder> createDomainNameRequest) {
        return createDomainName(CreateDomainNameRequest.builder().applyMutation(createDomainNameRequest).build());
    }

    /**
     * <p>
     * Adds a new Model resource to an existing RestApi resource.
     * </p>
     *
     * @param createModelRequest
     *        Request to add a new Model to an existing RestApi resource.
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateModel
     */
    default CompletableFuture<CreateModelResponse> createModel(CreateModelRequest createModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new Model resource to an existing RestApi resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateModelRequest#builder()}
     * </p>
     *
     * @param createModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateModelRequest.Builder} to create a request.
     *        Request to add a new Model to an existing RestApi resource.
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateModel
     */
    default CompletableFuture<CreateModelResponse> createModel(Consumer<CreateModelRequest.Builder> createModelRequest) {
        return createModel(CreateModelRequest.builder().applyMutation(createModelRequest).build());
    }

    /**
     * <p>
     * Creates a RequestValidator of a given RestApi.
     * </p>
     *
     * @param createRequestValidatorRequest
     *        Creates a RequestValidator of a given RestApi.
     * @return A Java Future containing the result of the CreateRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateRequestValidator
     */
    default CompletableFuture<CreateRequestValidatorResponse> createRequestValidator(
            CreateRequestValidatorRequest createRequestValidatorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a RequestValidator of a given RestApi.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRequestValidatorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRequestValidatorRequest#builder()}
     * </p>
     *
     * @param createRequestValidatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateRequestValidatorRequest.Builder} to create a
     *        request. Creates a RequestValidator of a given RestApi.
     * @return A Java Future containing the result of the CreateRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateRequestValidator
     */
    default CompletableFuture<CreateRequestValidatorResponse> createRequestValidator(
            Consumer<CreateRequestValidatorRequest.Builder> createRequestValidatorRequest) {
        return createRequestValidator(CreateRequestValidatorRequest.builder().applyMutation(createRequestValidatorRequest)
                .build());
    }

    /**
     * <p>
     * Creates a Resource resource.
     * </p>
     *
     * @param createResourceRequest
     *        Requests API Gateway to create a Resource resource.
     * @return A Java Future containing the result of the CreateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateResource
     */
    default CompletableFuture<CreateResourceResponse> createResource(CreateResourceRequest createResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Resource resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateResourceRequest#builder()}
     * </p>
     *
     * @param createResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateResourceRequest.Builder} to create a
     *        request. Requests API Gateway to create a Resource resource.
     * @return A Java Future containing the result of the CreateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateResource
     */
    default CompletableFuture<CreateResourceResponse> createResource(Consumer<CreateResourceRequest.Builder> createResourceRequest) {
        return createResource(CreateResourceRequest.builder().applyMutation(createResourceRequest).build());
    }

    /**
     * <p>
     * Creates a new RestApi resource.
     * </p>
     *
     * @param createRestApiRequest
     *        The POST Request to add a new RestApi resource to your collection.
     * @return A Java Future containing the result of the CreateRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateRestApi
     */
    default CompletableFuture<CreateRestApiResponse> createRestApi(CreateRestApiRequest createRestApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new RestApi resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRestApiRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRestApiRequest#builder()}
     * </p>
     *
     * @param createRestApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest.Builder} to create a request.
     *        The POST Request to add a new RestApi resource to your collection.
     * @return A Java Future containing the result of the CreateRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateRestApi
     */
    default CompletableFuture<CreateRestApiResponse> createRestApi(Consumer<CreateRestApiRequest.Builder> createRestApiRequest) {
        return createRestApi(CreateRestApiRequest.builder().applyMutation(createRestApiRequest).build());
    }

    /**
     * <p>
     * Creates a new Stage resource that references a pre-existing Deployment for the API.
     * </p>
     *
     * @param createStageRequest
     *        Requests API Gateway to create a Stage resource.
     * @return A Java Future containing the result of the CreateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateStage
     */
    default CompletableFuture<CreateStageResponse> createStage(CreateStageRequest createStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Stage resource that references a pre-existing Deployment for the API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStageRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStageRequest#builder()}
     * </p>
     *
     * @param createStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateStageRequest.Builder} to create a request.
     *        Requests API Gateway to create a Stage resource.
     * @return A Java Future containing the result of the CreateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateStage
     */
    default CompletableFuture<CreateStageResponse> createStage(Consumer<CreateStageRequest.Builder> createStageRequest) {
        return createStage(CreateStageRequest.builder().applyMutation(createStageRequest).build());
    }

    /**
     * <p>
     * Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the
     * payload.
     * </p>
     *
     * @param createUsagePlanRequest
     *        The POST request to create a usage plan with the name, description, throttle limits and quota limits, as
     *        well as the associated API stages, specified in the payload.
     * @return A Java Future containing the result of the CreateUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateUsagePlan
     */
    default CompletableFuture<CreateUsagePlanResponse> createUsagePlan(CreateUsagePlanRequest createUsagePlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the
     * payload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUsagePlanRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUsagePlanRequest#builder()}
     * </p>
     *
     * @param createUsagePlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateUsagePlanRequest.Builder} to create a
     *        request. The POST request to create a usage plan with the name, description, throttle limits and quota
     *        limits, as well as the associated API stages, specified in the payload.
     * @return A Java Future containing the result of the CreateUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateUsagePlan
     */
    default CompletableFuture<CreateUsagePlanResponse> createUsagePlan(
            Consumer<CreateUsagePlanRequest.Builder> createUsagePlanRequest) {
        return createUsagePlan(CreateUsagePlanRequest.builder().applyMutation(createUsagePlanRequest).build());
    }

    /**
     * <p>
     * Creates a usage plan key for adding an existing API key to a usage plan.
     * </p>
     *
     * @param createUsagePlanKeyRequest
     *        The POST request to create a usage plan key for adding an existing API key to a usage plan.
     * @return A Java Future containing the result of the CreateUsagePlanKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateUsagePlanKey
     */
    default CompletableFuture<CreateUsagePlanKeyResponse> createUsagePlanKey(CreateUsagePlanKeyRequest createUsagePlanKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a usage plan key for adding an existing API key to a usage plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUsagePlanKeyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUsagePlanKeyRequest#builder()}
     * </p>
     *
     * @param createUsagePlanKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyRequest.Builder} to create a
     *        request. The POST request to create a usage plan key for adding an existing API key to a usage plan.
     * @return A Java Future containing the result of the CreateUsagePlanKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateUsagePlanKey
     */
    default CompletableFuture<CreateUsagePlanKeyResponse> createUsagePlanKey(
            Consumer<CreateUsagePlanKeyRequest.Builder> createUsagePlanKeyRequest) {
        return createUsagePlanKey(CreateUsagePlanKeyRequest.builder().applyMutation(createUsagePlanKeyRequest).build());
    }

    /**
     * <p>
     * Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically
     * takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC
     * Endpoint services.
     * </p>
     *
     * @param createVpcLinkRequest
     *        Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that
     *        typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create
     *        and update VPC Endpoint services.
     * @return A Java Future containing the result of the CreateVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateVpcLink
     */
    default CompletableFuture<CreateVpcLinkResponse> createVpcLink(CreateVpcLinkRequest createVpcLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically
     * takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC
     * Endpoint services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVpcLinkRequest#builder()}
     * </p>
     *
     * @param createVpcLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.CreateVpcLinkRequest.Builder} to create a request.
     *        Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that
     *        typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create
     *        and update VPC Endpoint services.
     * @return A Java Future containing the result of the CreateVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.CreateVpcLink
     */
    default CompletableFuture<CreateVpcLinkResponse> createVpcLink(Consumer<CreateVpcLinkRequest.Builder> createVpcLinkRequest) {
        return createVpcLink(CreateVpcLinkRequest.builder().applyMutation(createVpcLinkRequest).build());
    }

    /**
     * <p>
     * Deletes the ApiKey resource.
     * </p>
     *
     * @param deleteApiKeyRequest
     *        A request to delete the ApiKey resource.
     * @return A Java Future containing the result of the DeleteApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteApiKey
     */
    default CompletableFuture<DeleteApiKeyResponse> deleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the ApiKey resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteApiKeyRequest#builder()}
     * </p>
     *
     * @param deleteApiKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteApiKeyRequest.Builder} to create a request.
     *        A request to delete the ApiKey resource.
     * @return A Java Future containing the result of the DeleteApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteApiKey
     */
    default CompletableFuture<DeleteApiKeyResponse> deleteApiKey(Consumer<DeleteApiKeyRequest.Builder> deleteApiKeyRequest) {
        return deleteApiKey(DeleteApiKeyRequest.builder().applyMutation(deleteApiKeyRequest).build());
    }

    /**
     * <p>
     * Deletes an existing Authorizer resource.
     * </p>
     *
     * @param deleteAuthorizerRequest
     *        Request to delete an existing Authorizer resource.
     * @return A Java Future containing the result of the DeleteAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteAuthorizer
     */
    default CompletableFuture<DeleteAuthorizerResponse> deleteAuthorizer(DeleteAuthorizerRequest deleteAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing Authorizer resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAuthorizerRequest#builder()}
     * </p>
     *
     * @param deleteAuthorizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerRequest.Builder} to create a
     *        request. Request to delete an existing Authorizer resource.
     * @return A Java Future containing the result of the DeleteAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteAuthorizer
     */
    default CompletableFuture<DeleteAuthorizerResponse> deleteAuthorizer(
            Consumer<DeleteAuthorizerRequest.Builder> deleteAuthorizerRequest) {
        return deleteAuthorizer(DeleteAuthorizerRequest.builder().applyMutation(deleteAuthorizerRequest).build());
    }

    /**
     * <p>
     * Deletes the BasePathMapping resource.
     * </p>
     *
     * @param deleteBasePathMappingRequest
     *        A request to delete the BasePathMapping resource.
     * @return A Java Future containing the result of the DeleteBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteBasePathMapping
     */
    default CompletableFuture<DeleteBasePathMappingResponse> deleteBasePathMapping(
            DeleteBasePathMappingRequest deleteBasePathMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the BasePathMapping resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBasePathMappingRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBasePathMappingRequest#builder()}
     * </p>
     *
     * @param deleteBasePathMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteBasePathMappingRequest.Builder} to create a
     *        request. A request to delete the BasePathMapping resource.
     * @return A Java Future containing the result of the DeleteBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteBasePathMapping
     */
    default CompletableFuture<DeleteBasePathMappingResponse> deleteBasePathMapping(
            Consumer<DeleteBasePathMappingRequest.Builder> deleteBasePathMappingRequest) {
        return deleteBasePathMapping(DeleteBasePathMappingRequest.builder().applyMutation(deleteBasePathMappingRequest).build());
    }

    /**
     * <p>
     * Deletes the ClientCertificate resource.
     * </p>
     *
     * @param deleteClientCertificateRequest
     *        A request to delete the ClientCertificate resource.
     * @return A Java Future containing the result of the DeleteClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteClientCertificate
     */
    default CompletableFuture<DeleteClientCertificateResponse> deleteClientCertificate(
            DeleteClientCertificateRequest deleteClientCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the ClientCertificate resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClientCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteClientCertificateRequest#builder()}
     * </p>
     *
     * @param deleteClientCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteClientCertificateRequest.Builder} to create
     *        a request. A request to delete the ClientCertificate resource.
     * @return A Java Future containing the result of the DeleteClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteClientCertificate
     */
    default CompletableFuture<DeleteClientCertificateResponse> deleteClientCertificate(
            Consumer<DeleteClientCertificateRequest.Builder> deleteClientCertificateRequest) {
        return deleteClientCertificate(DeleteClientCertificateRequest.builder().applyMutation(deleteClientCertificateRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a Deployment resource. Deleting a deployment will only succeed if there are no Stage resources associated
     * with it.
     * </p>
     *
     * @param deleteDeploymentRequest
     *        Requests API Gateway to delete a Deployment resource.
     * @return A Java Future containing the result of the DeleteDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDeployment
     */
    default CompletableFuture<DeleteDeploymentResponse> deleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Deployment resource. Deleting a deployment will only succeed if there are no Stage resources associated
     * with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDeploymentRequest#builder()}
     * </p>
     *
     * @param deleteDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteDeploymentRequest.Builder} to create a
     *        request. Requests API Gateway to delete a Deployment resource.
     * @return A Java Future containing the result of the DeleteDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDeployment
     */
    default CompletableFuture<DeleteDeploymentResponse> deleteDeployment(
            Consumer<DeleteDeploymentRequest.Builder> deleteDeploymentRequest) {
        return deleteDeployment(DeleteDeploymentRequest.builder().applyMutation(deleteDeploymentRequest).build());
    }

    /**
     * <p>
     * Deletes a documentation part
     * </p>
     *
     * @param deleteDocumentationPartRequest
     *        Deletes an existing documentation part of an API.
     * @return A Java Future containing the result of the DeleteDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDocumentationPart
     */
    default CompletableFuture<DeleteDocumentationPartResponse> deleteDocumentationPart(
            DeleteDocumentationPartRequest deleteDocumentationPartRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a documentation part
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDocumentationPartRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDocumentationPartRequest#builder()}
     * </p>
     *
     * @param deleteDocumentationPartRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteDocumentationPartRequest.Builder} to create
     *        a request. Deletes an existing documentation part of an API.
     * @return A Java Future containing the result of the DeleteDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDocumentationPart
     */
    default CompletableFuture<DeleteDocumentationPartResponse> deleteDocumentationPart(
            Consumer<DeleteDocumentationPartRequest.Builder> deleteDocumentationPartRequest) {
        return deleteDocumentationPart(DeleteDocumentationPartRequest.builder().applyMutation(deleteDocumentationPartRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a documentation version.
     * </p>
     *
     * @param deleteDocumentationVersionRequest
     *        Deletes an existing documentation version of an API.
     * @return A Java Future containing the result of the DeleteDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDocumentationVersion
     */
    default CompletableFuture<DeleteDocumentationVersionResponse> deleteDocumentationVersion(
            DeleteDocumentationVersionRequest deleteDocumentationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a documentation version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDocumentationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDocumentationVersionRequest#builder()}
     * </p>
     *
     * @param deleteDocumentationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionRequest.Builder} to
     *        create a request. Deletes an existing documentation version of an API.
     * @return A Java Future containing the result of the DeleteDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDocumentationVersion
     */
    default CompletableFuture<DeleteDocumentationVersionResponse> deleteDocumentationVersion(
            Consumer<DeleteDocumentationVersionRequest.Builder> deleteDocumentationVersionRequest) {
        return deleteDocumentationVersion(DeleteDocumentationVersionRequest.builder()
                .applyMutation(deleteDocumentationVersionRequest).build());
    }

    /**
     * <p>
     * Deletes the DomainName resource.
     * </p>
     *
     * @param deleteDomainNameRequest
     *        A request to delete the DomainName resource.
     * @return A Java Future containing the result of the DeleteDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDomainName
     */
    default CompletableFuture<DeleteDomainNameResponse> deleteDomainName(DeleteDomainNameRequest deleteDomainNameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the DomainName resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDomainNameRequest#builder()}
     * </p>
     *
     * @param deleteDomainNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteDomainNameRequest.Builder} to create a
     *        request. A request to delete the DomainName resource.
     * @return A Java Future containing the result of the DeleteDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteDomainName
     */
    default CompletableFuture<DeleteDomainNameResponse> deleteDomainName(
            Consumer<DeleteDomainNameRequest.Builder> deleteDomainNameRequest) {
        return deleteDomainName(DeleteDomainNameRequest.builder().applyMutation(deleteDomainNameRequest).build());
    }

    /**
     * <p>
     * Clears any customization of a GatewayResponse of a specified response type on the given RestApi and resets it
     * with the default settings.
     * </p>
     *
     * @param deleteGatewayResponseRequest
     *        Clears any customization of a GatewayResponse of a specified response type on the given RestApi and resets
     *        it with the default settings.
     * @return A Java Future containing the result of the DeleteGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteGatewayResponse
     */
    default CompletableFuture<DeleteGatewayResponseResponse> deleteGatewayResponse(
            DeleteGatewayResponseRequest deleteGatewayResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Clears any customization of a GatewayResponse of a specified response type on the given RestApi and resets it
     * with the default settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayResponseRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGatewayResponseRequest#builder()}
     * </p>
     *
     * @param deleteGatewayResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteGatewayResponseRequest.Builder} to create a
     *        request. Clears any customization of a GatewayResponse of a specified response type on the given RestApi
     *        and resets it with the default settings.
     * @return A Java Future containing the result of the DeleteGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteGatewayResponse
     */
    default CompletableFuture<DeleteGatewayResponseResponse> deleteGatewayResponse(
            Consumer<DeleteGatewayResponseRequest.Builder> deleteGatewayResponseRequest) {
        return deleteGatewayResponse(DeleteGatewayResponseRequest.builder().applyMutation(deleteGatewayResponseRequest).build());
    }

    /**
     * <p>
     * Represents a delete integration.
     * </p>
     *
     * @param deleteIntegrationRequest
     *        Represents a delete integration request.
     * @return A Java Future containing the result of the DeleteIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteIntegration
     */
    default CompletableFuture<DeleteIntegrationResponse> deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a delete integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteIntegrationRequest.Builder} to create a
     *        request. Represents a delete integration request.
     * @return A Java Future containing the result of the DeleteIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteIntegration
     */
    default CompletableFuture<DeleteIntegrationResponse> deleteIntegration(
            Consumer<DeleteIntegrationRequest.Builder> deleteIntegrationRequest) {
        return deleteIntegration(DeleteIntegrationRequest.builder().applyMutation(deleteIntegrationRequest).build());
    }

    /**
     * <p>
     * Represents a delete integration response.
     * </p>
     *
     * @param deleteIntegrationResponseRequest
     *        Represents a delete integration response request.
     * @return A Java Future containing the result of the DeleteIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteIntegrationResponse
     */
    default CompletableFuture<DeleteIntegrationResponseResponse> deleteIntegrationResponse(
            DeleteIntegrationResponseRequest deleteIntegrationResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a delete integration response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationResponseRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteIntegrationResponseRequest.Builder} to
     *        create a request. Represents a delete integration response request.
     * @return A Java Future containing the result of the DeleteIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteIntegrationResponse
     */
    default CompletableFuture<DeleteIntegrationResponseResponse> deleteIntegrationResponse(
            Consumer<DeleteIntegrationResponseRequest.Builder> deleteIntegrationResponseRequest) {
        return deleteIntegrationResponse(DeleteIntegrationResponseRequest.builder()
                .applyMutation(deleteIntegrationResponseRequest).build());
    }

    /**
     * <p>
     * Deletes an existing Method resource.
     * </p>
     *
     * @param deleteMethodRequest
     *        Request to delete an existing Method resource.
     * @return A Java Future containing the result of the DeleteMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteMethod
     */
    default CompletableFuture<DeleteMethodResponse> deleteMethod(DeleteMethodRequest deleteMethodRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing Method resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMethodRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMethodRequest#builder()}
     * </p>
     *
     * @param deleteMethodRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteMethodRequest.Builder} to create a request.
     *        Request to delete an existing Method resource.
     * @return A Java Future containing the result of the DeleteMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteMethod
     */
    default CompletableFuture<DeleteMethodResponse> deleteMethod(Consumer<DeleteMethodRequest.Builder> deleteMethodRequest) {
        return deleteMethod(DeleteMethodRequest.builder().applyMutation(deleteMethodRequest).build());
    }

    /**
     * <p>
     * Deletes an existing MethodResponse resource.
     * </p>
     *
     * @param deleteMethodResponseRequest
     *        A request to delete an existing MethodResponse resource.
     * @return A Java Future containing the result of the DeleteMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteMethodResponse
     */
    default CompletableFuture<DeleteMethodResponseResponse> deleteMethodResponse(
            DeleteMethodResponseRequest deleteMethodResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing MethodResponse resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMethodResponseRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMethodResponseRequest#builder()}
     * </p>
     *
     * @param deleteMethodResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteMethodResponseRequest.Builder} to create a
     *        request. A request to delete an existing MethodResponse resource.
     * @return A Java Future containing the result of the DeleteMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteMethodResponse
     */
    default CompletableFuture<DeleteMethodResponseResponse> deleteMethodResponse(
            Consumer<DeleteMethodResponseRequest.Builder> deleteMethodResponseRequest) {
        return deleteMethodResponse(DeleteMethodResponseRequest.builder().applyMutation(deleteMethodResponseRequest).build());
    }

    /**
     * <p>
     * Deletes a model.
     * </p>
     *
     * @param deleteModelRequest
     *        Request to delete an existing model in an existing RestApi resource.
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteModel
     */
    default CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest deleteModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteModelRequest#builder()}
     * </p>
     *
     * @param deleteModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteModelRequest.Builder} to create a request.
     *        Request to delete an existing model in an existing RestApi resource.
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteModel
     */
    default CompletableFuture<DeleteModelResponse> deleteModel(Consumer<DeleteModelRequest.Builder> deleteModelRequest) {
        return deleteModel(DeleteModelRequest.builder().applyMutation(deleteModelRequest).build());
    }

    /**
     * <p>
     * Deletes a RequestValidator of a given RestApi.
     * </p>
     *
     * @param deleteRequestValidatorRequest
     *        Deletes a specified RequestValidator of a given RestApi.
     * @return A Java Future containing the result of the DeleteRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteRequestValidator
     */
    default CompletableFuture<DeleteRequestValidatorResponse> deleteRequestValidator(
            DeleteRequestValidatorRequest deleteRequestValidatorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a RequestValidator of a given RestApi.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRequestValidatorRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRequestValidatorRequest#builder()}
     * </p>
     *
     * @param deleteRequestValidatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteRequestValidatorRequest.Builder} to create a
     *        request. Deletes a specified RequestValidator of a given RestApi.
     * @return A Java Future containing the result of the DeleteRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteRequestValidator
     */
    default CompletableFuture<DeleteRequestValidatorResponse> deleteRequestValidator(
            Consumer<DeleteRequestValidatorRequest.Builder> deleteRequestValidatorRequest) {
        return deleteRequestValidator(DeleteRequestValidatorRequest.builder().applyMutation(deleteRequestValidatorRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a Resource resource.
     * </p>
     *
     * @param deleteResourceRequest
     *        Request to delete a Resource.
     * @return A Java Future containing the result of the DeleteResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteResource
     */
    default CompletableFuture<DeleteResourceResponse> deleteResource(DeleteResourceRequest deleteResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Resource resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteResourceRequest#builder()}
     * </p>
     *
     * @param deleteResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteResourceRequest.Builder} to create a
     *        request. Request to delete a Resource.
     * @return A Java Future containing the result of the DeleteResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteResource
     */
    default CompletableFuture<DeleteResourceResponse> deleteResource(Consumer<DeleteResourceRequest.Builder> deleteResourceRequest) {
        return deleteResource(DeleteResourceRequest.builder().applyMutation(deleteResourceRequest).build());
    }

    /**
     * <p>
     * Deletes the specified API.
     * </p>
     *
     * @param deleteRestApiRequest
     *        Request to delete the specified API from your collection.
     * @return A Java Future containing the result of the DeleteRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteRestApi
     */
    default CompletableFuture<DeleteRestApiResponse> deleteRestApi(DeleteRestApiRequest deleteRestApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRestApiRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRestApiRequest#builder()}
     * </p>
     *
     * @param deleteRestApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteRestApiRequest.Builder} to create a request.
     *        Request to delete the specified API from your collection.
     * @return A Java Future containing the result of the DeleteRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteRestApi
     */
    default CompletableFuture<DeleteRestApiResponse> deleteRestApi(Consumer<DeleteRestApiRequest.Builder> deleteRestApiRequest) {
        return deleteRestApi(DeleteRestApiRequest.builder().applyMutation(deleteRestApiRequest).build());
    }

    /**
     * <p>
     * Deletes a Stage resource.
     * </p>
     *
     * @param deleteStageRequest
     *        Requests API Gateway to delete a Stage resource.
     * @return A Java Future containing the result of the DeleteStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteStage
     */
    default CompletableFuture<DeleteStageResponse> deleteStage(DeleteStageRequest deleteStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Stage resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStageRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStageRequest#builder()}
     * </p>
     *
     * @param deleteStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteStageRequest.Builder} to create a request.
     *        Requests API Gateway to delete a Stage resource.
     * @return A Java Future containing the result of the DeleteStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteStage
     */
    default CompletableFuture<DeleteStageResponse> deleteStage(Consumer<DeleteStageRequest.Builder> deleteStageRequest) {
        return deleteStage(DeleteStageRequest.builder().applyMutation(deleteStageRequest).build());
    }

    /**
     * <p>
     * Deletes a usage plan of a given plan Id.
     * </p>
     *
     * @param deleteUsagePlanRequest
     *        The DELETE request to delete a usage plan of a given plan Id.
     * @return A Java Future containing the result of the DeleteUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteUsagePlan
     */
    default CompletableFuture<DeleteUsagePlanResponse> deleteUsagePlan(DeleteUsagePlanRequest deleteUsagePlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a usage plan of a given plan Id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUsagePlanRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteUsagePlanRequest#builder()}
     * </p>
     *
     * @param deleteUsagePlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanRequest.Builder} to create a
     *        request. The DELETE request to delete a usage plan of a given plan Id.
     * @return A Java Future containing the result of the DeleteUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteUsagePlan
     */
    default CompletableFuture<DeleteUsagePlanResponse> deleteUsagePlan(
            Consumer<DeleteUsagePlanRequest.Builder> deleteUsagePlanRequest) {
        return deleteUsagePlan(DeleteUsagePlanRequest.builder().applyMutation(deleteUsagePlanRequest).build());
    }

    /**
     * <p>
     * Deletes a usage plan key and remove the underlying API key from the associated usage plan.
     * </p>
     *
     * @param deleteUsagePlanKeyRequest
     *        The DELETE request to delete a usage plan key and remove the underlying API key from the associated usage
     *        plan.
     * @return A Java Future containing the result of the DeleteUsagePlanKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteUsagePlanKey
     */
    default CompletableFuture<DeleteUsagePlanKeyResponse> deleteUsagePlanKey(DeleteUsagePlanKeyRequest deleteUsagePlanKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a usage plan key and remove the underlying API key from the associated usage plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUsagePlanKeyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUsagePlanKeyRequest#builder()}
     * </p>
     *
     * @param deleteUsagePlanKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteUsagePlanKeyRequest.Builder} to create a
     *        request. The DELETE request to delete a usage plan key and remove the underlying API key from the
     *        associated usage plan.
     * @return A Java Future containing the result of the DeleteUsagePlanKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteUsagePlanKey
     */
    default CompletableFuture<DeleteUsagePlanKeyResponse> deleteUsagePlanKey(
            Consumer<DeleteUsagePlanKeyRequest.Builder> deleteUsagePlanKeyRequest) {
        return deleteUsagePlanKey(DeleteUsagePlanKeyRequest.builder().applyMutation(deleteUsagePlanKeyRequest).build());
    }

    /**
     * <p>
     * Deletes an existing VpcLink of a specified identifier.
     * </p>
     *
     * @param deleteVpcLinkRequest
     *        Deletes an existing VpcLink of a specified identifier.
     * @return A Java Future containing the result of the DeleteVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteVpcLink
     */
    default CompletableFuture<DeleteVpcLinkResponse> deleteVpcLink(DeleteVpcLinkRequest deleteVpcLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing VpcLink of a specified identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVpcLinkRequest#builder()}
     * </p>
     *
     * @param deleteVpcLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.DeleteVpcLinkRequest.Builder} to create a request.
     *        Deletes an existing VpcLink of a specified identifier.
     * @return A Java Future containing the result of the DeleteVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.DeleteVpcLink
     */
    default CompletableFuture<DeleteVpcLinkResponse> deleteVpcLink(Consumer<DeleteVpcLinkRequest.Builder> deleteVpcLinkRequest) {
        return deleteVpcLink(DeleteVpcLinkRequest.builder().applyMutation(deleteVpcLinkRequest).build());
    }

    /**
     * <p>
     * Flushes all authorizer cache entries on a stage.
     * </p>
     *
     * @param flushStageAuthorizersCacheRequest
     *        Request to flush authorizer cache entries on a specified stage.
     * @return A Java Future containing the result of the FlushStageAuthorizersCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.FlushStageAuthorizersCache
     */
    default CompletableFuture<FlushStageAuthorizersCacheResponse> flushStageAuthorizersCache(
            FlushStageAuthorizersCacheRequest flushStageAuthorizersCacheRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Flushes all authorizer cache entries on a stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FlushStageAuthorizersCacheRequest.Builder} avoiding
     * the need to create one manually via {@link FlushStageAuthorizersCacheRequest#builder()}
     * </p>
     *
     * @param flushStageAuthorizersCacheRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.FlushStageAuthorizersCacheRequest.Builder} to
     *        create a request. Request to flush authorizer cache entries on a specified stage.
     * @return A Java Future containing the result of the FlushStageAuthorizersCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.FlushStageAuthorizersCache
     */
    default CompletableFuture<FlushStageAuthorizersCacheResponse> flushStageAuthorizersCache(
            Consumer<FlushStageAuthorizersCacheRequest.Builder> flushStageAuthorizersCacheRequest) {
        return flushStageAuthorizersCache(FlushStageAuthorizersCacheRequest.builder()
                .applyMutation(flushStageAuthorizersCacheRequest).build());
    }

    /**
     * <p>
     * Flushes a stage's cache.
     * </p>
     *
     * @param flushStageCacheRequest
     *        Requests API Gateway to flush a stage's cache.
     * @return A Java Future containing the result of the FlushStageCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.FlushStageCache
     */
    default CompletableFuture<FlushStageCacheResponse> flushStageCache(FlushStageCacheRequest flushStageCacheRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Flushes a stage's cache.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FlushStageCacheRequest.Builder} avoiding the need
     * to create one manually via {@link FlushStageCacheRequest#builder()}
     * </p>
     *
     * @param flushStageCacheRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.FlushStageCacheRequest.Builder} to create a
     *        request. Requests API Gateway to flush a stage's cache.
     * @return A Java Future containing the result of the FlushStageCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.FlushStageCache
     */
    default CompletableFuture<FlushStageCacheResponse> flushStageCache(
            Consumer<FlushStageCacheRequest.Builder> flushStageCacheRequest) {
        return flushStageCache(FlushStageCacheRequest.builder().applyMutation(flushStageCacheRequest).build());
    }

    /**
     * <p>
     * Generates a ClientCertificate resource.
     * </p>
     *
     * @param generateClientCertificateRequest
     *        A request to generate a ClientCertificate resource.
     * @return A Java Future containing the result of the GenerateClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GenerateClientCertificate
     */
    default CompletableFuture<GenerateClientCertificateResponse> generateClientCertificate(
            GenerateClientCertificateRequest generateClientCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a ClientCertificate resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateClientCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link GenerateClientCertificateRequest#builder()}
     * </p>
     *
     * @param generateClientCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateRequest.Builder} to
     *        create a request. A request to generate a ClientCertificate resource.
     * @return A Java Future containing the result of the GenerateClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GenerateClientCertificate
     */
    default CompletableFuture<GenerateClientCertificateResponse> generateClientCertificate(
            Consumer<GenerateClientCertificateRequest.Builder> generateClientCertificateRequest) {
        return generateClientCertificate(GenerateClientCertificateRequest.builder()
                .applyMutation(generateClientCertificateRequest).build());
    }

    /**
     * <p>
     * Generates a ClientCertificate resource.
     * </p>
     *
     * @return A Java Future containing the result of the GenerateClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GenerateClientCertificate
     */
    default CompletableFuture<GenerateClientCertificateResponse> generateClientCertificate() {
        return generateClientCertificate(GenerateClientCertificateRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the current Account resource.
     * </p>
     *
     * @param getAccountRequest
     *        Requests API Gateway to get information about the current Account resource.
     * @return A Java Future containing the result of the GetAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetAccount
     */
    default CompletableFuture<GetAccountResponse> getAccount(GetAccountRequest getAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the current Account resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountRequest.Builder} avoiding the need to
     * create one manually via {@link GetAccountRequest#builder()}
     * </p>
     *
     * @param getAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetAccountRequest.Builder} to create a request.
     *        Requests API Gateway to get information about the current Account resource.
     * @return A Java Future containing the result of the GetAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetAccount
     */
    default CompletableFuture<GetAccountResponse> getAccount(Consumer<GetAccountRequest.Builder> getAccountRequest) {
        return getAccount(GetAccountRequest.builder().applyMutation(getAccountRequest).build());
    }

    /**
     * <p>
     * Gets information about the current Account resource.
     * </p>
     *
     * @return A Java Future containing the result of the GetAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetAccount
     */
    default CompletableFuture<GetAccountResponse> getAccount() {
        return getAccount(GetAccountRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the current ApiKey resource.
     * </p>
     *
     * @param getApiKeyRequest
     *        A request to get information about the current ApiKey resource.
     * @return A Java Future containing the result of the GetApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetApiKey
     */
    default CompletableFuture<GetApiKeyResponse> getApiKey(GetApiKeyRequest getApiKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the current ApiKey resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link GetApiKeyRequest#builder()}
     * </p>
     *
     * @param getApiKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetApiKeyRequest.Builder} to create a request. A
     *        request to get information about the current ApiKey resource.
     * @return A Java Future containing the result of the GetApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetApiKey
     */
    default CompletableFuture<GetApiKeyResponse> getApiKey(Consumer<GetApiKeyRequest.Builder> getApiKeyRequest) {
        return getApiKey(GetApiKeyRequest.builder().applyMutation(getApiKeyRequest).build());
    }

    /**
     * <p>
     * Gets information about the current ApiKeys resource.
     * </p>
     *
     * @param getApiKeysRequest
     *        A request to get information about the current ApiKeys resource.
     * @return A Java Future containing the result of the GetApiKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetApiKeys
     */
    default CompletableFuture<GetApiKeysResponse> getApiKeys(GetApiKeysRequest getApiKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the current ApiKeys resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiKeysRequest.Builder} avoiding the need to
     * create one manually via {@link GetApiKeysRequest#builder()}
     * </p>
     *
     * @param getApiKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest.Builder} to create a request. A
     *        request to get information about the current ApiKeys resource.
     * @return A Java Future containing the result of the GetApiKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetApiKeys
     */
    default CompletableFuture<GetApiKeysResponse> getApiKeys(Consumer<GetApiKeysRequest.Builder> getApiKeysRequest) {
        return getApiKeys(GetApiKeysRequest.builder().applyMutation(getApiKeysRequest).build());
    }

    /**
     * <p>
     * Gets information about the current ApiKeys resource.
     * </p>
     *
     * @return A Java Future containing the result of the GetApiKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetApiKeys
     */
    default CompletableFuture<GetApiKeysResponse> getApiKeys() {
        return getApiKeys(GetApiKeysRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysPublisher publisher = client.getApiKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysPublisher publisher = client.getApiKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetApiKeys
     */
    default GetApiKeysPublisher getApiKeysPaginator() {
        return getApiKeysPaginator(GetApiKeysRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysPublisher publisher = client.getApiKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysPublisher publisher = client.getApiKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)} operation.</b>
     * </p>
     *
     * @param getApiKeysRequest
     *        A request to get information about the current ApiKeys resource.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetApiKeys
     */
    default GetApiKeysPublisher getApiKeysPaginator(GetApiKeysRequest getApiKeysRequest) {
        return new GetApiKeysPublisher(this, getApiKeysRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysPublisher publisher = client.getApiKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetApiKeysPublisher publisher = client.getApiKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getApiKeys(software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiKeysRequest.Builder} avoiding the need to
     * create one manually via {@link GetApiKeysRequest#builder()}
     * </p>
     *
     * @param getApiKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetApiKeysRequest.Builder} to create a request. A
     *        request to get information about the current ApiKeys resource.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetApiKeys
     */
    default GetApiKeysPublisher getApiKeysPaginator(Consumer<GetApiKeysRequest.Builder> getApiKeysRequest) {
        return getApiKeysPaginator(GetApiKeysRequest.builder().applyMutation(getApiKeysRequest).build());
    }

    /**
     * <p>
     * Describe an existing Authorizer resource.
     * </p>
     *
     * @param getAuthorizerRequest
     *        Request to describe an existing Authorizer resource.
     * @return A Java Future containing the result of the GetAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetAuthorizer
     */
    default CompletableFuture<GetAuthorizerResponse> getAuthorizer(GetAuthorizerRequest getAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an existing Authorizer resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthorizerRequest.Builder} avoiding the need to
     * create one manually via {@link GetAuthorizerRequest#builder()}
     * </p>
     *
     * @param getAuthorizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetAuthorizerRequest.Builder} to create a request.
     *        Request to describe an existing Authorizer resource.
     * @return A Java Future containing the result of the GetAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetAuthorizer
     */
    default CompletableFuture<GetAuthorizerResponse> getAuthorizer(Consumer<GetAuthorizerRequest.Builder> getAuthorizerRequest) {
        return getAuthorizer(GetAuthorizerRequest.builder().applyMutation(getAuthorizerRequest).build());
    }

    /**
     * <p>
     * Describe an existing Authorizers resource.
     * </p>
     *
     * @param getAuthorizersRequest
     *        Request to describe an existing Authorizers resource.
     * @return A Java Future containing the result of the GetAuthorizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetAuthorizers
     */
    default CompletableFuture<GetAuthorizersResponse> getAuthorizers(GetAuthorizersRequest getAuthorizersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an existing Authorizers resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthorizersRequest.Builder} avoiding the need to
     * create one manually via {@link GetAuthorizersRequest#builder()}
     * </p>
     *
     * @param getAuthorizersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest.Builder} to create a
     *        request. Request to describe an existing Authorizers resource.
     * @return A Java Future containing the result of the GetAuthorizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetAuthorizers
     */
    default CompletableFuture<GetAuthorizersResponse> getAuthorizers(Consumer<GetAuthorizersRequest.Builder> getAuthorizersRequest) {
        return getAuthorizers(GetAuthorizersRequest.builder().applyMutation(getAuthorizersRequest).build());
    }

    /**
     * <p>
     * Describe a BasePathMapping resource.
     * </p>
     *
     * @param getBasePathMappingRequest
     *        Request to describe a BasePathMapping resource.
     * @return A Java Future containing the result of the GetBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetBasePathMapping
     */
    default CompletableFuture<GetBasePathMappingResponse> getBasePathMapping(GetBasePathMappingRequest getBasePathMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe a BasePathMapping resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBasePathMappingRequest.Builder} avoiding the
     * need to create one manually via {@link GetBasePathMappingRequest#builder()}
     * </p>
     *
     * @param getBasePathMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetBasePathMappingRequest.Builder} to create a
     *        request. Request to describe a BasePathMapping resource.
     * @return A Java Future containing the result of the GetBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetBasePathMapping
     */
    default CompletableFuture<GetBasePathMappingResponse> getBasePathMapping(
            Consumer<GetBasePathMappingRequest.Builder> getBasePathMappingRequest) {
        return getBasePathMapping(GetBasePathMappingRequest.builder().applyMutation(getBasePathMappingRequest).build());
    }

    /**
     * <p>
     * Represents a collection of BasePathMapping resources.
     * </p>
     *
     * @param getBasePathMappingsRequest
     *        A request to get information about a collection of BasePathMapping resources.
     * @return A Java Future containing the result of the GetBasePathMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetBasePathMappings
     */
    default CompletableFuture<GetBasePathMappingsResponse> getBasePathMappings(
            GetBasePathMappingsRequest getBasePathMappingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a collection of BasePathMapping resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBasePathMappingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBasePathMappingsRequest#builder()}
     * </p>
     *
     * @param getBasePathMappingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest.Builder} to create a
     *        request. A request to get information about a collection of BasePathMapping resources.
     * @return A Java Future containing the result of the GetBasePathMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetBasePathMappings
     */
    default CompletableFuture<GetBasePathMappingsResponse> getBasePathMappings(
            Consumer<GetBasePathMappingsRequest.Builder> getBasePathMappingsRequest) {
        return getBasePathMappings(GetBasePathMappingsRequest.builder().applyMutation(getBasePathMappingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getBasePathMappings(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsPublisher publisher = client.getBasePathMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsPublisher publisher = client.getBasePathMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBasePathMappings(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getBasePathMappingsRequest
     *        A request to get information about a collection of BasePathMapping resources.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetBasePathMappings
     */
    default GetBasePathMappingsPublisher getBasePathMappingsPaginator(GetBasePathMappingsRequest getBasePathMappingsRequest) {
        return new GetBasePathMappingsPublisher(this, getBasePathMappingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getBasePathMappings(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsPublisher publisher = client.getBasePathMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetBasePathMappingsPublisher publisher = client.getBasePathMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBasePathMappings(software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBasePathMappingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBasePathMappingsRequest#builder()}
     * </p>
     *
     * @param getBasePathMappingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest.Builder} to create a
     *        request. A request to get information about a collection of BasePathMapping resources.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetBasePathMappings
     */
    default GetBasePathMappingsPublisher getBasePathMappingsPaginator(
            Consumer<GetBasePathMappingsRequest.Builder> getBasePathMappingsRequest) {
        return getBasePathMappingsPaginator(GetBasePathMappingsRequest.builder().applyMutation(getBasePathMappingsRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the current ClientCertificate resource.
     * </p>
     *
     * @param getClientCertificateRequest
     *        A request to get information about the current ClientCertificate resource.
     * @return A Java Future containing the result of the GetClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetClientCertificate
     */
    default CompletableFuture<GetClientCertificateResponse> getClientCertificate(
            GetClientCertificateRequest getClientCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the current ClientCertificate resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClientCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link GetClientCertificateRequest#builder()}
     * </p>
     *
     * @param getClientCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetClientCertificateRequest.Builder} to create a
     *        request. A request to get information about the current ClientCertificate resource.
     * @return A Java Future containing the result of the GetClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetClientCertificate
     */
    default CompletableFuture<GetClientCertificateResponse> getClientCertificate(
            Consumer<GetClientCertificateRequest.Builder> getClientCertificateRequest) {
        return getClientCertificate(GetClientCertificateRequest.builder().applyMutation(getClientCertificateRequest).build());
    }

    /**
     * <p>
     * Gets a collection of ClientCertificate resources.
     * </p>
     *
     * @param getClientCertificatesRequest
     *        A request to get information about a collection of ClientCertificate resources.
     * @return A Java Future containing the result of the GetClientCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetClientCertificates
     */
    default CompletableFuture<GetClientCertificatesResponse> getClientCertificates(
            GetClientCertificatesRequest getClientCertificatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a collection of ClientCertificate resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClientCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link GetClientCertificatesRequest#builder()}
     * </p>
     *
     * @param getClientCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest.Builder} to create a
     *        request. A request to get information about a collection of ClientCertificate resources.
     * @return A Java Future containing the result of the GetClientCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetClientCertificates
     */
    default CompletableFuture<GetClientCertificatesResponse> getClientCertificates(
            Consumer<GetClientCertificatesRequest.Builder> getClientCertificatesRequest) {
        return getClientCertificates(GetClientCertificatesRequest.builder().applyMutation(getClientCertificatesRequest).build());
    }

    /**
     * <p>
     * Gets a collection of ClientCertificate resources.
     * </p>
     *
     * @return A Java Future containing the result of the GetClientCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetClientCertificates
     */
    default CompletableFuture<GetClientCertificatesResponse> getClientCertificates() {
        return getClientCertificates(GetClientCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesPublisher publisher = client.getClientCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesPublisher publisher = client.getClientCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetClientCertificates
     */
    default GetClientCertificatesPublisher getClientCertificatesPaginator() {
        return getClientCertificatesPaginator(GetClientCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesPublisher publisher = client.getClientCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesPublisher publisher = client.getClientCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getClientCertificatesRequest
     *        A request to get information about a collection of ClientCertificate resources.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetClientCertificates
     */
    default GetClientCertificatesPublisher getClientCertificatesPaginator(
            GetClientCertificatesRequest getClientCertificatesRequest) {
        return new GetClientCertificatesPublisher(this, getClientCertificatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesPublisher publisher = client.getClientCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetClientCertificatesPublisher publisher = client.getClientCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClientCertificates(software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClientCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link GetClientCertificatesRequest#builder()}
     * </p>
     *
     * @param getClientCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest.Builder} to create a
     *        request. A request to get information about a collection of ClientCertificate resources.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetClientCertificates
     */
    default GetClientCertificatesPublisher getClientCertificatesPaginator(
            Consumer<GetClientCertificatesRequest.Builder> getClientCertificatesRequest) {
        return getClientCertificatesPaginator(GetClientCertificatesRequest.builder().applyMutation(getClientCertificatesRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a Deployment resource.
     * </p>
     *
     * @param getDeploymentRequest
     *        Requests API Gateway to get information about a Deployment resource.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDeployment
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(GetDeploymentRequest getDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Deployment resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentRequest#builder()}
     * </p>
     *
     * @param getDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetDeploymentRequest.Builder} to create a request.
     *        Requests API Gateway to get information about a Deployment resource.
     * @return A Java Future containing the result of the GetDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDeployment
     */
    default CompletableFuture<GetDeploymentResponse> getDeployment(Consumer<GetDeploymentRequest.Builder> getDeploymentRequest) {
        return getDeployment(GetDeploymentRequest.builder().applyMutation(getDeploymentRequest).build());
    }

    /**
     * <p>
     * Gets information about a Deployments collection.
     * </p>
     *
     * @param getDeploymentsRequest
     *        Requests API Gateway to get information about a Deployments collection.
     * @return A Java Future containing the result of the GetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDeployments
     */
    default CompletableFuture<GetDeploymentsResponse> getDeployments(GetDeploymentsRequest getDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Deployments collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentsRequest#builder()}
     * </p>
     *
     * @param getDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest.Builder} to create a
     *        request. Requests API Gateway to get information about a Deployments collection.
     * @return A Java Future containing the result of the GetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDeployments
     */
    default CompletableFuture<GetDeploymentsResponse> getDeployments(Consumer<GetDeploymentsRequest.Builder> getDeploymentsRequest) {
        return getDeployments(GetDeploymentsRequest.builder().applyMutation(getDeploymentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getDeployments(software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsPublisher publisher = client.getDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsPublisher publisher = client.getDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDeployments(software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest)} operation.</b>
     * </p>
     *
     * @param getDeploymentsRequest
     *        Requests API Gateway to get information about a Deployments collection.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDeployments
     */
    default GetDeploymentsPublisher getDeploymentsPaginator(GetDeploymentsRequest getDeploymentsRequest) {
        return new GetDeploymentsPublisher(this, getDeploymentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getDeployments(software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsPublisher publisher = client.getDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDeploymentsPublisher publisher = client.getDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDeployments(software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentsRequest#builder()}
     * </p>
     *
     * @param getDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest.Builder} to create a
     *        request. Requests API Gateway to get information about a Deployments collection.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDeployments
     */
    default GetDeploymentsPublisher getDeploymentsPaginator(Consumer<GetDeploymentsRequest.Builder> getDeploymentsRequest) {
        return getDeploymentsPaginator(GetDeploymentsRequest.builder().applyMutation(getDeploymentsRequest).build());
    }

    /**
     * <p>
     * Gets a documentation part.
     * </p>
     *
     * @param getDocumentationPartRequest
     *        Gets a specified documentation part of a given API.
     * @return A Java Future containing the result of the GetDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationPart
     */
    default CompletableFuture<GetDocumentationPartResponse> getDocumentationPart(
            GetDocumentationPartRequest getDocumentationPartRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a documentation part.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentationPartRequest.Builder} avoiding the
     * need to create one manually via {@link GetDocumentationPartRequest#builder()}
     * </p>
     *
     * @param getDocumentationPartRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetDocumentationPartRequest.Builder} to create a
     *        request. Gets a specified documentation part of a given API.
     * @return A Java Future containing the result of the GetDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationPart
     */
    default CompletableFuture<GetDocumentationPartResponse> getDocumentationPart(
            Consumer<GetDocumentationPartRequest.Builder> getDocumentationPartRequest) {
        return getDocumentationPart(GetDocumentationPartRequest.builder().applyMutation(getDocumentationPartRequest).build());
    }

    /**
     * <p>
     * Gets documentation parts.
     * </p>
     *
     * @param getDocumentationPartsRequest
     *        Gets the documentation parts of an API. The result may be filtered by the type, name, or path of API
     *        entities (targets).
     * @return A Java Future containing the result of the GetDocumentationParts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationParts
     */
    default CompletableFuture<GetDocumentationPartsResponse> getDocumentationParts(
            GetDocumentationPartsRequest getDocumentationPartsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets documentation parts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentationPartsRequest.Builder} avoiding the
     * need to create one manually via {@link GetDocumentationPartsRequest#builder()}
     * </p>
     *
     * @param getDocumentationPartsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetDocumentationPartsRequest.Builder} to create a
     *        request. Gets the documentation parts of an API. The result may be filtered by the type, name, or path of
     *        API entities (targets).
     * @return A Java Future containing the result of the GetDocumentationParts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationParts
     */
    default CompletableFuture<GetDocumentationPartsResponse> getDocumentationParts(
            Consumer<GetDocumentationPartsRequest.Builder> getDocumentationPartsRequest) {
        return getDocumentationParts(GetDocumentationPartsRequest.builder().applyMutation(getDocumentationPartsRequest).build());
    }

    /**
     * <p>
     * Gets a documentation version.
     * </p>
     *
     * @param getDocumentationVersionRequest
     *        Gets a documentation snapshot of an API.
     * @return A Java Future containing the result of the GetDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationVersion
     */
    default CompletableFuture<GetDocumentationVersionResponse> getDocumentationVersion(
            GetDocumentationVersionRequest getDocumentationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a documentation version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link GetDocumentationVersionRequest#builder()}
     * </p>
     *
     * @param getDocumentationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionRequest.Builder} to create
     *        a request. Gets a documentation snapshot of an API.
     * @return A Java Future containing the result of the GetDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationVersion
     */
    default CompletableFuture<GetDocumentationVersionResponse> getDocumentationVersion(
            Consumer<GetDocumentationVersionRequest.Builder> getDocumentationVersionRequest) {
        return getDocumentationVersion(GetDocumentationVersionRequest.builder().applyMutation(getDocumentationVersionRequest)
                .build());
    }

    /**
     * <p>
     * Gets documentation versions.
     * </p>
     *
     * @param getDocumentationVersionsRequest
     *        Gets the documentation versions of an API.
     * @return A Java Future containing the result of the GetDocumentationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationVersions
     */
    default CompletableFuture<GetDocumentationVersionsResponse> getDocumentationVersions(
            GetDocumentationVersionsRequest getDocumentationVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets documentation versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetDocumentationVersionsRequest#builder()}
     * </p>
     *
     * @param getDocumentationVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionsRequest.Builder} to create
     *        a request. Gets the documentation versions of an API.
     * @return A Java Future containing the result of the GetDocumentationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDocumentationVersions
     */
    default CompletableFuture<GetDocumentationVersionsResponse> getDocumentationVersions(
            Consumer<GetDocumentationVersionsRequest.Builder> getDocumentationVersionsRequest) {
        return getDocumentationVersions(GetDocumentationVersionsRequest.builder().applyMutation(getDocumentationVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Represents a domain name that is contained in a simpler, more intuitive URL that can be called.
     * </p>
     *
     * @param getDomainNameRequest
     *        Request to get the name of a DomainName resource.
     * @return A Java Future containing the result of the GetDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDomainName
     */
    default CompletableFuture<GetDomainNameResponse> getDomainName(GetDomainNameRequest getDomainNameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a domain name that is contained in a simpler, more intuitive URL that can be called.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainNameRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainNameRequest#builder()}
     * </p>
     *
     * @param getDomainNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetDomainNameRequest.Builder} to create a request.
     *        Request to get the name of a DomainName resource.
     * @return A Java Future containing the result of the GetDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDomainName
     */
    default CompletableFuture<GetDomainNameResponse> getDomainName(Consumer<GetDomainNameRequest.Builder> getDomainNameRequest) {
        return getDomainName(GetDomainNameRequest.builder().applyMutation(getDomainNameRequest).build());
    }

    /**
     * <p>
     * Represents a collection of DomainName resources.
     * </p>
     *
     * @param getDomainNamesRequest
     *        Request to describe a collection of DomainName resources.
     * @return A Java Future containing the result of the GetDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDomainNames
     */
    default CompletableFuture<GetDomainNamesResponse> getDomainNames(GetDomainNamesRequest getDomainNamesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a collection of DomainName resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainNamesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainNamesRequest#builder()}
     * </p>
     *
     * @param getDomainNamesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest.Builder} to create a
     *        request. Request to describe a collection of DomainName resources.
     * @return A Java Future containing the result of the GetDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDomainNames
     */
    default CompletableFuture<GetDomainNamesResponse> getDomainNames(Consumer<GetDomainNamesRequest.Builder> getDomainNamesRequest) {
        return getDomainNames(GetDomainNamesRequest.builder().applyMutation(getDomainNamesRequest).build());
    }

    /**
     * <p>
     * Represents a collection of DomainName resources.
     * </p>
     *
     * @return A Java Future containing the result of the GetDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDomainNames
     */
    default CompletableFuture<GetDomainNamesResponse> getDomainNames() {
        return getDomainNames(GetDomainNamesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesPublisher publisher = client.getDomainNamesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesPublisher publisher = client.getDomainNamesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDomainNames
     */
    default GetDomainNamesPublisher getDomainNamesPaginator() {
        return getDomainNamesPaginator(GetDomainNamesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesPublisher publisher = client.getDomainNamesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesPublisher publisher = client.getDomainNamesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation.</b>
     * </p>
     *
     * @param getDomainNamesRequest
     *        Request to describe a collection of DomainName resources.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDomainNames
     */
    default GetDomainNamesPublisher getDomainNamesPaginator(GetDomainNamesRequest getDomainNamesRequest) {
        return new GetDomainNamesPublisher(this, getDomainNamesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesPublisher publisher = client.getDomainNamesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetDomainNamesPublisher publisher = client.getDomainNamesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDomainNames(software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainNamesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainNamesRequest#builder()}
     * </p>
     *
     * @param getDomainNamesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest.Builder} to create a
     *        request. Request to describe a collection of DomainName resources.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetDomainNames
     */
    default GetDomainNamesPublisher getDomainNamesPaginator(Consumer<GetDomainNamesRequest.Builder> getDomainNamesRequest) {
        return getDomainNamesPaginator(GetDomainNamesRequest.builder().applyMutation(getDomainNamesRequest).build());
    }

    /**
     * <p>
     * Exports a deployed version of a RestApi in a specified format.
     * </p>
     *
     * @param getExportRequest
     *        Request a new export of a RestApi for a particular Stage.
     * @return A Java Future containing the result of the GetExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetExport
     */
    default CompletableFuture<GetExportResponse> getExport(GetExportRequest getExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports a deployed version of a RestApi in a specified format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExportRequest.Builder} avoiding the need to
     * create one manually via {@link GetExportRequest#builder()}
     * </p>
     *
     * @param getExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetExportRequest.Builder} to create a request.
     *        Request a new export of a RestApi for a particular Stage.
     * @return A Java Future containing the result of the GetExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetExport
     */
    default CompletableFuture<GetExportResponse> getExport(Consumer<GetExportRequest.Builder> getExportRequest) {
        return getExport(GetExportRequest.builder().applyMutation(getExportRequest).build());
    }

    /**
     * <p>
     * Gets a GatewayResponse of a specified response type on the given RestApi.
     * </p>
     *
     * @param getGatewayResponseRequest
     *        Gets a GatewayResponse of a specified response type on the given RestApi.
     * @return A Java Future containing the result of the GetGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetGatewayResponse
     */
    default CompletableFuture<GetGatewayResponseResponse> getGatewayResponse(GetGatewayResponseRequest getGatewayResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a GatewayResponse of a specified response type on the given RestApi.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGatewayResponseRequest.Builder} avoiding the
     * need to create one manually via {@link GetGatewayResponseRequest#builder()}
     * </p>
     *
     * @param getGatewayResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetGatewayResponseRequest.Builder} to create a
     *        request. Gets a GatewayResponse of a specified response type on the given RestApi.
     * @return A Java Future containing the result of the GetGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetGatewayResponse
     */
    default CompletableFuture<GetGatewayResponseResponse> getGatewayResponse(
            Consumer<GetGatewayResponseRequest.Builder> getGatewayResponseRequest) {
        return getGatewayResponse(GetGatewayResponseRequest.builder().applyMutation(getGatewayResponseRequest).build());
    }

    /**
     * <p>
     * Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any definitions for
     * gateway responses, the result will be the API Gateway-generated default GatewayResponses collection for the
     * supported response types.
     * </p>
     *
     * @param getGatewayResponsesRequest
     *        Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any
     *        definitions for gateway responses, the result will be the API Gateway-generated default GatewayResponses
     *        collection for the supported response types.
     * @return A Java Future containing the result of the GetGatewayResponses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetGatewayResponses
     */
    default CompletableFuture<GetGatewayResponsesResponse> getGatewayResponses(
            GetGatewayResponsesRequest getGatewayResponsesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any definitions for
     * gateway responses, the result will be the API Gateway-generated default GatewayResponses collection for the
     * supported response types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGatewayResponsesRequest.Builder} avoiding the
     * need to create one manually via {@link GetGatewayResponsesRequest#builder()}
     * </p>
     *
     * @param getGatewayResponsesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesRequest.Builder} to create a
     *        request. Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any
     *        definitions for gateway responses, the result will be the API Gateway-generated default GatewayResponses
     *        collection for the supported response types.
     * @return A Java Future containing the result of the GetGatewayResponses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetGatewayResponses
     */
    default CompletableFuture<GetGatewayResponsesResponse> getGatewayResponses(
            Consumer<GetGatewayResponsesRequest.Builder> getGatewayResponsesRequest) {
        return getGatewayResponses(GetGatewayResponsesRequest.builder().applyMutation(getGatewayResponsesRequest).build());
    }

    /**
     * <p>
     * Get the integration settings.
     * </p>
     *
     * @param getIntegrationRequest
     *        Represents a request to get the integration configuration.
     * @return A Java Future containing the result of the GetIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetIntegration
     */
    default CompletableFuture<GetIntegrationResponse> getIntegration(GetIntegrationRequest getIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the integration settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationRequest.Builder} avoiding the need to
     * create one manually via {@link GetIntegrationRequest#builder()}
     * </p>
     *
     * @param getIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetIntegrationRequest.Builder} to create a
     *        request. Represents a request to get the integration configuration.
     * @return A Java Future containing the result of the GetIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetIntegration
     */
    default CompletableFuture<GetIntegrationResponse> getIntegration(Consumer<GetIntegrationRequest.Builder> getIntegrationRequest) {
        return getIntegration(GetIntegrationRequest.builder().applyMutation(getIntegrationRequest).build());
    }

    /**
     * <p>
     * Represents a get integration response.
     * </p>
     *
     * @param getIntegrationResponseRequest
     *        Represents a get integration response request.
     * @return A Java Future containing the result of the GetIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetIntegrationResponse
     */
    default CompletableFuture<GetIntegrationResponseResponse> getIntegrationResponse(
            GetIntegrationResponseRequest getIntegrationResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a get integration response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationResponseRequest.Builder} avoiding the
     * need to create one manually via {@link GetIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param getIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetIntegrationResponseRequest.Builder} to create a
     *        request. Represents a get integration response request.
     * @return A Java Future containing the result of the GetIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetIntegrationResponse
     */
    default CompletableFuture<GetIntegrationResponseResponse> getIntegrationResponse(
            Consumer<GetIntegrationResponseRequest.Builder> getIntegrationResponseRequest) {
        return getIntegrationResponse(GetIntegrationResponseRequest.builder().applyMutation(getIntegrationResponseRequest)
                .build());
    }

    /**
     * <p>
     * Describe an existing Method resource.
     * </p>
     *
     * @param getMethodRequest
     *        Request to describe an existing Method resource.
     * @return A Java Future containing the result of the GetMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetMethod
     */
    default CompletableFuture<GetMethodResponse> getMethod(GetMethodRequest getMethodRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe an existing Method resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMethodRequest.Builder} avoiding the need to
     * create one manually via {@link GetMethodRequest#builder()}
     * </p>
     *
     * @param getMethodRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetMethodRequest.Builder} to create a request.
     *        Request to describe an existing Method resource.
     * @return A Java Future containing the result of the GetMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetMethod
     */
    default CompletableFuture<GetMethodResponse> getMethod(Consumer<GetMethodRequest.Builder> getMethodRequest) {
        return getMethod(GetMethodRequest.builder().applyMutation(getMethodRequest).build());
    }

    /**
     * <p>
     * Describes a MethodResponse resource.
     * </p>
     *
     * @param getMethodResponseRequest
     *        Request to describe a MethodResponse resource.
     * @return A Java Future containing the result of the GetMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetMethodResponse
     */
    default CompletableFuture<GetMethodResponseResponse> getMethodResponse(GetMethodResponseRequest getMethodResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a MethodResponse resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMethodResponseRequest.Builder} avoiding the need
     * to create one manually via {@link GetMethodResponseRequest#builder()}
     * </p>
     *
     * @param getMethodResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetMethodResponseRequest.Builder} to create a
     *        request. Request to describe a MethodResponse resource.
     * @return A Java Future containing the result of the GetMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetMethodResponse
     */
    default CompletableFuture<GetMethodResponseResponse> getMethodResponse(
            Consumer<GetMethodResponseRequest.Builder> getMethodResponseRequest) {
        return getMethodResponse(GetMethodResponseRequest.builder().applyMutation(getMethodResponseRequest).build());
    }

    /**
     * <p>
     * Describes an existing model defined for a RestApi resource.
     * </p>
     *
     * @param getModelRequest
     *        Request to list information about a model in an existing RestApi resource.
     * @return A Java Future containing the result of the GetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModel
     */
    default CompletableFuture<GetModelResponse> getModel(GetModelRequest getModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an existing model defined for a RestApi resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelRequest#builder()}
     * </p>
     *
     * @param getModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetModelRequest.Builder} to create a request.
     *        Request to list information about a model in an existing RestApi resource.
     * @return A Java Future containing the result of the GetModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModel
     */
    default CompletableFuture<GetModelResponse> getModel(Consumer<GetModelRequest.Builder> getModelRequest) {
        return getModel(GetModelRequest.builder().applyMutation(getModelRequest).build());
    }

    /**
     * <p>
     * Generates a sample mapping template that can be used to transform a payload into the structure of a model.
     * </p>
     *
     * @param getModelTemplateRequest
     *        Request to generate a sample mapping template used to transform the payload.
     * @return A Java Future containing the result of the GetModelTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModelTemplate
     */
    default CompletableFuture<GetModelTemplateResponse> getModelTemplate(GetModelTemplateRequest getModelTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a sample mapping template that can be used to transform a payload into the structure of a model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetModelTemplateRequest#builder()}
     * </p>
     *
     * @param getModelTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetModelTemplateRequest.Builder} to create a
     *        request. Request to generate a sample mapping template used to transform the payload.
     * @return A Java Future containing the result of the GetModelTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModelTemplate
     */
    default CompletableFuture<GetModelTemplateResponse> getModelTemplate(
            Consumer<GetModelTemplateRequest.Builder> getModelTemplateRequest) {
        return getModelTemplate(GetModelTemplateRequest.builder().applyMutation(getModelTemplateRequest).build());
    }

    /**
     * <p>
     * Describes existing Models defined for a RestApi resource.
     * </p>
     *
     * @param getModelsRequest
     *        Request to list existing Models defined for a RestApi resource.
     * @return A Java Future containing the result of the GetModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModels
     */
    default CompletableFuture<GetModelsResponse> getModels(GetModelsRequest getModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes existing Models defined for a RestApi resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelsRequest#builder()}
     * </p>
     *
     * @param getModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetModelsRequest.Builder} to create a request.
     *        Request to list existing Models defined for a RestApi resource.
     * @return A Java Future containing the result of the GetModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModels
     */
    default CompletableFuture<GetModelsResponse> getModels(Consumer<GetModelsRequest.Builder> getModelsRequest) {
        return getModels(GetModelsRequest.builder().applyMutation(getModelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getModels(software.amazon.awssdk.services.apigateway.model.GetModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetModelsPublisher publisher = client.getModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetModelsPublisher publisher = client.getModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getModels(software.amazon.awssdk.services.apigateway.model.GetModelsRequest)} operation.</b>
     * </p>
     *
     * @param getModelsRequest
     *        Request to list existing Models defined for a RestApi resource.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModels
     */
    default GetModelsPublisher getModelsPaginator(GetModelsRequest getModelsRequest) {
        return new GetModelsPublisher(this, getModelsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getModels(software.amazon.awssdk.services.apigateway.model.GetModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetModelsPublisher publisher = client.getModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetModelsPublisher publisher = client.getModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getModels(software.amazon.awssdk.services.apigateway.model.GetModelsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelsRequest#builder()}
     * </p>
     *
     * @param getModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetModelsRequest.Builder} to create a request.
     *        Request to list existing Models defined for a RestApi resource.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetModels
     */
    default GetModelsPublisher getModelsPaginator(Consumer<GetModelsRequest.Builder> getModelsRequest) {
        return getModelsPaginator(GetModelsRequest.builder().applyMutation(getModelsRequest).build());
    }

    /**
     * <p>
     * Gets a RequestValidator of a given RestApi.
     * </p>
     *
     * @param getRequestValidatorRequest
     *        Gets a RequestValidator of a given RestApi.
     * @return A Java Future containing the result of the GetRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRequestValidator
     */
    default CompletableFuture<GetRequestValidatorResponse> getRequestValidator(
            GetRequestValidatorRequest getRequestValidatorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a RequestValidator of a given RestApi.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRequestValidatorRequest.Builder} avoiding the
     * need to create one manually via {@link GetRequestValidatorRequest#builder()}
     * </p>
     *
     * @param getRequestValidatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetRequestValidatorRequest.Builder} to create a
     *        request. Gets a RequestValidator of a given RestApi.
     * @return A Java Future containing the result of the GetRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRequestValidator
     */
    default CompletableFuture<GetRequestValidatorResponse> getRequestValidator(
            Consumer<GetRequestValidatorRequest.Builder> getRequestValidatorRequest) {
        return getRequestValidator(GetRequestValidatorRequest.builder().applyMutation(getRequestValidatorRequest).build());
    }

    /**
     * <p>
     * Gets the RequestValidators collection of a given RestApi.
     * </p>
     *
     * @param getRequestValidatorsRequest
     *        Gets the RequestValidators collection of a given RestApi.
     * @return A Java Future containing the result of the GetRequestValidators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRequestValidators
     */
    default CompletableFuture<GetRequestValidatorsResponse> getRequestValidators(
            GetRequestValidatorsRequest getRequestValidatorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the RequestValidators collection of a given RestApi.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRequestValidatorsRequest.Builder} avoiding the
     * need to create one manually via {@link GetRequestValidatorsRequest#builder()}
     * </p>
     *
     * @param getRequestValidatorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetRequestValidatorsRequest.Builder} to create a
     *        request. Gets the RequestValidators collection of a given RestApi.
     * @return A Java Future containing the result of the GetRequestValidators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRequestValidators
     */
    default CompletableFuture<GetRequestValidatorsResponse> getRequestValidators(
            Consumer<GetRequestValidatorsRequest.Builder> getRequestValidatorsRequest) {
        return getRequestValidators(GetRequestValidatorsRequest.builder().applyMutation(getRequestValidatorsRequest).build());
    }

    /**
     * <p>
     * Lists information about a resource.
     * </p>
     *
     * @param getResourceRequest
     *        Request to list information about a resource.
     * @return A Java Future containing the result of the GetResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetResource
     */
    default CompletableFuture<GetResourceResponse> getResource(GetResourceRequest getResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceRequest.Builder} avoiding the need to
     * create one manually via {@link GetResourceRequest#builder()}
     * </p>
     *
     * @param getResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetResourceRequest.Builder} to create a request.
     *        Request to list information about a resource.
     * @return A Java Future containing the result of the GetResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetResource
     */
    default CompletableFuture<GetResourceResponse> getResource(Consumer<GetResourceRequest.Builder> getResourceRequest) {
        return getResource(GetResourceRequest.builder().applyMutation(getResourceRequest).build());
    }

    /**
     * <p>
     * Lists information about a collection of Resource resources.
     * </p>
     *
     * @param getResourcesRequest
     *        Request to list information about a collection of resources.
     * @return A Java Future containing the result of the GetResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetResources
     */
    default CompletableFuture<GetResourcesResponse> getResources(GetResourcesRequest getResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about a collection of Resource resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link GetResourcesRequest#builder()}
     * </p>
     *
     * @param getResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetResourcesRequest.Builder} to create a request.
     *        Request to list information about a collection of resources.
     * @return A Java Future containing the result of the GetResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetResources
     */
    default CompletableFuture<GetResourcesResponse> getResources(Consumer<GetResourcesRequest.Builder> getResourcesRequest) {
        return getResources(GetResourcesRequest.builder().applyMutation(getResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getResources(software.amazon.awssdk.services.apigateway.model.GetResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetResourcesPublisher publisher = client.getResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetResourcesPublisher publisher = client.getResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResources(software.amazon.awssdk.services.apigateway.model.GetResourcesRequest)} operation.</b>
     * </p>
     *
     * @param getResourcesRequest
     *        Request to list information about a collection of resources.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetResources
     */
    default GetResourcesPublisher getResourcesPaginator(GetResourcesRequest getResourcesRequest) {
        return new GetResourcesPublisher(this, getResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getResources(software.amazon.awssdk.services.apigateway.model.GetResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetResourcesPublisher publisher = client.getResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetResourcesPublisher publisher = client.getResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResources(software.amazon.awssdk.services.apigateway.model.GetResourcesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link GetResourcesRequest#builder()}
     * </p>
     *
     * @param getResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetResourcesRequest.Builder} to create a request.
     *        Request to list information about a collection of resources.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetResources
     */
    default GetResourcesPublisher getResourcesPaginator(Consumer<GetResourcesRequest.Builder> getResourcesRequest) {
        return getResourcesPaginator(GetResourcesRequest.builder().applyMutation(getResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the RestApi resource in the collection.
     * </p>
     *
     * @param getRestApiRequest
     *        The GET request to list an existing RestApi defined for your collection.
     * @return A Java Future containing the result of the GetRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRestApi
     */
    default CompletableFuture<GetRestApiResponse> getRestApi(GetRestApiRequest getRestApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the RestApi resource in the collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRestApiRequest.Builder} avoiding the need to
     * create one manually via {@link GetRestApiRequest#builder()}
     * </p>
     *
     * @param getRestApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetRestApiRequest.Builder} to create a request.
     *        The GET request to list an existing RestApi defined for your collection.
     * @return A Java Future containing the result of the GetRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRestApi
     */
    default CompletableFuture<GetRestApiResponse> getRestApi(Consumer<GetRestApiRequest.Builder> getRestApiRequest) {
        return getRestApi(GetRestApiRequest.builder().applyMutation(getRestApiRequest).build());
    }

    /**
     * <p>
     * Lists the RestApis resources for your collection.
     * </p>
     *
     * @param getRestApisRequest
     *        The GET request to list existing RestApis defined for your collection.
     * @return A Java Future containing the result of the GetRestApis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRestApis
     */
    default CompletableFuture<GetRestApisResponse> getRestApis(GetRestApisRequest getRestApisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the RestApis resources for your collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRestApisRequest.Builder} avoiding the need to
     * create one manually via {@link GetRestApisRequest#builder()}
     * </p>
     *
     * @param getRestApisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetRestApisRequest.Builder} to create a request.
     *        The GET request to list existing RestApis defined for your collection.
     * @return A Java Future containing the result of the GetRestApis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRestApis
     */
    default CompletableFuture<GetRestApisResponse> getRestApis(Consumer<GetRestApisRequest.Builder> getRestApisRequest) {
        return getRestApis(GetRestApisRequest.builder().applyMutation(getRestApisRequest).build());
    }

    /**
     * <p>
     * Lists the RestApis resources for your collection.
     * </p>
     *
     * @return A Java Future containing the result of the GetRestApis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRestApis
     */
    default CompletableFuture<GetRestApisResponse> getRestApis() {
        return getRestApis(GetRestApisRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisPublisher publisher = client.getRestApisPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisPublisher publisher = client.getRestApisPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetRestApisResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetRestApisResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRestApis
     */
    default GetRestApisPublisher getRestApisPaginator() {
        return getRestApisPaginator(GetRestApisRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisPublisher publisher = client.getRestApisPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisPublisher publisher = client.getRestApisPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetRestApisResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetRestApisResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)} operation.</b>
     * </p>
     *
     * @param getRestApisRequest
     *        The GET request to list existing RestApis defined for your collection.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRestApis
     */
    default GetRestApisPublisher getRestApisPaginator(GetRestApisRequest getRestApisRequest) {
        return new GetRestApisPublisher(this, getRestApisRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisPublisher publisher = client.getRestApisPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetRestApisPublisher publisher = client.getRestApisPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetRestApisResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetRestApisResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRestApis(software.amazon.awssdk.services.apigateway.model.GetRestApisRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRestApisRequest.Builder} avoiding the need to
     * create one manually via {@link GetRestApisRequest#builder()}
     * </p>
     *
     * @param getRestApisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetRestApisRequest.Builder} to create a request.
     *        The GET request to list existing RestApis defined for your collection.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetRestApis
     */
    default GetRestApisPublisher getRestApisPaginator(Consumer<GetRestApisRequest.Builder> getRestApisRequest) {
        return getRestApisPaginator(GetRestApisRequest.builder().applyMutation(getRestApisRequest).build());
    }

    /**
     * <p>
     * Generates a client SDK for a RestApi and Stage.
     * </p>
     *
     * @param getSdkRequest
     *        Request a new generated client SDK for a RestApi and Stage.
     * @return A Java Future containing the result of the GetSdk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetSdk
     */
    default CompletableFuture<GetSdkResponse> getSdk(GetSdkRequest getSdkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a client SDK for a RestApi and Stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSdkRequest.Builder} avoiding the need to create
     * one manually via {@link GetSdkRequest#builder()}
     * </p>
     *
     * @param getSdkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetSdkRequest.Builder} to create a request.
     *        Request a new generated client SDK for a RestApi and Stage.
     * @return A Java Future containing the result of the GetSdk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetSdk
     */
    default CompletableFuture<GetSdkResponse> getSdk(Consumer<GetSdkRequest.Builder> getSdkRequest) {
        return getSdk(GetSdkRequest.builder().applyMutation(getSdkRequest).build());
    }

    /**
     * <p>
     * Gets an SDK type.
     * </p>
     *
     * @param getSdkTypeRequest
     *        Get an SdkType instance.
     * @return A Java Future containing the result of the GetSdkType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetSdkType
     */
    default CompletableFuture<GetSdkTypeResponse> getSdkType(GetSdkTypeRequest getSdkTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an SDK type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSdkTypeRequest.Builder} avoiding the need to
     * create one manually via {@link GetSdkTypeRequest#builder()}
     * </p>
     *
     * @param getSdkTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetSdkTypeRequest.Builder} to create a request.
     *        Get an SdkType instance.
     * @return A Java Future containing the result of the GetSdkType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetSdkType
     */
    default CompletableFuture<GetSdkTypeResponse> getSdkType(Consumer<GetSdkTypeRequest.Builder> getSdkTypeRequest) {
        return getSdkType(GetSdkTypeRequest.builder().applyMutation(getSdkTypeRequest).build());
    }

    /**
     * <p>
     * Gets SDK types
     * </p>
     *
     * @param getSdkTypesRequest
     *        Get the SdkTypes collection.
     * @return A Java Future containing the result of the GetSdkTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetSdkTypes
     */
    default CompletableFuture<GetSdkTypesResponse> getSdkTypes(GetSdkTypesRequest getSdkTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets SDK types
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSdkTypesRequest.Builder} avoiding the need to
     * create one manually via {@link GetSdkTypesRequest#builder()}
     * </p>
     *
     * @param getSdkTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetSdkTypesRequest.Builder} to create a request.
     *        Get the SdkTypes collection.
     * @return A Java Future containing the result of the GetSdkTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetSdkTypes
     */
    default CompletableFuture<GetSdkTypesResponse> getSdkTypes(Consumer<GetSdkTypesRequest.Builder> getSdkTypesRequest) {
        return getSdkTypes(GetSdkTypesRequest.builder().applyMutation(getSdkTypesRequest).build());
    }

    /**
     * <p>
     * Gets SDK types
     * </p>
     *
     * @return A Java Future containing the result of the GetSdkTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetSdkTypes
     */
    default CompletableFuture<GetSdkTypesResponse> getSdkTypes() {
        return getSdkTypes(GetSdkTypesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about a Stage resource.
     * </p>
     *
     * @param getStageRequest
     *        Requests API Gateway to get information about a Stage resource.
     * @return A Java Future containing the result of the GetStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetStage
     */
    default CompletableFuture<GetStageResponse> getStage(GetStageRequest getStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Stage resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStageRequest.Builder} avoiding the need to
     * create one manually via {@link GetStageRequest#builder()}
     * </p>
     *
     * @param getStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetStageRequest.Builder} to create a request.
     *        Requests API Gateway to get information about a Stage resource.
     * @return A Java Future containing the result of the GetStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetStage
     */
    default CompletableFuture<GetStageResponse> getStage(Consumer<GetStageRequest.Builder> getStageRequest) {
        return getStage(GetStageRequest.builder().applyMutation(getStageRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more Stage resources.
     * </p>
     *
     * @param getStagesRequest
     *        Requests API Gateway to get information about one or more Stage resources.
     * @return A Java Future containing the result of the GetStages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetStages
     */
    default CompletableFuture<GetStagesResponse> getStages(GetStagesRequest getStagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more Stage resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStagesRequest.Builder} avoiding the need to
     * create one manually via {@link GetStagesRequest#builder()}
     * </p>
     *
     * @param getStagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetStagesRequest.Builder} to create a request.
     *        Requests API Gateway to get information about one or more Stage resources.
     * @return A Java Future containing the result of the GetStages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetStages
     */
    default CompletableFuture<GetStagesResponse> getStages(Consumer<GetStagesRequest.Builder> getStagesRequest) {
        return getStages(GetStagesRequest.builder().applyMutation(getStagesRequest).build());
    }

    /**
     * <p>
     * Gets the Tags collection for a given resource.
     * </p>
     *
     * @param getTagsRequest
     *        Gets the Tags collection for a given resource.
     * @return A Java Future containing the result of the GetTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetTags
     */
    default CompletableFuture<GetTagsResponse> getTags(GetTagsRequest getTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Tags collection for a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTagsRequest.Builder} avoiding the need to create
     * one manually via {@link GetTagsRequest#builder()}
     * </p>
     *
     * @param getTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetTagsRequest.Builder} to create a request. Gets
     *        the Tags collection for a given resource.
     * @return A Java Future containing the result of the GetTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetTags
     */
    default CompletableFuture<GetTagsResponse> getTags(Consumer<GetTagsRequest.Builder> getTagsRequest) {
        return getTags(GetTagsRequest.builder().applyMutation(getTagsRequest).build());
    }

    /**
     * <p>
     * Gets the usage data of a usage plan in a specified time interval.
     * </p>
     *
     * @param getUsageRequest
     *        The GET request to get the usage data of a usage plan in a specified time interval.
     * @return A Java Future containing the result of the GetUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsage
     */
    default CompletableFuture<GetUsageResponse> getUsage(GetUsageRequest getUsageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the usage data of a usage plan in a specified time interval.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageRequest.Builder} avoiding the need to
     * create one manually via {@link GetUsageRequest#builder()}
     * </p>
     *
     * @param getUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetUsageRequest.Builder} to create a request. The
     *        GET request to get the usage data of a usage plan in a specified time interval.
     * @return A Java Future containing the result of the GetUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsage
     */
    default CompletableFuture<GetUsageResponse> getUsage(Consumer<GetUsageRequest.Builder> getUsageRequest) {
        return getUsage(GetUsageRequest.builder().applyMutation(getUsageRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getUsage(software.amazon.awssdk.services.apigateway.model.GetUsageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePublisher publisher = client.getUsagePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePublisher publisher = client.getUsagePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetUsageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetUsageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsage(software.amazon.awssdk.services.apigateway.model.GetUsageRequest)} operation.</b>
     * </p>
     *
     * @param getUsageRequest
     *        The GET request to get the usage data of a usage plan in a specified time interval.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsage
     */
    default GetUsagePublisher getUsagePaginator(GetUsageRequest getUsageRequest) {
        return new GetUsagePublisher(this, getUsageRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getUsage(software.amazon.awssdk.services.apigateway.model.GetUsageRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePublisher publisher = client.getUsagePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePublisher publisher = client.getUsagePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetUsageResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetUsageResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsage(software.amazon.awssdk.services.apigateway.model.GetUsageRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageRequest.Builder} avoiding the need to
     * create one manually via {@link GetUsageRequest#builder()}
     * </p>
     *
     * @param getUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetUsageRequest.Builder} to create a request. The
     *        GET request to get the usage data of a usage plan in a specified time interval.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsage
     */
    default GetUsagePublisher getUsagePaginator(Consumer<GetUsageRequest.Builder> getUsageRequest) {
        return getUsagePaginator(GetUsageRequest.builder().applyMutation(getUsageRequest).build());
    }

    /**
     * <p>
     * Gets a usage plan of a given plan identifier.
     * </p>
     *
     * @param getUsagePlanRequest
     *        The GET request to get a usage plan of a given plan identifier.
     * @return A Java Future containing the result of the GetUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlan
     */
    default CompletableFuture<GetUsagePlanResponse> getUsagePlan(GetUsagePlanRequest getUsagePlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a usage plan of a given plan identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsagePlanRequest.Builder} avoiding the need to
     * create one manually via {@link GetUsagePlanRequest#builder()}
     * </p>
     *
     * @param getUsagePlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetUsagePlanRequest.Builder} to create a request.
     *        The GET request to get a usage plan of a given plan identifier.
     * @return A Java Future containing the result of the GetUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlan
     */
    default CompletableFuture<GetUsagePlanResponse> getUsagePlan(Consumer<GetUsagePlanRequest.Builder> getUsagePlanRequest) {
        return getUsagePlan(GetUsagePlanRequest.builder().applyMutation(getUsagePlanRequest).build());
    }

    /**
     * <p>
     * Gets a usage plan key of a given key identifier.
     * </p>
     *
     * @param getUsagePlanKeyRequest
     *        The GET request to get a usage plan key of a given key identifier.
     * @return A Java Future containing the result of the GetUsagePlanKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlanKey
     */
    default CompletableFuture<GetUsagePlanKeyResponse> getUsagePlanKey(GetUsagePlanKeyRequest getUsagePlanKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a usage plan key of a given key identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsagePlanKeyRequest.Builder} avoiding the need
     * to create one manually via {@link GetUsagePlanKeyRequest#builder()}
     * </p>
     *
     * @param getUsagePlanKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeyRequest.Builder} to create a
     *        request. The GET request to get a usage plan key of a given key identifier.
     * @return A Java Future containing the result of the GetUsagePlanKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlanKey
     */
    default CompletableFuture<GetUsagePlanKeyResponse> getUsagePlanKey(
            Consumer<GetUsagePlanKeyRequest.Builder> getUsagePlanKeyRequest) {
        return getUsagePlanKey(GetUsagePlanKeyRequest.builder().applyMutation(getUsagePlanKeyRequest).build());
    }

    /**
     * <p>
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     * </p>
     *
     * @param getUsagePlanKeysRequest
     *        The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.
     * @return A Java Future containing the result of the GetUsagePlanKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlanKeys
     */
    default CompletableFuture<GetUsagePlanKeysResponse> getUsagePlanKeys(GetUsagePlanKeysRequest getUsagePlanKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all the usage plan keys representing the API keys added to a specified usage plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsagePlanKeysRequest.Builder} avoiding the need
     * to create one manually via {@link GetUsagePlanKeysRequest#builder()}
     * </p>
     *
     * @param getUsagePlanKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest.Builder} to create a
     *        request. The GET request to get all the usage plan keys representing the API keys added to a specified
     *        usage plan.
     * @return A Java Future containing the result of the GetUsagePlanKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlanKeys
     */
    default CompletableFuture<GetUsagePlanKeysResponse> getUsagePlanKeys(
            Consumer<GetUsagePlanKeysRequest.Builder> getUsagePlanKeysRequest) {
        return getUsagePlanKeys(GetUsagePlanKeysRequest.builder().applyMutation(getUsagePlanKeysRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getUsagePlanKeys(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysPublisher publisher = client.getUsagePlanKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysPublisher publisher = client.getUsagePlanKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsagePlanKeys(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUsagePlanKeysRequest
     *        The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlanKeys
     */
    default GetUsagePlanKeysPublisher getUsagePlanKeysPaginator(GetUsagePlanKeysRequest getUsagePlanKeysRequest) {
        return new GetUsagePlanKeysPublisher(this, getUsagePlanKeysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getUsagePlanKeys(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysPublisher publisher = client.getUsagePlanKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlanKeysPublisher publisher = client.getUsagePlanKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsagePlanKeys(software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsagePlanKeysRequest.Builder} avoiding the need
     * to create one manually via {@link GetUsagePlanKeysRequest#builder()}
     * </p>
     *
     * @param getUsagePlanKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest.Builder} to create a
     *        request. The GET request to get all the usage plan keys representing the API keys added to a specified
     *        usage plan.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlanKeys
     */
    default GetUsagePlanKeysPublisher getUsagePlanKeysPaginator(Consumer<GetUsagePlanKeysRequest.Builder> getUsagePlanKeysRequest) {
        return getUsagePlanKeysPaginator(GetUsagePlanKeysRequest.builder().applyMutation(getUsagePlanKeysRequest).build());
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     *
     * @param getUsagePlansRequest
     *        The GET request to get all the usage plans of the caller's account.
     * @return A Java Future containing the result of the GetUsagePlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlans
     */
    default CompletableFuture<GetUsagePlansResponse> getUsagePlans(GetUsagePlansRequest getUsagePlansRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsagePlansRequest.Builder} avoiding the need to
     * create one manually via {@link GetUsagePlansRequest#builder()}
     * </p>
     *
     * @param getUsagePlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest.Builder} to create a request.
     *        The GET request to get all the usage plans of the caller's account.
     * @return A Java Future containing the result of the GetUsagePlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlans
     */
    default CompletableFuture<GetUsagePlansResponse> getUsagePlans(Consumer<GetUsagePlansRequest.Builder> getUsagePlansRequest) {
        return getUsagePlans(GetUsagePlansRequest.builder().applyMutation(getUsagePlansRequest).build());
    }

    /**
     * <p>
     * Gets all the usage plans of the caller's account.
     * </p>
     *
     * @return A Java Future containing the result of the GetUsagePlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlans
     */
    default CompletableFuture<GetUsagePlansResponse> getUsagePlans() {
        return getUsagePlans(GetUsagePlansRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansPublisher publisher = client.getUsagePlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansPublisher publisher = client.getUsagePlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlans
     */
    default GetUsagePlansPublisher getUsagePlansPaginator() {
        return getUsagePlansPaginator(GetUsagePlansRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansPublisher publisher = client.getUsagePlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansPublisher publisher = client.getUsagePlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation.</b>
     * </p>
     *
     * @param getUsagePlansRequest
     *        The GET request to get all the usage plans of the caller's account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlans
     */
    default GetUsagePlansPublisher getUsagePlansPaginator(GetUsagePlansRequest getUsagePlansRequest) {
        return new GetUsagePlansPublisher(this, getUsagePlansRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansPublisher publisher = client.getUsagePlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetUsagePlansPublisher publisher = client.getUsagePlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetUsagePlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsagePlans(software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsagePlansRequest.Builder} avoiding the need to
     * create one manually via {@link GetUsagePlansRequest#builder()}
     * </p>
     *
     * @param getUsagePlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest.Builder} to create a request.
     *        The GET request to get all the usage plans of the caller's account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetUsagePlans
     */
    default GetUsagePlansPublisher getUsagePlansPaginator(Consumer<GetUsagePlansRequest.Builder> getUsagePlansRequest) {
        return getUsagePlansPaginator(GetUsagePlansRequest.builder().applyMutation(getUsagePlansRequest).build());
    }

    /**
     * <p>
     * Gets a specified VPC link under the caller's account in a region.
     * </p>
     *
     * @param getVpcLinkRequest
     *        Gets a specified VPC link under the caller's account in a region.
     * @return A Java Future containing the result of the GetVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetVpcLink
     */
    default CompletableFuture<GetVpcLinkResponse> getVpcLink(GetVpcLinkRequest getVpcLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a specified VPC link under the caller's account in a region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link GetVpcLinkRequest#builder()}
     * </p>
     *
     * @param getVpcLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetVpcLinkRequest.Builder} to create a request.
     *        Gets a specified VPC link under the caller's account in a region.
     * @return A Java Future containing the result of the GetVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetVpcLink
     */
    default CompletableFuture<GetVpcLinkResponse> getVpcLink(Consumer<GetVpcLinkRequest.Builder> getVpcLinkRequest) {
        return getVpcLink(GetVpcLinkRequest.builder().applyMutation(getVpcLinkRequest).build());
    }

    /**
     * <p>
     * Gets the VpcLinks collection under the caller's account in a selected region.
     * </p>
     *
     * @param getVpcLinksRequest
     *        Gets the VpcLinks collection under the caller's account in a selected region.
     * @return A Java Future containing the result of the GetVpcLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetVpcLinks
     */
    default CompletableFuture<GetVpcLinksResponse> getVpcLinks(GetVpcLinksRequest getVpcLinksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the VpcLinks collection under the caller's account in a selected region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVpcLinksRequest.Builder} avoiding the need to
     * create one manually via {@link GetVpcLinksRequest#builder()}
     * </p>
     *
     * @param getVpcLinksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest.Builder} to create a request.
     *        Gets the VpcLinks collection under the caller's account in a selected region.
     * @return A Java Future containing the result of the GetVpcLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetVpcLinks
     */
    default CompletableFuture<GetVpcLinksResponse> getVpcLinks(Consumer<GetVpcLinksRequest.Builder> getVpcLinksRequest) {
        return getVpcLinks(GetVpcLinksRequest.builder().applyMutation(getVpcLinksRequest).build());
    }

    /**
     * <p>
     * Gets the VpcLinks collection under the caller's account in a selected region.
     * </p>
     *
     * @return A Java Future containing the result of the GetVpcLinks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetVpcLinks
     */
    default CompletableFuture<GetVpcLinksResponse> getVpcLinks() {
        return getVpcLinks(GetVpcLinksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksPublisher publisher = client.getVpcLinksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksPublisher publisher = client.getVpcLinksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetVpcLinks
     */
    default GetVpcLinksPublisher getVpcLinksPaginator() {
        return getVpcLinksPaginator(GetVpcLinksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksPublisher publisher = client.getVpcLinksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksPublisher publisher = client.getVpcLinksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)} operation.</b>
     * </p>
     *
     * @param getVpcLinksRequest
     *        Gets the VpcLinks collection under the caller's account in a selected region.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetVpcLinks
     */
    default GetVpcLinksPublisher getVpcLinksPaginator(GetVpcLinksRequest getVpcLinksRequest) {
        return new GetVpcLinksPublisher(this, getVpcLinksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksPublisher publisher = client.getVpcLinksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apigateway.paginators.GetVpcLinksPublisher publisher = client.getVpcLinksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apigateway.model.GetVpcLinksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVpcLinks(software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVpcLinksRequest.Builder} avoiding the need to
     * create one manually via {@link GetVpcLinksRequest#builder()}
     * </p>
     *
     * @param getVpcLinksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.GetVpcLinksRequest.Builder} to create a request.
     *        Gets the VpcLinks collection under the caller's account in a selected region.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.GetVpcLinks
     */
    default GetVpcLinksPublisher getVpcLinksPaginator(Consumer<GetVpcLinksRequest.Builder> getVpcLinksRequest) {
        return getVpcLinksPaginator(GetVpcLinksRequest.builder().applyMutation(getVpcLinksRequest).build());
    }

    /**
     * <p>
     * Import API keys from an external source, such as a CSV-formatted file.
     * </p>
     *
     * @param importApiKeysRequest
     *        The POST request to import API keys from an external source, such as a CSV-formatted file.
     * @return A Java Future containing the result of the ImportApiKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.ImportApiKeys
     */
    default CompletableFuture<ImportApiKeysResponse> importApiKeys(ImportApiKeysRequest importApiKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Import API keys from an external source, such as a CSV-formatted file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportApiKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ImportApiKeysRequest#builder()}
     * </p>
     *
     * @param importApiKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.ImportApiKeysRequest.Builder} to create a request.
     *        The POST request to import API keys from an external source, such as a CSV-formatted file.
     * @return A Java Future containing the result of the ImportApiKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.ImportApiKeys
     */
    default CompletableFuture<ImportApiKeysResponse> importApiKeys(Consumer<ImportApiKeysRequest.Builder> importApiKeysRequest) {
        return importApiKeys(ImportApiKeysRequest.builder().applyMutation(importApiKeysRequest).build());
    }

    /**
     * <p>
     * Imports documentation parts
     * </p>
     *
     * @param importDocumentationPartsRequest
     *        Import documentation parts from an external (e.g., OpenAPI) definition file.
     * @return A Java Future containing the result of the ImportDocumentationParts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.ImportDocumentationParts
     */
    default CompletableFuture<ImportDocumentationPartsResponse> importDocumentationParts(
            ImportDocumentationPartsRequest importDocumentationPartsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports documentation parts
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportDocumentationPartsRequest.Builder} avoiding
     * the need to create one manually via {@link ImportDocumentationPartsRequest#builder()}
     * </p>
     *
     * @param importDocumentationPartsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.ImportDocumentationPartsRequest.Builder} to create
     *        a request. Import documentation parts from an external (e.g., OpenAPI) definition file.
     * @return A Java Future containing the result of the ImportDocumentationParts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.ImportDocumentationParts
     */
    default CompletableFuture<ImportDocumentationPartsResponse> importDocumentationParts(
            Consumer<ImportDocumentationPartsRequest.Builder> importDocumentationPartsRequest) {
        return importDocumentationParts(ImportDocumentationPartsRequest.builder().applyMutation(importDocumentationPartsRequest)
                .build());
    }

    /**
     * <p>
     * A feature of the API Gateway control service for creating a new API from an external API definition file.
     * </p>
     *
     * @param importRestApiRequest
     *        A POST request to import an API to API Gateway using an input of an API definition file.
     * @return A Java Future containing the result of the ImportRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.ImportRestApi
     */
    default CompletableFuture<ImportRestApiResponse> importRestApi(ImportRestApiRequest importRestApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A feature of the API Gateway control service for creating a new API from an external API definition file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportRestApiRequest.Builder} avoiding the need to
     * create one manually via {@link ImportRestApiRequest#builder()}
     * </p>
     *
     * @param importRestApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest.Builder} to create a request.
     *        A POST request to import an API to API Gateway using an input of an API definition file.
     * @return A Java Future containing the result of the ImportRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.ImportRestApi
     */
    default CompletableFuture<ImportRestApiResponse> importRestApi(Consumer<ImportRestApiRequest.Builder> importRestApiRequest) {
        return importRestApi(ImportRestApiRequest.builder().applyMutation(importRestApiRequest).build());
    }

    /**
     * <p>
     * Creates a customization of a GatewayResponse of a specified response type and status code on the given RestApi.
     * </p>
     *
     * @param putGatewayResponseRequest
     *        Creates a customization of a GatewayResponse of a specified response type and status code on the given
     *        RestApi.
     * @return A Java Future containing the result of the PutGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutGatewayResponse
     */
    default CompletableFuture<PutGatewayResponseResponse> putGatewayResponse(PutGatewayResponseRequest putGatewayResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a customization of a GatewayResponse of a specified response type and status code on the given RestApi.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutGatewayResponseRequest.Builder} avoiding the
     * need to create one manually via {@link PutGatewayResponseRequest#builder()}
     * </p>
     *
     * @param putGatewayResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.PutGatewayResponseRequest.Builder} to create a
     *        request. Creates a customization of a GatewayResponse of a specified response type and status code on the
     *        given RestApi.
     * @return A Java Future containing the result of the PutGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutGatewayResponse
     */
    default CompletableFuture<PutGatewayResponseResponse> putGatewayResponse(
            Consumer<PutGatewayResponseRequest.Builder> putGatewayResponseRequest) {
        return putGatewayResponse(PutGatewayResponseRequest.builder().applyMutation(putGatewayResponseRequest).build());
    }

    /**
     * <p>
     * Sets up a method's integration.
     * </p>
     *
     * @param putIntegrationRequest
     *        Sets up a method's integration.
     * @return A Java Future containing the result of the PutIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutIntegration
     */
    default CompletableFuture<PutIntegrationResponse> putIntegration(PutIntegrationRequest putIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets up a method's integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutIntegrationRequest.Builder} avoiding the need to
     * create one manually via {@link PutIntegrationRequest#builder()}
     * </p>
     *
     * @param putIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest.Builder} to create a
     *        request. Sets up a method's integration.
     * @return A Java Future containing the result of the PutIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutIntegration
     */
    default CompletableFuture<PutIntegrationResponse> putIntegration(Consumer<PutIntegrationRequest.Builder> putIntegrationRequest) {
        return putIntegration(PutIntegrationRequest.builder().applyMutation(putIntegrationRequest).build());
    }

    /**
     * <p>
     * Represents a put integration.
     * </p>
     *
     * @param putIntegrationResponseRequest
     *        Represents a put integration response request.
     * @return A Java Future containing the result of the PutIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutIntegrationResponse
     */
    default CompletableFuture<PutIntegrationResponseResponse> putIntegrationResponse(
            PutIntegrationResponseRequest putIntegrationResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents a put integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutIntegrationResponseRequest.Builder} avoiding the
     * need to create one manually via {@link PutIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param putIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest.Builder} to create a
     *        request. Represents a put integration response request.
     * @return A Java Future containing the result of the PutIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutIntegrationResponse
     */
    default CompletableFuture<PutIntegrationResponseResponse> putIntegrationResponse(
            Consumer<PutIntegrationResponseRequest.Builder> putIntegrationResponseRequest) {
        return putIntegrationResponse(PutIntegrationResponseRequest.builder().applyMutation(putIntegrationResponseRequest)
                .build());
    }

    /**
     * <p>
     * Add a method to an existing Resource resource.
     * </p>
     *
     * @param putMethodRequest
     *        Request to add a method to an existing Resource resource.
     * @return A Java Future containing the result of the PutMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutMethod
     */
    default CompletableFuture<PutMethodResponse> putMethod(PutMethodRequest putMethodRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add a method to an existing Resource resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMethodRequest.Builder} avoiding the need to
     * create one manually via {@link PutMethodRequest#builder()}
     * </p>
     *
     * @param putMethodRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.PutMethodRequest.Builder} to create a request.
     *        Request to add a method to an existing Resource resource.
     * @return A Java Future containing the result of the PutMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutMethod
     */
    default CompletableFuture<PutMethodResponse> putMethod(Consumer<PutMethodRequest.Builder> putMethodRequest) {
        return putMethod(PutMethodRequest.builder().applyMutation(putMethodRequest).build());
    }

    /**
     * <p>
     * Adds a MethodResponse to an existing Method resource.
     * </p>
     *
     * @param putMethodResponseRequest
     *        Request to add a MethodResponse to an existing Method resource.
     * @return A Java Future containing the result of the PutMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutMethodResponse
     */
    default CompletableFuture<PutMethodResponseResponse> putMethodResponse(PutMethodResponseRequest putMethodResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a MethodResponse to an existing Method resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMethodResponseRequest.Builder} avoiding the need
     * to create one manually via {@link PutMethodResponseRequest#builder()}
     * </p>
     *
     * @param putMethodResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest.Builder} to create a
     *        request. Request to add a MethodResponse to an existing Method resource.
     * @return A Java Future containing the result of the PutMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutMethodResponse
     */
    default CompletableFuture<PutMethodResponseResponse> putMethodResponse(
            Consumer<PutMethodResponseRequest.Builder> putMethodResponseRequest) {
        return putMethodResponse(PutMethodResponseRequest.builder().applyMutation(putMethodResponseRequest).build());
    }

    /**
     * <p>
     * A feature of the API Gateway control service for updating an existing API with an input of external API
     * definitions. The update can take the form of merging the supplied definition into the existing API or overwriting
     * the existing API.
     * </p>
     *
     * @param putRestApiRequest
     *        A PUT request to update an existing API, with external API definitions specified as the request body.
     * @return A Java Future containing the result of the PutRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutRestApi
     */
    default CompletableFuture<PutRestApiResponse> putRestApi(PutRestApiRequest putRestApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A feature of the API Gateway control service for updating an existing API with an input of external API
     * definitions. The update can take the form of merging the supplied definition into the existing API or overwriting
     * the existing API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRestApiRequest.Builder} avoiding the need to
     * create one manually via {@link PutRestApiRequest#builder()}
     * </p>
     *
     * @param putRestApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.PutRestApiRequest.Builder} to create a request. A
     *        PUT request to update an existing API, with external API definitions specified as the request body.
     * @return A Java Future containing the result of the PutRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.PutRestApi
     */
    default CompletableFuture<PutRestApiResponse> putRestApi(Consumer<PutRestApiRequest.Builder> putRestApiRequest) {
        return putRestApi(PutRestApiRequest.builder().applyMutation(putRestApiRequest).build());
    }

    /**
     * <p>
     * Adds or updates a tag on a given resource.
     * </p>
     *
     * @param tagResourceRequest
     *        Adds or updates a tag on a given resource.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.TagResource
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates a tag on a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.TagResourceRequest.Builder} to create a request.
     *        Adds or updates a tag on a given resource.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.TagResource
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Simulate the execution of an Authorizer in your RestApi with headers, parameters, and an incoming request body.
     * </p>
     *
     * @param testInvokeAuthorizerRequest
     *        Make a request to simulate the invocation of an Authorizer.
     * @return A Java Future containing the result of the TestInvokeAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.TestInvokeAuthorizer
     */
    default CompletableFuture<TestInvokeAuthorizerResponse> testInvokeAuthorizer(
            TestInvokeAuthorizerRequest testInvokeAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Simulate the execution of an Authorizer in your RestApi with headers, parameters, and an incoming request body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestInvokeAuthorizerRequest.Builder} avoiding the
     * need to create one manually via {@link TestInvokeAuthorizerRequest#builder()}
     * </p>
     *
     * @param testInvokeAuthorizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest.Builder} to create a
     *        request. Make a request to simulate the invocation of an Authorizer.
     * @return A Java Future containing the result of the TestInvokeAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.TestInvokeAuthorizer
     */
    default CompletableFuture<TestInvokeAuthorizerResponse> testInvokeAuthorizer(
            Consumer<TestInvokeAuthorizerRequest.Builder> testInvokeAuthorizerRequest) {
        return testInvokeAuthorizer(TestInvokeAuthorizerRequest.builder().applyMutation(testInvokeAuthorizerRequest).build());
    }

    /**
     * <p>
     * Simulate the invocation of a Method in your RestApi with headers, parameters, and an incoming request body.
     * </p>
     *
     * @param testInvokeMethodRequest
     *        Make a request to simulate the invocation of a Method.
     * @return A Java Future containing the result of the TestInvokeMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.TestInvokeMethod
     */
    default CompletableFuture<TestInvokeMethodResponse> testInvokeMethod(TestInvokeMethodRequest testInvokeMethodRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Simulate the invocation of a Method in your RestApi with headers, parameters, and an incoming request body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestInvokeMethodRequest.Builder} avoiding the need
     * to create one manually via {@link TestInvokeMethodRequest#builder()}
     * </p>
     *
     * @param testInvokeMethodRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest.Builder} to create a
     *        request. Make a request to simulate the invocation of a Method.
     * @return A Java Future containing the result of the TestInvokeMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.TestInvokeMethod
     */
    default CompletableFuture<TestInvokeMethodResponse> testInvokeMethod(
            Consumer<TestInvokeMethodRequest.Builder> testInvokeMethodRequest) {
        return testInvokeMethod(TestInvokeMethodRequest.builder().applyMutation(testInvokeMethodRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a given resource.
     * </p>
     *
     * @param untagResourceRequest
     *        Removes a tag from a given resource.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UntagResource
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UntagResourceRequest.Builder} to create a request.
     *        Removes a tag from a given resource.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UntagResource
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Changes information about the current Account resource.
     * </p>
     *
     * @param updateAccountRequest
     *        Requests API Gateway to change information about the current Account resource.
     * @return A Java Future containing the result of the UpdateAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateAccount
     */
    default CompletableFuture<UpdateAccountResponse> updateAccount(UpdateAccountRequest updateAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about the current Account resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAccountRequest#builder()}
     * </p>
     *
     * @param updateAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateAccountRequest.Builder} to create a request.
     *        Requests API Gateway to change information about the current Account resource.
     * @return A Java Future containing the result of the UpdateAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateAccount
     */
    default CompletableFuture<UpdateAccountResponse> updateAccount(Consumer<UpdateAccountRequest.Builder> updateAccountRequest) {
        return updateAccount(UpdateAccountRequest.builder().applyMutation(updateAccountRequest).build());
    }

    /**
     * <p>
     * Changes information about an ApiKey resource.
     * </p>
     *
     * @param updateApiKeyRequest
     *        A request to change information about an ApiKey resource.
     * @return A Java Future containing the result of the UpdateApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateApiKey
     */
    default CompletableFuture<UpdateApiKeyResponse> updateApiKey(UpdateApiKeyRequest updateApiKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about an ApiKey resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateApiKeyRequest#builder()}
     * </p>
     *
     * @param updateApiKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateApiKeyRequest.Builder} to create a request.
     *        A request to change information about an ApiKey resource.
     * @return A Java Future containing the result of the UpdateApiKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateApiKey
     */
    default CompletableFuture<UpdateApiKeyResponse> updateApiKey(Consumer<UpdateApiKeyRequest.Builder> updateApiKeyRequest) {
        return updateApiKey(UpdateApiKeyRequest.builder().applyMutation(updateApiKeyRequest).build());
    }

    /**
     * <p>
     * Updates an existing Authorizer resource.
     * </p>
     *
     * @param updateAuthorizerRequest
     *        Request to update an existing Authorizer resource.
     * @return A Java Future containing the result of the UpdateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateAuthorizer
     */
    default CompletableFuture<UpdateAuthorizerResponse> updateAuthorizer(UpdateAuthorizerRequest updateAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Authorizer resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAuthorizerRequest#builder()}
     * </p>
     *
     * @param updateAuthorizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerRequest.Builder} to create a
     *        request. Request to update an existing Authorizer resource.
     * @return A Java Future containing the result of the UpdateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateAuthorizer
     */
    default CompletableFuture<UpdateAuthorizerResponse> updateAuthorizer(
            Consumer<UpdateAuthorizerRequest.Builder> updateAuthorizerRequest) {
        return updateAuthorizer(UpdateAuthorizerRequest.builder().applyMutation(updateAuthorizerRequest).build());
    }

    /**
     * <p>
     * Changes information about the BasePathMapping resource.
     * </p>
     *
     * @param updateBasePathMappingRequest
     *        A request to change information about the BasePathMapping resource.
     * @return A Java Future containing the result of the UpdateBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateBasePathMapping
     */
    default CompletableFuture<UpdateBasePathMappingResponse> updateBasePathMapping(
            UpdateBasePathMappingRequest updateBasePathMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about the BasePathMapping resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBasePathMappingRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBasePathMappingRequest#builder()}
     * </p>
     *
     * @param updateBasePathMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingRequest.Builder} to create a
     *        request. A request to change information about the BasePathMapping resource.
     * @return A Java Future containing the result of the UpdateBasePathMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateBasePathMapping
     */
    default CompletableFuture<UpdateBasePathMappingResponse> updateBasePathMapping(
            Consumer<UpdateBasePathMappingRequest.Builder> updateBasePathMappingRequest) {
        return updateBasePathMapping(UpdateBasePathMappingRequest.builder().applyMutation(updateBasePathMappingRequest).build());
    }

    /**
     * <p>
     * Changes information about an ClientCertificate resource.
     * </p>
     *
     * @param updateClientCertificateRequest
     *        A request to change information about an ClientCertificate resource.
     * @return A Java Future containing the result of the UpdateClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateClientCertificate
     */
    default CompletableFuture<UpdateClientCertificateResponse> updateClientCertificate(
            UpdateClientCertificateRequest updateClientCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about an ClientCertificate resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClientCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateClientCertificateRequest#builder()}
     * </p>
     *
     * @param updateClientCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateRequest.Builder} to create
     *        a request. A request to change information about an ClientCertificate resource.
     * @return A Java Future containing the result of the UpdateClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateClientCertificate
     */
    default CompletableFuture<UpdateClientCertificateResponse> updateClientCertificate(
            Consumer<UpdateClientCertificateRequest.Builder> updateClientCertificateRequest) {
        return updateClientCertificate(UpdateClientCertificateRequest.builder().applyMutation(updateClientCertificateRequest)
                .build());
    }

    /**
     * <p>
     * Changes information about a Deployment resource.
     * </p>
     *
     * @param updateDeploymentRequest
     *        Requests API Gateway to change information about a Deployment resource.
     * @return A Java Future containing the result of the UpdateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDeployment
     */
    default CompletableFuture<UpdateDeploymentResponse> updateDeployment(UpdateDeploymentRequest updateDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about a Deployment resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDeploymentRequest#builder()}
     * </p>
     *
     * @param updateDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateDeploymentRequest.Builder} to create a
     *        request. Requests API Gateway to change information about a Deployment resource.
     * @return A Java Future containing the result of the UpdateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>ServiceUnavailableException The requested service is not available. For details see the accompanying
     *         error message. Retry after the specified time period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDeployment
     */
    default CompletableFuture<UpdateDeploymentResponse> updateDeployment(
            Consumer<UpdateDeploymentRequest.Builder> updateDeploymentRequest) {
        return updateDeployment(UpdateDeploymentRequest.builder().applyMutation(updateDeploymentRequest).build());
    }

    /**
     * <p>
     * Updates a documentation part.
     * </p>
     *
     * @param updateDocumentationPartRequest
     *        Updates an existing documentation part of a given API.
     * @return A Java Future containing the result of the UpdateDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDocumentationPart
     */
    default CompletableFuture<UpdateDocumentationPartResponse> updateDocumentationPart(
            UpdateDocumentationPartRequest updateDocumentationPartRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a documentation part.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDocumentationPartRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDocumentationPartRequest#builder()}
     * </p>
     *
     * @param updateDocumentationPartRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartRequest.Builder} to create
     *        a request. Updates an existing documentation part of a given API.
     * @return A Java Future containing the result of the UpdateDocumentationPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDocumentationPart
     */
    default CompletableFuture<UpdateDocumentationPartResponse> updateDocumentationPart(
            Consumer<UpdateDocumentationPartRequest.Builder> updateDocumentationPartRequest) {
        return updateDocumentationPart(UpdateDocumentationPartRequest.builder().applyMutation(updateDocumentationPartRequest)
                .build());
    }

    /**
     * <p>
     * Updates a documentation version.
     * </p>
     *
     * @param updateDocumentationVersionRequest
     *        Updates an existing documentation version of an API.
     * @return A Java Future containing the result of the UpdateDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDocumentationVersion
     */
    default CompletableFuture<UpdateDocumentationVersionResponse> updateDocumentationVersion(
            UpdateDocumentationVersionRequest updateDocumentationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a documentation version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDocumentationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDocumentationVersionRequest#builder()}
     * </p>
     *
     * @param updateDocumentationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateDocumentationVersionRequest.Builder} to
     *        create a request. Updates an existing documentation version of an API.
     * @return A Java Future containing the result of the UpdateDocumentationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDocumentationVersion
     */
    default CompletableFuture<UpdateDocumentationVersionResponse> updateDocumentationVersion(
            Consumer<UpdateDocumentationVersionRequest.Builder> updateDocumentationVersionRequest) {
        return updateDocumentationVersion(UpdateDocumentationVersionRequest.builder()
                .applyMutation(updateDocumentationVersionRequest).build());
    }

    /**
     * <p>
     * Changes information about the DomainName resource.
     * </p>
     *
     * @param updateDomainNameRequest
     *        A request to change information about the DomainName resource.
     * @return A Java Future containing the result of the UpdateDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDomainName
     */
    default CompletableFuture<UpdateDomainNameResponse> updateDomainName(UpdateDomainNameRequest updateDomainNameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about the DomainName resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDomainNameRequest#builder()}
     * </p>
     *
     * @param updateDomainNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateDomainNameRequest.Builder} to create a
     *        request. A request to change information about the DomainName resource.
     * @return A Java Future containing the result of the UpdateDomainName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateDomainName
     */
    default CompletableFuture<UpdateDomainNameResponse> updateDomainName(
            Consumer<UpdateDomainNameRequest.Builder> updateDomainNameRequest) {
        return updateDomainName(UpdateDomainNameRequest.builder().applyMutation(updateDomainNameRequest).build());
    }

    /**
     * <p>
     * Updates a GatewayResponse of a specified response type on the given RestApi.
     * </p>
     *
     * @param updateGatewayResponseRequest
     *        Updates a GatewayResponse of a specified response type on the given RestApi.
     * @return A Java Future containing the result of the UpdateGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateGatewayResponse
     */
    default CompletableFuture<UpdateGatewayResponseResponse> updateGatewayResponse(
            UpdateGatewayResponseRequest updateGatewayResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a GatewayResponse of a specified response type on the given RestApi.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayResponseRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGatewayResponseRequest#builder()}
     * </p>
     *
     * @param updateGatewayResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseRequest.Builder} to create a
     *        request. Updates a GatewayResponse of a specified response type on the given RestApi.
     * @return A Java Future containing the result of the UpdateGatewayResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateGatewayResponse
     */
    default CompletableFuture<UpdateGatewayResponseResponse> updateGatewayResponse(
            Consumer<UpdateGatewayResponseRequest.Builder> updateGatewayResponseRequest) {
        return updateGatewayResponse(UpdateGatewayResponseRequest.builder().applyMutation(updateGatewayResponseRequest).build());
    }

    /**
     * <p>
     * Represents an update integration.
     * </p>
     *
     * @param updateIntegrationRequest
     *        Represents an update integration request.
     * @return A Java Future containing the result of the UpdateIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateIntegration
     */
    default CompletableFuture<UpdateIntegrationResponse> updateIntegration(UpdateIntegrationRequest updateIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents an update integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateIntegrationRequest#builder()}
     * </p>
     *
     * @param updateIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateIntegrationRequest.Builder} to create a
     *        request. Represents an update integration request.
     * @return A Java Future containing the result of the UpdateIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateIntegration
     */
    default CompletableFuture<UpdateIntegrationResponse> updateIntegration(
            Consumer<UpdateIntegrationRequest.Builder> updateIntegrationRequest) {
        return updateIntegration(UpdateIntegrationRequest.builder().applyMutation(updateIntegrationRequest).build());
    }

    /**
     * <p>
     * Represents an update integration response.
     * </p>
     *
     * @param updateIntegrationResponseRequest
     *        Represents an update integration response request.
     * @return A Java Future containing the result of the UpdateIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateIntegrationResponse
     */
    default CompletableFuture<UpdateIntegrationResponseResponse> updateIntegrationResponse(
            UpdateIntegrationResponseRequest updateIntegrationResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Represents an update integration response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIntegrationResponseRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateIntegrationResponseRequest#builder()}
     * </p>
     *
     * @param updateIntegrationResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseRequest.Builder} to
     *        create a request. Represents an update integration response request.
     * @return A Java Future containing the result of the UpdateIntegrationResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateIntegrationResponse
     */
    default CompletableFuture<UpdateIntegrationResponseResponse> updateIntegrationResponse(
            Consumer<UpdateIntegrationResponseRequest.Builder> updateIntegrationResponseRequest) {
        return updateIntegrationResponse(UpdateIntegrationResponseRequest.builder()
                .applyMutation(updateIntegrationResponseRequest).build());
    }

    /**
     * <p>
     * Updates an existing Method resource.
     * </p>
     *
     * @param updateMethodRequest
     *        Request to update an existing Method resource.
     * @return A Java Future containing the result of the UpdateMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateMethod
     */
    default CompletableFuture<UpdateMethodResponse> updateMethod(UpdateMethodRequest updateMethodRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Method resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMethodRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMethodRequest#builder()}
     * </p>
     *
     * @param updateMethodRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateMethodRequest.Builder} to create a request.
     *        Request to update an existing Method resource.
     * @return A Java Future containing the result of the UpdateMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateMethod
     */
    default CompletableFuture<UpdateMethodResponse> updateMethod(Consumer<UpdateMethodRequest.Builder> updateMethodRequest) {
        return updateMethod(UpdateMethodRequest.builder().applyMutation(updateMethodRequest).build());
    }

    /**
     * <p>
     * Updates an existing MethodResponse resource.
     * </p>
     *
     * @param updateMethodResponseRequest
     *        A request to update an existing MethodResponse resource.
     * @return A Java Future containing the result of the UpdateMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateMethodResponse
     */
    default CompletableFuture<UpdateMethodResponseResponse> updateMethodResponse(
            UpdateMethodResponseRequest updateMethodResponseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing MethodResponse resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMethodResponseRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMethodResponseRequest#builder()}
     * </p>
     *
     * @param updateMethodResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateMethodResponseRequest.Builder} to create a
     *        request. A request to update an existing MethodResponse resource.
     * @return A Java Future containing the result of the UpdateMethodResponse operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateMethodResponse
     */
    default CompletableFuture<UpdateMethodResponseResponse> updateMethodResponse(
            Consumer<UpdateMethodResponseRequest.Builder> updateMethodResponseRequest) {
        return updateMethodResponse(UpdateMethodResponseRequest.builder().applyMutation(updateMethodResponseRequest).build());
    }

    /**
     * <p>
     * Changes information about a model. The maximum size of the model is 400 KB.
     * </p>
     *
     * @param updateModelRequest
     *        Request to update an existing model in an existing RestApi resource.
     * @return A Java Future containing the result of the UpdateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateModel
     */
    default CompletableFuture<UpdateModelResponse> updateModel(UpdateModelRequest updateModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about a model. The maximum size of the model is 400 KB.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateModelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateModelRequest#builder()}
     * </p>
     *
     * @param updateModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateModelRequest.Builder} to create a request.
     *        Request to update an existing model in an existing RestApi resource.
     * @return A Java Future containing the result of the UpdateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateModel
     */
    default CompletableFuture<UpdateModelResponse> updateModel(Consumer<UpdateModelRequest.Builder> updateModelRequest) {
        return updateModel(UpdateModelRequest.builder().applyMutation(updateModelRequest).build());
    }

    /**
     * <p>
     * Updates a RequestValidator of a given RestApi.
     * </p>
     *
     * @param updateRequestValidatorRequest
     *        Updates a RequestValidator of a given RestApi.
     * @return A Java Future containing the result of the UpdateRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateRequestValidator
     */
    default CompletableFuture<UpdateRequestValidatorResponse> updateRequestValidator(
            UpdateRequestValidatorRequest updateRequestValidatorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a RequestValidator of a given RestApi.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRequestValidatorRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRequestValidatorRequest#builder()}
     * </p>
     *
     * @param updateRequestValidatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateRequestValidatorRequest.Builder} to create a
     *        request. Updates a RequestValidator of a given RestApi.
     * @return A Java Future containing the result of the UpdateRequestValidator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateRequestValidator
     */
    default CompletableFuture<UpdateRequestValidatorResponse> updateRequestValidator(
            Consumer<UpdateRequestValidatorRequest.Builder> updateRequestValidatorRequest) {
        return updateRequestValidator(UpdateRequestValidatorRequest.builder().applyMutation(updateRequestValidatorRequest)
                .build());
    }

    /**
     * <p>
     * Changes information about a Resource resource.
     * </p>
     *
     * @param updateResourceRequest
     *        Request to change information about a Resource resource.
     * @return A Java Future containing the result of the UpdateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateResource
     */
    default CompletableFuture<UpdateResourceResponse> updateResource(UpdateResourceRequest updateResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about a Resource resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateResourceRequest#builder()}
     * </p>
     *
     * @param updateResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateResourceRequest.Builder} to create a
     *        request. Request to change information about a Resource resource.
     * @return A Java Future containing the result of the UpdateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateResource
     */
    default CompletableFuture<UpdateResourceResponse> updateResource(Consumer<UpdateResourceRequest.Builder> updateResourceRequest) {
        return updateResource(UpdateResourceRequest.builder().applyMutation(updateResourceRequest).build());
    }

    /**
     * <p>
     * Changes information about the specified API.
     * </p>
     *
     * @param updateRestApiRequest
     *        Request to update an existing RestApi resource in your collection.
     * @return A Java Future containing the result of the UpdateRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateRestApi
     */
    default CompletableFuture<UpdateRestApiResponse> updateRestApi(UpdateRestApiRequest updateRestApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about the specified API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRestApiRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRestApiRequest#builder()}
     * </p>
     *
     * @param updateRestApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateRestApiRequest.Builder} to create a request.
     *        Request to update an existing RestApi resource in your collection.
     * @return A Java Future containing the result of the UpdateRestApi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateRestApi
     */
    default CompletableFuture<UpdateRestApiResponse> updateRestApi(Consumer<UpdateRestApiRequest.Builder> updateRestApiRequest) {
        return updateRestApi(UpdateRestApiRequest.builder().applyMutation(updateRestApiRequest).build());
    }

    /**
     * <p>
     * Changes information about a Stage resource.
     * </p>
     *
     * @param updateStageRequest
     *        Requests API Gateway to change information about a Stage resource.
     * @return A Java Future containing the result of the UpdateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateStage
     */
    default CompletableFuture<UpdateStageResponse> updateStage(UpdateStageRequest updateStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes information about a Stage resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStageRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStageRequest#builder()}
     * </p>
     *
     * @param updateStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateStageRequest.Builder} to create a request.
     *        Requests API Gateway to change information about a Stage resource.
     * @return A Java Future containing the result of the UpdateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateStage
     */
    default CompletableFuture<UpdateStageResponse> updateStage(Consumer<UpdateStageRequest.Builder> updateStageRequest) {
        return updateStage(UpdateStageRequest.builder().applyMutation(updateStageRequest).build());
    }

    /**
     * <p>
     * Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.
     * </p>
     *
     * @param updateUsageRequest
     *        The PATCH request to grant a temporary extension to the remaining quota of a usage plan associated with a
     *        specified API key.
     * @return A Java Future containing the result of the UpdateUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateUsage
     */
    default CompletableFuture<UpdateUsageResponse> updateUsage(UpdateUsageRequest updateUsageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUsageRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUsageRequest#builder()}
     * </p>
     *
     * @param updateUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateUsageRequest.Builder} to create a request.
     *        The PATCH request to grant a temporary extension to the remaining quota of a usage plan associated with a
     *        specified API key.
     * @return A Java Future containing the result of the UpdateUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateUsage
     */
    default CompletableFuture<UpdateUsageResponse> updateUsage(Consumer<UpdateUsageRequest.Builder> updateUsageRequest) {
        return updateUsage(UpdateUsageRequest.builder().applyMutation(updateUsageRequest).build());
    }

    /**
     * <p>
     * Updates a usage plan of a given plan Id.
     * </p>
     *
     * @param updateUsagePlanRequest
     *        The PATCH request to update a usage plan of a given plan Id.
     * @return A Java Future containing the result of the UpdateUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateUsagePlan
     */
    default CompletableFuture<UpdateUsagePlanResponse> updateUsagePlan(UpdateUsagePlanRequest updateUsagePlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a usage plan of a given plan Id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUsagePlanRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateUsagePlanRequest#builder()}
     * </p>
     *
     * @param updateUsagePlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateUsagePlanRequest.Builder} to create a
     *        request. The PATCH request to update a usage plan of a given plan Id.
     * @return A Java Future containing the result of the UpdateUsagePlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateUsagePlan
     */
    default CompletableFuture<UpdateUsagePlanResponse> updateUsagePlan(
            Consumer<UpdateUsagePlanRequest.Builder> updateUsagePlanRequest) {
        return updateUsagePlan(UpdateUsagePlanRequest.builder().applyMutation(updateUsagePlanRequest).build());
    }

    /**
     * <p>
     * Updates an existing VpcLink of a specified identifier.
     * </p>
     *
     * @param updateVpcLinkRequest
     *        Updates an existing VpcLink of a specified identifier.
     * @return A Java Future containing the result of the UpdateVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateVpcLink
     */
    default CompletableFuture<UpdateVpcLinkResponse> updateVpcLink(UpdateVpcLinkRequest updateVpcLinkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing VpcLink of a specified identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVpcLinkRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateVpcLinkRequest#builder()}
     * </p>
     *
     * @param updateVpcLinkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkRequest.Builder} to create a request.
     *        Updates an existing VpcLink of a specified identifier.
     * @return A Java Future containing the result of the UpdateVpcLink operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The submitted request is not valid, for example, the input is incomplete or
     *         incorrect. See the accompanying error message for details.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>LimitExceededException The request exceeded the rate limit. Retry after the specified time period.</li>
     *         <li>NotFoundException The requested resource is not found. Make sure that the request URI is correct.</li>
     *         <li>UnauthorizedException The request is denied because the caller has insufficient permissions.</li>
     *         <li>TooManyRequestsException The request has reached its throttling limit. Retry after the specified time
     *         period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApiGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ApiGatewayAsyncClient.UpdateVpcLink
     */
    default CompletableFuture<UpdateVpcLinkResponse> updateVpcLink(Consumer<UpdateVpcLinkRequest.Builder> updateVpcLinkRequest) {
        return updateVpcLink(UpdateVpcLinkRequest.builder().applyMutation(updateVpcLinkRequest).build());
    }

    @Override
    default ApiGatewayServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ApiGatewayAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ApiGatewayAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ApiGatewayAsyncClient}.
     */
    static ApiGatewayAsyncClientBuilder builder() {
        return new DefaultApiGatewayAsyncClientBuilder();
    }
}
